/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.lists;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.RecordList;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class LeafList
extends RecordList {
    @Override
    public void add(EquivRecord r) {
        this.error(!r.isLeaf(), "EquivList only allows leaves");
        super.add(r);
    }

    public void sortByIncreasingSize() {
        Collections.sort(this.content, new SizeCompare());
    }

    public String sizeInfoString() {
        StringBuffer max = new StringBuffer(" offspring max sizes:");
        StringBuffer diff = new StringBuffer(" offspring size differences: ");
        boolean matchOK = true;
        Iterator<EquivRecord> it = this.iterator();
        while (it.hasNext()) {
            EquivRecord g2 = it.next();
            max.append(" " + g2.maxSize());
            diff.append(" " + g2.maxSizeDiff());
            if (g2.maxSizeDiff() <= 0) continue;
            matchOK = false;
        }
        if (matchOK) {
            return max.toString();
        }
        return String.valueOf(max) + "\n" + String.valueOf(diff) + "\n WARNING: Mismatched sizes";
    }

    public LeafList selectActive(NccGlobals globals) {
        LeafList out = new LeafList();
        Iterator<EquivRecord> it = this.iterator();
        while (it.hasNext()) {
            EquivRecord er = it.next();
            if (!er.isActive()) continue;
            out.add(er);
        }
        globals.status2(" selectActive found " + out.size() + " active leaf records");
        return out;
    }

    public LeafList selectMatched(NccGlobals globals) {
        LeafList out = new LeafList();
        Iterator<EquivRecord> it = this.iterator();
        while (it.hasNext()) {
            EquivRecord er = it.next();
            if (!er.isMatched()) continue;
            out.add(er);
        }
        globals.status2(" selectMatched found " + out.size() + " matched leaf records");
        return out;
    }

    private static class SizeCompare
    implements Comparator<EquivRecord> {
        private SizeCompare() {
        }

        @Override
        public int compare(EquivRecord s1, EquivRecord s2) {
            return s1.maxSize() - s2.maxSize();
        }
    }
}

