/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.technology.Technology;
import com.sun.electric.tool.ncc.NccPreferences;
import com.sun.electric.tool.user.User;
import java.io.Serializable;

public class NccOptions
implements Serializable {
    static final long serialVersionUID = 0L;
    public static final int HIER_EACH_CELL = 0;
    public static final int FLAT_EACH_CELL = 1;
    public static final int FLAT_TOP_CELL = 2;
    public static final int LIST_ANNOTATIONS = 3;
    public int operation = 0;
    Technology defaultLayoutTech = null;
    public boolean checkSizes = false;
    public boolean checkResistors = false;
    public double absoluteSizeTolerance;
    public double relativeSizeTolerance;
    public boolean skipPassed = false;
    public int howMuchStatus = 0;
    public boolean haltAfterFirstMismatch = true;
    public int maxMismatchedEquivRecsToPrint = 10;
    public int maxMatchedEquivRecsToPrint = 10;
    public int maxEquivRecMembersToPrint = 10;
    public boolean oneNamePerPort = true;
    public boolean checkBody = false;

    public NccOptions() {
    }

    public NccOptions(NccOptions o2) {
        this.operation = o2.operation;
        this.checkSizes = o2.checkSizes;
        this.checkResistors = o2.checkResistors;
        this.absoluteSizeTolerance = o2.absoluteSizeTolerance;
        this.relativeSizeTolerance = o2.relativeSizeTolerance;
        this.skipPassed = o2.skipPassed;
        this.howMuchStatus = o2.howMuchStatus;
        this.haltAfterFirstMismatch = o2.haltAfterFirstMismatch;
        this.maxMismatchedEquivRecsToPrint = o2.maxMismatchedEquivRecsToPrint;
        this.maxMatchedEquivRecsToPrint = o2.maxMatchedEquivRecsToPrint;
        this.maxEquivRecMembersToPrint = o2.maxEquivRecMembersToPrint;
        this.oneNamePerPort = o2.oneNamePerPort;
        this.checkBody = o2.checkBody;
        this.defaultLayoutTech = o2.defaultLayoutTech;
    }

    public static NccOptions getOptionsFromNccPreferences() {
        NccOptions options = new NccOptions();
        options.operation = NccPreferences.getOperation();
        options.checkSizes = NccPreferences.getCheckSizes();
        options.checkResistors = NccPreferences.getCheckResistors();
        options.relativeSizeTolerance = NccPreferences.getRelativeSizeTolerance() / 100.0;
        options.absoluteSizeTolerance = NccPreferences.getAbsoluteSizeTolerance();
        options.checkBody = NccPreferences.getCheckBody();
        options.skipPassed = NccPreferences.getSkipPassed();
        options.howMuchStatus = NccPreferences.getHowMuchStatus();
        options.haltAfterFirstMismatch = NccPreferences.getHaltAfterFirstMismatch();
        options.maxMismatchedEquivRecsToPrint = NccPreferences.getMaxMismatchedClasses();
        options.maxMatchedEquivRecsToPrint = NccPreferences.getMaxMatchedClasses();
        options.maxEquivRecMembersToPrint = NccPreferences.getMaxClassMembers();
        options.defaultLayoutTech = User.getSchematicTechnology();
        return options;
    }
}

