/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.logicaleffort.Instance;
import com.sun.electric.tool.logicaleffort.LENetlister1;
import com.sun.electric.tool.logicaleffort.LETool;
import com.sun.electric.tool.logicaleffort.Net;
import com.sun.electric.tool.logicaleffort.Pin;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.util.ElapseTimer;
import com.sun.electric.util.TextUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LESizer {
    private PrintStream out;
    private Job job;
    private LENetlister1 netlist;
    private ErrorLogger errorLogger;

    protected LESizer(Alg alg, LENetlister1 netlist, Job job, ErrorLogger errorLogger) {
        this.netlist = netlist;
        this.job = job;
        this.errorLogger = errorLogger;
        this.out = new PrintStream(System.out);
    }

    protected boolean optimizeLoops(float maxDeltaX, int N, boolean verbose, float alpha, float keeperRatio) {
        float currentLoopDeltaX;
        float lastLoopDeltaX = currentLoopDeltaX = maxDeltaX + 1.0f;
        int divergingIters = 0;
        ElapseTimer timer = ElapseTimer.createInstance();
        int loopcount = 0;
        while (currentLoopDeltaX > maxDeltaX && loopcount < N) {
            if (((LETool.AnalyzeCell)this.job).checkAbort(null)) {
                return false;
            }
            currentLoopDeltaX = 0.0f;
            timer.start();
            System.out.print("  Iteration " + loopcount);
            if (verbose) {
                System.out.println(":");
            }
            for (Instance instance : this.netlist.getAllInstances().values()) {
                float deltaX;
                float currentX;
                NodeInst ni;
                ArrayList<Pin> outputPins;
                String instanceName = instance.getName();
                if (!instance.isLeGate() || (outputPins = instance.getOutputPins()).size() != 1) continue;
                Pin outputPin = outputPins.get(0);
                Net net = outputPin.getNet();
                ArrayList<Pin> netpins = net.getAllPins();
                ArrayList<Instance> drivers = new ArrayList<Instance>();
                ArrayList<Instance> arrayedDrivers = new ArrayList<Instance>();
                for (Pin pin : netpins) {
                    if (pin.getDir() != Pin.Dir.OUTPUT) continue;
                    Instance inst = pin.getInstance();
                    if (inst.getType() == instance.getType() && inst.getParallelGroup() == instance.getParallelGroup()) {
                        drivers.add(inst);
                        if (inst.getParallelGroup() > 0 && loopcount == 0 && inst.getLeSU() != instance.getLeSU()) {
                            String msg2 = "\nError: LEGATE \"" + inst.getName() + "\" drives in parallel with \"" + instance.getName() + "\" but has a different step-up";
                            System.out.println(msg2);
                            NodeInst nodeInst = inst.getNodable().getNodeInst();
                            if (nodeInst != null) {
                                this.errorLogger.logError(msg2, nodeInst, nodeInst.getParent(), inst.getContext(), 0);
                            }
                        }
                    }
                    if (inst.getNodable().getNodeInst() != instance.getNodable().getNodeInst() || inst.getContext() != instance.getContext()) continue;
                    arrayedDrivers.add(inst);
                }
                float newX = 0.0f;
                if (instance.getType() == Instance.Type.LEKEEPER) {
                    HashMap<String, ArrayList<Instance>> drivingGroups = new HashMap<String, ArrayList<Instance>>();
                    float smallestX = 0.0f;
                    for (Pin pin : netpins) {
                        ArrayList<Instance> groupList;
                        Instance inst;
                        if (pin.getDir() != Pin.Dir.OUTPUT || (inst = pin.getInstance()).getType() != Instance.Type.LEGATE) continue;
                        int i2 = inst.getParallelGroup();
                        Integer integer = i2;
                        if (i2 <= 0) {
                            if (smallestX == 0.0f) {
                                smallestX = inst.getLeX();
                            }
                            if (inst.getLeX() < smallestX) {
                                smallestX = inst.getLeX();
                            }
                        }
                        if ((groupList = (ArrayList<Instance>)drivingGroups.get(integer.toString())) == null) {
                            groupList = new ArrayList<Instance>();
                            drivingGroups.put(integer.toString(), groupList);
                        }
                        groupList.add(inst);
                    }
                    Set keys = drivingGroups.keySet();
                    for (String str : keys) {
                        List groupList = (List)drivingGroups.get(str);
                        if (groupList == null) continue;
                        float sizeX = 0.0f;
                        for (Instance inst : groupList) {
                            sizeX += inst.getLeX();
                        }
                        if (smallestX == 0.0f) {
                            smallestX = sizeX;
                        }
                        if (!(sizeX < smallestX)) continue;
                        smallestX = sizeX;
                    }
                    if (!keys.iterator().hasNext() && loopcount == 0) {
                        String string = "\nError: LEKEEPER \"" + instance.getName() + "\" does not fight against any drivers";
                        System.out.println(string);
                        ni = instance.getNodable().getNodeInst();
                        if (ni != null) {
                            this.errorLogger.logError(string, ni, ni.getParent(), instance.getContext(), 0);
                        }
                    }
                    newX = instance.getParallelGroup() <= 0 ? smallestX * this.netlist.getKeeperRatio() / (float)arrayedDrivers.size() : smallestX * this.netlist.getKeeperRatio() / (float)drivers.size();
                }
                if (instance.getType() == Instance.Type.LEGATE) {
                    float totalcap = 0.0f;
                    Iterator<Pin> netpinsIter = netpins.iterator();
                    int numLoads = 0;
                    while (netpinsIter.hasNext()) {
                        Pin pin = netpinsIter.next();
                        Instance netpinInstance = pin.getInstance();
                        float load = netpinInstance.getLeX() * pin.getLE() * (float)netpinInstance.getMfactor();
                        if (pin.getDir() == Pin.Dir.OUTPUT) {
                            load *= alpha;
                        }
                        totalcap += load;
                        if (netpinInstance == instance) continue;
                        ++numLoads;
                    }
                    if (numLoads == 0 && loopcount == 0) {
                        String string = "\nError: LEGATE \"" + instance.getName() + "\" has no loads: will be ignored";
                        System.out.println(string);
                        ni = instance.getNodable().getNodeInst();
                        if (ni != null) {
                            this.errorLogger.logError(string, ni, ni.getParent(), instance.getContext(), 1);
                        }
                    }
                    if (numLoads == 0) continue;
                    newX = instance.getParallelGroup() <= 0 ? totalcap / instance.getLeSU() / (float)arrayedDrivers.size() : totalcap / instance.getLeSU() / (float)drivers.size();
                    newX /= (float)instance.getMfactor();
                }
                if ((currentX = instance.getLeX()) == 0.0f && newX == 0.0f) {
                    deltaX = 0.0f;
                } else {
                    if (currentX == 0.0f) {
                        currentX = 0.001f;
                    }
                    deltaX = Math.abs((newX - currentX) / currentX);
                }
                float f2 = currentLoopDeltaX = deltaX > currentLoopDeltaX ? deltaX : currentLoopDeltaX;
                if (verbose) {
                    this.out.println("Optimized " + instanceName + ": size:  " + TextUtils.formatDouble(instance.getLeX(), 3) + "x ==> " + TextUtils.formatDouble(newX, 3) + "x");
                }
                instance.setLeX(newX);
            }
            timer.end();
            System.out.println("  ...done (" + String.valueOf(timer) + "), delta: " + currentLoopDeltaX);
            if (verbose) {
                System.out.println("-----------------------------------");
            }
            ++loopcount;
            if (currentLoopDeltaX >= lastLoopDeltaX) {
                if (divergingIters > 2) {
                    System.out.println("  Sizing diverging, aborting");
                    return false;
                }
                ++divergingIters;
            }
            lastLoopDeltaX = currentLoopDeltaX;
        }
        return true;
    }

    protected List getEndNets() {
        Iterator<Net> netIter = this.netlist.getAllNets().values().iterator();
        while (netIter.hasNext()) {
            netIter.next();
        }
        return null;
    }

    protected void printDesign() {
        this.out.println("Instances in design are:");
        for (Instance instance : this.netlist.getAllInstances().values()) {
            String instanceName = instance.getName();
            this.out.println("\t" + instanceName + " ==> " + TextUtils.formatDouble(instance.getLeX(), 3) + "x");
            ArrayList<Pin> pins = instance.getAllPins();
            for (Pin pin : pins) {
                this.out.println("\t\t" + pin.getName() + " ==> " + pin.getNetName());
            }
        }
    }

    protected int printDesignSizes(String filename) {
        try {
            FileWriter fileWriter = new FileWriter(filename);
            for (Instance instance : this.netlist.getAllInstances().values()) {
                String instanceName = instance.getName();
                float leX = instance.getLeX();
                fileWriter.write(instanceName + " " + leX + "\n");
                fileWriter.flush();
            }
            fileWriter.close();
        }
        catch (IOException e2) {
            this.out.println("Writing to file " + filename + ": " + e2.getMessage());
            return 1;
        }
        return 0;
    }

    protected int printDesignSkill(String filename, String libname, String cellname) {
        return 0;
    }

    protected void testcoverage() {
    }

    public static void test1() {
        System.out.println("Running GASP test circuit");
        System.out.println("=========================");
        float su = 4.0f;
        LENetlister1 netlist = new LENetlister1(null, null);
        Pin pin_a = new Pin("A", Pin.Dir.INPUT, 1.0f, "nand1_out");
        Pin pin_y = new Pin("Y", Pin.Dir.OUTPUT, 1.0f, "inv1_out");
        ArrayList<Pin> pins = new ArrayList<Pin>();
        pins.add(pin_a);
        pins.add(pin_y);
        netlist.addInstance("inv1", Instance.Type.LEGATE, su, 1.0f, pins, null);
        pin_a = new Pin("A", Pin.Dir.INPUT, 1.0f, "pu_out");
        pin_y = new Pin("Y", Pin.Dir.OUTPUT, 1.0f, "inv2_out");
        pins = new ArrayList();
        pins.add(pin_a);
        pins.add(pin_y);
        netlist.addInstance("inv2", Instance.Type.LEGATE, su, 1.0f, pins, null);
        pin_a = new Pin("A", Pin.Dir.INPUT, 1.0f, "nand1_out");
        pin_y = new Pin("Y", Pin.Dir.OUTPUT, 1.0f, "inv3_out");
        pins = new ArrayList();
        pins.add(pin_a);
        pins.add(pin_y);
        netlist.addInstance("inv3", Instance.Type.LEGATE, su, 1.0f, pins, null);
        pin_a = new Pin("A", Pin.Dir.INPUT, 1.333f, "inv2_out");
        Pin pin_b = new Pin("B", Pin.Dir.INPUT, 1.333f, "pd_out");
        Pin pin_y2 = new Pin("Y", Pin.Dir.OUTPUT, 2.0f, "nand1_out");
        ArrayList<Pin> pins2 = new ArrayList<Pin>();
        pins2.add(pin_a);
        pins2.add(pin_b);
        pins2.add(pin_y2);
        netlist.addInstance("nand1", Instance.Type.LEGATE, su, 1.0f, pins2, null);
        Pin pin_g = new Pin("G", Pin.Dir.INPUT, 0.667f, "nand1_out");
        Pin pin_d = new Pin("D", Pin.Dir.OUTPUT, 0.667f, "pu_out");
        pins = new ArrayList();
        pins.add(pin_g);
        pins.add(pin_d);
        netlist.addInstance("pu", Instance.Type.LEGATE, su, 1.0f, pins, null);
        pin_g = new Pin("G", Pin.Dir.INPUT, 0.333f, "inv3_out");
        pin_d = new Pin("D", Pin.Dir.OUTPUT, 0.333f, "pd_out");
        pins = new ArrayList();
        pins.add(pin_g);
        pins.add(pin_d);
        netlist.addInstance("pd", Instance.Type.LEGATE, su, 1.0f, pins, null);
        Pin pin_c = new Pin("C", Pin.Dir.INPUT, 1.0f, "pd_out");
        ArrayList<Pin> pins3 = new ArrayList<Pin>();
        pins3.add(pin_c);
        netlist.addInstance("cap1", Instance.Type.LOAD, su, 0.0f, pins3, null);
        pin_c = new Pin("C", Pin.Dir.INPUT, 1.0f, "pu_out");
        pins3 = new ArrayList();
        pins3.add(pin_c);
        netlist.addInstance("cap2", Instance.Type.LOAD, su, 0.0f, pins3, null);
        pin_c = new Pin("C", Pin.Dir.INPUT, 1.0f, "inv1_out");
        pins3 = new ArrayList();
        pins3.add(pin_c);
        netlist.addInstance("cap3", Instance.Type.LOAD, su, 100.0f, pins3, null);
        netlist.getSizer().printDesign();
        netlist.getSizer().optimizeLoops(0.01f, 30, true, 0.7f, 0.1f);
        System.out.println("After optimization:");
        netlist.getSizer().printDesign();
    }

    public static enum Alg {
        EQUALGATEDELAYS("Equal Gate Delays"),
        PATHDELAY("Path Delay");

        private final String name;

        private Alg(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

