/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.lang;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;

public class EvalJython {
    private static boolean jythonChecked = false;
    private static boolean jythonInited = false;
    private static Class<?> jythonClass;
    private static Object jythonInterpreterObject;
    private static Method jythonExecMethod;

    public static boolean hasJython() {
        if (!jythonChecked) {
            jythonChecked = true;
            jythonClass = Resources.getJythonClass("PythonInterpreter");
            if (jythonClass == null) {
                TextUtils.recordMissingComponent("Jython");
            }
        }
        return jythonClass != null;
    }

    private static void initJython() {
        if (!EvalJython.hasJython()) {
            return;
        }
        if (jythonInited) {
            return;
        }
        try {
            Constructor<?> instance = jythonClass.getDeclaredConstructor(new Class[0]);
            jythonInterpreterObject = instance.newInstance(new Object[0]);
            jythonExecMethod = jythonClass.getMethod("exec", String.class);
            jythonExecMethod.invoke(jythonInterpreterObject, "import sys");
        }
        catch (Exception e2) {
            jythonClass = null;
        }
        jythonInited = true;
    }

    public static void execJython(String code) {
        try {
            jythonExecMethod.invoke(jythonInterpreterObject, code);
            return;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Throwable ourCause = e2.getCause();
            if (ourCause != null) {
                System.out.println("Jython: " + String.valueOf(ourCause));
            } else {
                System.out.println("Jython error");
            }
            return;
        }
    }

    public static void runScript(String fileName) {
        new RunJythonScriptJob(fileName).startJob();
    }

    public static void runScriptNoJob(String fileName) {
        URL url = TextUtils.makeURLToFile(fileName);
        try {
            String buf;
            URLConnection urlCon = url.openConnection();
            InputStreamReader is = new InputStreamReader(urlCon.getInputStream());
            LineNumberReader lineReader = new LineNumberReader(is);
            StringBuffer sb = new StringBuffer();
            String sep = System.getProperty("line.separator");
            while ((buf = lineReader.readLine()) != null) {
                sb.append(buf);
                sb.append(sep);
            }
            lineReader.close();
            EvalJython.initJython();
            EvalJython.execJython(sb.toString());
        }
        catch (IOException e2) {
            System.out.println("Error reading " + fileName);
        }
    }

    public static EditingPreferences getEditingPreferences() {
        return Job.getRunningJob().getEditingPreferences();
    }

    public static void displayCell(Cell cell) {
        Job curJob = Job.getRunningJob();
        if (curJob instanceof RunJythonScriptJob) {
            ((RunJythonScriptJob)curJob).displayCell(cell);
        }
    }

    public static void setVarInJob(CellId cellId, int nodeId, Variable.Key key, Object newVal, TextDescriptor td) {
        new SetVarJob(cellId, nodeId, key, newVal, td);
    }

    private static class RunJythonScriptJob
    extends Job {
        private String script;
        private Cell cellToDisplay;

        public RunJythonScriptJob(String script) {
            super("Jython script: " + script, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.script = script;
            this.cellToDisplay = null;
        }

        @Override
        public boolean doIt() throws JobException {
            EvalJython.runScriptNoJob(this.script);
            return true;
        }

        private void displayCell(Cell cell) {
            if (this.cellToDisplay != null) {
                return;
            }
            this.cellToDisplay = cell;
            this.fieldVariableChanged("cellToDisplay");
        }

        @Override
        public void terminateOK() {
            if (this.cellToDisplay != null) {
                Job.getUserInterface().displayCell(this.cellToDisplay);
            }
        }
    }

    private static class SetVarJob
    extends Job {
        private CellId cellId;
        private int nodeId;
        private Variable.Key key;
        private Object newVal;
        private TextDescriptor td;

        protected SetVarJob(CellId cellId, int nodeId, Variable.Key key, Object newVal, TextDescriptor td) {
            super("Add Variable", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cellId = cellId;
            this.nodeId = nodeId;
            this.key = key;
            this.newVal = newVal;
            this.td = td;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Cell c2 = Cell.inCurrentThread(this.cellId);
            NodeInst ni = c2.getNodeById(this.nodeId);
            ni.newVar(this.key, this.newVal, this.td);
            return true;
        }
    }
}

