/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.output.ELIB;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ReadableDump
extends ELIB {
    private int portProtoError;
    private LinkedHashMap<CellId, Integer> cellOrdering = new LinkedHashMap();
    private HashMap<ExportId, Integer> portMap;

    ReadableDump() {
        this.write6Compatible();
    }

    @Override
    boolean writeTheLibrary() throws IOException {
        this.portProtoError = 0;
        for (Object cellRevision : this.externalCells) {
            this.cellOrdering.put(((CellRevision)cellRevision).d.cellId, null);
        }
        for (Object cellRevision : this.localCells) {
            CellId cellId = ((CellRevision)cellRevision).d.cellId;
            if (this.cellOrdering.containsKey(cellId)) continue;
            this.textRecurse(this.theLibId, cellId);
        }
        int cellNumber = 0;
        for (Map.Entry entry : this.cellOrdering.entrySet()) {
            entry.setValue(cellNumber++);
            this.objInfo.put(entry.getKey(), (Integer)entry.getValue());
        }
        this.printWriter.println("****library: \"" + this.theLibId.libName + "\"");
        this.printWriter.println("version: " + Version.getVersion().toOldStyleString());
        this.printWriter.println("aids: " + this.toolCount);
        Iterator<Comparable> it = Tool.getTools();
        while (it.hasNext()) {
            Tool tool = it.next();
            if (!this.objInfo.containsKey(tool)) continue;
            this.printWriter.println("aidname: " + tool.getName());
            this.writeMeaningPrefs(tool);
        }
        this.printWriter.println("techcount: " + this.technologies.size());
        for (Technology technology : this.technologies) {
            this.printWriter.println("techname: " + technology.getTechName() + " lambda: " + this.gridCoordToElib(technology, 400.0));
            this.writeMeaningPrefs(technology);
        }
        it = View.getViews();
        while (it.hasNext()) {
            View view = (View)it.next();
            if (!this.objInfo.containsKey(view)) continue;
            this.printWriter.println("view: " + view.getFullName() + view.getAbbreviationExtension());
        }
        this.printWriter.println("cellcount: " + cellNumber);
        this.writeVariables(this.snapshot.getLib((LibId)this.theLibId).d);
        this.writeExternalCells();
        for (Map.Entry<CellId, Integer> entry : this.cellOrdering.entrySet()) {
            CellId cellId = entry.getKey();
            if (cellId.libId != this.theLibId) continue;
            CellBackup cellBackup = this.snapshot.getCell(cellId);
            CellRevision cellRevision = cellBackup.cellRevision;
            this.startCell(cellRevision, 0);
            int groupIndex = this.groupRenumber[this.snapshot.getCellGroupIndex(cellId)];
            this.printWriter.println("***cell: " + entry.getValue() + "/" + groupIndex);
            this.writeCellInfo(cellRevision);
            this.printWriter.println("userbits: " + (cellRevision.d.flags & 0xF00002));
            this.portMap = new HashMap();
            int portCount = 0;
            for (int exportIndex = 0; exportIndex < cellRevision.exports.size(); ++exportIndex) {
                ImmutableExport e3 = cellRevision.exports.get(exportIndex);
                this.portMap.put(e3.exportId, portCount++);
            }
            this.printWriter.println("nodes: " + cellRevision.nodes.size() + " arcs: " + cellRevision.arcs.size() + " porttypes: " + cellRevision.exports.size());
            this.writeVariables(cellRevision.d);
            this.writeNodes(cellBackup, 0);
            this.writeExports(cellRevision);
            this.writeArcs(cellRevision);
            this.printWriter.println("celldone: " + cellId.cellName.getName());
        }
        if (this.portProtoError != 0) {
            System.out.println("Warning: " + this.portProtoError + " export pointers point outside cell: not saved");
        }
        return false;
    }

    @Override
    void writeOrientation(int angle, int transpose) throws IOException {
        this.printWriter.println("rotation: " + angle + " transpose: " + transpose);
    }

    @Override
    void writeConnection(PortProtoId portId, int arcIndex, int connIndex) throws IOException {
        this.printWriter.println("*port: " + portId.getName(this.snapshot) + " arc: " + arcIndex);
    }

    @Override
    void writeReExport(ImmutableExport e2) throws IOException {
        Integer pIndex = this.portMap.get(e2.exportId);
        if (pIndex == null) {
            pIndex = -1;
        }
        this.printWriter.println("*port: " + e2.originalPortId.getName(this.snapshot) + " exported: " + pIndex);
    }

    private void textRecurse(LibId libId, CellId cellId) {
        for (ImmutableNodeInst n2 : this.snapshot.getCellRevision((CellId)cellId).nodes) {
            if (!(n2.protoId instanceof CellId)) continue;
            CellId subCellId = (CellId)n2.protoId;
            if (subCellId.libId != libId || this.cellOrdering.containsKey(subCellId)) continue;
            this.textRecurse(libId, subCellId);
        }
        this.cellOrdering.put(cellId, null);
    }

    @Override
    void writeVarValue(Object varObj) {
        StringBuffer infstr = new StringBuffer();
        if (varObj instanceof Object[]) {
            Object[] objArray = (Object[])varObj;
            int len = objArray.length;
            for (int i2 = 0; i2 < len; ++i2) {
                Object oneObj = objArray[i2];
                if (i2 == 0) {
                    infstr.append("[");
                } else {
                    infstr.append(",");
                }
                if (oneObj == null) continue;
                this.makeStringVar(infstr, oneObj);
            }
            infstr.append("]");
        } else {
            this.makeStringVar(infstr, varObj);
        }
        this.printWriter.println(infstr);
    }

    private void makeStringVar(StringBuffer infstr, Object obj) {
        if (obj instanceof String) {
            infstr.append("\"");
            infstr.append(this.convertString((String)obj));
            infstr.append("\"");
            return;
        }
        if (obj instanceof CodeExpression) {
            infstr.append("\"");
            infstr.append(this.convertString(((CodeExpression)obj).getExpr()));
            infstr.append("\"");
            return;
        }
        if (obj instanceof Double) {
            infstr.append(((Double)obj).floatValue());
            return;
        }
        if (obj instanceof Float) {
            infstr.append(((Float)obj).floatValue());
            return;
        }
        if (obj instanceof Long) {
            infstr.append(((Long)obj).intValue());
            return;
        }
        if (obj instanceof Integer) {
            infstr.append((Integer)obj);
            return;
        }
        if (obj instanceof Short) {
            infstr.append(((Short)obj).shortValue());
            return;
        }
        if (obj instanceof Byte) {
            infstr.append(((Byte)obj).byteValue());
            return;
        }
        if (obj instanceof Boolean) {
            infstr.append((Boolean)obj != false ? 1 : 0);
            return;
        }
        if (obj instanceof Tool) {
            Tool tool = (Tool)obj;
            infstr.append(tool.getName());
            return;
        }
        if (obj instanceof TechId) {
            TechId techId = (TechId)obj;
            infstr.append(techId.techName);
            return;
        }
        if (obj instanceof PrimitiveNodeId) {
            PrimitiveNodeId np = (PrimitiveNodeId)obj;
            infstr.append(np.fullName);
            return;
        }
        if (obj instanceof ArcProtoId) {
            ArcProtoId arcProtoId = (ArcProtoId)obj;
            infstr.append(arcProtoId.fullName);
            return;
        }
        if (obj instanceof LibId) {
            LibId libId = (LibId)obj;
            infstr.append("\"" + libId.libName + "\"");
            return;
        }
        if (obj instanceof CellId) {
            CellId cellId = (CellId)obj;
            Integer mi = this.cellOrdering.get(cellId);
            int cIndex = -1;
            if (mi != null) {
                cIndex = mi;
            }
            infstr.append(Integer.toString(cIndex));
            return;
        }
        if (obj instanceof ExportId) {
            ExportId exportId = (ExportId)obj;
            Integer portIndex = this.portMap.get(exportId);
            int cIndex = -1;
            if (portIndex == null) {
                ++this.portProtoError;
            } else {
                cIndex = portIndex;
            }
            infstr.append(Integer.toString(cIndex));
            return;
        }
        assert (false);
    }

    @Override
    void writeTextDescriptor(int varBits, int td0, int td1) throws IOException {
        if (varBits == -1) {
            this.printWriter.println("descript: " + td0 + "/" + td1);
            return;
        }
        if ((varBits & 0x80) != 0) {
            this.printWriter.print("(" + ((varBits & 0x1FFFFE00) >> 9) + ")");
        }
        this.printWriter.print("[0" + Integer.toOctalString(varBits) + ",");
        this.printWriter.print((String)(td0 != 0 ? "0" + Integer.toOctalString(td0) : "0"));
        this.printWriter.print("/");
        this.printWriter.print((String)(td1 != 0 ? "0" + Integer.toOctalString(td1) : "0"));
        this.printWriter.print("]: ");
    }

    @Override
    void writeObj(Object obj) throws IOException {
    }

    @Override
    void writeInt(String keyword2, int i2) throws IOException {
        if (keyword2 == null) {
            return;
        }
        this.printWriter.println(keyword2 + i2);
    }

    @Override
    void writeTxt(String txt) throws IOException {
        this.printWriter.println(txt);
    }

    @Override
    void writeBigInteger(int i2) throws IOException {
    }

    @Override
    void writeVariableName(String name) throws IOException {
        this.printName(name);
    }

    private String convertString(String str) {
        StringBuffer infstr = new StringBuffer();
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char ch = str.charAt(i2);
            if (ch == '[' || ch == ']' || ch == '\"' || ch == '^') {
                infstr.append('^');
            }
            infstr.append(ch);
        }
        return infstr.toString();
    }

    private void printName(String name) {
        int len = name.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char pt = name.charAt(i2);
            if (pt == '^' || pt == '[' || pt == '(' || pt == ':') {
                this.printWriter.print("^");
            }
            this.printWriter.print(pt);
        }
    }
}

