/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.output.PostScript;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.Orientation;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PostScriptColor {
    private static final int MAXLAYERS = 1000;
    private static final int TREETHRESHOLD = 500;
    private static final double SMALL_NUM = 1.0E-6;
    private static final String FONTNAME = "Helvetica";
    private double[] psBoundaries = new double[4];
    private List<PsCell> allCells;
    private LayerMap[] allLayers = new LayerMap[1000];
    private List<ArrayList<PsBox>> flattenedBoxes = new ArrayList<ArrayList<PsBox>>();
    private PxBoxQuadTree[] quadTrees = new PxBoxQuadTree[1000];
    private List<ArrayList<PsPoly>> flattenedPolys = new ArrayList<ArrayList<PsPoly>>();
    private int numLayers;
    private int totalCells = 0;
    private boolean curveWarning;
    private Set<Technology> techsSetup;
    private Map<Cell, PsCell> cellStructs;
    private PostScript psObject;

    private PostScriptColor(PostScript psObject) {
        this.psObject = psObject;
    }

    public static void psColorPlot(PostScript psObject, PostScript.PostScriptPreferences prefs, Cell cell, double pageWid, double pageHei, double pageMargin) {
        PostScriptColor psc = new PostScriptColor(psObject);
        psc.doPrinting(cell, prefs, pageWid, pageHei, pageMargin);
    }

    private void doPrinting(Cell cell, PostScript.PostScriptPreferences prefs, double pageWid, double pageHei, double pageMargin) {
        this.totalCells = 0;
        this.psBoundaries[0] = 1.073741824E9;
        this.psBoundaries[1] = 1.073741824E9;
        this.psBoundaries[2] = -1.073741824E9;
        this.psBoundaries[3] = -1.073741824E9;
        for (int i2 = 0; i2 < 1000; ++i2) {
            this.quadTrees[i2] = null;
        }
        this.numLayers = 0;
        this.techsSetup = new HashSet<Technology>();
        this.cellStructs = new HashMap<Cell, PsCell>();
        this.getLayerMap(Technology.getCurrent());
        this.curveWarning = false;
        this.allCells = new ArrayList<PsCell>();
        this.extractDatabase(cell, prefs);
        this.mergeBoxes();
        this.flatten();
        this.genOverlapShapesAfterFlattening();
        this.writePS(cell, prefs.printForPlotter, pageWid, pageHei, pageMargin, prefs.wnd);
    }

    private void getLayerMap(Technology tech) {
        Layer layer;
        int i2;
        if (this.techsSetup.contains(tech)) {
            return;
        }
        this.techsSetup.add(tech);
        int startLayer = this.numLayers;
        ArrayList<Layer> layerSorts = new ArrayList<Layer>();
        ArrayList<Layer> layerSorts1 = new ArrayList<Layer>();
        for (i2 = 0; i2 < tech.getNumLayers(); ++i2) {
            layer = tech.getLayer(i2);
            layerSorts.add(layer);
            layerSorts1.add(layer);
        }
        Layer.getLayersSortedByRule(layerSorts1, Layer.LayerSortingType.ByDepth);
        for (i2 = 0; i2 < layerSorts.size(); ++i2) {
            if (this.numLayers >= 1000) {
                System.out.println("More than 1000 layers");
                break;
            }
            layer = (Layer)layerSorts.get(i2);
            this.allLayers[this.numLayers] = new LayerMap();
            this.allLayers[this.numLayers].layer = layer;
            EGraphics graph = this.psObject.localPrefs.gp.getGraphics(layer);
            this.allLayers[this.numLayers].opacity = graph.getOpacity();
            this.allLayers[this.numLayers].foreground = graph.getForeground();
            Color col = graph.getColor();
            this.allLayers[this.numLayers].r = (double)col.getRed() / 255.0;
            this.allLayers[this.numLayers].g = (double)col.getGreen() / 255.0;
            this.allLayers[this.numLayers].b = (double)col.getBlue() / 255.0;
            this.allLayers[this.numLayers].mix1 = -1;
            this.allLayers[this.numLayers].mix2 = -1;
            if (this.allLayers[this.numLayers].opacity < 1.0) {
                int curLayer = this.numLayers;
                for (int k2 = startLayer; k2 < curLayer; ++k2) {
                    if (!this.allLayers[k2].foreground) continue;
                    this.allLayers[++this.numLayers] = new LayerMap();
                    this.allLayers[this.numLayers].opacity = 1.0;
                    this.allLayers[this.numLayers].layer = null;
                    this.allLayers[this.numLayers].foreground = true;
                    this.allLayers[this.numLayers].r = this.allLayers[curLayer].r * this.allLayers[curLayer].opacity + this.allLayers[k2].r * (1.0 - this.allLayers[curLayer].opacity);
                    this.allLayers[this.numLayers].g = this.allLayers[curLayer].g * this.allLayers[curLayer].opacity + this.allLayers[k2].g * (1.0 - this.allLayers[curLayer].opacity);
                    this.allLayers[this.numLayers].b = this.allLayers[curLayer].b * this.allLayers[curLayer].opacity + this.allLayers[k2].b * (1.0 - this.allLayers[curLayer].opacity);
                    this.allLayers[this.numLayers].mix1 = k2;
                    this.allLayers[this.numLayers].mix2 = curLayer;
                }
            }
            ++this.numLayers;
        }
    }

    private void extractDatabase(Cell cell, PostScript.PostScriptPreferences prefs) {
        int i2;
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            Cell subCell;
            NodeInst ni = it.next();
            if (!ni.isCellInstance() || !prefs.expansionState.isExpanded(ni) || this.cellStructs.get(subCell = (Cell)ni.getProto()) != null) continue;
            this.extractDatabase(subCell, prefs);
        }
        PsCell curCell = new PsCell();
        curCell.boxes = new ArrayList<PsBox>();
        curCell.polys = new ArrayList<PsPoly>();
        curCell.labels = new ArrayList<PsLabel>();
        curCell.inst = new ArrayList<PsCellInst>();
        ++this.totalCells;
        this.allCells.add(curCell);
        this.cellStructs.put(cell, curCell);
        Iterator<ElectricObject> it2 = cell.getNodes();
        while (it2.hasNext()) {
            NodeInst ni = it2.next();
            NodeProto np = ni.getProto();
            if (ni.isCellInstance()) {
                if (!prefs.expansionState.isExpanded(ni)) {
                    for (i2 = 0; i2 < this.numLayers && (this.allLayers[i2].r != 0.0 || this.allLayers[i2].g != 0.0 || this.allLayers[i2].b != 0.0 || this.allLayers[i2].opacity != 1.0); ++i2) {
                    }
                    if (i2 >= this.numLayers) continue;
                    ERectangle niBounds = ni.getBounds();
                    PsBox curBox = new PsBox();
                    curBox.layer = i2;
                    curBox.visible = true;
                    curBox.pos[0] = 1.0;
                    curBox.pos[1] = ((RectangularShape)niBounds).getHeight();
                    curBox.pos[2] = ((RectangularShape)niBounds).getMinX();
                    curBox.pos[3] = ((RectangularShape)niBounds).getMinY();
                    curCell.boxes.add(curBox);
                    curBox = new PsBox();
                    curBox.layer = i2;
                    curBox.visible = true;
                    curBox.pos[0] = ((RectangularShape)niBounds).getWidth();
                    curBox.pos[1] = 1.0;
                    curBox.pos[2] = ((RectangularShape)niBounds).getMinX();
                    curBox.pos[3] = ((RectangularShape)niBounds).getMinY();
                    curCell.boxes.add(curBox);
                    curBox = new PsBox();
                    curBox.layer = i2;
                    curBox.visible = true;
                    curBox.pos[0] = 1.0;
                    curBox.pos[1] = ((RectangularShape)niBounds).getHeight();
                    curBox.pos[2] = ((RectangularShape)niBounds).getMaxX();
                    curBox.pos[3] = ((RectangularShape)niBounds).getMinY();
                    curCell.boxes.add(curBox);
                    curBox = new PsBox();
                    curBox.layer = i2;
                    curBox.visible = true;
                    curBox.pos[0] = ((RectangularShape)niBounds).getWidth();
                    curBox.pos[1] = 1.0;
                    curBox.pos[2] = ((RectangularShape)niBounds).getMinX();
                    curBox.pos[3] = ((RectangularShape)niBounds).getMaxY();
                    curCell.boxes.add(curBox);
                    PsLabel curLabel = new PsLabel();
                    curLabel.label = ni.getProto().describe(false);
                    curLabel.pos[0] = ((RectangularShape)niBounds).getMinX();
                    curLabel.pos[1] = ((RectangularShape)niBounds).getMaxX();
                    curLabel.pos[2] = ((RectangularShape)niBounds).getMinY();
                    curLabel.pos[3] = ((RectangularShape)niBounds).getMaxY();
                    curLabel.style = Poly.Type.TEXTBOX;
                    curLabel.descript = ni.getTextDescriptor(NodeInst.NODE_NAME);
                    curCell.labels.add(curLabel);
                    continue;
                }
                Cell npCell = (Cell)np;
                PsCell subCell = this.cellStructs.get(npCell);
                PsCellInst curInst = new PsCellInst();
                curInst.inst = subCell;
                this.newIdentityMatrix(curInst.transform);
                double[] transT = new double[9];
                this.newIdentityMatrix(transT);
                ERectangle cellBounds = npCell.getBounds();
                transT[6] = transT[6] - ((RectangularShape)cellBounds).getCenterX();
                transT[7] = transT[7] - ((RectangularShape)cellBounds).getCenterY();
                this.matrixMul(curInst.transform, curInst.transform, transT);
                double[] transR = new double[9];
                this.newIdentityMatrix(transR);
                Orientation o2 = ni.getOrient();
                double rotation = (double)o2.getCAngle() / 1800.0 * Math.PI;
                transR[0] = Math.cos(rotation);
                if (Math.abs(transR[0]) < 1.0E-6) {
                    transR[0] = 0.0;
                }
                transR[1] = Math.sin(rotation);
                if (Math.abs(transR[1]) < 1.0E-6) {
                    transR[1] = 0.0;
                }
                transR[3] = -Math.sin(rotation);
                if (Math.abs(transR[3]) < 1.0E-6) {
                    transR[3] = 0.0;
                }
                transR[4] = Math.cos(rotation);
                if (Math.abs(transR[4]) < 1.0E-6) {
                    transR[4] = 0.0;
                }
                this.matrixMul(curInst.transform, curInst.transform, transR);
                if (o2.isCTranspose()) {
                    this.newIdentityMatrix(transR);
                    transR[0] = 0.0;
                    transR[4] = 0.0;
                    transR[1] = -1.0;
                    transR[3] = -1.0;
                    this.matrixMul(curInst.transform, curInst.transform, transR);
                }
                this.newIdentityMatrix(transT);
                transT[6] = ni.getAnchorCenterX();
                transT[7] = ni.getAnchorCenterY();
                this.matrixMul(curInst.transform, curInst.transform, transT);
                curCell.inst.add(curInst);
                continue;
            }
            FixpTransform trans = ni.rotateOut();
            Poly[] polys = np.getTechnology().getShapeOfNode(ni);
            for (int i3 = 0; i3 < polys.length; ++i3) {
                Poly poly = polys[i3];
                poly.transform(trans);
                this.plotPolygon(poly, curCell);
            }
        }
        it2 = cell.getArcs();
        while (it2.hasNext()) {
            ArcInst ai = (ArcInst)it2.next();
            Poly[] polys = ai.getProto().getTechnology().getShapeOfArc(ai);
            for (i2 = 0; i2 < polys.length; ++i2) {
                Poly poly = polys[i2];
                this.plotPolygon(poly, curCell);
            }
        }
        it2 = cell.getExports();
        while (it2.hasNext()) {
            Export pp = (Export)it2.next();
            PsLabel curLabel = new PsLabel();
            curLabel.label = pp.getName();
            FixpRectangle bounds = pp.getPoly().getBounds2D();
            curLabel.pos[0] = curLabel.pos[1] = ((RectangularShape)bounds).getCenterX();
            curLabel.pos[2] = curLabel.pos[3] = ((RectangularShape)bounds).getCenterY();
            curLabel.style = Poly.Type.TEXTCENT;
            curLabel.descript = pp.getTextDescriptor(Export.EXPORT_NAME);
            curCell.labels.add(curLabel);
        }
    }

    private void plotPolygon(Poly poly, PsCell curCell) {
        int j2;
        Layer layer = poly.getLayer();
        Technology tech = layer.getTechnology();
        if (tech == null) {
            return;
        }
        this.getLayerMap(tech);
        for (j2 = 0; j2 < this.numLayers && this.allLayers[j2].layer != poly.getLayer(); ++j2) {
        }
        if (j2 >= this.numLayers) {
            return;
        }
        FixpRectangle polyBox = poly.getBox();
        Poly.Type style = poly.getStyle();
        PolyBase.Point[] points = poly.getPoints();
        if (style == Poly.Type.FILLED) {
            if (polyBox != null) {
                PsBox curBox = new PsBox();
                curBox.layer = j2;
                curBox.visible = true;
                curBox.pos[0] = ((RectangularShape)polyBox).getWidth();
                curBox.pos[1] = ((RectangularShape)polyBox).getHeight();
                curBox.pos[2] = ((RectangularShape)polyBox).getCenterX();
                curBox.pos[3] = ((RectangularShape)polyBox).getCenterY();
                curBox.pos[2] = curBox.pos[2] - curBox.pos[0] / 2.0;
                curBox.pos[3] = curBox.pos[3] - curBox.pos[1] / 2.0;
                curCell.boxes.add(curBox);
            } else {
                PsPoly curPoly = new PsPoly();
                curPoly.layer = j2;
                int numCoords = points.length * 2;
                curPoly.coords = new double[numCoords];
                for (int k2 = 0; k2 < numCoords; ++k2) {
                    curPoly.coords[k2] = k2 % 2 == 0 ? ((Point2D)points[k2 / 2]).getX() : ((Point2D)points[k2 / 2]).getY();
                }
                curCell.polys.add(curPoly);
            }
        } else if (style == Poly.Type.CLOSED || style == Poly.Type.OPENEDT1 || style == Poly.Type.OPENEDT2 || style == Poly.Type.OPENEDT3) {
            int k3;
            int type = 0;
            if (poly.getStyle() == Poly.Type.OPENEDT1) {
                type = 1;
            } else if (poly.getStyle() == Poly.Type.OPENEDT2) {
                type = 2;
            } else if (poly.getStyle() == Poly.Type.OPENEDT3) {
                type = 3;
            }
            for (k3 = 1; k3 < points.length; ++k3) {
                this.plotLine(j2, ((Point2D)points[k3 - 1]).getX(), ((Point2D)points[k3 - 1]).getY(), ((Point2D)points[k3]).getX(), ((Point2D)points[k3]).getY(), type, curCell);
            }
            if (poly.getStyle() == Poly.Type.CLOSED) {
                k3 = points.length - 1;
                this.plotLine(j2, ((Point2D)points[k3]).getX(), ((Point2D)points[k3]).getY(), ((Point2D)points[0]).getX(), ((Point2D)points[0]).getY(), type, curCell);
            }
        } else if (style == Poly.Type.VECTORS) {
            for (int k4 = 0; k4 < points.length; k4 += 2) {
                this.plotLine(j2, ((Point2D)points[k4]).getX(), ((Point2D)points[k4]).getY(), ((Point2D)points[k4 + 1]).getX(), ((Point2D)points[k4 + 1]).getY(), 0, curCell);
            }
        } else if (style == Poly.Type.CROSS || style == Poly.Type.BIGCROSS) {
            FixpRectangle bounds = poly.getBounds2D();
            double x = ((RectangularShape)bounds).getCenterX();
            double y = ((RectangularShape)bounds).getCenterY();
            this.plotLine(j2, x - 5.0, y, x + 5.0, y, 0, curCell);
            this.plotLine(j2, x, y + 5.0, x, y - 5.0, 0, curCell);
        } else if (style == Poly.Type.CROSSED) {
            FixpRectangle bounds = poly.getBounds2D();
            double lX = ((RectangularShape)bounds).getMinX();
            double hX = ((RectangularShape)bounds).getMaxX();
            double lY = ((RectangularShape)bounds).getMinY();
            double hY = ((RectangularShape)bounds).getMaxY();
            this.plotLine(j2, lX, lY, lX, hY, 0, curCell);
            this.plotLine(j2, lX, hY, hX, hY, 0, curCell);
            this.plotLine(j2, hX, hY, hX, lY, 0, curCell);
            this.plotLine(j2, hX, lY, lX, lY, 0, curCell);
            this.plotLine(j2, hX, hY, lX, lY, 0, curCell);
            this.plotLine(j2, hX, lY, lX, hY, 0, curCell);
        } else if (style == Poly.Type.DISC || style == Poly.Type.CIRCLE || style == Poly.Type.THICKCIRCLE || style == Poly.Type.CIRCLEARC || style == Poly.Type.THICKCIRCLEARC) {
            if (!this.curveWarning) {
                System.out.println("Warning: the 'merged color' PostScript option ignores curves.  Use other color options");
            }
            this.curveWarning = true;
        } else if (style.isText()) {
            PsLabel curLabel = new PsLabel();
            curLabel.label = poly.getString();
            FixpRectangle bounds = poly.getBounds2D();
            curLabel.pos[0] = ((RectangularShape)bounds).getMinX();
            curLabel.pos[1] = ((RectangularShape)bounds).getMaxX();
            curLabel.pos[2] = ((RectangularShape)bounds).getMinY();
            curLabel.pos[3] = ((RectangularShape)bounds).getMaxY();
            curLabel.style = poly.getStyle();
            curLabel.descript = poly.getTextDescriptor();
            curCell.labels.add(curLabel);
        }
    }

    private void plotLine(int layer, double fx, double fy, double tx, double ty, int texture, PsCell curCell) {
        PsPoly curPoly = new PsPoly();
        curPoly.layer = layer;
        curPoly.coords = new double[4];
        curPoly.coords[0] = fx;
        curPoly.coords[1] = fy;
        curPoly.coords[2] = tx;
        curPoly.coords[3] = ty;
        curCell.polys.add(curPoly);
    }

    private void genOverlapShapesAfterFlattening() {
        System.out.println("Generating overlap after flattening " + this.numLayers + " layers...");
        for (int i2 = 0; i2 < this.numLayers; ++i2) {
            if (this.allLayers[i2].mix1 == -1 || this.allLayers[i2].mix2 == -1) continue;
            PxBoxQuadTree q1 = this.makeBoxQuadTree(this.allLayers[i2].mix1);
            PxBoxQuadTree q2 = this.makeBoxQuadTree(this.allLayers[i2].mix2);
            this.coaf1(q1, q2, i2);
        }
    }

    private PxBoxQuadTree makeBoxQuadTree(int layer) {
        if (this.quadTrees[layer] != null) {
            return this.quadTrees[layer];
        }
        int numBoxes = 0;
        for (PsBox g2 : this.flattenedBoxes.get(layer)) {
            if (!g2.visible) continue;
            ++numBoxes;
        }
        this.quadTrees[layer] = new PxBoxQuadTree();
        this.quadTrees[layer].bounds[0] = this.psBoundaries[0];
        this.quadTrees[layer].bounds[1] = this.psBoundaries[1];
        this.quadTrees[layer].bounds[2] = this.psBoundaries[2];
        this.quadTrees[layer].bounds[3] = this.psBoundaries[3];
        this.quadTrees[layer].tl = null;
        this.quadTrees[layer].tr = null;
        this.quadTrees[layer].bl = null;
        this.quadTrees[layer].br = null;
        this.quadTrees[layer].numBoxes = numBoxes;
        this.quadTrees[layer].boxes = new PsBoxElement[numBoxes];
        this.quadTrees[layer].parent = null;
        this.quadTrees[layer].level = 0;
        int i2 = 0;
        for (PsBox g3 : this.flattenedBoxes.get(layer)) {
            if (!g3.visible) continue;
            this.quadTrees[layer].boxes[i2] = new PsBoxElement();
            this.quadTrees[layer].boxes[i2].pos[0] = g3.pos[0];
            this.quadTrees[layer].boxes[i2].pos[1] = g3.pos[1];
            this.quadTrees[layer].boxes[i2].pos[2] = g3.pos[2];
            this.quadTrees[layer].boxes[i2].pos[3] = g3.pos[3];
            this.quadTrees[layer].boxes[i2].layer = g3.layer;
            this.quadTrees[layer].boxes[i2].visible = true;
            ++i2;
        }
        if (numBoxes > 500) {
            this.recursivelyMakeBoxQuadTree(this.quadTrees[layer]);
        }
        return this.quadTrees[layer];
    }

    private void recursivelyMakeBoxQuadTree(PxBoxQuadTree q) {
        q.tl = new PxBoxQuadTree();
        q.tl.parent = q;
        q.tl.level = q.level * 10 + 1;
        q.tr = new PxBoxQuadTree();
        q.tr.parent = q;
        q.tr.level = q.level * 10 + 2;
        q.bl = new PxBoxQuadTree();
        q.bl.parent = q;
        q.bl.level = q.level * 10 + 3;
        q.br = new PxBoxQuadTree();
        q.br.parent = q;
        q.br.level = q.level * 10 + 4;
        this.splitTree(q.numBoxes, q.boxes, q.bl, q.bounds[0], q.bounds[1], (q.bounds[0] + q.bounds[2]) / 2.0, (q.bounds[1] + q.bounds[3]) / 2.0);
        this.splitTree(q.numBoxes, q.boxes, q.br, (q.bounds[0] + q.bounds[2]) / 2.0, q.bounds[1], q.bounds[2], (q.bounds[1] + q.bounds[3]) / 2.0);
        this.splitTree(q.numBoxes, q.boxes, q.tl, q.bounds[0], (q.bounds[1] + q.bounds[3]) / 2.0, (q.bounds[0] + q.bounds[2]) / 2.0, q.bounds[3]);
        this.splitTree(q.numBoxes, q.boxes, q.tr, (q.bounds[0] + q.bounds[2]) / 2.0, (q.bounds[1] + q.bounds[3]) / 2.0, q.bounds[2], q.bounds[3]);
        int numBoxes = 0;
        for (int i2 = 0; i2 < q.numBoxes; ++i2) {
            if (!q.boxes[i2].visible) continue;
            q.boxes[numBoxes].layer = q.boxes[i2].layer;
            q.boxes[numBoxes].visible = true;
            q.boxes[numBoxes].pos[0] = q.boxes[i2].pos[0];
            q.boxes[numBoxes].pos[1] = q.boxes[i2].pos[1];
            q.boxes[numBoxes].pos[2] = q.boxes[i2].pos[2];
            q.boxes[numBoxes].pos[3] = q.boxes[i2].pos[3];
            ++numBoxes;
        }
        q.numBoxes = numBoxes;
    }

    private void splitTree(int numBoxes, PsBoxElement[] boxes, PxBoxQuadTree q, double left, double bot, double right, double top) {
        int i2;
        int count = 0;
        for (i2 = 0; i2 < numBoxes; ++i2) {
            if (!boxes[i2].visible || !(boxes[i2].pos[2] >= left) || !(boxes[i2].pos[3] >= bot) || !(boxes[i2].pos[2] + boxes[i2].pos[0] <= right) || !(boxes[i2].pos[3] + boxes[i2].pos[1] <= top)) continue;
            ++count;
        }
        q.boxes = new PsBoxElement[count];
        count = 0;
        for (i2 = 0; i2 < numBoxes; ++i2) {
            if (!boxes[i2].visible || !(boxes[i2].pos[2] >= left) || !(boxes[i2].pos[3] >= bot) || !(boxes[i2].pos[2] + boxes[i2].pos[0] <= right) || !(boxes[i2].pos[3] + boxes[i2].pos[1] <= top)) continue;
            q.boxes[count] = new PsBoxElement();
            q.boxes[count].layer = boxes[i2].layer;
            q.boxes[count].visible = true;
            q.boxes[count].pos[0] = boxes[i2].pos[0];
            q.boxes[count].pos[1] = boxes[i2].pos[1];
            q.boxes[count].pos[2] = boxes[i2].pos[2];
            q.boxes[count].pos[3] = boxes[i2].pos[3];
            boxes[i2].visible = false;
            ++count;
        }
        q.numBoxes = count;
        q.bounds[0] = left;
        q.bounds[1] = bot;
        q.bounds[2] = right;
        q.bounds[3] = top;
        q.tl = null;
        q.tr = null;
        q.bl = null;
        q.br = null;
        if (count > 500) {
            this.recursivelyMakeBoxQuadTree(q);
        }
    }

    private void mergeBoxes() {
        System.out.println("Merging boxes for " + this.totalCells + " cells...");
        for (PsCell c2 : this.allCells) {
            boolean changed = false;
            do {
                changed = false;
                for (int i1 = 0; i1 < c2.boxes.size(); ++i1) {
                    PsBox b1 = c2.boxes.get(i1);
                    for (int i2 = i1 + 1; i2 < c2.boxes.size(); ++i2) {
                        PsBox b2 = c2.boxes.get(i2);
                        if (b1.layer != b2.layer || !b1.visible || !b2.visible || !this.mergeBoxPair(b1, b2)) continue;
                        changed = true;
                    }
                }
            } while (changed);
        }
    }

    private boolean mergeBoxPair(PsBox bx1, PsBox bx2) {
        double t0 = bx1.pos[3] + bx1.pos[1];
        double b0 = bx1.pos[3];
        double l0 = bx1.pos[2];
        double r0 = bx1.pos[2] + bx1.pos[0];
        double t1 = bx2.pos[3] + bx2.pos[1];
        double b1 = bx2.pos[3];
        double l1 = bx2.pos[2];
        double r1 = bx2.pos[2] + bx2.pos[0];
        if (t0 == t1 && b0 == b1 && Math.min(r0, r1) > Math.max(l0, l1)) {
            double l2 = Math.min(l0, l1);
            double r2 = Math.max(r0, r1);
            bx1.pos[0] = r2 - l2;
            bx1.pos[1] = t0 - b0;
            bx1.pos[2] = l2;
            bx1.pos[3] = b0;
            bx2.visible = false;
            return true;
        }
        if (r0 == r1 && l0 == l1 && Math.min(t0, t1) > Math.max(b0, b1)) {
            double b2 = Math.min(b0, b1);
            double t2 = Math.max(t0, t1);
            bx1.pos[0] = r0 - l0;
            bx1.pos[1] = t2 - b2;
            bx1.pos[2] = l0;
            bx1.pos[3] = b2;
            bx2.visible = false;
            return true;
        }
        if (r0 >= r1 && l0 <= l1 && t0 >= t1 && b0 <= b1) {
            bx2.visible = false;
            return true;
        }
        if (r1 >= r0 && l1 <= l0 && t1 >= t0 && b1 <= b0) {
            bx1.visible = false;
            return true;
        }
        return false;
    }

    private void coaf1(PxBoxQuadTree q1, PxBoxQuadTree q2, int layerNum) {
        this.coaf2(q1, q2, layerNum);
        if (q1.tl != null) {
            this.coaf3(q1.tl, q2, layerNum);
            this.coaf3(q1.tr, q2, layerNum);
            this.coaf3(q1.bl, q2, layerNum);
            this.coaf3(q1.br, q2, layerNum);
            if (q2.tl != null) {
                this.coaf1(q1.tl, q2.tl, layerNum);
                this.coaf1(q1.tr, q2.tr, layerNum);
                this.coaf1(q1.bl, q2.bl, layerNum);
                this.coaf1(q1.br, q2.br, layerNum);
            } else {
                this.coaf4(q1.tl, q2, layerNum, false);
                this.coaf4(q1.tr, q2, layerNum, false);
                this.coaf4(q1.bl, q2, layerNum, false);
                this.coaf4(q1.br, q2, layerNum, false);
            }
        }
    }

    private void coaf2(PxBoxQuadTree q1, PxBoxQuadTree q2, int layerNum) {
        this.checkOverlapAfterFlattening(q1, q2, layerNum);
        if (q2.tl != null) {
            this.coaf2(q1, q2.tl, layerNum);
            this.coaf2(q1, q2.tr, layerNum);
            this.coaf2(q1, q2.bl, layerNum);
            this.coaf2(q1, q2.br, layerNum);
        }
    }

    private void coaf3(PxBoxQuadTree q1, PxBoxQuadTree q2, int layerNum) {
        this.checkOverlapAfterFlattening(q1, q2, layerNum);
        if (q2.parent != null) {
            this.coaf3(q1, q2.parent, layerNum);
        }
    }

    private void coaf4(PxBoxQuadTree q1, PxBoxQuadTree q2, int layerNum, boolean check) {
        if (check) {
            this.coaf3(q1, q2, layerNum);
        }
        if (q1.tl != null) {
            this.coaf4(q1.tl, q2, layerNum, true);
            this.coaf4(q1.tr, q2, layerNum, true);
            this.coaf4(q1.bl, q2, layerNum, true);
            this.coaf4(q1.br, q2, layerNum, true);
        }
    }

    private void checkOverlapAfterFlattening(PxBoxQuadTree q1, PxBoxQuadTree q2, int layerNum) {
        double[] t = new double[3];
        double[] b2 = new double[3];
        double[] l2 = new double[3];
        double[] r = new double[3];
        if (q1.numBoxes != 0 && q2.numBoxes != 0) {
            for (int j2 = 0; j2 < q1.numBoxes; ++j2) {
                t[0] = q1.boxes[j2].pos[3] + q1.boxes[j2].pos[1];
                b2[0] = q1.boxes[j2].pos[3];
                l2[0] = q1.boxes[j2].pos[2];
                r[0] = q1.boxes[j2].pos[2] + q1.boxes[j2].pos[0];
                for (int k2 = 0; k2 < q2.numBoxes; ++k2) {
                    t[1] = q2.boxes[k2].pos[3] + q2.boxes[k2].pos[1];
                    b2[1] = q2.boxes[k2].pos[3];
                    l2[1] = q2.boxes[k2].pos[2];
                    r[1] = q2.boxes[k2].pos[2] + q2.boxes[k2].pos[0];
                    t[2] = t[0] < t[1] ? t[0] : t[1];
                    b2[2] = b2[0] > b2[1] ? b2[0] : b2[1];
                    l2[2] = l2[0] > l2[1] ? l2[0] : l2[1];
                    double d2 = r[2] = r[0] < r[1] ? r[0] : r[1];
                    if (!(t[2] > b2[2]) || !(r[2] > l2[2])) continue;
                    PsBox curBox = new PsBox();
                    curBox.layer = layerNum;
                    curBox.pos[0] = r[2] - l2[2];
                    curBox.pos[1] = t[2] - b2[2];
                    curBox.pos[2] = l2[2];
                    curBox.pos[3] = b2[2];
                    curBox.visible = true;
                    if (t[2] == t[0] && b2[2] == b2[0] && l2[2] == l2[0] && r[2] == r[0]) {
                        q1.boxes[j2].visible = false;
                    }
                    if (t[2] == t[1] && b2[2] == b2[1] && l2[2] == l2[1] && r[2] == r[1]) {
                        q2.boxes[k2].visible = false;
                    }
                    this.flattenedBoxes.get(layerNum).add(curBox);
                }
            }
        }
    }

    private void flatten() {
        double[] ident = new double[9];
        this.newIdentityMatrix(ident);
        for (int i2 = 0; i2 < this.numLayers; ++i2) {
            this.flattenedPolys.add(new ArrayList());
            this.flattenedBoxes.add(new ArrayList());
        }
        System.out.println("Flattening...");
        int lastCell = this.allCells.size() - 1;
        PsCell topCell = this.allCells.get(lastCell);
        this.recursiveFlatten(topCell, ident);
    }

    private void recursiveFlatten(PsCell topCell, double[] m2) {
        for (PsBox box : topCell.boxes) {
            if (!box.visible) continue;
            PsBox newBox = this.copyBox(box, m2);
            this.flattenedBoxes.get(newBox.layer).add(newBox);
        }
        for (PsPoly poly : topCell.polys) {
            PsPoly newPoly = this.copyPoly(poly, m2);
            this.flattenedPolys.get(newPoly.layer).add(newPoly);
        }
        double[] tm = new double[9];
        for (PsCellInst inst : topCell.inst) {
            this.matrixMul(tm, inst.transform, m2);
            this.recursiveFlatten(inst.inst, tm);
        }
    }

    private void writePS(Cell cell, boolean usePlotter, double pageWidth, double pageHeight, double border, EditWindow0 wnd) {
        PrintWriter printWriter = this.psObject.printWriter;
        printWriter.println("%%!PS-Adobe-1.0");
        printWriter.println("%%Title: " + cell.describe(false));
        if (User.isIncludeDateAndVersionInOutput()) {
            printWriter.println("%%%%Creator: Electric VLSI Design System (David Harris's color PostScript generator) version " + String.valueOf(Version.getVersion()));
            printWriter.println("%%%%CreationDate: " + TextUtils.formatDate(new Date()));
        } else {
            printWriter.println("%%%%Creator: Electric VLSI Design System (David Harris's color PostScript generator)");
        }
        printWriter.println("%%%%Pages: 1");
        printWriter.println("%%%%BoundingBox: " + TextUtils.formatDouble(this.psBoundaries[0]) + " " + TextUtils.formatDouble(this.psBoundaries[1]) + " " + TextUtils.formatDouble(this.psBoundaries[2]) + " " + TextUtils.formatDouble(this.psBoundaries[3]));
        printWriter.println("%%%%DocumentFonts: Helvetica");
        printWriter.println("%%%%EndComments");
        printWriter.println("%% Min X: " + TextUtils.formatDouble(this.psBoundaries[0]) + "  min Y: " + TextUtils.formatDouble(this.psBoundaries[1]) + "  max X: " + TextUtils.formatDouble(this.psBoundaries[2]) + "  max Y: " + TextUtils.formatDouble(this.psBoundaries[3]));
        double reducedwidth = pageWidth - border * 2.0;
        double reducedheight = pageHeight - border * 2.0;
        double scale = reducedwidth / (this.psBoundaries[2] - this.psBoundaries[0]);
        if (usePlotter) {
            printWriter.println(TextUtils.formatDouble(scale) + " " + TextUtils.formatDouble(scale) + " scale");
            x = this.psBoundaries[0] + (this.psBoundaries[2] - this.psBoundaries[0]) / 2.0 - reducedwidth / scale / 2.0 - border / scale;
            y = this.psBoundaries[1] - border / scale;
            printWriter.println(TextUtils.formatDouble(x) + " neg " + TextUtils.formatDouble(y) + " neg translate");
        } else {
            if (reducedheight / (this.psBoundaries[3] - this.psBoundaries[1]) < scale) {
                scale = reducedheight / (this.psBoundaries[3] - this.psBoundaries[1]);
            }
            printWriter.println(TextUtils.formatDouble(scale) + " " + TextUtils.formatDouble(scale) + " scale");
            x = this.psBoundaries[0] + (this.psBoundaries[2] - this.psBoundaries[0]) / 2.0 - reducedwidth / scale / 2.0 - border / scale;
            y = this.psBoundaries[1] + (this.psBoundaries[3] - this.psBoundaries[1]) / 2.0 - reducedheight / scale / 2.0 - border / scale;
            printWriter.println(TextUtils.formatDouble(x) + " neg " + TextUtils.formatDouble(y) + " neg translate");
        }
        printWriter.println("/DefaultFont /Helvetica def");
        printWriter.println("/scaleFont {");
        printWriter.println("    DefaultFont findfont");
        printWriter.println("    exch scalefont setfont} def");
        printWriter.println("\n/bx \n  { /h exch def /w exch def /x exch def /y exch def");
        printWriter.println("    newpath x y moveto w 0 rlineto 0 h rlineto w neg 0 rlineto closepath fill } def");
        for (int i2 = 0; i2 < this.numLayers; ++i2) {
            if (this.allLayers[i2].r == 1.0 && this.allLayers[i2].g == 1.0 && this.allLayers[i2].b == 1.0) continue;
            List g2 = this.flattenedBoxes.get(i2);
            List p = this.flattenedPolys.get(i2);
            if (g2.size() > 0 || p.size() > 0) {
                Iterator buf = new StringBuffer();
                this.makeLayerName(i2, (StringBuffer)((Object)buf));
                printWriter.println();
                printWriter.println("%% Layer" + ((StringBuffer)((Object)buf)).toString());
                printWriter.println(TextUtils.formatDouble(this.allLayers[i2].r) + " " + TextUtils.formatDouble(this.allLayers[i2].g) + " " + TextUtils.formatDouble(this.allLayers[i2].b) + " setrgbcolor");
            }
            for (PsBox gB : g2) {
                if (!gB.visible) continue;
                double w = gB.pos[0];
                double h2 = gB.pos[1];
                printWriter.println(gB.pos[3] + " " + gB.pos[2] + " " + w + " " + h2 + " bx");
            }
            for (PsPoly pB : p) {
                if (pB.coords.length <= 2) continue;
                printWriter.println("newpath " + TextUtils.formatDouble(pB.coords[0]) + " " + TextUtils.formatDouble(pB.coords[1]) + " moveto");
                for (int j2 = 2; j2 < pB.coords.length; j2 += 2) {
                    printWriter.println("        " + TextUtils.formatDouble(pB.coords[j2]) + " " + TextUtils.formatDouble(pB.coords[j2 + 1]) + " lineto");
                }
                printWriter.println("closepath " + (i2 == 0 ? "stroke" : "fill"));
            }
        }
        PsCell topCell = this.allCells.get(0);
        printWriter.println();
        printWriter.println("%% Port and Cell Instance Labels");
        printWriter.println("0 0 0 setrgbcolor");
        for (int i3 = 0; i3 < this.psObject.headerString.length; ++i3) {
            printWriter.println(this.psObject.headerString[i3]);
        }
        for (PsLabel l2 : topCell.labels) {
            double size = 14.0;
            AbstractTextDescriptor.Size s = l2.descript.getSize();
            if (s != null) {
                size = s.isAbsolute() ? s.getSize() : s.getSize();
            }
            if (wnd != null) {
                size *= wnd.getGlobalTextScale();
            }
            double psLX = l2.pos[0];
            double psHX = l2.pos[1];
            double psLY = l2.pos[2];
            double psHY = l2.pos[3];
            if (l2.style == Poly.Type.TEXTBOX) {
                printWriter.print(TextUtils.formatDouble((psLX + psHX) / 2.0) + " " + TextUtils.formatDouble((psLY + psHY) / 2.0) + " " + TextUtils.formatDouble(psHX - psLX) + " " + TextUtils.formatDouble(psHY - psLY) + " ");
                this.psObject.writePSString(l2.label);
                printWriter.println(" " + TextUtils.formatDouble(size / scale) + " Boxstring");
                continue;
            }
            double x = 0.0;
            double y = 0.0;
            String opName = "";
            if (l2.style == Poly.Type.TEXTCENT) {
                x = (psLX + psHX) / 2.0;
                y = (psLY + psHY) / 2.0;
                opName = "Centerstring";
            } else if (l2.style == Poly.Type.TEXTTOP) {
                x = (psLX + psHX) / 2.0;
                y = psHY;
                opName = "Topstring";
            } else if (l2.style == Poly.Type.TEXTBOT) {
                x = (psLX + psHX) / 2.0;
                y = psLY;
                opName = "Botstring";
            } else if (l2.style == Poly.Type.TEXTLEFT) {
                x = psLX;
                y = (psLY + psHY) / 2.0;
                opName = "Leftstring";
            } else if (l2.style == Poly.Type.TEXTRIGHT) {
                x = psHX;
                y = (psLY + psHY) / 2.0;
                opName = "Rightstring";
            } else if (l2.style == Poly.Type.TEXTTOPLEFT) {
                x = psLX;
                y = psHY;
                opName = "Topleftstring";
            } else if (l2.style == Poly.Type.TEXTTOPRIGHT) {
                x = psHX;
                y = psHY;
                opName = "Toprightstring";
            } else if (l2.style == Poly.Type.TEXTBOTLEFT) {
                x = psLX;
                y = psLY;
                opName = "Botleftstring";
            } else if (l2.style == Poly.Type.TEXTBOTRIGHT) {
                x = psHX;
                y = psLY;
                opName = "Botrightstring";
            }
            double descenderOffset = size / 12.0;
            AbstractTextDescriptor.Rotation rot = l2.descript.getRotation();
            if (rot == AbstractTextDescriptor.Rotation.ROT0) {
                y += descenderOffset;
            } else if (rot == AbstractTextDescriptor.Rotation.ROT90) {
                x -= descenderOffset;
            } else if (rot == AbstractTextDescriptor.Rotation.ROT180) {
                y -= descenderOffset;
            } else if (rot == AbstractTextDescriptor.Rotation.ROT270) {
                x += descenderOffset;
            }
            double xOff = x;
            double yOff = y;
            if (rot != AbstractTextDescriptor.Rotation.ROT0) {
                if (rot == AbstractTextDescriptor.Rotation.ROT90 || rot == AbstractTextDescriptor.Rotation.ROT270) {
                    if (l2.style == Poly.Type.TEXTTOP) {
                        opName = "Rightstring";
                    } else if (l2.style == Poly.Type.TEXTBOT) {
                        opName = "Leftstring";
                    } else if (l2.style == Poly.Type.TEXTLEFT) {
                        opName = "Botstring";
                    } else if (l2.style == Poly.Type.TEXTRIGHT) {
                        opName = "Topstring";
                    } else if (l2.style == Poly.Type.TEXTTOPLEFT) {
                        opName = "Botrightstring";
                    } else if (l2.style == Poly.Type.TEXTBOTRIGHT) {
                        opName = "Topleftstring";
                    }
                }
                y = 0.0;
                x = 0.0;
                if (rot == AbstractTextDescriptor.Rotation.ROT90) {
                    printWriter.println(xOff + " " + yOff + " translate 90 rotate");
                } else if (rot == AbstractTextDescriptor.Rotation.ROT180) {
                    printWriter.println(xOff + " " + yOff + " translate 180 rotate");
                } else if (rot == AbstractTextDescriptor.Rotation.ROT270) {
                    printWriter.println(xOff + " " + yOff + " translate 270 rotate");
                }
            }
            printWriter.print(x + " " + y + " ");
            this.psObject.writePSString(l2.label);
            printWriter.println(" " + size + " " + opName);
            if (rot == AbstractTextDescriptor.Rotation.ROT0) continue;
            if (rot == AbstractTextDescriptor.Rotation.ROT90) {
                printWriter.println("270 rotate " + -xOff + " " + -yOff + " translate");
                continue;
            }
            if (rot == AbstractTextDescriptor.Rotation.ROT180) {
                printWriter.println("180 rotate " + -xOff + " " + -yOff + " translate");
                continue;
            }
            if (rot != AbstractTextDescriptor.Rotation.ROT270) continue;
            printWriter.println("90 rotate " + -xOff + " " + -yOff + " translate");
        }
        printWriter.println("\nshowpage");
    }

    private void makeLayerName(int index, StringBuffer buf) {
        if (this.allLayers[index].layer != null) {
            buf.append(" ");
            buf.append(this.allLayers[index].layer.getName());
            return;
        }
        this.makeLayerName(this.allLayers[index].mix1, buf);
        this.makeLayerName(this.allLayers[index].mix2, buf);
    }

    private PsBox copyBox(PsBox g2, double[] m2) {
        PsBox newBox = new PsBox();
        newBox.layer = g2.layer;
        this.transformBox(newBox.pos, g2.pos, m2);
        newBox.visible = g2.visible;
        double dx = newBox.pos[0];
        double dy = newBox.pos[1];
        if (newBox.pos[2] < this.psBoundaries[0]) {
            this.psBoundaries[0] = newBox.pos[2];
        }
        if (newBox.pos[3] < this.psBoundaries[1]) {
            this.psBoundaries[1] = newBox.pos[3];
        }
        if (newBox.pos[2] + dx > this.psBoundaries[2]) {
            this.psBoundaries[2] = newBox.pos[2] + dx;
        }
        if (newBox.pos[3] + dy > this.psBoundaries[3]) {
            this.psBoundaries[3] = newBox.pos[3] + dy;
        }
        return newBox;
    }

    private PsPoly copyPoly(PsPoly p, double[] m2) {
        PsPoly newPoly = new PsPoly();
        newPoly.layer = p.layer;
        int numCoords = p.coords.length;
        newPoly.coords = new double[numCoords];
        this.transformPoly(newPoly, p, m2);
        for (int i2 = 0; i2 < numCoords; ++i2) {
            if (i2 % 2 == 0) {
                if (newPoly.coords[i2] < this.psBoundaries[0]) {
                    this.psBoundaries[0] = newPoly.coords[i2];
                }
                if (!(newPoly.coords[i2] > this.psBoundaries[3])) continue;
                this.psBoundaries[3] = newPoly.coords[i2];
                continue;
            }
            if (newPoly.coords[i2] < this.psBoundaries[1]) {
                this.psBoundaries[1] = newPoly.coords[i2];
            }
            if (!(newPoly.coords[i2] > this.psBoundaries[2])) continue;
            this.psBoundaries[2] = newPoly.coords[i2];
        }
        return newPoly;
    }

    private void matrixMul(double[] r, double[] a2, double[] b2) {
        int j2;
        int i2;
        double[] tmp = new double[9];
        for (i2 = 0; i2 < 3; ++i2) {
            for (j2 = 0; j2 < 3; ++j2) {
                tmp[i2 * 3 + j2] = 0.0;
                for (int k2 = 0; k2 < 3; ++k2) {
                    int n2 = i2 * 3 + j2;
                    tmp[n2] = tmp[n2] + a2[i2 * 3 + k2] * b2[k2 * 3 + j2];
                }
            }
        }
        for (i2 = 0; i2 < 3; ++i2) {
            for (j2 = 0; j2 < 3; ++j2) {
                r[i2 * 3 + j2] = tmp[i2 * 3 + j2];
            }
        }
    }

    private void newIdentityMatrix(double[] m2) {
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j2 = 0; j2 < 3; ++j2) {
                m2[i2 * 3 + j2] = i2 == j2 ? 1 : 0;
            }
        }
    }

    private void transformBox(double[] finall, double[] initial, double[] m2) {
        double[] pos = new double[]{initial[2] + initial[0] / 2.0, initial[3] + initial[1] / 2.0};
        for (int i2 = 0; i2 < 2; ++i2) {
            finall[i2 + 2] = m2[6 + i2];
            for (int j2 = 0; j2 < 2; ++j2) {
                int n2 = i2 + 2;
                finall[n2] = finall[n2] + m2[i2 + j2 * 3] * pos[j2];
            }
        }
        if (m2[1] == 0.0) {
            finall[0] = initial[0];
            finall[1] = initial[1];
        } else {
            finall[0] = initial[1];
            finall[1] = initial[0];
        }
        finall[2] = finall[2] - finall[0] / 2.0;
        finall[3] = finall[3] - finall[1] / 2.0;
    }

    private void transformPoly(PsPoly finall, PsPoly initial, double[] m2) {
        for (int p = 0; p < initial.coords.length / 2; ++p) {
            for (int i2 = 0; i2 < 2; ++i2) {
                finall.coords[p * 2 + i2] = m2[6 + i2];
                for (int j2 = 0; j2 < 2; ++j2) {
                    int n2 = p * 2 + i2;
                    finall.coords[n2] = finall.coords[n2] + m2[i2 + j2 * 3] * initial.coords[p * 2 + j2];
                }
            }
        }
    }

    private static class LayerMap {
        Layer layer;
        int mix1;
        int mix2;
        double r;
        double g;
        double b;
        double opacity;
        boolean foreground;

        private LayerMap() {
        }
    }

    private static class PxBoxQuadTree {
        int numBoxes;
        PsBoxElement[] boxes;
        double[] bounds = new double[4];
        PxBoxQuadTree tl;
        PxBoxQuadTree tr;
        PxBoxQuadTree bl;
        PxBoxQuadTree br;
        PxBoxQuadTree parent;
        int level;

        private PxBoxQuadTree() {
        }
    }

    private static class PsCell {
        List<PsBox> boxes;
        List<PsPoly> polys;
        List<PsLabel> labels;
        List<PsCellInst> inst;

        private PsCell() {
        }
    }

    private static class PsBox {
        double[] pos = new double[4];
        int layer;
        boolean visible;

        private PsBox() {
        }
    }

    private static class PsLabel {
        String label;
        double[] pos = new double[4];
        Poly.Type style;
        TextDescriptor descript;

        private PsLabel() {
        }
    }

    private static class PsCellInst {
        double[] transform = new double[9];
        PsCell inst;

        private PsCellInst() {
        }
    }

    private static class PsPoly {
        double[] coords;
        int layer;

        private PsPoly() {
        }
    }

    private static class PsBoxElement {
        double[] pos = new double[4];
        int layer;
        boolean visible;

        private PsBoxElement() {
        }
    }
}

