/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import java.awt.Color;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Maxwell
extends Output {
    Map<Integer, List<Integer>> maxNetMap;
    Map<Integer, String> boxNames;
    int boxNumber;
    private MaxwellPreferences localPrefs;

    Maxwell(MaxwellPreferences mp) {
        this.localPrefs = mp;
    }

    private void initialize(Cell cell) {
        this.maxNetMap = new HashMap<Integer, List<Integer>>();
        this.boxNames = new HashMap<Integer, String>();
        this.boxNumber = 1;
        this.printWriter.print("# Maxwell netlist for cell " + cell.noLibDescribe() + " from library " + cell.getLibrary().getName() + "\n");
        if (this.localPrefs.includeDateAndVersionInOutput) {
            this.printWriter.print("# CELL CREATED ON " + TextUtils.formatDate(cell.getCreationDate()) + "\n");
            this.printWriter.print("# LAST REVISED ON " + TextUtils.formatDate(cell.getRevisionDate()) + "\n");
            this.printWriter.print("# Generated automatically by the Electric VLSI Design System, version " + String.valueOf(Version.getVersion()) + "\n");
            this.printWriter.print("# WRITTEN ON " + TextUtils.formatDate(new Date()) + "\n");
        } else {
            this.printWriter.print("# Generated automatically by the Electric VLSI Design System\n");
        }
        this.printWriter.print("\n");
        this.emitCopyright("# ", "");
    }

    private void terminate() {
        for (Integer index : this.maxNetMap.keySet()) {
            List<Integer> boxList = this.maxNetMap.get(index);
            if (boxList.size() <= 1) continue;
            this.printWriter.print("Unite {");
            boolean first = true;
            for (Integer boxNum : boxList) {
                if (first) {
                    first = false;
                } else {
                    this.printWriter.print(" ");
                }
                String boxName = this.boxNames.get(boxNum);
                this.printWriter.print("\"" + boxName + "\"");
            }
            this.printWriter.print("}\n");
        }
    }

    private void writePolygon(Poly poly, int globalNetNum, Network net) {
        Layer layer = poly.getLayer();
        if (layer.getTechnology() != Technology.getCurrent()) {
            return;
        }
        FixpRectangle box = poly.getBox();
        if (box == null) {
            return;
        }
        Color color = this.localPrefs.layerColors.get(layer);
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        this.printWriter.print("NewObjColor " + red + " " + green + " " + blue + "\n");
        Integer index = globalNetNum;
        List<Integer> boxList = this.maxNetMap.get(index);
        if (boxList == null) {
            boxList = new ArrayList<Integer>();
            this.maxNetMap.put(index, boxList);
        }
        double scale = layer.getTechnology().getScale();
        double lX = ((RectangularShape)box).getMinX() * scale / 1000.0;
        double lY = ((RectangularShape)box).getMinY() * scale / 1000.0;
        double wid = ((RectangularShape)box).getWidth() * scale / 1000.0;
        double hei = ((RectangularShape)box).getHeight() * scale / 1000.0;
        String netName = net.describe(false) + "-" + this.boxNumber;
        this.printWriter.print("Box pos3 " + lX + " " + lY + " " + layer.getName() + "-Bot   " + wid + " " + hei + " " + layer.getName() + "-Hei \"" + netName + "\"\n");
        Integer boxNum = this.boxNumber;
        boxList.add(boxNum);
        this.boxNames.put(boxNum, netName);
        ++this.boxNumber;
    }

    public static class MaxwellPreferences
    extends Output.OutputPreferences {
        public Map<Layer, Color> layerColors = new HashMap<Layer, Color>();

        public MaxwellPreferences(boolean factory) {
            super(factory);
            for (Technology tech : TechPool.getThreadTechPool().values()) {
                Color[] transparentColors = factory ? tech.getFactoryTransparentLayerColors() : tech.getTransparentLayerColors();
                Iterator<Layer> it = tech.getLayers();
                while (it.hasNext()) {
                    Layer layer = it.next();
                    EGraphics graphics = factory ? layer.getFactoryGraphics() : layer.getGraphics();
                    this.layerColors.put(layer, graphics.getColor(transparentColors));
                }
            }
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            Maxwell out = new Maxwell(this);
            if (out.openTextOutputStream(filePath)) {
                return out.finishWrite();
            }
            out.initialize(cell);
            Visitor wcVisitor = new Visitor(out);
            HierarchyEnumerator.enumerateCell(cell, context, (HierarchyEnumerator.Visitor)wcVisitor);
            out.terminate();
            if (out.closeTextOutputStream()) {
                return out.finishWrite();
            }
            System.out.println(filePath + " written");
            return out.finishWrite();
        }
    }

    private static class Visitor
    extends HierarchyEnumerator.Visitor {
        Maxwell generator;

        public Visitor(Maxwell generator) {
            this.generator = generator;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            Netlist netList = info.getNetlist();
            Iterator<Geometric> it = info.getCell().getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (ni.isCellInstance()) continue;
                FixpTransform transRot = ni.rotateOut();
                Technology tech = ni.getProto().getTechnology();
                for (Poly poly : tech.getShapeOfNode(ni, true, false, null)) {
                    if (poly.getPort() == null) continue;
                    poly.transform(transRot);
                    poly.transform(info.getTransformToRoot());
                    PortInst pi = ni.findPortInstFromEquivalentProto(poly.getPort());
                    Network net = netList.getNetwork(pi);
                    if (net == null) continue;
                    int globalNetNum = info.getNetID(net);
                    this.generator.writePolygon(poly, globalNetNum, net);
                }
            }
            it = info.getCell().getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                Technology tech = ai.getProto().getTechnology();
                for (Poly poly : tech.getShapeOfArc(ai)) {
                    poly.transform(info.getTransformToRoot());
                    Network net = netList.getNetwork(ai, 0);
                    int globalNetNum = info.getNetID(net);
                    this.generator.writePolygon(poly, globalNetNum, net);
                }
            }
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            return true;
        }
    }
}

