/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TransistorSize;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.RectangularShape;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class L
extends Output {
    private static final int TRUEPIN = 1;
    private static final int TRANSISTOR = 2;
    private static final int INSTANCE = 3;
    private static final int OTHERNODE = 4;
    private Set<Cell> cellsSeen;
    private PortInst gateLeft;
    private PortInst gateRight;
    private PortInst activeTop;
    private PortInst activeBottom;
    private final EditingPreferences ep;

    L(EditingPreferences ep, LPreferences lp) {
        this.ep = ep;
    }

    private void writeLCells(Cell cell) {
        this.printWriter.println("L:: TECH ANY");
        this.cellsSeen = new HashSet<Cell>();
        this.writeLCell(cell);
    }

    private void writeLCell(Cell cell) {
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
            Cell np = (Cell)ni.getProto();
            Cell oNp = np.contentsView();
            if (oNp != null) {
                np = oNp;
            }
            if (this.cellsSeen.contains(np)) continue;
            this.writeLCell(np);
        }
        this.cellsSeen.add(cell);
        this.printWriter.println("");
        if (cell.getView() == View.LAYOUT) {
            this.printWriter.print("LAYOUT ");
        }
        if (cell.isSchematic()) {
            this.printWriter.print("SCHEMATIC ");
        }
        if (cell.isIcon()) {
            this.printWriter.print("ICON ");
        }
        if (cell.getView() == View.LAYOUTSKEL) {
            this.printWriter.print("BBOX ");
        }
        this.printWriter.println("CELL " + this.getLegalName(cell.getName()) + " ( )\n{");
        ERectangle bounds = cell.getBounds();
        this.printWriter.println("#bbox: ll= (" + TextUtils.formatDouble(((RectangularShape)bounds).getMinX()) + "," + TextUtils.formatDouble(((RectangularShape)bounds).getMinY()) + ") ur= (" + TextUtils.formatDouble(((RectangularShape)bounds).getMaxX()) + "," + TextUtils.formatDouble(((RectangularShape)bounds).getMaxY()) + ")");
        Iterator<Object> it2 = cell.getPorts();
        while (it2.hasNext()) {
            Export e2 = (Export)it2.next();
            Poly poly = e2.getPoly();
            double xPos = poly.getCenterX();
            double yPos = poly.getCenterY();
            String type = "";
            if (e2.getCharacteristic() == PortCharacteristic.GND) {
                type = "GND";
            } else if (e2.getCharacteristic() == PortCharacteristic.PWR) {
                type = "VDD";
            } else if (e2.getCharacteristic() == PortCharacteristic.IN) {
                type = "IN";
            } else if (e2.getCharacteristic() == PortCharacteristic.OUT) {
                type = "OUT";
            } else if (e2.getCharacteristic() == PortCharacteristic.BIDIR) {
                type = "INOUT";
            }
            ArcProto ap = e2.getBasePort().getConnection();
            String lay = this.getArcFunctionName(ap, ap.getName());
            this.printWriter.println("\t" + type + " " + lay + " " + this.getLegalName(e2.getName()) + " (" + TextUtils.formatDouble(xPos) + "," + TextUtils.formatDouble(yPos) + ") ;");
        }
        this.printWriter.println("");
        it2 = cell.getNodes();
        while (it2.hasNext()) {
            boolean oldTranspose;
            NodeInst ni = (NodeInst)it2.next();
            if (this.getNodeType(ni) == 1) continue;
            NodeProto np = ni.getProto();
            PrimitiveNode.Function fun = ni.getFunction();
            Object type = np.getName();
            if (ni.isCellInstance()) {
                if (ni.isIconOfParent()) continue;
                Cell oNp = ((Cell)np).contentsView();
                if (oNp != null) {
                    np = oNp;
                }
                type = np.getName();
                this.printWriter.print("\tINST " + (String)type + " " + this.getLegalName(ni.getName()));
            } else {
                PrimitiveNode npPrim = (PrimitiveNode)np;
                if (fun.isPin()) {
                    if (ni.hasExports()) continue;
                    PrimitivePort primPp = npPrim.getPort(0);
                    ArcProto ap = primPp.getConnection();
                    type = "NODE " + this.getArcFunctionName(ap, "???");
                }
                if (fun == PrimitiveNode.Function.WELL) {
                    type = "MNSUB";
                }
                if (fun == PrimitiveNode.Function.SUBSTRATE) {
                    type = "MPSUB";
                }
                if (fun.isContact() || fun == PrimitiveNode.Function.CONNECT) {
                    boolean conMetal1 = false;
                    boolean conMetal2 = false;
                    boolean conPActive = false;
                    boolean conNActive = false;
                    boolean conPoly = false;
                    for (int j2 = 0; j2 < npPrim.getNumPorts(); ++j2) {
                        PrimitivePort primPp = npPrim.getPort(j2);
                        ArcProto[] arcs = primPp.getConnections();
                        for (int k2 = 0; k2 < arcs.length; ++k2) {
                            ArcProto ap = arcs[k2];
                            ArcProto.Function aFun = ap.getFunction();
                            if (aFun == ArcProto.Function.METAL1) {
                                conMetal1 = true;
                            }
                            if (aFun == ArcProto.Function.METAL2) {
                                conMetal2 = true;
                            }
                            if (aFun == ArcProto.Function.POLY1) {
                                conPoly = true;
                            }
                            if (aFun == ArcProto.Function.DIFFP) {
                                conPActive = true;
                            }
                            if (aFun != ArcProto.Function.DIFFN) continue;
                            conNActive = true;
                        }
                    }
                    if (conMetal1) {
                        if (conMetal2) {
                            type = "M1M2";
                        } else if (conPoly) {
                            type = "MPOLY";
                        } else if (conPActive) {
                            type = "MPDIFF";
                        } else if (conNActive) {
                            type = "MNDIFF";
                        }
                    }
                }
                if (fun.isNTypeTransistor()) {
                    type = "TN";
                } else if (fun.isPTypeTransistor()) {
                    type = "TP";
                } else if (fun == PrimitiveNode.Function.TRADMOS || fun == PrimitiveNode.Function.TRAPMOSD) {
                    type = "TD";
                }
                this.printWriter.print("\t" + (String)type + " " + this.getLegalName(ni.getName()));
            }
            Orientation or = ni.getOrient();
            int oldRotation = or.getCAngle();
            boolean bl = oldTranspose = or.isCTranspose();
            if (oldRotation != 0 || oldTranspose) {
                if (oldTranspose) {
                    this.printWriter.print(" RX");
                    oldRotation = (oldRotation + 2700) % 3600;
                }
                this.printWriter.print(" R" + TextUtils.formatDouble(oldRotation / 10));
            }
            if (ni.getXSize() != np.getDefWidth(this.ep) || ni.getYSize() != np.getDefHeight(this.ep)) {
                double wid = ni.getLambdaBaseXSize();
                double len = ni.getLambdaBaseYSize();
                if (fun.isFET()) {
                    TransistorSize ts = ni.getTransistorSize(null);
                    len = ts.getDoubleLength();
                    wid = ts.getDoubleWidth();
                }
                this.printWriter.print(" W=" + TextUtils.formatDouble(wid) + " L=" + TextUtils.formatDouble(len));
            }
            if (ni.isCellInstance()) {
                ERectangle cellBounds = ((Cell)ni.getProto()).getBounds();
                this.printWriter.println(" AT (" + TextUtils.formatDouble(ni.getTrueCenterX() - ((RectangularShape)cellBounds).getCenterX()) + "," + TextUtils.formatDouble(ni.getTrueCenterY() - ((RectangularShape)cellBounds).getCenterY()) + ") ;");
                continue;
            }
            this.printWriter.println(" AT (" + TextUtils.formatDouble(ni.getTrueCenterX()) + "," + TextUtils.formatDouble(ni.getTrueCenterY()) + ") ;");
        }
        this.printWriter.println("");
        HashSet<ArcInst> arcsSeen = new HashSet<ArcInst>();
        Iterator<Geometric> it3 = cell.getNodes();
        while (it3.hasNext()) {
            NodeInst ni = it3.next();
            int nature = this.getNodeType(ni);
            if (nature == 1) continue;
            Iterator<Connection> cIt = ni.getConnections();
            while (cIt.hasNext()) {
                Connection con = cIt.next();
                ArcInst ai = con.getArc();
                if (arcsSeen.contains(ai)) continue;
                this.printWriter.print("\tWIRE");
                String alt = this.getArcFunctionName(ai.getProto(), null);
                if (alt != null) {
                    this.printWriter.print(" " + alt);
                }
                if (ai.getLambdaBaseWidth() != ai.getProto().getDefaultLambdaBaseWidth(this.ep)) {
                    this.printWriter.print(" W=" + TextUtils.formatDouble(ai.getLambdaBaseWidth()));
                }
                if (ni.hasExports() && ni.getFunction().isPin()) {
                    Export e3 = ni.getExports().next();
                    this.printWriter.print(" " + this.getLegalName(e3.getName()));
                } else {
                    this.printWriter.print(" " + this.getLegalName(ni.getName()));
                }
                PortInst pi = con.getPortInst();
                if (nature == 2) {
                    this.transistorPorts(ni);
                    if (pi == this.gateLeft) {
                        this.printWriter.print(".gl");
                    }
                    if (pi == this.activeTop) {
                        this.printWriter.print(".d");
                    }
                    if (pi == this.gateRight) {
                        this.printWriter.print(".gr");
                    }
                    if (pi == this.activeBottom) {
                        this.printWriter.print(".s");
                    }
                } else if (nature == 3) {
                    this.printWriter.print("." + this.getLegalName(pi.getPortProto().getName()));
                }
                int thatEnd = 1 - con.getEndIndex();
                String lastDir = "";
                double segDist = -1.0;
                int segCount = 0;
                int eNature = 0;
                NodeInst oNi = null;
                while (true) {
                    arcsSeen.add(ai);
                    int thisEnd = 1 - thatEnd;
                    String dir2 = lastDir;
                    if (ai.getLocation(thatEnd).getX() == ai.getLocation(thisEnd).getX()) {
                        if (ai.getLocation(thatEnd).getY() > ai.getLocation(thisEnd).getY()) {
                            dir2 = "UP";
                        } else if (ai.getLocation(thatEnd).getY() < ai.getLocation(thisEnd).getY()) {
                            dir2 = "DOWN";
                        }
                    } else if (ai.getLocation(thatEnd).getY() == ai.getLocation(thisEnd).getY()) {
                        if (ai.getLocation(thatEnd).getX() > ai.getLocation(thisEnd).getX()) {
                            dir2 = "RIGHT";
                        } else if (ai.getLocation(thatEnd).getX() < ai.getLocation(thisEnd).getX()) {
                            dir2 = "LEFT";
                        }
                    }
                    if (!dir2.equals(lastDir) && lastDir.length() > 0) {
                        this.printWriter.print(" " + lastDir);
                        if (segDist >= 0.0) {
                            this.printWriter.print("=" + TextUtils.formatDouble(segDist));
                        }
                        segDist = -1.0;
                        ++segCount;
                    }
                    lastDir = dir2;
                    oNi = ai.getPortInst(thatEnd).getNodeInst();
                    eNature = this.getNodeType(oNi);
                    if ((nature != 2 || segCount > 0) && eNature != 2) {
                        if (segDist < 0.0) {
                            segDist = 0.0;
                        }
                        segDist += ai.getLambdaLength();
                    }
                    if (eNature != 1) break;
                    int tot = 0;
                    int ot = 0;
                    ArcInst oAi = null;
                    Iterator<Connection> oCIt = oNi.getConnections();
                    while (oCIt.hasNext()) {
                        Connection oCon = oCIt.next();
                        if (arcsSeen.contains(oCon.getArc())) continue;
                        oAi = oCon.getArc();
                        ++tot;
                        ot = 1 - oCon.getEndIndex();
                    }
                    if (tot != 1) break;
                    ai = oAi;
                    thatEnd = ot;
                }
                if (lastDir.length() > 0) {
                    this.printWriter.print(" " + lastDir);
                    if (segDist >= 0.0) {
                        this.printWriter.print("=" + TextUtils.formatDouble(segDist));
                    }
                } else {
                    this.printWriter.print(" TO");
                }
                if (oNi.hasExports() && oNi.getFunction().isPin()) {
                    Export e4 = oNi.getExports().next();
                    this.printWriter.print(" " + this.getLegalName(e4.getName()));
                } else {
                    this.printWriter.print(" " + this.getLegalName(oNi.getName()));
                }
                PortInst oPi = ai.getPortInst(thatEnd);
                if (eNature == 2) {
                    this.transistorPorts(oNi);
                    if (oPi == this.gateLeft) {
                        this.printWriter.print(".gl");
                    }
                    if (oPi == this.activeTop) {
                        this.printWriter.print(".d");
                    }
                    if (oPi == this.gateRight) {
                        this.printWriter.print(".gr");
                    }
                    if (oPi == this.activeBottom) {
                        this.printWriter.print(".s");
                    }
                } else if (eNature == 3) {
                    this.printWriter.print("." + this.getLegalName(oPi.getPortProto().getName()));
                }
                this.printWriter.println(" ;");
            }
        }
        it3 = cell.getArcs();
        while (it3.hasNext()) {
            ArcInst ai = (ArcInst)it3.next();
            if (arcsSeen.contains(ai)) continue;
            this.printWriter.println("# WIRE " + ai.describe(true) + " not described!!");
        }
        this.printWriter.println("}");
    }

    private void transistorPorts(NodeInst ni) {
        PrimitiveNode.Function fun = ni.getFunction();
        this.activeBottom = null;
        this.gateRight = null;
        this.activeTop = null;
        this.gateLeft = null;
        if (ni.getNumPortInsts() < 3) {
            return;
        }
        this.gateLeft = ni.getPortInst(0);
        this.activeTop = ni.getPortInst(1);
        this.gateRight = ni.getPortInst(2);
        if (ni.getNumPortInsts() == 3 || fun == PrimitiveNode.Function.TRANPN || fun == PrimitiveNode.Function.TRAPNP || fun == PrimitiveNode.Function.TRA4NMOS || fun == PrimitiveNode.Function.TRA4DMOS || fun == PrimitiveNode.Function.TRA4PMOS || fun == PrimitiveNode.Function.TRA4NPN || fun == PrimitiveNode.Function.TRA4PNP || fun == PrimitiveNode.Function.TRA4NJFET || fun == PrimitiveNode.Function.TRA4PJFET || fun == PrimitiveNode.Function.TRA4DMES || fun == PrimitiveNode.Function.TRA4EMES) {
            this.activeBottom = this.gateRight;
            this.gateRight = null;
        } else {
            this.activeBottom = ni.getPortInst(3);
        }
    }

    private String getLegalName(String name) {
        if (name.equals("VDD")) {
            return "VDDXXX";
        }
        if (name.equals("GND")) {
            return "GNDXXX";
        }
        boolean badChars = false;
        for (int i2 = 0; i2 < name.length(); ++i2) {
            if (TextUtils.isLetterOrDigit(name.charAt(i2))) continue;
            badChars = true;
        }
        if (!badChars) {
            return name;
        }
        StringBuffer sb = new StringBuffer();
        for (int i3 = 0; i3 < name.length(); ++i3) {
            if (!TextUtils.isLetterOrDigit(name.charAt(i3))) continue;
            sb.append(name.charAt(i3));
        }
        return sb.toString();
    }

    private int getNodeType(NodeInst ni) {
        if (ni.isCellInstance()) {
            return 3;
        }
        PrimitiveNode.Function fun = ni.getFunction();
        if (fun.isFET()) {
            return 2;
        }
        if (!fun.isPin()) {
            return 4;
        }
        if (ni.getNumConnections() != 2) {
            return 4;
        }
        return 1;
    }

    private String getArcFunctionName(ArcProto ap, String def) {
        ArcProto.Function fun = ap.getFunction();
        if (fun.isMetal()) {
            return "MET" + fun.getLevel();
        }
        if (fun.isPoly()) {
            return "POLY";
        }
        if (fun == ArcProto.Function.DIFFP) {
            return "PDIFF";
        }
        if (fun == ArcProto.Function.DIFFN) {
            return "NDIFF";
        }
        if (fun == ArcProto.Function.DIFFS) {
            return "NWELL";
        }
        if (fun == ArcProto.Function.DIFFW) {
            return "PWELL";
        }
        return def;
    }

    public static class LPreferences
    extends Output.OutputPreferences {
        public LPreferences(boolean factory) {
            super(factory);
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath, EditingPreferences ep) {
            L out = new L(ep, this);
            if (out.openTextOutputStream(filePath)) {
                return out.finishWrite();
            }
            out.writeLCells(cell);
            if (out.closeTextOutputStream()) {
                return out.finishWrite();
            }
            System.out.println(filePath + " written");
            return out.finishWrite();
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            throw new UnsupportedOperationException();
        }
    }
}

