/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.ELIBConstants;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.io.input.LibraryStatistics;
import com.sun.electric.util.TextUtils;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ReadableDump
extends LibraryFiles {
    private int textLevel;
    private int bitCount;
    private int curArcEnd;
    private int varPos;
    private int curCellNumber;
    private int curNodeInstIndex;
    private int curArcInstIndex;
    private int curExportIndex;
    private double[] nodeProtoOffX;
    private double[] nodeProtoOffY;
    private String[][] nodeProtoTypeList;
    private LibraryFiles.NodeInstList[] nodeInstList;
    private ArcInstList[] arcInstList;
    private ExportList[] exportList;
    private int keywordArrayLen;
    private char[] keywordArray = null;
    private String keyWord;
    private Variable[] libVars;
    private Tool[] toolList;
    private Tool curTool;
    private Technology[] techList;
    private Technology curTech;
    private int[] lambdaValues;
    private int[] cellGroups;
    private CellName[] cellNames;
    private int[] cellCreationDates;
    private int[] cellRevisionDates;
    private String[] cellTechNames;
    private int[] cellUserbits;
    private Variable[][] cellVars;
    private int[] cellLowX;
    private int[] cellHighX;
    private int[] cellLowY;
    private int[] cellHighY;
    private String[] cellLibPaths;
    private Cell[] allCellsArray;
    private static final int INLIB = 1;
    private static final int INCELL = 2;
    private static final int INPORTPROTO = 3;
    private static final int INNODEINST = 4;
    private static final int INPOR = 5;
    private static final int INARCINST = 6;
    private static final int INARCEND = 7;
    private static final int INVTOOL = 1;
    private static final int INVTECHNOLOGY = 2;
    private static final int INVLIBRARY = 3;
    private static final int INVNODEPROTO = 4;
    private static final int INVNODEINST = 5;
    private static final int INVPORTPROTO = 6;
    private static final int INVARCINST = 7;

    ReadableDump(EditingPreferences ep) {
        super(ep);
    }

    @Override
    protected boolean readProjectSettings(EditingPreferences ep) {
        try {
            this.textLevel = 1;
            while (!this.getKeyword()) {
                String thisKey = this.keyWord;
                if (this.getKeyword() || this.textLevel != 1 || this.varPos != 0 && this.varPos != 1 && this.varPos != 2) break;
                if (thisKey.equals("****library:")) {
                    this.keywordNewLib();
                    continue;
                }
                if (thisKey.equals("lambda:")) {
                    this.keywordLambda();
                    continue;
                }
                if (thisKey.equals("version:")) {
                    this.keywordVersn();
                    continue;
                }
                if (thisKey.equals("aids:")) {
                    this.keywordLibKno();
                    continue;
                }
                if (thisKey.equals("aidname:")) {
                    this.keywordLibAiN();
                    continue;
                }
                if (thisKey.equals("aidbits:")) {
                    this.keywordLibAiB();
                    continue;
                }
                if (thisKey.equals("techcount:")) {
                    this.keywordLibTe();
                    continue;
                }
                if (thisKey.equals("techname:")) {
                    this.keywordLibTeN();
                    continue;
                }
                if (thisKey.equals("cellcount:")) {
                    this.keywordLibCC();
                    continue;
                }
                if (!thisKey.equals("variables:")) continue;
                this.keywordGetVar();
            }
            return false;
        }
        catch (IOException e2) {
            System.out.println("End of file reached while reading " + this.filePath);
            return true;
        }
    }

    @Override
    boolean readTheLibrary(boolean onlyProjectSettings, LibraryStatistics.FileContents fc, EditingPreferences ep) throws IOException {
        this.textLevel = 1;
        while (!this.getKeyword()) {
            String thisKey = this.keyWord;
            if (this.getKeyword()) break;
            switch (this.textLevel) {
                case 1: {
                    if (thisKey.equals("****library:")) {
                        this.keywordNewLib();
                        break;
                    }
                    if (thisKey.equals("bits:")) {
                        this.keywordLibBit();
                        break;
                    }
                    if (thisKey.equals("lambda:")) {
                        this.keywordLambda();
                        break;
                    }
                    if (thisKey.equals("version:")) {
                        this.keywordVersn();
                        break;
                    }
                    if (thisKey.equals("aids:")) {
                        this.keywordLibKno();
                        break;
                    }
                    if (thisKey.equals("aidname:")) {
                        this.keywordLibAiN();
                        break;
                    }
                    if (thisKey.equals("aidbits:")) {
                        this.keywordLibAiB();
                        break;
                    }
                    if (thisKey.equals("userbits:")) {
                        this.keywordLibUsb();
                        break;
                    }
                    if (thisKey.equals("techcount:")) {
                        this.keywordLibTe();
                        break;
                    }
                    if (thisKey.equals("techname:")) {
                        this.keywordLibTeN();
                        break;
                    }
                    if (thisKey.equals("cellcount:")) {
                        this.keywordLibCC();
                        break;
                    }
                    if (thisKey.equals("maincell:")) {
                        this.keywordLibMS();
                        break;
                    }
                    if (thisKey.equals("view:")) {
                        this.keywordLibVie();
                        break;
                    }
                    if (thisKey.equals("***cell:")) {
                        this.keywordNewCel();
                        break;
                    }
                    if (!thisKey.equals("variables:")) break;
                    this.keywordGetVar();
                    break;
                }
                case 2: {
                    if (thisKey.equals("bits:")) {
                        this.keywordCelBit();
                        break;
                    }
                    if (thisKey.equals("userbits:")) {
                        this.keywordCelUsb();
                        break;
                    }
                    if (thisKey.equals("name:")) {
                        this.keywordCelNam();
                        break;
                    }
                    if (thisKey.equals("version:")) {
                        this.keywordCelVer();
                        break;
                    }
                    if (thisKey.equals("creationdate:")) {
                        this.keywordCelCre();
                        break;
                    }
                    if (thisKey.equals("revisiondate:")) {
                        this.keywordCelRev();
                        break;
                    }
                    if (thisKey.equals("externallibrary:")) {
                        this.keywordCelExt();
                        break;
                    }
                    if (thisKey.equals("lowx:")) {
                        this.keywordCelLX();
                        break;
                    }
                    if (thisKey.equals("highx:")) {
                        this.keywordCelHX();
                        break;
                    }
                    if (thisKey.equals("lowy:")) {
                        this.keywordCelLY();
                        break;
                    }
                    if (thisKey.equals("highy:")) {
                        this.keywordCelHY();
                        break;
                    }
                    if (thisKey.equals("nodes:")) {
                        this.keywordCelNoC();
                        break;
                    }
                    if (thisKey.equals("arcs:")) {
                        this.keywordCelArC();
                        break;
                    }
                    if (thisKey.equals("porttypes:")) {
                        this.keywordCelPtC();
                        break;
                    }
                    if (thisKey.equals("technology:")) {
                        this.keywordTech();
                        break;
                    }
                    if (thisKey.equals("**node:")) {
                        this.keywordNewNo();
                        break;
                    }
                    if (thisKey.equals("**arc:")) {
                        this.keywordNewAr();
                        break;
                    }
                    if (thisKey.equals("***cell:")) {
                        this.keywordNewCel();
                        break;
                    }
                    if (!thisKey.equals("variables:")) break;
                    this.keywordGetVar();
                    break;
                }
                case 3: {
                    if (thisKey.equals("bits:")) {
                        this.keywordPtBit();
                        break;
                    }
                    if (thisKey.equals("userbits:")) {
                        this.keywordPtUsb();
                        break;
                    }
                    if (thisKey.equals("subnode:")) {
                        this.keywordPtSNo();
                        break;
                    }
                    if (thisKey.equals("subport:")) {
                        this.keywordPtSPt();
                        break;
                    }
                    if (thisKey.equals("name:")) {
                        this.keywordPtNam();
                        break;
                    }
                    if (thisKey.equals("descript:")) {
                        this.keywordPtDes();
                        break;
                    }
                    if (thisKey.equals("aseen:")) {
                        this.keywordPtKse();
                        break;
                    }
                    if (thisKey.equals("**porttype:")) {
                        this.keywordNewPt();
                        break;
                    }
                    if (thisKey.equals("**arc:")) {
                        this.keywordNewAr();
                        break;
                    }
                    if (thisKey.equals("**node:")) {
                        this.keywordNewNo();
                        break;
                    }
                    if (thisKey.equals("***cell:")) {
                        this.keywordNewCel();
                        break;
                    }
                    if (!thisKey.equals("variables:")) break;
                    this.keywordGetVar();
                    break;
                }
                case 4: {
                    if (thisKey.equals("bits:")) {
                        this.keywordNodBit();
                        break;
                    }
                    if (thisKey.equals("userbits:")) {
                        this.keywordNodUsb();
                        break;
                    }
                    if (thisKey.equals("type:")) {
                        this.keywordNodTyp();
                        break;
                    }
                    if (thisKey.equals("lowx:")) {
                        this.keywordNodLX();
                        break;
                    }
                    if (thisKey.equals("highx:")) {
                        this.keywordNodHX();
                        break;
                    }
                    if (thisKey.equals("lowy:")) {
                        this.keywordNodLY();
                        break;
                    }
                    if (thisKey.equals("highy:")) {
                        this.keywordNodHY();
                        break;
                    }
                    if (thisKey.equals("rotation:")) {
                        this.keywordNodRot();
                        break;
                    }
                    if (thisKey.equals("transpose:")) {
                        this.keywordNodTra();
                        break;
                    }
                    if (thisKey.equals("aseen:")) {
                        this.keywordNodKse();
                        break;
                    }
                    if (thisKey.equals("name:")) {
                        this.keywordNodNam();
                        break;
                    }
                    if (thisKey.equals("descript:")) {
                        this.keywordNodDes();
                        break;
                    }
                    if (thisKey.equals("*port:")) {
                        this.keywordNewPor();
                        break;
                    }
                    if (thisKey.equals("**node:")) {
                        this.keywordNewNo();
                        break;
                    }
                    if (thisKey.equals("**porttype:")) {
                        this.keywordNewPt();
                        break;
                    }
                    if (thisKey.equals("**arc:")) {
                        this.keywordNewAr();
                        break;
                    }
                    if (thisKey.equals("variables:")) {
                        this.keywordGetVar();
                        break;
                    }
                    if (thisKey.equals("***cell:")) {
                        this.keywordNewCel();
                        break;
                    }
                    if (!thisKey.equals("ports:")) break;
                    this.keywordNodPoC();
                    break;
                }
                case 5: {
                    if (thisKey.equals("*port:")) {
                        this.keywordNewPor();
                        break;
                    }
                    if (thisKey.equals("**node:")) {
                        this.keywordNewNo();
                        break;
                    }
                    if (thisKey.equals("**porttype:")) {
                        this.keywordNewPt();
                        break;
                    }
                    if (thisKey.equals("**arc:")) {
                        this.keywordNewAr();
                        break;
                    }
                    if (thisKey.equals("variables:")) {
                        this.keywordGetVar();
                        break;
                    }
                    if (!thisKey.equals("***cell:")) break;
                    this.keywordNewCel();
                    break;
                }
                case 6: {
                    if (thisKey.equals("bits:")) {
                        this.keywordArcBit();
                        break;
                    }
                    if (thisKey.equals("userbits:")) {
                        this.keywordArcUsb();
                        break;
                    }
                    if (thisKey.equals("type:")) {
                        this.keywordArcTyp();
                        break;
                    }
                    if (thisKey.equals("width:")) {
                        this.keywordArcWid();
                        break;
                    }
                    if (thisKey.equals("aseen:")) {
                        this.keywordArcKse();
                        break;
                    }
                    if (thisKey.equals("name:")) {
                        this.keywordArcNam();
                        break;
                    }
                    if (thisKey.equals("*end:")) {
                        this.keywordNewEnd();
                        break;
                    }
                    if (thisKey.equals("**arc:")) {
                        this.keywordNewAr();
                        break;
                    }
                    if (thisKey.equals("**node:")) {
                        this.keywordNewNo();
                        break;
                    }
                    if (thisKey.equals("variables:")) {
                        this.keywordGetVar();
                        break;
                    }
                    if (!thisKey.equals("***cell:")) break;
                    this.keywordNewCel();
                    break;
                }
                case 7: {
                    if (thisKey.equals("node:")) {
                        this.keywordEndNod();
                        break;
                    }
                    if (thisKey.equals("nodeport:")) {
                        this.keywordEndPt();
                        break;
                    }
                    if (thisKey.equals("xpos:")) {
                        this.keywordEndXP();
                        break;
                    }
                    if (thisKey.equals("ypos:")) {
                        this.keywordEndYP();
                        break;
                    }
                    if (thisKey.equals("*end:")) {
                        this.keywordNewEnd();
                        break;
                    }
                    if (thisKey.equals("**arc:")) {
                        this.keywordNewAr();
                        break;
                    }
                    if (thisKey.equals("**node:")) {
                        this.keywordNewNo();
                        break;
                    }
                    if (thisKey.equals("variables:")) {
                        this.keywordGetVar();
                        break;
                    }
                    if (!thisKey.equals("***cell:")) break;
                    this.keywordNewCel();
                }
            }
        }
        return this.allCellsArray == null;
    }

    @Override
    Map<Cell, Variable[]> createLibraryCells(boolean onlyProjectSettings, EditingPreferences ep) {
        this.lib.erase();
        this.lib.lowLevelSetUserBits(TextUtils.atoi(this.keyWord));
        this.lib.clearFromDisk();
        this.realizeVariables(this.lib, this.libVars);
        HashMap<Cell, Variable[]> originalVars = new HashMap<Cell, Variable[]>();
        for (int cellNumber = 0; cellNumber < this.nodeProtoCount; ++cellNumber) {
            if (this.cellLibPaths[cellNumber] == null) {
                this.finishCellInitialization(cellNumber, originalVars);
                continue;
            }
            this.findExtCell(cellNumber);
        }
        return originalVars;
    }

    private void findExtCell(int cellNumber) {
        String libPath = this.cellLibPaths[cellNumber];
        Library elib = this.readExternalLibraryFromFilename(libPath, FileType.ELIB, null);
        Cell cell = null;
        CellName curCellName = this.cellNames[cellNumber];
        if (elib != null && (cell = elib.findNodeProto(curCellName.toString())) != null && cell.getRevisionDate().compareTo(ELIBConstants.secondsToDate(this.cellRevisionDates[cellNumber])) != 0) {
            System.out.println("Warning: " + String.valueOf(cell) + " in " + String.valueOf(elib) + " has been modified since its use in " + String.valueOf(this.lib));
        }
        if (cell != null) {
            this.allCellsArray[cellNumber] = cell;
            this.nodeProtoList[cellNumber] = null;
        } else {
            LibraryFiles.NodeInstList nil;
            String elibName = null;
            if (elib != null) {
                elibName = elib.getName();
            } else {
                File libFile = new File(libPath);
                elibName = libFile.getName();
                int lastDotPos = elibName.lastIndexOf(46);
                if (lastDotPos > 0) {
                    elibName = elibName.substring(0, lastDotPos);
                }
            }
            System.out.println("Cannot find cell " + curCellName.toString() + " in library " + elibName + "...creating dummy version");
            curCellName = curCellName.getVersion() != 0 ? CellName.parseName(curCellName.getName() + "FROM" + elibName + ";" + curCellName.getVersion() + curCellName.getView().getAbbreviationExtension()) : CellName.parseName(curCellName.getName() + "FROM" + elibName + curCellName.getView().getAbbreviationExtension());
            this.cellNames[cellNumber] = curCellName;
            this.finishCellInitialization(cellNumber, null);
            this.nodeInstList[cellNumber] = nil = new LibraryFiles.NodeInstList(2, false);
            nil.protoType[0] = Generic.tech().cellCenterNode;
            nil.name[0] = null;
            nil.lowX[0] = 0;
            nil.highX[0] = 0;
            nil.lowY[0] = 0;
            nil.highY[0] = 0;
            nil.rotation[0] = 0;
            nil.transpose[0] = 0;
            nil.protoType[1] = Artwork.tech().crossedBoxNode;
            nil.name[1] = null;
            nil.lowX[1] = this.cellLowX[cellNumber];
            nil.highX[1] = this.cellHighX[cellNumber];
            nil.lowY[1] = this.cellLowY[cellNumber];
            nil.highY[1] = this.cellHighY[cellNumber];
            nil.rotation[1] = 0;
            nil.transpose[1] = 0;
        }
    }

    private void finishCellInitialization(int cellNumber, HashMap<Cell, Variable[]> originalVars) {
        Technology tech;
        Cell curCell;
        this.allCellsArray[cellNumber] = this.nodeProtoList[cellNumber] = (curCell = Cell.newInst(this.lib, this.cellNames[cellNumber].toString()));
        curCell.setTempInt(this.cellGroups[cellNumber]);
        String techName = this.cellTechNames[cellNumber];
        Technology technology = tech = techName != null ? this.findTechnologyName(techName) : null;
        if (tech != null) {
            curCell.setTechnology(tech);
        }
        curCell.lowLevelSetCreationDate(ELIBConstants.secondsToDate(this.cellCreationDates[cellNumber]));
        curCell.lowLevelSetRevisionDate(ELIBConstants.secondsToDate(this.cellRevisionDates[cellNumber]));
        curCell.lowLevelSetUserbits(this.cellUserbits[cellNumber]);
        if (originalVars != null) {
            originalVars.put(curCell, this.cellVars[cellNumber]);
        }
        for (int nodeInstIndex = 0; nodeInstIndex < this.nodeInstList[cellNumber].protoType.length; ++nodeInstIndex) {
            this.findNodeProto(cellNumber, nodeInstIndex);
        }
        for (int arcInstIndex = 0; arcInstIndex < this.arcInstList[cellNumber].arcProto.length; ++arcInstIndex) {
            this.findArcProto(cellNumber, arcInstIndex);
        }
    }

    private void findNodeProto(int cellNumber, int nodeInstIndex) {
        String nodeProtoType = this.nodeProtoTypeList[cellNumber][nodeInstIndex];
        Comparable<Cell> curNodeInstProto = null;
        int openSquare = nodeProtoType.indexOf(91);
        if (openSquare >= 0) {
            curNodeInstProto = this.allCellsArray[TextUtils.atoi(nodeProtoType, openSquare + 1)];
        } else {
            int colonPos = nodeProtoType.indexOf(58);
            Technology tech = Technology.findTechnology(nodeProtoType.substring(0, colonPos));
            if (tech == null) {
                return;
            }
            curNodeInstProto = tech.findNodeProto(nodeProtoType.substring(colonPos + 1));
            if (curNodeInstProto == null && nodeProtoType.equals("Active-Node") && (curNodeInstProto = tech.findNodeProto("P-Active-Node")) == null) {
                curNodeInstProto = tech.convertOldNodeName(nodeProtoType);
            }
        }
        if (curNodeInstProto == null) {
            System.out.println("Error on line " + this.lineReader.getLineNumber() + ": unknown node type: " + nodeProtoType);
        }
        this.nodeInstList[cellNumber].protoType[nodeInstIndex] = curNodeInstProto;
    }

    private void findArcProto(int cellNumber, int arcInstIndex) {
        ArcProto curArcInstProto = null;
        curArcInstProto = ArcProto.findArcProto(this.keyWord);
        if (curArcInstProto == null) {
            Technology tech = null;
            int colonPos = this.keyWord.indexOf(58);
            if (colonPos >= 0) {
                tech = Technology.findTechnology(this.keyWord.substring(0, colonPos));
            }
            if (tech != null) {
                curArcInstProto = tech.convertOldArcName(this.keyWord);
            }
        }
        if (curArcInstProto == null) {
            System.out.println("Error on line " + this.lineReader.getLineNumber() + ": unknown arc type: " + this.keyWord);
        }
        this.arcInstList[cellNumber].arcProto[arcInstIndex] = curArcInstProto;
    }

    @Override
    Variable[] findVarsOnExampleIcon(Cell parentCell, Cell iconCell) {
        int cellIndex;
        for (cellIndex = 0; cellIndex < this.nodeProtoList.length && this.nodeProtoList[cellIndex] != parentCell; ++cellIndex) {
        }
        if (cellIndex >= this.nodeInstList.length) {
            return null;
        }
        LibraryFiles.NodeInstList nil = this.nodeInstList[cellIndex];
        for (int i2 = 0; i2 < nil.protoType.length; ++i2) {
            this.findNodeProto(cellIndex, i2);
            NodeProto np = this.nodeInstList[cellIndex].protoType[i2];
            if (np != iconCell) continue;
            return nil.vars[i2];
        }
        return null;
    }

    @Override
    protected void realizeCellsRecursively(Cell cell, HashSet<Cell> markCellForNodes, HashSet<Cell> patchedCells, String scaledCellName, double scale) {
        if (cell.getLibrary() != this.lib) {
            return;
        }
        if (scaledCellName != null) {
            return;
        }
        int cellIndex = cell.getTempInt();
        if (this.nodeInstList == null) {
            return;
        }
        LibraryFiles.NodeInstList nil = this.nodeInstList[cellIndex];
        int numNodes = 0;
        NodeProto[] nodePrototypes = null;
        if (nil != null) {
            nodePrototypes = nil.protoType;
            numNodes = nodePrototypes.length;
        }
        this.scanNodesForRecursion(cell, markCellForNodes, patchedCells, nodePrototypes, 0, numNodes);
        ReadableDump.setProgressValue(++cellsConstructed * 100 / totalCells);
        double lambda = this.cellLambda[cellIndex];
        Point2D offset = this.realizeNodes(cell, nil, lambda);
        this.nodeProtoOffX[cellIndex] = offset.getX();
        this.nodeProtoOffY[cellIndex] = offset.getY();
        this.realizeExports(cell, cellIndex);
        this.realizeArcs(cell, cellIndex);
    }

    @Override
    protected boolean spreadLambda(Cell cell, int cellIndex) {
        boolean changed = false;
        LibraryFiles.NodeInstList nil = this.nodeInstList[cellIndex];
        int numNodes = 0;
        if (nil != null) {
            numNodes = nil.protoType.length;
        }
        double thisLambda = this.cellLambda[cellIndex];
        for (int i2 = 0; i2 < numNodes; ++i2) {
            int subCellIndex;
            double subLambda;
            NodeProto np = nil.protoType[i2];
            if (np == null || np instanceof PrimitiveNode) continue;
            Cell subCell = (Cell)np;
            LibraryFiles reader = this;
            if (subCell.getLibrary() != this.lib && (reader = this.getReaderForLib(subCell.getLibrary())) == null || (subLambda = reader.cellLambda[subCellIndex = subCell.getTempInt()]) == thisLambda) continue;
            reader.cellLambda[subCellIndex] = thisLambda;
            changed = true;
        }
        return changed;
    }

    @Override
    protected void computeTech(Cell cell, Set uncomputedCells) {
        int cellIndex;
        uncomputedCells.remove(cell);
        for (cellIndex = 0; cellIndex < this.nodeProtoCount && this.nodeProtoList[cellIndex] != cell; ++cellIndex) {
        }
        if (cellIndex >= this.nodeProtoCount || this.nodeInstList == null) {
            return;
        }
        LibraryFiles.NodeInstList nil = this.nodeInstList[cellIndex];
        int numNodes = 0;
        NodeProto[] nodePrototypes = null;
        if (nil != null) {
            nodePrototypes = nil.protoType;
            numNodes = nodePrototypes.length;
        }
        for (int i2 = 0; i2 < numNodes; ++i2) {
            Cell subCell;
            LibraryFiles reader;
            NodeProto np = nodePrototypes[i2];
            if (!uncomputedCells.contains(np) || (reader = this.getReaderForLib((subCell = (Cell)np).getLibrary())) == null) continue;
            reader.computeTech(subCell, uncomputedCells);
        }
        ArcInstList ail = this.arcInstList[cellIndex];
        ArcProto[] arcPrototypes = null;
        if (ail != null) {
            arcPrototypes = ail.arcProto;
        }
        Technology cellTech = Technology.whatTechnology(cell, nodePrototypes, 0, numNodes, arcPrototypes);
        cell.setTechnology(cellTech);
    }

    @Override
    protected double computeLambda(Cell cell, int cellIndex) {
        Technology cellTech = cell.getTechnology();
        double lambda = 1.0;
        if (cellTech != null) {
            for (int i2 = 0; i2 < this.techList.length; ++i2) {
                if (this.techList[i2] != cellTech) continue;
                lambda = this.lambdaValues[i2];
                break;
            }
        }
        return lambda;
    }

    private Point2D realizeNodes(Cell cell, LibraryFiles.NodeInstList nil, double lambda) {
        int xoff = 0;
        int yoff = 0;
        int numNodes = 0;
        if (nil != null) {
            numNodes = nil.protoType.length;
        }
        for (int j2 = 0; j2 < numNodes; ++j2) {
            NodeProto np = nil.protoType[j2];
            if (np != Generic.tech().cellCenterNode) continue;
            this.realizeNode(nil, j2, xoff, yoff, lambda, cell, np);
            xoff = (nil.lowX[j2] + nil.highX[j2]) / 2;
            yoff = (nil.lowY[j2] + nil.highY[j2]) / 2;
            break;
        }
        Point2D.Double offset = new Point2D.Double(xoff, yoff);
        for (int j3 = 0; j3 < numNodes; ++j3) {
            NodeProto np = nil.protoType[j3];
            if (np == null || np == Generic.tech().cellCenterNode) continue;
            this.realizeNode(nil, j3, xoff, yoff, lambda, cell, np);
        }
        return offset;
    }

    private void realizeExports(Cell cell, int cellIndex) {
        ExportList el = this.exportList[cellIndex];
        int numExports = 0;
        if (el != null) {
            numExports = el.exportList.length;
        }
        CellId cellId = cell.getId();
        TreeSet<String> exportNames = new TreeSet<String>(TextUtils.STRING_NUMBER_ORDER);
        for (int j2 = 0; j2 < numExports; ++j2) {
            exportNames.add(el.exportName[j2]);
        }
        for (String exportName : exportNames) {
            cell.getId().newPortId(exportName);
        }
        for (int j3 = 0; j3 < numExports; ++j3) {
            Export pp;
            NodeInst subNi = this.nodeInstList[cellIndex].theNode[el.exportSubNode[j3]];
            PortInst pi = this.findProperPortInst(subNi, el.exportSubPort[j3]);
            int userBits = el.exportUserBits[j3];
            boolean alwaysDrawn = ImmutableExport.alwaysDrawnFromElib(userBits);
            boolean bodyOnly = ImmutableExport.bodyOnlyFromElib(userBits);
            PortCharacteristic characteristic = ImmutableExport.portCharacteristicFromElib(userBits);
            ExportId exportId = cellId.newPortId(Name.findName(el.exportName[j3]).toString());
            TextDescriptor nameTextDescriptor = el.exportNameDescriptor[j3];
            if (nameTextDescriptor == null) {
                nameTextDescriptor = this.ep.getExportTextDescriptor();
            }
            el.exportList[j3] = pp = Export.newInstanceNoIcon(cell, exportId, null, nameTextDescriptor, pi, alwaysDrawn, bodyOnly, characteristic, errorLogger);
            if (pp == null) continue;
            this.realizeVariables(pp, el.exportVars[j3]);
        }
    }

    private PortInst findProperPortInst(NodeInst ni, String portName) {
        NodeProto np = ni.getProto();
        PortProto pp = ReadableDump.findPortProto(np, portName);
        if (pp == null && !ni.isCellInstance()) {
            Technology tech = np.getTechnology();
            pp = tech.convertOldPortName(portName, (PrimitiveNode)np);
        }
        if (pp == null) {
            return null;
        }
        return ni.findPortInstFromProto(pp);
    }

    private void realizeArcs(Cell cell, int cellIndex) {
        ArcInstList ail = this.arcInstList[cellIndex];
        int numArcs = 0;
        if (ail != null) {
            numArcs = ail.arcProto.length;
        }
        double lambda = this.cellLambda[cellIndex];
        double xoff = this.nodeProtoOffX[cellIndex];
        double yoff = this.nodeProtoOffY[cellIndex];
        for (int j2 = 0; j2 < numArcs; ++j2) {
            ArcInst ai;
            TextDescriptor nameDescriptor;
            ArcProto ap = ail.arcProto[j2];
            String name = ail.arcInstName[j2];
            long gridExtendOverMin = this.getSizeCorrector(ap.getTechnology()).getExtendFromDisk(ap, (double)ail.arcWidth[j2] / lambda);
            NodeInst arcHeadNode = this.nodeInstList[cellIndex].theNode[ail.arcHeadNode[j2]];
            NodeInst arcTailNode = this.nodeInstList[cellIndex].theNode[ail.arcTailNode[j2]];
            if (!arcHeadNode.isLinked() || !arcTailNode.isLinked()) continue;
            PortInst headPortInst = this.findProperPortInst(arcHeadNode, ail.arcHeadPort[j2]);
            PortInst tailPortInst = this.findProperPortInst(arcTailNode, ail.arcTailPort[j2]);
            if (ap == null || headPortInst == null || tailPortInst == null) continue;
            double headX = ((double)ail.arcHeadX[j2] - xoff) / lambda;
            double headY = ((double)ail.arcHeadY[j2] - yoff) / lambda;
            double tailX = ((double)ail.arcTailX[j2] - xoff) / lambda;
            double tailY = ((double)ail.arcTailY[j2] - yoff) / lambda;
            EPoint headPt = EPoint.fromLambda(headX, headY);
            EPoint tailPt = EPoint.fromLambda(tailX, tailY);
            int userBits = ail.arcUserBits[j2];
            Poly poly = headPortInst.getPoly();
            if (!poly.isInside(headPt)) {
                System.out.println("Cell " + cell.describe(true) + ", " + String.valueOf(ap) + " head at (" + ail.arcHeadX[j2] + "," + ail.arcHeadY[j2] + ") not in port");
            }
            if (!(poly = tailPortInst.getPoly()).isInside(tailPt)) {
                System.out.println("Cell " + cell.describe(true) + ", " + String.valueOf(ap) + " tail at (" + ail.arcTailX[j2] + "," + ail.arcTailY[j2] + ") not in port");
            }
            if ((nameDescriptor = ail.arcNameDescriptor[j2]) == null) {
                nameDescriptor = this.ep.getArcTextDescriptor();
            }
            ail.arcList[j2] = ai = ArcInst.newInstanceNoCheck(cell, ap, name, nameDescriptor, headPortInst, tailPortInst, headPt, tailPt, gridExtendOverMin, ImmutableArcInst.angleFromElib(userBits), ImmutableArcInst.flagsFromElib(userBits));
            if (ai == null) {
                String msg = "ERROR: " + String.valueOf(cell) + ": arc " + name + " could not be created";
                System.out.println(msg);
                Input.errorLogger.logError(msg, cell, 1);
                continue;
            }
            this.realizeVariables(ai, ail.arcVars[j2]);
        }
    }

    private boolean getKeyword() throws IOException {
        int filePostionDelta = 0;
        int c2 = 0;
        do {
            if ((c2 = this.lineReader.read()) == -1) {
                return true;
            }
            ++filePostionDelta;
        } while (c2 == 32);
        int cindex = 0;
        boolean inQuote = false;
        if (c2 == 34) {
            inQuote = true;
        }
        if (this.keywordArray == null) {
            this.keywordArrayLen = 500;
            this.keywordArray = new char[this.keywordArrayLen];
        }
        this.keywordArray[cindex++] = (char)c2;
        while (true) {
            if ((c2 = this.lineReader.read()) == -1) {
                return true;
            }
            ++filePostionDelta;
            if (c2 == 10 || c2 == 32 && !inQuote) break;
            if (c2 == 34 && (cindex == 0 || this.keywordArray[cindex - 1] != '^')) {
                boolean bl = inQuote = !inQuote;
            }
            if (cindex >= this.keywordArrayLen) {
                int newKeywordArrayLen = this.keywordArrayLen * 2;
                char[] newKeywordArray = new char[newKeywordArrayLen];
                for (int i2 = 0; i2 < this.keywordArrayLen; ++i2) {
                    newKeywordArray[i2] = this.keywordArray[i2];
                }
                this.keywordArray = newKeywordArray;
                this.keywordArrayLen = newKeywordArrayLen;
            }
            this.keywordArray[cindex++] = (char)c2;
        }
        this.keyWord = new String(this.keywordArray, 0, cindex);
        this.updateProgressDialog(filePostionDelta);
        return false;
    }

    private void keywordNewLib() {
        this.varPos = 1;
        this.curTech = null;
        this.textLevel = 1;
    }

    private void keywordVersn() {
        this.version = Version.parseVersion(this.keyWord);
        this.convertMosisCmosTechnologies = this.version.compareTo(Version.parseVersion("6.03q")) < 0;
        this.scaleLambdaBy20 = this.version.compareTo(Version.parseVersion("5")) < 0;
        this.rotationMirrorBits = this.version.compareTo(Version.parseVersion("7.01")) >= 0;
    }

    private void keywordLibKno() {
        this.bitCount = 0;
        this.toolList = new Tool[Integer.parseInt(this.keyWord)];
    }

    private void keywordLibAiN() {
        this.curTool = Tool.findTool(this.keyWord);
        this.toolList[this.bitCount++] = this.curTool;
    }

    private void keywordLibAiB() {
        this.bitCount = 0;
    }

    private void keywordLibBit() {
        ++this.bitCount;
    }

    private void keywordLibUsb() {
    }

    private void keywordLibTe() {
        this.varPos = 2;
        this.bitCount = 0;
        int numTechs = Integer.parseInt(this.keyWord);
        this.techList = new Technology[numTechs];
        this.lambdaValues = new int[numTechs];
    }

    private void keywordLibTeN() {
        this.curTech = Technology.findTechnology(this.keyWord);
        this.techList[this.bitCount++] = this.curTech;
    }

    private void keywordLambda() {
        int lam = Integer.parseInt(this.keyWord);
        if (this.scaleLambdaBy20) {
            lam *= 20;
        }
        this.lambdaValues[this.bitCount - 1] = lam;
    }

    private void keywordLibCC() {
        this.varPos = 3;
        this.nodeProtoCount = Integer.parseInt(this.keyWord);
        if (this.nodeProtoCount == 0) {
            return;
        }
        this.nodeProtoList = new Cell[this.nodeProtoCount];
        this.allCellsArray = new Cell[this.nodeProtoCount];
        this.cellLambda = new double[this.nodeProtoCount];
        this.nodeProtoOffX = new double[this.nodeProtoCount];
        this.nodeProtoOffY = new double[this.nodeProtoCount];
        this.cellLowX = new int[this.nodeProtoCount];
        this.cellHighX = new int[this.nodeProtoCount];
        this.cellLowY = new int[this.nodeProtoCount];
        this.cellHighY = new int[this.nodeProtoCount];
        this.nodeProtoTypeList = new String[this.nodeProtoCount][];
        this.nodeInstList = new LibraryFiles.NodeInstList[this.nodeProtoCount];
        this.arcInstList = new ArcInstList[this.nodeProtoCount];
        this.exportList = new ExportList[this.nodeProtoCount];
        this.cellNames = new CellName[this.nodeProtoCount];
        this.cellGroups = new int[this.nodeProtoCount];
        this.cellTechNames = new String[this.nodeProtoCount];
        this.cellCreationDates = new int[this.nodeProtoCount];
        this.cellRevisionDates = new int[this.nodeProtoCount];
        this.cellUserbits = new int[this.nodeProtoCount];
        this.cellVars = new Variable[this.nodeProtoCount][];
        this.cellLibPaths = new String[this.nodeProtoCount];
    }

    private void keywordLibMS() {
    }

    private void keywordLibVie() {
        int openCurly = this.keyWord.indexOf(123);
        if (openCurly < 0) {
            System.out.println("Error on line " + this.lineReader.getLineNumber() + ": missing '{' in view name: " + this.keyWord);
            return;
        }
        String fullName = this.keyWord.substring(0, openCurly);
        String abbrev = this.keyWord.substring(openCurly + 1);
        int closeCurly = abbrev.indexOf(125);
        if (closeCurly < 0) {
            System.out.println("Error on line " + this.lineReader.getLineNumber() + ": missing '}' in view name: " + this.keyWord);
            return;
        }
        abbrev = abbrev.substring(0, closeCurly);
        View v = View.findView(fullName);
        if (v == null && (v = this.findOldViewName(fullName)) != null) {
            abbrev = v.getAbbreviation();
        }
        if (v == null) {
            v = View.newInst(fullName, abbrev);
        } else if (!v.getAbbreviation().equals(abbrev)) {
            System.out.println("Error on line " + this.lineReader.getLineNumber() + ": view " + fullName + " has abbreviation '" + abbrev + "' which does not match the existing abbreviation '" + v.getAbbreviation() + "'");
            return;
        }
    }

    private void keywordNewCel() {
        this.curCellNumber = TextUtils.atoi(this.keyWord);
        int curCellGroup = -1;
        int slashPos = this.keyWord.indexOf(47);
        if (slashPos >= 0) {
            curCellGroup = TextUtils.atoi(this.keyWord.substring(slashPos + 1));
        }
        this.cellGroups[this.curCellNumber] = curCellGroup;
        this.textLevel = 2;
        this.varPos = 4;
    }

    private void keywordCelNam() {
        this.cellNames[this.curCellNumber] = CellName.parseName(this.keyWord);
    }

    private void keywordCelVer() {
        CellName curCellName = this.cellNames[this.curCellNumber];
        this.cellNames[this.curCellNumber] = CellName.newName(curCellName.getName(), curCellName.getView(), TextUtils.atoi(this.keyWord));
    }

    private void keywordCelCre() {
        this.cellCreationDates[this.curCellNumber] = TextUtils.atoi(this.keyWord);
    }

    private void keywordCelRev() {
        this.cellRevisionDates[this.curCellNumber] = TextUtils.atoi(this.keyWord);
    }

    private void keywordCelLX() {
        this.cellLowX[this.curCellNumber] = TextUtils.atoi(this.keyWord);
    }

    private void keywordCelHX() {
        this.cellHighX[this.curCellNumber] = TextUtils.atoi(this.keyWord);
    }

    private void keywordCelLY() {
        this.cellLowY[this.curCellNumber] = TextUtils.atoi(this.keyWord);
    }

    private void keywordCelHY() {
        this.cellHighY[this.curCellNumber] = TextUtils.atoi(this.keyWord);
    }

    private void keywordCelBit() {
        this.cellUserbits[this.curCellNumber] = TextUtils.atoi(this.keyWord);
    }

    private void keywordCelUsb() {
        this.cellUserbits[this.curCellNumber] = TextUtils.atoi(this.keyWord);
    }

    private void keywordCelExt() {
        String withoutQuotes = this.keyWord;
        if (withoutQuotes.charAt(0) == '\"' && (withoutQuotes = withoutQuotes.substring(1)).endsWith("\"")) {
            withoutQuotes = withoutQuotes.substring(0, withoutQuotes.length() - 1);
        }
        this.cellLibPaths[this.curCellNumber] = withoutQuotes;
    }

    private void keywordTech() {
        this.cellTechNames[this.curCellNumber] = this.keyWord;
    }

    private void keywordCelNoC() {
        int nodeInstCount = Integer.parseInt(this.keyWord);
        if (nodeInstCount == 0) {
            return;
        }
        this.nodeProtoTypeList[this.curCellNumber] = new String[nodeInstCount];
        this.nodeInstList[this.curCellNumber] = new LibraryFiles.NodeInstList(nodeInstCount, false);
    }

    private void keywordCelArC() {
        ArcInstList ail;
        int arcInstCount = Integer.parseInt(this.keyWord);
        this.arcInstList[this.curCellNumber] = ail = new ArcInstList();
        ail.arcList = new ArcInst[arcInstCount];
        ail.arcProtoName = new String[arcInstCount];
        ail.arcProto = new ArcProto[arcInstCount];
        ail.arcInstName = new String[arcInstCount];
        ail.arcNameDescriptor = new TextDescriptor[arcInstCount];
        ail.arcWidth = new int[arcInstCount];
        ail.arcHeadNode = new int[arcInstCount];
        ail.arcHeadPort = new String[arcInstCount];
        ail.arcHeadX = new int[arcInstCount];
        ail.arcHeadY = new int[arcInstCount];
        ail.arcTailNode = new int[arcInstCount];
        ail.arcTailPort = new String[arcInstCount];
        ail.arcTailX = new int[arcInstCount];
        ail.arcTailY = new int[arcInstCount];
        ail.arcUserBits = new int[arcInstCount];
        ail.arcVars = new Variable[arcInstCount][];
    }

    private void keywordCelPtC() {
        ExportList el;
        int exportCount = Integer.parseInt(this.keyWord);
        this.exportList[this.curCellNumber] = el = new ExportList();
        el.exportList = new Export[exportCount];
        el.exportName = new String[exportCount];
        el.exportNameDescriptor = new TextDescriptor[exportCount];
        el.exportSubNode = new int[exportCount];
        el.exportSubPort = new String[exportCount];
        el.exportUserBits = new int[exportCount];
        el.exportVars = new Variable[exportCount][];
    }

    private void keywordNewNo() {
        this.curNodeInstIndex = Integer.parseInt(this.keyWord);
        this.textLevel = 4;
        this.varPos = 5;
    }

    private void keywordNodTyp() {
        this.nodeProtoTypeList[this.curCellNumber][this.curNodeInstIndex] = this.keyWord;
    }

    private void keywordNodLX() {
        this.nodeInstList[this.curCellNumber].lowX[this.curNodeInstIndex] = TextUtils.atoi(this.keyWord);
    }

    private void keywordNodHX() {
        this.nodeInstList[this.curCellNumber].highX[this.curNodeInstIndex] = TextUtils.atoi(this.keyWord);
    }

    private void keywordNodLY() {
        this.nodeInstList[this.curCellNumber].lowY[this.curNodeInstIndex] = TextUtils.atoi(this.keyWord);
    }

    private void keywordNodHY() {
        this.nodeInstList[this.curCellNumber].highY[this.curNodeInstIndex] = TextUtils.atoi(this.keyWord);
    }

    private void keywordNodNam() {
        this.nodeInstList[this.curCellNumber].name[this.curNodeInstIndex] = this.keyWord;
    }

    private void keywordNodDes() {
        int td0 = TextUtils.atoi(this.keyWord);
        int td1 = 0;
        int slashPos = this.keyWord.indexOf(47);
        if (slashPos >= 0) {
            td1 = TextUtils.atoi(this.keyWord.substring(slashPos + 1));
        }
        this.nodeInstList[this.curCellNumber].protoTextDescriptor[this.curNodeInstIndex] = this.makeDescriptor(td0, td1);
    }

    private void keywordNodRot() {
        this.nodeInstList[this.curCellNumber].rotation[this.curNodeInstIndex] = (short)Integer.parseInt(this.keyWord);
    }

    private void keywordNodTra() {
        this.nodeInstList[this.curCellNumber].transpose[this.curNodeInstIndex] = Integer.parseInt(this.keyWord);
    }

    private void keywordNodKse() {
        this.bitCount = 0;
    }

    private void keywordNodPoC() {
    }

    private void keywordNodBit() {
        if (this.bitCount == 0) {
            this.nodeInstList[this.curCellNumber].userBits[this.curNodeInstIndex] = TextUtils.atoi(this.keyWord);
        }
        ++this.bitCount;
    }

    private void keywordNodUsb() {
        this.nodeInstList[this.curCellNumber].userBits[this.curNodeInstIndex] = TextUtils.atoi(this.keyWord);
    }

    private void keywordNewPor() {
        this.textLevel = 5;
    }

    private void keywordNewAr() {
        this.curArcInstIndex = Integer.parseInt(this.keyWord);
        this.textLevel = 6;
        this.varPos = 7;
    }

    private void keywordArcTyp() {
        this.arcInstList[this.curCellNumber].arcProtoName[this.curArcInstIndex] = this.keyWord;
    }

    private void keywordArcNam() {
        this.arcInstList[this.curCellNumber].arcInstName[this.curArcInstIndex] = this.keyWord;
    }

    private void keywordArcWid() {
        this.arcInstList[this.curCellNumber].arcWidth[this.curArcInstIndex] = TextUtils.atoi(this.keyWord);
    }

    private void keywordNewEnd() {
        this.curArcEnd = Integer.parseInt(this.keyWord);
        this.textLevel = 7;
    }

    private void keywordEndNod() {
        int endIndex = TextUtils.atoi(this.keyWord);
        if (this.curArcEnd == 1) {
            this.arcInstList[this.curCellNumber].arcHeadNode[this.curArcInstIndex] = endIndex;
        } else {
            this.arcInstList[this.curCellNumber].arcTailNode[this.curArcInstIndex] = endIndex;
        }
    }

    private void keywordEndPt() {
        if (this.curArcEnd == 1) {
            this.arcInstList[this.curCellNumber].arcHeadPort[this.curArcInstIndex] = this.keyWord;
        } else {
            this.arcInstList[this.curCellNumber].arcTailPort[this.curArcInstIndex] = this.keyWord;
        }
    }

    private void keywordEndXP() {
        int x = TextUtils.atoi(this.keyWord);
        if (this.curArcEnd == 1) {
            this.arcInstList[this.curCellNumber].arcHeadX[this.curArcInstIndex] = x;
        } else {
            this.arcInstList[this.curCellNumber].arcTailX[this.curArcInstIndex] = x;
        }
    }

    private void keywordEndYP() {
        int y = TextUtils.atoi(this.keyWord);
        if (this.curArcEnd == 1) {
            this.arcInstList[this.curCellNumber].arcHeadY[this.curArcInstIndex] = y;
        } else {
            this.arcInstList[this.curCellNumber].arcTailY[this.curArcInstIndex] = y;
        }
    }

    private void keywordArcKse() {
        this.bitCount = 0;
    }

    private void keywordArcBit() {
        if (this.bitCount == 0) {
            this.arcInstList[this.curCellNumber].arcUserBits[this.curArcInstIndex] = TextUtils.atoi(this.keyWord);
        }
        ++this.bitCount;
    }

    private void keywordArcUsb() {
        this.arcInstList[this.curCellNumber].arcUserBits[this.curArcInstIndex] = TextUtils.atoi(this.keyWord);
    }

    private void keywordNewPt() {
        this.curExportIndex = Integer.parseInt(this.keyWord);
        this.textLevel = 3;
        this.varPos = 6;
    }

    private void keywordPtNam() {
        this.exportList[this.curCellNumber].exportName[this.curExportIndex] = this.keyWord;
    }

    private void keywordPtDes() {
        int td0 = TextUtils.atoi(this.keyWord);
        int td1 = 0;
        int slashPos = this.keyWord.indexOf(47);
        if (slashPos >= 0) {
            td1 = TextUtils.atoi(this.keyWord, slashPos + 1);
        }
        this.exportList[this.curCellNumber].exportNameDescriptor[this.curExportIndex] = this.makeDescriptor(td0, td1);
    }

    private void keywordPtSNo() {
        int index;
        this.exportList[this.curCellNumber].exportSubNode[this.curExportIndex] = index = Integer.parseInt(this.keyWord);
    }

    private void keywordPtSPt() {
        this.exportList[this.curCellNumber].exportSubPort[this.curExportIndex] = this.keyWord;
    }

    private void keywordPtKse() {
        this.bitCount = 0;
    }

    private void keywordPtBit() {
        if (this.bitCount == 0) {
            this.exportList[this.curCellNumber].exportUserBits[this.curExportIndex] = TextUtils.atoi(this.keyWord);
        }
        ++this.bitCount;
    }

    private void keywordPtUsb() {
        this.exportList[this.curCellNumber].exportUserBits[this.curExportIndex] = TextUtils.atoi(this.keyWord);
    }

    private void keywordGetVar() throws IOException {
        Variable[] vars = this.parseVars();
        switch (this.varPos) {
            case 5: {
                this.nodeInstList[this.curCellNumber].vars[this.curNodeInstIndex] = vars;
                for (int i2 = 0; i2 < vars.length; ++i2) {
                    Object value;
                    Variable var = vars[i2];
                    if (var == null || var.getKey() != NodeInst.NODE_NAME || !((value = var.getObject()) instanceof String)) continue;
                    this.nodeInstList[this.curCellNumber].name[this.curNodeInstIndex] = ReadableDump.convertGeomName(value, var.isDisplay());
                    this.nodeInstList[this.curCellNumber].nameTextDescriptor[this.curNodeInstIndex] = var.getTextDescriptor();
                    vars[i2] = null;
                }
                break;
            }
            case 6: {
                this.exportList[this.curCellNumber].exportVars[this.curExportIndex] = vars;
                break;
            }
            case 7: {
                this.arcInstList[this.curCellNumber].arcVars[this.curArcInstIndex] = vars;
                for (int i3 = 0; i3 < vars.length; ++i3) {
                    Object value;
                    Variable var = vars[i3];
                    if (var == null || var.getKey() != ArcInst.ARC_NAME || !((value = var.getObject()) instanceof String)) continue;
                    this.arcInstList[this.curCellNumber].arcInstName[this.curArcInstIndex] = ReadableDump.convertGeomName(value, var.isDisplay());
                    this.arcInstList[this.curCellNumber].arcNameDescriptor[this.curArcInstIndex] = var.getTextDescriptor();
                    vars[i3] = null;
                }
                break;
            }
            case 1: {
                this.realizeMeaningPrefs(this.curTool, vars);
                break;
            }
            case 2: {
                this.realizeMeaningPrefs(this.curTech, vars);
                break;
            }
            case 3: {
                for (int i4 = 0; i4 < vars.length; ++i4) {
                    Object value;
                    Variable var = vars[i4];
                    if (var == null || var.getKey() != Library.FONT_ASSOCIATIONS || !((value = var.getObject()) instanceof String[])) continue;
                    this.setFontNames((String[])value);
                    vars[i4] = null;
                }
                this.libVars = vars;
                break;
            }
            case 4: {
                this.cellVars[this.curCellNumber] = vars;
            }
        }
    }

    private Variable[] parseVars() throws IOException {
        int count = Integer.parseInt(this.keyWord);
        if (count <= 0) {
            return Variable.NULL_ARRAY;
        }
        Variable[] vars = new Variable[count];
        for (int i2 = 0; i2 < count; ++i2) {
            Object[] value;
            CodeExpression.Code code;
            TextDescriptor td;
            Object varName;
            block42: {
                int type;
                int len;
                block41: {
                    int openSquarePos;
                    if (this.getKeyword()) {
                        System.out.println("EOF too soon");
                        return vars;
                    }
                    varName = "";
                    len = this.keyWord.length();
                    if (this.keyWord.charAt(len - 1) != ':') {
                        System.out.println("Error on line " + this.lineReader.getLineNumber() + ": missing colon in variable specification: " + this.keyWord);
                        return vars;
                    }
                    for (int j2 = 0; j2 < len; ++j2) {
                        char cat = this.keyWord.charAt(j2);
                        if (cat == '^' && j2 < len - 1) {
                            varName = (String)varName + this.keyWord.charAt(++j2);
                            continue;
                        }
                        if (cat == '(' || cat == '[' || cat == ':') break;
                        varName = (String)varName + cat;
                    }
                    if ((openSquarePos = this.keyWord.lastIndexOf(91)) < 0) {
                        System.out.println("Error on line " + this.lineReader.getLineNumber() + ": missing type information in variable: " + this.keyWord);
                        return vars;
                    }
                    type = TextUtils.atoi(this.keyWord, openSquarePos + 1);
                    int commaPos = this.keyWord.indexOf(44);
                    int td0 = 0;
                    int td1 = 0;
                    if (commaPos >= 0) {
                        td0 = TextUtils.atoi(this.keyWord, commaPos + 1);
                        td1 = 0;
                        int slashPos = this.keyWord.indexOf(47);
                        if (slashPos >= 0) {
                            td1 = TextUtils.atoi(this.keyWord, slashPos + 1);
                        }
                    }
                    td = this.makeDescriptor(td0, td1, type);
                    code = CodeExpression.Code.getByCBits(type);
                    if (this.getKeyword()) {
                        System.out.println("EOF too soon");
                        return vars;
                    }
                    value = null;
                    if ((type & 0x80) != 0) break block41;
                    value = this.variableDecode(this.keyWord, type);
                    break block42;
                }
                if (this.keyWord.charAt(0) != '[') {
                    System.out.println("Error on line " + this.lineReader.getLineNumber() + ": missing '[' in list of variable values: " + this.keyWord);
                    return vars;
                }
                ArrayList<Object> al = new ArrayList<Object>();
                int pos = 1;
                len = this.keyWord.length();
                while (true) {
                    int start;
                    block44: {
                        block43: {
                            start = ++pos;
                            if ((type & 0x1F) != 4) break block43;
                            while (this.keyWord.charAt(pos) != '\"' && pos < len - 1) {
                                ++pos;
                            }
                            start = pos;
                            if (pos >= len) break block44;
                            ++pos;
                            while (true) {
                                if (this.keyWord.charAt(pos) == '^' && pos < len - 1) {
                                    pos += 2;
                                    continue;
                                }
                                if (this.keyWord.charAt(pos) == '\"' || pos == len - 1) break;
                                ++pos;
                            }
                            if (pos >= len) break block44;
                            ++pos;
                            break block44;
                        }
                        while (this.keyWord.charAt(pos) != ',' && this.keyWord.charAt(pos) != ']' && pos < len) {
                            ++pos;
                        }
                    }
                    if (pos >= len) {
                        System.out.println("Error on line " + this.lineReader.getLineNumber() + ": array too short in variable values: " + this.keyWord);
                        return vars;
                    }
                    String entry = this.keyWord.substring(start, pos);
                    al.add(this.variableDecode(entry, type));
                    if (this.keyWord.charAt(pos) == ']') break;
                    if (this.keyWord.charAt(pos) == ',') continue;
                    System.out.println("Error on line " + this.lineReader.getLineNumber() + ": missing comma between array entries: " + this.keyWord);
                    return vars;
                }
                int arrayLen = al.size();
                switch (type & 0x1F) {
                    case 1: 
                    case 2: {
                        value = new Integer[arrayLen];
                        break;
                    }
                    case 5: 
                    case 19: {
                        value = new Float[arrayLen];
                        break;
                    }
                    case 6: {
                        value = new Double[arrayLen];
                        break;
                    }
                    case 25: {
                        value = new Short[arrayLen];
                        break;
                    }
                    case 30: {
                        value = new Boolean[arrayLen];
                        break;
                    }
                    case 3: {
                        value = new Byte[arrayLen];
                        break;
                    }
                    case 4: {
                        value = new String[arrayLen];
                        break;
                    }
                    case 8: {
                        value = new NodeProtoId[arrayLen];
                        break;
                    }
                    case 13: {
                        value = new ArcProtoId[arrayLen];
                        break;
                    }
                    case 11: {
                        value = new ExportId[arrayLen];
                        break;
                    }
                    case 16: {
                        value = new TechId[arrayLen];
                        break;
                    }
                    case 15: {
                        value = new LibId[arrayLen];
                        break;
                    }
                    case 17: {
                        value = new Tool[arrayLen];
                    }
                }
                if (value != null) {
                    for (int j3 = 0; j3 < arrayLen; ++j3) {
                        value[j3] = al.get(j3);
                    }
                }
                if (value instanceof NodeProtoId[]) {
                    NodeProtoId[] newAddrArray = (NodeProtoId[])value;
                    int numCells = 0;
                    int numPrims = 0;
                    for (int j4 = 0; j4 < newAddrArray.length; ++j4) {
                        if (newAddrArray[j4] == null) continue;
                        if (newAddrArray[j4] instanceof CellId) {
                            ++numCells;
                        }
                        if (!(newAddrArray[j4] instanceof PrimitiveNodeId)) continue;
                        ++numPrims;
                    }
                    if (numCells >= numPrims) {
                        CellId[] cellArray = new CellId[newAddrArray.length];
                        for (j = 0; j < cellArray.length; ++j) {
                            if (!(newAddrArray[j] instanceof CellId)) continue;
                            cellArray[j] = (CellId)newAddrArray[j];
                        }
                        value = cellArray;
                    } else {
                        PrimitiveNodeId[] primArray = new PrimitiveNodeId[newAddrArray.length];
                        for (j = 0; j < primArray.length; ++j) {
                            if (!(newAddrArray[j] instanceof PrimitiveNodeId)) continue;
                            primArray[j] = (PrimitiveNodeId)newAddrArray[j];
                        }
                        value = primArray;
                    }
                }
            }
            if (value == null) continue;
            value = Variable.withCode(value, code);
            vars[i2] = Variable.newInst(Variable.newKey((String)varName), value, td);
        }
        return vars;
    }

    private Object variableDecode(String name, int type) {
        int thistype = type;
        if ((thistype & 0x20000020) != 0) {
            thistype = 4;
        }
        switch (thistype & 0x1F) {
            case 1: 
            case 2: {
                return TextUtils.atoi(name);
            }
            case 25: {
                return (short)TextUtils.atoi(name);
            }
            case 30: {
                return TextUtils.atoi(name) != 0;
            }
            case 19: {
                return Float.valueOf((float)TextUtils.atoi(name) / 120.0f);
            }
            case 3: {
                return (byte)name.charAt(0);
            }
            case 4: {
                char[] letters = new char[name.length()];
                int outpos = 0;
                int inpos = 0;
                if (name.charAt(inpos) == '\"') {
                    ++inpos;
                }
                while (inpos < name.length()) {
                    if (name.charAt(inpos) == '^' && inpos < name.length() - 1) {
                        letters[outpos++] = name.charAt(++inpos);
                    } else {
                        if (name.charAt(inpos) == '\"') break;
                        letters[outpos++] = name.charAt(inpos);
                    }
                    ++inpos;
                }
                return new String(letters, 0, outpos);
            }
            case 5: {
                return Float.valueOf(Float.parseFloat(name));
            }
            case 6: {
                return Double.parseDouble(name);
            }
            case 15: {
                if (name.length() == 0) {
                    return null;
                }
                if (name.charAt(0) == '\"') {
                    name = name.substring(1, name.length() - 1);
                }
                return this.idManager.newLibId(name);
            }
            case 8: {
                int colonPos = name.indexOf(58);
                if (colonPos < 0) {
                    int cindex = Integer.parseInt(name);
                    return this.allCellsArray[cindex] != null ? this.allCellsArray[cindex].getId() : null;
                }
                return this.idManager.newTechId(name.substring(0, colonPos)).newPrimitiveNodeId(name.substring(colonPos + 1));
            }
            case 11: {
                int ppIndex = TextUtils.atoi(name);
                Export pp = this.exportList[this.curCellNumber].exportList[ppIndex];
                if (!(pp instanceof Export)) {
                    return null;
                }
                return pp.getId();
            }
            case 13: {
                int colon = name.indexOf(58);
                if (colon < 0) {
                    System.out.println("Error on line " + this.lineReader.getLineNumber() + ": cannot find arc " + name);
                    return null;
                }
                return this.idManager.newTechId(name.substring(0, colon)).newArcProtoId(name.substring(colon + 1));
            }
            case 16: {
                return this.idManager.newTechId(name);
            }
            case 17: {
                return Tool.findTool(name);
            }
        }
        return null;
    }

    private static class ArcInstList {
        private ArcInst[] arcList;
        private String[] arcProtoName;
        private ArcProto[] arcProto;
        private String[] arcInstName;
        private TextDescriptor[] arcNameDescriptor;
        private int[] arcWidth;
        private int[] arcHeadNode;
        private String[] arcHeadPort;
        private int[] arcHeadX;
        private int[] arcHeadY;
        private int[] arcTailNode;
        private String[] arcTailPort;
        private int[] arcTailX;
        private int[] arcTailY;
        private int[] arcUserBits;
        private Variable[][] arcVars;

        private ArcInstList() {
        }
    }

    private static class ExportList {
        private Export[] exportList;
        private String[] exportName;
        private TextDescriptor[] exportNameDescriptor;
        private int[] exportSubNode;
        private String[] exportSubPort;
        private int[] exportUserBits;
        private Variable[][] exportVars;

        private ExportList() {
        }
    }
}

