/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.simulation.MutableSignal;
import com.sun.electric.tool.simulation.ScalarSample;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.simulation.SweptSample;
import com.sun.electric.util.TextUtils;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class RawSpiceOut
extends Input<Stimuli> {
    private static final boolean DEBUG = false;
    private boolean complexValues;

    RawSpiceOut() {
        super(null);
    }

    @Override
    protected Stimuli processInput(URL fileURL, Cell cell, Stimuli sd) throws IOException {
        sd.setNetDelimiter(" ");
        if (this.openBinaryInput(fileURL)) {
            return sd;
        }
        boolean newRawLTspice = SimulationTool.isSpiceUseNewerLTSpice();
        System.out.println("Reading Spice3/NGSpice/" + (newRawLTspice ? "LTSpiceXVII" : "LTSpiceIV") + "/SmartSpice raw output file: " + fileURL.getFile());
        RawSpiceOut.startProgressDialog("LTSpice output", fileURL.getFile());
        sd = this.readRawSpice3File(cell, sd, newRawLTspice);
        RawSpiceOut.stopProgressDialog();
        this.closeInput();
        return sd;
    }

    private Stimuli readRawSpice3File(Cell cell, Stimuli sd, boolean newRawLTspice) throws IOException {
        String line;
        this.complexValues = false;
        boolean realValues = false;
        int signalCount = -1;
        boolean firstFieldIsTime = false;
        String[] signalNames = null;
        int rowCount = -1;
        boolean isLTSpice = false;
        boolean first = true;
        sd.setCell(cell);
        SignalCollection sc = null;
        double[] time = null;
        while ((line = this.getLineFromBinary()) != null) {
            int i2;
            String name;
            int colonPos;
            this.updateProgressDialog(line.length());
            if (newRawLTspice) {
                line = new String(line.getBytes(), "UTF-16");
            }
            if (first) {
                String hsFormat;
                first = false;
                if (line.length() >= 20 && ((hsFormat = line.substring(16, 20)).equals("9007") || hsFormat.equals("9601"))) {
                    System.out.println("This is an HSPICE file, not a RAWFILE file");
                    System.out.println("Change the SPICE format (in Preferences) and reread");
                    return null;
                }
            }
            if ((colonPos = line.indexOf(58)) < 0) continue;
            String keyWord = line.substring(0, colonPos);
            String restOfLine = line.substring(colonPos + 1).trim();
            if (keyWord.equals("Command")) {
                isLTSpice = restOfLine.indexOf("LTspice") != -1;
                continue;
            }
            if (keyWord.equals("Plotname")) {
                if (sc != null) {
                    signalCount = -1;
                    rowCount = -1;
                    signalNames = null;
                }
                if (restOfLine.startsWith("Transient Analysis")) {
                    sc = Stimuli.newSignalCollection(sd, "TRANS SIGNALS");
                    continue;
                }
                if (restOfLine.startsWith("DC ")) {
                    sc = Stimuli.newSignalCollection(sd, "DC SIGNALS");
                    continue;
                }
                if (restOfLine.startsWith("AC ")) {
                    sc = Stimuli.newSignalCollection(sd, "AC SIGNALS");
                    continue;
                }
                if (restOfLine.startsWith("Operating ")) {
                    sc = Stimuli.newSignalCollection(sd, "OPERATING POINT");
                    continue;
                }
                System.out.println("Warning: unknown analysis: " + restOfLine);
                sc = Stimuli.newSignalCollection(sd, "TRANS SIGNALS");
                continue;
            }
            if (keyWord.equals("Flags")) {
                int r;
                int complex = restOfLine.indexOf("complex");
                if (complex >= 0) {
                    this.complexValues = true;
                }
                if ((r = restOfLine.indexOf("real")) < 0) continue;
                realValues = true;
                continue;
            }
            if (keyWord.equals("No. Variables")) {
                signalCount = TextUtils.atoi(restOfLine);
                continue;
            }
            if (keyWord.equals("No. Points")) {
                rowCount = TextUtils.atoi(restOfLine);
                time = new double[rowCount];
                continue;
            }
            if (!isLTSpice) {
                int j2;
                int i3;
                if (keyWord.equals("Variables")) {
                    if (signalCount < 0) {
                        System.out.println("Missing variable count in file");
                        return null;
                    }
                    signalNames = new String[signalCount];
                    int trueSignalCount = 0;
                    for (i3 = 0; i3 < signalCount; ++i3) {
                        int pos;
                        int tabPos;
                        int spacePos;
                        if (restOfLine.length() > 0) {
                            line = restOfLine;
                            restOfLine = "";
                        } else {
                            line = this.getLineAndUpdateProgressBinary();
                            if (line == null) {
                                System.out.println("Error: end of file during signal names");
                                return null;
                            }
                        }
                        line = line.trim();
                        int numberOnLine = TextUtils.atoi(line);
                        if (numberOnLine != i3) {
                            System.out.println("Warning: Variable " + i3 + " has number " + numberOnLine);
                        }
                        if ((spacePos = line.indexOf(" ")) < 0) {
                            spacePos = line.length();
                        }
                        if ((tabPos = line.indexOf("\t")) < 0) {
                            tabPos = line.length();
                        }
                        if ((spacePos = (name = line.substring(pos = Math.min(spacePos, tabPos)).trim()).indexOf(" ")) < 0) {
                            spacePos = name.length();
                        }
                        if ((tabPos = name.indexOf("\t")) < 0) {
                            tabPos = name.length();
                        }
                        pos = Math.min(spacePos, tabPos);
                        name = name.substring(0, pos);
                        if (i3 == 0 && name.equals("time")) {
                            firstFieldIsTime = true;
                            continue;
                        }
                        signalNames[trueSignalCount++] = name;
                    }
                    signalCount = trueSignalCount;
                    continue;
                }
                if (keyWord.equals("Values")) {
                    if (signalCount < 0) {
                        System.out.println("Missing variable count in file");
                        return null;
                    }
                    if (rowCount < 0) {
                        System.out.println("Missing point count in file");
                        return null;
                    }
                    if (rowCount == 0) {
                        System.out.println("No points in file");
                        return null;
                    }
                    double[][] values = new double[signalCount][rowCount];
                    for (j2 = 0; j2 < rowCount; ++j2) {
                        int valueFill = 0;
                        int valuesToRead = signalCount;
                        if (firstFieldIsTime) {
                            ++valuesToRead;
                        } else {
                            time[j2] = j2;
                        }
                        int i4 = -1;
                        block3: while (i4 < valuesToRead) {
                            line = this.getLineAndUpdateProgressBinary();
                            if (line == null) {
                                System.out.println("Error: end of file during data points (read " + j2 + " out of " + rowCount);
                                return null;
                            }
                            if ((line = line.trim()).length() == 0) continue;
                            int charPos = 0;
                            while (charPos <= line.length()) {
                                int tabPos = line.indexOf("\t", charPos);
                                if (tabPos < 0) {
                                    tabPos = line.length();
                                }
                                String field = line.substring(charPos, tabPos);
                                for (charPos = tabPos + 1; charPos < line.length() && line.charAt(charPos) == '\t'; ++charPos) {
                                }
                                if (i4 < 0) {
                                    int lineNumber = TextUtils.atoi(field);
                                    if (lineNumber != j2) {
                                        System.out.println("Warning: event " + j2 + " has wrong event number: " + lineNumber);
                                    }
                                } else {
                                    double val = TextUtils.atof(field);
                                    if (i4 == 0 && firstFieldIsTime) {
                                        time[j2] = val;
                                    } else {
                                        values[valueFill++][j2] = val;
                                    }
                                }
                                if (++i4 < valuesToRead) continue;
                                continue block3;
                            }
                        }
                    }
                    for (i3 = 0; i3 < signalCount; ++i3) {
                        ScalarSample.createSignal(sc, sd, signalNames[i3], null, time, values[i3]);
                    }
                    continue;
                }
                if (!keyWord.equals("Binary")) continue;
                if (signalCount < 0) {
                    System.out.println("Missing variable count in file");
                    return null;
                }
                if (rowCount < 0) {
                    System.out.println("Missing point count in file");
                    return null;
                }
                if (rowCount == 0) {
                    System.out.println("No points in file");
                    return null;
                }
                double[][] values = new double[signalCount][rowCount];
                for (j2 = 0; j2 < rowCount; ++j2) {
                    time[j2] = this.getNextDouble();
                    for (i2 = 0; i2 < signalCount; ++i2) {
                        values[i2][j2] = this.getNextDouble();
                    }
                }
                for (i3 = 0; i3 < signalCount; ++i3) {
                    ScalarSample.createSignal(sc, sd, signalNames[i3], null, time, values[i3]);
                }
                continue;
            }
            boolean OLD = true;
            if (OLD) {
                firstFieldIsTime = true;
            }
            if (keyWord.equals("Variables")) {
                if (signalCount < 0) {
                    System.out.println("Missing variable count in file");
                    return null;
                }
                signalNames = new String[signalCount];
                int trueSignalCount = 0;
                for (i2 = 0; i2 < signalCount && (restOfLine = this.getLineFromBinary()) != null; ++i2) {
                    int nameEnd;
                    int nameStart;
                    int indexOnLine;
                    this.updateProgressDialog(restOfLine.length());
                    if (newRawLTspice) {
                        restOfLine = new String(restOfLine.getBytes(), "UTF-16");
                    }
                    if ((indexOnLine = TextUtils.atoi(restOfLine = restOfLine.trim())) != i2) {
                        System.out.println("Warning: Variable " + i2 + " has number " + indexOnLine);
                    }
                    for (nameStart = 0; nameStart < restOfLine.length() && !Character.isWhitespace(restOfLine.charAt(nameStart)); ++nameStart) {
                    }
                    while (nameStart < restOfLine.length() && Character.isWhitespace(restOfLine.charAt(nameStart))) {
                        ++nameStart;
                    }
                    for (nameEnd = nameStart; nameEnd < restOfLine.length() && !Character.isWhitespace(restOfLine.charAt(nameEnd)); ++nameEnd) {
                    }
                    name = restOfLine.substring(nameStart, nameEnd);
                    if (name.startsWith("V(") && name.endsWith(")")) {
                        name = name.substring(2, name.length() - 1);
                    }
                    if (i2 == 0) {
                        if (OLD) continue;
                        if (name.equals("time")) {
                            firstFieldIsTime = true;
                            continue;
                        }
                    }
                    signalNames[trueSignalCount++] = name;
                }
                signalCount = trueSignalCount;
                continue;
            }
            if (!keyWord.equals("Binary")) continue;
            if (signalCount < 0) {
                System.out.println("Missing variable count in file");
                return null;
            }
            if (rowCount < 0) {
                System.out.println("Missing point count in file");
                return null;
            }
            if (rowCount == 0) {
                System.out.println("No points in file");
                return null;
            }
            if (newRawLTspice) {
                int c2 = this.dataInputStream.read();
                this.updateProgressDialog(Integer.toString(c2).length());
            }
            double[][] values = new double[signalCount][rowCount];
            time = new double[rowCount];
            for (int j3 = 0; j3 < rowCount; ++j3) {
                double t = j3;
                if (firstFieldIsTime) {
                    t = this.getNextDouble();
                }
                time[j3] = Math.abs(t);
                for (int i5 = 0; i5 < signalCount; ++i5) {
                    double value = 0.0;
                    value = realValues ? (double)this.getNextFloat() : this.getNextDouble();
                    values[i5][j3] = value;
                }
            }
            ArrayList<Integer> sweepLengths = new ArrayList<Integer>();
            int sweepStart = 0;
            int sweepCount = 0;
            for (int j4 = 1; j4 <= rowCount; ++j4) {
                if (j4 != rowCount && !(time[j4] < time[j4 - 1])) continue;
                int sl = j4 - sweepStart;
                sweepLengths.add(sl);
                sweepStart = j4;
                ++sweepCount;
            }
            Signal[][] signals = new Signal[signalCount][sweepCount];
            for (int i6 = 0; i6 < signalCount; ++i6) {
                String name2 = signalNames[i6];
                int lastDotPos = name2.lastIndexOf(46);
                String context = null;
                if (lastDotPos >= 0) {
                    context = name2.substring(0, lastDotPos);
                    name2 = name2.substring(lastDotPos + 1);
                }
                for (int s = 0; s < sweepCount; ++s) {
                    signals[i6][s] = ScalarSample.createSignal(sc, sd, name2, context);
                }
            }
            int offset = 0;
            for (int s = 0; s < sweepCount; ++s) {
                int sweepLength = (Integer)sweepLengths.get(s);
                for (int i7 = 0; i7 < signalCount; ++i7) {
                    MutableSignal ms = (MutableSignal)signals[i7][s];
                    for (int j5 = 0; j5 < sweepLength; ++j5) {
                        ms.addSample(time[j5 + offset], new ScalarSample(values[i7][j5 + offset]));
                    }
                }
                offset += sweepLength;
            }
            String[] sweepNames = new String[sweepCount];
            for (int s = 0; s < sweepCount; ++s) {
                sweepNames[s] = "" + (s + 1);
            }
            for (int i8 = 0; i8 < signalCount; ++i8) {
                String name3 = signalNames[i8];
                int lastDotPos = name3.lastIndexOf(46);
                String context = null;
                if (lastDotPos >= 0) {
                    context = name3.substring(0, lastDotPos);
                    name3 = name3.substring(lastDotPos + 1);
                }
                SweptSample.createSignal(sc, sd, name3, context, false, signals[i8]);
            }
            sc.setSweepNames(sweepNames);
            return sd;
        }
        return sd;
    }

    private double getNextDouble() throws IOException {
        long lt = this.dataInputStream.readLong();
        if (ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN) {
            lt = Long.reverseBytes(lt);
        }
        double t = Double.longBitsToDouble(lt);
        int amtRead = 8;
        if (this.complexValues) {
            amtRead *= 2;
            this.dataInputStream.readLong();
        }
        this.updateProgressDialog(amtRead);
        return t;
    }

    private float getNextFloat() throws IOException {
        int lt = this.dataInputStream.readInt();
        if (ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN) {
            lt = Integer.reverseBytes(lt);
        }
        float t = Float.intBitsToFloat(lt);
        int amtRead = 4;
        if (this.complexValues) {
            amtRead *= 2;
            this.dataInputStream.readInt();
        }
        this.updateProgressDialog(amtRead);
        return t;
    }
}

