/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.simulation.ComplexSample;
import com.sun.electric.tool.simulation.MutableSignal;
import com.sun.electric.tool.simulation.ScalarSample;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.simulation.SweptSample;
import com.sun.electric.util.TextUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class HSpiceOut
extends Input<Stimuli> {
    private static final boolean DEBUGCONDITIONS = false;
    private static final int BINARYBUFFERSIZE = 8192;
    private boolean isTRACDCBinary;
    private boolean isTRACDCBinarySwapped;
    private String fileBase;
    private List<String> trFiles;
    private String swExtension;
    private String icExtension;
    private String acExtension;
    private String mtExtension;
    private String paExtension;
    private String[] signalNames;
    private Signal<?>[][] allSignals;
    private String[] sweepNames;
    private int binaryTRACDCSize;
    private int binaryTRACDCPosition;
    private boolean eofReached;
    private byte[] binaryTRACDCBuffer;

    HSpiceOut() {
        super(null);
    }

    @Override
    protected Stimuli processInput(URL fileURL, Cell cell, Stimuli sd) throws IOException {
        this.trFiles = new ArrayList<String>();
        String fileNameNoPath = TextUtils.getFileNameWithoutExtension(TextUtils.URLtoString(fileURL)) + ".tr";
        String topDirName = TextUtils.getFilePath(fileURL);
        File topDir = new File(topDirName);
        String[] fileList = topDir.list();
        for (int i2 = 0; i2 < fileList.length; ++i2) {
            if (!fileList[i2].startsWith(fileNameNoPath)) continue;
            this.trFiles.add(topDirName + fileList[i2]);
        }
        Collections.sort(this.trFiles, TextUtils.STRING_NUMBER_ORDER);
        if (this.trFiles.size() > 1) {
            System.out.println("Reading " + this.trFiles.size() + " 'tr' files...");
        }
        this.swExtension = "sw0";
        this.icExtension = "ic0";
        this.acExtension = "ac0";
        this.mtExtension = "mt0";
        this.paExtension = "pa0";
        this.fileBase = fileURL.getFile();
        int dotPos = this.fileBase.lastIndexOf(46);
        if (dotPos > 0) {
            String extension = this.fileBase.substring(dotPos + 1);
            this.fileBase = this.fileBase.substring(0, dotPos);
            if (extension.startsWith("sw") || extension.startsWith("ic") || extension.startsWith("ac") || extension.startsWith("mt") || extension.startsWith("pa")) {
                this.swExtension = "sw" + extension.substring(2);
                this.icExtension = "ic" + extension.substring(2);
                this.acExtension = "ac" + extension.substring(2);
                this.mtExtension = "mt" + extension.substring(2);
                this.paExtension = "pa" + extension.substring(2);
            }
        }
        List<PALine> paList = this.readPAFile(fileURL);
        this.addTRData(sd, paList, fileURL);
        this.addDCData(sd, paList, fileURL);
        this.addACData(sd, paList, fileURL);
        this.addMeasurementData(sd, fileURL);
        return sd;
    }

    private void addMeasurementData(Stimuli sd, URL fileURL) throws IOException {
        List mData;
        String nextLine;
        URL mtURL = null;
        try {
            mtURL = new URI(fileURL.getProtocol(), null, fileURL.getHost(), fileURL.getPort(), this.fileBase + "." + this.mtExtension, null, null).toURL();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mtURL == null) {
            return;
        }
        if (!TextUtils.URLExists(mtURL)) {
            return;
        }
        if (this.openTextInput(mtURL)) {
            return;
        }
        System.out.println("Reading HSpice measurements file: " + mtURL.getFile());
        SignalCollection sc = Stimuli.newSignalCollection(sd, "MEASUREMENTS");
        ArrayList<String> measurementNames = new ArrayList<String>();
        HashMap measurementData = new HashMap();
        String lastLine = null;
        while ((nextLine = lastLine) != null || (nextLine = this.lineReader.readLine()) != null) {
            String mName;
            int i2;
            if (nextLine.startsWith("$") || nextLine.startsWith(".")) continue;
            String[] keywords = this.breakMTLine(nextLine, false);
            if (keywords.length == 0) break;
            if (measurementNames.size() == 0) {
                int i3;
                for (i3 = 0; i3 < keywords.length; ++i3) {
                    measurementNames.add(keywords[i3]);
                }
                while ((lastLine = this.lineReader.readLine()) != null) {
                    keywords = this.breakMTLine(lastLine, true);
                    if (keywords.length == 0) {
                        lastLine = null;
                        break;
                    }
                    if (TextUtils.isANumber(keywords[0])) break;
                    for (i3 = 0; i3 < keywords.length; ++i3) {
                        if (keywords[i3].length() <= 0) continue;
                        measurementNames.add(keywords[i3]);
                    }
                }
                for (String mName2 : measurementNames) {
                    measurementData.put(mName2, new ArrayList());
                }
                continue;
            }
            int index = 0;
            for (i2 = 0; i2 < keywords.length; ++i2) {
                if (keywords[i2].length() == 0) continue;
                mName = (String)measurementNames.get(index++);
                mData = (List)measurementData.get(mName);
                mData.add(TextUtils.atof(keywords[i2]));
            }
            while (index < measurementNames.size() && (lastLine = this.lineReader.readLine()) != null && (keywords = this.breakMTLine(lastLine, true)).length != 0) {
                for (i2 = 0; i2 < keywords.length; ++i2) {
                    if (keywords[i2].length() == 0) continue;
                    mName = (String)measurementNames.get(index++);
                    mData = (List)measurementData.get(mName);
                    mData.add(TextUtils.atof(keywords[i2]));
                }
            }
            lastLine = null;
        }
        List argMeas = (List)measurementData.get(measurementNames.get(0));
        double[] time = new double[argMeas.size()];
        for (int i4 = 0; i4 < argMeas.size(); ++i4) {
            time[i4] = (Double)argMeas.get(i4);
        }
        ArrayList<MutableSignal<ScalarSample>> measData = new ArrayList<MutableSignal<ScalarSample>>();
        for (String mName : measurementNames) {
            mData = (List)measurementData.get(mName);
            double[] values = new double[mData.size()];
            for (int i5 = 0; i5 < mData.size(); ++i5) {
                values[i5] = (Double)mData.get(i5);
            }
            if (mName.equals("alter#")) {
                mName = "alter";
            }
            MutableSignal<ScalarSample> as = ScalarSample.createSignal(sc, sd, mName, null, time, values);
            measData.add(as);
        }
        this.closeInput();
    }

    private String[] breakMTLine(String line, boolean continuation) {
        ArrayList<String> strings = new ArrayList<String>();
        int i2 = 1;
        while (line.length() > i2 + 1) {
            int end = i2 + 17;
            if (end > line.length()) {
                end = line.length();
            }
            while (end < line.length() && line.charAt(end - 1) != ' ') {
                ++end;
            }
            String part = line.substring(i2, end).trim();
            if (part.length() > 0) {
                strings.add(part.trim());
            }
            i2 = end;
        }
        int actualSize = strings.size();
        String[] retVal = new String[actualSize];
        for (int i3 = 0; i3 < actualSize; ++i3) {
            retVal[i3] = (String)strings.get(i3);
        }
        return retVal;
    }

    private void addTRData(Stimuli sd, List<PALine> paList, URL fileURL) throws IOException {
        int numFiles = this.trFiles.size();
        for (int i2 = 0; i2 < numFiles; ++i2) {
            String trFile = this.trFiles.get(i2);
            URL trURL = null;
            try {
                trURL = new URI(fileURL.getProtocol(), null, fileURL.getHost(), fileURL.getPort(), trFile, null, null).toURL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (trURL == null) {
                return;
            }
            if (!TextUtils.URLExists(trURL)) {
                return;
            }
            this.readTRDCACFile(sd, trURL, paList, "TRANS SIGNALS", i2, numFiles);
        }
    }

    private void addDCData(Stimuli sd, List<PALine> paList, URL fileURL) throws IOException {
        URL swURL = null;
        try {
            swURL = new URI(fileURL.getProtocol(), null, fileURL.getHost(), fileURL.getPort(), this.fileBase + "." + this.swExtension, null, null).toURL();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (swURL != null && TextUtils.URLExists(swURL)) {
            this.readTRDCACFile(sd, swURL, paList, "DC SIGNALS", 0, 1);
            return;
        }
        URL icURL = null;
        try {
            icURL = new URI(fileURL.getProtocol(), null, fileURL.getHost(), fileURL.getPort(), this.fileBase + "." + this.icExtension, null, null).toURL();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (icURL != null && TextUtils.URLExists(icURL)) {
            System.out.println("WARNING: Cannot read old DC format file (." + this.icExtension + ")...must provide new format (." + this.swExtension + "): " + this.fileBase + "." + this.icExtension);
            return;
        }
    }

    private void addACData(Stimuli sd, List<PALine> paList, URL fileURL) throws IOException {
        URL acURL = null;
        try {
            acURL = new URI(fileURL.getProtocol(), null, fileURL.getHost(), fileURL.getPort(), this.fileBase + "." + this.acExtension, null, null).toURL();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (acURL == null) {
            return;
        }
        if (!TextUtils.URLExists(acURL)) {
            return;
        }
        this.readTRDCACFile(sd, acURL, paList, "AC SIGNALS", 0, 1);
    }

    private List<PALine> readPAFile(URL fileURL) throws IOException {
        String nextLine;
        URL paURL = null;
        try {
            paURL = new URI(fileURL.getProtocol(), null, fileURL.getHost(), fileURL.getPort(), this.fileBase + "." + this.paExtension, null, null).toURL();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (paURL == null) {
            return null;
        }
        if (!TextUtils.URLExists(paURL)) {
            return null;
        }
        if (this.openTextInput(paURL)) {
            return null;
        }
        ArrayList<PALine> paList = new ArrayList<PALine>();
        while ((nextLine = this.lineReader.readLine()) != null) {
            String trimLine = nextLine.trim();
            int spacePos = trimLine.indexOf(32);
            if (spacePos <= 0) continue;
            PALine pl = new PALine();
            pl.number = TextUtils.atoi(trimLine, 0, 10);
            pl.string = HSpiceOut.removeLeadingX(trimLine.substring(spacePos + 1).trim());
            paList.add(pl);
        }
        this.closeInput();
        return paList;
    }

    private void readTRDCACFile(Stimuli sd, URL fileURL, List<PALine> paList, String analysisTitle, int fileNum, int numFiles) throws IOException {
        int sweepsThisFile;
        int i2;
        int l2;
        int j2;
        int k2;
        int k3;
        int j3;
        SignalCollection sc;
        if (this.openBinaryInput(fileURL)) {
            return;
        }
        this.eofReached = false;
        this.resetBinaryTRACDCReader();
        if (fileNum == 0) {
            sc = Stimuli.newSignalCollection(sd, analysisTitle);
        } else {
            sc = sd.findSignalCollection(analysisTitle);
            if (sc == null) {
                return;
            }
        }
        HSpiceOut.startProgressDialog("HSpice " + analysisTitle + " analysis", fileURL.getFile());
        if (fileNum == 0) {
            System.out.println("Reading HSpice " + analysisTitle + " file: " + fileURL.getFile());
        } else {
            System.out.println("Also reading file: " + fileURL.getFile());
        }
        int nodcnt = this.getHSpiceInt();
        if (!this.isTRACDCBinary) {
            this.closeInput();
            if (this.openTextInput(fileURL)) {
                return;
            }
            this.eofReached = false;
            this.resetBinaryTRACDCReader();
            int nodcntTxt = this.getHSpiceInt();
            if (nodcnt != nodcntTxt) {
                System.out.println("WARNING: Binary interpretation saw " + nodcnt + " nodes but text sees " + nodcntTxt);
            }
        }
        int numnoi = this.getHSpiceInt();
        int cndcnt = this.getHSpiceInt();
        StringBuffer line = new StringBuffer();
        for (int j4 = 0; j4 < 4; ++j4) {
            line.append((char)this.getByteFromFile());
        }
        int multiplier = TextUtils.atoi(line.toString(), 0, 10);
        int numSignals = numnoi + (nodcnt += multiplier * 10000) - 1;
        if (numSignals <= 0) {
            System.out.println("Error reading " + fileURL.getFile());
            this.closeInput();
            HSpiceOut.stopProgressDialog();
            return;
        }
        int version = this.getHSpiceInt();
        if (version != 9007 && version != 9601) {
            System.out.println("Warning: may not be able to read HSpice files of type " + version);
        }
        line = new StringBuffer();
        for (j3 = 0; j3 < 76; ++j3) {
            k3 = this.getByteFromFile();
            line.append((char)k3);
            if (this.isTRACDCBinary || k3 != 10 && k3 != 13) continue;
            --j3;
        }
        line = new StringBuffer();
        for (j3 = 0; j3 < 16; ++j3) {
            line.append((char)this.getByteFromFile());
        }
        line = new StringBuffer();
        for (j3 = 0; j3 < 72; ++j3) {
            k3 = this.getByteFromFile();
            line.append((char)k3);
            if (this.isTRACDCBinary || k3 != 10 && k3 != 13) continue;
            --j3;
        }
        int sweepcnt = this.getHSpiceInt();
        if (cndcnt == 0) {
            sweepcnt = 0;
        }
        line = new StringBuffer();
        for (int j5 = 0; j5 < 76; ++j5) {
            k2 = this.getByteFromFile();
            line.append((char)k2);
            if (this.isTRACDCBinary || k2 != 10 && k2 != 13) continue;
            --j5;
        }
        if (fileNum == 0) {
            this.signalNames = new String[numSignals];
        } else if (numSignals != this.signalNames.length) {
            System.out.println("Error: file " + fileURL.getFile() + " has " + numSignals + " in it, but previous files have " + this.signalNames.length);
            this.closeInput();
            HSpiceOut.stopProgressDialog();
            return;
        }
        int[] signalTypes = new int[numSignals];
        for (k2 = 0; k2 <= numSignals; ++k2) {
            line = new StringBuffer();
            for (j2 = 0; j2 < 8; ++j2) {
                int l3 = this.getByteFromFile();
                line.append((char)l3);
                if (this.isTRACDCBinary || l3 != 10 && l3 != 13) continue;
                --j2;
            }
            if (k2 == 0) continue;
            int l4 = k2 - nodcnt;
            if (k2 < nodcnt) {
                l4 = k2 + numnoi - 1;
            }
            String lineStr = line.toString().trim();
            signalTypes[l4] = TextUtils.atoi(lineStr, 0, 10);
        }
        boolean paMissingWarned = false;
        for (int k4 = 0; k4 <= numSignals; ++k4) {
            line = new StringBuffer();
            while (true) {
                int l5;
                if ((l5 = this.getByteFromFile()) == 10 || l5 == 13) {
                    continue;
                }
                if (l5 == 32) {
                    if (line.length() == 0) {
                        while ((l5 = this.getByteFromFile()) == 32) {
                        }
                    }
                    break;
                }
                line.append((char)l5);
                if (version == 9007 && line.length() >= 16) break;
            }
            int j6 = line.length();
            l2 = (j6 + 16) / 16 * 16 - 1;
            if (version == 9007) {
                l2 = (j6 + 15) / 16 * 16 - 1;
            }
            while (j6 < l2) {
                i2 = this.getByteFromFile();
                if (!(this.isTRACDCBinary || i2 != 10 && i2 != 13)) {
                    --j6;
                }
                ++j6;
            }
            if (k4 == 0) continue;
            int startPos = 0;
            int openPos = line.indexOf("(");
            if (openPos >= 0) {
                startPos = openPos + 1;
            }
            for (j6 = startPos; j6 < line.length() && line.charAt(j6) != ':' && TextUtils.isDigit(line.charAt(j6)); ++j6) {
            }
            if (j6 < line.length() && line.charAt(j6) == ':') {
                l2 = TextUtils.atoi(line.toString().substring(startPos), 0, 10);
                PALine foundPALine = null;
                if (paList == null) {
                    if (!paMissingWarned) {
                        System.out.println("Warning: there should be a ." + this.paExtension + " file with extra signal names");
                    }
                    paMissingWarned = true;
                } else {
                    for (PALine paLine : paList) {
                        if (paLine.number != l2) continue;
                        foundPALine = paLine;
                        break;
                    }
                }
                if (foundPALine != null) {
                    StringBuffer newSB = new StringBuffer();
                    newSB.append(line.substring(0, startPos));
                    newSB.append(foundPALine.string);
                    newSB.append(line.substring(j6 + 1));
                    line = newSB;
                }
            } else if (line.indexOf(".") >= 0) {
                String fixedLine = HSpiceOut.removeLeadingX(line.toString());
                line = new StringBuffer();
                line.append(fixedLine);
            }
            openPos = line.indexOf("(");
            if (openPos >= 0) {
                String parenPrefix = line.substring(0, openPos + 1);
                int lastDot = line.lastIndexOf(".");
                if (lastDot >= 0) {
                    newSB = new StringBuffer();
                    if (parenPrefix.equalsIgnoreCase("v(") && line.charAt(line.length() - 1) == ')') {
                        newSB.append(line.substring(openPos + 1, lastDot + 1));
                        newSB.append(line.substring(lastDot + 1, line.length() - 1));
                    } else {
                        newSB.append(line.substring(openPos + 1, lastDot + 1));
                        newSB.append(parenPrefix);
                        newSB.append(line.substring(lastDot + 1));
                    }
                    line = newSB;
                } else if (parenPrefix.equalsIgnoreCase("v(") && line.charAt(line.length() - 1) == ')') {
                    newSB = new StringBuffer();
                    newSB.append(line.substring(openPos + 1, line.length() - 1));
                    line = newSB;
                }
            }
            l2 = k4 < nodcnt ? k4 + numnoi - 1 : k4 - nodcnt;
            String sigName = line.toString();
            if (fileNum == 0) {
                this.signalNames[l2] = sigName;
                continue;
            }
            if (sigName.equals(this.signalNames[l2])) continue;
            System.out.println("Error: file " + fileURL.getFile() + " signal " + (l2 + 1) + " is '" + sigName + "', but previous files call that signal '" + this.signalNames[l2] + "'");
            this.closeInput();
            HSpiceOut.stopProgressDialog();
            return;
        }
        for (int c2 = 0; c2 < cndcnt; ++c2) {
            int j7 = 0;
            line = new StringBuffer();
            while (true) {
                if ((l2 = this.getByteFromFile()) == 10 || l2 == 13) {
                    continue;
                }
                if (l2 == 32) break;
                line.append((char)l2);
                if (++j7 >= 16) break;
            }
            l2 = (j7 + 15) / 16 * 16 - 1;
            while (j7 < l2) {
                i2 = this.getByteFromFile();
                if (!(this.isTRACDCBinary || i2 != 10 && i2 != 13)) {
                    --j7;
                }
                ++j7;
            }
        }
        line = new StringBuffer();
        if (!this.isTRACDCBinary) {
            int l6;
            j2 = 0;
            while ((l6 = this.getByteFromFile()) != 10 && l6 != 13) {
                if (j2 < 4) {
                    line.append((char)l6);
                }
                ++j2;
            }
        } else {
            for (j2 = 0; j2 < 4; ++j2) {
                line.append((char)this.getByteFromFile());
            }
        }
        if (!line.toString().equals("$&%#")) {
            System.out.println("HSpice header improperly terminated (got " + line.toString() + ")");
            this.closeInput();
            HSpiceOut.stopProgressDialog();
            return;
        }
        this.resetBinaryTRACDCReader();
        Object constantPrefix = null;
        boolean hasPrefix = true;
        for (int k5 = 0; k5 < numSignals; ++k5) {
            String name = this.signalNames[k5];
            int dotPos = name.indexOf(46);
            if (dotPos < 0) continue;
            String prefix = name.substring(0, dotPos);
            if (constantPrefix == null) {
                constantPrefix = prefix;
            }
            if (((String)constantPrefix).equals(prefix)) continue;
            hasPrefix = false;
            break;
        }
        if (!hasPrefix) {
            constantPrefix = null;
        } else {
            String fileName = fileURL.getFile();
            int pos = fileName.lastIndexOf(File.separatorChar);
            if (pos >= 0) {
                fileName = fileName.substring(pos + 1);
            }
            if ((pos = fileName.lastIndexOf(47)) >= 0) {
                fileName = fileName.substring(pos + 1);
            }
            if ((pos = fileName.indexOf(46)) >= 0) {
                fileName = fileName.substring(0, pos);
            }
            constantPrefix = fileName.equals(constantPrefix) ? (String)constantPrefix + "." : null;
        }
        boolean isComplex = analysisTitle.equals("AC SIGNALS");
        int n2 = sweepsThisFile = sweepcnt > 0 ? sweepcnt : 1;
        if (fileNum == 0) {
            int sweepTotal = sweepsThisFile * numFiles;
            this.allSignals = new Signal[numSignals][sweepTotal];
            this.sweepNames = new String[sweepTotal];
        }
        int sweepCounter = sweepcnt;
        int sweepIndex = 0;
        while (true) {
            block94: {
                Object sweepName = "";
                if (sweepcnt > 0) {
                    float sweepValue = this.getHSpiceFloat(false);
                    if (this.eofReached) {
                        System.out.println("EOF before sweep data");
                        break;
                    }
                    sweepName = TextUtils.formatDouble(sweepValue);
                    for (int i3 = 2; i3 < cndcnt; ++i3) {
                        float anotherSweepValue = this.getHSpiceFloat(false);
                        if (this.eofReached) {
                            System.out.println("EOF reading sweep header");
                            break;
                        }
                        sweepName = (String)sweepName + "," + TextUtils.formatDouble(anotherSweepValue);
                    }
                    this.sweepNames[fileNum * sweepsThisFile + sweepIndex] = (String)(sweepsThisFile > 1 ? "TR" + fileNum + "-" : "") + (String)sweepName;
                } else if (numFiles > 1) {
                    this.sweepNames[fileNum] = "" + (fileNum + 1);
                }
                for (int k6 = 0; k6 < numSignals; ++k6) {
                    Object name = this.signalNames[k6];
                    if (constantPrefix != null && ((String)name).startsWith((String)constantPrefix)) {
                        name = ((String)name).substring(((String)constantPrefix).length());
                    }
                    String context = null;
                    int lastDotPos = ((String)name).lastIndexOf(46);
                    if (lastDotPos >= 0) {
                        context = ((String)name).substring(0, lastDotPos);
                        name = ((String)name).substring(lastDotPos + 1);
                    }
                    if (sweepcnt > 0) {
                        name = (String)name + "[" + (String)sweepName + "]";
                    }
                    SignalCollection scToUse = sc;
                    if (sweepcnt > 0) {
                        scToUse = null;
                    }
                    this.allSignals[k6][fileNum * sweepsThisFile + sweepIndex] = isComplex ? ComplexSample.createComplexSignal(scToUse, sd, (String)name, context) : ScalarSample.createSignal(scToUse, sd, (String)name, context);
                }
                block22: do {
                    float time = this.getHSpiceFloat(true);
                    if (this.eofReached) break block94;
                    for (int k7 = 0; k7 < numSignals; ++k7) {
                        if (isComplex) {
                            signal = (MutableSignal)this.allSignals[(k7 + numnoi) % numSignals][fileNum * sweepsThisFile + sweepIndex];
                            float realPart = this.getHSpiceFloat(false);
                            float imagPart = this.getHSpiceFloat(false);
                            if (signal.getSample(time) == null) {
                                signal.addSample(time, new ComplexSample(realPart, imagPart));
                            }
                        } else {
                            signal = (MutableSignal)this.allSignals[(k7 + numnoi) % numSignals][fileNum * sweepsThisFile + sweepIndex];
                            double val = this.getHSpiceFloat(false);
                            if (signal.getSample(time) == null) {
                                signal.addSample(time, new ScalarSample(val));
                            }
                        }
                        if (!this.eofReached) continue;
                        System.out.println("EOF in the middle of the data (at " + k7 + " out of " + numSignals + ")");
                        continue block22;
                    }
                } while (!this.eofReached);
                System.out.println("EOF before the end of the data");
            }
            if (--sweepCounter <= 0) break;
            ++sweepIndex;
            this.eofReached = false;
        }
        if (sweepcnt > 0 || numFiles > 1 && fileNum == numFiles - 1) {
            for (int k8 = 0; k8 < numSignals; ++k8) {
                String name = this.signalNames[k8];
                if (constantPrefix != null && name.startsWith((String)constantPrefix)) {
                    name = name.substring(((String)constantPrefix).length());
                }
                String context = null;
                int lastDotPos = name.lastIndexOf(46);
                if (lastDotPos >= 0) {
                    context = name.substring(0, lastDotPos);
                    name = name.substring(lastDotPos + 1);
                }
                int total = 0;
                for (int i4 = 0; i4 < this.allSignals[k8].length; ++i4) {
                    if (this.allSignals[k8][i4] == null) continue;
                    ++total;
                }
                Signal[] signalCopy = new Signal[total];
                int j8 = 0;
                for (int i5 = 0; i5 < this.allSignals[k8].length; ++i5) {
                    if (this.allSignals[k8][i5] == null) continue;
                    signalCopy[j8] = this.allSignals[k8][i5];
                    ++j8;
                }
                if (isComplex) {
                    SweptSample.createSignal(sc, sd, name, context, false, signalCopy);
                    continue;
                }
                SweptSample.createSignal(sc, sd, name, context, false, signalCopy);
            }
            sc.setSweepNames(this.sweepNames);
        }
        this.closeInput();
        HSpiceOut.stopProgressDialog();
        if (fileNum == numFiles - 1) {
            System.out.println("Done reading " + analysisTitle + " analysis");
        }
    }

    private void resetBinaryTRACDCReader() {
        this.binaryTRACDCSize = 0;
        this.binaryTRACDCPosition = 0;
    }

    private boolean readBinaryTRACDCBlock(boolean firstbyteread) throws IOException {
        int amtread;
        int i2;
        if (!firstbyteread) {
            if (this.dataInputStream.read() == -1) {
                return true;
            }
            this.updateProgressDialog(1);
        }
        for (int i3 = 0; i3 < 3; ++i3) {
            if (this.dataInputStream.read() != -1) continue;
            return true;
        }
        this.updateProgressDialog(3);
        int blocks = 0;
        for (i2 = 0; i2 < 4; ++i2) {
            int uval = this.dataInputStream.read();
            if (uval == -1) {
                return true;
            }
            blocks = this.isTRACDCBinarySwapped ? blocks >> 8 & 0xFFFFFF | (uval & 0xFF) << 24 : blocks << 8 | uval;
        }
        this.updateProgressDialog(4);
        for (i2 = 0; i2 < 4; ++i2) {
            if (this.dataInputStream.read() != -1) continue;
            return true;
        }
        this.updateProgressDialog(4);
        int bytes = 0;
        for (int i4 = 0; i4 < 4; ++i4) {
            int uval = this.dataInputStream.read();
            if (uval == -1) {
                return true;
            }
            bytes = this.isTRACDCBinarySwapped ? bytes >> 8 & 0xFFFFFF | (uval & 0xFF) << 24 : bytes << 8 | uval;
        }
        this.updateProgressDialog(4);
        if (bytes > 8192) {
            System.out.println("ERROR: block is " + bytes + " long, but limit is 8192");
            bytes = 8192;
        }
        if ((amtread = this.dataInputStream.read(this.binaryTRACDCBuffer, 0, bytes)) != bytes) {
            System.out.println("Expected to read " + bytes + " bytes but got only " + amtread);
            return true;
        }
        this.updateProgressDialog(bytes);
        int trailer = 0;
        for (int i5 = 0; i5 < 4; ++i5) {
            int uval = this.dataInputStream.read();
            if (uval == -1) {
                return true;
            }
            trailer = this.isTRACDCBinarySwapped ? trailer >> 8 & 0xFFFFFF | (uval & 0xFF) << 24 : trailer << 8 | uval;
        }
        if (trailer != bytes) {
            System.out.println("Block trailer claims block had " + trailer + " bytes but block really had " + bytes);
            return true;
        }
        this.updateProgressDialog(4);
        this.binaryTRACDCPosition = 0;
        this.binaryTRACDCSize = bytes;
        return false;
    }

    private int getByteFromFile() throws IOException {
        int i2;
        if (this.byteCount == 0L) {
            i2 = this.dataInputStream.read();
            if (i2 == -1) {
                return i2;
            }
            this.updateProgressDialog(1);
            if (i2 == 0 || i2 == 4) {
                this.isTRACDCBinary = true;
                this.isTRACDCBinarySwapped = false;
                if (i2 == 4) {
                    this.isTRACDCBinarySwapped = true;
                }
                this.binaryTRACDCBuffer = new byte[8192];
                if (this.readBinaryTRACDCBlock(true)) {
                    return -1;
                }
            } else {
                this.isTRACDCBinary = false;
                return i2;
            }
        }
        if (this.isTRACDCBinary) {
            if (this.binaryTRACDCPosition >= this.binaryTRACDCSize && this.readBinaryTRACDCBlock(false)) {
                return -1;
            }
            byte val = this.binaryTRACDCBuffer[this.binaryTRACDCPosition];
            ++this.binaryTRACDCPosition;
            return val & 0xFF;
        }
        i2 = this.dataInputStream.read();
        this.updateProgressDialog(1);
        return i2;
    }

    private int getHSpiceInt() throws IOException {
        StringBuffer line = new StringBuffer();
        for (int j2 = 0; j2 < 4; ++j2) {
            line.append((char)this.getByteFromFile());
        }
        return TextUtils.atoi(line.toString().trim(), 0, 10);
    }

    private float getHSpiceFloat(boolean testEOFValue) throws IOException {
        if (!this.isTRACDCBinary) {
            StringBuffer line = new StringBuffer();
            for (int j2 = 0; j2 < 11; ++j2) {
                int l2 = this.getByteFromFile();
                if (l2 == -1) {
                    this.eofReached = true;
                    return 0.0f;
                }
                line.append((char)l2);
                if (l2 != 10 && l2 != 13) continue;
                --j2;
            }
            String result = line.toString();
            if (testEOFValue && result.equals("0.10000E+31")) {
                this.eofReached = true;
                return 0.0f;
            }
            return (float)TextUtils.atof(result);
        }
        int fi0 = this.getByteFromFile();
        int fi1 = this.getByteFromFile();
        int fi2 = this.getByteFromFile();
        int fi3 = this.getByteFromFile();
        if (fi0 < 0 || fi1 < 0 || fi2 < 0 || fi3 < 0) {
            this.eofReached = true;
            return 0.0f;
        }
        int fi = 0;
        fi = this.isTRACDCBinarySwapped ? fi3 << 24 | fi2 << 16 | fi1 << 8 | fi0 : (fi0 &= 0xFF) << 24 | (fi1 &= 0xFF) << 16 | (fi2 &= 0xFF) << 8 | (fi3 &= 0xFF);
        float f2 = Float.intBitsToFloat(fi);
        if (testEOFValue && (double)f2 > 1.0E30 && (double)f2 < 1.00000002E30) {
            this.eofReached = true;
            return 0.0f;
        }
        return f2;
    }

    static String removeLeadingX(String name) {
        int dotPos = -1;
        while (((String)name).indexOf(46, dotPos + 1) >= 0) {
            int xPos = dotPos + 1;
            if (((String)name).length() > xPos && ((String)name).charAt(xPos) == 'x') {
                name = ((String)name).substring(0, xPos) + ((String)name).substring(xPos + 1);
            }
            if ((dotPos = ((String)name).indexOf(46, xPos)) >= 0) continue;
            break;
        }
        return name;
    }

    private static class PALine {
        int number;
        String string;

        private PALine() {
        }
    }
}

