/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.ELIBConstants;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.io.input.LibraryStatistics;
import com.sun.electric.tool.ncc.basic.TransitiveRelation;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ELIB
extends LibraryFiles {
    private Header header;
    private int toolCount;
    private int toolBCount;
    private Tool[] toolList;
    private String[] toolError;
    private Variable[][] toolVars;
    private int libUserBits;
    private Variable[] libVars;
    private int techCount;
    private TechId[] techIdList;
    private Technology[] techList;
    private String[] techError;
    private Variable[][] techVars;
    private int[] techLambda;
    private HashMap<Technology, Double> techScale = new HashMap();
    private int arcProtoCount;
    private ArcProtoId[] arcProtoIdList;
    private ArcProto[] arcProtoList;
    private String[] arcProtoError;
    private int primNodeProtoCount;
    private PrimitiveNodeId[] primitiveNodeIdList;
    private PrimitiveNode[] primNodeProtoList;
    private boolean[] primNodeProtoError;
    private String[] primNodeProtoOrig;
    private int[] primNodeProtoTech;
    private int primPortProtoCount;
    private PrimitivePortId[] primitivePortIdList;
    private PrimitivePort[] primPortProtoList;
    private String[] primPortProtoError;
    private int cellCount;
    private FakeCell[] fakeCellList;
    private String[] cellProtoName;
    private int[] cellCreationDate;
    private int[] cellRevisionDate;
    private int[] cellUserBits;
    private Variable[][] cellVars;
    private int[] cellLowX;
    private int[] cellHighX;
    private int[] cellLowY;
    private int[] cellHighY;
    private String[] cellLibraryPath;
    private int[] nodeCounts;
    private int[] firstNodeIndex;
    private int[] arcCounts;
    private int[] firstArcIndex;
    private int[] portCounts;
    private int[] firstPortIndex;
    private int[] cellXOff;
    private int[] cellYOff;
    private int[] cellNextInCellGroup;
    private boolean[] xLibRefSatisfied;
    private HashMap<Integer, View> viewMapping;
    private int nodeCount;
    private LibraryFiles.NodeInstList nodeInstList;
    private int[] nodeTypeList;
    private int arcCount;
    private ArcInst[] arcList;
    private int[] arcTypeList;
    private String[] arcNameList;
    private TextDescriptor[] arcNameDescriptorList;
    private int[] arcWidthList;
    private int[] arcHeadXPosList;
    private int[] arcHeadYPosList;
    private int[] arcHeadNodeList;
    private int[] arcHeadPortList;
    private int[] arcTailXPosList;
    private int[] arcTailYPosList;
    private int[] arcTailNodeList;
    private int[] arcTailPortList;
    private int[] arcUserBits;
    private Variable[][] arcVariables;
    private int exportCount;
    private int exportIndex;
    private Object[] exportList;
    private int[] exportSubNodeList;
    private int[] exportSubPortList;
    private String[] exportNameList;
    private TextDescriptor[] exportNameDescriptors;
    private int[] exportUserbits;
    private Variable[][] exportVariables;
    private int geomCount;
    private boolean[] geomType;
    private int[] geomMoreUp;
    private String[] varNames;
    private Variable.Key[] varKeys;
    private boolean convertTextDescriptors;
    private boolean alwaysTextDescriptors;
    private static ByteBuffer bb = ByteBuffer.allocateDirect(8);
    private static byte[] rawData = new byte[8];

    ELIB(EditingPreferences ep) {
        super(ep);
    }

    public static synchronized boolean readStatistics(URL fileURL, ErrorLogger errorLogger, LibraryStatistics.FileContents fc, EditingPreferences ep) {
        try {
            ELIB in = new ELIB(null);
            if (in.openBinaryInput(fileURL)) {
                return true;
            }
            boolean error = in.readTheLibrary(true, fc, ep);
            in.closeInput();
            return error;
        }
        catch (Exception e2) {
            errorLogger.logError("Error " + String.valueOf(e2) + " on " + String.valueOf(fileURL), -1);
            e2.printStackTrace();
            return true;
        }
    }

    @Override
    protected boolean readProjectSettings(EditingPreferences ep) {
        try {
            if (this.readTheLibrary(true, null, ep)) {
                return true;
            }
            this.createLibraryCells(true, ep);
            return false;
        }
        catch (IOException e2) {
            System.out.println("End of file reached while reading " + this.filePath);
            return true;
        }
    }

    @Override
    boolean readTheLibrary(boolean onlyProjectSettings, LibraryStatistics.FileContents fc, EditingPreferences ep) throws IOException {
        int i2;
        int j2;
        int i3;
        this.byteCount = 0L;
        this.header = this.readHeader();
        if (this.header == null) {
            System.out.println("Error reading header");
            return true;
        }
        if (fc != null) {
            fc.header = this.header;
        }
        this.toolCount = this.readBigInteger();
        this.techCount = this.readBigInteger();
        this.primNodeProtoCount = this.readBigInteger();
        this.primPortProtoCount = this.readBigInteger();
        this.arcProtoCount = this.readBigInteger();
        this.nodeProtoCount = this.readBigInteger();
        this.nodeCount = this.readBigInteger();
        this.exportCount = this.readBigInteger();
        this.arcCount = this.readBigInteger();
        this.geomCount = this.readBigInteger();
        this.cellCount = this.header.magic <= -1589 && this.header.magic >= -1593 ? this.readBigInteger() : this.nodeProtoCount;
        this.readBigInteger();
        String versionString = this.header.magic <= -1587 ? this.readString() : "3.35";
        this.version = Version.parseVersion(versionString);
        if (fc != null) {
            fc.version = this.version;
        }
        this.convertMosisCmosTechnologies = this.version.compareTo(Version.parseVersion("6.03q")) < 0;
        this.convertTextDescriptors = this.version.compareTo(Version.parseVersion("6.04c")) < 0;
        this.alwaysTextDescriptors = this.version.compareTo(Version.parseVersion("6.05x")) >= 0;
        this.scaleLambdaBy20 = this.version.compareTo(Version.parseVersion("5")) < 0;
        this.rotationMirrorBits = this.version.compareTo(Version.parseVersion("7.01")) >= 0;
        this.viewMapping = new HashMap();
        this.viewMapping.put(-1, View.UNKNOWN);
        this.viewMapping.put(-2, View.LAYOUT);
        this.viewMapping.put(-3, View.SCHEMATIC);
        this.viewMapping.put(-4, View.ICON);
        this.viewMapping.put(-5, View.DOCWAVE);
        this.viewMapping.put(-6, View.LAYOUTSKEL);
        this.viewMapping.put(-7, View.VHDL);
        this.viewMapping.put(-8, View.NETLIST);
        this.viewMapping.put(-9, View.DOC);
        this.viewMapping.put(-10, View.NETLISTNETLISP);
        this.viewMapping.put(-11, View.NETLISTALS);
        this.viewMapping.put(-12, View.NETLISTQUISC);
        this.viewMapping.put(-13, View.NETLISTRSIM);
        this.viewMapping.put(-14, View.NETLISTSILOS);
        this.viewMapping.put(-15, View.VERILOG);
        this.viewMapping.put(-16, View.LAYOUTCOMP);
        if (this.header.magic <= -1589) {
            int numExtraViews = this.readBigInteger();
            for (i3 = 0; i3 < numExtraViews; ++i3) {
                String viewName = this.readString();
                String viewShortName = this.readString();
                View view = View.findView(viewName);
                if (view == null && (view = this.findOldViewName(viewName)) == null && !onlyProjectSettings && (view = View.newInst(viewName, viewShortName)) == null) {
                    return true;
                }
                this.viewMapping.put(i3 + 1, view);
            }
        }
        this.toolBCount = this.header.magic <= -1577 && this.header.magic >= -1583 ? this.readBigInteger() : this.toolCount;
        this.techIdList = new TechId[this.techCount];
        this.techList = new Technology[this.techCount];
        this.techError = new String[this.techCount];
        this.techVars = new Variable[this.techCount][];
        this.techLambda = new int[this.techCount];
        this.arcProtoIdList = new ArcProtoId[this.arcProtoCount];
        this.arcProtoList = new ArcProto[this.arcProtoCount];
        this.arcProtoError = new String[this.arcProtoCount];
        this.primitiveNodeIdList = new PrimitiveNodeId[this.primNodeProtoCount];
        this.primNodeProtoList = new PrimitiveNode[this.primNodeProtoCount];
        this.primNodeProtoError = new boolean[this.primNodeProtoCount];
        this.primNodeProtoOrig = new String[this.primNodeProtoCount];
        this.primNodeProtoTech = new int[this.primNodeProtoCount];
        this.primitivePortIdList = new PrimitivePortId[this.primPortProtoCount];
        this.primPortProtoList = new PrimitivePort[this.primPortProtoCount];
        this.primPortProtoError = new String[this.primPortProtoCount];
        this.toolList = new Tool[this.toolCount];
        this.toolError = new String[this.toolCount];
        this.toolVars = new Variable[this.toolCount][];
        this.nodeProtoList = new Cell[this.nodeProtoCount];
        this.cellProtoName = new String[this.nodeProtoCount];
        this.cellCreationDate = new int[this.nodeProtoCount];
        this.cellRevisionDate = new int[this.nodeProtoCount];
        this.cellUserBits = new int[this.nodeProtoCount];
        this.cellVars = new Variable[this.nodeProtoCount][];
        this.cellLowX = new int[this.nodeProtoCount];
        this.cellHighX = new int[this.nodeProtoCount];
        this.cellLowY = new int[this.nodeProtoCount];
        this.cellHighY = new int[this.nodeProtoCount];
        this.cellLibraryPath = new String[this.nodeProtoCount];
        this.nodeCounts = new int[this.nodeProtoCount];
        this.firstNodeIndex = new int[this.nodeProtoCount + 1];
        this.arcCounts = new int[this.nodeProtoCount];
        this.firstArcIndex = new int[this.nodeProtoCount + 1];
        this.portCounts = new int[this.nodeProtoCount];
        this.firstPortIndex = new int[this.nodeProtoCount];
        this.cellLambda = new double[this.nodeProtoCount];
        this.cellXOff = new int[this.nodeProtoCount];
        this.cellYOff = new int[this.nodeProtoCount];
        this.cellNextInCellGroup = new int[this.nodeProtoCount];
        this.xLibRefSatisfied = new boolean[this.nodeProtoCount];
        Arrays.fill(this.cellNextInCellGroup, -1);
        boolean hasAnchor = this.header.magic <= -1597;
        this.nodeInstList = new LibraryFiles.NodeInstList(this.nodeCount, hasAnchor);
        this.nodeTypeList = new int[this.nodeCount];
        this.arcList = new ArcInst[this.arcCount];
        this.arcTypeList = new int[this.arcCount];
        this.arcNameList = new String[this.arcCount];
        this.arcNameDescriptorList = new TextDescriptor[this.arcCount];
        this.arcWidthList = new int[this.arcCount];
        this.arcHeadXPosList = new int[this.arcCount];
        this.arcHeadYPosList = new int[this.arcCount];
        this.arcHeadNodeList = new int[this.arcCount];
        this.arcHeadPortList = new int[this.arcCount];
        this.arcTailXPosList = new int[this.arcCount];
        this.arcTailYPosList = new int[this.arcCount];
        this.arcTailNodeList = new int[this.arcCount];
        this.arcTailPortList = new int[this.arcCount];
        this.arcUserBits = new int[this.arcCount];
        this.arcVariables = new Variable[this.arcCount][];
        for (i3 = 0; i3 < this.arcCount; ++i3) {
            this.arcHeadNodeList[i3] = -1;
            this.arcHeadPortList[i3] = -1;
            this.arcTailNodeList[i3] = -1;
            this.arcTailPortList[i3] = -1;
            this.arcNameList[i3] = null;
            this.arcUserBits[i3] = 0;
        }
        this.exportList = new Object[this.exportCount];
        this.exportSubNodeList = new int[this.exportCount];
        this.exportSubPortList = new int[this.exportCount];
        this.exportNameList = new String[this.exportCount];
        this.exportNameDescriptors = new TextDescriptor[this.exportCount];
        this.exportUserbits = new int[this.exportCount];
        this.exportVariables = new Variable[this.exportCount][];
        if (this.header.magic <= -1589 && this.header.magic >= -1593) {
            this.fakeCellList = new FakeCell[this.cellCount];
            for (i3 = 0; i3 < this.cellCount; ++i3) {
                this.fakeCellList[i3] = new FakeCell();
            }
        }
        if (this.header.magic > -1581) {
            this.geomType = new boolean[this.geomCount];
            this.geomMoreUp = new int[this.geomCount];
        }
        if (this.header.magic != -1573) {
            int nodeInstPos = 0;
            int arcInstPos = 0;
            int portProtoPos = 0;
            for (int i4 = 0; i4 < this.nodeProtoCount; ++i4) {
                this.arcCounts[i4] = this.readBigInteger();
                this.nodeCounts[i4] = this.readBigInteger();
                this.portCounts[i4] = this.readBigInteger();
                if (this.arcCounts[i4] > 0 || this.nodeCounts[i4] > 0) {
                    arcInstPos += this.arcCounts[i4];
                    nodeInstPos += this.nodeCounts[i4];
                }
                portProtoPos += this.portCounts[i4];
            }
            if (nodeInstPos != this.nodeCount) {
                System.out.println("Error: cells have " + nodeInstPos + " nodes but library has " + this.nodeCount);
                return true;
            }
            if (arcInstPos != this.arcCount) {
                System.out.println("Error: cells have " + arcInstPos + " arcs but library has " + this.arcCount);
                return true;
            }
            if (portProtoPos != this.exportCount) {
                System.out.println("Error: cells have " + portProtoPos + " ports but library has " + this.exportCount);
                return true;
            }
        } else {
            this.arcCounts[0] = this.arcCount;
            this.nodeCounts[0] = this.nodeCount;
            this.portCounts[0] = this.exportCount;
            for (i3 = 1; i3 < this.nodeProtoCount; ++i3) {
                this.portCounts[i3] = 0;
                this.nodeCounts[i3] = 0;
                this.arcCounts[i3] = 0;
            }
        }
        IdManager idManager = fc != null ? fc.idManager() : this.idManager;
        this.primNodeProtoCount = 0;
        this.primPortProtoCount = 0;
        this.arcProtoCount = 0;
        for (int techIndex = 0; techIndex < this.techCount; ++techIndex) {
            TechId techId;
            String name = this.readString();
            this.techIdList[techIndex] = techId = idManager.newTechId(name);
            int numPrimNodes = this.readBigInteger();
            for (int j3 = 0; j3 < numPrimNodes; ++j3) {
                PrimitiveNodeId primitiveNodeId;
                name = this.readString();
                this.primitiveNodeIdList[this.primNodeProtoCount] = primitiveNodeId = techId.newPrimitiveNodeId(name);
                this.primNodeProtoTech[this.primNodeProtoCount] = techIndex;
                int numPrimPorts = this.readBigInteger();
                for (int i5 = 0; i5 < numPrimPorts; ++i5) {
                    name = this.readString();
                    PrimitivePortId primitivePortId = primitiveNodeId.newPortId(name);
                    this.primitivePortIdList[this.primPortProtoCount++] = primitivePortId;
                }
                ++this.primNodeProtoCount;
            }
            int numArcProtos = this.readBigInteger();
            for (j2 = 0; j2 < numArcProtos; ++j2) {
                name = this.readString();
                ArcProtoId arcProtoId = techId.newArcProtoId(name);
                this.arcProtoIdList[this.arcProtoCount++] = arcProtoId;
            }
        }
        for (i2 = 0; i2 < this.toolCount; ++i2) {
            String name = this.readString();
            this.toolError[i2] = null;
            Tool t = Tool.findTool(name);
            if (t == null) {
                this.toolError[i2] = name;
            }
            this.toolList[i2] = t;
        }
        if (this.header.magic <= -1577 && this.header.magic >= -1583) {
            for (i2 = 0; i2 < this.toolBCount; ++i2) {
                this.readString();
            }
        }
        if (this.header.magic <= -1585) {
            this.libUserBits = this.readBigInteger();
        } else {
            if (this.toolBCount >= 1) {
                this.libUserBits = this.readBigInteger();
            }
            for (i2 = 1; i2 < this.toolBCount; ++i2) {
                this.readBigInteger();
            }
        }
        for (i2 = 0; i2 < this.techCount; ++i2) {
            this.techLambda[i2] = this.readBigInteger();
        }
        this.readNameSpace();
        this.libVars = this.readVariables();
        for (i2 = 0; i2 < this.libVars.length; ++i2) {
            Object value;
            Variable var = this.libVars[i2];
            if (var == null || var.getKey() != Library.FONT_ASSOCIATIONS || !((value = var.getObject()) instanceof String[])) continue;
            this.setFontNames((String[])value);
            this.libVars[i2] = null;
        }
        for (i2 = 0; i2 < this.toolCount; ++i2) {
            this.toolVars[i2] = this.readVariables();
        }
        for (i2 = 0; i2 < this.techCount; ++i2) {
            this.techVars[i2] = this.readVariables();
        }
        for (i2 = 0; i2 < this.arcProtoCount; ++i2) {
            this.readVariables();
        }
        for (i2 = 0; i2 < this.primNodeProtoCount; ++i2) {
            this.readVariables();
        }
        for (i2 = 0; i2 < this.primPortProtoCount; ++i2) {
            this.readVariables();
        }
        if (this.header.magic <= -1589) {
            int count = this.readBigInteger();
            for (int i6 = 0; i6 < count; ++i6) {
                int j4 = this.readBigInteger();
                View v = this.getView(j4);
                if (v == null) {
                    System.out.println("View index " + j4 + " not found in ELIB:readTheLibrary()");
                }
                this.readVariables();
            }
        }
        if (this.header.magic <= -1589 && this.header.magic >= -1593) {
            for (i2 = 0; i2 < this.cellCount; ++i2) {
                String thecellname = this.readString();
                this.readVariables();
                this.fakeCellList[i2].cellName = this.convertCellName(thecellname);
            }
        }
        this.exportIndex = 0;
        for (i2 = 0; i2 < this.nodeProtoCount; ++i2) {
            if (this.arcCounts[i2] < 0 && this.nodeCounts[i2] < 0 || !this.readNodeProto(i2)) continue;
            System.out.println("Error reading cell");
            return true;
        }
        for (i2 = 0; i2 < this.nodeProtoCount; ++i2) {
            if (this.arcCounts[i2] >= 0 || this.nodeCounts[i2] >= 0 || !this.readExternalNodeProto(i2)) continue;
            System.out.println("Error reading external cell");
            return true;
        }
        if (fc != null) {
            for (int cellIndex = 0; cellIndex < this.nodeProtoCount; ++cellIndex) {
                if (this.arcCounts[cellIndex] >= 0 || this.nodeCounts[cellIndex] >= 0) {
                    fc.localCells.add(this.cellProtoName[cellIndex]);
                    continue;
                }
                fc.externalCells.add(new LibraryStatistics.ExternalCell(this.cellLibraryPath[cellIndex], null, this.cellProtoName[cellIndex]));
            }
            return false;
        }
        int nodeIndex = 0;
        int arcIndex = 0;
        int geomIndex = 0;
        for (int cellIndex = 0; cellIndex < this.nodeProtoCount; ++cellIndex) {
            Cell cell = this.nodeProtoList[cellIndex];
            this.firstNodeIndex[cellIndex] = nodeIndex;
            this.firstArcIndex[cellIndex] = arcIndex;
            if (this.header.magic > -1581) {
                j2 = geomIndex;
                this.readGeom(this.geomType, this.geomMoreUp, j2);
                this.readGeom(this.geomType, this.geomMoreUp, ++j2);
                int top = ++j2;
                this.readGeom(this.geomType, this.geomMoreUp, j2);
                int bot = ++j2;
                this.readGeom(this.geomType, this.geomMoreUp, j2);
                ++j2;
                do {
                    this.readGeom(this.geomType, this.geomMoreUp, j2);
                } while (this.geomMoreUp[++j2 - 1] != top);
                geomIndex = j2;
                int look = bot;
                while (look != top) {
                    if (!this.geomType[look]) {
                        if (this.readArcInst(arcIndex)) {
                            System.out.println("Error reading arc");
                            Input.errorLogger.logError("Error reading arc index " + arcIndex, cell, 1);
                            return true;
                        }
                        ++arcIndex;
                    } else {
                        if (this.readNodeInst(nodeIndex, cellIndex)) {
                            System.out.println("Error reading node");
                            Input.errorLogger.logError("Error reading node index " + nodeIndex, cell, 1);
                            return true;
                        }
                        ++nodeIndex;
                    }
                    look = this.geomMoreUp[look];
                }
                continue;
            }
            for (j2 = 0; j2 < this.arcCounts[cellIndex]; ++j2) {
                if (this.readArcInst(arcIndex)) {
                    System.out.println("Error reading arc");
                    Input.errorLogger.logError("Error reading arc index " + arcIndex, cell, 1);
                    return true;
                }
                ++arcIndex;
            }
            for (j2 = 0; j2 < this.nodeCounts[cellIndex]; ++j2) {
                if (this.readNodeInst(nodeIndex, cellIndex)) {
                    System.out.println("Error reading node index " + nodeIndex + " in " + String.valueOf(cell) + " of " + String.valueOf(this.lib));
                    Input.errorLogger.logError("Error reading node index " + nodeIndex + " in " + String.valueOf(cell) + " of " + String.valueOf(this.lib), cell, 1);
                    return true;
                }
                ++nodeIndex;
            }
        }
        this.firstNodeIndex[this.nodeProtoCount] = nodeIndex;
        this.firstArcIndex[this.nodeProtoCount] = arcIndex;
        return false;
    }

    @Override
    Map<Cell, Variable[]> createLibraryCells(boolean onlyProjectSettings, EditingPreferences ep) {
        int i2;
        this.primNodeProtoCount = 0;
        this.primPortProtoCount = 0;
        this.arcProtoCount = 0;
        block0: for (int techIndex = 0; techIndex < this.techCount; ++techIndex) {
            Object errorMessage;
            TechId techId = this.techIdList[techIndex];
            String name = techId.techName;
            Technology tech = this.findTechnologyName(name);
            boolean imosconv = false;
            if (name.equals("imos")) {
                tech = Technology.getMocmosTechnology();
                imosconv = true;
            }
            if (tech == null) {
                tech = Generic.tech();
                this.techError[techIndex] = name;
            } else {
                this.techError[techIndex] = null;
            }
            this.techList[techIndex] = tech;
            while (this.primNodeProtoCount < this.primitiveNodeIdList.length) {
                PrimitiveNode pnp;
                PrimitiveNodeId primitiveNodeId = this.primitiveNodeIdList[this.primNodeProtoCount];
                if (primitiveNodeId.techId != techId) break;
                this.primNodeProtoOrig[this.primNodeProtoCount] = null;
                this.primNodeProtoError[this.primNodeProtoCount] = false;
                name = primitiveNodeId.name;
                if (imosconv) {
                    name = name.substring(6);
                }
                if ((pnp = tech.findNodeProto(name)) == null && name.equals("Active-Node")) {
                    pnp = tech.findNodeProto("P-Active-Node");
                }
                if (pnp == null) {
                    String primName;
                    PrimitiveNode opnp;
                    boolean advise = true;
                    Iterator<PrimitiveNode> it = tech.getNodes();
                    while (it.hasNext()) {
                        opnp = it.next();
                        primName = opnp.getName();
                        if (!primName.startsWith(name) && !name.startsWith(primName)) continue;
                        pnp = opnp;
                        break;
                    }
                    if (pnp == null) {
                        it = tech.getNodes();
                        while (it.hasNext()) {
                            opnp = it.next();
                            primName = opnp.getName();
                            if (!primName.endsWith(name) && !name.endsWith(primName)) continue;
                            pnp = opnp;
                            break;
                        }
                    }
                    if (pnp == null && (pnp = tech.convertOldNodeName(name)) != null) {
                        advise = false;
                    }
                    if (pnp == null) {
                        it = tech.getNodes();
                        pnp = it.next();
                    }
                    if (advise) {
                        errorMessage = this.techError[techIndex] != null ? this.techError[techIndex] : tech.getTechName();
                        this.primNodeProtoOrig[this.primNodeProtoCount] = errorMessage = (String)errorMessage + ":" + name;
                        this.primNodeProtoError[this.primNodeProtoCount] = true;
                    }
                }
                this.primNodeProtoTech[this.primNodeProtoCount] = techIndex;
                this.primNodeProtoList[this.primNodeProtoCount] = pnp;
                while (this.primPortProtoCount < this.primitivePortIdList.length) {
                    Iterator<PrimitivePort> it;
                    PrimitivePortId primitivePortId = this.primitivePortIdList[this.primPortProtoCount];
                    if (primitivePortId.parentId != primitiveNodeId) break;
                    this.primPortProtoError[this.primPortProtoCount] = null;
                    name = primitivePortId.externalId;
                    PrimitivePort pp = (PrimitivePort)pnp.findPortProto(name);
                    if (pp == null) {
                        pp = tech.convertOldPortName(name, pnp);
                    }
                    if (pp == null && (it = pnp.getPrimitivePorts()).hasNext()) {
                        pp = it.next();
                        if (!this.primNodeProtoError[this.primNodeProtoCount]) {
                            String errorMessage2 = name + " on ";
                            if (this.primNodeProtoOrig[this.primNodeProtoCount] != null) {
                                errorMessage2 = errorMessage2 + this.primNodeProtoOrig[this.primNodeProtoCount];
                            } else {
                                errorMessage2 = this.techError[techIndex] != null ? errorMessage2 + this.techError[techIndex] : errorMessage2 + tech.getTechName();
                                errorMessage2 = errorMessage2 + ":" + pnp.getName();
                            }
                            this.primPortProtoError[this.primPortProtoCount] = errorMessage2;
                        }
                    }
                    this.primPortProtoList[this.primPortProtoCount++] = pp;
                }
                ++this.primNodeProtoCount;
            }
            while (this.arcProtoCount < this.arcProtoIdList.length) {
                ArcProto ap;
                ArcProtoId arcProtoId = this.arcProtoIdList[this.arcProtoCount];
                if (arcProtoId.techId != techId) continue block0;
                this.arcProtoError[this.arcProtoCount] = null;
                name = arcProtoId.name;
                if (imosconv) {
                    name = name.substring(6);
                }
                if ((ap = tech.findArcProto(name)) == null) {
                    ap = tech.convertOldArcName(name);
                }
                if (ap == null) {
                    Iterator<ArcProto> it = tech.getArcs();
                    ap = it.next();
                    errorMessage = this.techError[techIndex] != null ? this.techError[techIndex] : tech.getTechName();
                    this.arcProtoError[this.arcProtoCount] = errorMessage = (String)errorMessage + ":" + name;
                }
                this.arcProtoList[this.arcProtoCount++] = ap;
            }
        }
        for (i2 = 0; i2 < this.techCount; ++i2) {
            int lambda = this.techLambda[i2];
            if (this.techError[i2] != null) continue;
            Technology tech = this.techList[i2];
            if (this.scaleLambdaBy20) {
                lambda *= 20;
            }
            this.techScale.put(tech, Double.valueOf(lambda));
            String varName = tech.getScaleVariableName();
            Variable var = Variable.newInst(Variable.newKey(varName), lambda / 2, TextDescriptor.EMPTY);
            this.realizeMeaningPrefs(tech, new Variable[]{var});
        }
        for (i2 = 0; i2 < this.toolCount; ++i2) {
            Tool tool = this.toolList[i2];
            if (tool == null) continue;
            this.realizeMeaningPrefs(tool, this.toolVars[i2]);
        }
        for (i2 = 0; i2 < this.techCount; ++i2) {
            Technology tech = this.techList[i2];
            if (tech == null) continue;
            this.realizeMeaningPrefs(tech, this.techVars[i2]);
        }
        if (onlyProjectSettings) {
            return null;
        }
        this.lib.erase();
        this.lib.lowLevelSetUserBits(this.libUserBits);
        this.lib.setFromDisk();
        this.lib.setVersion(this.version);
        this.realizeVariables(this.lib, this.libVars);
        HashMap<Cell, Variable[]> originalVars = new HashMap<Cell, Variable[]>();
        for (int i3 = 0; i3 < this.nodeProtoCount; ++i3) {
            if (this.arcCounts[i3] < 0 && this.nodeCounts[i3] < 0) continue;
            this.xLibRefSatisfied[i3] = true;
            this.realizeNodeProto(i3, originalVars);
        }
        TransitiveRelation<Object> transitive = new TransitiveRelation<Object>();
        HashMap<String, String> protoNames = new HashMap<String, String>();
        for (int cellIndex = 0; cellIndex < this.nodeProtoCount; ++cellIndex) {
            Cell cell = this.nodeProtoList[cellIndex];
            if (cell == null || cell.getLibrary() != this.lib) continue;
            String protoName = (String)protoNames.get(cell.getName());
            if (protoName == null) {
                protoName = cell.getName();
                protoNames.put(protoName, protoName);
            }
            transitive.theseAreRelated(cell, protoName);
            Cell otherCell = null;
            int nextInCell = this.cellNextInCellGroup[cellIndex];
            if (nextInCell >= 0) {
                otherCell = this.nodeProtoList[nextInCell];
            }
            if (otherCell == null || cell.getLibrary() != this.lib) continue;
            transitive.theseAreRelated(cell, otherCell);
        }
        Iterator git = transitive.getSetsOfRelatives();
        while (git.hasNext()) {
            Set group = git.next();
            Cell firstCell = null;
            for (Object o2 : group) {
                if (!(o2 instanceof Cell)) continue;
                Cell cell = (Cell)o2;
                if (firstCell == null) {
                    firstCell = cell;
                    continue;
                }
                cell.joinGroup(firstCell);
            }
        }
        for (int i4 = 0; i4 < this.nodeProtoCount; ++i4) {
            Cell cell = this.nodeProtoList[i4];
            if (cell != null) continue;
            this.realizeExternalNodeProto(this.lib, i4);
        }
        Iterator<Cell> it = this.lib.getCells();
        while (it.hasNext()) {
            Cell c2 = it.next();
            if (c2.getVar(IO_DUMMY_OBJECT) == null) continue;
            System.out.println("WARNING: " + String.valueOf(this.lib) + " contains DUMMY cell " + c2.noLibDescribe());
        }
        return originalVars;
    }

    @Override
    Variable[] findVarsOnExampleIcon(Cell parentCell, Cell iconCell) {
        int cellIndex;
        for (cellIndex = 0; cellIndex < this.nodeProtoList.length && this.nodeProtoList[cellIndex] != parentCell; ++cellIndex) {
        }
        if (cellIndex + 1 >= this.firstNodeIndex.length) {
            return null;
        }
        int startNode = this.firstNodeIndex[cellIndex];
        int endNode = this.firstNodeIndex[cellIndex + 1];
        for (int i2 = startNode; i2 < endNode; ++i2) {
            NodeProto np = this.convertNodeProto(this.nodeTypeList[i2]);
            if (np != iconCell) continue;
            return this.nodeInstList.vars[i2];
        }
        return null;
    }

    @Override
    protected void realizeCellsRecursively(Cell cell, HashSet<Cell> recursiveSetupFlag, HashSet<Cell> patchedCells, String scaledCellName, double scale) {
        int i2;
        boolean dummyCell;
        if (cell.getLibrary() != this.lib) {
            return;
        }
        boolean bl = dummyCell = cell.getVar(IO_DUMMY_OBJECT) != null;
        if (dummyCell) {
            return;
        }
        int cellIndex = cell.getTempInt();
        if (cellIndex + 1 >= this.firstNodeIndex.length) {
            return;
        }
        int startNode = this.firstNodeIndex[cellIndex];
        int endNode = this.firstNodeIndex[cellIndex + 1];
        block0: for (int i3 = startNode; i3 < endNode; ++i3) {
            Cell subCell;
            NodeProto np = this.nodeInstList.protoType[i3];
            if (np instanceof PrimitiveNode || (subCell = (Cell)np).getLibrary() == this.lib) continue;
            for (int cI = 0; cI < this.nodeProtoCount; ++cI) {
                LibraryFiles reader;
                if (this.nodeProtoList[cI] != subCell) continue;
                if (this.xLibRefSatisfied[cI]) continue block0;
                if (!recursiveSetupFlag.contains(subCell) && (reader = this.getReaderForLib(subCell.getLibrary())) != null) {
                    reader.realizeCellsRecursively(subCell, recursiveSetupFlag, patchedCells, null, 0.0);
                }
                int startPort = this.firstPortIndex[cI];
                int endPort = startPort + this.portCounts[cI];
                for (int j2 = startPort; j2 < endPort; ++j2) {
                    Object obj = this.exportList[j2];
                    Export pp = null;
                    Cell otherCell = null;
                    if (!(obj instanceof Cell) || (pp = (Export)ELIB.findPortProto(otherCell = (Cell)obj, this.exportNameList[j2])) == null) continue;
                    this.exportList[j2] = pp;
                }
                this.xLibRefSatisfied[cI] = true;
                continue block0;
            }
        }
        this.scanNodesForRecursion(cell, recursiveSetupFlag, patchedCells, this.nodeInstList.protoType, startNode, endNode);
        ELIB.setProgressValue(++cellsConstructed * 100 / totalCells);
        double lambda = this.cellLambda[cellIndex];
        if (scaledCellName != null) {
            Cell oldCell = cell;
            cell = Cell.newInst(cell.getLibrary(), scaledCellName);
            cell.setTempInt(cellIndex);
            recursiveSetupFlag.add(cell);
            cell.joinGroup(oldCell);
            this.scaledCells.add(cell);
            lambda /= scale;
        } else {
            scale = 1.0;
        }
        int xoff = 0;
        int yoff = 0;
        for (i2 = startNode; i2 < endNode; ++i2) {
            NodeProto np = this.nodeInstList.protoType[i2];
            if (np != Generic.tech().cellCenterNode) continue;
            this.realizeNode(this.nodeInstList, i2, xoff, yoff, lambda, cell, np);
            xoff = (this.nodeInstList.lowX[i2] + this.nodeInstList.highX[i2]) / 2;
            yoff = (this.nodeInstList.lowY[i2] + this.nodeInstList.highY[i2]) / 2;
            break;
        }
        this.cellXOff[cellIndex] = xoff;
        this.cellYOff[cellIndex] = yoff;
        for (i2 = startNode; i2 < endNode; ++i2) {
            NodeProto np = this.nodeInstList.protoType[i2];
            if (np == Generic.tech().cellCenterNode) continue;
            if (np instanceof Cell) {
                np = this.scaleCell(i2, lambda, cell, recursiveSetupFlag, patchedCells);
            }
            this.realizeNode(this.nodeInstList, i2, xoff, yoff, lambda, cell, np);
        }
        this.realizeExports(cell, cellIndex, scaledCellName);
        this.realizeArcs(cell, cellIndex, scaledCellName, scale);
    }

    @Override
    protected boolean spreadLambda(Cell cell, int cellIndex) {
        boolean changed = false;
        int startNode = this.firstNodeIndex[cellIndex];
        int endNode = this.firstNodeIndex[cellIndex + 1];
        double thisLambda = this.cellLambda[cellIndex];
        for (int i2 = startNode; i2 < endNode; ++i2) {
            int subCellIndex;
            double subLambda;
            Cell subCell;
            NodeProto np = this.nodeInstList.protoType[i2];
            if (np instanceof PrimitiveNode || (subCell = (Cell)np).getVar(IO_DUMMY_OBJECT) != null) continue;
            LibraryFiles reader = this;
            if (subCell.getLibrary() != this.lib && (reader = this.getReaderForLib(subCell.getLibrary())) == null || !((subLambda = reader.cellLambda[subCellIndex = subCell.getTempInt()]) < thisLambda) || !cell.isSchematic() || !subCell.isIcon()) continue;
            reader.cellLambda[subCellIndex] = thisLambda;
            changed = true;
        }
        return changed;
    }

    @Override
    protected void computeTech(Cell cell, Set uncomputedCells) {
        int cellIndex;
        uncomputedCells.remove(cell);
        for (cellIndex = 0; cellIndex < this.nodeProtoCount && this.nodeProtoList[cellIndex] != cell; ++cellIndex) {
        }
        if (cellIndex >= this.nodeProtoCount) {
            return;
        }
        int startNode = this.firstNodeIndex[cellIndex];
        int endNode = this.firstNodeIndex[cellIndex + 1];
        for (int i2 = startNode; i2 < endNode; ++i2) {
            Cell subCell;
            LibraryFiles reader;
            NodeProto np;
            this.nodeInstList.protoType[i2] = np = this.convertNodeProto(this.nodeTypeList[i2]);
            if (!uncomputedCells.contains(np) || (reader = this.getReaderForLib((subCell = (Cell)np).getLibrary())) == null) continue;
            reader.computeTech(subCell, uncomputedCells);
        }
        int startArc = this.firstArcIndex[cellIndex];
        int endArc = this.firstArcIndex[cellIndex + 1];
        ArcProto[] arcTypes = new ArcProto[endArc - startArc];
        for (int i3 = 0; i3 < arcTypes.length; ++i3) {
            arcTypes[i3] = this.convertArcProto(this.arcTypeList[i3]);
        }
        Technology cellTech = Technology.whatTechnology(cell, this.nodeInstList.protoType, startNode, endNode, arcTypes);
        cell.setTechnology(cellTech);
    }

    @Override
    protected double computeLambda(Cell cell, int cellIndex) {
        Technology cellTech = cell.getTechnology();
        return cellTech != null ? this.getScale(cellTech) : 1.0;
    }

    private double getScale(Technology tech) {
        Double scale = this.techScale.get(tech);
        return scale != null ? scale.doubleValue() : tech.getScale();
    }

    @Override
    protected boolean canScale() {
        return true;
    }

    private void realizeExports(Cell cell, int cellIndex, String scaledCellName) {
        int startPort = this.firstPortIndex[cellIndex];
        int endPort = startPort + this.portCounts[cellIndex];
        CellId cellId = cell.getId();
        TreeSet<String> exportNames = new TreeSet<String>(TextUtils.STRING_NUMBER_ORDER);
        for (int i2 = startPort; i2 < endPort; ++i2) {
            exportNames.add(this.exportNameList[i2]);
        }
        for (String exportName : exportNames) {
            cellId.newPortId(exportName);
        }
        for (int i3 = startPort; i3 < endPort; ++i3) {
            String msg;
            String exportName;
            exportName = this.exportNameList[i3];
            int nodeIndex = this.exportSubNodeList[i3];
            if (nodeIndex < 0) {
                System.out.println("ERROR: " + String.valueOf(cell) + ": cannot find the node on which export " + exportName + " resides");
                continue;
            }
            NodeInst subNodeInst = this.nodeInstList.theNode[nodeIndex];
            PortProto subPortProto = this.convertPortProto(this.exportSubPortList[i3]);
            if (subNodeInst == null || subPortProto == null || subNodeInst.getParent() != cell || subNodeInst.getProto() != subPortProto.getParent()) {
                msg = "ERROR: " + String.valueOf(cell) + ": export " + this.exportNameList[i3] + " could not be created";
                System.out.println(msg);
                Input.errorLogger.logError(msg, cell, 1);
                continue;
            }
            if (subNodeInst.getProto() == null) {
                msg = "ERROR: " + String.valueOf(cell) + ": export " + this.exportNameList[i3] + " could not be created...proto bad!";
                System.out.println(msg);
                Input.errorLogger.logError(msg, cell, 1);
                continue;
            }
            PortInst pi = subNodeInst.findPortInst(subPortProto.getName());
            boolean alwaysDrawn = ImmutableExport.alwaysDrawnFromElib(this.exportUserbits[i3]);
            boolean bodyOnly = ImmutableExport.bodyOnlyFromElib(this.exportUserbits[i3]);
            PortCharacteristic characteristic = ImmutableExport.portCharacteristicFromElib(this.exportUserbits[i3]);
            ExportId exportId = cellId.newPortId(Name.findName(exportName).toString());
            TextDescriptor nameTextDescriptor = this.exportNameDescriptors[i3];
            if (nameTextDescriptor == null) {
                nameTextDescriptor = this.ep.getExportTextDescriptor();
            }
            Export pp = Export.newInstanceNoIcon(cell, exportId, null, nameTextDescriptor, pi, alwaysDrawn, bodyOnly, characteristic, errorLogger);
            this.exportList[i3] = pp;
            if (pp == null) continue;
            this.realizeVariables(pp, this.exportVariables[i3]);
        }
    }

    private void realizeArcs(Cell cell, int cellIndex, String scaledCellName, double scale) {
        double lambda = this.cellLambda[cellIndex] / scale;
        int xoff = this.cellXOff[cellIndex];
        int yoff = this.cellYOff[cellIndex];
        int startArc = this.firstArcIndex[cellIndex];
        int endArc = this.firstArcIndex[cellIndex + 1];
        for (int i2 = startArc; i2 < endArc; ++i2) {
            ArcInst ai;
            ArcProto ap = this.convertArcProto(this.arcTypeList[i2]);
            String name = this.arcNameList[i2];
            long gridExtendOverMin = this.getSizeCorrector(ap.getTechnology()).getExtendFromDisk(ap, (double)this.arcWidthList[i2] / lambda);
            double headX = (double)(this.arcHeadXPosList[i2] - xoff) / lambda;
            double headY = (double)(this.arcHeadYPosList[i2] - yoff) / lambda;
            double tailX = (double)(this.arcTailXPosList[i2] - xoff) / lambda;
            double tailY = (double)(this.arcTailYPosList[i2] - yoff) / lambda;
            if (this.arcHeadNodeList[i2] < 0) {
                System.out.println("ERROR: head of " + String.valueOf(ap) + " not known");
                continue;
            }
            NodeInst headNode = this.nodeInstList.theNode[this.arcHeadNodeList[i2]];
            int headPortIntValue = this.arcHeadPortList[i2];
            PortProto headPort = this.convertPortProto(headPortIntValue);
            String headname = "Port name not found";
            if (headPort != null) {
                headname = headPort.getName();
            } else if (headPortIntValue >= 0 && headPortIntValue < this.exportNameList.length) {
                headname = this.exportNameList[headPortIntValue];
            }
            if (this.arcTailNodeList[i2] < 0) {
                System.out.println("ERROR: tail of " + String.valueOf(ap) + " not known");
                continue;
            }
            NodeInst tailNode = this.nodeInstList.theNode[this.arcTailNodeList[i2]];
            int tailPortIntValue = this.arcTailPortList[i2];
            PortProto tailPort = this.convertPortProto(tailPortIntValue);
            String tailname = "Port name not found";
            if (tailPort != null) {
                tailname = tailPort.getName();
            } else if (tailPortIntValue >= 0 && tailPortIntValue < this.exportNameList.length) {
                tailname = this.exportNameList[tailPortIntValue];
            }
            PortInst headPortInst = this.getArcEnd(ap, headNode, headname, headX, headY, cell);
            PortInst tailPortInst = this.getArcEnd(ap, tailNode, tailname, tailX, tailY, cell);
            if (headPortInst == null || tailPortInst == null) {
                System.out.println("Cannot create arc of type " + ap.getName() + " in cell " + cell.getName() + " because ends are unknown");
                continue;
            }
            TextDescriptor nameDescriptor = this.arcNameDescriptorList[i2];
            if (nameDescriptor == null) {
                nameDescriptor = this.ep.getArcTextDescriptor();
            }
            this.arcList[i2] = ai = ArcInst.newInstanceNoCheck(cell, ap, name, nameDescriptor, headPortInst, tailPortInst, EPoint.fromLambda(headX, headY), EPoint.fromLambda(tailX, tailY), gridExtendOverMin, ImmutableArcInst.angleFromElib(this.arcUserBits[i2]), ImmutableArcInst.flagsFromElib(this.arcUserBits[i2]));
            if (ai == null) {
                String msg = "ERROR: " + String.valueOf(cell) + ": arc " + name + " could not be created";
                System.out.println(msg);
                Input.errorLogger.logError(msg, cell, 1);
                continue;
            }
            this.realizeVariables(ai, this.arcVariables[i2]);
        }
    }

    private Cell scaleCell(int i2, double lambda, Cell cell, HashSet<Cell> recursiveSetupFlag, HashSet<Cell> patchedCells) {
        double scaleY;
        Cell subCell = (Cell)this.nodeInstList.protoType[i2];
        ERectangle bounds = subCell.tree().getElibBounds(elibCellBounds);
        double width = (double)(this.nodeInstList.highX[i2] - this.nodeInstList.lowX[i2]) / lambda;
        double height = (double)(this.nodeInstList.highY[i2] - this.nodeInstList.lowY[i2]) / lambda;
        if (Math.abs(((RectangularShape)bounds).getWidth() - width) <= 0.5 && Math.abs(((RectangularShape)bounds).getHeight() - height) <= 0.5) {
            return subCell;
        }
        LibraryFiles reader = this;
        if (subCell.getLibrary() != this.lib) {
            reader = this.getReaderForLib(subCell.getLibrary());
        }
        if (!(reader != null && reader.canScale() && cell.isSchematic() && subCell.isIcon())) {
            return subCell;
        }
        double scaleX = width / ((RectangularShape)bounds).getWidth();
        if (!GenMath.doublesClose(scaleX, scaleY = height / ((RectangularShape)bounds).getHeight())) {
            return subCell;
        }
        double scale = Math.sqrt(scaleX * scaleY);
        String scaledCellName = subCell.getName() + "-SCALED-BY-" + scale + subCell.getView().getAbbreviationExtension();
        Cell scaledCell = subCell.getLibrary().findNodeProto(scaledCellName);
        if (scaledCell == null) {
            if (reader != null) {
                reader.realizeCellsRecursively(subCell, recursiveSetupFlag, patchedCells, scaledCellName, scale);
            }
            if ((scaledCell = subCell.getLibrary().findNodeProto(scaledCellName)) == null) {
                System.out.println("Error scaling " + String.valueOf(subCell) + " by " + scale);
            }
        }
        return scaledCell != null ? scaledCell : subCell;
    }

    protected PortInst getArcEnd(ArcProto ap, NodeInst node, String portname, double x, double y, Cell cell) {
        PortInst pi = null;
        String whatHappenedToPort = "not found";
        String nodeName = "missing node";
        if (node != null) {
            pi = node.findPortInst(portname);
            nodeName = node.getName();
            if (pi != null) {
                return pi;
            }
            Iterator<PortInst> it = node.getPortInsts();
            while (it.hasNext()) {
                pi = it.next();
                Poly portLocation = pi.getPoly();
                if (portLocation.contains(x, y) && pi.getPortProto().connectsTo(ap)) {
                    String msg = String.valueOf(cell) + ": Port '" + portname + "' on '" + nodeName + "' not found, connecting to port '" + pi.getPortProto().getName() + "' at the same location";
                    System.out.println("ERROR: " + msg);
                    Input.errorLogger.logError(msg, cell, 0);
                    return pi;
                }
                pi = null;
            }
            whatHappenedToPort = "is missing";
            Cell c2 = null;
            if (node.getProto() != null && node.isCellInstance() && ((Cell)node.getProto()).getVar(IO_DUMMY_OBJECT) != null) {
                c2 = (Cell)node.getProto();
            }
            if (c2 != null) {
                double anchorX = node.getAnchorCenterX();
                double anchorY = node.getAnchorCenterY();
                Point2D expected = new Point2D.Double(x, y);
                PrimitiveNode pn = Generic.tech().universalPinNode;
                FixpTransform trans = node.rotateIn();
                expected = trans.transform(expected, expected);
                Point2D.Double center = new Point2D.Double(expected.getX() - anchorX, expected.getY() - anchorY);
                NodeInst ni = NodeInst.newInst(pn, this.ep, center, 0.0, 0.0, c2, Orientation.IDENT, "");
                Export ex = Export.newInstanceNoIcon(c2, ni.getOnlyPortInst(), portname, this.ep, null);
                if (ex != null) {
                    return node.findPortInst(portname);
                }
            }
        }
        String msg = String.valueOf(cell) + ": Port '" + portname + "' on " + String.valueOf(node) + " " + whatHappenedToPort + ": leaving arc disconnected";
        System.out.println("ERROR: " + msg);
        PrimitiveNode pn = ap.findOverridablePinProto(this.ep);
        node = NodeInst.newInst(pn, this.ep, new Point2D.Double(x, y), pn.getDefWidth(this.ep), pn.getDefHeight(this.ep), cell);
        Input.errorLogger.logError(msg, node, cell, null, 0);
        return node.getOnlyPortInst();
    }

    private Header readHeader() throws IOException {
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        byte byte1 = this.readByte();
        byte byte2 = this.readByte();
        byte byte3 = this.readByte();
        byte byte4 = this.readByte();
        int magic = (byte4 & 0xFF) << 24 | (byte3 & 0xFF) << 16 | (byte2 & 0xFF) << 8 | byte1 & 0xFF;
        if (magic != -1573 && magic != -1575 && magic != -1577 && magic != -1579 && magic != -1581 && magic != -1583 && magic != -1585 && magic != -1587 && magic != -1589 && magic != -1591 && magic != -1593 && magic != -1595 && magic != -1597) {
            magic = (byte1 & 0xFF) << 24 | (byte2 & 0xFF) << 16 | (byte3 & 0xFF) << 8 | byte4 & 0xFF;
            if (magic != -1573 && magic != -1575 && magic != -1577 && magic != -1579 && magic != -1581 && magic != -1583 && magic != -1585 && magic != -1587 && magic != -1589 && magic != -1591 && magic != -1593 && magic != -1595 && magic != -1597) {
                System.out.println("Bad file format: does not start with proper magic number");
                return null;
            }
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        int sizeOfBig = 4;
        int sizeOfSmall = 2;
        byte sizeOfChar = 1;
        if (magic <= -1591) {
            sizeOfSmall = this.readByte();
            sizeOfBig = this.readByte();
        }
        if (magic <= -1593) {
            sizeOfChar = this.readByte();
        }
        return new Header(magic, byteOrder, sizeOfBig, sizeOfSmall, sizeOfChar);
    }

    private boolean readNodeProto(int cellIndex) throws IOException {
        Object theProtoName;
        if (this.header.magic <= -1589) {
            int nextInCell = -1;
            if (this.header.magic >= -1593) {
                k = this.readBigInteger();
                theProtoName = this.fakeCellList[k].cellName;
            } else {
                theProtoName = this.convertCellName(this.readString());
                k = this.readBigInteger();
                if (k == -1) {
                    k = cellIndex;
                }
                nextInCell = k;
                k = this.readBigInteger();
            }
            View v = this.getView(this.readBigInteger());
            if (v == null) {
                v = View.UNKNOWN;
            }
            int version = this.readBigInteger();
            theProtoName = (String)theProtoName + ";" + version + v.getAbbreviationExtension();
            this.cellNextInCellGroup[cellIndex] = nextInCell;
            this.cellCreationDate[cellIndex] = this.readBigInteger();
            this.cellRevisionDate[cellIndex] = this.readBigInteger();
        } else {
            theProtoName = this.readString();
        }
        this.cellProtoName[cellIndex] = theProtoName;
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        if (this.header.magic >= -1581) {
            this.readBigInteger();
            this.readBigInteger();
        }
        this.firstPortIndex[cellIndex] = this.exportIndex;
        int portCount = this.readBigInteger();
        if (portCount != this.portCounts[cellIndex]) {
            System.out.println("Error! Cell header lists " + this.portCounts[cellIndex] + " exports, but body lists " + portCount);
        }
        for (int j2 = 0; j2 < portCount; ++j2) {
            String exportName;
            this.exportSubNodeList[this.exportIndex] = -1;
            int whichNode = this.readBigInteger();
            if (whichNode >= 0 && whichNode < this.nodeCount) {
                this.exportSubNodeList[this.exportIndex] = whichNode;
            }
            this.exportSubPortList[this.exportIndex] = this.readBigInteger();
            this.exportNameList[this.exportIndex] = exportName = this.readString();
            if (this.exportSubNodeList[this.exportIndex] == -1) {
                System.out.println("Error: Export '" + exportName + "' of cell " + (String)theProtoName + " cannot be read properly");
            }
            int descript0 = 0;
            int descript1 = 0;
            if (this.header.magic <= -1589) {
                if (this.convertTextDescriptors) {
                    descript0 = this.readBigInteger();
                    descript1 = 0;
                } else {
                    descript0 = this.readBigInteger();
                    descript1 = this.readBigInteger();
                }
            }
            this.exportNameDescriptors[this.exportIndex] = this.makeDescriptor(descript0, descript1);
            if (this.header.magic > -1589) {
                this.readBigInteger();
            }
            this.exportUserbits[this.exportIndex] = 0;
            if (this.header.magic <= -1585) {
                this.exportUserbits[this.exportIndex] = this.readBigInteger();
                if (this.header.magic >= -1587) {
                    this.readBigInteger();
                }
            } else {
                if (this.toolBCount >= 1) {
                    this.exportUserbits[this.exportIndex] = this.readBigInteger();
                }
                for (int i2 = 1; i2 < this.toolBCount; ++i2) {
                    this.readBigInteger();
                }
            }
            this.exportVariables[this.exportIndex] = this.readVariables();
            ++this.exportIndex;
        }
        if (this.header.magic > -1581) {
            this.readBigInteger();
            this.readBigInteger();
            this.readBigInteger();
            this.readBigInteger();
            this.readBigInteger();
        }
        this.readBigInteger();
        int userBits = 0;
        if (this.header.magic <= -1585) {
            userBits = this.readBigInteger();
            if (this.header.magic >= -1587) {
                this.readBigInteger();
            }
        } else {
            if (this.toolBCount >= 1) {
                userBits = this.readBigInteger();
            }
            for (int i3 = 1; i3 < this.toolBCount; ++i3) {
                this.readBigInteger();
            }
        }
        this.cellUserBits[cellIndex] = userBits;
        this.cellVars[cellIndex] = this.readVariables();
        return false;
    }

    private void realizeNodeProto(int cellIndex, Map<Cell, Variable[]> originalVars) {
        String theProtoName = this.cellProtoName[cellIndex];
        Cell cell = Cell.newInst(this.lib, theProtoName);
        if (this.header.magic <= -1589) {
            cell.lowLevelSetCreationDate(ELIBConstants.secondsToDate(this.cellCreationDate[cellIndex]));
            cell.lowLevelSetRevisionDate(ELIBConstants.secondsToDate(this.cellRevisionDate[cellIndex]));
        }
        this.nodeProtoList[cellIndex] = cell;
        assert (cell.getCellName() != null);
        cell.lowLevelSetUserbits(this.cellUserBits[cellIndex]);
        originalVars.put(cell, this.cellVars[cellIndex]);
    }

    private boolean readExternalNodeProto(int cellIndex) throws IOException {
        int j2;
        String theProtoName;
        if (this.header.magic >= -1593) {
            int k2 = this.readBigInteger();
            theProtoName = this.fakeCellList[k2].cellName;
        } else {
            theProtoName = this.convertCellName(this.readString());
            this.readBigInteger();
            this.readBigInteger();
        }
        View v = this.getView(this.readBigInteger());
        if (v == null) {
            v = View.UNKNOWN;
        }
        int version = this.readBigInteger();
        String fullCellName = theProtoName + ";" + version + v.getAbbreviationExtension();
        if (version <= 1) {
            fullCellName = theProtoName + v.getAbbreviationExtension();
        }
        this.cellProtoName[cellIndex] = fullCellName;
        this.cellCreationDate[cellIndex] = this.readBigInteger();
        this.cellRevisionDate[cellIndex] = this.readBigInteger();
        this.cellLowX[cellIndex] = this.readBigInteger();
        this.cellHighX[cellIndex] = this.readBigInteger();
        this.cellLowY[cellIndex] = this.readBigInteger();
        this.cellHighY[cellIndex] = this.readBigInteger();
        this.cellLibraryPath[cellIndex] = this.readString();
        int portCount = this.readBigInteger();
        String[] localPortNames = new String[portCount];
        for (j2 = 0; j2 < portCount; ++j2) {
            localPortNames[j2] = this.readString();
        }
        this.firstPortIndex[cellIndex] = this.exportIndex;
        if (portCount != this.portCounts[cellIndex]) {
            System.out.println("Error! Cell header lists " + this.portCounts[cellIndex] + " exports, but body lists " + portCount);
        }
        for (j2 = 0; j2 < portCount; ++j2) {
            String protoName;
            this.exportNameList[this.exportIndex] = protoName = localPortNames[j2];
            ++this.exportIndex;
        }
        return false;
    }

    private boolean realizeExternalNodeProto(Library lib, int cellIndex) {
        String fullCellName = this.cellProtoName[cellIndex];
        Date creationDate = ELIBConstants.secondsToDate(this.cellCreationDate[cellIndex]);
        Date revisionDate = ELIBConstants.secondsToDate(this.cellRevisionDate[cellIndex]);
        int lowX = this.cellLowX[cellIndex];
        int highX = this.cellHighX[cellIndex];
        int lowY = this.cellLowY[cellIndex];
        int highY = this.cellHighY[cellIndex];
        Library elib = this.readExternalLibraryFromFilename(this.cellLibraryPath[cellIndex], FileType.ELIB, this.ep);
        Cell c2 = elib.findNodeProto(fullCellName);
        String dummyName = fullCellName;
        if (c2 == null) {
            c2 = elib.findNodeProto(dummyName);
        }
        if (c2 == null) {
            System.out.println("ERROR: Cannot find cell " + fullCellName + " in " + String.valueOf(elib));
        }
        if (c2 != null && revisionDate.compareTo(c2.getRevisionDate()) != 0) {
            System.out.println("Warning: cell " + c2.noLibDescribe() + " in " + String.valueOf(elib) + " has changed since its use in " + String.valueOf(lib));
        }
        if (c2 == null) {
            c2 = Cell.newInst(elib, dummyName);
            if (c2 == null) {
                return true;
            }
            c2.lowLevelSetCreationDate(creationDate);
            c2.lowLevelSetRevisionDate(revisionDate);
            Technology tech = Technology.getMocmosTechnology();
            if (c2.isIcon()) {
                tech = Artwork.tech();
            } else if (c2.isSchematic()) {
                tech = Schematics.tech();
            }
            double lambda = this.getScale(tech);
            int cX = (lowX + highX) / 2;
            int cY = (lowY + highY) / 2;
            double width = (double)(highX - lowX) / lambda;
            double height = (double)(highY - lowY) / lambda;
            Point2D.Double center = new Point2D.Double((double)cX / lambda, (double)cY / lambda);
            NodeInst.newInst(Generic.tech().drcNode, this.ep, center, width, height, c2);
            System.out.println("...Creating dummy cell '" + dummyName + "' in " + String.valueOf(elib) + ". Instances will be logged as Errors.");
            c2.newVar(IO_TRUE_LIBRARY, (Object)elib.getName(), this.ep);
            c2.newVar(IO_DUMMY_OBJECT, (Object)fullCellName, this.ep);
        }
        this.nodeProtoList[cellIndex] = c2;
        int portCount = this.portCounts[cellIndex];
        for (int j2 = 0; j2 < portCount; ++j2) {
            this.exportList[this.firstPortIndex[cellIndex] + j2] = c2;
        }
        return false;
    }

    private boolean readNodeInst(int nodeIndex, int cellIndex) throws IOException {
        String instName;
        int protoIndex;
        this.nodeTypeList[nodeIndex] = protoIndex = this.readBigInteger();
        this.nodeInstList.lowX[nodeIndex] = this.readBigInteger();
        this.nodeInstList.lowY[nodeIndex] = this.readBigInteger();
        this.nodeInstList.highX[nodeIndex] = this.readBigInteger();
        this.nodeInstList.highY[nodeIndex] = this.readBigInteger();
        if (this.header.magic <= -1597 && protoIndex >= 0) {
            this.nodeInstList.anchorX[nodeIndex] = this.readBigInteger();
            this.nodeInstList.anchorY[nodeIndex] = this.readBigInteger();
        }
        this.nodeInstList.transpose[nodeIndex] = this.readBigInteger();
        this.nodeInstList.rotation[nodeIndex] = (short)this.readBigInteger();
        this.nodeInstList.name[nodeIndex] = null;
        int descript0 = 0;
        int descript1 = 0;
        if (this.header.magic <= -1589) {
            if (this.convertTextDescriptors) {
                descript0 = this.readBigInteger();
            } else {
                descript0 = this.readBigInteger();
                descript1 = this.readBigInteger();
            }
        }
        this.nodeInstList.protoTextDescriptor[nodeIndex] = this.makeDescriptor(descript0, descript1);
        if (this.header.magic >= -1577 && (instName = this.readString()).length() > 0) {
            this.nodeInstList.name[nodeIndex] = instName;
        }
        if (this.header.magic > -1581) {
            this.readBigInteger();
        }
        int numPorts = this.readBigInteger();
        for (int j2 = 0; j2 < numPorts; ++j2) {
            int k2 = this.readBigInteger();
            int arcIndex = k2 >> 1;
            if (k2 < 0 || arcIndex >= this.arcCount) {
                return true;
            }
            int portIndex = this.readBigInteger();
            if ((k2 & 1) == 0) {
                this.arcTailPortList[arcIndex] = portIndex;
            } else {
                this.arcHeadPortList[arcIndex] = portIndex;
            }
            this.readVariables();
        }
        int numExports = this.readBigInteger();
        for (int j3 = 0; j3 < numExports; ++j3) {
            this.readBigInteger();
            this.readBigInteger();
            this.readVariables();
        }
        if (this.header.magic > -1589) {
            this.readBigInteger();
        }
        int userBits = 0;
        if (this.header.magic <= -1585) {
            userBits = this.readBigInteger();
        } else {
            if (this.toolBCount >= 1) {
                userBits = this.readBigInteger();
            }
            for (int i2 = 1; i2 < this.toolBCount; ++i2) {
                this.readBigInteger();
            }
        }
        this.nodeInstList.userBits[nodeIndex] = userBits;
        Variable[] vars = this.readVariables();
        for (int j4 = 0; j4 < vars.length; ++j4) {
            Object value;
            Variable var = vars[j4];
            if (var == null || var.getKey() != NodeInst.NODE_NAME || !((value = var.getObject()) instanceof String)) continue;
            this.nodeInstList.name[nodeIndex] = ELIB.convertGeomName(value, var.isDisplay());
            this.nodeInstList.nameTextDescriptor[nodeIndex] = var.getTextDescriptor();
            vars[j4] = null;
        }
        this.nodeInstList.vars[nodeIndex] = vars;
        return false;
    }

    private boolean readArcInst(int arcIndex) throws IOException {
        String instName;
        this.arcTypeList[arcIndex] = this.readBigInteger();
        if (this.header.magic >= -1581) {
            this.readBigInteger();
        }
        this.arcWidthList[arcIndex] = this.readBigInteger();
        if (this.header.magic <= -1583 && this.header.magic >= -1587) {
            this.readBigInteger();
        }
        if (this.header.magic >= -1577 && (instName = this.readString()).length() > 0) {
            this.arcNameList[arcIndex] = instName;
        }
        this.arcTailXPosList[arcIndex] = this.readBigInteger();
        this.arcTailYPosList[arcIndex] = this.readBigInteger();
        int tailNodeIndex = this.readBigInteger();
        if (tailNodeIndex >= 0 && tailNodeIndex < this.nodeCount) {
            this.arcTailNodeList[arcIndex] = tailNodeIndex;
        }
        this.arcHeadXPosList[arcIndex] = this.readBigInteger();
        this.arcHeadYPosList[arcIndex] = this.readBigInteger();
        int headNodeIndex = this.readBigInteger();
        if (headNodeIndex >= 0 && headNodeIndex < this.nodeCount) {
            this.arcHeadNodeList[arcIndex] = headNodeIndex;
        }
        if (this.header.magic > -1581) {
            this.readBigInteger();
        }
        if (this.header.magic > -1589) {
            this.readBigInteger();
        }
        int userBits = 0;
        if (this.header.magic <= -1585) {
            userBits = this.readBigInteger();
            if (this.header.magic >= -1587) {
                this.readBigInteger();
            }
        } else {
            if (this.toolBCount >= 1) {
                userBits = this.readBigInteger();
            }
            for (int i2 = 1; i2 < this.toolBCount; ++i2) {
                this.readBigInteger();
            }
        }
        this.arcUserBits[arcIndex] = userBits;
        Variable[] vars = this.readVariables();
        for (int i3 = 0; i3 < vars.length; ++i3) {
            Object value;
            Variable var = vars[i3];
            if (var == null || var.getKey() != ArcInst.ARC_NAME || !((value = var.getObject()) instanceof String)) continue;
            this.arcNameList[arcIndex] = ELIB.convertGeomName(value, var.isDisplay());
            this.arcNameDescriptorList[arcIndex] = var.getTextDescriptor();
            vars[i3] = null;
        }
        this.arcVariables[arcIndex] = vars;
        return false;
    }

    private void readGeom(boolean[] isNode, int[] moreup, int index) throws IOException {
        int type = this.readBigInteger();
        isNode[index] = type != 0;
        if (isNode[index]) {
            this.readBigInteger();
        }
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        moreup[index] = this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readVariables();
    }

    private void readNameSpace() throws IOException {
        int nameCount = this.readBigInteger();
        this.varNames = new String[nameCount];
        this.varKeys = new Variable.Key[nameCount];
        for (int i2 = 0; i2 < nameCount; ++i2) {
            this.varNames[i2] = this.readString();
        }
    }

    private Variable[] readVariables() throws IOException {
        int count = this.readBigInteger();
        if (count == 0) {
            return Variable.NULL_ARRAY;
        }
        Variable[] vars = new Variable[count];
        for (int i2 = 0; i2 < count; ++i2) {
            NodeProtoId[] newAddr;
            short key = this.readSmallInteger();
            if (key < 0 || key >= this.varKeys.length) {
                String msg = "Bad variable index (" + key + ", limit is " + this.varKeys.length + ")";
                System.out.println(msg);
                throw new IOException(msg);
            }
            if (this.varKeys[key] == null) {
                this.varKeys[key] = Variable.newKey(this.varNames[key]);
            }
            int newtype = this.readBigInteger();
            int descript0 = 0;
            int descript1 = 0;
            if (this.header.magic <= -1589) {
                if (this.alwaysTextDescriptors) {
                    descript0 = this.readBigInteger();
                    descript1 = this.readBigInteger();
                } else if ((newtype & 0x40) != 0) {
                    if (this.convertTextDescriptors) {
                        descript0 = this.readBigInteger();
                    } else {
                        descript0 = this.readBigInteger();
                        descript1 = this.readBigInteger();
                    }
                }
            }
            TextDescriptor td = this.makeDescriptor(descript0, descript1, newtype);
            CodeExpression.Code code = CodeExpression.Code.getByCBits(newtype);
            if ((newtype & 0x80) != 0) {
                int len;
                int cou = len = this.readBigInteger();
                Object[] newAddrArray = null;
                switch (newtype & 0x1F) {
                    case 1: 
                    case 2: {
                        newAddrArray = new Integer[cou];
                        break;
                    }
                    case 5: 
                    case 19: {
                        newAddrArray = new Float[cou];
                        break;
                    }
                    case 6: {
                        newAddrArray = new Double[cou];
                        break;
                    }
                    case 25: {
                        newAddrArray = new Short[cou];
                        break;
                    }
                    case 30: {
                        newAddrArray = new Boolean[cou];
                        break;
                    }
                    case 3: {
                        newAddrArray = new Byte[cou];
                        break;
                    }
                    case 4: {
                        newAddrArray = new String[cou];
                        break;
                    }
                    case 8: {
                        newAddrArray = new NodeProtoId[cou];
                        break;
                    }
                    case 13: {
                        newAddrArray = new ArcProtoId[cou];
                        break;
                    }
                    case 11: {
                        newAddrArray = new ExportId[cou];
                        break;
                    }
                    case 16: {
                        newAddrArray = new TechId[cou];
                        break;
                    }
                    case 15: {
                        newAddrArray = new LibId[cou];
                        break;
                    }
                    case 17: {
                        newAddrArray = new Tool[cou];
                    }
                }
                newAddr = newAddrArray;
                if ((newtype & 0x1F) == 27) {
                    for (j = 0; j < len; j += 2) {
                        this.readBigInteger();
                        this.readBigInteger();
                        if (newAddrArray == null) continue;
                        newAddrArray[j] = null;
                    }
                } else {
                    for (j = 0; j < len; ++j) {
                        Object ret = this.getInVar(newtype);
                        if (newAddrArray == null) continue;
                        newAddrArray[j] = ret;
                    }
                }
                if (newAddrArray == null) {
                    String msg = "Cannot figure out the type for code " + (newtype & 0x1F);
                    System.out.println(msg);
                    continue;
                }
                if (newAddrArray instanceof NodeProtoId[]) {
                    int numCells = 0;
                    int numPrims = 0;
                    for (int j2 = 0; j2 < newAddrArray.length; ++j2) {
                        if (newAddrArray[j2] == null) continue;
                        if (newAddrArray[j2] instanceof CellId) {
                            ++numCells;
                        }
                        if (!(newAddrArray[j2] instanceof PrimitiveNodeId)) continue;
                        ++numPrims;
                    }
                    if (numCells >= numPrims) {
                        CellId[] cellArray = new CellId[newAddrArray.length];
                        for (j = 0; j < cellArray.length; ++j) {
                            if (!(newAddrArray[j] instanceof CellId)) continue;
                            cellArray[j] = (CellId)newAddrArray[j];
                        }
                        newAddr = cellArray;
                    } else {
                        PrimitiveNodeId[] primArray = new PrimitiveNodeId[newAddrArray.length];
                        for (j = 0; j < primArray.length; ++j) {
                            if (!(newAddrArray[j] instanceof PrimitiveNodeId)) continue;
                            primArray[j] = (PrimitiveNodeId)newAddrArray[j];
                        }
                        newAddr = primArray;
                    }
                }
            } else {
                newAddr = this.getInVar(newtype);
            }
            if (newAddr == null) {
                System.out.println("Error reading variable " + this.varNames[key] + " type " + newtype);
                continue;
            }
            newAddr = Variable.withCode(newAddr, code);
            vars[i2] = Variable.newInst(this.varKeys[key], newAddr, td);
        }
        return vars;
    }

    private Object getInVar(int ty) throws IOException {
        if ((ty & 0x20000020) != 0) {
            ty = 4;
        }
        switch (ty & 0x1F) {
            case 1: 
            case 2: {
                return this.readBigInteger();
            }
            case 19: {
                return Float.valueOf((float)this.readBigInteger() / 120.0f);
            }
            case 5: {
                return Float.valueOf(this.readFloat());
            }
            case 6: {
                return this.readDouble();
            }
            case 25: {
                return this.readSmallInteger();
            }
            case 30: {
                return this.readByte() != 0;
            }
            case 3: {
                return this.readByte();
            }
            case 4: {
                return this.readString();
            }
            case 7: {
                int i2 = this.readBigInteger();
                System.out.println("Cannot read variable of type NodeInst");
                return null;
            }
            case 8: {
                int i3 = this.readBigInteger();
                NodeProto np = this.convertNodeProto(i3);
                if (np == null) {
                    return np;
                }
                return np instanceof Cell ? ((Cell)np).getId() : ((PrimitiveNode)np).getId();
            }
            case 13: {
                int i4 = this.readBigInteger();
                if (i4 == -1) {
                    System.out.println("Variable of type ArcProto has negative index");
                    return null;
                }
                return this.convertArcProto(i4).getId();
            }
            case 11: {
                int i5 = this.readBigInteger();
                PortProto pp = this.convertPortProto(i5);
                if (!(pp instanceof Export)) {
                    return null;
                }
                return ((Export)pp).getId();
            }
            case 12: {
                int i6 = this.readBigInteger();
                System.out.println("Cannot read variable of type ArcInst");
                return null;
            }
            case 14: {
                this.readBigInteger();
                this.readBigInteger();
                System.out.println("Cannot read variable of type Geometric");
                return null;
            }
            case 16: {
                int i7 = this.readBigInteger();
                if (i7 == -1) {
                    System.out.println("Variable of type Technology has negative index");
                    return null;
                }
                return this.getTechList(i7).getId();
            }
            case 9: {
                this.readBigInteger();
                System.out.println("Cannot read variable of type PortArcInst");
                return null;
            }
            case 10: {
                this.readBigInteger();
                System.out.println("Cannot read variable of type PortExpInst");
                return null;
            }
            case 15: {
                String libName = this.readString();
                if (libName.length() == 0) {
                    return null;
                }
                return this.idManager.newLibId(libName);
            }
            case 17: {
                int i8 = this.readBigInteger();
                if (i8 < 0 || i8 >= this.toolCount) {
                    return null;
                }
                Tool tool = this.toolList[i8];
                if (tool == null && this.toolError[i8 = 0] != null) {
                    System.out.println("WARNING: no tool called '" + this.toolError[i8] + "', using 'user'");
                    this.toolError[i8] = null;
                }
                return tool;
            }
            case 18: {
                this.readBigInteger();
                System.out.println("Cannot read variable of type RTNode");
                return null;
            }
        }
        System.out.println("Cannot read variable of type " + (ty & 0x1F));
        return null;
    }

    private NodeProto convertNodeProto(int i2) {
        if (i2 == -1) {
            return null;
        }
        if (i2 < 0) {
            int nindex = -i2 - 2;
            if (nindex >= this.primNodeProtoCount) {
                System.out.println("Error: want primitive node index " + nindex + " when limit is " + this.primNodeProtoCount);
                return null;
            }
            return this.getPrimNodeProtoList(nindex);
        }
        if (i2 >= this.nodeProtoCount) {
            System.out.println("Error: want cell index " + i2 + " when limit is " + this.nodeProtoCount);
            return null;
        }
        return this.nodeProtoList[i2];
    }

    private ArcProto convertArcProto(int i2) {
        int aindex = -i2 - 2;
        if (aindex >= this.arcProtoCount || aindex < 0) {
            System.out.println("Want primitive arc index " + aindex + " when range is 0 to " + this.arcProtoCount);
            aindex = 0;
        }
        return this.getArcProtoList(aindex);
    }

    private PortProto convertPortProto(int i2) {
        if (i2 == -1) {
            return null;
        }
        if (i2 < 0) {
            int pindex = -i2 - 2;
            if (pindex >= this.primPortProtoCount) {
                System.out.println("Error: want primitive port index " + pindex + " when limit is " + this.primPortProtoCount);
                pindex = 0;
            }
            return this.getPrimPortProtoList(pindex);
        }
        if (i2 >= this.exportCount) {
            System.out.println("Error: want port index " + i2 + " when limit is " + this.exportCount);
            i2 = 0;
        }
        if (this.exportList[i2] instanceof Cell) {
            return null;
        }
        return (Export)this.exportList[i2];
    }

    private NodeProto getPrimNodeProtoList(int i2) {
        this.getTechList(this.primNodeProtoTech[i2]);
        if (this.primNodeProtoError[i2]) {
            System.out.println("Cannot find primitive '" + this.primNodeProtoOrig[i2] + "', using " + this.primNodeProtoList[i2].getName());
            this.primNodeProtoError[i2] = false;
        }
        return this.primNodeProtoList[i2];
    }

    private ArcProto getArcProtoList(int i2) {
        if (this.arcProtoError[i2] != null) {
            System.out.println("Cannot find arc '" + this.arcProtoError[i2] + "', using " + this.arcProtoList[i2].getName());
            this.arcProtoError[i2] = null;
        }
        return this.arcProtoList[i2];
    }

    private PortProto getPrimPortProtoList(int i2) {
        if (this.primPortProtoError[i2] != null) {
            System.out.println("WARNING: port " + this.primPortProtoError[i2] + " not found, using " + this.primPortProtoList[i2].getName());
            this.primPortProtoError[i2] = null;
        }
        return this.primPortProtoList[i2];
    }

    private Technology getTechList(int i2) {
        if (this.techError[i2] != null) {
            System.out.println("WARNING: technology '" + this.techError[i2] + "' does not exist, using '" + this.techList[i2].getTechName() + "'");
            this.techError[i2] = null;
        }
        return this.techList[i2];
    }

    private View getView(int i2) {
        View v = this.viewMapping.get(i2);
        return v;
    }

    private byte readByte() throws IOException {
        int value = this.dataInputStream.read();
        if (value == -1) {
            throw new IOException();
        }
        this.updateProgressDialog(1);
        return (byte)value;
    }

    private int readBigInteger() throws IOException {
        if (this.header.sizeOfBig == 4) {
            this.updateProgressDialog(4);
            int data = this.dataInputStream.readInt();
            if (!this.header.bytesSwapped) {
                data = data >> 24 & 0xFF | data >> 8 & 0xFF00 | (data & 0xFF00) << 8 | (data & 0xFF) << 24;
            }
            return data;
        }
        this.readBytes(rawData, this.header.sizeOfBig, 4, true);
        if (this.header.bytesSwapped) {
            bb.put(0, rawData[0]);
            bb.put(1, rawData[1]);
            bb.put(2, rawData[2]);
            bb.put(3, rawData[3]);
        } else {
            bb.put(0, rawData[3]);
            bb.put(1, rawData[2]);
            bb.put(2, rawData[1]);
            bb.put(3, rawData[0]);
        }
        return bb.getInt(0);
    }

    private float readFloat() throws IOException {
        if (this.header.bytesSwapped) {
            this.updateProgressDialog(4);
            return this.dataInputStream.readFloat();
        }
        this.readBytes(rawData, this.header.sizeOfBig, 4, true);
        bb.put(0, rawData[3]);
        bb.put(1, rawData[2]);
        bb.put(2, rawData[1]);
        bb.put(3, rawData[0]);
        return bb.getFloat(0);
    }

    private double readDouble() throws IOException {
        if (this.header.bytesSwapped) {
            this.updateProgressDialog(8);
            return this.dataInputStream.readDouble();
        }
        this.readBytes(rawData, this.header.sizeOfBig, 8, true);
        bb.put(0, rawData[7]);
        bb.put(1, rawData[2]);
        bb.put(2, rawData[3]);
        bb.put(3, rawData[4]);
        bb.put(4, rawData[3]);
        bb.put(5, rawData[2]);
        bb.put(6, rawData[1]);
        bb.put(7, rawData[0]);
        return bb.getDouble(0);
    }

    private short readSmallInteger() throws IOException {
        if (this.header.sizeOfSmall == 2) {
            this.updateProgressDialog(2);
            int data = this.dataInputStream.readShort();
            if (!this.header.bytesSwapped) {
                data = data >> 8 & 0xFF | (data & 0xFF) << 8;
            }
            return (short)data;
        }
        this.readBytes(rawData, this.header.sizeOfSmall, 2, true);
        if (this.header.bytesSwapped) {
            bb.put(0, rawData[0]);
            bb.put(1, rawData[1]);
        } else {
            bb.put(0, rawData[1]);
            bb.put(1, rawData[0]);
        }
        return bb.getShort(0);
    }

    private String readString() throws IOException {
        if (this.header.sizeOfChar != 1) {
            System.out.println("Cannot handle library files with unicode strings");
            return null;
        }
        int len = this.readBigInteger();
        if (len <= 0) {
            return "";
        }
        if ((long)len > this.fileLength - this.byteCount) {
            System.out.println("Corrupt ELIB file requests string that is " + len + " long");
            throw new IOException();
        }
        byte[] stringBytes = new byte[len];
        int ret = this.dataInputStream.read(stringBytes, 0, len);
        if (ret != len) {
            throw new IOException();
        }
        this.updateProgressDialog(len);
        String theString = new String(stringBytes);
        return theString;
    }

    private void readBytes(byte[] data, int diskSize, int memorySize, boolean signExtend) throws IOException {
        if (diskSize == memorySize) {
            int ret = this.dataInputStream.read(data, 0, diskSize);
            if (ret != diskSize) {
                throw new IOException();
            }
        } else {
            int ret = this.dataInputStream.read(rawData, 0, diskSize);
            if (ret != diskSize) {
                throw new IOException();
            }
            if (diskSize > memorySize) {
                for (int i2 = 0; i2 < memorySize; ++i2) {
                    data[i2] = rawData[i2];
                }
            } else {
                int i3;
                if (!signExtend || (rawData[diskSize - 1] & 0x80) == 0) {
                    for (i3 = diskSize; i3 < memorySize; ++i3) {
                        ELIB.rawData[i3] = 0;
                    }
                } else {
                    for (i3 = diskSize; i3 < memorySize; ++i3) {
                        ELIB.rawData[i3] = -1;
                    }
                }
                for (i3 = 0; i3 < memorySize; ++i3) {
                    data[i3] = rawData[i3];
                }
            }
        }
        this.updateProgressDialog(diskSize);
    }

    public static class Header
    implements Comparable,
    Serializable {
        static final Header DEFAULT = new Header(-1597, ByteOrder.BIG_ENDIAN, 4, 2, 1);
        private final int magic;
        private final boolean bytesSwapped;
        private final int sizeOfBig;
        private final int sizeOfSmall;
        private final int sizeOfChar;
        private final String s;

        Header(int magic, ByteOrder byteOrder, int sizeOfBig, int sizeOfSmall, int sizeOfChar) {
            this.magic = magic;
            this.bytesSwapped = byteOrder == ByteOrder.BIG_ENDIAN;
            this.sizeOfBig = sizeOfBig;
            this.sizeOfSmall = sizeOfSmall;
            this.sizeOfChar = sizeOfChar;
            int magicNum = -1571 - magic;
            String s = "MAGIC" + magicNum / 2;
            if (magicNum % 2 != 0) {
                s = s + "?";
            }
            if (byteOrder != ByteOrder.BIG_ENDIAN) {
                s = s + "L";
            }
            if (sizeOfBig != 4) {
                s = s + "I" + sizeOfBig;
            }
            if (sizeOfSmall != 2) {
                s = s + "S" + sizeOfSmall;
            }
            if (sizeOfChar != 1) {
                s = s + "C" + sizeOfChar;
            }
            this.s = s;
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
        }

        public int hashCode() {
            return this.s.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Header) {
                Header h2 = (Header)obj;
                return this.s.equals(h2.s);
            }
            return false;
        }

        public int compareTo(Object o2) {
            Header h2 = (Header)o2;
            return TextUtils.STRING_NUMBER_ORDER.compare(this.s, h2.s);
        }

        public String toString() {
            return this.s;
        }
    }

    private static class FakeCell {
        String cellName;

        private FakeCell() {
        }
    }
}

