/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouter;
import com.sun.electric.tool.generator.layout.TrackRouterH;

class Nor2_star {
    private static final double nmosTop = -9.0;
    private static final double pmosBot = 9.0;
    private static final double wellOverhangDiff = 6.0;
    private static final double inaY = 4.0;
    private static final double inbY = -4.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;

    Nor2_star() {
    }

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    static Cell makePart(double sz, String threshold, StdCellParams stdCell) {
        int i2;
        int i3;
        TechType tech = stdCell.getTechType();
        EditingPreferences ep = stdCell.getEditingPreferences();
        sz = stdCell.roundSize(sz);
        Nor2_star.error(!threshold.equals("") && !threshold.equals("LT"), "Nor2: threshold not \"\" or \"LT\": " + threshold);
        String nm = "nor2" + threshold;
        sz = stdCell.checkMinStrength(sz, 1.0, nm);
        int nbStackedP = 2;
        double spaceAvail = stdCell.getCellTop() - 6.0 - 9.0;
        double totWid = sz * (double)nbStackedP * (double)(threshold.equals("LT") ? 3 : 6);
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 1);
        Nor2_star.error(fwP == null, "can't make nor2 this small: " + sz);
        spaceAvail = -9.0 - (stdCell.getCellBot() + 6.0);
        totWid = sz * 3.0 * 2.0;
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 2);
        Nor2_star.error(fwN == null, "can't make nor2 this small: " + sz);
        Cell nor = stdCell.findPart(nm, sz);
        if (nor != null) {
            return nor;
        }
        nor = stdCell.newPart(nm, sz);
        double inbX = 3.5;
        double nmosX = inbX + 2.0 + 3.0 + 2.0;
        double pmosX = nmosX + 3.0;
        double pmosY = 9.0 + fwP.physWid / 2.0;
        FoldedPmos pmos = new FoldedPmos(pmosX, pmosY, fwP.nbFolds, nbStackedP, fwP.gateWid, nor, tech, ep);
        double nmosY = -9.0 - fwN.physWid / 2.0;
        FoldedMos[] nmoss = new FoldedMos[fwN.nbFolds / 2];
        for (int nbFoldsN = 0; nbFoldsN < fwN.nbFolds; nbFoldsN += 2) {
            double nmosPitch = 26.0;
            double x = nmosX + (double)(nbFoldsN / 2) * nmosPitch;
            FoldedNmos nmos = new FoldedNmos(x, nmosY, 2, 1, fwN.gateWid, nor, tech, ep);
            nmoss[nbFoldsN / 2] = nmos;
        }
        stdCell.fillDiffAndSelectNotches(nmoss, true);
        stdCell.wireVddGnd(nmoss, StdCellParams.EVEN, nor);
        stdCell.wireVddGnd(pmos, StdCellParams.EVEN, nor);
        double inaX = StdCellParams.getRightDiffX(pmos, nmoss) + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nor, "ina", ep, PortCharacteristic.IN, tech.m1(), 4.0, inaX, 4.0);
        TrackRouterH inA = new TrackRouterH(tech.m1(), 3.0, 4.0, tech, ep, nor);
        inA.connect(nor.findExport("ina"));
        for (i3 = 0; i3 < pmos.nbGates(); i3 += 2) {
            if (i3 / 2 % 2 == 0) {
                ((TrackRouter)inA).connect(pmos.getGate(i3, 'B'), -4.0, tech.getPolyLShapeOffset());
                continue;
            }
            ((TrackRouter)inA).connect(pmos.getGate(i3 + 1, 'B'), 4.0, tech.getPolyLShapeOffset());
        }
        for (i3 = 0; i3 < nmoss.length; ++i3) {
            inA.connect(nmoss[i3].getGate(0, 'T'), -1.0);
        }
        LayoutLib.newExport(nor, "inb", ep, PortCharacteristic.IN, tech.m1(), 4.0, inbX, -4.0);
        TrackRouterH inb = new TrackRouterH(tech.m1(), 3.0, -4.0, tech, ep, nor);
        inb.connect(nor.findExport("inb"));
        for (i2 = 0; i2 < pmos.nbGates(); i2 += 2) {
            if (i2 / 2 % 2 == 0) {
                inb.connect(pmos.getGate(i2 + 1, 'B'));
                continue;
            }
            inb.connect(pmos.getGate(i2, 'B'));
        }
        for (i2 = 0; i2 < nmoss.length; ++i2) {
            inb.connect(nmoss[i2].getGate(1, 'T'));
        }
        double outX = inaX + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nor, "out", ep, PortCharacteristic.OUT, tech.m1(), 4.0, outX, 11.0);
        TrackRouterH outHi = new TrackRouterH(tech.m2(), 4.0, 11.0, tech, ep, nor);
        outHi.connect(nor.findExport("out"));
        for (int i4 = 1; i4 < pmos.nbSrcDrns(); i4 += 2) {
            outHi.connect(pmos.getSrcDrn(i4));
        }
        TrackRouterH outLo = new TrackRouterH(tech.m2(), 4.0, -11.0, tech, ep, nor);
        outLo.connect(nor.findExport("out"));
        for (int i5 = 0; i5 < nmoss.length; ++i5) {
            for (int j2 = 1; j2 < nmoss[i5].nbSrcDrns(); j2 += 2) {
                outLo.connect(nmoss[i5].getSrcDrn(j2));
            }
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, nor);
        stdCell.addPmosWell(wellMinX, wellMaxX, nor);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, nor);
        stdCell.doNCC(nor, nm + "{sch}");
        return nor;
    }
}

