/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class Nms2_sy {
    private static final double gY = -4.0;
    private static final double dY = -11.0;
    private static final double nmosTop = -8.5;

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    public static Cell makePart(double sz, StdCellParams stdCell) {
        int nbStacked;
        double totWid;
        TechType tech = stdCell.getTechType();
        EditingPreferences ep = stdCell.getEditingPreferences();
        sz = stdCell.roundSize(sz);
        String nm = "nms2_sy";
        sz = stdCell.checkMinStrength(sz, 1.0, nm);
        double nmosLowest = stdCell.getCellBot() + 1.5 + 5.0 + 2.0;
        double spaceAvail = -8.5 - nmosLowest;
        FoldsAndWidth fw = stdCell.calcFoldsAndWidth(spaceAvail, totWid = sz * 3.0 * (double)(nbStacked = 2), 2);
        Nms2_sy.error(fw == null, "can't make Nms2_sy this small: " + sz);
        double g2FromGndY = stdCell.getGndY() - stdCell.getGndWidth() / 2.0 - 3.0 - 2.0;
        double g2FromMosY = -8.5 - fw.physWid - 2.0 - 2.5;
        double g2Y = Math.min(g2FromGndY, g2FromMosY);
        Cell nms2 = stdCell.findPart(nm, sz);
        if (nms2 != null) {
            return nms2;
        }
        nms2 = stdCell.newPart(nm, sz);
        double gX = 3.5;
        LayoutLib.newExport(nms2, "g", ep, PortCharacteristic.IN, tech.m1(), 4.0, gX, -4.0);
        double mosX = gX + 2.0 + 3.0 + 2.0;
        double nmosY = -8.5 - fw.physWid / 2.0;
        FoldedNmos nmos = new FoldedNmos(mosX, nmosY, fw.nbFolds, nbStacked, fw.gateWid, nms2, tech, ep);
        double g2X = StdCellParams.getRightDiffX(nmos) + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nms2, "g2", ep, PortCharacteristic.IN, tech.m1(), 4.0, g2X, g2Y);
        double dX = g2X + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nms2, "d", ep, PortCharacteristic.OUT, tech.m1(), 4.0, dX, -11.0);
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, nms2);
        TrackRouterH g2 = new TrackRouterH(tech.m1(), 3.0, -4.0, tech, ep, nms2);
        TrackRouterH g22 = new TrackRouterH(tech.m1(), 3.0, g2Y, tech, ep, nms2);
        g2.connect(nms2.findExport("g"));
        g22.connect(nms2.findExport("g2"));
        block4: for (int i2 = 0; i2 < nmos.nbGates(); ++i2) {
            switch (i2 % 2) {
                case 0: {
                    g2.connect(nmos.getGate(i2, 'T'), -1.5);
                    continue block4;
                }
                case 1: {
                    g22.connect(nmos.getGate(i2, 'B'), 1.5);
                }
            }
        }
        TrackRouterH d2 = new TrackRouterH(tech.m2(), 4.0, -11.0, tech, ep, nms2);
        d2.connect(nms2.findExport("d"));
        for (int i3 = 1; i3 < nmos.nbSrcDrns(); i3 += 2) {
            d2.connect(nmos.getSrcDrn(i3));
        }
        double wellMinX = 0.0;
        double wellMaxX = dX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, nms2);
        stdCell.addNstackEssentialBounds(wellMinX, wellMaxX, nms2);
        stdCell.doNCC(nms2, nm + "{sch}");
        return nms2;
    }
}

