/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouter;
import com.sun.electric.tool.generator.layout.TrackRouterH;

class Nand3_star_en_sy3 {
    private static final double DEF_SIZE = Double.POSITIVE_INFINITY;
    private static final double nmosTop = -9.0;
    private static final double pmosBot = 9.0;
    private static final double incY = -4.0;
    private static final double inbY = 4.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;

    Nand3_star_en_sy3() {
    }

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    static Cell makePart(double sz, String threshold, StdCellParams stdCell) {
        int i2;
        int i3;
        TechType tech = stdCell.getTechType();
        EditingPreferences ep = stdCell.getEditingPreferences();
        sz = stdCell.roundSize(sz);
        Nand3_star_en_sy3.error(!threshold.equals("") && !threshold.equals("LT"), "Nand3en_sy3: threshold not \"\" or \"LT\": " + threshold);
        String nm = "nand3" + threshold + "en_sy3";
        double spaceAvail = stdCell.getCellTop() - 8.5 - 9.0;
        double lamPerSz = threshold.equals("LT") ? 2.0 : 6.0;
        double totWid = sz * lamPerSz * 2.0;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 2);
        Nand3_star_en_sy3.error(fwP == null, "can't make " + nm + " this small: " + sz);
        totWid = Math.max(5.0, sz * lamPerSz / 10.0);
        double weakBot = 11.5;
        spaceAvail = spaceAvail + 9.0 - weakBot;
        FoldsAndWidth fwW = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 1);
        Nand3_star_en_sy3.error(fwW == null, "can't make " + nm + " weak PMOS should never have a problem");
        int nbStackedN = 3;
        spaceAvail = -9.0 - (stdCell.getCellBot() + 2.0 + 3.0 + 5.0 + 1.5);
        totWid = sz * 3.0 * (double)nbStackedN;
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 3);
        Nand3_star_en_sy3.error(fwN == null, "can't make " + nm + " this small: " + sz);
        Cell nand = stdCell.findPart(nm, sz);
        if (nand != null) {
            return nand;
        }
        nand = stdCell.newPart(nm, sz);
        double inbX = 3.5;
        double incX = inbX + 2.0 + 3.0 + 2.0;
        double jogbX = incX + 2.0 + 3.0 + 2.0;
        double nmosX = jogbX + 2.0 + 3.0 + 2.0;
        FoldedNmos nmos = new FoldedNmos(nmosX, -9.0 - fwN.physWid / 2.0, fwN.nbFolds, nbStackedN, fwN.gateWid, nand, tech, ep);
        double pmosY = 9.0 + fwP.physWid / 2.0;
        FoldedMos[] pmoss = new FoldedMos[(int)Math.ceil((double)fwP.nbFolds / 12.0)];
        for (int i4 = 0; i4 < pmoss.length; ++i4) {
            double pmosPitch = 108.0;
            double pmosX = nmosX + 6.0 + (double)i4 * pmosPitch;
            int nbFolds = Math.min(12, fwP.nbFolds - i4 * 12);
            pmoss[i4] = new FoldedPmos(pmosX, pmosY, nbFolds, 1, fwP.gateWid, nand, tech, ep);
        }
        double weakX = StdCellParams.getRightDiffX(pmoss) + 12.0;
        double weakY = weakBot + fwW.physWid / 2.0;
        FoldedPmos weak = new FoldedPmos(weakX, weakY, fwW.nbFolds, 1, fwW.gateWid, nand, tech, ep);
        FoldedMos[] stroWeakPmoss = new FoldedMos[pmoss.length + 1];
        for (int i5 = 0; i5 < pmoss.length; ++i5) {
            stroWeakPmoss[i5] = pmoss[i5];
        }
        stroWeakPmoss[pmoss.length] = weak;
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, nand);
        stdCell.wireVddGnd(stroWeakPmoss, StdCellParams.EVEN, nand);
        double inbHiY = 11.0;
        LayoutLib.newExport(nand, "inb", ep, PortCharacteristic.IN, tech.m1(), 4.0, inbX, inbHiY);
        TrackRouterH inbHi = new TrackRouterH(tech.m2(), 3.0, inbHiY, tech, ep, nand);
        inbHi.connect(nand.findExport("inb"));
        PortInst jogb = LayoutLib.newNodeInst(tech.m1pin(), ep, jogbX, inbHiY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, nand).getOnlyPortInst();
        inbHi.connect(jogb);
        TrackRouterH inbLo = new TrackRouterH(tech.m1(), 3.0, 4.0, tech, ep, nand);
        inbLo.connect(jogb);
        block42: for (i3 = 0; i3 < fwN.nbFolds; ++i3) {
            switch (i3 % 6) {
                case 0: {
                    inbLo.connect(nmos.getGate(i3 * 3 + 0, 'T'), 1.5);
                    continue block42;
                }
                case 1: {
                    inbLo.connect(nmos.getGate(i3 * 3 + 1, 'T'), -1.0);
                    continue block42;
                }
                case 2: {
                    inbLo.connect(nmos.getGate(i3 * 3 + 2, 'T'));
                    continue block42;
                }
                case 3: {
                    inbLo.connect(nmos.getGate(i3 * 3 + 0, 'T'));
                    continue block42;
                }
                case 4: {
                    inbLo.connect(nmos.getGate(i3 * 3 + 1, 'T'), 1.0);
                    continue block42;
                }
                case 5: {
                    inbLo.connect(nmos.getGate(i3 * 3 + 2, 'T'), -1.5);
                }
            }
        }
        for (i3 = 0; i3 < pmoss.length; ++i3) {
            block44: for (int j2 = 0; j2 < pmoss[i3].nbGates(); ++j2) {
                switch (j2 % 12) {
                    case 0: {
                        ((TrackRouter)inbLo).connect(pmoss[i3].getGate(j2, 'B'), -4.5, 1.5);
                        continue block44;
                    }
                    case 2: {
                        inbLo.connect(pmoss[i3].getGate(j2, 'B'));
                        continue block44;
                    }
                    case 5: {
                        inbLo.connect(pmoss[i3].getGate(j2, 'B'));
                        continue block44;
                    }
                    case 6: {
                        inbLo.connect(pmoss[i3].getGate(j2, 'B'));
                        continue block44;
                    }
                    case 9: {
                        inbLo.connect(pmoss[i3].getGate(j2, 'B'));
                        continue block44;
                    }
                    case 11: {
                        ((TrackRouter)inbLo).connect(pmoss[i3].getGate(j2, 'B'), 4.5, 1.5);
                    }
                }
            }
        }
        double inaX = StdCellParams.getRightDiffX(nmos) + 2.0 + 3.0 + 2.0;
        double gndBot = stdCell.getGndY() - stdCell.getGndWidth() / 2.0;
        double inaLoY = gndBot - 3.0 - 2.0;
        double nmosBot = -9.0 - fwN.physWid;
        inaLoY = Math.min(inaLoY, nmosBot - 2.0 - 3.0 - 2.5);
        double vddTop = stdCell.getVddY() + stdCell.getVddWidth() / 2.0;
        double weakTop = weakBot + fwW.physWid;
        double inaHiY = Math.max(vddTop, weakTop) + 3.0 + 2.0;
        LayoutLib.newExport(nand, "ina", ep, PortCharacteristic.IN, tech.m1(), 4.0, inaX, inaHiY);
        TrackRouterH inaHi = new TrackRouterH(tech.m1(), 3.0, inaHiY, tech, ep, nand);
        inaHi.connect(nand.findExport("ina"));
        for (int i6 = 0; i6 < weak.nbGates(); ++i6) {
            inaHi.connect(weak.getGate(i6, 'T'));
        }
        TrackRouterH inaLo = new TrackRouterH(tech.m1(), 3.0, inaLoY, tech, ep, nand);
        inaLo.connect(nand.findExport("ina"));
        block46: for (int i7 = 0; i7 < fwN.nbFolds; ++i7) {
            switch (i7 % 6) {
                case 0: {
                    inaLo.connect(nmos.getGate(i7 * 3 + 1, 'B'));
                    continue block46;
                }
                case 1: {
                    inaLo.connect(nmos.getGate(i7 * 3 + 0, 'B'));
                    continue block46;
                }
                case 2: {
                    inaLo.connect(nmos.getGate(i7 * 3 + 0, 'B'));
                    continue block46;
                }
                case 3: {
                    inaLo.connect(nmos.getGate(i7 * 3 + 2, 'B'));
                    continue block46;
                }
                case 4: {
                    inaLo.connect(nmos.getGate(i7 * 3 + 2, 'B'));
                    continue block46;
                }
                case 5: {
                    inaLo.connect(nmos.getGate(i7 * 3 + 1, 'B'));
                }
            }
        }
        TrackRouterH inc = new TrackRouterH(tech.m1(), 3.0, -4.0, tech, ep, nand);
        block47: for (i2 = 0; i2 < fwN.nbFolds; ++i2) {
            switch (i2 % 6) {
                case 0: {
                    inc.connect(nmos.getGate(i2 * 3 + 2, 'T'), 1.5);
                    continue block47;
                }
                case 1: {
                    inc.connect(nmos.getGate(i2 * 3 + 2, 'T'), 1.5);
                    continue block47;
                }
                case 2: {
                    ((TrackRouter)inc).connect(nmos.getGate(i2 * 3 + 1, 'T'), -11.5, 1.0);
                    continue block47;
                }
                case 3: {
                    ((TrackRouter)inc).connect(nmos.getGate(i2 * 3 + 1, 'T'), 11.5, 1.0);
                    continue block47;
                }
                case 4: {
                    inc.connect(nmos.getGate(i2 * 3 + 0, 'T'), -1.5);
                    continue block47;
                }
                case 5: {
                    inc.connect(nmos.getGate(i2 * 3 + 0, 'T'), -1.5);
                }
            }
        }
        for (i2 = 0; i2 < pmoss.length; ++i2) {
            block49: for (int j3 = 0; j3 < pmoss[i2].nbGates(); ++j3) {
                switch (j3 % 12) {
                    case 1: {
                        ((TrackRouter)inc).connect(pmoss[i2].getGate(j3, 'B'), -2.5, 3.5);
                        continue block49;
                    }
                    case 3: {
                        inc.connect(pmoss[i2].getGate(j3, 'B'), -0.5);
                        continue block49;
                    }
                    case 4: {
                        ((TrackRouter)inc).connect(pmoss[i2].getGate(j3, 'B'), -8.5, 3.0);
                        continue block49;
                    }
                    case 7: {
                        ((TrackRouter)inc).connect(pmoss[i2].getGate(j3, 'B'), 8.5, 3.0);
                        continue block49;
                    }
                    case 8: {
                        inc.connect(pmoss[i2].getGate(j3, 'B'), 0.5);
                        continue block49;
                    }
                    case 10: {
                        ((TrackRouter)inc).connect(pmoss[i2].getGate(j3, 'B'), 2.5, 3.5);
                    }
                }
            }
        }
        LayoutLib.newExport(nand, "inc", ep, PortCharacteristic.IN, tech.m1(), 4.0, incX, -4.0);
        inc.connect(nand.findExport("inc"));
        double outX = inaX + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "out", ep, PortCharacteristic.OUT, tech.m1(), 4.0, outX, 11.0);
        TrackRouterH outHi = new TrackRouterH(tech.m2(), 4.0, 11.0, tech, ep, nand);
        outHi.connect(nand.findExport("out"));
        for (int i8 = 0; i8 < stroWeakPmoss.length; ++i8) {
            for (int j4 = 1; j4 < stroWeakPmoss[i8].nbSrcDrns(); j4 += 2) {
                outHi.connect(stroWeakPmoss[i8].getSrcDrn(j4));
            }
        }
        TrackRouterH outLo = new TrackRouterH(tech.m2(), 4.0, -11.0, tech, ep, nand);
        outLo.connect(nand.findExport("out"));
        for (int i9 = 1; i9 < nmos.nbSrcDrns(); i9 += 2) {
            outLo.connect(nmos.getSrcDrn(i9));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, nand);
        stdCell.addPmosWell(wellMinX, wellMaxX, nand);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, nand);
        stdCell.doNCC(nand, nm + "{sch}");
        return nand;
    }
}

