/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class Nand2LT_sy {
    private static final double nmosTop = -9.0;
    private static final double pmosBot = 9.0;
    private static final double wellOverhangDiff = 6.0;
    private static final double inbY = -4.0;
    private static final double inaY = 4.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    public static Cell makePart(double sz, StdCellParams stdCell) {
        int i2;
        int i3;
        double totWid;
        TechType tech = stdCell.getTechType();
        EditingPreferences ep = stdCell.getEditingPreferences();
        sz = stdCell.roundSize(sz);
        String nm = "nand2LT_sy";
        sz = stdCell.checkMinStrength(sz, 1.0, nm);
        double spaceAvail = stdCell.getCellTop() - 6.0 - 9.0;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWid = sz * 3.0 * 2.0, 2);
        Nand2LT_sy.error(fwP == null, "can't make nand2LT_sy this small: " + sz);
        int nbStacked = 2;
        spaceAvail = -9.0 - (stdCell.getCellBot() + 6.0);
        totWid = sz * 3.0 * (double)nbStacked;
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 2);
        Nand2LT_sy.error(fwN == null, "can't make nand2LT_sy this small: " + sz);
        Cell nand = stdCell.findPart(nm, sz);
        if (nand != null) {
            return nand;
        }
        nand = stdCell.newPart(nm, sz);
        double inbX = 3.5;
        double mosX = inbX + 2.0 + 3.0 + 2.0;
        double nmosY = -9.0 - fwN.physWid / 2.0;
        FoldedNmos nmos = new FoldedNmos(mosX, nmosY, fwN.nbFolds, nbStacked, fwN.gateWid, nand, tech, ep);
        double pmosY = 9.0 + fwP.physWid / 2.0;
        FoldedMos[] pmoss = new FoldedMos[fwP.nbFolds / 2];
        for (int i4 = 0; i4 < pmoss.length; ++i4) {
            double pmosPitch = 26.0;
            double pmosX = mosX + pmosPitch * (double)i4;
            pmoss[i4] = new FoldedPmos(pmosX, pmosY, 2, 1, fwP.gateWid, nand, tech, ep);
        }
        stdCell.fillDiffAndSelectNotches(pmoss, true);
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, nand);
        stdCell.wireVddGnd(pmoss, StdCellParams.EVEN, nand);
        LayoutLib.newExport(nand, "inb", ep, PortCharacteristic.IN, tech.m1(), 4.0, inbX, -4.0);
        TrackRouterH inB = new TrackRouterH(tech.m1(), 3.0, -4.0, tech, ep, nand);
        inB.connect(nand.findExport("inb"));
        for (i3 = 0; i3 < nmos.nbGates(); i3 += 2) {
            inB.connect(nmos.getGate(i3, 'T'), -1.5);
        }
        for (i3 = 0; i3 < pmoss.length; ++i3) {
            inB.connect(pmoss[i3].getGate(0, 'B'), -1.5);
        }
        double inaX = StdCellParams.getRightDiffX(pmoss, nmos) + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "ina", ep, PortCharacteristic.IN, tech.m1(), 4.0, inaX, 4.0);
        TrackRouterH ina = new TrackRouterH(tech.m1(), 3.0, 4.0, tech, ep, nand);
        ina.connect(nand.findExport("ina"));
        for (i2 = 1; i2 < nmos.nbGates(); i2 += 2) {
            ina.connect(nmos.getGate(i2, 'T'), 1.5);
        }
        for (i2 = 0; i2 < pmoss.length; ++i2) {
            ina.connect(pmoss[i2].getGate(1, 'B'), -1.5);
        }
        double outX = inaX + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "out", ep, PortCharacteristic.OUT, tech.m1(), 4.0, outX, 11.0);
        TrackRouterH outHi = new TrackRouterH(tech.m2(), 4.0, 11.0, tech, ep, nand);
        outHi.connect(nand.findExport("out"));
        for (int i5 = 0; i5 < pmoss.length; ++i5) {
            outHi.connect(pmoss[i5].getSrcDrn(1));
        }
        TrackRouterH outLo = new TrackRouterH(tech.m2(), 4.0, -11.0, tech, ep, nand);
        outLo.connect(nand.findExport("out"));
        for (int i6 = 1; i6 < nmos.nbSrcDrns(); i6 += 2) {
            outLo.connect(nmos.getSrcDrn(i6));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, nand);
        stdCell.addPmosWell(wellMinX, wellMaxX, nand);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, nand);
        stdCell.doNCC(nand, nm + "{sch}");
        return nand;
    }
}

