/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class MullerC_sy {
    private static final double nmosTop = -9.0;
    private static final double pmosBot = 9.0;
    private static final double wellOverhangDiff = 6.0;
    private static final double inbY = 4.0;
    private static final double inaY = -4.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    public static Cell makePart(double sz, StdCellParams stdCell) {
        int i2;
        int i3;
        int nbSeries;
        double totWid;
        TechType tech = stdCell.getTechType();
        EditingPreferences ep = stdCell.getEditingPreferences();
        sz = stdCell.roundSize(sz);
        String nm = "mullerC_sy";
        sz = stdCell.checkMinStrength(sz, 1.0, nm);
        double spaceAvail = -9.0 - (stdCell.getCellBot() + 6.0);
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid = sz * 3.0 * (double)(nbSeries = 2), 2);
        MullerC_sy.error(fwN == null, "can't make " + nm + " this small: " + sz);
        spaceAvail = stdCell.getCellTop() - 6.0 - 9.0;
        totWid = sz * 6.0 * (double)nbSeries;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 2);
        MullerC_sy.error(fwP == null, "can't make " + nm + " this small: " + sz);
        Cell mull = stdCell.findPart(nm, sz);
        if (mull != null) {
            return mull;
        }
        mull = stdCell.newPart(nm, sz);
        double inaX = 3.5;
        LayoutLib.newExport(mull, "ina", ep, PortCharacteristic.IN, tech.m1(), 4.0, inaX, -4.0);
        double mosX = inaX + 2.0 + 3.0 + 2.0;
        double nmosY = -9.0 - fwN.physWid / 2.0;
        FoldedNmos nmos = new FoldedNmos(mosX, nmosY, fwN.nbFolds, nbSeries, fwN.gateWid, mull, tech, ep);
        double pmosY = 9.0 + fwP.physWid / 2.0;
        FoldedPmos pmos = new FoldedPmos(mosX, pmosY, fwP.nbFolds, nbSeries, fwP.gateWid, mull, tech, ep);
        double rightDiffX = StdCellParams.getRightDiffX(nmos, pmos);
        double inbX = rightDiffX + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(mull, "inb", ep, PortCharacteristic.IN, tech.m1(), 4.0, inbX, 4.0);
        double outX = inbX + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(mull, "out", ep, PortCharacteristic.OUT, tech.m1(), 4.0, outX, -11.0);
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, mull);
        stdCell.wireVddGnd(pmos, StdCellParams.EVEN, mull);
        TrackRouterH ina = new TrackRouterH(tech.m1(), 3.0, -4.0, tech, ep, mull);
        ina.connect(mull.findExport("ina"));
        for (i3 = 0; i3 < nmos.nbGates(); i3 += 2) {
            ina.connect(nmos.getGate(i3, 'T'), -1.5);
        }
        for (i3 = 0; i3 < pmos.nbGates(); i3 += 2) {
            ina.connect(pmos.getGate(i3, 'B'), -1.5);
        }
        TrackRouterH inb = new TrackRouterH(tech.m1(), 3.0, 4.0, tech, ep, mull);
        inb.connect(mull.findExport("inb"));
        for (i2 = 1; i2 < pmos.nbGates(); i2 += 2) {
            inb.connect(pmos.getGate(i2, 'B'), 1.5);
        }
        for (i2 = 1; i2 < nmos.nbGates(); i2 += 2) {
            inb.connect(nmos.getGate(i2, 'T'), 1.5);
        }
        TrackRouterH outLo = new TrackRouterH(tech.m2(), 4.0, -11.0, tech, ep, mull);
        outLo.connect(mull.findExport("out"));
        for (int i4 = 1; i4 < nmos.nbSrcDrns(); i4 += 2) {
            outLo.connect(nmos.getSrcDrn(i4));
        }
        TrackRouterH outHi = new TrackRouterH(tech.m2(), 4.0, 11.0, tech, ep, mull);
        outHi.connect(mull.findExport("out"));
        for (int i5 = 1; i5 < pmos.nbSrcDrns(); i5 += 2) {
            outHi.connect(pmos.getSrcDrn(i5));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, mull);
        stdCell.addPmosWell(wellMinX, wellMaxX, mull);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, mull);
        stdCell.doNCC(mull, nm + "{sch}");
        return mull;
    }
}

