/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fillCell;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.Pref;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.fill.ExportConfig;
import com.sun.electric.tool.generator.layout.fill.FillGenConfig;
import com.sun.electric.tool.generator.layout.fill.FillGeneratorTool;
import com.sun.electric.tool.generator.layout.fill.G;
import com.sun.electric.tool.generator.layout.fillCell.TreeTiledCell;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class FillCellTool
extends FillGeneratorTool {
    private static Pref cacheFillCellMode;
    private static Pref cacheFillRouterMode;
    private static Pref cacheFillCellCreateMaster;

    public static FillCellMode getFillCellMode() {
        if (cacheFillCellMode == null) {
            cacheFillCellMode = Pref.makeIntPref("FillCellMode", FillCellTool.getTool().prefs, FillCellMode.FLAT.mode);
        }
        return FillCellMode.find(cacheFillCellMode.getInt());
    }

    public static void setFillCellMode(FillCellMode mode) {
        cacheFillCellMode.setInt(mode.mode);
    }

    public static FillGenConfig.FillGenType getFillRouterMode() {
        if (cacheFillRouterMode == null) {
            cacheFillRouterMode = Pref.makeIntPref("FillRouterMode", FillCellTool.getTool().prefs, FillGenConfig.FillGenType.INTERNAL.getMode());
        }
        return FillGenConfig.FillGenType.find(cacheFillRouterMode.getInt());
    }

    public static void setFillRouterMode(FillGenConfig.FillGenType mode) {
        cacheFillRouterMode.setInt(mode.getMode());
    }

    public static boolean isFillCellCreateMasterOn() {
        if (cacheFillCellCreateMaster == null) {
            cacheFillCellCreateMaster = Pref.makeBooleanPref("FillCellCreateMaster", FillCellTool.getTool().prefs, true);
        }
        return cacheFillCellCreateMaster.getBoolean();
    }

    public static void setFillCellCreateMasterOn(boolean on) {
        cacheFillCellCreateMaster.setBoolean(on);
    }

    private Cell treeMakeAndTileCell(TechType tech, EditingPreferences ep, List<Cell> masters, boolean isPlanHorizontal, Cell topCell, List<Rectangle2D> topBoxList, Area area) {
        Cell empty = Cell.newInst(this.lib, "empty" + masters.get(0).getName() + "{lay}");
        empty.setTechnology(topCell.getTechnology());
        double cellWidth = masters.get(0).getBounds().getWidth();
        double cellHeight = masters.get(0).getBounds().getHeight();
        LayoutLib.newNodeInst(tech.essentialBounds(), ep, -cellWidth / 2.0, -cellHeight / 2.0, G.DEF_SIZE, G.DEF_SIZE, 180.0, empty);
        LayoutLib.newNodeInst(tech.essentialBounds(), ep, cellWidth / 2.0, cellHeight / 2.0, G.DEF_SIZE, G.DEF_SIZE, 0.0, empty);
        int tileOnX = (int)Math.ceil(this.config.targetW / this.config.minTileSizeX);
        int tileOnY = (int)Math.ceil(this.config.targetH / this.config.minTileSizeY);
        TreeTiledCell t = new TreeTiledCell(this.config, ep);
        Cell topFill = t.makeQTreeCell(masters, empty, this.lib, tileOnX, tileOnY, isPlanHorizontal, topCell, topBoxList, area);
        topFill.setTechnology(topCell.getTechnology());
        return topFill;
    }

    protected Cell treeMakeFillCell(FillGenConfig config, EditingPreferences ep, Cell topCell, List<Cell> givenMasters, List<Rectangle2D> topBoxList, Area area) {
        boolean metalFlex = true;
        int loLayer = config.firstLayer;
        int hiLayer = config.lastLayer;
        ExportConfig exportConfig = config.perim;
        this.initFillParameters(metalFlex, true, ep);
        TechType tech = config.getTechType();
        this.masters = givenMasters;
        if (this.masters == null) {
            Job.error(loLayer < 1, "loLayer must be >=1");
            int maxNumMetals = tech.getNumMetals();
            Job.error(hiLayer > maxNumMetals, "hiLayer must be <=" + maxNumMetals);
            Job.error(loLayer > hiLayer, "loLayer must be <= hiLayer");
            this.masters = new ArrayList();
            Cell master = FillCellTool.makeFillCell(this.lib, this.plans, loLayer, hiLayer, this.capCell, tech, ep, exportConfig, metalFlex, true);
            this.masters.add(master);
        } else {
            Rectangle2D r = ((Cell)this.masters.get(0)).findEssentialBounds();
            if (r == null) {
                r = ((Cell)this.masters.get(0)).getBounds();
            }
            config.minTileSizeX = r.getWidth();
            config.minTileSizeY = r.getHeight();
        }
        Cell cell = this.treeMakeAndTileCell(tech, ep, this.masters, this.getOrientation(), topCell, topBoxList, area);
        return cell;
    }

    public static enum FillCellMode {
        NONE(-1),
        FLAT(0),
        BINARY(1),
        ADAPTIVE(2);

        private final int mode;

        private FillCellMode(int m2) {
            this.mode = m2;
        }

        static FillCellMode find(int mode) {
            for (FillCellMode m2 : FillCellMode.values()) {
                if (m2.mode != mode) continue;
                return m2;
            }
            return NONE;
        }
    }
}

