/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fill;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.fill.CapCell;
import com.sun.electric.tool.generator.layout.fill.CapFloorplan;
import com.sun.electric.tool.generator.layout.fill.CapLayer;
import com.sun.electric.tool.generator.layout.fill.ExportConfig;
import com.sun.electric.tool.generator.layout.fill.Floorplan;
import com.sun.electric.tool.generator.layout.fill.G;
import com.sun.electric.tool.generator.layout.fill.MetalLayer;
import com.sun.electric.tool.generator.layout.fill.MetalLayerFlex;
import com.sun.electric.tool.generator.layout.fill.VddGndStraps;

public class FillCell {
    public static final String VDD_NAME = "vdd";
    public static final String GND_NAME = "gnd";
    public static final PortCharacteristic VDD_CHARACTERISTIC = PortCharacteristic.PWR;
    public static final PortCharacteristic GND_CHARACTERISTIC = PortCharacteristic.GND;
    private int vddNum;
    private int gndNum;
    private final TechType tech;
    private final EditingPreferences ep;

    private String vddName() {
        int n2;
        return VDD_NAME + (String)((n2 = this.vddNum++) == 0 ? "" : "_" + n2);
    }

    private String gndName() {
        int n2;
        return GND_NAME + (String)((n2 = this.gndNum++) == 0 ? "" : "_" + n2);
    }

    public void exportPerimeter(VddGndStraps lay, Cell cell) {
        int i2;
        for (i2 = 0; i2 < lay.numGnd(); ++i2) {
            this.exportStripeEnds(i2, lay, true, cell);
        }
        for (i2 = 0; i2 < lay.numVdd(); ++i2) {
            this.exportStripeEnds(i2, lay, false, cell);
        }
    }

    public void exportPerimeter(VddGndStraps[] lays, int botLay, int topLay, ExportConfig exptConfig, Cell cell) {
        int[] perim = exptConfig.getPerimeterExports(botLay, topLay);
        for (int i2 = 0; i2 < perim.length; ++i2) {
            VddGndStraps lay = lays[perim[i2]];
            if (lay == null) continue;
            this.exportPerimeter(lay, cell);
        }
    }

    private void exportStripeEnds(int n2, VddGndStraps lay, boolean gnd, Cell cell) {
        PortInst piRight;
        PrimitiveNode pin = lay.getPinType();
        ArcProto metal = lay.getMetalType();
        double edge = (lay.isHorizontal() ? lay.getCellWidth() : lay.getCellHeight()) / 2.0;
        double center = gnd ? lay.getGndCenter(n2) : lay.getVddCenter(n2);
        double width = gnd ? lay.getGndWidth(n2) : lay.getVddWidth(n2);
        PortInst piLeft = gnd ? lay.getGnd(n2, 0) : lay.getVdd(n2, 0);
        PortInst portInst = piRight = gnd ? lay.getGnd(n2, 1) : lay.getVdd(n2, 1);
        if (lay.isHorizontal()) {
            this.export(-edge, center, pin, metal, piLeft, width, gnd ? this.gndName() : this.vddName(), gnd, cell, lay.addExtraArc());
            this.export(edge, center, pin, metal, piRight, width, gnd ? this.gndName() : this.vddName(), gnd, cell, lay.addExtraArc());
        } else {
            this.export(center, -edge, pin, metal, piLeft, width, gnd ? this.gndName() : this.vddName(), gnd, cell, lay.addExtraArc());
            this.export(center, edge, pin, metal, piRight, width, gnd ? this.gndName() : this.vddName(), gnd, cell, lay.addExtraArc());
        }
    }

    private void export(double x, double y, PrimitiveNode pin, ArcProto metal, PortInst conn, double w, String name, boolean gnd, Cell cell, boolean withExtraArc) {
        Export e2 = null;
        e2 = Export.newInst(cell, conn, name, this.ep);
        e2.setCharacteristic(gnd ? GND_CHARACTERISTIC : VDD_CHARACTERISTIC);
    }

    public void exportWiring(VddGndStraps lay, Cell cell) {
        int i2;
        for (i2 = 0; i2 < lay.numGnd(); ++i2) {
            this.exportStripeCenter(i2, lay, true, cell);
        }
        for (i2 = 0; i2 < lay.numVdd(); ++i2) {
            this.exportStripeCenter(i2, lay, false, cell);
        }
    }

    public void exportWiring(VddGndStraps[] lays, int botLay, int topLay, ExportConfig exptConfig, Cell cell) {
        int[] intnl = exptConfig.getInternalExports(botLay, topLay);
        for (int i2 = 0; i2 < intnl.length; ++i2) {
            VddGndStraps lay = lays[intnl[i2]];
            if (lay == null) continue;
            this.exportWiring(lay, cell);
        }
    }

    private void exportStripeCenter(int n2, VddGndStraps lay, boolean gnd, Cell cell) {
        PortInst pi;
        PrimitiveNode pin = lay.getPinType();
        ArcProto metal = lay.getMetalType();
        double center = gnd ? lay.getGndCenter(n2) : lay.getVddCenter(n2);
        double width = gnd ? lay.getGndWidth(n2) : lay.getVddWidth(n2);
        PortInst portInst = pi = gnd ? lay.getGnd(n2, 0) : lay.getVdd(n2, 0);
        if (lay.isHorizontal()) {
            this.export(0.0, center, pin, metal, pi, width, gnd ? this.gndName() : this.vddName(), gnd, cell, lay.addExtraArc());
        } else {
            this.export(center, 0.0, pin, metal, pi, width, gnd ? this.gndName() : this.vddName(), gnd, cell, lay.addExtraArc());
        }
    }

    private void appendExportLayerNumbers(StringBuffer buf, String type, int[] layerNbs) {
        if (layerNbs.length > 0) {
            buf.append(type);
            for (int i2 = 0; i2 < layerNbs.length; ++i2) {
                buf.append(layerNbs[i2]);
            }
        }
    }

    private String fillName(int lo, int hi, ExportConfig expConfig) {
        StringBuffer buf = new StringBuffer();
        buf.append("fill");
        if (lo != 1 || hi != this.tech.getNumMetals()) {
            for (int i2 = lo; i2 <= hi; ++i2) {
                buf.append(i2);
            }
        }
        if (expConfig != ExportConfig.PERIMETER) {
            if (expConfig == ExportConfig.PERIMETER_AND_INTERNAL) {
                buf.append("w");
            } else {
                int[] perim = expConfig.getPerimeterExports(lo, hi);
                this.appendExportLayerNumbers(buf, "p", perim);
                int[] intnl = expConfig.getInternalExports(lo, hi);
                this.appendExportLayerNumbers(buf, "w", intnl);
            }
        }
        buf.append("{lay}");
        return buf.toString();
    }

    private VddGndStraps[] findHoriVert(VddGndStraps lay1, VddGndStraps lay2) {
        if (lay1.isHorizontal()) {
            Job.error(lay2.isHorizontal(), "adjacent layers both horizontal");
            return new VddGndStraps[]{lay1, lay2};
        }
        Job.error(!lay2.isHorizontal(), "adjacent layers both vertical");
        return new VddGndStraps[]{lay2, lay1};
    }

    private void connectVddStraps(VddGndStraps horLay, int horNdx, VddGndStraps verLay, int verNdx, Cell cell) {
        double w = verLay.getVddWidth(verNdx);
        double x = verLay.getVddCenter(verNdx);
        ArcProto verMetal = verLay.getMetalType();
        PortInst verPort = horNdx % 2 == 0 ? verLay.getVdd(verNdx, 0) : verLay.getVdd(verNdx, 1);
        double h2 = horLay.getVddWidth(horNdx);
        double y = horLay.getVddCenter(horNdx);
        ArcProto horMetal = horLay.getMetalType();
        PrimitiveNode viaType = this.tech.getViaFor(verMetal, horMetal);
        PortInst horPort = verNdx % 2 == 0 ? horLay.getVdd(horNdx, 0) : horLay.getVdd(horNdx, 1);
        Job.error(viaType == null, "can't find via for metal layers " + String.valueOf(verMetal) + " " + String.valueOf(horMetal));
        ViaDim d2 = new ViaDim(horLay, x, y, w, h2);
        PortInst via = LayoutLib.newNodeInst(viaType, this.ep, d2.x, d2.y, d2.w, d2.h, 0.0, cell).getOnlyPortInst();
        G.noExtendArc(horMetal, this.ep, h2, horPort, via);
        G.noExtendArc(verMetal, this.ep, w, via, verPort);
    }

    private void connectGndStraps(VddGndStraps horLay, int horNdx, VddGndStraps verLay, int verNdx, Cell cell) {
        double w = verLay.getGndWidth(verNdx);
        double x = verLay.getGndCenter(verNdx);
        ArcProto verMetal = verLay.getMetalType();
        PortInst verPort = horNdx % 2 == 0 ? verLay.getGnd(verNdx, 0) : verLay.getGnd(verNdx, 1);
        double h2 = horLay.getGndWidth(horNdx);
        double y = horLay.getGndCenter(horNdx);
        ArcProto horMetal = horLay.getMetalType();
        PrimitiveNode viaType = this.tech.getViaFor(verMetal, horMetal);
        PortInst horPort = verNdx % 2 == 0 ? horLay.getGnd(horNdx, 0) : horLay.getGnd(horNdx, 1);
        Job.error(viaType == null, "can't find via for metal layers");
        ViaDim d2 = new ViaDim(horLay, x, y, w, h2);
        PortInst via = LayoutLib.newNodeInst(viaType, this.ep, d2.x, d2.y, d2.w, d2.h, 0.0, cell).getOnlyPortInst();
        G.noExtendArc(horMetal, this.ep, h2, horPort, via);
        G.noExtendArc(verMetal, this.ep, w, via, verPort);
    }

    private void connectLayers(VddGndStraps loLayer, VddGndStraps hiLayer, Cell cell) {
        int v;
        int h2;
        VddGndStraps[] layers = this.findHoriVert(loLayer, hiLayer);
        VddGndStraps horLay = layers[0];
        VddGndStraps verLay = layers[1];
        for (h2 = 0; h2 < horLay.numVdd(); ++h2) {
            for (v = 0; v < verLay.numVdd(); ++v) {
                this.connectVddStraps(horLay, h2, verLay, v, cell);
            }
        }
        for (h2 = 0; h2 < horLay.numGnd(); ++h2) {
            for (v = 0; v < verLay.numGnd(); ++v) {
                this.connectGndStraps(horLay, h2, verLay, v, cell);
            }
        }
    }

    protected Cell makeFillCell1(Library lib, Floorplan[] plans, int botLayer, int topLayer, CapCell capCell, ExportConfig expCfg, boolean metalFlex, boolean hierFlex) {
        String name = this.fillName(botLayer, topLayer, expCfg);
        Cell cell = Cell.newInst(lib, name);
        VddGndStraps[] layers = new VddGndStraps[topLayer + 1];
        for (int i2 = topLayer; i2 >= botLayer; --i2) {
            layers[i2] = i2 == 1 ? new CapLayer(this.tech, this.ep, (CapFloorplan)plans[i2], capCell, cell) : (metalFlex && !hierFlex ? new MetalLayerFlex(this.tech, this.ep, i2, plans[i2], cell) : new MetalLayer(this.tech, this.ep, i2, plans[i2], cell));
            if (i2 == topLayer) continue;
            this.connectLayers(layers[i2], layers[i2 + 1], cell);
        }
        this.exportPerimeter(layers, botLayer, topLayer, expCfg, cell);
        this.exportWiring(layers, botLayer, topLayer, expCfg, cell);
        double cellWidth = plans[topLayer].cellWidth;
        double cellHeight = plans[topLayer].cellHeight;
        LayoutLib.newNodeInst(this.tech.essentialBounds(), this.ep, -cellWidth / 2.0, -cellHeight / 2.0, G.DEF_SIZE, G.DEF_SIZE, 180.0, cell);
        LayoutLib.newNodeInst(this.tech.essentialBounds(), this.ep, cellWidth / 2.0, cellHeight / 2.0, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell);
        return cell;
    }

    protected FillCell(TechType tech, EditingPreferences ep) {
        this.tech = tech;
        this.ep = ep;
    }

    private static class ViaDim {
        public final double x;
        public final double y;
        public final double w;
        public final double h;

        public ViaDim(VddGndStraps lay, double x, double y, double w, double h2) {
            if (x + w / 2.0 == lay.getCellWidth() / 2.0) {
                w -= 1.0;
                x -= 0.5;
            } else if (x - w / 2.0 == -lay.getCellWidth() / 2.0) {
                w -= 1.0;
                x += 0.5;
            }
            if (y + h2 / 2.0 == lay.getCellHeight() / 2.0) {
                h2 -= 1.0;
                y -= 0.5;
            } else if (y - h2 / 2.0 == -lay.getCellHeight() / 2.0) {
                h2 -= 1.0;
                y += 0.5;
            }
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h2;
        }
    }
}

