/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fill;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.fill.CapCell;
import com.sun.electric.tool.generator.layout.fill.CapFloorplan;
import com.sun.electric.tool.generator.layout.fill.G;
import com.sun.electric.tool.generator.layout.fill.VddGndStraps;

class CapLayer
extends VddGndStraps {
    private CapCell capCell;
    private NodeInst capCellInst;
    private CapFloorplan plan;

    @Override
    public boolean addExtraArc() {
        return true;
    }

    public CapLayer(TechType t, EditingPreferences ep, CapFloorplan plan, CapCell capCell, Cell cell) {
        super(t, ep);
        double angle;
        this.plan = plan;
        this.capCell = capCell;
        double d2 = angle = plan.horizontal ? 0.0 : 90.0;
        if (capCell != null) {
            this.capCellInst = LayoutLib.newNodeInst(capCell.getCell(), ep, 0.0, 0.0, G.DEF_SIZE, G.DEF_SIZE, angle, cell);
        }
    }

    @Override
    public boolean isHorizontal() {
        return this.plan.horizontal;
    }

    @Override
    public int numVdd() {
        return this.capCell != null ? this.capCell.numVdd() : 0;
    }

    @Override
    public PortInst getVdd(int n2, int pos) {
        return this.capCellInst.findPortInst("vdd_" + n2);
    }

    @Override
    public double getVddCenter(int n2) {
        EPoint center = this.getVdd(n2, 0).getCenter();
        return this.plan.horizontal ? center.getY() : center.getX();
    }

    @Override
    public double getVddWidth(int n2) {
        return this.capCell.getVddWidth();
    }

    @Override
    public int numGnd() {
        return this.capCell != null ? this.capCell.numGnd() : 0;
    }

    @Override
    public PortInst getGnd(int n2, int pos) {
        return this.capCellInst.findPortInst("gnd_" + n2);
    }

    @Override
    public double getGndCenter(int n2) {
        EPoint center = this.getGnd(n2, 0).getCenter();
        return this.plan.horizontal ? center.getY() : center.getX();
    }

    @Override
    public double getGndWidth(int n2) {
        return this.capCell.getGndWidth();
    }

    @Override
    public PrimitiveNode getPinType() {
        return this.tech.m1pin();
    }

    @Override
    public ArcProto getMetalType() {
        return this.tech.m1();
    }

    @Override
    public double getCellWidth() {
        return this.plan.cellWidth;
    }

    @Override
    public double getCellHeight() {
        return this.plan.cellHeight;
    }

    public int getLayerNumber() {
        return 1;
    }
}

