/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.LayoutLib;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;

public class Gallery {
    static final double PAGE_WIDTH = 1000.0;
    static final double HORIZONTAL_SPACE = 30.0;
    static final double VERTICAL_SPACE = 30.0;
    static final double TEXT_OFFSET_BELOW_CELL = 10.0;
    private PrimitiveNode textPin;
    private Library lib;
    private final EditingPreferences ep;

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    ArrayList<Cell> readLayoutCells(Library lib) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        Iterator<Cell> it = lib.getCells();
        View layView = View.findView("layout");
        while (it.hasNext()) {
            Cell c2 = it.next();
            if (c2.getName().equals("gallery") || c2.getName().startsWith("drcRing") || c2.getView() != layView) continue;
            cells.add(c2);
        }
        return cells;
    }

    void sortCellsByName(ArrayList<Cell> facets) {
        Collections.sort(facets, new Comparator<Cell>(){

            @Override
            public int compare(Cell c1, Cell c2) {
                String n1 = c1.getName();
                String n2 = c2.getName();
                return n1.compareTo(n2);
            }
        });
    }

    void printCells(ArrayList<Cell> facets) {
        for (int i2 = 0; i2 < facets.size(); ++i2) {
            Cell p = facets.get(i2);
            System.out.println(p.getName());
        }
    }

    ArrayList<NodeInst> addOneInstOfEveryCell(ArrayList<Cell> cells, Cell gallery) {
        ArrayList<NodeInst> insts = new ArrayList<NodeInst>();
        for (int i2 = 0; i2 < cells.size(); ++i2) {
            Cell c2 = cells.get(i2);
            NodeInst ni = LayoutLib.newNodeInst(c2, this.ep, 0.0, 0.0, 0.0, 0.0, 0.0, gallery);
            insts.add(ni);
        }
        return insts;
    }

    double width(NodeInst ni) {
        return LayoutLib.getBounds(ni).getWidth();
    }

    double height(NodeInst ni) {
        return LayoutLib.getBounds(ni).getHeight();
    }

    double[] getRow(ArrayList<NodeInst> row, ListIterator<NodeInst> it) {
        double x = 0.0;
        double highestAboveCenter = Double.MIN_VALUE;
        double lowestBelowCenter = Double.MIN_VALUE;
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (x != 0.0 && x + this.width(ni) > 1000.0) {
                it.previous();
                break;
            }
            row.add(ni);
            Rectangle2D bounds = LayoutLib.getBounds(ni);
            highestAboveCenter = Math.max(highestAboveCenter, bounds.getMaxY());
            lowestBelowCenter = Math.min(lowestBelowCenter, bounds.getMinY());
            x = x + this.width(ni) + 30.0;
        }
        return new double[]{highestAboveCenter, lowestBelowCenter};
    }

    void placeRow(ArrayList<NodeInst> row, double centerY, Cell gallery) {
        double curLeftX = 0.0;
        for (int i2 = 0; i2 < row.size(); ++i2) {
            NodeInst ni = row.get(i2);
            double x = LayoutLib.getBounds(ni).getMinX();
            double y = LayoutLib.getPosition(ni).getY();
            LayoutLib.modNodeInst(ni, curLeftX - x, centerY - y, 0.0, 0.0, false, false, 0.0);
            double defSz = Double.POSITIVE_INFINITY;
            LayoutLib.newNodeInst(this.textPin, this.ep, curLeftX + this.width(ni) / 2.0, centerY - 10.0, defSz, defSz, 0.0, gallery);
            curLeftX = curLeftX + this.width(ni) + 30.0;
        }
    }

    void placeInstsOnPage(ArrayList<NodeInst> insts, Cell gallery) {
        double topY = 0.0;
        ListIterator<NodeInst> it = insts.listIterator();
        while (it.hasNext()) {
            ArrayList<NodeInst> row = new ArrayList<NodeInst>();
            double[] hiLo = this.getRow(row, it);
            double highestAboveCenter = hiLo[0];
            double lowestBelowCenter = hiLo[1];
            double centerY = topY - highestAboveCenter;
            this.placeRow(row, centerY, gallery);
            topY = centerY + lowestBelowCenter - 30.0;
        }
    }

    Gallery(Library lib, EditingPreferences ep) {
        this.lib = lib;
        this.ep = ep;
        Technology generic = Technology.findTechnology("generic");
        Gallery.error(generic == null, "No generic technology?");
        this.textPin = generic.findNodeProto("Invisible-Pin");
    }

    Cell makeGallery1() {
        ArrayList<Cell> cells = this.readLayoutCells(this.lib);
        System.out.println("Gallery contains: " + cells.size() + " Cells");
        this.sortCellsByName(cells);
        Cell gallery = Cell.newInst(this.lib, "gallery{lay}");
        ArrayList<NodeInst> insts = this.addOneInstOfEveryCell(cells, gallery);
        this.placeInstsOnPage(insts, gallery);
        return gallery;
    }

    public static Cell makeGallery(Library lib, EditingPreferences ep) {
        Gallery galleryMaker = new Gallery(lib, ep);
        return galleryMaker.makeGallery1();
    }

    public static void main(String[] args) {
        Library lib = Library.getCurrent();
        Gallery.error(lib == null, "No currently open library?");
        EditingPreferences ep = new EditingPreferences(true, lib.getTechPool());
        Gallery.makeGallery(lib, ep);
        System.out.println("Done");
    }
}

