/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag.scan;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.flag.FlagConfig;
import com.sun.electric.tool.generator.flag.Utils;
import com.sun.electric.tool.generator.flag.router.Router;
import com.sun.electric.tool.generator.flag.scan.ScanChain;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Scan {
    private final List<ScanChain> chains = new ArrayList<ScanChain>();
    private final Set<String> SCAN_PORT_NAME_SET = new HashSet<String>();
    private final FlagConfig config;

    private static void prln(String s) {
        Utils.prln(s);
    }

    private TechType tech() {
        return this.config.tech();
    }

    private boolean vertOrHorizAligned(PortInst p1, PortInst p2) {
        double x1 = p1.getCenter().getX();
        double y1 = p1.getCenter().getY();
        double x2 = p2.getCenter().getX();
        double y2 = p2.getCenter().getY();
        return x1 == x2 || y1 == y2;
    }

    private void connectScanPorts(NodeInst niOut, NodeInst niIn, List<String> outPortNm, List<String> inPortNm, Router router) {
        EditingPreferences ep = router.getEditingPreferences();
        for (int i2 = 0; i2 < outPortNm.size(); ++i2) {
            PortInst piIn;
            PortInst piOut = niOut.findPortInst(outPortNm.get(i2));
            if (!this.vertOrHorizAligned(piOut, piIn = niIn.findPortInst(inPortNm.get(i2)))) {
                Scan.prln("Can't connect scan ports with horizontal or vertical wire:");
                Scan.prln("    " + String.valueOf(piOut) + " " + String.valueOf(piIn));
                continue;
            }
            LayoutLib.newArcInst(this.tech().m3(), ep, this.config.signalWid, router.raiseToM3(piOut), router.raiseToM3(piIn));
        }
    }

    public Scan(List<ScanChain> chains, FlagConfig config) {
        this.chains.addAll(chains);
        this.config = config;
        for (ScanChain chain : chains) {
            this.SCAN_PORT_NAME_SET.addAll(chain.getInputNames());
            this.SCAN_PORT_NAME_SET.addAll(chain.getOutputNames());
            this.SCAN_PORT_NAME_SET.addAll(chain.getFeedthroughNames());
        }
    }

    public void stitchScanChains(List<NodeInst> layInsts, Router router) {
        for (ScanChain chain : this.chains) {
            NodeInst prevOut = null;
            List<String> prevOutPorts = null;
            for (NodeInst ni : layInsts) {
                List<String> newPrevOutPorts;
                List<String> inOrFeed = chain.getInputOrFeedNames(ni);
                if (inOrFeed != null && prevOut != null) {
                    this.connectScanPorts(prevOut, ni, prevOutPorts, inOrFeed, router);
                    prevOut = null;
                }
                if ((newPrevOutPorts = chain.getOutputOrFeedNames(ni)) == null) continue;
                if (prevOut != null) {
                    Scan.prln("Error: Dangling scan chain output. ");
                    Scan.prln("  NodeInst: " + prevOut.getName());
                    Scan.prln("  Port:     " + prevOutPorts.get(0));
                }
                prevOutPorts = newPrevOutPorts;
                prevOut = ni;
            }
        }
    }

    public boolean isScan(PortInst pi) {
        String nm = pi.getPortProto().getName();
        return this.SCAN_PORT_NAME_SET.contains(nm);
    }
}

