/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag.hornFunnel2;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.flag.hornFunnel2.Node;
import com.sun.electric.tool.generator.layout.LayoutLib;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BinaryTree {
    private static final double DEF_SIZE = Double.POSITIVE_INFINITY;
    private final boolean SLANTED_EDGES = true;
    private static final Technology SCHEM_TECH = Technology.findTechnology("schematic");
    private static final PrimitiveNode SCH_ICON_PROTO = SCHEM_TECH.findNodeProto("Buffer");
    private static final PrimitiveNode DOT_ICON_PROTO = SCHEM_TECH.findNodeProto("Wire_Pin");
    private static final ArcProto LINE_PROTO = SCHEM_TECH.findArcProto("Wire");
    private final int SLOT_WID = 6;
    private final int SLOT_HEI = 24;
    private List<Node> slots;
    private final int height;
    private final EditingPreferences ep;
    private final int numSlots;
    private final Node root;

    private void prln(String s) {
        System.out.println(s);
    }

    private void pr(String s) {
        System.out.print(s);
    }

    private List<Node> makeSlots(int nbSlots) {
        ArrayList<Node> slots = new ArrayList<Node>();
        for (int i2 = 0; i2 < nbSlots; ++i2) {
            slots.add(null);
        }
        return slots;
    }

    private void drawExternalArc(Cell c2, Map<Node, NodeInst> nodeToInst) {
        int dotX = -6;
        int dotY = (this.height + 1) * 24;
        NodeInst dot = LayoutLib.newNodeInst(DOT_ICON_PROTO, this.ep, dotX, dotY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, c2);
        PortInst dotPi = dot.getOnlyPortInst();
        PortInst inPi = nodeToInst.get(this.root).findPortInst("a");
        this.drawArc(dotPi, inPi);
    }

    private void drawArc(PortInst p1, PortInst p2) {
        ArcInst aL = ArcInst.makeInstance(LINE_PROTO, this.ep, p1, p2);
        aL.setFixedAngle(false);
    }

    private void drawArcs(Node n2, Map<Node, NodeInst> nodeToInst) {
        if (n2.isLeaf()) {
            return;
        }
        PortInst cur = nodeToInst.get(n2).findPortInst("y");
        PortInst left = nodeToInst.get(n2.getLeftChild()).findPortInst("a");
        PortInst right = nodeToInst.get(n2.getRightChild()).findPortInst("a");
        this.drawArc(cur, left);
        this.drawArc(cur, right);
        this.drawArcs(n2.getLeftChild(), nodeToInst);
        this.drawArcs(n2.getRightChild(), nodeToInst);
    }

    private void setSlot(int slot, Node n2) {
        this.slots.set(slot, n2);
        n2.setSlot(slot);
    }

    public BinaryTree(int height, EditingPreferences ep) {
        this.height = height;
        this.ep = ep;
        this.numSlots = (int)Math.pow(2.0, height) - 1;
        this.slots = this.makeSlots(this.numSlots);
        int halfNbSlots = (this.numSlots + 1) / 2;
        Node.resetIds();
        this.root = new Node(null, height, -1 + halfNbSlots, this.slots);
    }

    public int getHeight() {
        return this.height;
    }

    public Node getRoot() {
        return this.root;
    }

    public int getNumSlots() {
        return this.numSlots;
    }

    public void checkSlots() {
        HashMap<Node, Integer> nodeToNdx = new HashMap<Node, Integer>();
        for (int i2 = 0; i2 < this.slots.size(); ++i2) {
            Node n2 = this.slots.get(i2);
            Job.error(n2.getSlot() != i2, "wrong slot. actual=" + i2 + " incorrect=" + n2.getSlot());
            Integer index = (Integer)nodeToNdx.get(n2);
            Job.error(index != null, "already at: " + index);
            nodeToNdx.put(n2, i2);
        }
    }

    private boolean isLocked(Node n2, int movableHeight) {
        int h2 = n2.getHeight();
        return h2 > movableHeight;
    }

    public void moveTo(Node n2, int dst, int moveableHeight) {
        this.checkSlots();
        int src = n2.getSlot();
        Job.error(this.isLocked(this.slots.get(dst), moveableHeight), "moveTo fails because destination is locked. \n    src: " + this.slots.get(src).toString() + "\n    dest: " + this.slots.get(dst).toString());
        int incr = dst >= src ? 1 : -1;
        Node movee = this.slots.get(src);
        int wr = src;
        while (wr != dst) {
            int rd = wr + incr;
            while (this.isLocked(this.slots.get(rd), moveableHeight)) {
                rd += incr;
            }
            this.setSlot(wr, this.slots.get(rd));
            wr = rd;
        }
        this.setSlot(dst, movee);
        this.checkSlots();
    }

    public void addId(NodeInst ni, int id) {
        ni.setName("" + id);
    }

    public void draw(Cell c2) {
        HashMap<Node, NodeInst> nodeToInst = new HashMap<Node, NodeInst>();
        for (Node n2 : this.slots) {
            int h2 = n2.getHeight();
            int s = n2.getSlot();
            double x = s * 6;
            double y = h2 * 24;
            NodeInst ni = LayoutLib.newNodeInst(SCH_ICON_PROTO, this.ep, x, y, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 270.0, c2);
            this.addId(ni, n2.getId());
            Job.error(nodeToInst.containsKey(n2), "duplicate entry");
            nodeToInst.put(n2, ni);
        }
        this.drawExternalArc(c2, nodeToInst);
        this.drawArcs(this.root, nodeToInst);
        this.printStats();
    }

    public int calcWireLength() {
        int wireLen = this.getRoot().getSlot() + 1;
        for (Node n2 : this.slots) {
            wireLen += n2.getChildWireLength();
        }
        return wireLen;
    }

    public int maxWireLength() {
        int maxLen = this.getRoot().getSlot() + 1;
        for (Node n2 : this.slots) {
            maxLen = Math.max(maxLen, n2.getChildWireLength());
        }
        return maxLen;
    }

    public int[] countTracks() {
        int[] counts = new int[this.numSlots];
        for (Node n2 : this.slots) {
            if (n2.isLeaf()) continue;
            int minSlot = n2.getMinChildWireSlot();
            int maxSlot = n2.getMaxChildWireSlot();
            int i2 = minSlot;
            while (i2 <= maxSlot) {
                int n3 = i2++;
                counts[n3] = counts[n3] + 1;
            }
        }
        int i3 = 0;
        while (i3 <= this.getRoot().getSlot()) {
            int n4 = i3++;
            counts[n4] = counts[n4] + 1;
        }
        return counts;
    }

    public List<Node> getNodesSortedByChildWireLength() {
        ArrayList<Node> sorted = new ArrayList<Node>();
        sorted.addAll(this.slots);
        Collections.sort(sorted, new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                return n1.getChildWireLength() - n2.getChildWireLength();
            }
        });
        return sorted;
    }

    public Node getNodeWithLongestChildWire() {
        List<Node> sorted = this.getNodesSortedByChildWireLength();
        return sorted.get(sorted.size() - 1);
    }

    public int getLowBoundWireLen() {
        return (int)Math.ceil((double)this.getNumSlots() / (double)this.height);
    }

    public void printStats() {
        this.pr("Track counts: ");
        int[] counts = this.countTracks();
        int maxNbTracks = -1;
        for (int count : counts) {
            this.pr(count + " ");
            maxNbTracks = Math.max(maxNbTracks, count);
        }
        this.prln("");
        this.prln("Max numb tracks: " + maxNbTracks);
        this.prln("Total wire length: " + this.calcWireLength());
        this.prln("Maximum wire length: " + this.maxWireLength());
        int lowBoundWireLen = this.getLowBoundWireLen();
        this.prln("Lower bound on wire length: " + lowBoundWireLen);
        this.prln("Nodes with child wire length exceeding lower bound: ");
        for (Node n2 : this.getNodesSortedByChildWireLength()) {
            if (n2.isLeaf() || n2.getChildWireLength() <= lowBoundWireLen) continue;
            this.prln(n2.toString());
        }
    }

    public List<Node> getNodesAtHeight(int h2) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node n2 : this.slots) {
            if (n2.getHeight() != h2) continue;
            nodes.add(n2);
        }
        return nodes;
    }

    public Node getNodeInSlot(int i2) {
        return this.slots.get(i2);
    }
}

