/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class ROMGenerator {
    private int globalbits;
    private int folds;
    private double lambda = 1.0;
    private Technology tech;
    private EditingPreferences ep;

    public static void generateROM() {
        String romFile = OpenFile.chooseInputFile(FileType.TEXT, null, null);
        if (romFile == null) {
            return;
        }
        new DoROM(Library.getCurrent(), romFile);
    }

    public static void generateROM(Library destLib, String romFile, EditingPreferences ep) {
        new ROMGenerator(ep).makeAROM(destLib, romFile, "ROMCELL");
    }

    private ROMGenerator(EditingPreferences ep) {
        this.ep = ep;
    }

    public Cell makeAROM(Library destLib, String romfile, String romcell) {
        PortProto apport1;
        NodeInst ap1;
        int i2;
        int i3;
        int i4;
        int i5;
        this.tech = Technology.getMocmosTechnology();
        int[][] romarray = this.romarraygen(romfile);
        String dpr = new String(romcell + "_decoderpmos");
        String dnr = new String(romcell + "_decodernmos");
        String dpm = new String(romcell + "_decoderpmosmux");
        String dnm = new String(romcell + "_decodernmosmux");
        String invt = new String(romcell + "_invertertop");
        String invb = new String(romcell + "_inverterbot");
        String romname = new String(romcell + "_rom");
        String rp = new String(romcell + "_romplane");
        String ip = new String(romcell + "_inverterplane");
        String mp = new String(romcell + "_muxplane");
        if (this.folds > 1) {
            romarray = this.romfold(romarray);
        }
        this.romplane(destLib, this.lambda, romarray, rp);
        int bits = Double.valueOf(Math.ceil(Math.log(this.globalbits) / Math.log(2.0))).intValue();
        int words = (int)Math.pow(2.0, bits);
        int foldbits = Double.valueOf(Math.ceil(Math.log(this.folds) / Math.log(2.0))).intValue();
        boolean top = true;
        boolean bot = false;
        this.decoderpmos(destLib, this.lambda, bits, dpr, top);
        this.decodernmos(destLib, this.lambda, bits, dnr, top);
        this.inverterplane(destLib, this.lambda, romarray.length, this.folds, ip);
        this.ininverterplane(destLib, this.lambda, bits, invt, top, bits);
        ArcProto m1arc = this.tech.findArcProto("Metal-1");
        ArcProto m2arc = this.tech.findArcProto("Metal-2");
        Cell decp = destLib.findNodeProto(dpr + "{lay}");
        ERectangle decpBounds = decp.getBounds();
        PortProto[] decpin = new PortProto[words];
        PortProto[] decpout = new PortProto[words];
        PortProto[] decpbit = new PortProto[2 * bits];
        PortProto decpvdd = decp.findPortProto("vdd");
        PortProto decpvddb = decp.findPortProto("vddb");
        for (i5 = 0; i5 < words; ++i5) {
            decpin[i5] = decp.findPortProto("wordin" + i5);
            decpout[i5] = decp.findPortProto("word" + i5);
        }
        for (i5 = 0; i5 < bits; ++i5) {
            decpbit[2 * i5] = decp.findPortProto("top_in" + i5);
            decpbit[2 * i5 + 1] = decp.findPortProto("top_in" + i5 + "_b");
        }
        Cell decn = destLib.findNodeProto(dnr + "{lay}");
        ERectangle decnBounds = decn.getBounds();
        PortProto[] decnout = new PortProto[words];
        PortProto[] decnin = new PortProto[words];
        PortProto[] decnbit = new PortProto[2 * bits];
        for (i4 = 0; i4 < words; ++i4) {
            decnin[i4] = decn.findPortProto("mid" + i4);
            decnout[i4] = decn.findPortProto("word" + i4);
        }
        for (i4 = 0; i4 < bits; ++i4) {
            decnbit[2 * i4] = decn.findPortProto("top_in" + i4);
            decnbit[2 * i4 + 1] = decn.findPortProto("top_in" + i4 + "_b");
        }
        Cell romp = destLib.findNodeProto(rp + "{lay}");
        ERectangle rompBounds = romp.getBounds();
        PortProto[] rompin = new PortProto[this.globalbits];
        PortProto[] rompout = new PortProto[romarray.length];
        PortProto[] rompgnd = new PortProto[romarray.length / 2];
        PortProto rompvdd = romp.findPortProto("vdd");
        PortProto rompgndc = romp.findPortProto("gndc");
        for (i3 = 0; i3 < this.globalbits; ++i3) {
            rompin[i3] = romp.findPortProto("wordline_" + i3);
        }
        for (i3 = 0; i3 < romarray.length; ++i3) {
            rompout[i3] = romp.findPortProto("out_" + i3);
        }
        for (i3 = 0; i3 < romarray.length / 2; ++i3) {
            rompgnd[i3] = romp.findPortProto("romgnd" + i3);
        }
        Cell invp = destLib.findNodeProto(ip + "{lay}");
        ERectangle invpBounds = invp.getBounds();
        PortProto[] invin = new PortProto[romarray.length];
        PortProto[] invout = new PortProto[romarray.length];
        PortProto[] invgnd = new PortProto[romarray.length / 2];
        PortProto invvddc = invp.findPortProto("vdd");
        PortProto invgndc = invp.findPortProto("gnd");
        for (int i6 = 0; i6 < romarray.length / this.folds; ++i6) {
            invin[i6] = invp.findPortProto("invin" + i6);
            invout[i6] = invp.findPortProto("invout" + i6);
        }
        int invplanegnd = romarray.length / this.folds;
        if (this.folds == 1) {
            invplanegnd /= 2;
        }
        for (int i7 = 0; i7 < invplanegnd; ++i7) {
            invgnd[i7] = invp.findPortProto("invgnd" + i7);
        }
        Cell ininvtp = destLib.findNodeProto(invt + "{lay}");
        ERectangle ininvtpBounds = ininvtp.getBounds();
        PortProto[] ivttop = new PortProto[bits];
        PortProto[] ivtbot = new PortProto[bits];
        PortProto[] ivtbar = new PortProto[bits];
        PortProto ivtvdd = ininvtp.findPortProto("vdd");
        PortProto ivtgnd = ininvtp.findPortProto("gnd");
        for (int i8 = 0; i8 < bits; ++i8) {
            ivttop[i8] = ininvtp.findPortProto("in_top" + i8);
            ivtbot[i8] = ininvtp.findPortProto("in_bot" + i8);
            ivtbar[i8] = ininvtp.findPortProto("in_b" + i8);
        }
        Cell rom = Cell.newInst(destLib, romname + "{lay}");
        double offset = (double)(2 * bits) * (8.0 * this.lambda) + 16.0 * this.lambda;
        double rompoffset = 8.0 * this.lambda * 2.0 * (double)bits + 12.0 * this.lambda + offset;
        double rompoffsety = 8.0 * this.lambda * (double)(this.globalbits + 1);
        double foldoffsetx = (double)(2 * (bits - foldbits)) * (8.0 * this.lambda);
        double muxpoffsety = -6.0 * this.lambda;
        double foldoffsety = -8.0 * this.lambda * (double)(this.folds + 1);
        double ininvtoffset = (double)((this.globalbits + 2) * 8) * this.lambda + 48.0 * this.lambda;
        ininvtoffset += 44.0 * this.lambda;
        double invpoffsety = -8.0 * this.lambda * (double)(this.folds + 1) - 16.0 * this.lambda;
        if (this.folds == 1) {
            invpoffsety += 24.0 * this.lambda;
        }
        NodeInst nplane = this.makeCStyleNodeInst(decn, ((RectangularShape)decnBounds).getMinX() + offset, ((RectangularShape)decnBounds).getMaxX() + offset, ((RectangularShape)decnBounds).getMinY(), ((RectangularShape)decnBounds).getMaxY(), 0, 0, rom);
        NodeInst pplane = this.makeCStyleNodeInst(decp, ((RectangularShape)decpBounds).getMinX(), ((RectangularShape)decpBounds).getMaxX(), ((RectangularShape)decpBounds).getMinY(), ((RectangularShape)decpBounds).getMaxY(), 0, 0, rom);
        NodeInst rompln = this.makeCStyleNodeInst(romp, ((RectangularShape)rompBounds).getMinX() + rompoffset, ((RectangularShape)rompBounds).getMaxX() + rompoffset, ((RectangularShape)rompBounds).getMinY() + rompoffsety, ((RectangularShape)rompBounds).getMaxY() + rompoffsety, 0, 2700, rom);
        NodeInst invpln = this.makeCStyleNodeInst(invp, ((RectangularShape)invpBounds).getMinX() + rompoffset, ((RectangularShape)invpBounds).getMaxX() + rompoffset, ((RectangularShape)invpBounds).getMinY() + invpoffsety, ((RectangularShape)invpBounds).getMaxY() + invpoffsety, 0, 0, rom);
        NodeInst ininvtop1 = this.makeCStyleNodeInst(ininvtp, ((RectangularShape)ininvtpBounds).getMinX(), ((RectangularShape)ininvtpBounds).getMaxX(), ((RectangularShape)ininvtpBounds).getMinY() + ininvtoffset, ((RectangularShape)ininvtpBounds).getMaxY() + ininvtoffset, 0, 0, rom);
        NodeInst ininvtop2 = this.makeCStyleNodeInst(ininvtp, ((RectangularShape)ininvtpBounds).getMinX() + offset, ((RectangularShape)ininvtpBounds).getMaxX() + offset, ((RectangularShape)ininvtpBounds).getMinY() + ininvtoffset, ((RectangularShape)ininvtpBounds).getMaxY() + ininvtoffset, 0, 0, rom);
        for (i2 = 0; i2 < bits; ++i2) {
            ap1 = ininvtop1;
            apport1 = ivttop[i2];
            this.makeCStyleExport(rom, ap1, apport1, "sel" + i2, PortCharacteristic.IN);
        }
        for (i2 = 0; i2 < romarray.length / this.folds; ++i2) {
            ap1 = invpln;
            apport1 = invout[i2];
            this.makeCStyleExport(rom, ap1, apport1, "out" + i2, PortCharacteristic.OUT);
        }
        NodeInst ap2 = rompln;
        PortProto apport2 = rompvdd;
        this.makeCStyleExport(rom, ap2, apport2, "vdd", PortCharacteristic.PWR);
        ap1 = nplane;
        apport1 = decn.findPortProto("gnd");
        double[] appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        ap2 = rompln;
        apport2 = rompgndc;
        double[] appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        this.makeCStyleArcInst(m1arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        apport2 = romp.findPortProto("gnd");
        for (i2 = 0; i2 < words; ++i2) {
            ap1 = pplane;
            apport1 = decpout[i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = nplane;
            apport2 = decnin[i2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m2arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i2 = 0; i2 < words; ++i2) {
            if (i2 >= this.globalbits) continue;
            ap1 = nplane;
            apport1 = decnout[i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = rompln;
            apport2 = rompin[i2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m2arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        if (this.folds > 1) {
            for (i2 = 0; i2 < romarray.length / this.folds; ++i2) {
                ap1 = invpln;
                apport1 = invgnd[i2];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = rompln;
                apport2 = rompgnd[i2 * this.folds / 2];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m1arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
        } else {
            for (i2 = 0; i2 < romarray.length / (2 * this.folds); ++i2) {
                ap1 = invpln;
                apport1 = invgnd[i2];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = rompln;
                apport2 = rompgnd[i2];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m1arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
        }
        for (i2 = 0; i2 < bits; ++i2) {
            ap1 = ininvtop1;
            apport1 = ivttop[i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = ininvtop2;
            apport2 = ivttop[i2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m2arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i2 = 0; i2 < bits; ++i2) {
            ap1 = ininvtop1;
            apport1 = ivtbot[i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = pplane;
            apport2 = decpbit[i2 * 2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m1arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            ap1 = ininvtop1;
            apport1 = ivtbar[i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = pplane;
            apport2 = decpbit[i2 * 2 + 1];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m1arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i2 = 0; i2 < bits; ++i2) {
            ap1 = ininvtop2;
            apport1 = ivtbot[i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = nplane;
            apport2 = decnbit[i2 * 2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m1arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            ap1 = ininvtop2;
            apport1 = ivtbar[i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = nplane;
            apport2 = decnbit[i2 * 2 + 1];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m1arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        ap1 = ininvtop1;
        apport1 = ivtvdd;
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        ap2 = ininvtop2;
        apport2 = ivtvdd;
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        NodeInst ap3 = pplane;
        PortProto apport3 = decpvdd;
        double[] appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
        this.makeCStyleArcInst(m2arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        this.makeCStyleArcInst(m2arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap3, apport3, appos3[0], appos3[1]);
        ap1 = ininvtop1;
        apport1 = ivtgnd;
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        ap2 = ininvtop2;
        apport2 = ivtgnd;
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        ap3 = rompln;
        apport3 = rompgndc;
        appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
        this.makeCStyleArcInst(m2arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        this.makeCStyleArcInst(m1arc, 4.0 * this.lambda, ap2, apport2, appos2[0], appos2[1], ap3, apport3, appos3[0], appos3[1]);
        this.makeCStyleExport(rom, ap2, apport2, "gnd", PortCharacteristic.GND);
        ap1 = ininvtop2;
        apport1 = ivtvdd;
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        ap2 = rompln;
        apport2 = rompvdd;
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        this.makeCStyleArcInst(m2arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        if (this.folds > 1) {
            int i9;
            int i10;
            int i11;
            int i12;
            this.decoderpmos(destLib, this.lambda, foldbits, dpm, bot);
            this.decodernmos(destLib, this.lambda, foldbits, dnm, bot);
            this.ininverterplane(destLib, this.lambda, foldbits, invb, bot, bits);
            this.muxplane(destLib, this.lambda, this.folds, romarray.length, mp);
            Cell decpmux = destLib.findNodeProto(dpm + "{lay}");
            ERectangle decpmuxBounds = decpmux.getBounds();
            PortProto[] decpmuxin = new PortProto[this.folds];
            PortProto[] decpmuxout = new PortProto[this.folds];
            PortProto[] decpmuxbit = new PortProto[2 * foldbits];
            PortProto decpmuxvdd = decpmux.findPortProto("vdd");
            PortProto decpmuxvddb = decpmux.findPortProto("vddb");
            for (i12 = 0; i12 < this.folds; ++i12) {
                decpmuxin[i12] = decpmux.findPortProto("wordin" + i12);
                decpmuxout[i12] = decpmux.findPortProto("word" + i12);
            }
            for (i12 = 0; i12 < foldbits; ++i12) {
                decpmuxbit[2 * i12] = decpmux.findPortProto("bot_in" + i12);
                decpmuxbit[2 * i12 + 1] = decpmux.findPortProto("bot_in" + i12 + "_b");
            }
            Cell decnmux = destLib.findNodeProto(dnm + "{lay}");
            ERectangle decnmuxBounds = decnmux.getBounds();
            PortProto[] decnmuxout = new PortProto[this.folds];
            PortProto[] decnmuxin = new PortProto[this.folds];
            PortProto[] decnmuxbit = new PortProto[2 * foldbits];
            for (i11 = 0; i11 < this.folds; ++i11) {
                decnmuxin[i11] = decnmux.findPortProto("mid" + i11);
                decnmuxout[i11] = decnmux.findPortProto("word" + i11);
            }
            for (i11 = 0; i11 < foldbits; ++i11) {
                decnmuxbit[2 * i11] = decnmux.findPortProto("bot_in" + i11);
                decnmuxbit[2 * i11 + 1] = decnmux.findPortProto("bot_in" + i11 + "_b");
            }
            Cell muxp = destLib.findNodeProto(mp + "{lay}");
            ERectangle muxpBounds = muxp.getBounds();
            PortProto[] muxin = new PortProto[romarray.length];
            PortProto[] muxout = new PortProto[romarray.length / this.folds];
            PortProto[] muxsel = new PortProto[this.folds];
            for (i10 = 0; i10 < romarray.length; ++i10) {
                muxin[i10] = muxp.findPortProto("muxin" + i10);
            }
            for (i10 = 0; i10 < romarray.length / this.folds; ++i10) {
                muxout[i10] = muxp.findPortProto("muxout" + i10);
            }
            for (i10 = 0; i10 < this.folds; ++i10) {
                muxsel[i10] = muxp.findPortProto("sel" + i10);
            }
            Cell ininvbp = destLib.findNodeProto(invb + "{lay}");
            ERectangle ininvbpBounds = ininvbp.getBounds();
            PortProto[] ivbtop = new PortProto[foldbits];
            PortProto[] ivbbot = new PortProto[foldbits];
            PortProto[] ivbbar = new PortProto[foldbits];
            PortProto ivbvdd = ininvbp.findPortProto("vdd");
            PortProto ivbgnd = ininvbp.findPortProto("gnd");
            for (int i13 = 0; i13 < foldbits; ++i13) {
                ivbtop[i13] = ininvbp.findPortProto("in_top" + i13);
                ivbbot[i13] = ininvbp.findPortProto("in_bot" + i13);
                ivbbar[i13] = ininvbp.findPortProto("in_b" + i13);
            }
            NodeInst muxpln = this.makeCStyleNodeInst(muxp, ((RectangularShape)muxpBounds).getMinX() + rompoffset, ((RectangularShape)muxpBounds).getMaxX() + rompoffset, ((RectangularShape)muxpBounds).getMinY() + muxpoffsety, ((RectangularShape)muxpBounds).getMaxY() + muxpoffsety, 0, 2700, rom);
            NodeInst pplnmx = this.makeCStyleNodeInst(decpmux, ((RectangularShape)decpmuxBounds).getMinX() + foldoffsetx, ((RectangularShape)decpmuxBounds).getMaxX() + foldoffsetx, ((RectangularShape)decpmuxBounds).getMinY() + muxpoffsety + foldoffsety, ((RectangularShape)decpmuxBounds).getMaxY() + muxpoffsety + foldoffsety, 0, 0, rom);
            NodeInst nplnmx = this.makeCStyleNodeInst(decnmux, ((RectangularShape)decnmuxBounds).getMinX() + foldoffsetx + offset, ((RectangularShape)decnmuxBounds).getMaxX() + foldoffsetx + offset, ((RectangularShape)decnmuxBounds).getMinY() + muxpoffsety + foldoffsety, ((RectangularShape)decnmuxBounds).getMaxY() + muxpoffsety + foldoffsety, 0, 0, rom);
            NodeInst ininvbot1 = this.makeCStyleNodeInst(ininvbp, ((RectangularShape)ininvbpBounds).getMinX() + foldoffsetx, ((RectangularShape)ininvbpBounds).getMaxX() + foldoffsetx, ((RectangularShape)ininvbpBounds).getMinY() + invpoffsety, ((RectangularShape)ininvbpBounds).getMaxY() + invpoffsety, 0, 0, rom);
            NodeInst ininvbot2 = this.makeCStyleNodeInst(ininvbp, ((RectangularShape)ininvbpBounds).getMinX() + foldoffsetx + offset, ((RectangularShape)ininvbpBounds).getMaxX() + foldoffsetx + offset, ((RectangularShape)ininvbpBounds).getMinY() + invpoffsety, ((RectangularShape)ininvbpBounds).getMaxY() + invpoffsety, 0, 0, rom);
            for (i9 = 0; i9 < foldbits; ++i9) {
                ap1 = ininvbot1;
                apport1 = ivbbot[i9];
                this.makeCStyleExport(rom, ap1, apport1, "colsel" + i9, PortCharacteristic.IN);
            }
            ap1 = nplane;
            apport1 = decn.findPortProto("gnd");
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap3 = pplnmx;
            apport3 = decpmuxvdd;
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            NodeInst ap4 = pplane;
            PortProto apport4 = decpvddb;
            double[] appos4 = ROMGenerator.getCStylePortPosition(ap4, apport4);
            this.makeCStyleArcInst(m1arc, 4.0 * this.lambda, ap4, apport4, appos4[0], appos4[1], ap3, apport3, appos3[0], appos3[1]);
            ap3 = nplnmx;
            apport3 = decnmux.findPortProto("gnd");
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            this.makeCStyleArcInst(m1arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap3, apport3, appos3[0], appos3[1]);
            for (i9 = 0; i9 < this.folds; ++i9) {
                ap1 = pplnmx;
                apport1 = decpmuxout[i9];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = nplnmx;
                apport2 = decnmuxin[i9];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m2arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            for (i9 = 0; i9 < this.folds; ++i9) {
                ap1 = nplnmx;
                apport1 = decnmuxout[i9];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = muxpln;
                apport2 = muxsel[i9];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m2arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            for (i9 = 0; i9 < romarray.length; ++i9) {
                ap1 = rompln;
                apport1 = rompout[i9];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = muxpln;
                apport2 = muxin[i9];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m1arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            for (i9 = 0; i9 < romarray.length / this.folds; ++i9) {
                ap1 = invpln;
                apport1 = invin[i9];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = muxpln;
                apport2 = muxout[i9];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m1arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            for (i9 = 0; i9 < foldbits; ++i9) {
                ap1 = ininvbot1;
                apport1 = ivbbot[i9];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = ininvbot2;
                apport2 = ivbbot[i9];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m2arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            for (i9 = 0; i9 < foldbits; ++i9) {
                ap1 = ininvbot1;
                apport1 = ivbtop[i9];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = pplnmx;
                apport2 = decpmuxbit[i9 * 2];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m1arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ap1 = ininvbot1;
                apport1 = ivbbar[i9];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = pplnmx;
                apport2 = decpmuxbit[i9 * 2 + 1];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m1arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            for (i9 = 0; i9 < foldbits; ++i9) {
                ap1 = ininvbot2;
                apport1 = ivbtop[i9];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = nplnmx;
                apport2 = decnmuxbit[i9 * 2];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m1arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ap1 = ininvbot2;
                apport1 = ivbbar[i9];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = nplnmx;
                apport2 = decnmuxbit[i9 * 2 + 1];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m1arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            ap1 = ininvbot1;
            apport1 = ivbvdd;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = ininvbot2;
            apport2 = ivbvdd;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ap3 = pplnmx;
            apport3 = decpmuxvddb;
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            this.makeCStyleArcInst(m2arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            this.makeCStyleArcInst(m1arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap3, apport3, appos3[0], appos3[1]);
            ap1 = ininvbot1;
            apport1 = ivbgnd;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = ininvbot2;
            apport2 = ivbgnd;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ap3 = invpln;
            apport3 = invgndc;
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            this.makeCStyleArcInst(m2arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            this.makeCStyleArcInst(m2arc, 4.0 * this.lambda, ap3, apport3, appos3[0], appos3[1], ap2, apport2, appos2[0], appos2[1]);
            ap1 = invpln;
            apport1 = invvddc;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = ininvbot2;
            apport2 = ivbvdd;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m2arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        if (this.folds == 1) {
            for (int i14 = 0; i14 < romarray.length; ++i14) {
                ap1 = invpln;
                apport1 = invin[i14];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = rompln;
                apport2 = rompout[i14];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m1arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            PrimitiveNode m1m2c = this.tech.findNodeProto("Metal-1-Metal-2-Con");
            PortProto m1m2cport = m1m2c.getPort(0);
            double[] m1m2cbox = new double[]{-5.0 * this.lambda / 2.0, 5.0 * this.lambda / 2.0, -5.0 * this.lambda / 2.0, 5.0 * this.lambda / 2.0};
            double vddoffsetx = offset - 4.0 * this.lambda;
            double vddoffsety = invpoffsety - 26.0 * this.lambda;
            NodeInst vddbot = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + vddoffsetx, m1m2cbox[1] + vddoffsetx, m1m2cbox[2] + vddoffsety, m1m2cbox[3] + vddoffsety, 0, 0, rom);
            ap1 = invpln;
            apport1 = invvddc;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = vddbot;
            apport2 = m1m2cport;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ap3 = pplane;
            apport3 = decpvddb;
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            this.makeCStyleArcInst(m2arc, 4.0 * this.lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            this.makeCStyleArcInst(m1arc, 4.0 * this.lambda, ap2, apport2, appos2[0], appos2[1], ap3, apport3, appos3[0], appos3[1]);
        }
        return rom;
    }

    private void romplane(Library destLib, double lambda, int[][] romarray, String rp) {
        double[] appos3;
        PortProto apport3;
        NodeInst ap3;
        double[] appos2;
        PortProto apport2;
        NodeInst ap2;
        double[] appos1;
        int m2;
        PortProto apport1;
        NodeInst ap1;
        int i2;
        int inputs = romarray[0].length;
        int wordlines = romarray.length;
        NodeInst[][] andtrans = new NodeInst[wordlines + 2][inputs + 2];
        NodeInst[] pulluptrans = new NodeInst[wordlines + 2];
        NodeInst[] nwellc = new NodeInst[(wordlines + 2) / 2];
        NodeInst[][] minpins = new NodeInst[wordlines + 2][inputs + 2];
        NodeInst[][] diffpins = new NodeInst[wordlines + 2][inputs + 2];
        NodeInst[][] gndpins = new NodeInst[wordlines / 2][inputs + 2];
        NodeInst[] gnd_2pins = new NodeInst[wordlines / 2];
        NodeInst[] m1polypins = new NodeInst[inputs + 2];
        NodeInst[] m1m2pins = new NodeInst[inputs + 2];
        NodeInst[] m1m2_2pins = new NodeInst[wordlines + 2];
        NodeInst[] m1m2_3pins = new NodeInst[wordlines + 2];
        NodeInst[] m1m2_4pins = new NodeInst[wordlines + 2];
        NodeInst[] mpac_1pins = new NodeInst[wordlines + 2];
        NodeInst[] mpac_2pins = new NodeInst[wordlines + 2];
        NodeInst[] gndpex = new NodeInst[1];
        NodeInst[] gndm1ex = new NodeInst[1];
        NodeInst gnd1pin = null;
        NodeInst vdd2pin = null;
        PortProto[] nwellcports = new PortProto[(wordlines + 2) / 2];
        PortProto[][] minports = new PortProto[wordlines + 2][inputs + 2];
        PortProto[][] gndports = new PortProto[wordlines / 2][inputs + 2];
        PortProto[] gnd_2ports = new PortProto[wordlines / 2];
        PortProto[] m1m2_2ports = new PortProto[wordlines + 2];
        PortProto[] m1m2_3ports = new PortProto[wordlines + 2];
        PortProto[] m1m2_4ports = new PortProto[wordlines + 2];
        PortProto[] mpac_1ports = new PortProto[wordlines + 2];
        PortProto[] mpac_2ports = new PortProto[wordlines + 2];
        PortProto[] gndpexport = new PortProto[1];
        PortProto[] gndm1export = new PortProto[1];
        PortProto gnd1port = null;
        PortProto vdd2port = null;
        PrimitiveNode nmos = this.tech.findNodeProto("N-Transistor");
        PortProto nmosg1port = nmos.findPortProto("poly-right");
        PortProto nmosg2port = nmos.findPortProto("poly-left");
        PortProto nmosd1port = nmos.findPortProto("diff-top");
        PortProto nmosd2port = nmos.findPortProto("diff-bottom");
        double[] nmosbox = new double[]{-nmos.getDefWidth(this.ep) / 2.0 - lambda / 2.0, nmos.getDefWidth(this.ep) / 2.0 + lambda / 2.0, -nmos.getDefHeight(this.ep) / 2.0, nmos.getDefHeight(this.ep) / 2.0};
        PrimitiveNode pmos = this.tech.findNodeProto("P-Transistor");
        PortProto pmosg1port = pmos.findPortProto("poly-right");
        PortProto pmosg2port = pmos.findPortProto("poly-left");
        PortProto pmosd1port = pmos.findPortProto("diff-top");
        PortProto pmosd2port = pmos.findPortProto("diff-bottom");
        double bbb = 15.0;
        double ccc = 23.0;
        double[] pmosbox = new double[]{-bbb * lambda / 2.0, bbb * lambda / 2.0, -ccc * lambda / 2.0, ccc * lambda / 2.0};
        PrimitiveNode ppin = this.tech.findNodeProto("Polysilicon-1-Pin");
        PortProto ppinport = ppin.getPort(0);
        double[] ppinbox = new double[]{-ppin.getDefWidth(this.ep) / 2.0, ppin.getDefWidth(this.ep) / 2.0, -ppin.getDefHeight(this.ep) / 2.0, ppin.getDefHeight(this.ep) / 2.0};
        PrimitiveNode m1pin = this.tech.findNodeProto("Metal-1-Pin");
        PortProto m1pinport = m1pin.getPort(0);
        double[] m1pinbox = new double[]{-m1pin.getDefWidth(this.ep) / 2.0 - lambda / 2.0, m1pin.getDefWidth(this.ep) / 2.0 + lambda / 2.0, -m1pin.getDefHeight(this.ep) / 2.0 - lambda / 2.0, m1pin.getDefHeight(this.ep) / 2.0 + lambda / 2.0};
        PrimitiveNode m2pin = this.tech.findNodeProto("Metal-2-Pin");
        PortProto m2pinport = m2pin.getPort(0);
        double[] m2pinbox = new double[]{-m2pin.getDefWidth(this.ep) / 2.0 - lambda / 2.0, m2pin.getDefWidth(this.ep) / 2.0 + lambda / 2.0, -m2pin.getDefHeight(this.ep) / 2.0 - lambda / 2.0, m2pin.getDefHeight(this.ep) / 2.0 + lambda / 2.0};
        PrimitiveNode diffpin = this.tech.findNodeProto("Active-Pin");
        PortProto diffpinport = diffpin.getPort(0);
        double[] diffpinbox = new double[]{-diffpin.getDefWidth(this.ep) / 2.0 - lambda / 2.0, diffpin.getDefWidth(this.ep) / 2.0 + lambda / 2.0, -diffpin.getDefHeight(this.ep) / 2.0 - lambda / 2.0, diffpin.getDefHeight(this.ep) / 2.0 + lambda / 2.0};
        PrimitiveNode nwnode = this.tech.findNodeProto("N-Well-Node");
        PrimitiveNode pwnode = this.tech.findNodeProto("P-Well-Node");
        PrimitiveNode psnode = this.tech.findNodeProto("P-Select-Node");
        PrimitiveNode mnac = this.tech.findNodeProto("Metal-1-N-Active-Con");
        PortProto mnacport = mnac.getPort(0);
        double aaa = 17.0;
        double[] mnacbox = new double[]{-aaa * lambda / 2.0, aaa * lambda / 2.0, -aaa * lambda / 2.0, aaa * lambda / 2.0};
        PrimitiveNode mpac = this.tech.findNodeProto("Metal-1-P-Active-Con");
        PortProto mpacport = mpac.getPort(0);
        double[] mpacbox = new double[]{-aaa * lambda / 2.0, aaa * lambda / 2.0, -aaa * lambda / 2.0, aaa * lambda / 2.0};
        PrimitiveNode mpwc = this.tech.findNodeProto("Metal-1-P-Well-Con");
        PortProto mpwcport = mpwc.getPort(0);
        double[] mpwcbox = new double[]{-17.0 * lambda / 2.0, 17.0 * lambda / 2.0, -17.0 * lambda / 2.0, 17.0 * lambda / 2.0};
        PrimitiveNode mnwc = this.tech.findNodeProto("Metal-1-N-Well-Con");
        PortProto mnwcport = mnwc.getPort(0);
        double nwellx = 29.0;
        double nwelly = 17.0;
        double[] mnwcbox = new double[]{-nwellx * lambda / 2.0, nwellx * lambda / 2.0, -nwelly * lambda / 2.0, nwelly * lambda / 2.0};
        PrimitiveNode mpc = this.tech.findNodeProto("Metal-1-Polysilicon-1-Con");
        PortProto mpcport = mpc.getPort(0);
        double mx = 5.0;
        double[] mpcbox = new double[]{-mx * lambda / 2.0, mx * lambda / 2.0, -mx * lambda / 2.0, mx * lambda / 2.0};
        PrimitiveNode m1m2c = this.tech.findNodeProto("Metal-1-Metal-2-Con");
        PortProto m1m2cport = m1m2c.getPort(0);
        double[] m1m2cbox = new double[]{-mx * lambda / 2.0, mx * lambda / 2.0, -mx * lambda / 2.0, mx * lambda / 2.0};
        PrimitiveNode nsnode = this.tech.findNodeProto("N-Select-Node");
        ArcProto parc = this.tech.findArcProto("Polysilicon-1");
        ArcProto m1arc = this.tech.findArcProto("Metal-1");
        ArcProto m2arc = this.tech.findArcProto("Metal-2");
        ArcProto ndiffarc = this.tech.findArcProto("N-Active");
        ArcProto pdiffarc = this.tech.findArcProto("P-Active");
        Cell romplane = Cell.newInst(destLib, rp + "{lay}");
        this.makeCStyleNodeInst(pwnode, -4.0 * lambda, 8.0 * lambda * (double)(inputs + 2), -4.0 * lambda, 24.0 * lambda * (double)wordlines / 2.0, 0, 0, romplane);
        double ptranssize = 20.0;
        this.makeCStyleNodeInst(psnode, -28.0 * lambda, (ptranssize - 28.0) * lambda, 4.0 * lambda, (double)(4 + 24 * wordlines / 2) * lambda, 0, 0, romplane);
        this.makeCStyleNodeInst(nsnode, 0.0 * lambda, 8.0 * lambda * (double)inputs, 4.0 * lambda, (double)(4 + 24 * wordlines / 2) * lambda, 0, 0, romplane);
        this.makeCStyleNodeInst(nwnode, -38.0 * lambda, (ptranssize - 38.0) * lambda, 20.0 * lambda, (double)(4 + 24 * wordlines / 2) * lambda, 0, 0, romplane);
        double x = 0.0;
        for (i2 = 0; i2 < inputs + 1; ++i2) {
            x += 8.0 * lambda;
            double y = 0.0;
            if (i2 < inputs) {
                andtrans[0][i2] = this.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2], ppinbox[3], 0, 0, romplane);
                m1polypins[i2] = this.makeCStyleNodeInst(mpc, mpcbox[0] + x, mpcbox[1] + x, mpcbox[2], mpcbox[3], 0, 0, romplane);
                m1m2pins[i2] = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x, m1m2cbox[1] + x, m1m2cbox[2], m1m2cbox[3], 0, 0, romplane);
                ap1 = m1m2pins[i2];
                apport1 = m1m2cport;
                this.makeCStyleExport(romplane, ap1, apport1, "wordline_" + (inputs - i2 - 1), PortCharacteristic.IN);
            }
            for (m2 = 0; m2 < wordlines; ++m2) {
                y += 8.0 * lambda;
                if (m2 % 2 == 1) {
                    if (i2 % 2 == 1) {
                        gndpins[m2 / 2][i2] = this.makeCStyleNodeInst(mnac, mnacbox[0] + x - 4.0 * lambda, mnacbox[1] + x - 4.0 * lambda, mnacbox[2] + y, mnacbox[3] + y, 0, 0, romplane);
                        gndports[m2 / 2][i2] = mnacport;
                    } else if (i2 == inputs) {
                        gndpins[m2 / 2][i2] = this.makeCStyleNodeInst(mpwc, mpwcbox[0] + x - 4.0 * lambda, mpwcbox[1] + x - 4.0 * lambda, mpwcbox[2] + y, mpwcbox[3] + y, 0, 0, romplane);
                        gndports[m2 / 2][i2] = mpwcport;
                    } else {
                        gndpins[m2 / 2][i2] = this.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 4.0 * lambda, m1pinbox[1] + x - 4.0 * lambda, m1pinbox[2] + y, m1pinbox[3] + y, 0, 0, romplane);
                        gndports[m2 / 2][i2] = m1pinport;
                    }
                    if (i2 == 0) {
                        gnd_2pins[m2 / 2] = this.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 12.0 * lambda, m1pinbox[1] + x - 12.0 * lambda, m1pinbox[2] + y, m1pinbox[3] + y, 0, 0, romplane);
                        gnd_2ports[m2 / 2] = m1pinport;
                        if (m2 == 1) {
                            gndm1ex[m2 / 2] = this.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 12.0 * lambda, m1pinbox[1] + x - 12.0 * lambda, m1pinbox[2] + y - 16.0 * lambda, m1pinbox[3] + y - 16.0 * lambda, 0, 0, romplane);
                            gndm1export[m2 / 2] = m1pinport;
                            gnd1pin = this.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 8.0 * lambda, m1pinbox[1] + x - 8.0 * lambda, m1pinbox[2] + y - 16.0 * lambda, m1pinbox[3] + y - 16.0 * lambda, 0, 0, romplane);
                            gnd1port = m1pinport;
                            vdd2pin = this.makeCStyleNodeInst(m2pin, m2pinbox[0] + x - 32.0 * lambda, m2pinbox[1] + x - 32.0 * lambda, m2pinbox[2] + y - 16.0 * lambda, m2pinbox[3] + y - 16.0 * lambda, 0, 0, romplane);
                            vdd2port = m2pinport;
                        }
                    }
                    y += 8.0 * lambda;
                }
                if (i2 < inputs) {
                    andtrans[m2 + 1][i2] = romarray[m2][i2] == 1 ? this.makeCStyleNodeInst(nmos, nmosbox[0] + x, nmosbox[1] + x, nmosbox[2] + y, nmosbox[3] + y, 1, 0, romplane) : this.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2] + y, ppinbox[3] + y, 0, 0, romplane);
                }
                boolean transcont = false;
                if (i2 < inputs) {
                    boolean bl = transcont = romarray[m2][i2] == 1;
                }
                if (i2 > 1) {
                    transcont |= romarray[m2][i2 - 1] == 1;
                }
                if (i2 % 2 == 0 && transcont) {
                    minpins[m2][i2] = this.makeCStyleNodeInst(mnac, mnacbox[0] + x - 4.0 * lambda, mnacbox[1] + x - 4.0 * lambda, mnacbox[2] + y, mnacbox[3] + y, 0, 0, romplane);
                    diffpins[m2][i2] = this.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 4.0 * lambda, m1pinbox[1] + x - 4.0 * lambda, m1pinbox[2] + y, m1pinbox[3] + y, 0, 0, romplane);
                    minports[m2][i2] = mnacport;
                } else {
                    minpins[m2][i2] = this.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 4.0 * lambda, m1pinbox[1] + x - 4.0 * lambda, m1pinbox[2] + y, m1pinbox[3] + y, 0, 0, romplane);
                    diffpins[m2][i2] = transcont || i2 == 1 && romarray[m2][0] == 1 ? this.makeCStyleNodeInst(diffpin, diffpinbox[0] + x - 4.0 * lambda, diffpinbox[1] + x - 4.0 * lambda, diffpinbox[2] + y, diffpinbox[3] + y, 0, 0, romplane) : this.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 4.0 * lambda, m1pinbox[1] + x - 4.0 * lambda, m1pinbox[2] + y, m1pinbox[3] + y, 0, 0, romplane);
                    minports[m2][i2] = m1pinport;
                }
                if (i2 == inputs) {
                    ap1 = minpins[m2][i2];
                    apport1 = minports[m2][i2];
                    this.makeCStyleExport(romplane, ap1, apport1, "out_" + m2, PortCharacteristic.OUT);
                }
                if (i2 != 0) continue;
                if (m2 % 2 == 1) {
                    nwellc[m2 / 2] = this.makeCStyleNodeInst(mnwc, m1m2cbox[0] + x - 46.0 * lambda, mnwcbox[1] + x - 46.0 * lambda, mnwcbox[2] + y, mnwcbox[3] + y, 0, 0, romplane);
                    nwellcports[m2 / 2] = mnwcport;
                }
                m1m2_2pins[m2] = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 4.0 * lambda, m1m2cbox[1] + x - 4.0 * lambda, m1m2cbox[2] + y, m1m2cbox[3] + y, 0, 0, romplane);
                m1m2_2ports[m2] = m1m2cport;
                m1m2_3pins[m2] = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 20.0 * lambda, m1m2cbox[1] + x - 20.0 * lambda, m1m2cbox[2] + y, m1m2cbox[3] + y, 0, 0, romplane);
                m1m2_3ports[m2] = m1m2cport;
                mpac_1pins[m2] = this.makeCStyleNodeInst(mpac, mpacbox[0] + x - 20.0 * lambda, mpacbox[1] + x - 20.0 * lambda, mpacbox[2] + y, mpacbox[3] + y, 0, 0, romplane);
                mpac_1ports[m2] = mpacport;
                pulluptrans[m2] = this.makeCStyleNodeInst(pmos, pmosbox[0] + x - 26.0 * lambda, pmosbox[1] + x - 26.0 * lambda, pmosbox[2] + y, pmosbox[3] + y, 1, 0, romplane);
                mpac_2pins[m2] = this.makeCStyleNodeInst(mpac, mpacbox[0] + x - 32.0 * lambda, mpacbox[1] + x - 32.0 * lambda, mpacbox[2] + y, mpacbox[3] + y, 0, 0, romplane);
                mpac_2ports[m2] = mpacport;
                m1m2_4pins[m2] = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 32.0 * lambda, m1m2cbox[1] + x - 32.0 * lambda, m1m2cbox[2] + y, m1m2cbox[3] + y, 0, 0, romplane);
                m1m2_4ports[m2] = m1m2cport;
                if (m2 != 0) continue;
                gndpex[m2] = this.makeCStyleNodeInst(mpc, mpcbox[0] + x - 26.0 * lambda, mpcbox[1] + x - 26.0 * lambda, mpcbox[2] + y - 8.0 * lambda, mpcbox[3] + y - 8.0 * lambda, 0, 0, romplane);
                gndpexport[m2] = mpcport;
            }
        }
        for (i2 = 0; i2 < inputs; ++i2) {
            ap1 = andtrans[0][i2];
            apport1 = ppinport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = m1polypins[i2];
            apport2 = mpcport;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ap3 = m1m2pins[i2];
            apport3 = m1m2cport;
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            this.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap2, apport2, appos2[0], appos2[1], ap3, apport3, appos3[0], appos3[1]);
        }
        for (i2 = 0; i2 < inputs; ++i2) {
            ap1 = andtrans[0][i2];
            apport1 = ppinport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (m2 = 1; m2 < wordlines + 1; ++m2) {
                ap2 = andtrans[m2][i2];
                if (romarray[m2 - 1][i2] == 1) {
                    apport2 = nmosg1port;
                    apport3 = nmosg2port;
                } else {
                    apport2 = ppinport;
                    apport3 = ppinport;
                }
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                appos3 = ROMGenerator.getCStylePortPosition(ap2, apport3);
                this.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ap1 = ap2;
                apport1 = apport3;
                appos1 = appos3;
            }
        }
        for (m2 = 0; m2 < wordlines; ++m2) {
            ap1 = minpins[m2][0];
            apport1 = minports[m2][0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (i2 = 1; i2 < inputs + 1; ++i2) {
                ap2 = minpins[m2][i2];
                apport2 = minports[m2][i2];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ap1 = ap2;
                apport1 = apport2;
                appos1 = appos2;
            }
        }
        for (m2 = 0; m2 < wordlines; ++m2) {
            for (i2 = 0; i2 < inputs; ++i2) {
                NodeInst intgnd;
                NodeInst gnd2;
                PortProto gndport1;
                if (romarray[m2][i2] != 1) continue;
                NodeInst gnd1 = ap1 = andtrans[m2 + 1][i2];
                if (i2 % 2 == 0) {
                    apport1 = nmosd1port;
                    gndport1 = nmosd2port;
                    ap2 = minpins[m2][i2];
                    gnd2 = gndpins[m2 / 2][i2 + 1];
                    intgnd = diffpins[m2][i2 + 1];
                } else {
                    apport1 = nmosd2port;
                    gndport1 = nmosd1port;
                    ap2 = minpins[m2][i2 + 1];
                    gnd2 = gndpins[m2 / 2][i2];
                    intgnd = diffpins[m2][i2];
                }
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                double[] gndpos1 = ROMGenerator.getCStylePortPosition(gnd1, gndport1);
                apport2 = mnacport;
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                PortProto gndport2 = mnacport;
                double[] gndpos2 = ROMGenerator.getCStylePortPosition(gnd2, gndport2);
                PortProto intgndport = diffpinport;
                double[] intgndpos = ROMGenerator.getCStylePortPosition(intgnd, intgndport);
                this.makeCStyleArcInst(ndiffarc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                this.makeCStyleArcInst(ndiffarc, 4.0 * lambda, gnd1, gndport1, gndpos1[0], gndpos1[1], intgnd, intgndport, intgndpos[0], intgndpos[1]);
                this.makeCStyleArcInst(ndiffarc, 4.0 * lambda, intgnd, intgndport, intgndpos[0], intgndpos[1], gnd2, gndport2, gndpos2[0], gndpos2[1]);
            }
        }
        for (m2 = 0; m2 < wordlines / 2; ++m2) {
            ap1 = gndpins[m2][0];
            apport1 = gndports[m2][0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (i2 = 1; i2 < inputs + 1; ++i2) {
                ap2 = gndpins[m2][i2];
                apport2 = gndports[m2][i2];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                if (i2 == inputs) {
                    this.makeCStyleExport(romplane, ap1, apport1, "romgnd" + m2, PortCharacteristic.GND);
                }
                ap1 = ap2;
                apport1 = apport2;
                appos1 = appos2;
            }
        }
        for (m2 = 0; m2 < wordlines / 2; ++m2) {
            ap1 = gndpins[m2][0];
            apport1 = gndports[m2][0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = gnd_2pins[m2];
            apport2 = gnd_2ports[m2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        ap1 = gnd_2pins[0];
        apport1 = gnd_2ports[0];
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        for (m2 = 0; m2 < wordlines / 2; ++m2) {
            ap2 = gnd_2pins[m2];
            apport2 = gnd_2ports[m2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            if (m2 != wordlines / 2 - 1) continue;
            this.makeCStyleExport(romplane, ap2, apport2, "gnd", PortCharacteristic.GND);
        }
        ap2 = gndm1ex[0];
        apport2 = gndm1export[0];
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        ap1 = gnd1pin;
        apport1 = gnd1port;
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        this.makeCStyleExport(romplane, ap1, apport1, "gndc", PortCharacteristic.GND);
        ap1 = gndpex[0];
        apport1 = gndpexport[0];
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        ap2 = pulluptrans[0];
        apport2 = pmosg1port;
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        this.makeCStyleArcInst(parc, 3.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        for (m2 = 0; m2 < wordlines; ++m2) {
            ap1 = minpins[m2][0];
            apport1 = minports[m2][0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = m1m2_2pins[m2];
            apport2 = m1m2_2ports[m2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ap3 = m1m2_3pins[m2];
            apport3 = m1m2_3ports[m2];
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            this.makeCStyleArcInst(m2arc, 4.0 * lambda, ap2, apport2, appos2[0], appos2[1], ap3, apport3, appos3[0], appos3[1]);
        }
        for (m2 = 0; m2 < wordlines; ++m2) {
            ap1 = m1m2_3pins[m2];
            apport1 = m1m2_3ports[m2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = mpac_1pins[m2];
            apport2 = mpac_1ports[m2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (m2 = 0; m2 < wordlines; ++m2) {
            NodeInst ap4 = ap1 = pulluptrans[m2];
            PortProto apport4 = pmosd1port;
            apport1 = pmosd2port;
            ap2 = mpac_1pins[m2];
            ap3 = mpac_2pins[m2];
            apport2 = mpacport;
            apport3 = mpacport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            double[] appos4 = ROMGenerator.getCStylePortPosition(ap4, apport4);
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            this.makeCStyleArcInst(pdiffarc, 3.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            this.makeCStyleArcInst(pdiffarc, 3.0 * lambda, ap4, apport4, appos4[0], appos4[1], ap3, apport3, appos3[0], appos3[1]);
        }
        for (m2 = 0; m2 < wordlines; ++m2) {
            ap1 = m1m2_4pins[m2];
            apport1 = m1m2_4ports[m2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = mpac_2pins[m2];
            apport2 = mpac_2ports[m2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (m2 = 0; m2 < wordlines; ++m2) {
            if (m2 % 2 != 1) continue;
            ap1 = nwellc[m2 / 2];
            apport1 = nwellcports[m2 / 2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = mpac_2pins[m2];
            apport2 = mpac_2ports[m2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        ap1 = m1m2_4pins[0];
        apport1 = m1m2_4ports[0];
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        for (m2 = 0; m2 < wordlines; ++m2) {
            ap2 = m1m2_4pins[m2];
            apport2 = m1m2_4ports[m2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        ap2 = vdd2pin;
        apport2 = vdd2port;
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        this.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        this.makeCStyleExport(romplane, ap2, apport2, "vdd", PortCharacteristic.PWR);
        for (m2 = 0; m2 < wordlines - 1; ++m2) {
            ap1 = pulluptrans[m2];
            apport1 = pmosg2port;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = pulluptrans[m2 + 1];
            apport2 = pmosg1port;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(parc, 3.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
    }

    private void decodernmos(Library destLib, double lambda, int bits, String cellname, boolean top) {
        double[] appos3;
        PortProto apport3;
        double[] appos2;
        PortProto apport2;
        NodeInst ap2;
        PortProto apport1;
        NodeInst ap1;
        int m2;
        int i2;
        int[][] romplane = ROMGenerator.generateplane(bits);
        int inputs = romplane[0].length;
        int wordlines = romplane.length;
        NodeInst[][] ortrans = new NodeInst[wordlines + 3][inputs + 2];
        NodeInst[][] minpins = new NodeInst[wordlines + 2][inputs + 2];
        NodeInst[][] vddpins = new NodeInst[wordlines][inputs / 2];
        NodeInst[] pwrpins = new NodeInst[inputs / 2];
        NodeInst[][] m1m2pins = new NodeInst[wordlines + 2][inputs + 2];
        PortProto[][] minports = new PortProto[wordlines + 2][inputs + 2];
        PortProto[][] vddports = new PortProto[wordlines][inputs / 2];
        PortProto[] pwrports = new PortProto[inputs / 2];
        PortProto[][] m1m2ports = new PortProto[wordlines + 2][inputs + 2];
        PrimitiveNode nmos = this.tech.findNodeProto("N-Transistor");
        PortProto nmosg1port = nmos.findPortProto("poly-right");
        PortProto nmosg2port = nmos.findPortProto("poly-left");
        PortProto nmosd1port = nmos.findPortProto("diff-top");
        PortProto nmosd2port = nmos.findPortProto("diff-bottom");
        double[] nmosbox = new double[]{-nmos.getDefWidth(this.ep) / 2.0 - lambda / 2.0, nmos.getDefWidth(this.ep) / 2.0 + lambda / 2.0, -nmos.getDefHeight(this.ep) / 2.0, nmos.getDefHeight(this.ep) / 2.0};
        PrimitiveNode ppin = this.tech.findNodeProto("Polysilicon-1-Pin");
        PortProto ppinport = ppin.getPort(0);
        double[] ppinbox = new double[]{-ppin.getDefWidth(this.ep) / 2.0, ppin.getDefWidth(this.ep) / 2.0, -ppin.getDefHeight(this.ep) / 2.0, ppin.getDefHeight(this.ep) / 2.0};
        PrimitiveNode m1pin = this.tech.findNodeProto("Metal-1-Pin");
        PortProto m1pinport = m1pin.getPort(0);
        double[] m1pinbox = new double[]{-m1pin.getDefWidth(this.ep) / 2.0 - lambda / 2.0, m1pin.getDefWidth(this.ep) / 2.0 + lambda / 2.0, -m1pin.getDefHeight(this.ep) / 2.0 - lambda / 2.0, m1pin.getDefHeight(this.ep) / 2.0 + lambda / 2.0};
        PrimitiveNode m2pin = this.tech.findNodeProto("Metal-2-Pin");
        PortProto m2pinport = m2pin.getPort(0);
        double[] m2pinbox = new double[]{-m1pin.getDefWidth(this.ep) / 2.0 - lambda / 2.0, m1pin.getDefWidth(this.ep) / 2.0 + lambda / 2.0, -m1pin.getDefHeight(this.ep) / 2.0 - lambda / 2.0, m1pin.getDefHeight(this.ep) / 2.0 + lambda / 2.0};
        PrimitiveNode pwnode = this.tech.findNodeProto("P-Well-Node");
        double mx = 5.0;
        PrimitiveNode mpc = this.tech.findNodeProto("Metal-1-Polysilicon-1-Con");
        PortProto mpcport = mpc.getPort(0);
        double[] mpcbox = new double[]{-mx * lambda / 2.0, mx * lambda / 2.0, -mx * lambda / 2.0, mx * lambda / 2.0};
        PrimitiveNode m1m2c = this.tech.findNodeProto("Metal-1-Metal-2-Con");
        PortProto m1m2cport = m1m2c.getPort(0);
        double[] m1m2cbox = new double[]{-5.0 * lambda / 2.0, 5.0 * lambda / 2.0, -5.0 * lambda / 2.0, 5.0 * lambda / 2.0};
        PrimitiveNode mnac = this.tech.findNodeProto("Metal-1-N-Active-Con");
        PortProto mnacport = mnac.getPort(0);
        double aaa = 17.0;
        double[] mnacbox = new double[]{-aaa * lambda / 2.0, aaa * lambda / 2.0, -aaa * lambda / 2.0, aaa * lambda / 2.0};
        ArcProto parc = this.tech.findArcProto("Polysilicon-1");
        ArcProto m1arc = this.tech.findArcProto("Metal-1");
        ArcProto m2arc = this.tech.findArcProto("Metal-2");
        ArcProto ndiffarc = this.tech.findArcProto("N-Active");
        Cell decn = Cell.newInst(destLib, cellname + "{lay}");
        PrimitiveNode nsnode = this.tech.findNodeProto("N-Select-Node");
        this.makeCStyleNodeInst(pwnode, 0.0, 8.0 * lambda * (double)(2 * bits + 1), 0.0, 8.0 * lambda * (double)(wordlines + 1), 0, 0, decn);
        this.makeCStyleNodeInst(nsnode, 0.0, 8.0 * lambda * (double)(2 * bits + 1), 0.0, 8.0 * lambda * (double)(wordlines + 1), 0, 0, decn);
        double x = 0.0;
        for (i2 = 0; i2 < inputs + 1; ++i2) {
            x += 8.0 * lambda;
            double y = 0.0;
            if (i2 % 2 == 1) {
                x += 0.0 * lambda;
            }
            if (i2 < inputs) {
                ortrans[0][i2] = top ? this.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2], ppinbox[3], 0, 0, decn) : this.makeCStyleNodeInst(mpc, mpcbox[0] + x, mpcbox[1] + x, mpcbox[2], mpcbox[3], 0, 0, decn);
            }
            for (m2 = 0; m2 < wordlines; ++m2) {
                y += 8.0 * lambda;
                if (i2 % 2 == 1) {
                    vddpins[m2][i2 / 2] = this.makeCStyleNodeInst(mnac, mnacbox[0] + x - 4.0 * lambda, mnacbox[1] + x - 4.0 * lambda, mnacbox[2] + y, mnacbox[3] + y, 0, 0, decn);
                    vddports[m2][i2 / 2] = mnacport;
                    if (m2 == wordlines - 1) {
                        pwrpins[i2 / 2] = this.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 4.0 * lambda, m1pinbox[1] + x - 4.0 * lambda, m1pinbox[2] + y + 8.0 * lambda, m1pinbox[3] + y + 8.0 * lambda, 0, 0, decn);
                        pwrports[i2 / 2] = m1pinport;
                    }
                }
                if (i2 < inputs) {
                    ortrans[m2 + 1][i2] = romplane[m2][i2] == 1 ? this.makeCStyleNodeInst(nmos, nmosbox[0] + x, nmosbox[1] + x, nmosbox[2] + y, nmosbox[3] + y, 1, 0, decn) : this.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2] + y, ppinbox[3] + y, 0, 0, decn);
                    if (m2 == wordlines - 1) {
                        ortrans[m2 + 2][i2] = top ? this.makeCStyleNodeInst(mpc, mpcbox[0] + x, mpcbox[1] + x, mpcbox[2] + y + 16.0 * lambda, mpcbox[3] + y + 16.0 * lambda, 0, 0, decn) : this.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2] + y + 4.0 * lambda, ppinbox[3] + y + 4.0 * lambda, 0, 0, decn);
                    }
                }
                boolean transcont = false;
                if (i2 < inputs) {
                    boolean bl = transcont = romplane[m2][i2] == 1;
                }
                if (i2 > 1) {
                    transcont |= romplane[m2][i2 - 1] == 1;
                }
                if (i2 % 2 == 0 && transcont) {
                    minpins[m2][i2] = this.makeCStyleNodeInst(mnac, mnacbox[0] + x - 4.0 * lambda, mnacbox[1] + x - 4.0 * lambda, mnacbox[2] + y, mnacbox[3] + y, 0, 0, decn);
                    minports[m2][i2] = mnacport;
                    m1m2pins[m2][i2] = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 4.0 * lambda, m1m2cbox[1] + x - 4.0 * lambda, m1m2cbox[2] + y, m1m2cbox[3] + y, 0, 0, decn);
                    m1m2ports[m2][i2] = m1m2cport;
                } else {
                    minpins[m2][i2] = this.makeCStyleNodeInst(m2pin, m2pinbox[0] + x - 4.0 * lambda, m2pinbox[1] + x - 4.0 * lambda, m2pinbox[2] + y, m2pinbox[3] + y, 0, 0, decn);
                    minports[m2][i2] = m2pinport;
                    if (i2 == 0) {
                        m1m2pins[m2][i2] = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 4.0 * lambda, m1m2cbox[1] + x - 4.0 * lambda, m1m2cbox[2] + y, m1m2cbox[3] + y, 0, 0, decn);
                        m1m2ports[m2][i2] = m1m2cport;
                    } else {
                        m1m2pins[m2][i2] = this.makeCStyleNodeInst(m2pin, m2pinbox[0] + x - 4.0 * lambda, m2pinbox[1] + x - 4.0 * lambda, m2pinbox[2] + y, m2pinbox[3] + y, 0, 0, decn);
                        m1m2ports[m2][i2] = m2pinport;
                    }
                }
                if (i2 != 0) continue;
                ap1 = m1m2pins[m2][i2];
                apport1 = m1m2ports[m2][i2];
                this.makeCStyleExport(decn, ap1, apport1, "mid" + m2, PortCharacteristic.IN);
            }
        }
        ap1 = pwrpins[0];
        apport1 = pwrports[0];
        double[] appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        for (i2 = 1; i2 < inputs / 2; ++i2) {
            ap2 = pwrpins[i2];
            apport2 = pwrports[i2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            ap1 = ap2;
            apport1 = apport2;
            appos1 = appos2;
        }
        this.makeCStyleExport(decn, ap1, apport1, "gnd", PortCharacteristic.GND);
        m2 = wordlines - 1;
        for (i2 = 0; i2 < inputs / 2; ++i2) {
            ap1 = vddpins[m2][i2];
            apport1 = vddports[m2][i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = pwrpins[i2];
            apport2 = pwrports[i2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i2 = 0; i2 < inputs; ++i2) {
            ap1 = ortrans[wordlines + 1][i2];
            apport1 = top ? mpcport : ppinport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            if (i2 % 2 == 0) {
                this.makeCStyleExport(decn, ap1, apport1, "top_in" + i2 / 2, PortCharacteristic.IN);
            } else {
                this.makeCStyleExport(decn, ap1, apport1, "top_in" + (i2 - 1) / 2 + "_b", PortCharacteristic.IN);
            }
            ap1 = ortrans[0][i2];
            apport1 = top ? ppinport : mpcport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            if (i2 % 2 == 0) {
                this.makeCStyleExport(decn, ap1, apport1, "bot_in" + i2 / 2, PortCharacteristic.IN);
            } else {
                this.makeCStyleExport(decn, ap1, apport1, "bot_in" + (i2 - 1) / 2 + "_b", PortCharacteristic.IN);
            }
            for (m2 = 1; m2 < wordlines + 1; ++m2) {
                ap2 = ortrans[m2][i2];
                if (romplane[m2 - 1][i2] == 1) {
                    apport2 = nmosg1port;
                    apport3 = nmosg2port;
                } else {
                    apport2 = ppinport;
                    apport3 = ppinport;
                }
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                appos3 = ROMGenerator.getCStylePortPosition(ap2, apport3);
                this.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ap1 = ap2;
                apport1 = apport3;
                appos1 = appos3;
            }
            ap2 = ortrans[wordlines + 1][i2];
            if (top) {
                apport2 = mpcport;
                apport3 = mpcport;
            } else {
                apport2 = ppinport;
                apport3 = ppinport;
            }
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            appos3 = ROMGenerator.getCStylePortPosition(ap2, apport3);
            this.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (m2 = 0; m2 < wordlines; ++m2) {
            ap1 = m1m2pins[m2][0];
            apport1 = m1m2ports[m2][0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (i2 = 1; i2 < inputs + 1; ++i2) {
                ap2 = m1m2pins[m2][i2];
                apport2 = m1m2ports[m2][i2];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ap1 = ap2;
                apport1 = apport2;
                appos1 = appos2;
            }
            this.makeCStyleExport(decn, ap1, apport1, "word" + m2, PortCharacteristic.OUT);
        }
        for (m2 = 0; m2 < wordlines; ++m2) {
            for (i2 = 0; i2 < inputs; ++i2) {
                NodeInst vdd2;
                NodeInst ap3;
                PortProto vddport1;
                if (romplane[m2][i2] != 1) continue;
                NodeInst vdd1 = ap1 = ortrans[m2 + 1][i2];
                if (i2 % 2 == 0) {
                    apport1 = nmosd1port;
                    vddport1 = nmosd2port;
                    ap2 = minpins[m2][i2];
                    ap3 = m1m2pins[m2][i2];
                    vdd2 = vddpins[m2][i2 / 2];
                } else {
                    apport1 = nmosd2port;
                    vddport1 = nmosd1port;
                    ap2 = minpins[m2][i2 + 1];
                    ap3 = m1m2pins[m2][i2 + 1];
                    vdd2 = vddpins[m2][i2 / 2];
                }
                apport2 = mnacport;
                apport3 = m1m2cport;
                PortProto vddport2 = mnacport;
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                double[] vddpos1 = ROMGenerator.getCStylePortPosition(vdd1, vddport1);
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
                double[] vddpos2 = ROMGenerator.getCStylePortPosition(vdd2, vddport2);
                this.makeCStyleArcInst(ndiffarc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                this.makeCStyleArcInst(ndiffarc, 4.0 * lambda, vdd1, vddport1, vddpos1[0], vddpos1[1], vdd2, vddport2, vddpos2[0], vddpos2[1]);
                this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap2, apport2, appos2[0], appos2[1], ap3, apport3, appos3[0], appos3[1]);
            }
        }
        for (i2 = 0; i2 < inputs / 2; ++i2) {
            ap1 = vddpins[0][i2];
            apport1 = vddports[0][i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (m2 = 1; m2 < wordlines; ++m2) {
                ap2 = vddpins[m2][i2];
                apport2 = vddports[m2][i2];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ap1 = ap2;
                apport1 = apport2;
                appos1 = appos2;
            }
        }
    }

    private void decoderpmos(Library destLib, double lambda, int bits, String cellname, boolean top) {
        double[] appos3;
        double[] appos2;
        PortProto apport3;
        PortProto apport2;
        NodeInst ap2;
        double[] appos1;
        PortProto apport1;
        NodeInst ap1;
        int m2;
        int i2;
        int[][] romplane = ROMGenerator.generateplane(bits);
        int inputs = romplane[0].length;
        int wordlines = romplane.length;
        NodeInst[][] andtrans = new NodeInst[wordlines + 2][inputs + 2];
        NodeInst[][] minpins = new NodeInst[wordlines + 3][inputs + 2];
        NodeInst[] m1m2pins = new NodeInst[wordlines + 2];
        NodeInst[] m2pins = new NodeInst[wordlines + 2];
        NodeInst vddpin = null;
        NodeInst vddbpin = null;
        NodeInst vddcpin = null;
        PortProto[][] minports = new PortProto[wordlines + 2][inputs + 2];
        PortProto[] m1m2ports = new PortProto[wordlines + 2];
        PortProto[] m2ports = new PortProto[wordlines + 2];
        PortProto vddport = null;
        PortProto vddbport = null;
        PortProto vddcport = null;
        PrimitiveNode pmos = this.tech.findNodeProto("P-Transistor");
        PortProto pmosg1port = pmos.findPortProto("poly-right");
        PortProto pmosg2port = pmos.findPortProto("poly-left");
        PortProto pmosd1port = pmos.findPortProto("diff-top");
        PortProto pmosd2port = pmos.findPortProto("diff-bottom");
        double[] pmosbox = new double[]{-pmos.getDefWidth(this.ep) / 2.0 - lambda / 2.0, pmos.getDefWidth(this.ep) / 2.0 + lambda / 2.0, -pmos.getDefHeight(this.ep) / 2.0, pmos.getDefHeight(this.ep) / 2.0};
        PrimitiveNode ppin = this.tech.findNodeProto("Polysilicon-1-Pin");
        PortProto ppinport = ppin.getPort(0);
        double[] ppinbox = new double[]{-ppin.getDefWidth(this.ep) / 2.0, ppin.getDefWidth(this.ep) / 2.0, -ppin.getDefHeight(this.ep) / 2.0, ppin.getDefHeight(this.ep) / 2.0};
        PrimitiveNode m1pin = this.tech.findNodeProto("Metal-1-Pin");
        PortProto m1pinport = m1pin.getPort(0);
        double[] m1pinbox = new double[]{-m1pin.getDefWidth(this.ep) / 2.0 - lambda / 2.0, m1pin.getDefWidth(this.ep) / 2.0 + lambda / 2.0, -m1pin.getDefHeight(this.ep) / 2.0 - lambda / 2.0, m1pin.getDefHeight(this.ep) / 2.0 + lambda / 2.0};
        PrimitiveNode m2pin = this.tech.findNodeProto("Metal-2-Pin");
        PortProto m2pinport = m2pin.getPort(0);
        double[] m2pinbox = new double[]{-m1pin.getDefWidth(this.ep) / 2.0 - lambda / 2.0, m1pin.getDefWidth(this.ep) / 2.0 + lambda / 2.0, -m1pin.getDefHeight(this.ep) / 2.0 - lambda / 2.0, m1pin.getDefHeight(this.ep) / 2.0 + lambda / 2.0};
        double mx = 5.0;
        PrimitiveNode mpc = this.tech.findNodeProto("Metal-1-Polysilicon-1-Con");
        PortProto mpcport = mpc.getPort(0);
        double[] mpcbox = new double[]{-mx * lambda / 2.0, mx * lambda / 2.0, -mx * lambda / 2.0, mx * lambda / 2.0};
        PrimitiveNode m1m2c = this.tech.findNodeProto("Metal-1-Metal-2-Con");
        PortProto m1m2cport = m1m2c.getPort(0);
        double[] m1m2cbox = new double[]{-5.0 * lambda / 2.0, 5.0 * lambda / 2.0, -5.0 * lambda / 2.0, 5.0 * lambda / 2.0};
        PrimitiveNode mpac = this.tech.findNodeProto("Metal-1-P-Active-Con");
        PortProto mpacport = mpac.getPort(0);
        double[] mpacbox = new double[]{-17.0 * lambda / 2.0, 17.0 * lambda / 2.0, -17.0 * lambda / 2.0, 17.0 * lambda / 2.0};
        PrimitiveNode mnwc = this.tech.findNodeProto("Metal-1-N-Well-Con");
        PortProto mnwcport = mnwc.getPort(0);
        double[] mnwcbox = new double[]{-17.0 * lambda / 2.0, 17.0 * lambda / 2.0, -17.0 * lambda / 2.0, 17.0 * lambda / 2.0};
        ArcProto parc = this.tech.findArcProto("Polysilicon-1");
        ArcProto m1arc = this.tech.findArcProto("Metal-1");
        ArcProto m2arc = this.tech.findArcProto("Metal-2");
        ArcProto pdiffarc = this.tech.findArcProto("P-Active");
        PrimitiveNode nwnode = this.tech.findNodeProto("N-Well-Node");
        Cell decp = Cell.newInst(destLib, cellname + "{lay}");
        PrimitiveNode psnode = this.tech.findNodeProto("P-Select-Node");
        this.makeCStyleNodeInst(nwnode, 0.0, 8.0 * lambda * (double)(2 * bits), 0.0, 8.0 * lambda * (double)(wordlines + 1), 0, 0, decp);
        this.makeCStyleNodeInst(psnode, 0.0, 8.0 * lambda * (double)(2 * bits), 0.0, 8.0 * lambda * (double)(wordlines + 1), 0, 0, decp);
        double x = 0.0;
        for (i2 = 0; i2 < inputs + 1; ++i2) {
            x += 8.0 * lambda;
            double y = 0.0;
            if (i2 < inputs) {
                andtrans[0][i2] = top ? this.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2], ppinbox[3], 0, 0, decp) : this.makeCStyleNodeInst(mpc, mpcbox[0] + x, mpcbox[1] + x, mpcbox[2], mpcbox[3], 0, 0, decp);
            }
            for (m2 = 0; m2 < wordlines; ++m2) {
                y += 8.0 * lambda;
                if (i2 < inputs) {
                    andtrans[m2 + 1][i2] = romplane[m2][i2] == 1 ? this.makeCStyleNodeInst(pmos, pmosbox[0] + x, pmosbox[1] + x, pmosbox[2] + y, pmosbox[3] + y, 1, 0, decp) : this.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2] + y, ppinbox[3] + y, 0, 0, decp);
                    if (m2 == wordlines - 1) {
                        andtrans[m2 + 2][i2] = top ? this.makeCStyleNodeInst(mpc, mpcbox[0] + x, mpcbox[1] + x, mpcbox[2] + y + 16.0 * lambda, mpcbox[3] + y + 16.0 * lambda, 0, 0, decp) : this.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2] + y + 4.0 * lambda, ppinbox[3] + y + 4.0 * lambda, 0, 0, decp);
                    }
                }
                boolean transcont = false;
                if (i2 < inputs) {
                    boolean bl = transcont = romplane[m2][i2] == 1;
                }
                if (i2 == 0) {
                    m1m2pins[m2] = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 4.0 * lambda, m1m2cbox[1] + x - 4.0 * lambda, m1m2cbox[2] + y, m1m2cbox[3] + y, 0, 0, decp);
                    m1m2ports[m2] = m1m2cport;
                }
                if (i2 == inputs) {
                    m2pins[m2] = this.makeCStyleNodeInst(m2pin, m2pinbox[0] + x - 4.0 * lambda, m2pinbox[1] + x - 4.0 * lambda, m2pinbox[2] + y, m2pinbox[3] + y, 0, 0, decp);
                    m2ports[m2] = m2pinport;
                }
                if (i2 >= 1) {
                    transcont |= romplane[m2][i2 - 1] == 1;
                }
                if (transcont) {
                    minpins[m2][i2] = this.makeCStyleNodeInst(mpac, mpacbox[0] + x - 4.0 * lambda, mpacbox[1] + x - 4.0 * lambda, mpacbox[2] + y, mpacbox[3] + y, 0, 0, decp);
                    minports[m2][i2] = mpacport;
                } else if (i2 == inputs) {
                    minpins[m2][i2] = this.makeCStyleNodeInst(mnwc, mnwcbox[0] + x - 4.0 * lambda, mnwcbox[1] + x - 4.0 * lambda, mnwcbox[2] + y, mnwcbox[3] + y, 0, 0, decp);
                    minports[m2][i2] = mnwcport;
                } else {
                    minpins[m2][i2] = this.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 4.0 * lambda, m1pinbox[1] + x - 4.0 * lambda, m1pinbox[2] + y, m1pinbox[3] + y, 0, 0, decp);
                    minports[m2][i2] = m1pinport;
                }
                if (i2 != inputs) continue;
                vddpin = this.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 4.0 * lambda, m1pinbox[1] + x - 4.0 * lambda, m1pinbox[2] + y + 8.0 * lambda, m1pinbox[3] + y + 8.0 * lambda, 0, 0, decp);
                vddport = m1pinport;
                if (m2 == 0) {
                    vddbpin = this.makeCStyleNodeInst(m1pin, m1pinbox[0] + x + 4.0 * lambda, m1pinbox[1] + x + 4.0 * lambda, m1pinbox[2] + y + 0.0 * lambda, m1pinbox[3] + y + 0.0 * lambda, 0, 0, decp);
                    vddbport = m1pinport;
                }
                if (m2 != wordlines - 1) continue;
                vddcpin = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x + 4.0 * lambda, m1m2cbox[1] + x + 4.0 * lambda, m1m2cbox[2] + y + 8.0 * lambda, m1m2cbox[3] + y + 8.0 * lambda, 0, 0, decp);
                vddcport = m1m2cport;
            }
        }
        for (i2 = 0; i2 < inputs; ++i2) {
            ap1 = andtrans[wordlines + 1][i2];
            apport1 = top ? mpcport : ppinport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            if (i2 % 2 == 0) {
                this.makeCStyleExport(decp, ap1, apport1, "top_in" + i2 / 2, PortCharacteristic.IN);
            } else {
                this.makeCStyleExport(decp, ap1, apport1, "top_in" + (i2 - 1) / 2 + "_b", PortCharacteristic.IN);
            }
            ap1 = andtrans[0][i2];
            apport1 = top ? ppinport : mpcport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            if (i2 % 2 == 0) {
                this.makeCStyleExport(decp, ap1, apport1, "bot_in" + i2 / 2, PortCharacteristic.IN);
            } else {
                this.makeCStyleExport(decp, ap1, apport1, "bot_in" + (i2 - 1) / 2 + "_b", PortCharacteristic.IN);
            }
            for (m2 = 1; m2 < wordlines + 1; ++m2) {
                ap2 = andtrans[m2][i2];
                if (romplane[m2 - 1][i2] == 1) {
                    apport2 = pmosg1port;
                    apport3 = pmosg2port;
                } else {
                    apport2 = ppinport;
                    apport3 = ppinport;
                }
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                appos3 = ROMGenerator.getCStylePortPosition(ap2, apport3);
                this.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ap1 = ap2;
                apport1 = apport3;
                appos1 = appos3;
            }
            ap2 = andtrans[wordlines + 1][i2];
            if (top) {
                apport2 = mpcport;
                apport3 = mpcport;
            } else {
                apport2 = ppinport;
                apport3 = ppinport;
            }
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            appos3 = ROMGenerator.getCStylePortPosition(ap2, apport3);
            this.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (m2 = 0; m2 < wordlines; ++m2) {
            ap1 = minpins[m2][0];
            apport1 = minports[m2][0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (i2 = 1; i2 < inputs + 1; ++i2) {
                ap2 = minpins[m2][i2];
                apport2 = minports[m2][i2];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                if (romplane[m2][i2 - 1] != 1) {
                    this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                }
                ap1 = ap2;
                apport1 = apport2;
                appos1 = appos2;
            }
        }
        for (m2 = 0; m2 < wordlines; ++m2) {
            for (i2 = 0; i2 < inputs; ++i2) {
                if (romplane[m2][i2] != 1) continue;
                ap1 = andtrans[m2 + 1][i2];
                apport1 = pmosd1port;
                apport2 = pmosd2port;
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                appos2 = ROMGenerator.getCStylePortPosition(ap1, apport2);
                NodeInst apx = minpins[m2][i2];
                NodeInst apy = minpins[m2][i2 + 1];
                PortProto apportx = mpacport;
                PortProto apporty = mpacport;
                double[] apposx = ROMGenerator.getCStylePortPosition(apx, apportx);
                double[] apposy = ROMGenerator.getCStylePortPosition(apy, apporty);
                this.makeCStyleArcInst(pdiffarc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], apx, apportx, apposx[0], apposx[1]);
                this.makeCStyleArcInst(pdiffarc, 4.0 * lambda, ap1, apport2, appos2[0], appos2[1], apy, apporty, apposy[0], apposy[1]);
            }
        }
        i2 = inputs;
        ap1 = minpins[0][i2];
        apport1 = minports[0][i2];
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        for (m2 = 1; m2 < wordlines; ++m2) {
            ap2 = minpins[m2][i2];
            apport2 = minports[m2][i2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            ap1 = ap2;
            apport1 = apport2;
            appos1 = appos2;
        }
        ap1 = vddpin;
        apport1 = vddport;
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        ap2 = minpins[wordlines - 1][inputs];
        apport2 = minports[wordlines - 1][inputs];
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        ap1 = vddcpin;
        apport1 = vddcport;
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        ap2 = vddpin;
        apport2 = vddport;
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        this.makeCStyleExport(decp, ap1, apport1, "vdd", PortCharacteristic.PWR);
        ap1 = vddbpin;
        apport1 = vddbport;
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        ap2 = minpins[0][inputs];
        apport2 = minports[0][inputs];
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        this.makeCStyleExport(decp, ap1, apport1, "vddb", PortCharacteristic.PWR);
        for (m2 = 0; m2 < wordlines; ++m2) {
            ap1 = m1m2pins[m2];
            apport1 = m1m2ports[m2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = m2pins[m2];
            apport2 = m2ports[m2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            NodeInst ap3 = minpins[m2][0];
            apport3 = minports[m2][0];
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            this.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap3, apport3, appos3[0], appos3[1]);
            this.makeCStyleExport(decp, ap2, apport2, "word" + m2, PortCharacteristic.OUT);
            this.makeCStyleExport(decp, ap1, apport1, "wordin" + m2, PortCharacteristic.IN);
        }
    }

    private static int[][] generatemuxarray(int folds, int romoutputs) {
        int muxes = romoutputs / folds;
        int[][] muxarray = new int[romoutputs][folds];
        for (int i2 = 0; i2 < muxes; ++i2) {
            for (int j2 = 0; j2 < folds; ++j2) {
                for (int k2 = 0; k2 < folds; ++k2) {
                    muxarray[i2 * folds + j2][k2] = j2 == k2 ? 1 : 0;
                }
            }
        }
        StringBuffer sb = new StringBuffer();
        for (int i3 = 0; i3 < romoutputs; ++i3) {
            sb = new StringBuffer();
            for (int j3 = 0; j3 < folds; ++j3) {
                sb.append(Integer.toString(muxarray[i3][j3]));
            }
        }
        return muxarray;
    }

    private void muxplane(Library destLib, double lambda, int folds, int romoutputs, String mp) {
        int j2;
        double[] appos3;
        PortProto apport3;
        double[] appos2;
        PortProto apport2;
        NodeInst ap2;
        double[] appos1;
        int m2;
        PortProto apport1;
        NodeInst ap1;
        int i2;
        int[][] muxarray = ROMGenerator.generatemuxarray(folds, romoutputs);
        int muxnumber = folds;
        int selects = folds;
        int outputbits = romoutputs;
        NodeInst[][] ntrans = new NodeInst[outputbits + 2][selects + 2];
        NodeInst[][] minpins = new NodeInst[outputbits + 2][selects + 2];
        NodeInst[] m1m2pins2 = new NodeInst[outputbits + 2];
        NodeInst[] m1m2pins = new NodeInst[selects + 2];
        NodeInst[] m1polypins = new NodeInst[outputbits + 2];
        PortProto[][] minports = new PortProto[outputbits + 2][selects + 2];
        PortProto[] m1m2ports2 = new PortProto[outputbits + 2];
        PrimitiveNode nmos = this.tech.findNodeProto("N-Transistor");
        PortProto nmosg1port = nmos.findPortProto("poly-right");
        PortProto nmosg2port = nmos.findPortProto("poly-left");
        PortProto nmosd1port = nmos.findPortProto("diff-top");
        PortProto nmosd2port = nmos.findPortProto("diff-bottom");
        double[] nmosbox = new double[]{-nmos.getDefWidth(this.ep) / 2.0 - lambda / 2.0, nmos.getDefWidth(this.ep) / 2.0 + lambda / 2.0, -nmos.getDefHeight(this.ep) / 2.0, nmos.getDefHeight(this.ep) / 2.0};
        PrimitiveNode ppin = this.tech.findNodeProto("Polysilicon-1-Pin");
        PortProto ppinport = ppin.getPort(0);
        double[] ppinbox = new double[]{-ppin.getDefWidth(this.ep) / 2.0, ppin.getDefWidth(this.ep) / 2.0, -ppin.getDefHeight(this.ep) / 2.0, ppin.getDefHeight(this.ep) / 2.0};
        PrimitiveNode m1pin = this.tech.findNodeProto("Metal-1-Pin");
        PortProto m1pinport = m1pin.getPort(0);
        double[] m1pinbox = new double[]{-m1pin.getDefWidth(this.ep) / 2.0 - lambda / 2.0, m1pin.getDefWidth(this.ep) / 2.0 + lambda / 2.0, -m1pin.getDefHeight(this.ep) / 2.0 - lambda / 2.0, m1pin.getDefHeight(this.ep) / 2.0 + lambda / 2.0};
        PrimitiveNode m1m2c = this.tech.findNodeProto("Metal-1-Metal-2-Con");
        PortProto m1m2cport = m1m2c.getPort(0);
        double[] m1m2cbox = new double[]{-5.0 * lambda / 2.0, 5.0 * lambda / 2.0, -5.0 * lambda / 2.0, 5.0 * lambda / 2.0};
        PrimitiveNode mnac = this.tech.findNodeProto("Metal-1-N-Active-Con");
        PortProto mnacport = mnac.getPort(0);
        double mult = 17.0;
        double[] mnacbox = new double[]{-1.0 * mult * lambda / 2.0, mult * lambda / 2.0, -1.0 * mult * lambda / 2.0, mult * lambda / 2.0};
        PrimitiveNode mpc = this.tech.findNodeProto("Metal-1-Polysilicon-1-Con");
        PortProto mpcport = mpc.getPort(0);
        double mx = 5.0;
        double[] mpcbox = new double[]{-mx * lambda / 2.0, mx * lambda / 2.0, -mx * lambda / 2.0, mx * lambda / 2.0};
        ArcProto parc = this.tech.findArcProto("Polysilicon-1");
        ArcProto m1arc = this.tech.findArcProto("Metal-1");
        ArcProto m2arc = this.tech.findArcProto("Metal-2");
        ArcProto ndiffarc = this.tech.findArcProto("N-Active");
        PrimitiveNode pwnode = this.tech.findNodeProto("P-Well-Node");
        Cell muxplane = Cell.newInst(destLib, mp + "{lay}");
        this.makeCStyleNodeInst(pwnode, -8.0 * lambda, lambda * 8.0 * (double)(folds + 1), -8.0 * lambda, 8.0 * lambda * 3.0 * (double)romoutputs / 2.0, 0, 0, muxplane);
        double x = 0.0;
        for (i2 = 0; i2 < selects + 1; ++i2) {
            x += 8.0 * lambda;
            double y = 0.0;
            if (i2 < selects) {
                ntrans[0][i2] = this.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2], ppinbox[3], 0, 0, muxplane);
                m1polypins[i2] = this.makeCStyleNodeInst(mpc, mpcbox[0] + x, mpcbox[1] + x, mpcbox[2], mpcbox[3], 0, 0, muxplane);
                m1m2pins[i2] = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x, m1m2cbox[1] + x, m1m2cbox[2], m1m2cbox[3], 0, 0, muxplane);
                ap1 = m1m2pins[i2];
                apport1 = m1m2cport;
                this.makeCStyleExport(muxplane, ap1, apport1, "sel" + (selects - i2 - 1), PortCharacteristic.IN);
            }
            for (m2 = 0; m2 < outputbits; ++m2) {
                y += 8.0 * lambda;
                if (m2 % 2 == 1) {
                    y += 8.0 * lambda;
                }
                if (i2 < selects) {
                    ntrans[m2 + 1][i2] = muxarray[m2][i2] == 1 ? this.makeCStyleNodeInst(nmos, nmosbox[0] + x, nmosbox[1] + x, nmosbox[2] + y, nmosbox[3] + y, 1, 0, muxplane) : this.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2] + y, ppinbox[3] + y, 0, 0, muxplane);
                }
                boolean transcont = false;
                if (i2 < selects) {
                    boolean bl = transcont = muxarray[m2][i2] == 1;
                }
                if (i2 == selects) {
                    m1m2pins2[m2] = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 4.0 * lambda, m1m2cbox[1] + x - 4.0 * lambda, m1m2cbox[2] + y, m1m2cbox[3] + y, 0, 0, muxplane);
                    m1m2ports2[m2] = m1m2cport;
                }
                if (i2 >= 1) {
                    transcont |= muxarray[m2][i2 - 1] == 1;
                }
                if (transcont) {
                    minpins[m2][i2] = this.makeCStyleNodeInst(mnac, mnacbox[0] + x - 4.0 * lambda, mnacbox[1] + x - 4.0 * lambda, mnacbox[2] + y, mnacbox[3] + y, 0, 0, muxplane);
                    minports[m2][i2] = mnacport;
                    continue;
                }
                minpins[m2][i2] = this.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 4.0 * lambda, m1pinbox[1] + x - 4.0 * lambda, m1pinbox[2] + y, m1pinbox[3] + y, 0, 0, muxplane);
                minports[m2][i2] = m1pinport;
            }
        }
        for (i2 = 0; i2 < selects; ++i2) {
            ap1 = ntrans[0][i2];
            apport1 = ppinport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = m1polypins[i2];
            apport2 = mpcport;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            NodeInst ap3 = m1m2pins[i2];
            apport3 = m1m2cport;
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            this.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap2, apport2, appos2[0], appos2[1], ap3, apport3, appos3[0], appos3[1]);
        }
        for (i2 = 0; i2 < selects; ++i2) {
            ap1 = ntrans[0][i2];
            apport1 = ppinport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (m2 = 1; m2 < outputbits + 1; ++m2) {
                ap2 = ntrans[m2][i2];
                if (muxarray[m2 - 1][i2] == 1) {
                    apport2 = nmosg1port;
                    apport3 = nmosg2port;
                } else {
                    apport2 = ppinport;
                    apport3 = ppinport;
                }
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                appos3 = ROMGenerator.getCStylePortPosition(ap2, apport3);
                this.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ap1 = ap2;
                apport1 = apport3;
                appos1 = appos3;
            }
        }
        for (m2 = 0; m2 < outputbits; ++m2) {
            ap1 = minpins[m2][0];
            apport1 = minports[m2][0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (i2 = 1; i2 < selects + 1; ++i2) {
                ap2 = minpins[m2][i2];
                apport2 = minports[m2][i2];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                if (muxarray[m2][i2 - 1] != 1) {
                    this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                }
                if (i2 == 1) {
                    this.makeCStyleExport(muxplane, ap1, apport1, "muxin" + m2, PortCharacteristic.IN);
                }
                ap1 = ap2;
                apport1 = apport2;
                appos1 = appos2;
            }
        }
        for (m2 = 0; m2 < outputbits; ++m2) {
            for (i2 = 0; i2 < selects; ++i2) {
                if (muxarray[m2][i2] != 1) continue;
                ap1 = ntrans[m2 + 1][i2];
                apport1 = nmosd1port;
                apport2 = nmosd2port;
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                appos2 = ROMGenerator.getCStylePortPosition(ap1, apport2);
                NodeInst apx = minpins[m2][i2];
                NodeInst apy = minpins[m2][i2 + 1];
                PortProto apportx = mnacport;
                PortProto apporty = mnacport;
                double[] apposx = ROMGenerator.getCStylePortPosition(apx, apportx);
                double[] apposy = ROMGenerator.getCStylePortPosition(apy, apporty);
                this.makeCStyleArcInst(ndiffarc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], apx, apportx, apposx[0], apposx[1]);
                this.makeCStyleArcInst(ndiffarc, 4.0 * lambda, ap1, apport2, appos2[0], appos2[1], apy, apporty, apposy[0], apposy[1]);
            }
        }
        for (j2 = 0; j2 < outputbits; ++j2) {
            i2 = selects;
            ap1 = minpins[j2][i2];
            apport1 = minports[j2][i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = m1m2pins2[j2];
            apport2 = m1m2ports2[j2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (j2 = 0; j2 < outputbits / muxnumber; ++j2) {
            ap1 = m1m2pins2[j2 * muxnumber];
            apport1 = m1m2ports2[j2 * muxnumber];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (m2 = 1 + j2 * muxnumber; m2 < muxnumber + j2 * muxnumber; ++m2) {
                ap2 = m1m2pins2[m2];
                apport2 = m1m2ports2[m2];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            this.makeCStyleExport(muxplane, ap1, apport1, "muxout" + j2, PortCharacteristic.OUT);
        }
    }

    private void inverterplane(Library destLib, double lambda, int outs, int folds, String ip) {
        double[] appos3;
        PortProto apport3;
        double[] appos2;
        PortProto apport2;
        double[] appos1;
        PortProto apport1;
        NodeInst ap1;
        NodeInst ap3;
        NodeInst ap2;
        int i2;
        NodeInst[] ntrans = new NodeInst[outs / folds];
        NodeInst[] ptrans = new NodeInst[outs / folds];
        NodeInst[] inpins = new NodeInst[outs / folds];
        NodeInst[] polypins = new NodeInst[outs / folds];
        NodeInst[] intppins = new NodeInst[outs / folds];
        NodeInst[] nmospins = new NodeInst[outs / folds];
        NodeInst[] pmospins = new NodeInst[outs / folds];
        NodeInst[] gndpins = new NodeInst[outs / 2];
        NodeInst[] vddpins = new NodeInst[outs / 2];
        NodeInst[] midvddpins = new NodeInst[outs / 2];
        NodeInst[] gndpins2 = new NodeInst[outs / folds];
        NodeInst[] pwellpins2 = new NodeInst[outs / folds];
        NodeInst[] vddpins2 = new NodeInst[outs / folds];
        NodeInst[] midvddpins2 = new NodeInst[outs / folds];
        NodeInst gndc = null;
        NodeInst nwellc = null;
        NodeInst nwellm = null;
        PortProto[] inports = new PortProto[outs / folds];
        PortProto[] polyports = new PortProto[outs / folds];
        PortProto[] intpports = new PortProto[outs / folds];
        PortProto[] nmosports = new PortProto[outs / folds];
        PortProto[] pmosports = new PortProto[outs / folds];
        PortProto[] gndports = new PortProto[outs / 2];
        PortProto[] vddports = new PortProto[outs / 2];
        PortProto[] midvddports = new PortProto[outs / 2];
        PortProto[] pwellports2 = new PortProto[outs / folds];
        PortProto[] gndports2 = new PortProto[outs / folds];
        PortProto[] vddports2 = new PortProto[outs / folds];
        PortProto[] midvddports2 = new PortProto[outs / folds];
        PortProto gndcport = null;
        PortProto nwellcport = null;
        PortProto nwellmport = null;
        PrimitiveNode nmos = this.tech.findNodeProto("N-Transistor");
        PortProto nmosg1port = nmos.findPortProto("poly-right");
        PortProto nmosg2port = nmos.findPortProto("poly-left");
        PortProto nmosd1port = nmos.findPortProto("diff-top");
        PortProto nmosd2port = nmos.findPortProto("diff-bottom");
        double[] nmosbox = new double[]{-nmos.getDefWidth(this.ep) / 2.0 - lambda / 2.0, nmos.getDefWidth(this.ep) / 2.0 + lambda / 2.0, -nmos.getDefHeight(this.ep) / 2.0, nmos.getDefHeight(this.ep) / 2.0};
        PrimitiveNode pmos = this.tech.findNodeProto("P-Transistor");
        PortProto pmosg2port = pmos.findPortProto("poly-left");
        PortProto pmosd1port = pmos.findPortProto("diff-top");
        PortProto pmosd2port = pmos.findPortProto("diff-bottom");
        double[] pmosbox = new double[]{-pmos.getDefWidth(this.ep) / 2.0 - lambda / 2.0, pmos.getDefWidth(this.ep) / 2.0 + lambda / 2.0, -pmos.getDefHeight(this.ep) / 2.0, pmos.getDefHeight(this.ep) / 2.0};
        PrimitiveNode ppin = this.tech.findNodeProto("Polysilicon-1-Pin");
        PortProto ppinport = ppin.getPort(0);
        double[] ppinbox = new double[]{-ppin.getDefWidth(this.ep) / 2.0, ppin.getDefWidth(this.ep) / 2.0, -ppin.getDefHeight(this.ep) / 2.0, ppin.getDefHeight(this.ep) / 2.0};
        PrimitiveNode nwnode = this.tech.findNodeProto("N-Well-Node");
        PrimitiveNode pwnode = this.tech.findNodeProto("P-Well-Node");
        PrimitiveNode m1m2c = this.tech.findNodeProto("Metal-1-Metal-2-Con");
        PortProto m1m2cport = m1m2c.getPort(0);
        double[] m1m2cbox = new double[]{-5.0 * lambda / 2.0, 5.0 * lambda / 2.0, -5.0 * lambda / 2.0, 5.0 * lambda / 2.0};
        PrimitiveNode mnac = this.tech.findNodeProto("Metal-1-N-Active-Con");
        PortProto mnacport = mnac.getPort(0);
        double aaa = 17.0;
        double[] mnacbox = new double[]{-aaa * lambda / 2.0, aaa * lambda / 2.0, -aaa * lambda / 2.0, aaa * lambda / 2.0};
        PrimitiveNode mpac = this.tech.findNodeProto("Metal-1-P-Active-Con");
        PortProto mpacport = mpac.getPort(0);
        double[] mpacbox = new double[]{-aaa * lambda / 2.0, aaa * lambda / 2.0, -aaa * lambda / 2.0, aaa * lambda / 2.0};
        PrimitiveNode mpc = this.tech.findNodeProto("Metal-1-Polysilicon-1-Con");
        PortProto mpcport = mpc.getPort(0);
        double mx = -7.0;
        double my = 5.0;
        double[] mpcbox = new double[]{-mx * lambda / 2.0, mx * lambda / 2.0, -my * lambda / 2.0, my * lambda / 2.0};
        PrimitiveNode mpwc = this.tech.findNodeProto("Metal-1-P-Well-Con");
        PortProto mpwcport = mpwc.getPort(0);
        double[] mpwcbox = new double[]{-17.0 * lambda / 2.0, 17.0 * lambda / 2.0, -17.0 * lambda / 2.0, 17.0 * lambda / 2.0};
        PrimitiveNode mnwc = this.tech.findNodeProto("Metal-1-N-Well-Con");
        PortProto mnwcport = mnwc.getPort(0);
        double[] mnwcbox = new double[]{-17.0 * lambda / 2.0, 17.0 * lambda / 2.0, -17.0 * lambda / 2.0, 17.0 * lambda / 2.0};
        ArcProto parc = this.tech.findArcProto("Polysilicon-1");
        ArcProto m1arc = this.tech.findArcProto("Metal-1");
        ArcProto m2arc = this.tech.findArcProto("Metal-2");
        ArcProto ndiffarc = this.tech.findArcProto("N-Active");
        ArcProto pdiffarc = this.tech.findArcProto("P-Active");
        Cell invp = Cell.newInst(destLib, ip + "{lay}");
        this.makeCStyleNodeInst(pwnode, -32.0 * lambda, 3.0 * lambda * 8.0 * (double)outs / 2.0 + 8.0 * lambda, -18.0 * lambda, 16.0 * lambda, 0, 0, invp);
        this.makeCStyleNodeInst(nwnode, -32.0 * lambda, 3.0 * lambda * 8.0 * (double)outs / 2.0 + 8.0 * lambda, -34.0 * lambda, -18.0 * lambda, 0, 0, invp);
        double x = 0.0 * lambda;
        for (i2 = 0; i2 < outs; ++i2) {
            double off;
            x += 8.0 * lambda;
            double y = 0.0;
            if (folds > 1) {
                if (i2 % folds == 1) {
                    pwellpins2[i2 / folds] = this.makeCStyleNodeInst(mpwc, mpwcbox[0] + x, mpwcbox[1] + x, mpwcbox[2] + y, mpwcbox[3] + y, 0, 0, invp);
                    pwellports2[i2 / folds] = mpwcport;
                    gndpins2[i2 / folds] = this.makeCStyleNodeInst(mnac, mnacbox[0] + x, mnacbox[1] + x, mnacbox[2] + y - 10.0 * lambda, mnacbox[3] + y - 10.0 * lambda, 0, 0, invp);
                    gndports2[i2 / folds] = mnacport;
                    midvddpins2[i2 / folds] = this.makeCStyleNodeInst(mpac, mpacbox[0] + x, mpacbox[1] + x, mpacbox[2] + y - 26.0 * lambda, mpacbox[3] + y - 26.0 * lambda, 0, 0, invp);
                    midvddports2[i2 / folds] = mpacport;
                    vddpins2[i2 / folds] = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x, m1m2cbox[1] + x, m1m2cbox[2] + y - 26.0 * lambda, m1m2cbox[3] + y - 26.0 * lambda, 0, 0, invp);
                    vddports2[i2 / folds] = m1m2cport;
                    if (i2 == 1) {
                        gndc = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x, m1m2cbox[1] + x, m1m2cbox[2] + y - 10.0 * lambda, m1m2cbox[3] + y - 10.0 * lambda, 0, 0, invp);
                        gndcport = m1m2cport;
                        this.makeCStyleExport(invp, gndc, gndcport, "gnd", PortCharacteristic.GND);
                    }
                }
            } else if (i2 % 2 == 1) {
                gndpins[i2 / 2] = this.makeCStyleNodeInst(mnac, mnacbox[0] + x, mnacbox[1] + x, mnacbox[2] + y - 10.0 * lambda, mnacbox[3] + y - 10.0 * lambda, 0, 0, invp);
                gndports[i2 / 2] = mnacport;
                midvddpins[i2 / 2] = this.makeCStyleNodeInst(mpac, mpacbox[0] + x, mpacbox[1] + x, mpacbox[2] + y - 26.0 * lambda, mpacbox[3] + y - 26.0 * lambda, 0, 0, invp);
                midvddports[i2 / 2] = mpacport;
                vddpins[i2 / 2] = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x, m1m2cbox[1] + x, m1m2cbox[2] + y - 26.0 * lambda, m1m2cbox[3] + y - 26.0 * lambda, 0, 0, invp);
                vddports[i2 / 2] = m1m2cport;
                if (i2 == 1) {
                    nwellc = this.makeCStyleNodeInst(mnwc, mnwcbox[0] + x - 24.0 * lambda, mnwcbox[1] + x - 24.0 * lambda, mnwcbox[2] + y - 26.0 * lambda, mnwcbox[3] + y - 26.0 * lambda, 0, 0, invp);
                    nwellcport = mnwcport;
                    nwellm = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 24.0 * lambda, m1m2cbox[1] + x - 24.0 * lambda, m1m2cbox[2] + y - 26.0 * lambda, m1m2cbox[3] + y - 26.0 * lambda, 0, 0, invp);
                    nwellmport = m1m2cport;
                    gndc = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x, m1m2cbox[1] + x, m1m2cbox[2] + y - 10.0 * lambda, m1m2cbox[3] + y - 10.0 * lambda, 0, 0, invp);
                    gndcport = m1m2cport;
                    this.makeCStyleExport(invp, gndc, gndcport, "gnd", PortCharacteristic.GND);
                }
            }
            if (i2 % 2 == 1) {
                x += 8.0 * lambda;
            }
            if (folds > 1) {
                if (i2 % folds == 0) {
                    inpins[i2 / folds] = this.makeCStyleNodeInst(mpc, mpcbox[0] + x - 6.0 * lambda, mpacbox[1] + x - 6.0 * lambda, mpcbox[2] + y, mpcbox[3] + y, 0, 0, invp);
                    inports[i2 / folds] = mpcport;
                    polypins[i2 / folds] = this.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2] + y - 6.0 * lambda, ppinbox[3] + y - 6.0 * lambda, 0, 0, invp);
                    polyports[i2 / folds] = ppinport;
                    nmospins[i2 / folds] = this.makeCStyleNodeInst(mnac, mnacbox[0] + x, mnacbox[1] + x, mnacbox[2] + y - 10.0 * lambda, mnacbox[3] + y - 10.0 * lambda, 0, 0, invp);
                    nmosports[i2 / folds] = mnacport;
                    pmospins[i2 / folds] = this.makeCStyleNodeInst(mpac, mpacbox[0] + x, mpacbox[1] + x, mpacbox[2] + y - 26.0 * lambda, mpacbox[3] + y - 26.0 * lambda, 0, 0, invp);
                    pmosports[i2 / folds] = mpacport;
                }
            } else {
                inpins[i2] = this.makeCStyleNodeInst(mpc, mpcbox[0] + x - 6.0 * lambda, mpacbox[1] + x - 6.0 * lambda, mpcbox[2] + y, mpcbox[3] + y, 0, 0, invp);
                inports[i2] = mpcport;
                polypins[i2] = this.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2] + y - 6.0 * lambda, ppinbox[3] + y - 6.0 * lambda, 0, 0, invp);
                polyports[i2] = ppinport;
                nmospins[i2] = this.makeCStyleNodeInst(mnac, mnacbox[0] + x, mnacbox[1] + x, mnacbox[2] + y - 10.0 * lambda, mnacbox[3] + y - 10.0 * lambda, 0, 0, invp);
                nmosports[i2] = mnacport;
                pmospins[i2] = this.makeCStyleNodeInst(mpac, mpacbox[0] + x, mpacbox[1] + x, mpacbox[2] + y - 26.0 * lambda, mpacbox[3] + y - 26.0 * lambda, 0, 0, invp);
                pmosports[i2] = mpacport;
            }
            if (folds > 1) {
                if (i2 % folds != 0) continue;
                off = 4.0 * lambda;
                ptrans[i2 / folds] = this.makeCStyleNodeInst(pmos, pmosbox[0] + x + off, pmosbox[1] + x + off, pmosbox[2] + y - 26.0 * lambda, pmosbox[3] + y - 26.0 * lambda, 1, 0, invp);
                ntrans[i2 / folds] = this.makeCStyleNodeInst(nmos, nmosbox[0] + x + off, nmosbox[1] + x + off, nmosbox[2] + y - 10.0 * lambda, nmosbox[3] + y - 10.0 * lambda, 1, 0, invp);
                intppins[i2 / folds] = this.makeCStyleNodeInst(ppin, ppinbox[0] + x + off, ppinbox[1] + x + off, ppinbox[2] + y - 6.0 * lambda, ppinbox[3] + y - 6.0 * lambda, 0, 0, invp);
                intpports[i2 / folds] = ppinport;
                continue;
            }
            off = 0.0;
            off = i2 % 2 == 0 ? 4.0 * lambda : -4.0 * lambda;
            ptrans[i2] = this.makeCStyleNodeInst(pmos, pmosbox[0] + x + off, pmosbox[1] + x + off, pmosbox[2] + y - 26.0 * lambda, pmosbox[3] + y - 26.0 * lambda, 1, 0, invp);
            ntrans[i2] = this.makeCStyleNodeInst(nmos, nmosbox[0] + x + off, nmosbox[1] + x + off, nmosbox[2] + y - 10.0 * lambda, nmosbox[3] + y - 10.0 * lambda, 1, 0, invp);
            intppins[i2] = this.makeCStyleNodeInst(ppin, ppinbox[0] + x + off, ppinbox[1] + x + off, ppinbox[2] + y - 6.0 * lambda, ppinbox[3] + y - 6.0 * lambda, 0, 0, invp);
            intpports[i2] = ppinport;
        }
        if (folds > 1) {
            for (i2 = 0; i2 < outs / folds; ++i2) {
                ap2 = nmospins[i2];
                ap3 = gndpins2[i2];
                ap1 = ntrans[i2];
                apport1 = nmosd1port;
                gndport1 = nmosd2port;
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                gndpos1 = ROMGenerator.getCStylePortPosition(ap1, gndport1);
                apport2 = mnacport;
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                apport3 = mnacport;
                appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
                this.makeCStyleArcInst(ndiffarc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                this.makeCStyleArcInst(ndiffarc, 4.0 * lambda, ap1, gndport1, gndpos1[0], gndpos1[1], ap3, apport3, appos3[0], appos3[1]);
            }
        } else {
            for (i2 = 0; i2 < outs; ++i2) {
                if (i2 % 2 == 0) {
                    ap2 = nmospins[i2];
                    ap3 = gndpins[i2 / 2];
                } else {
                    ap2 = gndpins[i2 / 2];
                    ap3 = nmospins[i2];
                }
                ap1 = ntrans[i2];
                apport1 = nmosd1port;
                gndport1 = nmosd2port;
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                gndpos1 = ROMGenerator.getCStylePortPosition(ap1, gndport1);
                apport2 = mnacport;
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                apport3 = mnacport;
                appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
                this.makeCStyleArcInst(ndiffarc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                this.makeCStyleArcInst(ndiffarc, 4.0 * lambda, ap1, gndport1, gndpos1[0], gndpos1[1], ap3, apport3, appos3[0], appos3[1]);
            }
        }
        if (folds > 1) {
            for (i2 = 0; i2 < outs / folds; ++i2) {
                ap2 = pmospins[i2];
                ap3 = midvddpins2[i2];
                ap1 = ptrans[i2];
                ap1 = ptrans[i2];
                apport1 = pmosd1port;
                vddport1 = pmosd2port;
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                vddpos1 = ROMGenerator.getCStylePortPosition(ap1, vddport1);
                apport2 = mpacport;
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                apport3 = mpacport;
                appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
                this.makeCStyleArcInst(pdiffarc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                this.makeCStyleArcInst(pdiffarc, 4.0 * lambda, ap1, vddport1, vddpos1[0], vddpos1[1], ap3, apport3, appos3[0], appos3[1]);
            }
        } else {
            for (i2 = 0; i2 < outs; ++i2) {
                if (i2 % 2 == 0) {
                    ap2 = pmospins[i2];
                    ap3 = midvddpins[i2 / 2];
                } else {
                    ap2 = midvddpins[i2 / 2];
                    ap3 = pmospins[i2];
                }
                ap1 = ptrans[i2];
                apport1 = pmosd1port;
                vddport1 = pmosd2port;
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                vddpos1 = ROMGenerator.getCStylePortPosition(ap1, vddport1);
                apport2 = mpacport;
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                apport3 = mpacport;
                appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
                this.makeCStyleArcInst(pdiffarc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                this.makeCStyleArcInst(pdiffarc, 4.0 * lambda, ap1, vddport1, vddpos1[0], vddpos1[1], ap3, apport3, appos3[0], appos3[1]);
            }
        }
        for (i2 = 0; i2 < outs / folds; ++i2) {
            ap1 = nmospins[i2];
            apport1 = nmosports[i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = pmospins[i2];
            apport2 = pmosports[i2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i2 = 0; i2 < outs / folds; ++i2) {
            ap1 = inpins[i2];
            apport1 = inports[i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = polypins[i2];
            apport2 = polyports[i2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i2 = 0; i2 < outs / folds; ++i2) {
            ap1 = polypins[i2];
            apport1 = polyports[i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = intppins[i2];
            apport2 = intpports[i2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i2 = 0; i2 < outs / folds; ++i2) {
            ap1 = intppins[i2];
            apport1 = intpports[i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = ntrans[i2];
            apport2 = nmosg2port;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i2 = 0; i2 < outs / folds; ++i2) {
            ap1 = ntrans[i2];
            apport1 = nmosg1port;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = ptrans[i2];
            apport2 = pmosg2port;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        if (folds > 1) {
            for (i2 = 0; i2 < outs / folds; ++i2) {
                ap1 = pwellpins2[i2];
                apport1 = pwellports2[i2];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = gndpins2[i2];
                apport2 = gndports2[i2];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            for (i2 = 0; i2 < outs / folds; ++i2) {
                ap1 = midvddpins2[i2];
                apport1 = midvddports2[i2];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = vddpins2[i2];
                apport2 = vddports2[i2];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            ap1 = vddpins2[0];
            apport1 = vddports2[0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (i2 = 1; i2 < outs / folds; ++i2) {
                ap2 = vddpins2[i2];
                apport2 = vddports2[i2];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            this.makeCStyleExport(invp, ap1, apport1, "vdd", PortCharacteristic.PWR);
            for (i2 = 0; i2 < outs / folds; ++i2) {
                ap1 = gndpins2[i2];
                apport1 = gndports2[i2];
                this.makeCStyleExport(invp, ap1, apport1, "invgnd" + i2, PortCharacteristic.GND);
            }
            ap1 = gndpins2[0];
            apport1 = gndports2[0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        } else {
            for (i2 = 0; i2 < outs / 2; ++i2) {
                ap1 = midvddpins[i2];
                apport1 = midvddports[i2];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = vddpins[i2];
                apport2 = vddports[i2];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            ap1 = vddpins[0];
            apport1 = vddports[0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = nwellm;
            apport2 = nwellmport;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ap3 = nwellc;
            apport3 = nwellcport;
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            this.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap3, apport3, appos3[0], appos3[1], ap2, apport2, appos2[0], appos2[1]);
            ap1 = vddpins[0];
            apport1 = vddports[0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (i2 = 1; i2 < outs / 2; ++i2) {
                ap2 = vddpins[i2];
                apport2 = vddports[i2];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            this.makeCStyleExport(invp, ap1, apport1, "vdd", PortCharacteristic.PWR);
            for (i2 = 0; i2 < outs / 2; ++i2) {
                ap1 = gndpins[i2];
                apport1 = gndports[i2];
                this.makeCStyleExport(invp, ap1, apport1, "invgnd" + i2, PortCharacteristic.GND);
            }
            ap1 = gndpins[0];
            apport1 = gndports[0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        }
        ap2 = gndc;
        apport2 = gndcport;
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        for (i2 = 0; i2 < outs / folds; ++i2) {
            ap1 = inpins[i2];
            apport1 = inports[i2];
            this.makeCStyleExport(invp, ap1, apport1, "invin" + i2, PortCharacteristic.IN);
        }
        for (i2 = 0; i2 < outs / folds; ++i2) {
            ap1 = pmospins[i2];
            apport1 = pmosports[i2];
            this.makeCStyleExport(invp, ap1, apport1, "invout" + (outs / folds - 1 - i2), PortCharacteristic.OUT);
        }
    }

    private void ininverterplane(Library destLib, double lambda, int outs, String layoutname, boolean top, int lengthbits) {
        double[] appos3;
        PortProto apport3;
        double[] appos2;
        PortProto apport2;
        double[] appos1;
        PortProto apport1;
        NodeInst ap1;
        NodeInst ap3;
        NodeInst ap2;
        int i2;
        NodeInst[] ntrans = new NodeInst[outs];
        NodeInst[] ptrans = new NodeInst[outs];
        NodeInst[] inpins = new NodeInst[outs];
        NodeInst[] inpins2 = new NodeInst[outs];
        NodeInst[] outpins = new NodeInst[outs];
        NodeInst[] outpins2 = new NodeInst[outs];
        NodeInst[] polypins = new NodeInst[outs];
        NodeInst[] intppins = new NodeInst[outs];
        NodeInst[] polypins2 = new NodeInst[outs];
        NodeInst[] intppins2 = new NodeInst[outs];
        NodeInst[] gndpins = new NodeInst[outs];
        NodeInst[] midvddpins = new NodeInst[outs];
        NodeInst[] nmospins = new NodeInst[outs];
        NodeInst[] gndpins2 = new NodeInst[outs];
        NodeInst[] vddpins = new NodeInst[outs];
        NodeInst[] pmospins = new NodeInst[outs];
        NodeInst vddc = null;
        NodeInst nwellc = null;
        NodeInst gndc = null;
        NodeInst pwellc = null;
        PortProto[] inports = new PortProto[outs];
        PortProto[] outports = new PortProto[outs];
        PortProto[] inports2 = new PortProto[outs];
        PortProto[] outports2 = new PortProto[outs];
        PortProto[] polyports = new PortProto[outs];
        PortProto[] intpports = new PortProto[outs];
        PortProto[] polyports2 = new PortProto[outs];
        PortProto[] intpports2 = new PortProto[outs];
        PortProto[] nmosports = new PortProto[outs];
        PortProto[] pmosports = new PortProto[outs];
        PortProto[] gndports = new PortProto[outs];
        PortProto[] gndports2 = new PortProto[outs];
        PortProto[] vddports = new PortProto[outs];
        PortProto[] midvddports = new PortProto[outs];
        PortProto vddcport = null;
        PortProto nwellport = null;
        PortProto gndcport = null;
        PortProto pwellport = null;
        PrimitiveNode nmos = this.tech.findNodeProto("N-Transistor");
        PortProto nmosg1port = nmos.findPortProto("poly-right");
        PortProto nmosg2port = nmos.findPortProto("poly-left");
        PortProto nmosd1port = nmos.findPortProto("diff-top");
        PortProto nmosd2port = nmos.findPortProto("diff-bottom");
        double[] nmosbox = new double[]{-nmos.getDefWidth(this.ep) / 2.0 - lambda / 2.0, nmos.getDefWidth(this.ep) / 2.0 + lambda / 2.0, -nmos.getDefHeight(this.ep) / 2.0, nmos.getDefHeight(this.ep) / 2.0};
        PrimitiveNode pmos = this.tech.findNodeProto("P-Transistor");
        PortProto pmosg1port = pmos.findPortProto("poly-right");
        PortProto pmosg2port = pmos.findPortProto("poly-left");
        PortProto pmosd1port = pmos.findPortProto("diff-top");
        PortProto pmosd2port = pmos.findPortProto("diff-bottom");
        double[] pmosbox = new double[]{-pmos.getDefWidth(this.ep) / 2.0 - lambda / 2.0, pmos.getDefWidth(this.ep) / 2.0 + lambda / 2.0, -pmos.getDefHeight(this.ep) / 2.0, pmos.getDefHeight(this.ep) / 2.0};
        PrimitiveNode ppin = this.tech.findNodeProto("Polysilicon-1-Pin");
        PortProto ppinport = ppin.getPort(0);
        double[] ppinbox = new double[]{-ppin.getDefWidth(this.ep) / 2.0, ppin.getDefWidth(this.ep) / 2.0, -ppin.getDefHeight(this.ep) / 2.0, ppin.getDefHeight(this.ep) / 2.0};
        PrimitiveNode m1pin = this.tech.findNodeProto("Metal-1-Pin");
        PrimitiveNode m2pin = this.tech.findNodeProto("Metal-2-Pin");
        PortProto m2pinport = m2pin.getPort(0);
        double[] m2pinbox = new double[]{-m1pin.getDefWidth(this.ep) / 2.0 - lambda / 2.0, m1pin.getDefWidth(this.ep) / 2.0 + lambda / 2.0, -m1pin.getDefHeight(this.ep) / 2.0 - lambda / 2.0, m1pin.getDefHeight(this.ep) / 2.0 + lambda / 2.0};
        PrimitiveNode nwnode = this.tech.findNodeProto("N-Well-Node");
        PrimitiveNode pwnode = this.tech.findNodeProto("P-Well-Node");
        PrimitiveNode m1m2c = this.tech.findNodeProto("Metal-1-Metal-2-Con");
        PortProto m1m2cport = m1m2c.getPort(0);
        double[] m1m2cbox = new double[]{-5.0 * lambda / 2.0, 5.0 * lambda / 2.0, -5.0 * lambda / 2.0, 5.0 * lambda / 2.0};
        PrimitiveNode mnac = this.tech.findNodeProto("Metal-1-N-Active-Con");
        PortProto mnacport = mnac.getPort(0);
        double aaa = 17.0;
        double[] mnacbox = new double[]{-aaa * lambda / 2.0, aaa * lambda / 2.0, -aaa * lambda / 2.0, aaa * lambda / 2.0};
        PrimitiveNode mpac = this.tech.findNodeProto("Metal-1-P-Active-Con");
        PortProto mpacport = mpac.getPort(0);
        double[] mpacbox = new double[]{-aaa * lambda / 2.0, aaa * lambda / 2.0, -aaa * lambda / 2.0, aaa * lambda / 2.0};
        double mx = -7.0;
        double my = 5.0;
        PrimitiveNode mpc = this.tech.findNodeProto("Metal-1-Polysilicon-1-Con");
        PortProto mpcport = mpc.getPort(0);
        double[] mpcbox = new double[]{-mx * lambda / 2.0, mx * lambda / 2.0, -my * lambda / 2.0, my * lambda / 2.0};
        PrimitiveNode mpwc = this.tech.findNodeProto("Metal-1-P-Well-Con");
        PortProto mpwcport = mpwc.getPort(0);
        double[] mpwcbox = new double[]{-17.0 * lambda / 2.0, 17.0 * lambda / 2.0, -17.0 * lambda / 2.0, 17.0 * lambda / 2.0};
        PrimitiveNode mnwc = this.tech.findNodeProto("Metal-1-N-Well-Con");
        PortProto mnwcport = mnwc.getPort(0);
        double[] mnwcbox = new double[]{-17.0 * lambda / 2.0, 17.0 * lambda / 2.0, -17.0 * lambda / 2.0, 17.0 * lambda / 2.0};
        ArcProto parc = this.tech.findArcProto("Polysilicon-1");
        ArcProto m1arc = this.tech.findArcProto("Metal-1");
        ArcProto m2arc = this.tech.findArcProto("Metal-2");
        ArcProto ndiffarc = this.tech.findArcProto("N-Active");
        ArcProto pdiffarc = this.tech.findArcProto("P-Active");
        Cell ininvp = Cell.newInst(destLib, layoutname + "{lay}");
        double lowX = -8.0 * lambda;
        double highX = 4.0 * lambda * 8.0 * (double)lengthbits + 24.0 * lambda;
        this.makeCStyleNodeInst(pwnode, lowX += 7.0 * lambda, highX -= 64.0 * lambda, -18.0 * lambda, 10.0 * lambda, 0, 0, ininvp);
        this.makeCStyleNodeInst(nwnode, lowX, highX, -36.0 * lambda, -18.0 * lambda, 0, 0, ininvp);
        double x = 0.0;
        for (i2 = 0; i2 < outs; ++i2) {
            double y = 0.0;
            gndpins[i2] = this.makeCStyleNodeInst(mnac, mnacbox[0] + (x += 8.0 * lambda), mnacbox[1] + x, mnacbox[2] + y - 10.0 * lambda, mnacbox[3] + y - 10.0 * lambda, 0, 0, ininvp);
            gndports[i2] = mnacport;
            midvddpins[i2] = this.makeCStyleNodeInst(mpac, mpacbox[0] + x, mpacbox[1] + x, mpacbox[2] + y - 26.0 * lambda, mpacbox[3] + y - 26.0 * lambda, 0, 0, ininvp);
            midvddports[i2] = mpacport;
            double off = 4.0 * lambda;
            ptrans[i2] = this.makeCStyleNodeInst(pmos, pmosbox[0] + x + off, pmosbox[1] + x + off, pmosbox[2] + y - 26.0 * lambda, pmosbox[3] + y - 26.0 * lambda, 1, 0, ininvp);
            ntrans[i2] = this.makeCStyleNodeInst(nmos, nmosbox[0] + x + off, nmosbox[1] + x + off, nmosbox[2] + y - 10.0 * lambda, nmosbox[3] + y - 10.0 * lambda, 1, 0, ininvp);
            polypins[i2] = this.makeCStyleNodeInst(ppin, ppinbox[0] + (x += 8.0 * lambda) - 8.0 * lambda, ppinbox[1] + x - 8.0 * lambda, ppinbox[2] + y - 6.0 * lambda, ppinbox[3] + y - 6.0 * lambda, 0, 0, ininvp);
            polyports[i2] = ppinport;
            inpins[i2] = this.makeCStyleNodeInst(mpc, mpcbox[0] + x - 14.0 * lambda, mpacbox[1] + x - 14.0 * lambda, mpcbox[2] + y, mpcbox[3] + y, 0, 0, ininvp);
            inports[i2] = mpcport;
            if (top) {
                inpins2[i2] = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 8.0 * lambda, m1m2cbox[1] + x - 8.0 * lambda, m1m2cbox[2] + y + 8.0 * lambda * (double)(i2 + 1), m1m2cbox[3] + y + 8.0 * lambda * (double)(i2 + 1), 0, 0, ininvp);
                inports2[i2] = m1m2cport;
            }
            intppins[i2] = this.makeCStyleNodeInst(ppin, ppinbox[0] + x - off, ppinbox[1] + x - off, ppinbox[2] + y - 6.0 * lambda, ppinbox[3] + y - 6.0 * lambda, 0, 0, ininvp);
            intpports[i2] = ppinport;
            pmospins[i2] = this.makeCStyleNodeInst(mpac, mpacbox[0] + x, mpacbox[1] + x, mpacbox[2] + y - 26.0 * lambda, mpacbox[3] + y - 26.0 * lambda, 0, 0, ininvp);
            pmosports[i2] = mpacport;
            vddpins[i2] = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 8.0 * lambda, m1m2cbox[1] + x - 8.0 * lambda, m1m2cbox[2] + y - 26.0 * lambda, m1m2cbox[3] + y - 26.0 * lambda, 0, 0, ininvp);
            vddports[i2] = m1m2cport;
            nmospins[i2] = this.makeCStyleNodeInst(mnac, mnacbox[0] + x, mnacbox[1] + x, mnacbox[2] + y - 10.0 * lambda, mnacbox[3] + y - 10.0 * lambda, 0, 0, ininvp);
            nmosports[i2] = mnacport;
            gndpins2[i2] = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 8.0 * lambda, m1m2cbox[1] + x - 8.0 * lambda, m1m2cbox[2] + y - 10.0 * lambda, m1m2cbox[3] + y - 10.0 * lambda, 0, 0, ininvp);
            gndports2[i2] = m1m2cport;
            outpins[i2] = this.makeCStyleNodeInst(mpc, mpcbox[0] + x - 14.0 * lambda, mpacbox[1] + x - 14.0 * lambda, mpcbox[2] + y - 36.0 * lambda, mpcbox[3] + y - 36.0 * lambda, 0, 0, ininvp);
            outports[i2] = mpcport;
            if (!top) {
                outpins2[i2] = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 8.0 * lambda, m1m2cbox[1] + x - 8.0 * lambda, m1m2cbox[2] + y - 8.0 * lambda * (double)(i2 + 1) - 36.0 * lambda, m1m2cbox[3] + y - 8.0 * lambda * (double)(i2 + 1) - 36.0 * lambda, 0, 0, ininvp);
                outports2[i2] = m1m2cport;
            }
            polypins2[i2] = this.makeCStyleNodeInst(ppin, ppinbox[0] + x - 8.0 * lambda, ppinbox[1] + x - 8.0 * lambda, ppinbox[2] + y - 30.0 * lambda, ppinbox[3] + y - 30.0 * lambda, 0, 0, ininvp);
            polyports2[i2] = ppinport;
            intppins2[i2] = this.makeCStyleNodeInst(ppin, ppinbox[0] + x - off, ppinbox[1] + x - off, ppinbox[2] + y - 30.0 * lambda, ppinbox[3] + y - 30.0 * lambda, 0, 0, ininvp);
            intpports2[i2] = ppinport;
            if (i2 != outs - 1) continue;
            if (top) {
                vddc = this.makeCStyleNodeInst(m2pin, m2pinbox[0] + x + 12.0 * lambda, m2pinbox[1] + x + 12.0 * lambda, m2pinbox[2] + y - 26.0 * lambda, m2pinbox[3] + y - 26.0 * lambda, 0, 0, ininvp);
                vddcport = m2pinport;
                gndc = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x + 12.0 * lambda, m1m2cbox[1] + x + 12.0 * lambda, m1m2cbox[2] + y - 10.0 * lambda, m1m2cbox[3] + y - 10.0 * lambda, 0, 0, ininvp);
                gndcport = m1m2cport;
                pwellc = this.makeCStyleNodeInst(mpwc, mpwcbox[0] + x + 12.0 * lambda, mpwcbox[1] + x + 12.0 * lambda, mpwcbox[2] + y - 10.0 * lambda, mpwcbox[3] + y - 10.0 * lambda, 0, 0, ininvp);
                pwellport = mpwcport;
                continue;
            }
            vddc = this.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x + 12.0 * lambda, m1m2cbox[1] + x + 12.0 * lambda, m1m2cbox[2] + y - 26.0 * lambda, m1m2cbox[3] + y - 26.0 * lambda, 0, 0, ininvp);
            vddcport = m1m2cport;
            nwellc = this.makeCStyleNodeInst(mnwc, mnwcbox[0] + x + 12.0 * lambda, mnwcbox[1] + x + 12.0 * lambda, mnwcbox[2] + y - 26.0 * lambda, mnwcbox[3] + y - 26.0 * lambda, 0, 0, ininvp);
            nwellport = mnwcport;
            gndc = this.makeCStyleNodeInst(m2pin, m2pinbox[0] + x + 12.0 * lambda, m2pinbox[1] + x + 12.0 * lambda, m2pinbox[2] + y - 10.0 * lambda, m2pinbox[3] + y - 10.0 * lambda, 0, 0, ininvp);
            gndcport = m2pinport;
        }
        for (i2 = 0; i2 < outs; ++i2) {
            ap2 = gndpins[i2];
            ap3 = nmospins[i2];
            ap1 = ntrans[i2];
            apport1 = nmosd1port;
            PortProto gndport1 = nmosd2port;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            double[] gndpos1 = ROMGenerator.getCStylePortPosition(ap1, gndport1);
            apport2 = mnacport;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            apport3 = mnacport;
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            this.makeCStyleArcInst(ndiffarc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            this.makeCStyleArcInst(ndiffarc, 4.0 * lambda, ap1, gndport1, gndpos1[0], gndpos1[1], ap3, apport3, appos3[0], appos3[1]);
        }
        for (i2 = 0; i2 < outs; ++i2) {
            ap2 = midvddpins[i2];
            ap3 = pmospins[i2];
            ap1 = ptrans[i2];
            apport1 = pmosd1port;
            PortProto vddport1 = pmosd2port;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            double[] vddpos1 = ROMGenerator.getCStylePortPosition(ap1, vddport1);
            apport2 = mpacport;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            apport3 = mpacport;
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            this.makeCStyleArcInst(pdiffarc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            this.makeCStyleArcInst(pdiffarc, 4.0 * lambda, ap1, vddport1, vddpos1[0], vddpos1[1], ap3, apport3, appos3[0], appos3[1]);
        }
        for (i2 = 0; i2 < outs; ++i2) {
            ap1 = nmospins[i2];
            apport1 = nmosports[i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = pmospins[i2];
            apport2 = pmosports[i2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        if (top) {
            ap1 = gndc;
            apport1 = gndcport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = pwellc;
            apport2 = pwellport;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        } else {
            ap1 = vddc;
            apport1 = vddcport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = nwellc;
            apport2 = nwellport;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        if (top) {
            for (i2 = 0; i2 < outs; ++i2) {
                ap1 = inpins[i2];
                apport1 = inports[i2];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = inpins2[i2];
                apport2 = inports2[i2];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
        } else {
            for (i2 = 0; i2 < outs; ++i2) {
                ap1 = outpins[i2];
                apport1 = outports[i2];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = outpins2[i2];
                apport2 = outports2[i2];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
        }
        for (i2 = 0; i2 < outs; ++i2) {
            ap1 = inpins[i2];
            apport1 = inports[i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = polypins[i2];
            apport2 = polyports[i2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i2 = 0; i2 < outs; ++i2) {
            ap1 = polypins[i2];
            apport1 = polyports[i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = intppins[i2];
            apport2 = intpports[i2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i2 = 0; i2 < outs; ++i2) {
            ap1 = intppins[i2];
            apport1 = intpports[i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = ntrans[i2];
            apport2 = nmosg2port;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i2 = 0; i2 < outs; ++i2) {
            ap1 = ntrans[i2];
            apport1 = nmosg1port;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = ptrans[i2];
            apport2 = pmosg2port;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i2 = 0; i2 < outs; ++i2) {
            ap1 = outpins[i2];
            apport1 = outports[i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = polypins2[i2];
            apport2 = polyports2[i2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i2 = 0; i2 < outs; ++i2) {
            ap1 = polypins2[i2];
            apport1 = polyports2[i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = intppins2[i2];
            apport2 = intpports2[i2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i2 = 0; i2 < outs; ++i2) {
            ap1 = intppins2[i2];
            apport1 = intpports2[i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = ptrans[i2];
            apport2 = pmosg1port;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i2 = 0; i2 < outs; ++i2) {
            ap1 = midvddpins[i2];
            apport1 = midvddports[i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = vddpins[i2];
            apport2 = vddports[i2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i2 = 0; i2 < outs; ++i2) {
            ap1 = gndpins[i2];
            apport1 = gndports[i2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = gndpins2[i2];
            apport2 = gndports2[i2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        ap1 = gndpins2[0];
        apport1 = gndports2[0];
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        for (i2 = 1; i2 < outs; ++i2) {
            ap2 = gndpins2[i2];
            apport2 = gndports2[i2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        ap1 = vddpins[0];
        apport1 = vddports[0];
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        for (i2 = 1; i2 < outs; ++i2) {
            ap2 = vddpins[i2];
            apport2 = vddports[i2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            this.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        ap1 = vddpins[0];
        apport1 = vddports[0];
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        ap2 = vddc;
        apport2 = vddcport;
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        this.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        this.makeCStyleExport(ininvp, ap2, apport2, "vdd", PortCharacteristic.PWR);
        ap1 = gndpins2[0];
        apport1 = gndports2[0];
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        ap2 = gndc;
        apport2 = gndcport;
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        this.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        this.makeCStyleExport(ininvp, ap2, apport2, "gnd", PortCharacteristic.GND);
        if (top) {
            for (i2 = 0; i2 < outs; ++i2) {
                ap1 = inpins2[i2];
                apport1 = inports2[i2];
                this.makeCStyleExport(ininvp, ap1, apport1, "in_top" + i2, PortCharacteristic.IN);
            }
        } else {
            for (i2 = 0; i2 < outs; ++i2) {
                ap1 = inpins[i2];
                apport1 = inports[i2];
                this.makeCStyleExport(ininvp, ap1, apport1, "in_top" + i2, PortCharacteristic.IN);
            }
        }
        if (top) {
            for (i2 = 0; i2 < outs; ++i2) {
                ap1 = outpins[i2];
                apport1 = outports[i2];
                this.makeCStyleExport(ininvp, ap1, apport1, "in_bot" + i2, PortCharacteristic.IN);
            }
        } else {
            for (i2 = 0; i2 < outs; ++i2) {
                ap1 = outpins2[i2];
                apport1 = outports2[i2];
                this.makeCStyleExport(ininvp, ap1, apport1, "in_bot" + i2, PortCharacteristic.IN);
            }
        }
        for (i2 = 0; i2 < outs; ++i2) {
            ap1 = pmospins[i2];
            apport1 = pmosports[i2];
            this.makeCStyleExport(ininvp, ap1, apport1, "in_b" + i2, PortCharacteristic.IN);
        }
    }

    private int[][] romarraygen(String romfile) {
        boolean end = false;
        int[][] returnarray = new int[1][1];
        try {
            BufferedReader in = new BufferedReader(new FileReader(romfile));
            try {
                int w = -1;
                int bits = 0;
                StringBuffer allfile = new StringBuffer();
                while (!end) {
                    ++w;
                    String temp = in.readLine();
                    if (temp == null) {
                        end = true;
                        continue;
                    }
                    StringBuffer sb = new StringBuffer(temp);
                    if (w == 1) {
                        bits = sb.length();
                    }
                    if (w == 0) {
                        this.folds = Integer.parseInt(temp, 10);
                        continue;
                    }
                    allfile.append(sb);
                }
                this.globalbits = --w / this.folds;
                returnarray = new int[bits][w];
                for (int r = 0; r < w; ++r) {
                    for (int s = 0; s < bits; ++s) {
                        returnarray[s][w - r - 1] = allfile.charAt(r * bits + s) == '1' ? 1 : 0;
                    }
                }
            }
            catch (IOException w) {
            }
        }
        catch (FileNotFoundException e2) {
            System.out.println(e2.toString());
        }
        return returnarray;
    }

    private static int[][] generateplane(int bits) {
        int lines = (int)Math.pow(2.0, bits);
        char[][] wordlines = new char[lines][bits];
        for (int i2 = 0; i2 < lines; ++i2) {
            int h2;
            int len = Integer.toBinaryString(i2).length();
            int leadingz = bits - len;
            for (h2 = 0; h2 < leadingz; ++h2) {
                wordlines[i2][h2] = 48;
            }
            for (int j2 = h2; j2 < bits; ++j2) {
                wordlines[i2][j2] = Integer.toBinaryString(i2).charAt(j2 - h2);
            }
        }
        int[][] x = new int[lines][bits];
        for (int j3 = 0; j3 < lines; ++j3) {
            for (int k2 = 0; k2 < bits; ++k2) {
                x[j3][k2] = Character.getNumericValue(wordlines[j3][k2]);
            }
        }
        int[][] wcomp = new int[lines][2 * bits];
        for (int j4 = 0; j4 < lines; ++j4) {
            for (int k3 = 0; k3 < bits; ++k3) {
                wcomp[j4][2 * k3] = x[j4][k3];
                int complement = x[j4][k3] == 1 ? 0 : 1;
                wcomp[j4][2 * k3 + 1] = complement;
            }
        }
        int[][] wcompb = new int[lines][2 * bits];
        for (int j5 = 0; j5 < lines; ++j5) {
            for (int k4 = 0; k4 < 2 * bits; ++k4) {
                wcompb[j5][k4] = wcomp[j5][2 * bits - 1 - k4];
            }
        }
        return wcompb;
    }

    private int[][] romfold(int[][] romarray) {
        int roma = romarray.length * this.folds;
        int romb = romarray[1].length / this.folds;
        int[][] foldedrom = new int[roma][romb];
        for (int i2 = 0; i2 < romarray.length; ++i2) {
            for (int j2 = 0; j2 < this.folds; ++j2) {
                for (int k2 = 0; k2 < romb; ++k2) {
                    foldedrom[this.folds * i2 + j2][k2] = romarray[i2][j2 * romb + k2];
                }
            }
        }
        return foldedrom;
    }

    private NodeInst makeCStyleNodeInst(NodeProto np, double lX, double hX, double lY, double hY, int trn, int rot, Cell parent) {
        double cX = (lX + hX) / 2.0;
        double cY = (lY + hY) / 2.0;
        if (np instanceof Cell) {
            ERectangle bounds = ((Cell)np).getBounds();
            cX -= ((RectangularShape)bounds).getCenterX();
            cY -= ((RectangularShape)bounds).getCenterY();
        }
        double width = hX - lX;
        double height = hY - lY;
        Orientation orient = Orientation.fromC(rot, trn != 0);
        NodeInst ni = NodeInst.makeInstance(np, this.ep, new Point2D.Double(cX, cY), width, height, parent, orient, null);
        return ni;
    }

    private void makeCStyleArcInst(ArcProto ap, double wid, NodeInst hNI, PortProto hPP, double hX, double hY, NodeInst tNI, PortProto tPP, double tX, double tY) {
        PortInst head = hNI.findPortInstFromProto(hPP);
        PortInst tail = tNI.findPortInstFromProto(tPP);
        ArcInst.makeInstanceBase(ap, this.ep, wid, head, tail, new Point2D.Double(hX, hY), new Point2D.Double(tX, tY), null);
    }

    private void makeCStyleExport(Cell parent, NodeInst ni, PortProto pp, String name, PortCharacteristic exporttype) {
        PortInst pi = ni.findPortInstFromProto(pp);
        Export.newInst(parent, pi, name, this.ep, exporttype);
    }

    private static double[] getCStylePortPosition(NodeInst ni, PortProto pp) {
        PortInst pi = ni.findPortInstFromProto(pp);
        Poly poly = pi.getPoly();
        double[] ret = new double[]{poly.getCenterX(), poly.getCenterY()};
        return ret;
    }

    private static class DoROM
    extends Job {
        private Library destLib;
        private String romfile;
        private Cell topLevel;

        private DoROM(Library destLib, String romfile) {
            super("ROM Generator", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.destLib = destLib;
            this.romfile = romfile;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            String romcell = "ROMCELL";
            this.topLevel = new ROMGenerator(this.getEditingPreferences()).makeAROM(this.destLib, this.romfile, romcell);
            this.fieldVariableChanged("topLevel");
            return true;
        }

        @Override
        public void terminateOK() {
            if (this.topLevel != null) {
                WindowFrame wf = WindowFrame.getCurrentWindowFrame();
                if (User.isShowCellsInNewWindow()) {
                    wf = null;
                }
                if (wf == null) {
                    wf = WindowFrame.createEditWindow(this.topLevel);
                }
                wf.setCellWindow(this.topLevel, null);
            }
        }
    }
}

