/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.extract;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.user.GraphicsPreferences;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.LayerVisibility;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GeometrySearch
extends HierarchyEnumerator.Visitor {
    private List<GeometrySearchResult> found;
    private ERectangle geomBBnd;
    private boolean visibleObjectsOnly;
    private final LayerVisibility lv;
    private final GraphicsPreferences gp;
    private int cellsProcessed;

    public GeometrySearch(LayerVisibility lv, GraphicsPreferences gp) {
        this.lv = lv;
        this.gp = gp;
    }

    public List<GeometrySearchResult> searchGeometries(Cell cell, EPoint point, boolean visibleObjectsOnly) {
        this.found = new ArrayList<GeometrySearchResult>();
        this.geomBBnd = ERectangle.fromLambda(point.getX(), point.getY(), 0.0, 0.0);
        this.visibleObjectsOnly = visibleObjectsOnly;
        this.cellsProcessed = 0;
        HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, (HierarchyEnumerator.Visitor)this);
        return this.found;
    }

    public int getCellsProcessed() {
        return this.cellsProcessed;
    }

    @Override
    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        Cell cell = info.getCell();
        FixpTransform xformToRoot = null;
        try {
            xformToRoot = info.getTransformToRoot().createInverse();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        assert (xformToRoot != null);
        Rectangle2D.Double rect = new Rectangle2D.Double();
        ((Rectangle2D)rect).setRect(this.geomBBnd);
        DBMath.transformRect(rect, xformToRoot);
        ++this.cellsProcessed;
        boolean continueDown = false;
        Iterator<Geometric> it = cell.searchIterator(rect, false);
        while (it.hasNext()) {
            double dist;
            Geometric geom = it.next();
            if (geom instanceof NodeInst) {
                NodeInst oNi = (NodeInst)geom;
                if (oNi.isCellInstance()) {
                    continueDown = true;
                    continue;
                }
                dist = Highlighter.distToNode(rect, oNi, null, this.gp.isShowTempNames());
                if (dist > 0.0) continue;
                PrimitiveNode node = (PrimitiveNode)oNi.getProto();
                if (this.visibleObjectsOnly && !this.lv.isVisible(node)) continue;
                this.found.add(new GeometrySearchResult(geom, info.getContext()));
                continue;
            }
            ArcInst ai = (ArcInst)geom;
            dist = Highlighter.distToArc(rect, ai, null, this.gp.isShowTempNames());
            if (dist > 0.0) continue;
            ArcProto ap = ai.getProto();
            if (this.visibleObjectsOnly && !this.lv.isVisible(ap)) continue;
            this.found.add(new GeometrySearchResult(geom, info.getContext()));
        }
        return continueDown;
    }

    @Override
    public void exitCell(HierarchyEnumerator.CellInfo info) {
    }

    @Override
    public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
        return !this.visibleObjectsOnly || no.getNodeInst().isExpanded();
    }

    public static class GeometrySearchResult {
        private Geometric geom;
        private VarContext context;

        GeometrySearchResult(Geometric g2, VarContext c2) {
            this.geom = g2;
            this.context = c2;
        }

        public Geometric getGeometric() {
            return this.geom;
        }

        public VarContext getContext() {
            return this.context;
        }

        public String describe() {
            String contextstr = "current cell";
            if (this.context != VarContext.globalContext) {
                contextstr = this.getInstPath(this.context);
            }
            return String.valueOf(this.geom) + " in " + contextstr;
        }

        public String getInstPath(VarContext vc) {
            if (vc == VarContext.globalContext) {
                return "";
            }
            String prefix = vc.pop() == VarContext.globalContext ? "" : this.getInstPath(vc.pop());
            Nodable no = vc.getNodable();
            if (no == null) {
                System.out.println("VarContext.getInstPath: context with null NodeInst?");
            }
            Object me = no.getName();
            if (no instanceof NodeInst) {
                Name name = no.getNameKey();
                me = name.subname(0).toString();
            }
            me = no.getProto().getName() + "[" + (String)me + "]";
            if (prefix.equals("")) {
                return me;
            }
            return prefix + " / " + (String)me;
        }
    }
}

