/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.erc.wellcheck;

import com.sun.electric.database.topology.RTNode;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.erc.ERCWellCheck;
import com.sun.electric.tool.erc.wellcheck.NetValues;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.MutableBoolean;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class Utils {
    public static final boolean GATHERSTATISTICS = false;
    public static final boolean INCREMENTALGROWTH = false;
    public static final WorkDistributionStrategy WORKDISTRIBUTION = WorkDistributionStrategy.bucket;
    public static List<ERCWellCheck.WellBoundRecord> wellBoundSearchOrder;
    public static int numObjSearches;

    public static boolean canBeSubstrateTap(PrimitiveNode.Function fun) {
        return fun == PrimitiveNode.Function.SUBSTRATE || fun == PrimitiveNode.Function.RESPWELL;
    }

    public static boolean canBeWellTap(PrimitiveNode.Function fun) {
        return fun == PrimitiveNode.Function.WELL || fun == PrimitiveNode.Function.RESNWELL;
    }

    public static void spreadWellSeed(double cX, double cY, NetValues wellNum, RTNode<ERCWellCheck.WellBound> rtree, int threadIndex) {
        RTNode<ERCWellCheck.WellBound> allFound = null;
        Point2D.Double ctr = new Point2D.Double(cX, cY);
        Rectangle2D.Double searchArea = new Rectangle2D.Double(cX, cY, 0.0, 0.0);
        MutableBoolean keepSearching = new MutableBoolean(true);
        Rectangle2D[] sides = new Rectangle2D[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            sides[i2] = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        boolean numSides = true;
        sides[0].setRect(searchArea);
        while (keepSearching.booleanValue()) {
            allFound = Utils.searchInArea(searchArea, wellNum, rtree, allFound, ctr, keepSearching, threadIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RTNode<ERCWellCheck.WellBound> searchInArea(Rectangle2D searchArea, NetValues wellNum, RTNode<ERCWellCheck.WellBound> rtree, RTNode<ERCWellCheck.WellBound> allFound, Point2D ctr, MutableBoolean keepSearching, int threadIndex) {
        keepSearching.setValue(false);
        RTNode.Search<ERCWellCheck.WellBound> sea = new RTNode.Search<ERCWellCheck.WellBound>(searchArea, rtree, true);
        while (sea.hasNext()) {
            ERCWellCheck.WellBound wb = (ERCWellCheck.WellBound)sea.next();
            if (wb.getNetID() != null && wb.getNetID().getIndex() == wellNum.getIndex()) continue;
            if (allFound == null) {
                if (!wb.getBounds().contains(ctr)) {
                    continue;
                }
            } else {
                boolean touches = false;
                RTNode.Search<ERCWellCheck.WellBound> subSea = new RTNode.Search<ERCWellCheck.WellBound>(wb.getBounds(), allFound, true);
                while (subSea.hasNext()) {
                    ERCWellCheck.WellBound subWB = (ERCWellCheck.WellBound)subSea.next();
                    if (!DBMath.rectsIntersect(subWB.getBounds(), wb.getBounds())) continue;
                    touches = true;
                    break;
                }
                if (!touches) continue;
            }
            ERCWellCheck.WellBound wellBound = wb;
            synchronized (wellBound) {
                if (wb.getNetID() != null) {
                    wellNum.merge(wb.getNetID());
                } else {
                    wb.setNetID(wellNum);
                }
            }
            Rectangle2D.union(searchArea, wb.getBounds(), searchArea);
            if (allFound == null) {
                allFound = RTNode.makeTopLevel();
            }
            allFound = RTNode.linkGeom(null, allFound, wb);
            keepSearching.setValue(true);
        }
        return allFound;
    }

    public static enum WorkDistributionStrategy {
        cluster,
        random,
        bucket;

    }
}

