/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.erc.wellcheck;

import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.erc.ERCWellCheck;
import com.sun.electric.tool.erc.wellcheck.WellCheckAnalysisStrategy;
import com.sun.electric.util.ElapseTimer;
import java.awt.geom.Rectangle2D;

public class DRCCheck
implements WellCheckAnalysisStrategy {
    private Layer pWellLayer;
    private Layer nWellLayer;
    private RTNode<ERCWellCheck.WellBound> pWellRoot;
    private RTNode<ERCWellCheck.WellBound> nWellRoot;
    private ERCWellCheck.StrategyParameter parameters;

    public DRCCheck(ERCWellCheck.StrategyParameter parameters, Layer pWellLayer, Layer nWellLayer, RTNode<ERCWellCheck.WellBound> pWellRoot, RTNode<ERCWellCheck.WellBound> nWellRoot) {
        this.parameters = parameters;
        this.pWellLayer = pWellLayer;
        this.nWellLayer = nWellLayer;
        this.pWellRoot = pWellRoot;
        this.nWellRoot = nWellRoot;
    }

    @Override
    public void execute() {
        if (this.parameters.getWellPrefs().drcCheck) {
            ElapseTimer timer = ElapseTimer.createInstance();
            timer.start();
            DRCTemplate pRule = DRC.getSpacingRule(this.pWellLayer, null, this.pWellLayer, null, false, -1, 0.0, 0.0);
            DRCTemplate nRule = DRC.getSpacingRule(this.nWellLayer, null, this.nWellLayer, null, false, -1, 0.0, 0.0);
            if (pRule != null) {
                this.findDRCViolations(this.pWellRoot, pRule.getValue(0));
            }
            if (nRule != null) {
                this.findDRCViolations(this.nWellRoot, nRule.getValue(0));
            }
            timer.end();
            System.out.println("   Design rule check took " + timer.toString());
        }
    }

    private void findDRCViolations(RTNode<ERCWellCheck.WellBound> rtree, double minDist) {
        for (int j2 = 0; j2 < rtree.getTotal(); ++j2) {
            Object child;
            if (rtree.getFlag()) {
                child = rtree.getChildLeaf(j2);
                if (((ERCWellCheck.WellBound)child).getNetID() == null) continue;
                Rectangle2D.Double searchArea = new Rectangle2D.Double(((ERCWellCheck.WellBound)child).getBounds().getMinX() - minDist, ((ERCWellCheck.WellBound)child).getBounds().getMinY() - minDist, ((ERCWellCheck.WellBound)child).getBounds().getWidth() + minDist * 2.0, ((ERCWellCheck.WellBound)child).getBounds().getHeight() + minDist * 2.0);
                RTNode.Search<ERCWellCheck.WellBound> sea = new RTNode.Search<ERCWellCheck.WellBound>(searchArea, rtree, true);
                while (sea.hasNext()) {
                    PolyBase pb;
                    double trueDist;
                    ERCWellCheck.WellBound other = (ERCWellCheck.WellBound)sea.next();
                    if (other.getNetID().getIndex() <= ((ERCWellCheck.WellBound)child).getNetID().getIndex() || ((ERCWellCheck.WellBound)child).getBounds().getMinX() > other.getBounds().getMaxX() + minDist || other.getBounds().getMinX() > ((ERCWellCheck.WellBound)child).getBounds().getMaxX() + minDist || ((ERCWellCheck.WellBound)child).getBounds().getMinY() > other.getBounds().getMaxY() + minDist || other.getBounds().getMinY() > ((ERCWellCheck.WellBound)child).getBounds().getMaxY() + minDist || !((trueDist = (pb = new PolyBase(((ERCWellCheck.WellBound)child).getBounds())).polyDistance(other.getBounds())) < minDist)) continue;
                    this.parameters.logError("Well areas too close (are " + TextUtils.formatDistance(trueDist) + " but should be " + TextUtils.formatDistance(minDist) + " apart)", child, other);
                }
                continue;
            }
            child = rtree.getChildTree(j2);
            this.findDRCViolations((RTNode<ERCWellCheck.WellBound>)child, minDist);
        }
    }
}

