/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies.photonics;

import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.photonics.PLayer;
import com.sun.electric.technology.technologies.photonics.Photonics;

public class Splitter
extends PrimitiveNode {
    private static final double BASEWIDTH = 40.0;
    private static final double BASEHEIGHT = 20.0;
    private static final double DEFAULTANGLESHIFT = 1.0;
    private static final double DEFAULTHORIZSHIFT = 5.0;
    private SplitterPort pp1 = new SplitterPort(this, "splitter-ll", 180, 1);
    private SplitterPort pp2 = new SplitterPort(this, "splitter-lr", 0, 2);
    private SplitterPort pp3 = new SplitterPort(this, "splitter-ur", 0, 3);

    public Splitter(Photonics tech, Technology.NodeLayer[] layers) {
        super("Splitter", tech, EPoint.ORIGIN, EPoint.ORIGIN, null, 40.0, 20.0, ERectangle.fromLambda(-20.0, -10.0, 40.0, 20.0), ERectangle.fromLambda(-20.0, -10.0, 40.0, 20.0), layers);
        this.addPrimitivePorts(this.pp1, this.pp2, this.pp3);
    }

    @Override
    public void genShape(AbstractShapeBuilder b2, ImmutableNodeInst n2) {
        assert (n2.protoId == this.getId());
        long width = n2.size.getFixpX() + Photonics.lambdaToFixp(40.0);
        long height = n2.size.getFixpY() + Photonics.lambdaToFixp(20.0);
        PLayer[] ol = Photonics.getOpticalLayers(true);
        double spacing = Photonics.photonicsWaveguide.getWidth() + 1.0;
        double aShift = 1.0;
        double hShift = 5.0;
        for (int i2 = 0; i2 < ol.length; ++i2) {
            long lowX = -width / 2L;
            long highX = width / 2L;
            long lowY = -height / 2L;
            long highY = 0L;
            double lowAngle = -1.5707963267948966;
            double highAngle = 4.71238898038469;
            this.drawCurve(b2, n2, lowX, highX, lowY, highY, lowAngle, highAngle, ol[i2]);
            lowX = -width / 2L + Photonics.lambdaToFixp(hShift);
            lowY = -height / 2L + Photonics.lambdaToFixp(spacing);
            highY = height / 2L;
            lowAngle = -1.5707963267948966 + aShift;
            highAngle = 1.5707963267948966;
            this.drawCurve(b2, n2, lowX, highX, lowY, highY, lowAngle, highAngle, ol[i2]);
        }
    }

    private void drawCurve(AbstractShapeBuilder b2, ImmutableNodeInst n2, long lowX, long highX, long lowY, long highY, double lowAngle, double highAngle, PLayer pl) {
        double y;
        double x;
        double sinVal;
        double angle;
        int i2;
        long channelWidth = Photonics.lambdaToFixp(pl.getWidth());
        b2.setCurNode(n2);
        for (i2 = 0; i2 <= 128; ++i2) {
            angle = lowAngle + (highAngle - lowAngle) / 128.0 * (double)i2;
            sinVal = (Math.sin(angle) + 1.0) / 2.0;
            x = lowX + (highX - lowX) / 128L * (long)i2;
            y = (double)lowY + (double)(highY - lowY) * sinVal - (double)(channelWidth / 2L);
            b2.pushPoint(x, y);
        }
        for (i2 = 128; i2 >= 0; --i2) {
            angle = lowAngle + (highAngle - lowAngle) / 128.0 * (double)i2;
            sinVal = (Math.sin(angle) + 1.0) / 2.0;
            x = lowX + (highX - lowX) / 128L * (long)i2;
            y = (double)lowY + (double)(highY - lowY) * sinVal + (double)(channelWidth / 2L);
            b2.pushPoint(x, y);
        }
        b2.pushPoly(Poly.Type.FILLED, pl.findLayer(), null, null);
    }

    public class SplitterPort
    extends PrimitivePort {
        private final int portNumber;

        SplitterPort(Splitter parent, String portName, int portAngle, int portNumber) {
            super(parent, new ArcProto[]{Photonics.opticalArc}, portName, false, portAngle, 0, 0, PortCharacteristic.UNKNOWN, false, false, new EdgeH(0.0, 0.0), new EdgeV(0.0, 0.0), new EdgeH(0.0, 0.0), new EdgeV(0.0, 0.0));
            this.portNumber = portNumber;
        }

        @Override
        public void genShape(AbstractShapeBuilder b2, ImmutableNodeInst n2) {
            assert (n2.protoId == this.getParent().getId());
            long width = n2.size.getFixpX() + Photonics.lambdaToFixp(40.0);
            long height = n2.size.getFixpY() + Photonics.lambdaToFixp(20.0);
            b2.setCurNode(n2);
            double x = 0.0;
            double y = 0.0;
            switch (this.portNumber) {
                case 1: {
                    x = -width / 2L;
                    y = -height / 2L;
                    break;
                }
                case 2: {
                    x = width / 2L;
                    y = -height / 2L;
                    break;
                }
                case 3: {
                    x = width / 2L;
                    y = height / 2L;
                }
            }
            b2.pushPoint(x, y);
            b2.pushPoint(x, y);
            b2.pushPoint(x, y);
            b2.pushPoint(x, y);
            b2.pushPoly(Poly.Type.FILLED, null, null, null);
        }
    }
}

