/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies.photonics;

import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.photonics.PLayer;
import com.sun.electric.technology.technologies.photonics.Photonics;

public class Ring
extends PrimitiveNode {
    private static final double BASESIZE = 30.0;
    private PrimitivePort ppC;

    public Ring(Photonics tech, Technology.NodeLayer[] layers) {
        super("Ring", tech, EPoint.ORIGIN, EPoint.ORIGIN, null, 30.0, 30.0, ERectangle.fromLambda(-15.0, -15.0, 30.0, 30.0), ERectangle.fromLambda(-15.0, -15.0, 30.0, 30.0), layers);
        this.setSquare();
        this.ppC = PrimitivePort.single(this, new ArcProto[]{Photonics.opticalArc}, "ring-ctr", 90, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.c(0.0), EdgeV.t(15.0), EdgeH.c(0.0), EdgeV.t(15.0));
        this.addPrimitivePorts(this.ppC);
    }

    @Override
    public void genShape(AbstractShapeBuilder b2, ImmutableNodeInst n2) {
        assert (n2.protoId == this.getId());
        long radius = n2.size.getFixpX() + Photonics.lambdaToFixp(30.0) >> 1;
        PLayer[] ol = Photonics.getOpticalLayers(true);
        for (int l2 = 0; l2 < ol.length; ++l2) {
            long y;
            long x;
            double angle;
            int i2;
            Layer layer = ol[l2].findLayer();
            if (layer == null) continue;
            long extend = Photonics.lambdaToFixp(ol[l2].getWidth()) / 2L;
            b2.setCurNode(n2);
            for (i2 = 0; i2 <= 128; ++i2) {
                angle = 0.04908738521234052 * (double)i2;
                x = (long)(Math.cos(angle) * (double)(radius + extend));
                y = (long)(Math.sin(angle) * (double)(radius + extend));
                b2.pushPoint(x, y);
            }
            for (i2 = 128; i2 >= 0; --i2) {
                angle = 0.04908738521234052 * (double)i2;
                x = (long)(Math.cos(angle) * (double)(radius - extend));
                y = (long)(Math.sin(angle) * (double)(radius - extend));
                b2.pushPoint(x, y);
            }
            PrimitivePort pp = ol[l2] == Photonics.photonicsWaveguide ? this.ppC : null;
            b2.pushPoly(Poly.Type.FILLED, layer, null, pp);
        }
    }
}

