/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies.photonics;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.TechFactory;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.photonics.GratingCoupler;
import com.sun.electric.technology.technologies.photonics.OpticalArc;
import com.sun.electric.technology.technologies.photonics.OpticalCorner;
import com.sun.electric.technology.technologies.photonics.OpticalPin;
import com.sun.electric.technology.technologies.photonics.PLayer;
import com.sun.electric.technology.technologies.photonics.PhotoDetector;
import com.sun.electric.technology.technologies.photonics.Ring;
import com.sun.electric.technology.technologies.photonics.Splitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Photonics
extends Technology {
    public static PLayer photonicsWaveguide = new PLayer("photonics-waveguide", 1.0);
    public static PLayer photonicsSide = new PLayer("photonics-side", 5.0);
    public static PLayer photonicsTop = new PLayer("photonics-top", 5.0);
    public static PLayer photonicsBottom = new PLayer("photonics-bottom", 5.0);
    public static final int CURVESTEPS = 128;
    public static Layer metal1Layer = null;
    public static Layer polyCutLayer = null;
    public static ArcProto metal1Arc = null;
    public static ArcProto opticalArc = null;
    private static Photonics thisTech = null;
    public static final Variable.Key extraInfoKey = Variable.newKey("ATTR_ExtraInfo");

    public Photonics(Generic generic, TechFactory techFactory, Map<TechFactory.Param, Object> techParams, Xml.Technology t) {
        super(generic, techFactory, techParams, t);
        thisTech = this;
        this.setStaticTechnology();
        opticalArc = new OpticalArc(this);
        metal1Layer = this.findLayer("m1");
        polyCutLayer = this.findLayer("poly-cut");
        if (metal1Layer == null || polyCutLayer == null) {
            System.out.println("WARNING: Missing Layers in Photonics technology");
        }
        if ((metal1Arc = this.findArcProto("metal-1")) == null) {
            System.out.println("WARNING: Missing Metal-1 arc in Photonics technology");
        }
        Technology.NodeLayer[] nodeLayers = new Technology.NodeLayer[]{new Technology.NodeLayer(metal1Layer, 0, Poly.Type.FILLED, 1, new Technology.TechPoint[0])};
        new OpticalPin("Optical-Pin", thisTech, nodeLayers);
        new OpticalCorner("Optical-Corner-90", thisTech, nodeLayers, 90);
        new OpticalCorner("Optical-Corner-45", thisTech, nodeLayers, 45);
        new GratingCoupler(thisTech, nodeLayers);
        new PhotoDetector(thisTech, nodeLayers);
        new Ring(thisTech, nodeLayers);
        new Splitter(thisTech, nodeLayers);
        this.loadFactoryMenuPalette(Photonics.class.getResource("PhotonicsMenu.xml"));
    }

    public static Photonics tech() {
        return thisTech;
    }

    public static List<TechFactory.Param> getTechParams() {
        return Arrays.asList(new TechFactory.Param[0]);
    }

    public static Xml.Technology getPatchedXml(Map<TechFactory.Param, Object> params) {
        Xml.Technology tech = Xml.parseTechnology(Photonics.class.getResource("Photonics.xml"));
        return tech;
    }

    public static long lambdaToFixp(double l2) {
        return (long)(l2 * 400.0 * 1048576.0);
    }

    public static PLayer[] getOpticalLayers(boolean includeWaveguide) {
        ArrayList<PLayer> wgb = new ArrayList<PLayer>();
        if (includeWaveguide) {
            wgb.add(photonicsWaveguide);
        }
        wgb.add(photonicsBottom);
        wgb.add(photonicsSide);
        wgb.add(photonicsTop);
        PLayer[] ret = new PLayer[wgb.size()];
        for (int i2 = 0; i2 < wgb.size(); ++i2) {
            ret[i2] = (PLayer)wgb.get(i2);
        }
        return ret;
    }
}

