/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies.photonics;

import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.photonics.PLayer;
import com.sun.electric.technology.technologies.photonics.Photonics;

public class OpticalPin
extends PrimitiveNode {
    private static final double BASESIZE = 1.0;
    private PrimitivePort pp = PrimitivePort.single(this, new ArcProto[]{Photonics.opticalArc}, "optical", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.c(0.0), EdgeV.c(0.0), EdgeH.c(0.0), EdgeV.c(0.0));

    public OpticalPin(String protoName, Photonics tech, Technology.NodeLayer[] layers) {
        super(protoName, tech, EPoint.ORIGIN, EPoint.ORIGIN, null, 1.0, 1.0, ERectangle.fromLambda(-0.5, -0.5, 1.0, 1.0), ERectangle.fromLambda(-0.5, -0.5, 1.0, 1.0), layers);
        this.addPrimitivePorts(this.pp);
        this.setFunction(PrimitiveNode.Function.PIN);
        this.setArcsWipe();
    }

    @Override
    public void genShape(AbstractShapeBuilder b2, ImmutableNodeInst n2) {
        assert (n2.protoId == this.getId());
        long width = n2.size.getFixpX() + Photonics.lambdaToFixp(1.0);
        long height = n2.size.getFixpY() + Photonics.lambdaToFixp(1.0);
        long one = Photonics.lambdaToFixp(1.0);
        PLayer[] ol = Photonics.getOpticalLayers(true);
        for (int l2 = 0; l2 < ol.length; ++l2) {
            Layer layer = ol[l2].findLayer();
            if (layer == null) continue;
            double extraWidth = ol[l2].getWidth() - 1.0;
            double halfWidth = ((double)width + extraWidth * (double)one) / 2.0;
            double halfHeight = ((double)height + extraWidth * (double)one) / 2.0;
            b2.setCurNode(n2);
            b2.pushPoint(-halfWidth, -halfHeight);
            b2.pushPoint(-halfWidth, halfHeight);
            b2.pushPoint(halfWidth, halfHeight);
            b2.pushPoint(halfWidth, -halfHeight);
            b2.pushPoly(Poly.Type.CROSSED, layer, null, null);
        }
    }
}

