/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies.photonics;

import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.photonics.PLayer;
import com.sun.electric.technology.technologies.photonics.Photonics;

public class OpticalCorner
extends PrimitiveNode {
    private static final double BASESIZE = 10.0;
    private int angle;
    private PrimitivePort pp1;
    private PrimitivePort pp2;

    public OpticalCorner(String protoName, Photonics tech, Technology.NodeLayer[] layers, int angle) {
        super(protoName, tech, EPoint.ORIGIN, EPoint.ORIGIN, null, 10.0, 10.0, ERectangle.fromLambda(-5.0, -5.0, 10.0, 10.0), ERectangle.fromLambda(-5.0, -5.0, 10.0, 10.0), layers);
        this.angle = angle;
        if (angle == 90) {
            this.pp1 = PrimitivePort.newInst(this, new ArcProto[]{Photonics.opticalArc}, "c1", 270, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.r(5.0), EdgeV.b(-5.0), EdgeH.r(5.0), EdgeV.b(-5.0));
            this.pp2 = PrimitivePort.newInst(this, new ArcProto[]{Photonics.opticalArc}, "c2", 180, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.l(-5.0), EdgeV.t(5.0), EdgeH.l(-5.0), EdgeV.t(5.0));
        } else {
            this.pp1 = PrimitivePort.newInst(this, new ArcProto[]{Photonics.opticalArc}, "c1", 270, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.r(5.0), EdgeV.b(-5.0), EdgeH.r(5.0), EdgeV.b(-5.0));
            this.pp2 = PrimitivePort.newInst(this, new ArcProto[]{Photonics.opticalArc}, "c2", 135, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.r(2.07), EdgeV.t(2.07), EdgeH.r(2.07), EdgeV.t(2.07));
        }
        this.addPrimitivePorts(this.pp1, this.pp2);
        this.setCurvedPin();
    }

    @Override
    public void genShape(AbstractShapeBuilder b2, ImmutableNodeInst n2) {
        int halfWay;
        int numPasses;
        assert (n2.protoId == this.getId());
        long width = n2.size.getFixpX() + Photonics.lambdaToFixp(10.0);
        long height = n2.size.getFixpY() + Photonics.lambdaToFixp(10.0);
        PLayer trench = Photonics.photonicsWaveguide;
        Layer otrenchLay = trench.findLayer();
        long one = Photonics.lambdaToFixp(1.0);
        if (width == 0L || height == 0L) {
            b2.setCurNode(n2);
            double extraWidth = trench.getWidth() - 10.0;
            double halfWidth = ((double)width + extraWidth * (double)one) / 2.0;
            double halfHeight = ((double)height + extraWidth * (double)one) / 2.0;
            b2.pushPoint(-halfWidth, -halfHeight);
            b2.pushPoint(-halfWidth, halfHeight);
            b2.pushPoint(halfWidth, halfHeight);
            b2.pushPoint(halfWidth, -halfHeight);
            b2.pushPoly(Poly.Type.CROSSED, otrenchLay, null, null);
            return;
        }
        long halfWidth = width >> 1;
        long halfHeight = height >> 1;
        double trenchHalfWidth = trench.getWidth() / 2.0;
        double outerWid = (double)width + trenchHalfWidth * (double)one;
        double outerHei = (double)height + trenchHalfWidth * (double)one;
        double innerWid = (double)width - trenchHalfWidth * (double)one;
        double innerHei = (double)height - trenchHalfWidth * (double)one;
        int numSteps = 128 * this.angle / 360;
        if (b2.isElectrical()) {
            numPasses = 2;
            halfWay = numSteps / 2;
        } else {
            numPasses = 1;
            halfWay = numSteps;
        }
        for (int e2 = 0; e2 < numPasses; ++e2) {
            long y;
            long x;
            double angle;
            int i2;
            PrimitivePort pp;
            int endPt;
            int startPt;
            b2.setCurNode(n2);
            if (e2 == 0) {
                startPt = 0;
                endPt = halfWay;
                pp = this.pp1;
            } else {
                startPt = halfWay;
                endPt = numSteps;
                pp = this.pp2;
            }
            for (i2 = startPt; i2 <= endPt; ++i2) {
                angle = 0.04908738521234052 * (double)i2;
                x = (long)(Math.cos(angle) * outerWid) - halfWidth;
                y = (long)(Math.sin(angle) * outerHei) - halfHeight;
                b2.pushPoint(x, y);
            }
            for (i2 = endPt; i2 >= startPt; --i2) {
                angle = 0.04908738521234052 * (double)i2;
                x = (long)(Math.cos(angle) * innerWid) - halfWidth;
                y = (long)(Math.sin(angle) * innerHei) - halfHeight;
                b2.pushPoint(x, y);
            }
            b2.pushPoly(Poly.Type.FILLED, otrenchLay, null, pp);
        }
        PLayer[] ol = Photonics.getOpticalLayers(false);
        for (int l2 = 0; l2 < ol.length; ++l2) {
            long y;
            long x;
            double angle;
            int i3;
            Layer layer = ol[l2].findLayer();
            if (layer == null) continue;
            double surroundHalfWidth = ol[l2].getWidth() / 2.0;
            outerWid = (double)width + surroundHalfWidth * (double)one;
            outerHei = (double)height + surroundHalfWidth * (double)one;
            innerWid = (double)width - surroundHalfWidth * (double)one;
            innerHei = (double)height - surroundHalfWidth * (double)one;
            b2.setCurNode(n2);
            for (i3 = 0; i3 <= numSteps; ++i3) {
                angle = 0.04908738521234052 * (double)i3;
                x = (long)(Math.cos(angle) * outerWid) - halfWidth;
                y = (long)(Math.sin(angle) * outerHei) - halfHeight;
                b2.pushPoint(x, y);
            }
            for (i3 = numSteps; i3 >= 0; --i3) {
                angle = 0.04908738521234052 * (double)i3;
                x = (long)(Math.cos(angle) * innerWid) - halfWidth;
                y = (long)(Math.sin(angle) * innerHei) - halfHeight;
                b2.pushPoint(x, y);
            }
            b2.pushPoly(Poly.Type.FILLED, layer, null, null);
        }
    }
}

