/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies.photonics;

import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.photonics.PLayer;
import com.sun.electric.technology.technologies.photonics.Photonics;

public class GratingCoupler
extends PrimitiveNode {
    private static final double BASESIZE = 20.0;
    private static final double DEFDEGREES = 180.0;
    private static final Variable.Key COUPLER_ANGLE = Variable.newKey("SIPHOTONICS_GratingCouplerAngle");
    private PrimitivePort pp;

    public GratingCoupler(Photonics tech, Technology.NodeLayer[] layers) {
        super("Grating-Coupler", tech, EPoint.ORIGIN, EPoint.ORIGIN, null, 20.0, 20.0, ERectangle.fromLambda(-10.0, -10.0, 20.0, 20.0), ERectangle.fromLambda(-10.0, -10.0, 20.0, 20.0), layers);
        new Technology.ExtraField(this, COUPLER_ANGLE, "Angle of Fan");
        this.pp = PrimitivePort.single(this, new ArcProto[]{Photonics.opticalArc}, "g-c", 90, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.c(0.0), EdgeV.c(0.0), EdgeH.c(0.0), EdgeV.c(0.0));
        this.addPrimitivePorts(this.pp);
    }

    @Override
    public void genShape(AbstractShapeBuilder b2, ImmutableNodeInst n2) {
        double botRadius;
        assert (n2.protoId == this.getId());
        double degrees = 180.0;
        Double userDegrees = (Double)n2.getVarValue(COUPLER_ANGLE, Double.class);
        if (userDegrees != null) {
            degrees = userDegrees;
        }
        double halfDegrees = degrees / 2.0;
        long radius = (n2.size.getFixpY() + Photonics.lambdaToFixp(20.0)) / 2L;
        double botRightAngle = (270.0 + halfDegrees) * Math.PI / 180.0;
        double botLeftAngle = (270.0 - halfDegrees) * Math.PI / 180.0;
        PLayer[] ol = Photonics.getOpticalLayers(false);
        for (int l2 = 0; l2 < ol.length; ++l2) {
            Layer layer = ol[l2].findLayer();
            if (layer == null) continue;
            b2.setCurNode(n2);
            b2.pushPoint(0L, 0L);
            for (int i2 = 0; i2 <= 128; ++i2) {
                double angle = botLeftAngle + (botRightAngle - botLeftAngle) / 128.0 * (double)i2;
                double x = (double)radius * Math.cos(angle);
                double y = (double)radius * Math.sin(angle);
                b2.pushPoint(x, y);
            }
            b2.pushPoly(Poly.Type.FILLED, layer, null, null);
        }
        PLayer trench = Photonics.photonicsWaveguide;
        Layer trenchLay = trench.findLayer();
        double trenchWidth = trench.getWidth();
        double ringRadius = 0.0;
        long one = Photonics.lambdaToFixp(1.0);
        while (!((botRadius = (ringRadius += trenchWidth * (double)one) + trenchWidth * (double)one) > (double)radius)) {
            double y;
            double x;
            double angle;
            int i3;
            b2.setCurNode(n2);
            for (i3 = 0; i3 <= 128; ++i3) {
                angle = botLeftAngle + (botRightAngle - botLeftAngle) / 128.0 * (double)i3;
                x = ringRadius * Math.cos(angle);
                y = ringRadius * Math.sin(angle);
                b2.pushPoint(x, y);
            }
            ringRadius = botRadius;
            for (i3 = 128; i3 >= 0; --i3) {
                angle = botLeftAngle + (botRightAngle - botLeftAngle) / 128.0 * (double)i3;
                x = ringRadius * Math.cos(angle);
                y = ringRadius * Math.sin(angle);
                b2.pushPoint(x, y);
            }
            b2.pushPoly(Poly.Type.FILLED, trenchLay, null, null);
        }
    }
}

