/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.Main;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ActivityLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class TechFactory {
    final String techName;
    private final List<Param> techParams;
    private static List<String> sensitiveTechNames = new ArrayList<String>();

    public static TechFactory fromXml(URL url, Xml.Technology xmlTech) {
        String techName = null;
        if (xmlTech != null) {
            techName = xmlTech.techName;
        }
        if (techName == null) {
            techName = TextUtils.getFileNameWithoutExtension(url);
        }
        return new FromXml(techName, true, url, xmlTech);
    }

    public Technology newInst(Generic generic) {
        return this.newInst(generic, Collections.emptyMap());
    }

    public Technology newInst(Generic generic, Map<Param, Object> paramValues) {
        block6: {
            try {
                HashMap<Param, Object> fixedParamValues = new HashMap<Param, Object>();
                for (Param param : this.techParams) {
                    Object value = paramValues.get(param);
                    if (value == null || value.getClass() != param.factoryValue.getClass()) {
                        value = param.factoryValue;
                    }
                    fixedParamValues.put(param, value);
                }
                Technology tech = this.newInstanceImpl(generic, fixedParamValues);
                if (tech != null) {
                    tech.setup();
                }
                return tech;
            }
            catch (ClassNotFoundException e2) {
                TextUtils.recordMissingTechnology("Extra");
            }
            catch (Exception e3) {
                System.out.println("ERROR while loading technology " + this.techName + ": " + (e3 != null ? e3.getMessage() : "Assertion"));
                if (!Job.getDebug()) break block6;
                ActivityLogger.logException(e3);
            }
        }
        return null;
    }

    public List<Param> getTechParams() {
        return this.techParams;
    }

    public static List<String> getSensitiveTechNames() {
        return sensitiveTechNames;
    }

    abstract String getDescription();

    void write(IdWriter writer) throws IOException {
        writer.writeString(this.techName);
        writer.writeBoolean(false);
    }

    public String toString() {
        return this.techName;
    }

    public static TechFactory getGenericFactory() {
        return new FromClass("generic", "com.sun.electric.technology.technologies.Generic");
    }

    public static Map<String, TechFactory> getKnownTechs() {
        LinkedHashMap<String, TechFactory> m2 = new LinkedHashMap<String, TechFactory>();
        TechFactory.c(m2, "artwork", "com.sun.electric.technology.technologies.Artwork");
        TechFactory.c(m2, "fpga", "com.sun.electric.technology.technologies.FPGA");
        TechFactory.c(m2, "schematic", "com.sun.electric.technology.technologies.Schematics");
        TechFactory.r(m2, "bicmos", "technology/technologies/bicmos.xml", false);
        TechFactory.r(m2, "bipolar", "technology/technologies/bipolar.xml", false);
        TechFactory.r(m2, "cmos", "technology/technologies/cmos.xml", false);
        TechFactory.r(m2, "efido", "technology/technologies/efido.xml", false);
        TechFactory.c(m2, "gem", "com.sun.electric.technology.technologies.GEM");
        TechFactory.r(m2, "josephson", "technology/technologies/josephson.xml", false);
        TechFactory.r(m2, "pcb", "technology/technologies/pcb.xml", false);
        TechFactory.r(m2, "rcmos", "technology/technologies/rcmos.xml", false);
        TechFactory.p(m2, "mocmos", "com.sun.electric.technology.technologies.MoCMOS", false);
        TechFactory.r(m2, "mocmosold", "technology/technologies/mocmosold.xml", false);
        TechFactory.r(m2, "mocmossub", "technology/technologies/mocmossub.xml", false);
        TechFactory.r(m2, "mocmos-cn", "technology/technologies/mocmos-cn.xml", false);
        TechFactory.r(m2, "nmos", "technology/technologies/nmos.xml", false);
        TechFactory.p(m2, "photonics", "com.sun.electric.technology.technologies.photonics.Photonics", false);
        TechFactory.r(m2, "skywater130", "technology/technologies/skywater130.xml", false);
        TechFactory.r(m2, "tft", "technology/technologies/tft.xml", false);
        TechFactory.p(m2, "tsmc180", "com.sun.electric.plugins.tsmc.TSMC180", true);
        TechFactory.p(m2, "cmos90", "com.sun.electric.plugins.tsmc.CMOS90", true);
        TechFactory.r(m2, "tsmcSun40GP", "plugins/tsmc/tsmcSun40GP.xml", true);
        TechFactory.r(m2, "tsmcCLN40G", "plugins/tsmc/tsmcCLN40G.xml", true);
        return Collections.unmodifiableMap(m2);
    }

    public static TechFactory getTechFactory(String techName) {
        return TechFactory.getKnownTechs().get(techName);
    }

    TechFactory(String techName) {
        this(techName, Collections.emptyList());
    }

    TechFactory(String techName, List<Param> techParams) {
        this.techName = techName;
        this.techParams = Collections.unmodifiableList(new ArrayList<Param>(techParams));
    }

    private static void p(Map<String, TechFactory> m2, String techName, String techClassName, boolean restricted) {
        FromParamClass techFactory;
        try {
            Class<?> techClass = Class.forName(techClassName);
            Method getTechParamsMethod = techClass.getMethod("getTechParams", new Class[0]);
            List params = (List)getTechParamsMethod.invoke(null, new Object[0]);
            techFactory = new FromParamClass(techName, techClass, params);
            if (restricted) {
                sensitiveTechNames.add(techName);
            }
        }
        catch (Exception e2) {
            TextUtils.recordMissingTechnology(techName);
            return;
        }
        m2.put(techName, techFactory);
    }

    private static void c(Map<String, TechFactory> m2, String techName, String techClassName) {
        m2.put(techName, new FromClass(techName, techClassName));
    }

    private static void r(Map<String, TechFactory> m2, String techName, String resourceName, boolean restricted) {
        assert (techName != null);
        URL url = Main.class.getResource(resourceName);
        if (url == null) {
            return;
        }
        m2.put(techName, new FromXml(techName, false, url, null));
        if (restricted) {
            sensitiveTechNames.add(techName);
        }
    }

    abstract Technology newInstanceImpl(Generic var1, Map<Param, Object> var2) throws Exception;

    public Xml.Technology getXml(Map<Param, Object> params) throws Exception {
        return this.getXml(params, null);
    }

    public abstract Xml.Technology getXml(Map<Param, Object> var1, Map<Object, Map<String, Object>> var2) throws Exception;

    static TechFactory read(IdReader reader) throws IOException {
        String techName = reader.readString();
        boolean userDefined = reader.readBoolean();
        if (!userDefined) {
            return TechFactory.getKnownTechs().get(techName);
        }
        boolean hasUrl = reader.readBoolean();
        URL xmlUrl = null;
        if (hasUrl) {
            xmlUrl = TextUtils.getURLFromString(reader.readString());
        }
        byte[] serializedXml = reader.readBytes();
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(serializedXml));
            Xml.Technology xmlTech = (Xml.Technology)in.readObject();
            in.close();
            return TechFactory.fromXml(xmlUrl, xmlTech);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return null;
        }
    }

    private static class FromXml
    extends TechFactory {
        private final boolean userDefined;
        private final URL urlXml;
        private Xml.Technology xmlTech;
        private boolean xmlParsed;

        private FromXml(String techName, boolean userDefined, URL urlXml, Xml.Technology xmlTech) {
            super(techName);
            this.userDefined = userDefined;
            this.urlXml = urlXml;
            this.xmlTech = xmlTech;
        }

        @Override
        Technology newInstanceImpl(Generic generic, Map<Param, Object> paramValues) throws Exception {
            assert (paramValues.isEmpty());
            Xml.Technology xml = this.getXml(paramValues);
            if (xml == null) {
                return null;
            }
            Class techClass = Technology.class;
            if (xml.className != null) {
                techClass = Class.forName(xml.className);
            }
            return (Technology)techClass.getConstructor(Generic.class, TechFactory.class, Map.class, Xml.Technology.class).newInstance(generic, this, Collections.emptyMap(), xml);
        }

        @Override
        String getDescription() {
            return this.urlXml == null ? "technology description" : "from " + this.urlXml.getFile();
        }

        @Override
        public Xml.Technology getXml(Map<Param, Object> paramValues, Map<Object, Map<String, Object>> additionalAttributes) throws Exception {
            assert (paramValues.isEmpty());
            if (this.xmlTech == null && !this.xmlParsed) {
                this.xmlTech = Xml.parseTechnology(this.urlXml);
                this.xmlParsed = true;
                if (this.xmlTech == null) {
                    throw new Exception("Can't load extra technology: " + String.valueOf(this.urlXml));
                }
                String xmlTechName = this.xmlTech.techName;
                if (!xmlTechName.equals(this.techName)) {
                    this.xmlTech = null;
                    throw new Exception("Tech name " + xmlTechName + " doesn't match " + this.techName + " in file:" + String.valueOf(this.urlXml));
                }
            }
            return this.xmlTech;
        }

        @Override
        void write(IdWriter writer) throws IOException {
            byte[] serializedXml;
            writer.writeString(this.techName);
            writer.writeBoolean(this.userDefined);
            if (!this.userDefined) {
                return;
            }
            boolean hasUrl = this.urlXml != null;
            writer.writeBoolean(hasUrl);
            if (hasUrl) {
                writer.writeString(this.urlXml.toString());
            }
            try {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(byteStream);
                out.writeObject(this.xmlTech);
                out.flush();
                serializedXml = byteStream.toByteArray();
            }
            catch (Throwable e2) {
                e2.printStackTrace();
                serializedXml = new byte[]{};
            }
            writer.writeBytes(serializedXml);
        }
    }

    public static class Param {
        public final String xmlPath;
        public final String prefPath;
        public final Object factoryValue;

        public Param(String xmlPath, String prefPath, Object factoryValue) {
            this.xmlPath = xmlPath;
            this.prefPath = prefPath;
            this.factoryValue = factoryValue;
        }

        public boolean equals(Object o2) {
            return o2 instanceof Param && this.xmlPath.equals(((Param)o2).xmlPath);
        }

        public int hashCode() {
            return this.xmlPath.hashCode();
        }

        public String toString() {
            return this.xmlPath;
        }
    }

    private static class FromClass
    extends TechFactory {
        private final String techClassName;

        private FromClass(String techName, String techClassName) {
            super(techName, Collections.emptyList());
            this.techClassName = techClassName;
        }

        @Override
        Technology newInstanceImpl(Generic generic, Map<Param, Object> paramValues) throws Exception {
            assert (paramValues.isEmpty());
            Class<?> techClass = Class.forName(this.techClassName);
            return (Technology)techClass.getConstructor(Generic.class, TechFactory.class).newInstance(generic, this);
        }

        @Override
        public Xml.Technology getXml(Map<Param, Object> params, Map<Object, Map<String, Object>> additionalAttributes) throws Exception {
            IdManager idManager = new IdManager();
            Generic generic = Generic.newInst(idManager);
            Technology tech = this.newInst(generic, params);
            return tech.makeXml(additionalAttributes);
        }

        @Override
        String getDescription() {
            return "from " + this.techClassName;
        }
    }

    private static class FromParamClass
    extends TechFactory {
        private final Method getPatchedXmlMethod;
        Constructor<?> techConstructor;

        private FromParamClass(String techName, Class<?> techClass, List<Param> techParams) throws Exception {
            super(techName, techParams);
            this.getPatchedXmlMethod = techClass.getMethod("getPatchedXml", Map.class);
            this.techConstructor = techClass.getConstructor(Generic.class, TechFactory.class, Map.class, Xml.Technology.class);
        }

        @Override
        Technology newInstanceImpl(Generic generic, Map<Param, Object> paramValues) throws Exception {
            Xml.Technology t = this.getXml(paramValues);
            if (t == null) {
                return null;
            }
            return (Technology)this.techConstructor.newInstance(generic, this, paramValues, t);
        }

        @Override
        public Xml.Technology getXml(Map<Param, Object> params, Map<Object, Map<String, Object>> additionalAttributes) throws Exception {
            return (Xml.Technology)this.getPatchedXmlMethod.invoke(null, params);
        }

        @Override
        String getDescription() {
            return "from " + this.getPatchedXmlMethod.getName();
        }
    }
}

