/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.util.TextUtils;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DRCTemplate
implements Serializable {
    public static final DRCTemplateSort templateSort = new DRCTemplateSort();
    public String ruleName;
    public int when;
    public DRCRuleType ruleType;
    public String name1;
    public String name2;
    public double[] values;
    public double maxWidth;
    public double minLength;
    public String nodeName;
    public int multiCuts;
    public String condition;

    public boolean isRuleIgnoredInPSubstrateProcess(boolean pSubstrateProcess) {
        if (!pSubstrateProcess) {
            return false;
        }
        if (this.ruleType == DRCRuleType.SPACING || this.ruleType == DRCRuleType.SPACINGE || this.ruleType == DRCRuleType.CONSPA || this.ruleType == DRCRuleType.UCONSPA) {
            return this.name1.toLowerCase().equals("p-well") && this.name2.toLowerCase().equals("p-well");
        }
        if (this.ruleType == DRCRuleType.MINAREA || this.ruleType == DRCRuleType.MINENCLOSEDAREA || this.ruleType == DRCRuleType.MINWID || this.ruleType == DRCRuleType.MINWIDCOND) {
            return this.name1.toLowerCase().equals("p-well");
        }
        return false;
    }

    private void copyValues(double[] vals) {
        int len = vals.length;
        assert (len == 1 || len == 2);
        this.values = new double[len];
        System.arraycopy(vals, 0, this.values, 0, len);
    }

    public int getNumValues() {
        return this.values.length;
    }

    public double getValue(int i2) {
        return this.values[i2];
    }

    public void setValue(int i2, double val) {
        assert (i2 < this.getNumValues());
        this.values[i2] = val;
    }

    public DRCTemplate(DRCTemplate rule) {
        this.ruleName = rule.ruleName;
        this.when = rule.when;
        this.ruleType = rule.ruleType;
        this.name1 = rule.name1;
        this.name2 = rule.name2;
        this.copyValues(rule.values);
        this.maxWidth = rule.maxWidth;
        this.minLength = rule.minLength;
        this.nodeName = rule.nodeName;
        this.multiCuts = rule.multiCuts;
        this.condition = rule.condition;
    }

    public DRCTemplate(String rule, int when, DRCRuleType ruleType, String name1, String name2, double[] vals, String nodeName, String condition) {
        this.ruleName = rule;
        this.when = when;
        this.ruleType = ruleType;
        this.name1 = name1;
        this.name2 = name2;
        this.copyValues(vals);
        this.nodeName = nodeName;
        this.condition = condition;
        this.multiCuts = -1;
        switch (ruleType.ordinal()) {
            case 5: {
                if (name1 != null && name2 != null) break;
                System.out.println("Error: missing one layer in no '" + rule + "' ");
                break;
            }
        }
    }

    public DRCTemplate(String rule, int when, DRCRuleType ruleType, double maxW, double minLen, double[] vals, int multiCut) {
        this.ruleName = rule;
        this.when = when;
        this.ruleType = ruleType;
        this.copyValues(vals);
        this.maxWidth = maxW;
        this.minLength = minLen;
        this.multiCuts = multiCut;
    }

    public DRCTemplate(String rule, int when, DRCRuleType ruleType, double maxW, double minLen, String name1, String name2, double[] vals, int multiCut) {
        this.ruleName = rule;
        this.when = when;
        this.ruleType = ruleType;
        this.name1 = name1;
        this.name2 = name2;
        this.copyValues(vals);
        this.maxWidth = maxW;
        this.minLength = minLen;
        this.multiCuts = multiCut;
        switch (ruleType.ordinal()) {
            case 5: {
                if (name1 != null && name2 != null) break;
                System.out.println("Error: missing one layer in no '" + rule + "' ");
                break;
            }
        }
    }

    public static DRCXMLParser importDRCDeck(URL fileURL, Xml.Technology tech, boolean verbose) {
        DRCXMLParser parser = new DRCXMLParser();
        parser.process(fileURL, tech, verbose);
        return parser;
    }

    public static String covertToXMLFormat(String orig) {
        if (orig == null) {
            return "";
        }
        orig = orig.replaceAll("&", "&amp;");
        orig = orig.replaceAll("<", "&lt;");
        orig = orig.replaceAll(">", "&gt;");
        orig = orig.replaceAll("\"", "&quot;");
        orig = orig.replaceAll("'", "&#39;");
        return orig;
    }

    public static void exportDRCDecks(String fileName, Technology tech) {
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.println("<!--");
            out.println("\t Document: DRC deck for " + String.valueOf(tech));
            out.println("\t Generated by: Electric (" + String.valueOf(Version.getVersion()) + ")");
            out.println("-->");
            out.println("<!DOCTYPE DRCRules SYSTEM \"DRC.dtd\">");
            out.println("<DRCRules>");
            Iterator<Foundry> it = tech.getFoundries();
            while (it.hasNext()) {
                Foundry foundry = it.next();
                List<DRCTemplate> rules = foundry.getRules();
                out.println("    <Foundry name=\"" + DRCTemplate.covertToXMLFormat(foundry.getType().getName()) + "\">");
                for (DRCTemplate rule : rules) {
                    if (rule.ruleType == DRCRuleType.EXTENSIONGATE || rule.ruleType == DRCRuleType.CUTSURX || rule.ruleType == DRCRuleType.CUTSURY || rule.ruleType == DRCRuleType.SLOTSIZE) continue;
                    DRCTemplate.exportDRCRule(out, rule);
                }
                out.println("    </Foundry>");
            }
            out.println("</DRCRules>");
            out.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void exportDRCRule(PrintWriter out, DRCTemplate rule) {
        Object whenName = null;
        int when = 0;
        for (DRCMode p : DRCMode.values()) {
            if ((p.mode() & ~when) == 0 || (p.mode() & ~rule.when) != 0) continue;
            whenName = whenName == null ? "" : (String)whenName + "|";
            whenName = (String)whenName + String.valueOf((Object)p);
            when |= p.mode();
        }
        assert (when == rule.when);
        if (whenName == null) {
            whenName = DRCMode.ALL.name();
        }
        Object condition = "";
        String ruleName = DRCTemplate.covertToXMLFormat(rule.ruleName);
        String name1 = DRCTemplate.covertToXMLFormat(rule.name1);
        String name2 = DRCTemplate.covertToXMLFormat(rule.name2);
        String cond = DRCTemplate.covertToXMLFormat(rule.condition);
        String nodeName = DRCTemplate.covertToXMLFormat(rule.nodeName);
        switch (rule.ruleType.ordinal()) {
            case 2: {
                condition = " condition=\"" + cond + "\"";
            }
            case 1: 
            case 13: 
            case 14: {
                out.println("        <LayerRule ruleName=\"" + ruleName + "\" layerName=\"" + name1 + "\" type=\"" + String.valueOf((Object)rule.ruleType) + "\"" + (String)condition + " when=\"" + (String)whenName + "\" value=\"" + rule.getValue(0) + "\"/>");
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 17: {
                if (rule.condition != null) {
                    condition = " condition=\"" + cond + "\"";
                }
                Object noName = rule.nodeName != null ? " nodeName=\"" + nodeName + "\"" : "";
                String wideValues = rule.maxWidth > 0.0 ? " maxW=\"" + rule.maxWidth + "\" minLen=\"" + rule.minLength + "\"" : "";
                out.println("        <LayersRule ruleName=\"" + ruleName + "\" layerNames=\"{" + name1 + "," + name2 + "}\" type=\"" + String.valueOf((Object)rule.ruleType) + "\" when=\"" + (String)whenName + "\" value=\"" + rule.getValue(0) + "\"" + wideValues + (String)noName + (String)condition + "/>");
                break;
            }
            case 4: 
            case 12: {
                String ruleType = "NodeLayersRule";
                String value = " value=\"" + rule.getValue(0) + "\"";
                String layersName = " layerNames=\"{" + name1 + "," + name2 + "}\"";
                if (rule.getValue(0) != rule.getValue(1)) {
                    value = " valueX=\"" + rule.getValue(0) + "\" valueY=\"" + rule.getValue(1) + "\"";
                }
                Object noName = " nodeName=\"" + nodeName + "\"";
                if (rule.name2 == null) {
                    noName = "";
                    ruleType = "LayerRule";
                    layersName = " layerName=\"" + name1 + "\" condition=\"" + cond + "\"";
                } else if (rule.nodeName == null) {
                    noName = "";
                    ruleType = "LayersRule";
                }
                out.println("        <" + ruleType + " ruleName=\"" + ruleName + "\"" + layersName + " type=\"" + String.valueOf((Object)rule.ruleType) + "\" when=\"" + (String)whenName + "\"" + value + (String)noName + "/>");
                break;
            }
            case 3: {
                String value = " value=\"" + rule.getValue(0) + "\"";
                if (rule.getValue(0) != rule.getValue(1)) {
                    value = " valueX=\"" + rule.getValue(0) + "\" valueY=\"" + rule.getValue(1) + "\"";
                }
                out.println("        <NodeRule ruleName=\"" + ruleName + "\" type=\"" + String.valueOf((Object)rule.ruleType) + "\" when=\"" + (String)whenName + "\"" + value + " nodeName=\"" + nodeName + "\"/>");
                break;
            }
            case 16: {
                if (rule.nodeName != null) {
                    out.println("        <NodeRule ruleName=\"" + ruleName + "\" type=\"" + String.valueOf((Object)rule.ruleType) + "\" when=\"" + (String)whenName + "\" nodeName=\"" + nodeName + "\"/>");
                    break;
                }
                out.println("        <LayersRule ruleName=\"" + ruleName + "\" layerNames=\"{" + name1 + "," + name2 + "}\" type=\"" + String.valueOf((Object)rule.ruleType) + "\" when=\"" + (String)whenName + "\"/>");
                break;
            }
            default: {
                assert (false);
                System.out.println("Case not implemented " + String.valueOf((Object)rule.ruleType));
            }
        }
    }

    public static String getSpacingCombinedName(Layer layer, Geometric geo) {
        String n1 = layer.getName() + "-";
        if (geo != null) {
            n1 = geo instanceof NodeInst ? n1 + ((NodeInst)geo).getProto().getName() : n1 + ((ArcInst)geo).getProto().getName();
        }
        return n1;
    }

    public static boolean parseXmlElement(List<DRCTemplate> drcRules, String qName, Attributes attributes, String localName) {
        System.out.println("Layer/Node names not checked");
        return DRCTemplate.parseXmlElement(drcRules, null, null, qName, attributes, localName);
    }

    public static boolean parseXmlElement(List<DRCTemplate> drcRules, Collection<String> layerNamesList, Collection<String> nodeNamesList, String qName, Attributes attributes, String localName) {
        boolean layerRule = qName.equals("LayerRule");
        boolean layersRule = qName.equals("LayersRule");
        boolean nodeLayersRule = qName.equals("NodeLayersRule");
        boolean nodeRule = qName.equals("NodeRule");
        if (!(layerRule || layersRule || nodeLayersRule || nodeRule)) {
            return false;
        }
        String ruleName = "";
        String layerNames = "";
        String nodeNames = null;
        String condition = null;
        int when = DRCMode.ALL.mode();
        DRCRuleType type = DRCRuleType.NONE;
        double[] values = new double[2];
        Double maxW = null;
        Double minLen = null;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (attributes.getQName(i2).equals("ruleName")) {
                ruleName = attributes.getValue(i2);
                continue;
            }
            if (attributes.getQName(i2).startsWith("layerName")) {
                layerNames = attributes.getValue(i2);
                continue;
            }
            if (attributes.getQName(i2).startsWith("nodeName")) {
                nodeNames = attributes.getValue(i2);
                continue;
            }
            if (attributes.getQName(i2).startsWith("condition")) {
                condition = attributes.getValue(i2);
                continue;
            }
            if (attributes.getQName(i2).equals("type")) {
                type = DRCRuleType.valueOf(attributes.getValue(i2));
                continue;
            }
            if (attributes.getQName(i2).equals("when")) {
                String[] modes;
                String[] stringArray = modes = TextUtils.parseString(attributes.getValue(i2), "|");
                int n2 = stringArray.length;
                for (int i3 = 0; i3 < n2; ++i3) {
                    String mode = stringArray[i3];
                    DRCMode m2 = DRCMode.valueOf(mode);
                    when |= m2.mode();
                }
                continue;
            }
            if (attributes.getQName(i2).equals("value")) {
                String value = attributes.getValue(i2);
                if (value.toLowerCase().equals("double.max_value")) {
                    values[1] = Double.MAX_VALUE;
                    values[0] = Double.MAX_VALUE;
                    continue;
                }
                try {
                    values[0] = values[1] = Double.parseDouble(value);
                    continue;
                }
                catch (Exception e2) {
                    System.out.println("Invalid attribute in DRCXMLParser: " + value + " is not a double in " + localName);
                    return false;
                }
            }
            if (attributes.getQName(i2).equals("valueX")) {
                values[0] = Double.parseDouble(attributes.getValue(i2));
                continue;
            }
            if (attributes.getQName(i2).equals("valueY")) {
                values[1] = Double.parseDouble(attributes.getValue(i2));
                continue;
            }
            if (attributes.getQName(i2).equals("maxW")) {
                maxW = Double.parseDouble(attributes.getValue(i2));
                continue;
            }
            if (attributes.getQName(i2).equals("minLen")) {
                minLen = Double.parseDouble(attributes.getValue(i2));
                continue;
            }
            System.out.println("Invalid attribute in DRCXMLParser in " + localName);
            return false;
        }
        if (layerRule) {
            String[] layers;
            for (String layer : layers = TextUtils.parseString(layerNames, "{,}")) {
                if (!layerNamesList.contains(layer)) {
                    System.out.println("Invalid layer '" + layer + "' in DRCXMLParser in " + localName);
                    return false;
                }
                if (nodeNames == null) {
                    tmp = new DRCTemplate(ruleName, when, type, layer, null, values, null, condition);
                    drcRules.add(tmp);
                    continue;
                }
                String[] names = TextUtils.parseString(nodeNames, ",");
                for (String name : names) {
                    if (!layerNamesList.contains(name)) {
                        System.out.println("Invalid node '" + name + "' in DRCXMLParser in " + localName);
                        return false;
                    }
                    DRCTemplate tmp = new DRCTemplate(ruleName, when, type, layer, null, values, name, null);
                    drcRules.add(tmp);
                }
            }
        } else if (nodeRule) {
            if (nodeNames == null) {
                DRCTemplate tmp = new DRCTemplate(ruleName, when, type, null, null, values, null, null);
                drcRules.add(tmp);
            } else {
                String[] names;
                for (String name : names = TextUtils.parseString(nodeNames, ",")) {
                    if (!nodeNamesList.contains(name)) {
                        System.out.println("Invalid node '" + name + "' in DRCXMLParser in " + localName);
                        return false;
                    }
                    tmp = new DRCTemplate(ruleName, when, type, null, null, values, name, null);
                    drcRules.add(tmp);
                }
            }
        } else if (layersRule || nodeLayersRule) {
            String[] layerPairs;
            for (String layerPair : layerPairs = TextUtils.parseString(layerNames, "{}")) {
                String[] names;
                String[] pair = TextUtils.parseString(layerPair, ",");
                if (pair.length != 2) continue;
                if (nodeNames == null) {
                    DRCTemplate tmp = maxW == null ? new DRCTemplate(ruleName, when, type, pair[0], pair[1], values, null, condition) : new DRCTemplate(ruleName, when, type, maxW, minLen, pair[0], pair[1], values, -1);
                    drcRules.add(tmp);
                    continue;
                }
                for (String name : names = TextUtils.parseString(nodeNames, ",")) {
                    DRCTemplate tmp = null;
                    if (maxW == null) {
                        tmp = new DRCTemplate(ruleName, when, type, pair[0], pair[1], values, name, null);
                    } else {
                        System.out.println("When do I have this case?");
                    }
                    drcRules.add(tmp);
                }
            }
        } else assert (false);
        return true;
    }

    public static enum DRCRuleType {
        NONE,
        MINWID,
        MINWIDCOND,
        NODSIZ,
        SURROUND,
        SPACING,
        SPACINGE,
        CONSPA,
        UCONSPA,
        UCONSPA2D,
        CUTSURX,
        CUTSURY,
        ASURROUND,
        MINAREA,
        MINENCLOSEDAREA,
        EXTENSION,
        FORBIDDEN,
        EXTENSIONGATE,
        SLOTSIZE,
        ALLOWEDANGLES,
        G0CPL,
        DIFFMASKSEP,
        DIAGONALVIA;

    }

    public static class DRCXMLParser {
        private List<DRCXMLBucket> rulesList = new ArrayList<DRCXMLBucket>();
        private DRCXMLBucket current = null;
        private boolean fullLoaded = true;
        private String fileName;
        private Collection<String> nodeNamesList = new ArrayList<String>();
        private Collection<String> layerNamesList = new ArrayList<String>();

        public List<DRCXMLBucket> getRules() {
            return this.rulesList;
        }

        public boolean isParseOK() {
            return this.fullLoaded;
        }

        protected boolean process(URL fileURL, Xml.Technology tech, boolean verbose) {
            this.fileName = TextUtils.getFileNameWithoutExtension(fileURL);
            this.nodeNamesList = tech.getNodeNames();
            this.layerNamesList = tech.getLayerNames();
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(true);
                SAXParser parser = factory.newSAXParser();
                URLConnection urlCon = fileURL.openConnection();
                InputStream inputStream = urlCon.getInputStream();
                if (verbose) {
                    System.out.println("Parsing XML file \"" + String.valueOf(fileURL) + "\"");
                }
                DRCXMLHandler handler = new DRCXMLHandler();
                parser.parse(inputStream, (DefaultHandler)handler);
                this.fullLoaded = handler.passed;
                if (verbose) {
                    System.out.println("End Parsing XML file ...");
                }
            }
            catch (Exception e2) {
                if (verbose) {
                    e2.printStackTrace();
                }
                this.fullLoaded = false;
            }
            return this.fullLoaded;
        }

        class DRCXMLHandler
        extends DefaultHandler {
            boolean passed = true;

            DRCXMLHandler() {
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
                URL fileURL = this.getClass().getResource("DRC.dtd");
                URLConnection urlCon = fileURL.openConnection();
                InputStream inputStream = urlCon.getInputStream();
                return new InputSource(inputStream);
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                if (qName.equals("DRCRules")) {
                    return;
                }
                if (qName.equals("Foundry")) {
                    DRCXMLParser.this.current = new DRCXMLBucket();
                    DRCXMLParser.this.rulesList.add(DRCXMLParser.this.current);
                    DRCXMLParser.this.current.foundry = attributes.getValue(0);
                    return;
                }
                if (!DRCTemplate.parseXmlElement(DRCXMLParser.this.current.drcRules, DRCXMLParser.this.layerNamesList, DRCXMLParser.this.nodeNamesList, qName, attributes, localName)) {
                    this.passed = false;
                }
            }

            @Override
            public void fatalError(SAXParseException e2) {
                System.out.println("Parser Fatal Error: '" + e2.getMessage() + "' in line " + e2.getLineNumber() + " in '" + DRCXMLParser.this.fileName + "'.");
                this.passed = false;
            }

            @Override
            public void warning(SAXParseException e2) {
                System.out.println("Parser Warning: '" + e2.getMessage() + "' in line " + e2.getLineNumber() + " in '" + DRCXMLParser.this.fileName + "'.");
            }

            @Override
            public void error(SAXParseException e2) {
                System.out.println("Parser Error: " + e2.getMessage() + "' in line " + e2.getLineNumber() + " in '" + DRCXMLParser.this.fileName + "'.");
                this.passed = false;
            }
        }
    }

    public static enum DRCMode {
        NONE(-1),
        ALL(0),
        M23(3),
        M2(1),
        M3(2),
        M456(28),
        M4(4),
        M56(24),
        M5(8),
        M6(16),
        M7(32768),
        M8(65536),
        M9(131072),
        AN(0x100000),
        AC(32),
        NAC(64),
        SV(128),
        NSV(256),
        DE(512),
        SU(1024),
        SC(2048);

        private final int mode;

        private DRCMode(int mode) {
            this.mode = mode;
        }

        public int mode() {
            return this.mode;
        }

        public String toString() {
            return this.name();
        }
    }

    public static class DRCTemplateSort
    implements Comparator<DRCTemplate> {
        @Override
        public int compare(DRCTemplate d1, DRCTemplate d2) {
            double bb2;
            double bb1 = d1.getValue(0);
            if (bb1 < (bb2 = d2.getValue(0))) {
                return -1;
            }
            if (bb1 > bb2) {
                return 1;
            }
            return 0;
        }
    }

    public static class DRCXMLBucket
    implements Serializable {
        public List<DRCTemplate> drcRules = new ArrayList<DRCTemplate>();
        public String foundry = Foundry.Type.NONE.getName();
    }
}

