/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.irsim;

import com.sun.electric.plugins.irsim.Config;
import com.sun.electric.plugins.irsim.Eval;
import com.sun.electric.plugins.irsim.NewRStep;
import com.sun.electric.plugins.irsim.SStep;
import com.sun.electric.plugins.irsim.SimAPI;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class Sim
implements SimAPI {
    private static final long MAX_TIME = 0xFFFFFFFFFFFFFFFL;
    public static final double SMALL = 1.0E-15;
    public static final double LARGE = 1.0E15;
    public static final double LIMIT = 1.0E8;
    public static final int NTTYPES = 4;
    static String[] transistorType = new String[]{"n-channel", "p-channel", "depletion", "resistor"};
    public static String vChars = "0XX1";
    public static String[] states = new String[]{"OFF", "ON", "UKNOWN", "WEAK"};
    public static final int MAX_ERRS = 20;
    private static final int MAX_PARALLEL = 30;
    public Node powerNode;
    public Node groundNode;
    public int numNodes;
    public int numAliases;
    private int[] numTrans = new int[4];
    private int[] numOred = new int[4];
    public Trans tCap = null;
    private int numErrors = 0;
    private List<Trans> readTransistorList;
    public Trans[] parallelTransistors = new Trans[30];
    private HistEnt lastHist;
    public int numEdges;
    public int numPunted;
    public int numConsPunted;
    public long maxTime;
    public long curDelta;
    public Node curNode;
    public long nEvent;
    public int tUnitDelay = 0;
    public long tDecay = 0L;
    private boolean parallelWarning = false;
    private HashMap<String, Node> nodeHash;
    private List<Node> nodeList;
    private int nodeIndexCounter;
    private boolean warnVdd;
    private boolean warnGnd;
    public int tReport = 0;
    private Eval theModel;
    private Config theConfig;
    SimAPI.Analyzer theAnalyzer;
    int irDebug;
    boolean isDelayedX;
    public boolean withDriven;

    public Node findNode(String name) {
        return this.nodeHash.get(this.theAnalyzer.canonicString(name));
    }

    private Node getNode(String name) {
        Node n2 = this.findNode(name);
        if (n2 != null) {
            if (!name.equals(n2.nName)) {
                boolean skip = false;
                if (name.equalsIgnoreCase("vdd")) {
                    skip = this.warnVdd;
                    this.warnVdd = true;
                }
                if (name.equalsIgnoreCase("gnd")) {
                    skip = this.warnGnd;
                    this.warnGnd = true;
                }
                if (!skip) {
                    System.out.println("Warning: Aliasing nodes '" + name + "' and '" + n2.nName + "'");
                }
            }
            while ((n2.nFlags & 4L) != 0L) {
                n2 = n2.nLink;
            }
            return n2;
        }
        n2 = new Node(this);
        ++this.numNodes;
        this.nodeHash.put(this.theAnalyzer.canonicString(name), n2);
        this.nodeList.add(n2);
        n2.nName = name;
        n2.nGateList = new ArrayList<Trans>();
        n2.nTermList = new ArrayList<Trans>();
        n2.nFlags = 0L;
        n2.nCap = 1.0E-5f;
        n2.vLow = (float)this.theConfig.lowThresh;
        n2.vHigh = (float)this.theConfig.highThresh;
        n2.setTime(0L);
        n2.tpLH = 0;
        n2.tpHL = 0;
        n2.setCause(null);
        n2.nLink = null;
        n2.events = null;
        n2.nPot = 1;
        n2.awPending = null;
        n2.head = new HistEnt();
        n2.head.next = this.lastHist;
        n2.head.hTime = 0L;
        n2.head.val = 1;
        n2.head.inp = false;
        n2.head.punt = false;
        n2.head.delay = 0;
        n2.head.rTime = 0;
        n2.curr = n2.head;
        return n2;
    }

    public List<Node> getNodeList() {
        return this.nodeList;
    }

    @Override
    public List<SimAPI.Node> getNodes() {
        return Collections.unmodifiableList(this.nodeList);
    }

    @Override
    public Node getGroundNode() {
        return this.groundNode;
    }

    @Override
    public Node getPowerNode() {
        return this.powerNode;
    }

    @Override
    public int getNumNodes() {
        return this.numNodes;
    }

    @Override
    public int getNumAliases() {
        return this.numAliases;
    }

    @Override
    public int getNumEdges() {
        return this.numEdges;
    }

    @Override
    public int getNumPunted() {
        return this.numPunted;
    }

    @Override
    public int getNumConsPunted() {
        return this.numConsPunted;
    }

    @Override
    public long getNumEvents() {
        return this.nEvent;
    }

    @Override
    public List<SimAPI.Trans> getShortedTransistors() {
        ArrayList<SimAPI.Trans> result = new ArrayList<SimAPI.Trans>();
        for (Trans t = this.tCap.getSTrans(); t != this.tCap; t = t.getSTrans()) {
            result.add(t);
        }
        return result;
    }

    @Override
    public int getReport() {
        return this.tReport;
    }

    @Override
    public void setReport(int mask) {
        this.tReport |= mask;
    }

    @Override
    public void clearReport() {
        this.tReport = 0;
    }

    @Override
    public long getMaxTime() {
        return this.maxTime;
    }

    @Override
    public long getCurDelta() {
        return this.curDelta;
    }

    @Override
    public void setCurDelta(long curDelta) {
        this.curDelta = curDelta;
    }

    @Override
    public void clearCurNode() {
        this.curNode = null;
    }

    @Override
    public void reInit() {
        this.getModel().reInit();
    }

    @Override
    public void backSimTime(long bTime, int isInc) {
        this.getModel().backSimTime(bTime, isInc);
    }

    @Override
    public void printPendingEvents() {
        this.getModel().printPendingEvents();
    }

    @Override
    public boolean step(long stopTime, Collection<SimAPI.Node> xInputs, Collection<SimAPI.Node> hInputs, Collection<SimAPI.Node> lInputs, Collection<SimAPI.Node> uInputs) {
        return this.getModel().step(stopTime, xInputs, hInputs, lInputs, uInputs);
    }

    @Override
    public long getLambdaCM() {
        return this.getConfig().lambdaCM;
    }

    @Override
    public long getDecay() {
        return this.tDecay;
    }

    @Override
    public void setDecay(long decay) {
        this.tDecay = decay;
    }

    @Override
    public int getUnitDelay() {
        return this.tUnitDelay;
    }

    @Override
    public void setUnitDelay(int unitDelay) {
        this.tUnitDelay = unitDelay;
    }

    @Override
    public void setDebug(int irDebug) {
        this.irDebug = irDebug;
    }

    public Sim(int irDebug, String steppingModel, boolean isDelayedX) {
        this.irDebug = irDebug;
        this.isDelayedX = isDelayedX;
        if (steppingModel.equals("Linear")) {
            this.theModel = new SStep(this);
        } else {
            if (!steppingModel.equals("RC")) {
                System.out.println("Unknown stepping model: " + steppingModel + " using RC");
            }
            this.theModel = new NewRStep(this);
        }
        this.theConfig = new Config();
    }

    @Override
    public void loadConfig(URL parameterURL, SimAPI.Analyzer analyzer) {
        this.theConfig.loadConfig(parameterURL, analyzer);
    }

    @Override
    public void setAnalyzer(SimAPI.Analyzer analyzer) {
        this.theAnalyzer = analyzer;
    }

    public Config getConfig() {
        return this.theConfig;
    }

    public Eval getModel() {
        return this.theModel;
    }

    @Override
    public void setModel(boolean rc) {
        this.theModel = rc ? new NewRStep(this) : new SStep(this);
        this.theModel.initEvent();
    }

    private void badArgCount(String fileName, LineNumberReader lineReader, String[] strings) {
        Sim.reportError(fileName, lineReader.getLineNumber(), "Wrong number of args for '" + strings[0] + "'");
        for (int i2 = 0; i2 < strings.length; ++i2) {
            System.out.print(" " + strings[i2]);
        }
        System.out.println();
        this.checkErrs(fileName);
    }

    public static void reportError(String filename, int lineno, String msg) {
        System.out.println("(" + filename + "," + lineno + "): " + msg);
    }

    private boolean checkErrs(String fileName) {
        ++this.numErrors;
        if (this.numErrors > 20) {
            System.out.println("Too many errors in sim file <" + fileName + ">");
            return true;
        }
        return false;
    }

    static double deltaToNS(long d2) {
        return (double)d2 / 1000.0;
    }

    static double deltaToPS(long d2) {
        return (double)(d2 * 1000L) / 1000.0;
    }

    static long nsToDelta(double d2) {
        return (long)(d2 * 1000.0);
    }

    static long psToDelta(double d2) {
        return (long)(d2 / 1000.0 * 1000.0);
    }

    static double psToNS(double d2) {
        return d2 * 0.001;
    }

    static Node otherNode(Trans t, Node n2) {
        return t.drain == n2 ? t.source : t.drain;
    }

    static int baseType(int t) {
        return t & 7;
    }

    static int inputNumber(int flg) {
        return (flg & 0x7000) >> 12;
    }

    static double combine(double r1, double r2) {
        return r1 * r2 / (r1 + r2);
    }

    private Node connectTransistors() {
        Node ndList = null;
        for (Trans t : this.readTransistorList) {
            Node gate = null;
            Node src = null;
            Node drn = null;
            gate = (Node)t.gate;
            while ((gate.nFlags & 4L) != 0L) {
                gate = gate.nLink;
            }
            src = t.source;
            while ((src.nFlags & 4L) != 0L) {
                src = src.nLink;
            }
            drn = t.drain;
            while ((drn.nFlags & 4L) != 0L) {
                drn = drn.nLink;
            }
            t.gate = gate;
            t.source = src;
            t.drain = drn;
            byte type = t.tType;
            t.state = (byte)((type & 2) != 0 ? 3 : 2);
            t.tFlags = 0;
            int n2 = Sim.baseType(type);
            this.numTrans[n2] = this.numTrans[n2] + 1;
            if (src == drn || (src.nFlags & drn.nFlags & 2L) != 0L) {
                t.tType = (byte)(t.tType | 0x80);
                t.setDTrans(this.tCap);
                t.setSTrans(this.tCap.getSTrans());
                this.tCap.getSTrans().setDTrans(t);
                this.tCap.setSTrans(t);
                ++this.tCap.x;
                continue;
            }
            if ((t.tType & 2) == 0) {
                ((Node)t.gate).nGateList.add(t);
            }
            if ((src.nFlags & 2L) == 0L) {
                src.nTermList.add(t);
                ndList = this.linkToList(src, ndList);
            }
            if ((drn.nFlags & 2L) != 0L) continue;
            drn.nTermList.add(t);
            ndList = this.linkToList(drn, ndList);
        }
        return ndList;
    }

    private Node linkToList(Node n2, Node list) {
        if ((n2.nFlags & 0x200L) == 0L) {
            n2.nFlags |= 0x200L;
            n2.setNext(list);
            list = n2;
        }
        return list;
    }

    private void nodeInfo(String[] targ, String fileName, LineNumberReader lineReader) {
        if (targ.length != 8) {
            this.badArgCount(fileName, lineReader, targ);
            return;
        }
        Node n2 = this.getNode(targ[1]);
        n2.nCap = (float)((double)n2.nCap + (this.theAnalyzer.atof(targ[4]) * (this.theConfig.CMA * this.theConfig.lambdaSquared) + this.theAnalyzer.atof(targ[5]) * (this.theConfig.CPA * this.theConfig.lambdaSquared) + this.theAnalyzer.atof(targ[6]) * (this.theConfig.CDA * this.theConfig.lambdaSquared) + this.theAnalyzer.atof(targ[7]) * 2.0 * (this.theConfig.CDP * this.theConfig.lambda)));
    }

    private void nNodeInfo(String[] targ, String fileName, LineNumberReader lineReader) {
        if (targ.length != 14) {
            this.badArgCount(fileName, lineReader, targ);
            return;
        }
        Node n2 = this.getNode(targ[1]);
        n2.nCap = (float)((double)n2.nCap + (this.theAnalyzer.atof(targ[4]) * (this.theConfig.CM2A * this.theConfig.lambdaSquared) + this.theAnalyzer.atof(targ[5]) * 2.0 * (this.theConfig.CM2P * this.theConfig.lambda) + this.theAnalyzer.atof(targ[6]) * (this.theConfig.CMA * this.theConfig.lambdaSquared) + this.theAnalyzer.atof(targ[7]) * 2.0 * (this.theConfig.CMP * this.theConfig.lambda) + this.theAnalyzer.atof(targ[8]) * (this.theConfig.CPA * this.theConfig.lambdaSquared) + this.theAnalyzer.atof(targ[9]) * 2.0 * (this.theConfig.CPP * this.theConfig.lambda) + this.theAnalyzer.atof(targ[10]) * (this.theConfig.CDA * this.theConfig.lambda) + this.theAnalyzer.atof(targ[11]) * 2.0 * (this.theConfig.CDP * this.theConfig.lambda) + this.theAnalyzer.atof(targ[12]) * (this.theConfig.CPDA * this.theConfig.lambdaSquared) + this.theAnalyzer.atof(targ[13]) * 2.0 * (this.theConfig.CPDP * this.theConfig.lambda)));
    }

    private void newTrans(int implant, String[] targ, String fileName, LineNumberReader lineReader) {
        Trans t = new Trans();
        t.tType = (byte)implant;
        if (implant == 3) {
            if (targ.length != 4) {
                this.badArgCount(fileName, lineReader, targ);
                return;
            }
            t.gate = this.powerNode;
            t.source = this.getNode(targ[1]);
            t.drain = this.getNode(targ[2]);
            long length = (long)(this.theAnalyzer.atof(targ[3]) * (double)this.theConfig.lambdaCM);
            t.r = this.theConfig.rEquiv(implant, 0L, length);
        } else {
            if (targ.length != 11) {
                this.badArgCount(fileName, lineReader, targ);
                return;
            }
            t.gate = this.getNode(targ[1]);
            t.source = this.getNode(targ[2]);
            t.drain = this.getNode(targ[3]);
            long length = (long)(this.theAnalyzer.atof(targ[4]) * (double)this.theConfig.lambdaCM);
            long width = (long)(this.theAnalyzer.atof(targ[5]) * (double)this.theConfig.lambdaCM);
            if (width <= 0L || length <= 0L) {
                Sim.reportError(fileName, lineReader.getLineNumber(), "Bad transistor width=" + width + " or length=" + length);
                return;
            }
            ((Node)t.gate).nCap = (float)((double)((Node)t.gate).nCap + (double)(length * width) * this.theConfig.CTGA);
            t.r = this.theConfig.rEquiv(implant, width, length);
            t.x = this.theAnalyzer.atoi(targ[6]);
            t.y = this.theAnalyzer.atoi(targ[7]);
            for (int i2 = 8; i2 < targ.length; ++i2) {
                int aIsPos = targ[i2].indexOf("A_");
                int pIsPos = targ[i2].indexOf("P_");
                if (aIsPos < 0 || pIsPos < 0) continue;
                int a2 = this.theAnalyzer.atoi(targ[i2].substring(aIsPos + 2));
                int p = this.theAnalyzer.atoi(targ[i2].substring(pIsPos + 2));
                char type = targ[i2].charAt(0);
                int asrc = 0;
                int adrn = 0;
                int psrc = 0;
                int pdrn = 0;
                if (type == 's') {
                    asrc = a2;
                    psrc = p;
                } else if (type == 'd') {
                    adrn = a2;
                    pdrn = p;
                }
                if (implant == 1) {
                    t.source.nCap = (float)((double)t.source.nCap + ((double)asrc * this.theConfig.lambda * this.theConfig.lambda * this.theConfig.CPDA + (double)psrc * this.theConfig.lambda * this.theConfig.CPDP));
                    t.drain.nCap = (float)((double)t.drain.nCap + ((double)adrn * this.theConfig.lambda * this.theConfig.lambda * this.theConfig.CPDA + (double)pdrn * this.theConfig.lambda * this.theConfig.CPDP));
                    continue;
                }
                if (implant != 0 && implant != 2) continue;
                t.source.nCap = (float)((double)t.source.nCap + ((double)asrc * this.theConfig.lambda * this.theConfig.lambda * this.theConfig.CDA + (double)psrc * this.theConfig.lambda * this.theConfig.CDP));
                t.drain.nCap = (float)((double)t.drain.nCap + ((double)adrn * this.theConfig.lambda * this.theConfig.lambda * this.theConfig.CDA + (double)pdrn * this.theConfig.lambda * this.theConfig.CDP));
            }
        }
        this.readTransistorList.add(t);
    }

    private void alias(String[] targ, String fileName, LineNumberReader lineReader) {
        if (targ.length < 3) {
            this.badArgCount(fileName, lineReader, targ);
            return;
        }
        Node n2 = this.getNode(targ[1]);
        for (int i2 = 2; i2 < targ.length; ++i2) {
            Node m2 = this.getNode(targ[i2]);
            if (m2 == n2) continue;
            if ((m2.nFlags & 2L) != 0L) {
                Node swap = m2;
                m2 = n2;
                n2 = swap;
            }
            if ((m2.nFlags & 2L) != 0L) {
                Sim.reportError(fileName, lineReader.getLineNumber(), "Can't alias the power supplies");
                continue;
            }
            n2.nCap += m2.nCap;
            m2.nLink = n2;
            m2.nFlags |= 4L;
            m2.nCap = 0.0f;
            --this.numNodes;
            ++this.numAliases;
        }
    }

    private void nThresh(String[] targ, String fileName, LineNumberReader lineReader) {
        if (targ.length != 4) {
            this.badArgCount(fileName, lineReader, targ);
            return;
        }
        Node n2 = this.getNode(targ[1]);
        n2.vLow = (float)this.theAnalyzer.atof(targ[2]);
        n2.vHigh = (float)this.theAnalyzer.atof(targ[3]);
    }

    private void nDelay(String[] targ, String fileName, LineNumberReader lineReader) {
        if (targ.length != 4) {
            this.badArgCount(fileName, lineReader, targ);
            return;
        }
        Node n2 = this.getNode(targ[1]);
        n2.nFlags |= 8L;
        n2.tpLH = (short)Sim.nsToDelta(this.theAnalyzer.atof(targ[2]));
        n2.tpHL = (short)Sim.nsToDelta(this.theAnalyzer.atof(targ[3]));
    }

    private void nCap(String[] targ, String fileName, LineNumberReader lineReader) {
        if (targ.length == 3) {
            Node n2 = this.getNode(targ[1]);
            n2.nCap += (float)this.theAnalyzer.atof(targ[2]);
        } else if (targ.length == 4) {
            Node m2;
            float cap = (float)(this.theAnalyzer.atof(targ[3]) / 1000.0);
            Node n3 = this.getNode(targ[1]);
            if (n3 != (m2 = this.getNode(targ[2]))) {
                if (m2 != this.groundNode) {
                    m2.nCap += cap;
                }
                if (n3 != this.groundNode) {
                    n3.nCap += cap;
                }
            } else if (n3 == this.groundNode) {
                n3.nCap += cap;
            }
        } else {
            this.badArgCount(fileName, lineReader, targ);
        }
    }

    @Override
    public String[] parseLine(String line) {
        return Sim.parseLine(line, false, this.theAnalyzer);
    }

    public static String[] parseLine(String line, boolean expand, SimAPI.Analyzer analyzer) {
        StringTokenizer st = new StringTokenizer(line, " \t");
        int total = st.countTokens();
        String[] strings = new String[total];
        boolean iteratorFound = false;
        for (int i2 = 0; i2 < total; ++i2) {
            strings[i2] = st.nextToken();
            if (strings[i2].indexOf(123) < 0) continue;
            iteratorFound = true;
        }
        if (iteratorFound && expand) {
            int i3;
            ArrayList<String> listOfStrings = new ArrayList<String>();
            for (i3 = 0; i3 < total; ++i3) {
                if (!Sim.expand(strings[i3], listOfStrings, analyzer)) continue;
                System.out.println("Invalid iterator: " + strings[i3]);
                listOfStrings.add(strings[i3]);
            }
            strings = new String[listOfStrings.size()];
            for (i3 = 0; i3 < listOfStrings.size(); ++i3) {
                strings[i3] = (String)listOfStrings.get(i3);
            }
        }
        return strings;
    }

    private static boolean expand(String arg, List<String> expanded, SimAPI.Analyzer analyzer) {
        int itStart = arg.indexOf(123);
        if (itStart < 0) {
            expanded.add(arg);
            return false;
        }
        int itEnd = arg.indexOf(125, itStart);
        if (itEnd < 0) {
            return true;
        }
        String iterator = arg.substring(itStart + 1, itEnd);
        int firstColon = iterator.indexOf(58);
        if (firstColon < 0) {
            return true;
        }
        int secondColon = iterator.indexOf(58, firstColon);
        int start = analyzer.atoi(iterator);
        int stop = analyzer.atoi(iterator.substring(firstColon + 1));
        int step = 1;
        if (secondColon >= 0) {
            step = analyzer.atoi(iterator.substring(secondColon + 1));
        }
        if (step == 0) {
            step = 1;
        } else if (step < 0) {
            step = -step;
        }
        if (start > stop) {
            step = -step;
        }
        String prefix = arg.substring(0, itStart);
        String suffix = arg.substring(itEnd + 1);
        while (step > 0 && start <= stop || step < 0 && start >= stop) {
            String full = prefix + start + suffix;
            if (Sim.expand(full, expanded, analyzer)) {
                return true;
            }
            start += step;
        }
        return false;
    }

    @Override
    public void putTransistor(String gateName, String sourceName, String drainName, double gateLength, double gateWidth, double activeArea, double activePerim, double centerX, double centerY, boolean isNTypeTransistor) {
        Trans t = new Trans();
        t.gate = this.getNode(gateName);
        t.source = this.getNode(sourceName);
        t.drain = this.getNode(drainName);
        long length = (long)(gateLength * (double)this.theConfig.lambdaCM);
        long width = (long)(gateWidth * (double)this.theConfig.lambdaCM);
        if (width <= 0L || length <= 0L) {
            System.out.println("Bad transistor width=" + width + " or length=" + length);
            return;
        }
        t.x = (int)centerX;
        t.y = (int)centerY;
        ((Node)t.gate).nCap = (float)((double)((Node)t.gate).nCap + (double)(length * width) * this.theConfig.CTGA);
        if (isNTypeTransistor) {
            t.tType = 0;
            t.source.nCap = (float)((double)t.source.nCap + (activeArea * this.theConfig.lambda * this.theConfig.lambda * this.theConfig.CDA + activePerim * this.theConfig.lambda * this.theConfig.CDP));
            t.drain.nCap = (float)((double)t.drain.nCap + (activeArea * this.theConfig.lambda * this.theConfig.lambda * this.theConfig.CDA + activePerim * this.theConfig.lambda * this.theConfig.CDP));
            t.r = this.theConfig.rEquiv(0, width, length);
        } else {
            t.tType = 1;
            t.source.nCap = (float)((double)t.source.nCap + (activeArea * this.theConfig.lambda * this.theConfig.lambda * this.theConfig.CPDA + activePerim * this.theConfig.lambda * this.theConfig.CPDP));
            t.drain.nCap = (float)((double)t.drain.nCap + (activeArea * this.theConfig.lambda * this.theConfig.lambda * this.theConfig.CPDA + activePerim * this.theConfig.lambda * this.theConfig.CPDP));
            t.r = this.theConfig.rEquiv(1, width, length);
        }
        this.readTransistorList.add(t);
    }

    @Override
    public void putResistor(String net1, String net2, double resistance) {
        Trans t = new Trans();
        t.tType = (byte)3;
        t.gate = this.powerNode;
        t.source = this.getNode(net1);
        t.drain = this.getNode(net2);
        t.r = this.theConfig.rEquiv(3, 0L, (long)(resistance * (double)this.theConfig.lambdaCM));
        this.readTransistorList.add(t);
    }

    @Override
    public void putCapacitor(String net1, String net2, double capacitance) {
        Node m2;
        float cap = (float)(capacitance / 1000.0);
        Node n2 = this.getNode(net1);
        if (n2 != (m2 = this.getNode(net2))) {
            if (m2 != this.groundNode) {
                m2.nCap += cap;
            }
            if (n2 != this.groundNode) {
                n2.nCap += cap;
            }
        } else if (n2 == this.groundNode) {
            n2.nCap += cap;
        }
    }

    @Override
    public int inputSim(Reader simReader, String fileName) throws IOException {
        String line;
        boolean rError = false;
        boolean aError = false;
        LineNumberReader lineReader = new LineNumberReader(simReader);
        block15: while ((line = lineReader.readLine()) != null) {
            String[] targ = Sim.parseLine(line, false, this.theAnalyzer);
            if (targ.length == 0) continue;
            char firstCh = targ[0].charAt(0);
            switch (firstCh) {
                case '|': {
                    double lmbd;
                    if (lineReader.getLineNumber() > 1) break;
                    if (targ.length >= 2 && (lmbd = this.theAnalyzer.atof(targ[2]) / 100.0) != this.theConfig.lambda) {
                        System.out.println("WARNING: sim file lambda (" + lmbd + "u) != config lambda (" + this.theConfig.lambda + "u), using config lambda");
                    }
                    if (targ.length < 6 || this.theConfig.CDA != 0.0 && this.theConfig.CDP != 0.0 && this.theConfig.CPDA != 0.0 && this.theConfig.CPDP != 0.0) continue block15;
                    System.out.println("Warning: missing area/perim cap values are zero");
                    break;
                }
                case 'e': 
                case 'n': {
                    this.newTrans(0, targ, fileName, lineReader);
                    break;
                }
                case 'p': {
                    this.newTrans(1, targ, fileName, lineReader);
                    break;
                }
                case 'd': {
                    this.newTrans(2, targ, fileName, lineReader);
                    break;
                }
                case 'r': {
                    this.newTrans(3, targ, fileName, lineReader);
                    break;
                }
                case 'N': {
                    this.nodeInfo(targ, fileName, lineReader);
                    break;
                }
                case 'M': {
                    this.nNodeInfo(targ, fileName, lineReader);
                    break;
                }
                case 'C': 
                case 'c': {
                    this.nCap(targ, fileName, lineReader);
                    break;
                }
                case '=': {
                    this.alias(targ, fileName, lineReader);
                    break;
                }
                case 't': {
                    this.nThresh(targ, fileName, lineReader);
                    break;
                }
                case 'D': {
                    this.nDelay(targ, fileName, lineReader);
                    break;
                }
                case 'R': {
                    if (rError) continue block15;
                    System.out.println(fileName + "Ignoring lumped-resistance ('R' construct)");
                    rError = true;
                    break;
                }
                case 'A': {
                    if (aError) continue block15;
                    System.out.println(fileName + "Ignoring attribute-line ('A' construct)");
                    aError = true;
                    break;
                }
                default: {
                    Sim.reportError(fileName, lineReader.getLineNumber(), "Unrecognized input line (" + targ[0] + ")");
                    if (!this.checkErrs(fileName)) continue block15;
                    return this.numErrors;
                }
            }
        }
        return this.numErrors;
    }

    @Override
    public void initNetwork() {
        this.readTransistorList = new ArrayList<Trans>();
        this.nodeHash = new HashMap();
        this.nodeList = new ArrayList<Node>();
        this.nodeIndexCounter = 1;
        this.warnGnd = false;
        this.warnVdd = false;
        this.maxTime = 0xFFFFFFFFFFFFFFFL;
        for (int i2 = 0; i2 < 4; ++i2) {
            this.numTrans[i2] = 0;
        }
        this.numAliases = 0;
        this.numNodes = 0;
        this.initHist();
        this.numEdges = 0;
        this.numPunted = 0;
        this.numConsPunted = 0;
        this.powerNode = this.getNode("Vdd");
        this.powerNode.nPot = (short)3;
        this.powerNode.nFlags |= 0x12L;
        this.powerNode.head.inp = true;
        this.powerNode.head.val = (byte)3;
        this.powerNode.head.punt = false;
        this.powerNode.head.hTime = 0L;
        this.powerNode.head.delay = 0;
        this.powerNode.head.rTime = 0;
        this.powerNode.head.next = this.lastHist;
        this.powerNode.curr = this.powerNode.head;
        this.groundNode = this.getNode("Gnd");
        this.groundNode.nPot = 0;
        this.groundNode.nFlags |= 0x12L;
        this.groundNode.head.inp = true;
        this.groundNode.head.val = 0;
        this.groundNode.head.punt = false;
        this.groundNode.head.hTime = 0L;
        this.groundNode.head.delay = 0;
        this.groundNode.head.rTime = 0;
        this.groundNode.head.next = this.lastHist;
        this.groundNode.curr = this.groundNode.head;
        this.tCap = new Trans();
        this.tCap.source = null;
        this.tCap.drain = null;
        this.tCap.setSTrans(this.tCap);
        this.tCap.setDTrans(this.tCap);
        this.tCap.x = 0;
        this.numErrors = 0;
    }

    @Override
    public void finishNetwork() {
        this.connectNetwork();
        Collections.sort(this.getNodeList(), new NodesByName());
        this.theModel.initEvent();
    }

    @Override
    public double getLambda() {
        return this.theConfig.lambda;
    }

    private void connectNetwork() {
        Node ndList = this.connectTransistors();
        this.makeParallel(ndList);
        String infstr = this.numNodes + " nodes";
        if (this.numAliases != 0) {
            infstr = infstr + ", " + this.numAliases + " aliases";
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this.numTrans[i2] == 0) continue;
            infstr = infstr + ", " + this.numTrans[i2] + " " + transistorType[i2] + " transistors";
            if (this.numOred[i2] == 0) continue;
            infstr = infstr + " (" + this.numOred[i2] + " parallel)";
        }
        if (this.tCap.x != 0) {
            infstr = infstr + " (" + this.tCap.x + " shorted)";
        }
        System.out.println(infstr);
    }

    public void buildConnList(Node n2) {
        int nPar = 0;
        n2.nFlags &= 0xFFFFFFFFFFFFFDFFL;
        this.withDriven = false;
        Node next = n2;
        Node thisOne = n2.nLink = n2;
        do {
            for (Trans t : thisOne.nTermList) {
                if (t.state == 0) continue;
                if ((t.tFlags & 1) != 0) {
                    t.tFlags = (byte)(t.tFlags & 0xFFFFFFFE);
                    continue;
                }
                t.setSThev(null);
                t.setDThev(null);
                Node other = Sim.otherNode(t, thisOne);
                if ((other.nFlags & 0x10L) != 0L) {
                    this.withDriven = true;
                    continue;
                }
                t.tFlags = (byte)(t.tFlags | 1);
                if (other.nLink == null) {
                    other.nFlags &= 0xFFFFFFFFFFFFFDFFL;
                    other.nLink = n2;
                    next.nLink = other;
                    next = other;
                    other.setTrans(t);
                    continue;
                }
                if (!(this.theModel instanceof NewRStep)) continue;
                if (other.getTrans().hashTerms() == t.hashTerms()) {
                    Trans tran = other.getTrans();
                    if ((tran.tFlags & 8) != 0) {
                        t.setDTrans(this.parallelTransistors[tran.nPar]);
                    } else {
                        if (nPar >= 30) {
                            if (!this.parallelWarning) {
                                System.out.println("There are too many transistors in parallel (> 30)");
                                System.out.println("Simulation results may be inaccurate, to fix this you may have to");
                                System.out.println("increase 'MAX_PARALLEL' in 'Sim.java'.");
                                System.out.println("Note: This condition often occurs when Vdd or Gnd are not connected to all cells.");
                                if (thisOne.nName != null && other.nName != null) {
                                    System.out.println("      Check the vicinity of the following 2 nodes: " + thisOne.nName + " " + other.nName);
                                }
                                this.parallelWarning = true;
                            }
                            t.tFlags = (byte)(t.tFlags | 4);
                            continue;
                        }
                        tran.nPar = (byte)nPar++;
                        tran.tFlags = (byte)(tran.tFlags | 8);
                    }
                    this.parallelTransistors[tran.nPar] = t;
                    t.tFlags = (byte)(t.tFlags | 4);
                    continue;
                }
                t.tFlags = (byte)(t.tFlags | 2);
            }
        } while ((thisOne = thisOne.nLink) != n2);
        next.nLink = null;
    }

    private void initHist() {
        HistEnt dummy;
        dummy.next = this.lastHist = (dummy = new HistEnt());
        dummy.hTime = this.maxTime;
        dummy.val = 1;
        dummy.inp = true;
        dummy.punt = false;
        dummy.rTime = 0;
        dummy.delay = 0;
    }

    public void addHist(Node node, int value, boolean inp, long time, long delay, long rTime) {
        ++this.numEdges;
        HistEnt curr = node.curr;
        while (curr.next.punt) {
            curr = curr.next;
        }
        HistEnt newH = new HistEnt();
        if (newH == null) {
            return;
        }
        newH.next = curr.next;
        newH.hTime = time;
        newH.val = (byte)value;
        newH.inp = inp;
        newH.punt = false;
        newH.delay = (short)delay;
        newH.rTime = (short)rTime;
        node.curr = curr.next = newH;
    }

    public void addPunted(Node node, Eval.Event ev, long tim) {
        HistEnt h2 = node.curr;
        ++this.numPunted;
        HistEnt newP = new HistEnt();
        newP.hTime = ev.nTime;
        newP.val = ev.eval;
        newP.inp = false;
        newP.punt = true;
        newP.delay = (short)ev.delay;
        newP.rTime = ev.rTime;
        newP.pTime = (short)(newP.hTime - tim);
        if (h2.next.punt) {
            ++this.numConsPunted;
            do {
                h2 = h2.next;
            } while (h2.next.punt);
        }
        newP.next = h2.next;
        h2.next = newP;
    }

    @Override
    public void backToTime(SimAPI.Node nd_) {
        Node nd = (Node)nd_;
        if ((nd.nFlags & 0x404L) != 0L) {
            return;
        }
        HistEnt h2 = nd.head;
        HistEnt p = h2.getNextHist();
        while (p.hTime < this.curDelta) {
            h2 = p;
            p = p.getNextHist();
        }
        nd.curr = h2;
        p = h2;
        h2 = p.next;
        while (true) {
            if (h2.punt) {
                long puntTime = h2.hTime - (long)h2.pTime;
                if (puntTime >= this.curDelta) {
                    qTime = h2.hTime - (long)h2.delay;
                    if (qTime < this.curDelta) {
                        long tmp = this.curDelta;
                        this.curDelta = qTime;
                        this.theModel.enqueueEvent(nd, h2.val, h2.delay, h2.rTime);
                        this.curDelta = tmp;
                    }
                    p.next = h2.next;
                    h2 = p;
                }
            } else {
                qTime = h2.hTime - (long)h2.delay;
                if (qTime >= this.curDelta) break;
                long tmp = this.curDelta;
                this.curDelta = qTime;
                this.theModel.enqueueEvent(nd, h2.val, h2.delay, h2.rTime);
                this.curDelta = tmp;
                p.next = h2.next;
                h2 = p;
            }
            p = h2;
            h2 = h2.next;
        }
        p.next = this.lastHist;
        p = h2;
        if (p != this.lastHist) {
            while (h2.next != this.lastHist) {
                h2 = h2.next;
            }
        }
        h2 = nd.curr;
        nd.nPot = h2.val;
        nd.setTime(h2.hTime);
        if (h2.inp) {
            nd.nFlags |= 0x10L;
        }
        if (nd.nGateList.size() != 0) {
            for (Trans t : nd.nGateList) {
                t.state = (byte)this.theModel.computeTransState(t);
            }
        }
    }

    private void makeParallel(Node nList) {
        while (nList != null) {
            for (int l1 = 0; l1 < nList.nTermList.size(); ++l1) {
                Trans t1 = nList.nTermList.get(l1);
                byte type = t1.tType;
                if ((type & 0x28) != 0) continue;
                long hval = t1.hashTerms();
                for (int l2 = l1 + 1; l2 < nList.nTermList.size(); ++l2) {
                    Trans t2 = nList.nTermList.get(l2);
                    if (t1.gate != t2.gate || (long)t2.hashTerms() != hval || type != (t2.tType & 0xFFFFFFDF)) continue;
                    if ((t1.tType & 0x20) == 0) {
                        int oldDrainI;
                        int oldSourceI;
                        Trans t3 = new Trans();
                        t3.r = new Resists();
                        t3.r.dynRes[0] = t1.r.dynRes[0];
                        t3.r.dynRes[1] = t1.r.dynRes[1];
                        t3.r.rStatic = t1.r.rStatic;
                        t3.gate = t1.gate;
                        t3.source = t1.source;
                        t3.drain = t1.drain;
                        t3.tType = (byte)(t1.tType & 0xFFFFFFBF | 0x20);
                        t3.state = t1.state;
                        t3.tFlags = t1.tFlags;
                        t3.tLink = t1;
                        t1.setSTrans(null);
                        t1.setDTrans(t3);
                        int oldGateI = ((Node)t1.gate).nGateList.indexOf(t1);
                        if (oldGateI >= 0) {
                            ((Node)t1.gate).nGateList.set(oldGateI, t3);
                        }
                        if ((oldSourceI = t1.source.nTermList.indexOf(t1)) >= 0) {
                            t1.source.nTermList.set(oldSourceI, t3);
                        }
                        if ((oldDrainI = t1.drain.nTermList.indexOf(t1)) >= 0) {
                            t1.drain.nTermList.set(oldDrainI, t3);
                        }
                        t1.tType = (byte)(t1.tType | 0x40);
                        t1 = t3;
                        int n2 = Sim.baseType(t1.tType);
                        this.numOred[n2] = this.numOred[n2] + 1;
                    }
                    Resists r1 = t1.r;
                    Resists r2 = t2.r;
                    r1.rStatic = (float)Sim.combine(r1.rStatic, r2.rStatic);
                    r1.dynRes[0] = (float)Sim.combine(r1.dynRes[0], r2.dynRes[0]);
                    r1.dynRes[1] = (float)Sim.combine(r1.dynRes[1], r2.dynRes[1]);
                    ((Node)t2.gate).nGateList.remove(t2);
                    if (t2.source == nList) {
                        t2.drain.nTermList.remove(t2);
                    } else {
                        t2.source.nTermList.remove(t2);
                    }
                    nList.nTermList.remove(t2);
                    if ((t2.tType & 0x20) != 0) {
                        Trans t = t2.tLink;
                        while (t.getSTrans() != null) {
                            t.setDTrans(t1);
                            t = t.getSTrans();
                        }
                        t.setSTrans(t1.tLink);
                        t1.tLink = t2.tLink;
                        continue;
                    }
                    t2.tType = (byte)(t2.tType | 0x40);
                    t2.setDTrans(t1);
                    t2.setSTrans(t1.tLink);
                    t1.tLink = t2;
                    int n3 = Sim.baseType(t1.tType);
                    this.numOred[n3] = this.numOred[n3] + 1;
                }
            }
            nList.nFlags &= 0xFFFFFFFFFFFFFDFFL;
            nList = nList.getNext();
        }
    }

    public static class Node
    implements SimAPI.Node {
        Node nLink;
        Eval.Event events;
        List<Trans> nGateList;
        List<Trans> nTermList;
        float nCap;
        float vLow;
        float vHigh;
        short tpLH;
        short tpHL;
        private Object c;
        private Object t;
        private Object n;
        short nPot;
        long nFlags;
        String nName;
        HistEnt head = new HistEnt();
        HistEnt curr;
        short awPot;
        Runnable awPending;
        int index;
        HistEnt wind;
        HistEnt cursor;

        Node(Sim theSim) {
            this.index = theSim.nodeIndexCounter++;
        }

        void setTime(long time) {
            this.c = time;
        }

        void setNIndex(long nIndex) {
            this.c = nIndex;
        }

        void setCap(float cap) {
            this.c = Float.valueOf(cap);
        }

        void setEvent(Eval.Event event) {
            this.c = event;
        }

        void setCause(Node cause) {
            this.t = cause;
        }

        void setPunts(HistEnt punts) {
            this.t = punts;
        }

        void setThev(Thev thev) {
            this.n = thev;
        }

        @Override
        public void setNext(SimAPI.Node next) {
            this.n = (Node)next;
        }

        void setTrans(Trans trans) {
            this.n = trans;
        }

        @Override
        public long getTime() {
            return (Long)this.c;
        }

        long getNIndex() {
            return (Long)this.c;
        }

        float getCap() {
            return ((Float)this.c).floatValue();
        }

        Eval.Event getEvent() {
            return (Eval.Event)this.c;
        }

        @Override
        public Node getCause() {
            return (Node)this.t;
        }

        HistEnt getPunts() {
            return (HistEnt)this.t;
        }

        Thev getThev() {
            return (Thev)this.n;
        }

        @Override
        public Node getNext() {
            return (Node)this.n;
        }

        Trans getTrans() {
            return (Trans)this.n;
        }

        @Override
        public String getName() {
            return this.nName;
        }

        @Override
        public Node getLink() {
            return this.nLink;
        }

        @Override
        public short getPot() {
            return this.nPot;
        }

        @Override
        public char getPotChar() {
            return vChars.charAt(this.getPot());
        }

        @Override
        public long getFlags() {
            return this.nFlags;
        }

        @Override
        public long getFlags(long mask) {
            return this.nFlags & mask;
        }

        @Override
        public void setFlags(long mask) {
            this.nFlags |= mask;
        }

        @Override
        public void clearFlags(long mask) {
            this.nFlags &= mask ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Override
        public HistEnt getHead() {
            return this.head;
        }

        @Override
        public HistEnt getCurr() {
            return this.curr;
        }

        @Override
        public HistEnt getWind() {
            return this.wind;
        }

        @Override
        public HistEnt getCursor() {
            return this.cursor;
        }

        @Override
        public void setWind(SimAPI.HistEnt wind) {
            this.wind = (HistEnt)wind;
        }

        @Override
        public void setCursor(SimAPI.HistEnt cursor) {
            this.cursor = (HistEnt)cursor;
        }

        @Override
        public Collection<SimAPI.Trans> getGates() {
            return Collections.unmodifiableCollection(this.nGateList);
        }

        @Override
        public Collection<SimAPI.Trans> getTerms() {
            return Collections.unmodifiableCollection(this.nTermList);
        }

        @Override
        public String describeDelay() {
            Object infstr = "";
            if (this.getFlags(16L) != 0L) {
                infstr = (String)infstr + "[NOTE: node is an input] ";
            }
            infstr = (String)infstr + "(vl=" + this.vLow + " vh=" + this.vHigh + ") ";
            if (this.getFlags(8L) != 0L) {
                infstr = (String)infstr + "(tpLH=" + this.tpLH + ", tpHL=" + this.tpHL + ") ";
            }
            infstr = (String)infstr + "(" + this.nCap + " pf) ";
            return infstr;
        }

        @Override
        public String[] describePendingEvents() {
            if (this.events == null) {
                return null;
            }
            ArrayList<CallSite> list = new ArrayList<CallSite>();
            Eval.Event e2 = this.events;
            while (e2 != null) {
                list.add((CallSite)((Object)("   transition to " + vChars.charAt(e2.eval) + " at " + Sim.deltaToNS(e2.nTime) + "ns")));
                e2 = e2.nLink;
            }
            return list.toArray(new String[list.size()]);
        }

        @Override
        public Runnable getAssertWhen() {
            return this.awPending;
        }

        @Override
        public void setAssertWhen(Runnable aw) {
            this.awPending = aw;
        }

        @Override
        public void setAssertWhenPot(short pot) {
            this.awPot = pot;
        }
    }

    public static class HistEnt
    implements SimAPI.HistEnt {
        HistEnt next;
        short delay;
        short rTime;
        short pTime;
        long hTime;
        boolean inp;
        boolean punt;
        byte val;

        @Override
        public HistEnt getNextHist() {
            HistEnt p = this;
            HistEnt h2 = p.next;
            while (h2.punt) {
                h2 = h2.next;
            }
            return h2;
        }

        @Override
        public long getTime() {
            return this.hTime;
        }

        @Override
        public byte getVal() {
            return this.val;
        }
    }

    public static class Trans
    implements SimAPI.Trans {
        Object gate;
        Node source;
        Node drain;
        Object sCache;
        Object dCache;
        byte tType;
        byte state;
        byte tFlags;
        byte nPar;
        Resists r;
        Trans tLink;
        int x;
        int y;

        void setSThev(Thev r) {
            this.sCache = r;
        }

        void setDThev(Thev r) {
            this.dCache = r;
        }

        void setSTrans(Trans t) {
            this.sCache = t;
        }

        void setDTrans(Trans t) {
            this.dCache = t;
        }

        void setSI(int i2) {
            this.sCache = i2;
        }

        void setDI(int i2) {
            this.dCache = i2;
        }

        Thev getSThev() {
            return (Thev)this.sCache;
        }

        Thev getDThev() {
            return (Thev)this.dCache;
        }

        public Trans getSTrans() {
            return (Trans)this.sCache;
        }

        Trans getDTrans() {
            return (Trans)this.dCache;
        }

        int getSI() {
            return (Integer)this.sCache;
        }

        int getDI() {
            return (Integer)this.dCache;
        }

        int hashTerms() {
            return this.source.index ^ this.drain.index;
        }

        @Override
        public int getBaseType() {
            return this.tType & 7;
        }

        @Override
        public String describeBaseType() {
            return transistorType[this.getBaseType()];
        }

        @Override
        public String describeState() {
            return states[this.state];
        }

        @Override
        public Node getGate() {
            return (Node)this.gate;
        }

        @Override
        public Node getSource() {
            return this.source;
        }

        @Override
        public Node getDrain() {
            return this.drain;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public double[] getResists() {
            return new double[]{this.r.rStatic, this.r.dynRes[1], this.r.dynRes[0]};
        }

        @Override
        public long getLength() {
            return this.r.length;
        }

        @Override
        public long getWidth() {
            return this.r.width;
        }

        @Override
        public Node getOtherNode(SimAPI.Node n2) {
            return this.drain == n2 ? this.source : this.drain;
        }

        @Override
        public Trans getLink() {
            return this.tLink;
        }

        @Override
        public Collection<SimAPI.Trans> getGateList() {
            ArrayList<Trans> result = null;
            if ((this.tType & 8) != 0) {
                result = new ArrayList<Trans>();
                for (Trans t = (Trans)this.gate; t != null; t = t.getSTrans()) {
                    result.add(t);
                }
            }
            return result;
        }
    }

    public static class Resists
    extends TranResist {
        long width;
        long length;
    }

    private static class NodesByName
    implements Comparator<Node> {
        private NodesByName() {
        }

        @Override
        public int compare(Node n1, Node n2) {
            return n1.nName.compareToIgnoreCase(n2.nName);
        }
    }

    public static class Thev {
        Object link;
        int flags;
        Range cLow;
        Range cHigh;
        Range rUp;
        Range rDown;
        Range req;
        Range v;
        double rMin;
        double rDom;
        double rMax;
        double cA;
        double cD;
        double tauD;
        double tauA;
        double tauP;
        double tIn;
        short tpLH;
        short tpHL;
        char finall;
        char tauDone;
        char tauPDone;

        Thev() {
            this.cLow = new Range(0.0, 0.0);
            this.cHigh = new Range(0.0, 0.0);
            this.rUp = new Range(1.0E15, 1.0E15);
            this.rDown = new Range(1.0E15, 1.0E15);
            this.req = new Range(1.0E15, 1.0E15);
            this.v = new Range(1.0, 0.0);
            this.setN(null);
            this.flags = 0;
            this.rMin = 1.0E15;
            this.rDom = 1.0E15;
            this.rMax = 1.0E15;
            this.cA = 0.0;
            this.cD = 0.0;
            this.tauD = 0.0;
            this.tauA = 0.0;
            this.tauP = 0.0;
            this.tIn = 1.0E-15;
            this.tpLH = 0;
            this.tpHL = 0;
            this.finall = '\u0001';
            this.tauDone = (char)4;
            this.tauPDone = (char)4;
        }

        Thev(Thev old) {
            this.link = old.link;
            this.flags = old.flags;
            this.cLow = new Range(old.cLow);
            this.cHigh = new Range(old.cHigh);
            this.rUp = new Range(old.rUp);
            this.rDown = new Range(old.rDown);
            this.req = new Range(old.req);
            this.v = new Range(old.v);
            this.rMin = old.rMin;
            this.rDom = old.rDom;
            this.rMax = old.rMax;
            this.cA = old.cA;
            this.cD = old.cD;
            this.tauD = old.tauD;
            this.tauA = old.tauA;
            this.tauP = old.tauP;
            this.tIn = old.tIn;
            this.tpLH = old.tpLH;
            this.tpHL = old.tpHL;
            this.finall = old.finall;
            this.tauDone = old.tauDone;
            this.tauPDone = old.tauPDone;
        }

        void setT(Thev t) {
            this.link = t;
        }

        void setN(Node n2) {
            this.link = n2;
        }

        Thev getT() {
            return (Thev)this.link;
        }

        Node getN() {
            return (Node)this.link;
        }
    }

    public static class Range {
        double min;
        double max;

        Range() {
        }

        Range(double min, double max) {
            this.min = min;
            this.max = max;
        }

        Range(Range r) {
            this.min = r.min;
            this.max = r.max;
        }
    }

    private static class TranResist {
        float[] dynRes = new float[2];
        float rStatic;

        TranResist() {
        }
    }
}

