/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.irsim;

import com.sun.electric.plugins.irsim.Electric;
import com.sun.electric.plugins.irsim.Eval;
import com.sun.electric.plugins.irsim.Sim;

public class NewRStep
extends Eval {
    private static final int T_DEFINITE = 1;
    private static final int T_UDELAY = 2;
    private static final int T_SPIKE = 4;
    private static final int T_DRIVEN = 8;
    private static final int T_REFNODE = 16;
    private static final int T_XTRAN = 32;
    private static final int T_INT = 64;
    private static final int T_DOMDRIVEN = 128;
    private static final double NP_RATIO = 0.7;
    private static final int SPIKETBLSIZE = 10;
    private static final int NLSPKMIN = 0;
    private static final int NLSPKMAX = 1;
    private static final int LINEARSPK = 2;
    private Dominant[] domPot;
    private int incLevel;
    private Sim.Thev[] inputThev;
    private static float[][][] spikeTable = new float[][][]{new float[][]{{0.005f, 0.051f, 0.106f, 0.163f, 0.225f, 0.293f, 0.367f, 0.452f, 0.552f, 0.683f, 0.899f}, {0.005f, 0.051f, 0.105f, 0.162f, 0.223f, 0.288f, 0.36f, 0.441f, 0.537f, 0.661f, 0.852f}, {0.005f, 0.051f, 0.104f, 0.159f, 0.217f, 0.278f, 0.345f, 0.419f, 0.505f, 0.614f, 0.768f}, {0.005f, 0.051f, 0.102f, 0.154f, 0.208f, 0.265f, 0.325f, 0.39f, 0.464f, 0.555f, 0.676f}, {0.005f, 0.05f, 0.099f, 0.148f, 0.197f, 0.248f, 0.3f, 0.355f, 0.417f, 0.49f, 0.583f}, {0.005f, 0.049f, 0.096f, 0.14f, 0.184f, 0.226f, 0.27f, 0.315f, 0.363f, 0.419f, 0.487f}, {0.005f, 0.048f, 0.09f, 0.129f, 0.166f, 0.2f, 0.234f, 0.269f, 0.304f, 0.344f, 0.392f}, {0.005f, 0.046f, 0.083f, 0.114f, 0.142f, 0.168f, 0.192f, 0.216f, 0.24f, 0.266f, 0.295f}, {0.005f, 0.042f, 0.071f, 0.093f, 0.112f, 0.128f, 0.142f, 0.156f, 0.169f, 0.182f, 0.198f}, {0.005f, 0.033f, 0.05f, 0.061f, 0.069f, 0.076f, 0.081f, 0.086f, 0.09f, 0.093f, 0.099f}, {0.003f, 0.008f, 0.009f, 0.009f, 0.009f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f}}, new float[][]{{0.1f, 0.313f, 0.441f, 0.54f, 0.623f, 0.696f, 0.762f, 0.824f, 0.882f, 0.937f, 0.984f}, {0.097f, 0.292f, 0.404f, 0.489f, 0.56f, 0.624f, 0.682f, 0.736f, 0.789f, 0.83f, 0.893f}, {0.094f, 0.272f, 0.37f, 0.443f, 0.503f, 0.557f, 0.606f, 0.652f, 0.698f, 0.745f, 0.793f}, {0.091f, 0.252f, 0.337f, 0.398f, 0.449f, 0.494f, 0.534f, 0.573f, 0.612f, 0.652f, 0.694f}, {0.087f, 0.232f, 0.304f, 0.355f, 0.396f, 0.432f, 0.465f, 0.496f, 0.527f, 0.56f, 0.594f}, {0.083f, 0.209f, 0.269f, 0.31f, 0.342f, 0.37f, 0.396f, 0.42f, 0.444f, 0.468f, 0.496f}, {0.078f, 0.184f, 0.231f, 0.262f, 0.286f, 0.307f, 0.325f, 0.343f, 0.36f, 0.377f, 0.397f}, {0.071f, 0.155f, 0.189f, 0.21f, 0.227f, 0.241f, 0.253f, 0.264f, 0.275f, 0.286f, 0.298f}, {0.061f, 0.12f, 0.14f, 0.153f, 0.162f, 0.169f, 0.176f, 0.182f, 0.187f, 0.193f, 0.199f}, {0.045f, 0.073f, 0.081f, 0.085f, 0.088f, 0.091f, 0.093f, 0.095f, 0.096f, 0.098f, 0.1f}, {0.009f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f}}, new float[][]{{0.01f, 0.099f, 0.198f, 0.296f, 0.394f, 0.491f, 0.589f, 0.688f, 0.787f, 0.887f, 0.979f}, {0.01f, 0.095f, 0.185f, 0.272f, 0.357f, 0.441f, 0.525f, 0.61f, 0.699f, 0.792f, 0.887f}, {0.01f, 0.091f, 0.173f, 0.25f, 0.324f, 0.396f, 0.468f, 0.541f, 0.617f, 0.699f, 0.787f}, {0.01f, 0.087f, 0.162f, 0.23f, 0.294f, 0.355f, 0.416f, 0.477f, 0.541f, 0.61f, 0.688f}, {0.01f, 0.083f, 0.15f, 0.209f, 0.264f, 0.315f, 0.365f, 0.416f, 0.468f, 0.525f, 0.589f}, {0.01f, 0.078f, 0.137f, 0.188f, 0.233f, 0.275f, 0.315f, 0.355f, 0.396f, 0.441f, 0.491f}, {0.009f, 0.072f, 0.123f, 0.164f, 0.2f, 0.233f, 0.264f, 0.294f, 0.324f, 0.357f, 0.394f}, {0.009f, 0.065f, 0.106f, 0.138f, 0.164f, 0.188f, 0.209f, 0.23f, 0.25f, 0.272f, 0.296f}, {0.009f, 0.055f, 0.085f, 0.106f, 0.123f, 0.137f, 0.15f, 0.162f, 0.173f, 0.185f, 0.198f}, {0.008f, 0.039f, 0.055f, 0.065f, 0.072f, 0.078f, 0.083f, 0.087f, 0.091f, 0.095f, 0.099f}, {0.004f, 0.008f, 0.009f, 0.009f, 0.009f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f}}};
    private static float[][] delayTable = new float[][]{{9.12006f, 0.631441f, 0.257972f, 0.144287f, 0.09082f, 0.0601663f, 0.0403907f, 0.0265355f, 0.016153f, 0.00781327f, 9.32511E-4f}, {67.592f, 4.23025f, 1.67348f, 0.922844f, 0.578068f, 0.383611f, 0.259448f, 0.172782f, 0.10751f, 0.0540007f, 0.00710297f}, {119.421f, 7.15202f, 2.80304f, 1.54448f, 0.970528f, 0.647718f, 0.441433f, 0.29682f, 0.186968f, 0.0955642f, 0.0130529f}, {163.622f, 9.51381f, 3.72112f, 2.05847f, 1.30175f, 0.875381f, 0.6016f, 0.408196f, 0.259717f, 0.134386f, 0.0187625f}, {201.466f, 11.4592f, 4.49666f, 2.50681f, 1.59963f, 1.08575f, 0.753099f, 0.515657f, 0.331075f, 0.172965f, 0.0244792f}, {233.031f, 13.0456f, 5.16491f, 2.9136f, 1.88135f, 1.29123f, 0.904789f, 0.625272f, 0.404824f, 0.213117f, 0.030387f}, {257.614f, 14.2986f, 5.75449f, 3.30168f, 2.16446f, 1.50508f, 1.06642f, 0.743858f, 0.485264f, 0.256919f, 0.0366949f}, {273.495f, 15.2373f, 6.30568f, 3.70558f, 2.47626f, 1.74816f, 1.2534f, 0.8822f, 0.579179f, 0.307615f, 0.0437233f}, {276.873f, 15.9248f, 6.91424f, 4.20379f, 2.87725f, 2.06596f, 1.49889f, 1.06318f, 0.70076f, 0.371884f, 0.0521156f}, {257.71f, 16.7902f, 7.96238f, 5.07908f, 3.57464f, 2.60911f, 1.90987f, 1.35912f, 0.894002f, 0.470028f, 0.0637819f}, {196.679f, 25.771f, 13.8437f, 9.11648f, 6.44036f, 4.66063f, 3.35777f, 2.33745f, 1.49276f, 0.751022f, 0.0921218f}};

    public NewRStep(Sim sim) {
        super(sim);
        this.initThevs();
        this.theSim.tUnitDelay = 0;
        this.theSim.tDecay = 0L;
        this.domPot = new Dominant[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            this.domPot[i2] = new Dominant();
        }
    }

    @Override
    public void modelEvaluate(Sim.Node n2) {
        boolean changes;
        for (int i2 = 0; i2 <= 3; ++i2) {
            this.domPot[i2].nd = null;
            this.domPot[i2].spike = false;
        }
        if ((n2.nFlags & 0x200L) != 0L) {
            this.theSim.buildConnList(n2);
        }
        if (!(changes = this.computeDC(n2))) {
            this.cleanEvents(n2);
        } else if (this.theSim.withDriven) {
            this.scheduleDriven();
        } else {
            this.schedulePureCS(n2);
        }
        if (this.theSim.tDecay != 0L && !this.theSim.withDriven) {
            this.enqueDecay(n2);
        }
        this.undoConnList(n2);
    }

    private void cleanEvents(Sim.Node n2) {
        while (true) {
            Eval.Event ev;
            if ((ev = n2.events) != null) {
                this.puntEvent(n2, ev);
                continue;
            }
            n2 = n2.nLink;
            if (n2 == null) break;
        }
    }

    private void enqueDecay(Sim.Node n2) {
        do {
            Eval.Event ev;
            if (((ev = n2.events) == null ? n2.nPot : (short)ev.eval) == 1) continue;
            if ((this.theSim.irDebug & 1) != 0 && (n2.nFlags & 0x20L) != 0L) {
                System.out.println("  decay transition for " + n2.nName + " @ " + Sim.deltaToNS(this.theSim.curDelta + this.theSim.tDecay) + "ns");
            }
            this.enqueueEvent(n2, 4, this.theSim.tDecay, this.theSim.tDecay);
        } while ((n2 = n2.nLink) != null);
    }

    private void undoConnList(Sim.Node n2) {
        Sim.Node next = null;
        do {
            next = n2.nLink;
            n2.nLink = null;
            n2.getThev().setT(null);
            for (Sim.Trans t : n2.nTermList) {
                if (t.state == 0) continue;
                if ((t.tFlags & 6) == 0) {
                    Sim.Thev r = t.getSThev();
                    if (r != null) {
                        r.setT(null);
                    }
                    if ((r = t.getDThev()) != null) {
                        r.setT(null);
                    }
                }
                t.setSThev(null);
                t.setDThev(null);
                t.tFlags = (byte)(t.tFlags & 0xFFFFFFF0);
            }
        } while ((n2 = next) != null);
    }

    private void queueFVal(Sim.Node nd, int fVal, double tau, double delay) {
        boolean queued = false;
        long delta = this.theSim.curDelta + Sim.psToDelta(delay);
        if (delta == this.theSim.curDelta) {
            ++delta;
        }
        Eval.Event ev = null;
        while ((ev = nd.events) != null && ev.nTime >= delta && (ev.nTime != delta || ev.eval != fVal)) {
            this.puntEvent(nd, ev);
        }
        delta -= this.theSim.curDelta;
        if (fVal != (ev == null ? nd.nPot : (short)ev.eval)) {
            this.enqueueEvent(nd, fVal, delta, Sim.psToDelta(tau));
            queued = true;
        }
        if ((this.theSim.irDebug & 1) != 0 && (nd.nFlags & 0x20L) != 0L) {
            this.printFinal(nd, queued, tau, delta);
        }
    }

    private void queueSpike(Sim.Node nd, SpikeRec spk) {
        Eval.Event ev;
        while ((ev = nd.events) != null) {
            this.puntEvent(nd, ev);
        }
        if (spk == null) {
            return;
        }
        long chDelta = Sim.psToDelta(spk.chDelay);
        long drDelta = Sim.psToDelta(spk.drDelay);
        if (chDelta == 0L) {
            chDelta = 1L;
        }
        if (drDelta == 0L) {
            drDelta = 1L;
        }
        if ((this.theSim.irDebug & 1) != 0 && (nd.nFlags & 0x20L) != 0L) {
            this.printSpike(nd, spk, chDelta, drDelta);
        }
        if (drDelta <= chDelta) {
            return;
        }
        this.enqueueEvent(nd, spk.charge, chDelta, chDelta);
        this.enqueueEvent(nd, nd.nPot, drDelta, chDelta);
    }

    private void scheduleDriven() {
        for (int dom = 0; dom < 4; ++dom) {
            Sim.Thev r = null;
            Sim.Node nd = this.domPot[dom].nd;
            while (nd != null) {
                this.incLevel = (this.theSim.irDebug & 0x24) == 36 && (nd.nFlags & 0x20L) != 0L ? 1 : 0;
                r = this.getTau(nd, null, dom, this.incLevel);
                if (this.incLevel == 0 && (this.theSim.irDebug & 4) == 4 && (nd.nFlags & 0x20L) != 0L) {
                    this.printTau(nd, r, -1);
                }
                r.tauA = r.rDom * r.cA;
                r.tauD = r.rDom * r.cD;
                if ((r.flags & 4) == 0) {
                    double tau = 0.0;
                    double delay = 0.0;
                    if (nd.nPot == r.finall) {
                        Eval.Event ev;
                        while ((ev = nd.events) != null) {
                            this.puntEvent(nd, ev);
                        }
                    } else {
                        if (this.theSim.tUnitDelay != 0) {
                            delay = this.theSim.tUnitDelay;
                            tau = 0.0;
                        } else if ((r.flags & 2) != 0) {
                            switch (r.finall) {
                                case '\u0000': {
                                    tau = Sim.deltaToPS(r.tpHL);
                                    break;
                                }
                                case '\u0003': {
                                    tau = Sim.deltaToPS(r.tpLH);
                                    break;
                                }
                                case '\u0001': {
                                    tau = Sim.deltaToPS(Math.min(r.tpHL, r.tpLH));
                                }
                            }
                            delay = tau;
                        } else {
                            if (r.finall == '\u0001') {
                                if (this.theSim.isDelayedX) {
                                    double reff = r.rUp.min == r.rDown.min ? 1.0E8 : (r.rUp.min > r.rDown.min ? 1.0 / (1.0 / r.rDown.min - 1.0 / r.rUp.min) : 1.0 / (1.0 / r.rUp.min - 1.0 / r.rDown.min));
                                    tau = reff * r.cA;
                                } else {
                                    tau = r.rMin * r.cA;
                                }
                            } else {
                                tau = (r.flags & 1) != 0 ? r.rMax * r.cA : r.rDom * r.cA;
                            }
                            delay = (r.flags & 0x40) != 0 && r.tIn > 0.5 ? Math.sqrt(tau * tau + Sim.deltaToPS((long)r.tIn) * r.cA) : tau;
                        }
                        this.queueFVal(nd, r.finall, tau, delay);
                    }
                }
                nd = r.getN();
            }
            if (!this.domPot[dom].spike) continue;
            nd = this.domPot[dom].nd;
            while (nd != null) {
                r = nd.getThev();
                if ((r.flags & 4) != 0) {
                    this.incLevel = (this.theSim.irDebug & 0x28) == 40 && (nd.nFlags & 0x20L) != 0L ? 1 : 0;
                    r.tauP = this.getTauP(nd, null, dom, this.incLevel);
                    r.tauP *= r.rDom / r.tauA;
                    this.queueSpike(nd, this.computeSpike(nd, r, dom));
                }
                nd = nd.getThev().getN();
            }
        }
    }

    private void schedulePureCS(Sim.Node nList) {
        Sim.Thev r = nList.getThev();
        char dom = r.finall;
        r.flags |= 0x10;
        double tauP = 0.0;
        Sim.Node nd = nList;
        while (nd != null) {
            this.incLevel = (this.theSim.irDebug & 0x24) == 36 && (nd.nFlags & 0x20L) != 0L ? 1 : 0;
            r = this.getTau(nd, null, dom, this.incLevel);
            r.tauD = r.rDom * r.cA;
            switch (dom) {
                case '\u0000': {
                    r.tauA = r.rDom * (r.cA - r.cD * r.v.max);
                    break;
                }
                case '\u0003': {
                    r.tauA = r.rDom * (r.cD * (1.0 - r.v.min) - r.cA);
                    break;
                }
                case '\u0001': {
                    r.tauA = r.rDom * (r.cA - r.cD * 0.5);
                }
            }
            tauP += r.tauA * (double)nd.nCap;
            nd = nd.nLink;
        }
        r = nList.getThev();
        tauP /= r.cLow.min + r.cHigh.max;
        nd = nList;
        while (nd != null) {
            r = nd.getThev();
            double delay = 0.0;
            double tau = 0.0;
            if (r.finall != nd.nPot) {
                switch (r.finall) {
                    case '\u0000': {
                        tau = (r.tauA - tauP) / (1.0 - r.v.max);
                        break;
                    }
                    case '\u0003': {
                        tau = (tauP - r.tauA) / r.v.min;
                        break;
                    }
                    case '\u0001': {
                        tau = (r.tauA - tauP) * 2.0;
                    }
                }
                if (tau < 0.0) {
                    tau = 0.0;
                }
                if (this.theSim.tUnitDelay != 0) {
                    delay = this.theSim.tUnitDelay;
                    tau = 0.0;
                } else {
                    delay = tau;
                }
            }
            this.queueFVal(nd, r.finall, tau, delay);
            nd = nd.nLink;
        }
    }

    private boolean computeDC(Sim.Node nList) {
        boolean anyChange = false;
        Sim.Node thisOne = nList;
        while (thisOne != null) {
            this.incLevel = (this.theSim.irDebug & 0x22) == 34 && (thisOne.nFlags & 0x20L) != 0L ? 1 : 0;
            Sim.Thev r = this.getDCVal(thisOne, null);
            thisOne.setThev(r);
            if (this.theSim.withDriven) {
                r.v.min = r.rDown.min >= 1.0E8 ? 1.0 : r.rDown.min / (r.rDown.min + r.rUp.max);
                r.v.max = r.rUp.min >= 1.0E8 ? 0.0 : r.rDown.max / (r.rDown.max + r.rUp.min);
            } else {
                r.v.min = r.cHigh.min / (r.cHigh.min + r.cLow.max);
                r.v.max = r.cHigh.max / (r.cHigh.max + r.cLow.min);
            }
            r.finall = r.v.min >= (double)thisOne.vHigh ? (char)3 : (r.v.max <= (double)thisOne.vLow ? (char)'\u0000' : '\u0001');
            if (this.theSim.withDriven) {
                if (r.finall != '\u0001' && (r.flags & 1) == 0) {
                    char cs_val = '\u0001';
                    if (r.cHigh.min >= (double)thisOne.vHigh * (r.cHigh.min + r.cLow.max)) {
                        cs_val = '\u0003';
                    } else if (r.cHigh.max <= (double)thisOne.vLow * (r.cHigh.max + r.cLow.min)) {
                        cs_val = '\u0000';
                    }
                    if (cs_val != r.finall) {
                        r.finall = '\u0001';
                    }
                }
                r.setN(this.domPot[r.finall].nd);
                this.domPot[r.finall].nd = thisOne;
                if (r.finall == thisOne.nPot && (r.finall == '\u0000' && r.cHigh.min > 1.0E-15 || r.finall == '\u0003' && r.cLow.min > 1.0E-15)) {
                    r.flags |= 4;
                    this.domPot[r.finall].spike = true;
                    anyChange = true;
                }
            }
            if (r.finall != thisOne.nPot) {
                anyChange = true;
            }
            if ((this.theSim.irDebug & 2) == 2 && (thisOne.nFlags & 0x20L) != 0L) {
                this.printFVal(thisOne, r);
            }
            thisOne = thisOne.nLink;
        }
        return anyChange;
    }

    private Sim.Thev getDCVal(Sim.Node n2, Sim.Trans tran) {
        if ((n2.nFlags & 0x10L) != 0L) {
            Sim.Thev r = new Sim.Thev(this.inputThev[n2.nPot]);
            return r;
        }
        Sim.Thev r = new Sim.Thev();
        switch (n2.nPot) {
            case 0: {
                r.cLow.min = r.cLow.max = (double)n2.nCap;
                break;
            }
            case 1: {
                r.cLow.max = r.cHigh.max = (double)n2.nCap;
                break;
            }
            case 3: {
                r.cHigh.min = r.cHigh.max = (double)n2.nCap;
            }
        }
        for (Sim.Trans t : n2.nTermList) {
            Sim.Thev cache;
            Sim.Node other;
            if (t == tran || t.state == 0 || (t.tFlags & 6) != 0) continue;
            if (n2 == t.source) {
                other = t.drain;
                cache = t.getDThev();
            } else {
                other = t.source;
                cache = t.getSThev();
            }
            if (cache == null) {
                cache = this.seriesOP(this.getDCVal(other, t), t);
                if (n2 == t.source) {
                    t.setDThev(cache);
                } else {
                    t.setSThev(cache);
                }
            }
            this.parallelOP(r, cache);
        }
        if ((n2.nFlags & 8L) != 0L) {
            r.tpLH = n2.tpLH;
            r.tpHL = n2.tpHL;
            r.flags |= 2;
        }
        return r;
    }

    private void getReq(Sim.Thev r, Sim.Trans t, int type) {
        if ((t.tFlags & 8) != 0) {
            this.getParallel(r, t, type);
        } else {
            r.req.min = t.r.dynRes[type];
            if (t.state == 2) {
                r.flags |= 0x20;
            } else {
                r.req.max = t.r.dynRes[type];
            }
        }
    }

    private void getMinR(Sim.Thev r, Sim.Trans t) {
        if ((t.tFlags & 8) != 0) {
            this.getMinParallel(r, t);
        } else {
            r.req.min = Math.min(t.r.dynRes[1], t.r.dynRes[0]);
            if (t.state == 2) {
                r.flags |= 0x20;
            } else {
                r.req.max = r.req.min;
            }
        }
    }

    private void getParallel(Sim.Thev r, Sim.Trans t, int restype) {
        Sim.Resists rp = t.r;
        double gMin = 1.0 / (double)rp.dynRes[restype];
        double gMax = t.state == 2 ? 0.0 : gMin;
        for (t = this.theSim.parallelTransistors[t.nPar]; t != null; t = t.getDTrans()) {
            rp = t.r;
            gMin += 1.0 / (double)rp.dynRes[restype];
            if (t.state == 2) continue;
            gMax += 1.0 / (double)rp.dynRes[restype];
        }
        r.req.min = 1.0 / gMin;
        if (gMax == 0.0) {
            r.flags |= 0x20;
        } else {
            r.req.max = 1.0 / gMax;
        }
    }

    private void getMinParallel(Sim.Thev r, Sim.Trans t) {
        Sim.Resists rp = t.r;
        double gMin = 1.0 / (double)Math.min(rp.dynRes[0], rp.dynRes[1]);
        double gMax = t.state == 2 ? 0.0 : gMin;
        for (t = this.theSim.parallelTransistors[t.nPar]; t != null; t = t.getDTrans()) {
            rp = t.r;
            double tmp = 1.0 / (double)Math.min(rp.dynRes[0], rp.dynRes[1]);
            gMin += tmp;
            if (t.state == 2) continue;
            gMax += tmp;
        }
        r.req.min = 1.0 / gMin;
        if (gMax == 0.0) {
            r.flags |= 0x20;
        } else {
            r.req.max = 1.0 / gMax;
        }
    }

    private Sim.Thev seriesOP(Sim.Thev r, Sim.Trans t) {
        if ((r.flags & 8) == 0) {
            if (r.cHigh.min > r.cLow.max) {
                this.getReq(r, t, 1);
            } else if (r.cHigh.max < r.cLow.min) {
                this.getReq(r, t, 0);
            } else {
                this.getMinR(r, t);
            }
            return r;
        }
        if (r.rDown.min > r.rUp.max) {
            this.getReq(r, t, 1);
        } else if (r.rDown.max < r.rUp.min) {
            this.getReq(r, t, 0);
        } else {
            this.getMinR(r, t);
        }
        double upMin = r.rUp.min;
        double downMin = r.rDown.min;
        if (upMin < 1.0E8) {
            r.rUp.min += r.req.min * (1.0 + upMin / r.rDown.max);
        }
        if (downMin < 1.0E8) {
            r.rDown.min += r.req.min * (1.0 + downMin / r.rUp.max);
        }
        if ((r.flags & 0x20) != 0) {
            r.flags &= 0xFFFFFFFE;
            r.rDown.max = 1.0E15;
            r.rUp.max = 1.0E15;
        } else {
            if (r.rUp.max < 1.0E8) {
                r.rUp.max += r.req.max * (1.0 + r.rUp.max / downMin);
            }
            if (r.rDown.max < 1.0E8) {
                r.rDown.max += r.req.max * (1.0 + r.rDown.max / upMin);
            }
        }
        return r;
    }

    private double doParallel(double oldR, double newR) {
        if (oldR > 1.0E8) {
            return newR;
        }
        if (newR > 1.0E8) {
            return oldR;
        }
        return Sim.combine(oldR, newR);
    }

    private void parallelOP(Sim.Thev r, Sim.Thev newRB) {
        r.cLow.max += newRB.cLow.max;
        r.cHigh.max += newRB.cHigh.max;
        if ((newRB.flags & 0x20) == 0) {
            r.cLow.min += newRB.cLow.min;
            r.cHigh.min += newRB.cHigh.min;
        }
        if ((newRB.flags & 3) == 3) {
            if ((r.flags & 2) != 0) {
                r.tpLH = (short)Math.min(r.tpLH, newRB.tpLH);
                r.tpHL = (short)Math.min(r.tpHL, newRB.tpHL);
            } else {
                r.tpLH = newRB.tpLH;
                r.tpHL = newRB.tpHL;
                r.flags |= 2;
            }
        }
        if ((newRB.flags & 8) == 0) {
            return;
        }
        r.flags |= 8;
        r.rUp.min = this.doParallel(r.rUp.min, newRB.rUp.min);
        r.rDown.min = this.doParallel(r.rDown.min, newRB.rDown.min);
        if ((r.flags & newRB.flags & 1) != 0) {
            r.rUp.max = this.doParallel(r.rUp.max, newRB.rUp.max);
            r.rDown.max = this.doParallel(r.rDown.max, newRB.rDown.max);
        } else if ((newRB.flags & 1) != 0) {
            r.rUp.max = newRB.rUp.max;
            r.rDown.max = newRB.rDown.max;
            r.flags |= 1;
        } else {
            if (newRB.rUp.max < r.rUp.max) {
                r.rUp.max = newRB.rUp.max;
            }
            if (newRB.rDown.max < r.rDown.max) {
                r.rDown.max = newRB.rDown.max;
            }
        }
    }

    private boolean isCurrTransition(Sim.HistEnt h2) {
        return h2.hTime == this.theSim.curDelta && (h2.inp || h2.delay != 0);
    }

    private boolean getTin(Sim.Trans t, Electric.MutableDouble ptin) {
        boolean isInt = false;
        if (t.state != 1) {
            return false;
        }
        if ((t.tType & 8) == 0) {
            Sim.HistEnt h2 = ((Sim.Node)t.gate).curr;
            if (this.isCurrTransition(h2)) {
                ptin.setValue((float)h2.rTime * t.r.rStatic);
                isInt = true;
            }
        } else {
            double tmp = 0.0;
            for (t = (Sim.Trans)t.gate; t != null; t = t.getSTrans()) {
                Sim.HistEnt h3 = ((Sim.Node)t.gate).curr;
                if (!this.isCurrTransition(h3)) continue;
                isInt = true;
                tmp += (double)((float)h3.rTime * t.r.rStatic);
            }
            ptin.setValue(tmp);
        }
        return isInt;
    }

    private double combineR(double a2, double b2) {
        return a2 + b2 <= 1.0E-15 ? 0.0 : Sim.combine(a2, b2);
    }

    private boolean getParallelTin(Sim.Trans t, Electric.MutableDouble iTau) {
        Electric.MutableDouble tin = new Electric.MutableDouble(0.0);
        boolean isInt = this.getTin(t, tin);
        for (t = this.theSim.parallelTransistors[t.nPar]; t != null; t = t.getDTrans()) {
            Electric.MutableDouble tmp = new Electric.MutableDouble(0.0);
            if (this.getTin(t, tmp)) {
                tin.setValue(isInt ? this.combineR(tin.doubleValue(), tmp.doubleValue()) : tmp.doubleValue());
                isInt = true;
            }
            iTau.setValue(tin.doubleValue());
        }
        return isInt;
    }

    private Sim.Thev getTau(Sim.Node n2, Sim.Trans tran, int dom, int level) {
        Sim.Thev r = tran == null ? n2.getThev() : (tran.source == n2 ? tran.getSThev() : tran.getDThev());
        r.tauDone = (char)dom;
        if ((n2.nFlags & 0x10L) != 0L) {
            r.cD = 0.0;
            r.cA = 0.0;
            r.rMin = 0.0;
            r.tIn = 0.0;
            if (n2.nPot == dom) {
                r.rMax = 0.0;
                r.rDom = 0.0;
                r.flags |= 0x80;
            } else {
                r.flags &= 0xFFFFFF3F;
                if (dom == 1) {
                    r.rMax = 0.0;
                    r.rDom = 0.0;
                } else {
                    r.rMax = 1.0E15;
                    r.rDom = 1.0E15;
                }
            }
            return r;
        }
        if ((n2.getThev().flags & 0x10) != 0) {
            r.rMax = 0.0;
            r.rDom = 0.0;
            r.rMin = 0.0;
            r.cD = 0.0;
            r.cA = 0.0;
            return r;
        }
        r.rMax = 1.0E15;
        r.rDom = 1.0E15;
        r.rMin = 1.0E15;
        r.cD = n2.nCap;
        r.cA = dom == 1 ? (this.theSim.isDelayedX ? (double)n2.nCap : (n2.nPot == 0 ? 0.0 : (double)n2.nCap)) : (n2.nPot == dom ? 0.0 : (double)n2.nCap);
        r.tIn = 0.0;
        r.flags &= 0xFFFFFF3F;
        for (Sim.Trans t : n2.nTermList) {
            Sim.Thev cache;
            Sim.Node other;
            if (t.state == 0 || t == tran || (t.tFlags & 6) != 0) continue;
            if (n2 == t.source) {
                other = t.drain;
                cache = t.getDThev();
            } else {
                other = t.source;
                cache = t.getSThev();
            }
            if (cache.tauDone != dom) {
                Electric.MutableDouble oldR = new Electric.MutableDouble(0.0);
                cache = this.getTau(other, t, dom, level + this.incLevel);
                if ((cache.flags & 0x80) != 0) {
                    boolean inputTau;
                    boolean bl = inputTau = (t.tFlags & 8) != 0 ? this.getParallelTin(t, oldR) : this.getTin(t, oldR);
                    if (inputTau) {
                        cache.flags |= 0x40;
                        cache.tIn += oldR.doubleValue();
                    }
                }
                oldR.setValue(cache.rDom);
                cache.rMin += cache.req.min;
                cache.rDom += cache.req.min;
                cache.rMax = (cache.flags & 0x20) != 0 ? 1.0E15 : (cache.rMax += cache.req.max);
                if ((cache.flags & 0x20) != 0 && other.nPot == dom) {
                    cache.cD = 0.0;
                    cache.cA = 0.0;
                    cache.tauP = 0.0;
                } else if (oldR.doubleValue() > 1.0E8) {
                    cache.tauP = 1.0;
                } else {
                    cache.tauP = oldR.doubleValue() / cache.rDom;
                    cache.cA *= cache.tauP;
                    cache.cD *= cache.tauP;
                }
            }
            r.cA += cache.cA;
            r.cD += cache.cD;
            r.rMin = Sim.combine(r.rMin, cache.rMin);
            if (r.rDom > 1.0E8) {
                r.rDom = cache.rDom;
                r.rMax = cache.rMax;
            } else if (cache.rDom < 1.0E8) {
                r.rDom = Sim.combine(r.rDom, cache.rDom);
                r.rMax = Sim.combine(r.rMax, cache.rMax);
            }
            if ((cache.flags & 0x80) != 0) {
                r.flags |= 0x80;
            }
            if ((cache.flags & 0x40) == 0) continue;
            if ((r.flags & 0x40) != 0) {
                r.tIn = this.combineR(r.tIn, cache.tIn);
                continue;
            }
            r.tIn = cache.tIn;
            r.flags |= 0x40;
        }
        if (level > 0) {
            this.printTau(n2, r, level);
        }
        return r;
    }

    private double getTauP(Sim.Node n2, Sim.Trans tran, int dom, int level) {
        if ((n2.nFlags & 0x10L) != 0L) {
            return 0.0;
        }
        Sim.Thev r = n2.getThev();
        if (r.tauDone != dom) {
            r = this.getTau(n2, null, dom, 0);
            r.tauA = r.rDom * r.cA;
            r.tauD = r.rDom * r.cD;
        }
        double taup = r.tauA * (double)n2.nCap;
        for (Sim.Trans t : n2.nTermList) {
            Sim.Node other;
            if (t.state == 0 || t == tran || (t.tFlags & 6) != 0) continue;
            if (t.source == n2) {
                other = t.drain;
                r = t.getDThev();
            } else {
                other = t.source;
                r = t.getSThev();
            }
            if (r.tauPDone != dom) {
                r.tauP *= this.getTauP(other, t, dom, level + this.incLevel);
                r.tauPDone = (char)dom;
            }
            taup += r.tauP;
        }
        if (level > 0) {
            this.printTauP(n2, level, taup);
        }
        return taup;
    }

    private SpikeRec computeSpike(Sim.Node nd, Sim.Thev r, int dom) {
        if (r.tauP <= 1.0E-15) {
            if ((this.theSim.irDebug & 0x10) != 0 && (nd.nFlags & 0x20L) != 0L) {
                System.out.println(" spike(" + nd.nName + ") ignored (taup=0)");
            }
            return null;
        }
        int rType = dom == 0 ? 0 : 1;
        float nmos = 0.0f;
        float pmos = 0.0f;
        for (Sim.Trans t : nd.nTermList) {
            if (t.state == 0 || (t.tFlags & 2) != 0) continue;
            if (Sim.baseType(t.tType) == 1) {
                pmos += 1.0f / t.r.dynRes[rType];
                continue;
            }
            nmos += 1.0f / t.r.dynRes[rType];
        }
        int tabIndex = 0;
        tabIndex = (double)nmos > 0.7 * (double)(pmos + nmos) ? (rType == 0 ? 0 : 1) : ((double)pmos > 0.7 * (double)(pmos + nmos) ? (rType == 0 ? 1 : 0) : 2);
        int alpha = (int)(10.0 * r.tauA / (r.tauA + r.tauP - r.tauD));
        if (alpha < 0) {
            alpha = 0;
        } else if (alpha > 10) {
            alpha = 10;
        }
        int beta = (int)(10.0 * (r.tauD - r.tauA) / r.tauD);
        if (beta < 0) {
            beta = 0;
        } else if (beta > 10) {
            beta = 10;
        }
        SpikeRec spk = new SpikeRec();
        spk.peak = spikeTable[tabIndex][beta][alpha];
        spk.chDelay = delayTable[beta][alpha];
        if (dom == 0) {
            if (spk.peak <= nd.vLow) {
                if ((this.theSim.irDebug & 0x10) != 0 && (nd.nFlags & 0x20L) != 0L) {
                    this.printSpk(nd, r, tabIndex, dom, alpha, beta, spk, false);
                }
                return null;
            }
            spk.charge = spk.peak >= nd.vHigh ? 3 : 1;
        } else {
            if ((double)spk.peak <= 1.0 - (double)nd.vHigh) {
                if ((this.theSim.irDebug & 0x10) != 0 && (nd.nFlags & 0x20L) != 0L) {
                    this.printSpk(nd, r, tabIndex, dom, alpha, beta, spk, false);
                }
                return null;
            }
            spk.charge = (double)spk.peak >= 1.0 - (double)nd.vLow ? 0 : 1;
        }
        spk.chDelay *= r.tauA * r.tauD / r.tauP;
        spk.drDelay = r.rMax < 1.0E15 ? r.rMax * r.cA : r.rDom * r.cA;
        if ((this.theSim.irDebug & 0x10) != 0 && (nd.nFlags & 0x20L) != 0L) {
            this.printSpk(nd, r, tabIndex, dom, alpha, beta, spk, true);
        }
        return spk;
    }

    private void printFVal(Sim.Node n2, Sim.Thev r) {
        System.out.print(" final_value(" + n2.nName + ")  V=[" + r.v.min + ", " + r.v.max + "]  => " + Sim.vChars.charAt(r.finall));
        System.out.println((r.flags & 4) != 0 ? "  (spk)" : "");
    }

    private void printFinal(Sim.Node nd, boolean queued, double tau, long delay) {
        Sim.Thev r = nd.getThev();
        long dtau = Sim.psToDelta(tau);
        System.out.print(" [event " + this.theSim.curNode.nName + "->" + Sim.vChars.charAt(this.theSim.curNode.nPot) + " @ " + Sim.deltaToNS(this.theSim.curDelta) + "ns] ");
        System.out.print((String)(queued ? "causes " + (this.theSim.withDriven ? "" : "CS") + "transition for" : "evaluates"));
        System.out.print(" " + nd.nName + ": " + Sim.vChars.charAt(nd.nPot) + " -> " + Sim.vChars.charAt(r.finall));
        System.out.println(" (tau=" + Sim.deltaToPS(dtau) + "ps, delay=" + Sim.deltaToPS(delay) + "ps)");
    }

    private void printSpike(Sim.Node nd, SpikeRec spk, long chDelay, long drDelay) {
        System.out.print("  [event " + this.theSim.curNode.nName + "->" + Sim.vChars.charAt(this.theSim.curNode.nPot) + "@ " + Sim.deltaToNS(this.theSim.curDelta) + "ns] causes ");
        if (drDelay <= chDelay) {
            System.out.print("suppressed ");
        }
        System.out.print("spike for " + nd.nName + ": " + Sim.vChars.charAt(nd.nPot) + " -> " + Sim.vChars.charAt(spk.charge) + " -> " + Sim.vChars.charAt(nd.nPot));
        System.out.println(" (peak=" + spk.peak + " delay: ch=" + Sim.deltaToPS(chDelay) + "ps, dr=" + Sim.deltaToPS(drDelay) + "ps)");
    }

    private void printTauP(Sim.Node n2, int level, double taup) {
        System.out.println("tauP(" + n2.nName + ") = " + Sim.psToNS(taup) + " ns");
    }

    private void printTau(Sim.Node n2, Sim.Thev r, int level) {
        System.out.println(" ...............compute_tau(" + n2.nName + ")");
        System.out.print("                {Rmin=" + this.rToAscii(r.rMin) + "  Rdom=" + this.rToAscii(r.rDom) + "  Rmax=" + this.rToAscii(r.rMax) + "}");
        System.out.println(" {Ca=" + r.cA + "  Cd=" + r.cD + "}");
        System.out.print("                tauA=" + Sim.psToNS(r.rDom * r.cA) + "  tauD=" + Sim.psToNS(r.rDom * r.cD) + " ns, RTin=");
        if ((r.flags & 0x40) != 0) {
            System.out.println(Sim.deltaToNS((long)r.tIn) + " ohm*ns");
        } else {
            System.out.println("-");
        }
    }

    private String rToAscii(double r) {
        if (r >= 1.0E8) {
            return " - ";
        }
        if (r > 1.0) {
            int exp = 0;
            while (r >= 1000.0) {
                ++exp;
                r *= 0.001;
            }
            return this.theSim.theAnalyzer.formatDouble(r) + " KMG".charAt(exp);
        }
        return this.theSim.theAnalyzer.formatDouble(r);
    }

    private void printSpk(Sim.Node nd, Sim.Thev r, int tab, int dom, int alpha, int beta, SpikeRec spk, boolean isSpk) {
        System.out.print(" spike_analysis(" + nd.nName + "):");
        String net_type = "";
        net_type = tab == 2 ? "n-p mix" : (tab == 0 ? (dom == 0 ? "nmos" : "pmos") : (dom == 0 ? "pmos" : "nmos"));
        System.out.print(" " + net_type + " driven " + (dom == 0 ? "low" : "high"));
        System.out.print("{tauA=" + Sim.psToNS(r.tauA) + "  tauD=" + Sim.psToNS(r.tauD) + "  tauP=" + Sim.psToNS(r.tauP) + "} ns  ");
        System.out.print("alpha=" + alpha + "  beta=" + beta + " => peak=" + spk.peak);
        if (isSpk) {
            System.out.println(" v=" + Sim.vChars.charAt(spk.charge));
        } else {
            System.out.println(" (too small)");
        }
    }

    private void initThevs() {
        this.inputThev = new Sim.Thev[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            this.inputThev[i2] = new Sim.Thev();
        }
        Sim.Thev t = this.inputThev[0];
        t.flags = 9;
        t.rDown.min = 1.0E-15;
        t.rDown.max = 1.0E-15;
        t.v.min = 0.0;
        t.rMin = 1.0E-15;
        t.finall = '\u0000';
        t = this.inputThev[3];
        t.flags = 9;
        t.rUp.min = 1.0E-15;
        t.rUp.max = 1.0E-15;
        t.v.min = 1.0;
        t.rMin = 1.0E-15;
        t.finall = (char)3;
        t = this.inputThev[1];
        t.flags = 9;
        t.rUp.min = 1.0E-15;
        t.rDown.min = 1.0E-15;
        t.rMin = 1.0E-15;
        this.inputThev[2] = this.inputThev[1];
    }

    private static class Dominant {
        Sim.Node nd;
        boolean spike;

        private Dominant() {
        }
    }

    private static class SpikeRec {
        double chDelay;
        double drDelay;
        float peak;
        int charge;

        private SpikeRec() {
        }
    }
}

