/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.irsim;

import com.sun.electric.plugins.irsim.Sim;
import com.sun.electric.plugins.irsim.SimAPI;
import java.util.Collection;

public class Eval {
    private boolean firstCall = true;
    protected Sim theSim;
    private int nPending;
    private static int[][] switchState = new int[][]{{0, 2, 2, 1}, {1, 2, 2, 0}, {3, 3, 3, 3}, {3, 3, 3, 3}};
    private static final int TSIZE = 1024;
    private static final int TMASK = 1023;
    private Event[] evArray = new Event[1024];

    public Eval(Sim sim) {
        this.theSim = sim;
    }

    protected void modelEvaluate(Sim.Node node) {
    }

    public void reInit() {
        this.firstCall = true;
    }

    public boolean step(long stopTime, Collection<SimAPI.Node> xInputs, Collection<SimAPI.Node> hInputs, Collection<SimAPI.Node> lInputs, Collection<SimAPI.Node> uInputs) {
        boolean retCode = false;
        this.MarkNOinputs(xInputs);
        this.SetInputs(hInputs, 3);
        hInputs.clear();
        this.SetInputs(lInputs, 0);
        lInputs.clear();
        this.SetInputs(uInputs, 1);
        uInputs.clear();
        if (this.firstCall) {
            this.enqueueInput(this.theSim.powerNode, 3);
            this.enqueueInput(this.theSim.groundNode, 0);
            this.firstCall = false;
        }
        while (true) {
            Event evList;
            if ((evList = this.getNextEvent(stopTime)) != null) {
                this.MarkNodes(evList);
                if (xInputs.size() > 0) {
                    this.EvalNOinputs(xInputs);
                }
                long brkFlag = this.EvalNodes(evList);
                SimAPI.Analyzer analyzer = this.theSim.theAnalyzer;
                if ((brkFlag & 0x1C0L) == 0L || analyzer == null) continue;
                if ((brkFlag & 0x140L) != 0L) {
                    analyzer.dispWatchVec(brkFlag);
                }
                if ((brkFlag & 0x180L) == 0L) continue;
                analyzer.updateWindowIfAnalyzerOn(this.theSim.curDelta);
                return true;
            }
            if (xInputs.size() <= 0) break;
            this.EvalNOinputs(xInputs);
        }
        this.theSim.curDelta = stopTime;
        SimAPI.Analyzer analyzer = this.theSim.theAnalyzer;
        if (analyzer != null) {
            analyzer.updateWindowIfAnalyzerOn(this.theSim.curDelta);
        }
        return retCode;
    }

    private void pr_watched(Event e2, Sim.Node n2) {
        if ((n2.nFlags & 0x10L) != 0L) {
            System.out.println(" @ " + Sim.deltaToNS(e2.nTime) + "ns input " + n2.nName + ": -> " + Sim.vChars.charAt(e2.eval));
            return;
        }
        System.out.print(" @ " + Sim.deltaToNS(e2.nTime) + "ns " + n2.nName + ": " + Sim.vChars.charAt(n2.nPot) + " -> " + Sim.vChars.charAt(e2.eval));
        int tmp = (this.theSim.irDebug & 1) != 0 ? 6 : this.theSim.tReport;
        switch (tmp & 6) {
            case 4: {
                System.out.println(" (tau=" + Sim.deltaToNS(e2.rTime));
                break;
            }
            case 2: {
                System.out.println(" (delay=" + Sim.deltaToNS(e2.delay) + "ns)");
                break;
            }
            default: {
                System.out.println(" (tau=" + Sim.deltaToNS(e2.rTime) + "ns, delay=" + Sim.deltaToNS(e2.delay) + "ns)");
            }
        }
    }

    private void MarkNodes(Event evList) {
        Sim.Node n2;
        Event e2 = evList;
        long allFlags = 0L;
        do {
            n2 = e2.eNode;
            allFlags |= n2.nFlags;
            if (e2.type == 1 && ((this.theSim.tReport & 1) != 0 || (n2.nFlags & 0xA0L) != 0L)) {
                System.out.println(" @ " + Sim.deltaToNS(e2.nTime) + "ns " + n2.nName + ": decay " + Sim.vChars.charAt(n2.nPot) + " . X");
            } else if ((n2.nFlags & 0xA0L) != 0L) {
                this.pr_watched(e2, n2);
            }
            n2.nPot = e2.eval;
            if ((n2.nFlags & 0x10L) == 0L && n2.curr.val != n2.nPot) {
                this.theSim.addHist(n2, n2.nPot, false, e2.nTime, e2.delay, e2.rTime);
            }
            if (n2.awPending != null && n2.awPot == n2.nPot && n2.awPending != null) {
                n2.awPending.run();
            }
            for (Sim.Trans t : n2.nGateList) {
                t.state = (byte)this.computeTransState(t);
                if ((t.source.nFlags & 0x10L) == 0L) {
                    t.source.nFlags |= 0x200L;
                }
                if ((t.drain.nFlags & 0x10L) != 0L) continue;
                t.drain.nFlags |= 0x200L;
            }
            this.freeFromNode(e2, n2);
        } while ((e2 = e2.fLink) != null);
        if ((allFlags & 0x10L) != 0L) {
            e2 = evList;
            while (e2 != null) {
                n2 = e2.eNode;
                if ((n2.nFlags & 0x12L) == 16L) {
                    for (Sim.Trans t : n2.nTermList) {
                        if (t.state == 0) continue;
                        Sim.Node other = Sim.otherNode(t, n2);
                        if ((other.nFlags & 0x210L) != 0L) continue;
                        other.nFlags |= 0x200L;
                    }
                }
                e2 = e2.fLink;
            }
        }
    }

    private long EvalNodes(Event evList) {
        long brkFlag = 0L;
        Event event = evList;
        do {
            ++this.theSim.nEvent;
            Sim.Node n2 = this.theSim.curNode = event.eNode;
            n2.setTime(event.nTime);
            n2.setCause(event.cause);
            --this.nPending;
            for (Sim.Trans t : n2.nGateList) {
                if ((t.source.nFlags & 0x200L) != 0L) {
                    this.modelEvaluate(t.source);
                }
                if ((t.drain.nFlags & 0x200L) == 0L) continue;
                this.modelEvaluate(t.drain);
            }
            if ((n2.nFlags & 0x12L) == 16L) {
                for (Sim.Trans t : n2.nTermList) {
                    Sim.Node other = Sim.otherNode(t, n2);
                    if ((other.nFlags & 0x200L) == 0L) continue;
                    this.modelEvaluate(other);
                }
            }
            brkFlag |= n2.nFlags;
        } while ((event = event.fLink) != null);
        return brkFlag;
    }

    private void SetInputs(Collection<SimAPI.Node> list, int val) {
        for (SimAPI.Node nn : list) {
            Sim.Node n2 = (Sim.Node)nn;
            n2.nPot = (short)val;
            n2.nFlags &= 0xFFFFFFFFFFFF8FFFL;
            n2.nFlags |= 0x10L;
            this.enqueueInput(n2, val);
            if (n2.curr.val == val && n2.curr.inp) continue;
            this.theSim.addHist(n2, val, true, this.theSim.curDelta, 0L, 0L);
        }
    }

    private void MarkNOinputs(Collection<SimAPI.Node> xInputs) {
        for (SimAPI.Node n2 : xInputs) {
            n2.clearFlags(28688L);
            n2.setFlags(512L);
        }
    }

    private void EvalNOinputs(Collection<SimAPI.Node> xInputs) {
        for (SimAPI.Node nn : xInputs) {
            Sim.Node n2;
            this.theSim.curNode = n2 = (Sim.Node)nn;
            this.theSim.addHist(n2, n2.curr.val, false, this.theSim.curDelta, 0L, 0L);
            if ((n2.nFlags & 0x200L) == 0L) continue;
            this.modelEvaluate(n2);
        }
        xInputs.clear();
    }

    public int computeTransState(Sim.Trans t) {
        if ((t.tType & 8) == 0) {
            return switchState[Sim.baseType(t.tType)][((Sim.Node)t.gate).nPot];
        }
        switch (Sim.baseType(t.tType)) {
            case 0: {
                int result = 1;
                for (Sim.Trans l2 = (Sim.Trans)t.gate; l2 != null; l2 = l2.getSTrans()) {
                    Sim.Node n2 = (Sim.Node)l2.gate;
                    if (n2.nPot == 0) {
                        return 0;
                    }
                    if (n2.nPot != 1) continue;
                    result = 2;
                }
                return result;
            }
            case 1: {
                int result = 1;
                for (Sim.Trans l3 = (Sim.Trans)t.gate; l3 != null; l3 = l3.getSTrans()) {
                    Sim.Node n3 = (Sim.Node)l3.gate;
                    if (n3.nPot == 3) {
                        return 0;
                    }
                    if (n3.nPot != 1) continue;
                    result = 2;
                }
                return result;
            }
            case 2: 
            case 3: {
                return 3;
            }
        }
        System.out.println("**** internal error: unrecongized transistor type (" + Sim.baseType(t.tType) + ")");
        return 2;
    }

    private Event getEVArray(long t) {
        return this.evArray[(int)(t & 0x3FFL)];
    }

    private Event getNextEvent(long stopTime) {
        long i2;
        if (this.nPending == 0) {
            return null;
        }
        Event event = null;
        boolean eventValid = false;
        long time = this.theSim.maxTime;
        long limit = i2 + 1024L;
        for (i2 = this.theSim.curDelta; i2 < limit; ++i2) {
            event = this.getEVArray(i2);
            if (event == event.fLink) continue;
            if (event.fLink.nTime < limit) {
                eventValid = true;
                break;
            }
            if (event.fLink.nTime >= time) continue;
            time = event.fLink.nTime;
        }
        if (!eventValid) {
            if (time == this.theSim.maxTime) {
                System.out.println("*** internal error: no events but npending set");
                return null;
            }
            event = this.getEVArray(time);
        }
        Event evList = event.fLink;
        time = evList.nTime;
        if (time >= stopTime) {
            return null;
        }
        this.theSim.curDelta = time;
        if (event.bLink.nTime != time) {
            do {
                event = event.fLink;
            } while (event.nTime == time);
            event = event.bLink;
            evList.bLink.fLink = event.fLink;
            event.fLink.bLink = evList.bLink;
            evList.bLink = event;
            event.fLink = null;
        } else {
            event = evList.bLink;
            event.bLink.fLink = null;
            evList.bLink = event.bLink;
            event.fLink = event.bLink = event;
        }
        return evList;
    }

    private void freeEvent(Event event) {
        event.bLink.fLink = event.fLink;
        event.fLink.bLink = event.bLink;
        --this.nPending;
        this.freeFromNode(event, event.eNode);
    }

    public void enqueueEvent(Sim.Node n2, int newValue, long delta, long rTime) {
        long eTime;
        Event newEV = new Event();
        newEV.nTime = eTime = this.theSim.curDelta + delta;
        newEV.rTime = (short)rTime;
        newEV.eNode = n2;
        newEV.cause = this.theSim.curNode;
        newEV.delay = delta;
        if (newValue == 4) {
            newEV.eval = 1;
            newEV.type = 1;
        } else {
            newEV.eval = (byte)newValue;
            newEV.type = 0;
        }
        Event marker = this.getEVArray(eTime);
        if (marker.bLink != marker && marker.bLink.nTime > eTime) {
            do {
                marker = marker.fLink;
            } while (marker.nTime <= eTime);
        }
        newEV.fLink = marker;
        newEV.bLink = marker.bLink;
        marker.bLink.fLink = newEV;
        marker.bLink = newEV;
        ++this.nPending;
        if (n2.events != null && n2.events.nTime > eTime) {
            marker = n2.events;
            while (marker.nLink != null && marker.nLink.nTime > eTime) {
                marker = marker.nLink;
            }
            newEV.nLink = marker.nLink;
            marker.nLink = newEV;
        } else {
            newEV.nLink = n2.events;
            n2.events = newEV;
        }
    }

    private void enqueueInput(Sim.Node n2, int newValue) {
        long eTime;
        while (n2.events != null) {
            this.freeEvent(n2.events);
        }
        Event newEV = new Event();
        newEV.nTime = eTime = this.theSim.curDelta;
        newEV.rTime = 0;
        newEV.delay = 0L;
        newEV.eNode = n2;
        newEV.cause = n2;
        newEV.eval = (byte)newValue;
        newEV.type = 0;
        Event marker = this.getEVArray(eTime);
        newEV.fLink = marker.fLink;
        newEV.bLink = marker;
        marker.fLink.bLink = newEV;
        marker.fLink = newEV;
        ++this.nPending;
        newEV.nLink = null;
        n2.events = newEV;
    }

    public void initEvent() {
        for (int i2 = 0; i2 < 1024; ++i2) {
            Event event;
            this.evArray[i2] = event = new Event();
            event.fLink = event.bLink = event;
        }
        this.nPending = 0;
        this.theSim.nEvent = 0L;
    }

    protected void puntEvent(Sim.Node node, Event ev) {
        if ((node.nFlags & 0x20L) != 0L) {
            System.out.println("    punting transition of " + node.nName + " . " + Sim.vChars.charAt(ev.eval) + " scheduled for " + Sim.deltaToNS(ev.nTime) + "ns");
        }
        if (ev.type != 1) {
            this.theSim.addPunted(ev.eNode, ev, this.theSim.curDelta);
        }
        this.freeEvent(ev);
    }

    private void requeueEvents(Event evList, boolean thread2) {
        this.nPending = 0;
        Event next = null;
        Event ev = evList;
        while (ev != null) {
            next = ev.fLink;
            ++this.nPending;
            long eTime = ev.nTime;
            Event target = this.getEVArray(eTime);
            if (target.bLink != target && target.bLink.nTime > eTime) {
                do {
                    target = target.fLink;
                } while (target.nTime <= eTime);
            }
            ev.fLink = target;
            ev.bLink = target.bLink;
            target.bLink.fLink = ev;
            target.bLink = ev;
            if (thread2) {
                Sim.Node n2 = ev.eNode;
                if (n2.events != null && n2.events.nTime > eTime) {
                    Event marker = n2.events;
                    while (marker.nLink != null && marker.nLink.nTime > eTime) {
                        marker = marker.nLink;
                    }
                    ev.nLink = marker.nLink;
                    marker.nLink = ev;
                } else {
                    ev.nLink = n2.events;
                    n2.events = ev;
                }
            }
            ev = next;
        }
    }

    public void printPendingEvents() {
        if (this.nPending == 0) {
            return;
        }
        System.out.println("Warning: there are " + this.nPending + " pending events:");
    }

    public Event backSimTime(long bTime, int isInc) {
        int nEvents = 0;
        Event tmpList = null;
        for (int i2 = 0; i2 < 1024; ++i2) {
            Event hdr = this.evArray[i2];
            Event next = null;
            Event evhdr = hdr.fLink;
            while (evhdr != hdr) {
                next = evhdr.fLink;
                Event ev = evhdr;
                ev.bLink.fLink = ev.fLink;
                ev.fLink.bLink = ev.bLink;
                if (isInc != 0) {
                    this.freeFromNode(ev, ev.eNode);
                }
                if (isInc == 0 && ev.nTime - ev.delay >= bTime) {
                    this.freeFromNode(ev, ev.eNode);
                } else {
                    ev.fLink = tmpList;
                    tmpList = ev;
                    ++nEvents;
                }
                evhdr = next;
            }
        }
        if (isInc == 0) {
            this.requeueEvents(tmpList, false);
            return null;
        }
        if (isInc != 1) {
            this.nPending = 0;
            return tmpList;
        }
        Event next = null;
        Event ev = tmpList;
        while (ev != null) {
            next = ev.fLink;
            ev.nTime -= ev.delay;
            ev.type = (byte)4;
            long eTime = ev.nTime;
            Event target = this.getEVArray(eTime);
            if (target.bLink != target && target.bLink.nTime > eTime) {
                do {
                    target = target.fLink;
                } while (target.nTime <= eTime);
            }
            ev.fLink = target;
            ev.bLink = target.bLink;
            target.bLink.fLink = ev;
            target.bLink = ev;
            ev = next;
        }
        this.nPending = nEvents;
        return null;
    }

    private void freeFromNode(Event ev, Sim.Node nd) {
        if (nd.events == ev) {
            nd.events = ev.nLink;
        } else {
            Event evp = null;
            evp = nd.events;
            while (evp.nLink != ev) {
                evp = evp.nLink;
            }
            evp.nLink = ev.nLink;
        }
    }

    public static class Event {
        Event fLink;
        Event bLink;
        Event nLink;
        Sim.Node eNode;
        Sim.Node cause;
        long nTime;
        long delay;
        short rTime;
        byte eval;
        byte type;
    }
}

