/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellTree;
import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.ImmutablePortInst;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.BatchChanges;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.IconNodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.Topology;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitiveNodeSize;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.TransistorSize;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.Clipboard;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.collections.ArrayIterator;
import com.sun.electric.util.math.AbstractFixpPoint;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class NodeInst
extends Geometric
implements Nodable,
Comparable<NodeInst> {
    public static final Variable.Key NODE_PROTO = Variable.newKey("NODE_proto");
    public static final Variable.Key NODE_NAME = Variable.newKey("NODE_name");
    public static final Variable.Key TRACE = Variable.newKey("trace");
    public static final Variable.Key TRANSISTOR_LENGTH_KEY = Variable.newKey("transistor_width");
    private static final PortInst[] NULL_PORT_INST_ARRAY = new PortInst[0];
    final Topology topology;
    private ImmutableNodeInst d;
    private NodeProto protoType;
    private PortInst[] portInsts = NULL_PORT_INST_ARRAY;
    private ERectangle visBounds;
    private boolean validVisBounds;

    public static boolean isSpecialNode(NodeInst ni) {
        NodeProto np = ni.getProto();
        return Generic.isSpecialGenericNode(ni) || np.getFunction().isPin() || np.getFunction() == PrimitiveNode.Function.CONNECT;
    }

    NodeInst(ImmutableNodeInst d2, Topology topology) {
        this.topology = topology;
        this.protoType = d2.protoId.inDatabase(this.getDatabase());
        this.d = d2;
        this.portInsts = new PortInst[this.protoType.getNumPorts()];
        for (int i2 = 0; i2 < this.portInsts.length; ++i2) {
            PortProto pp = this.protoType.getPort(i2);
            this.portInsts[i2] = PortInst.newInst(pp, this);
        }
    }

    private NodeInst(NodeProto protoType, ImmutableNodeInst d2) {
        this.topology = null;
        assert (d2.protoId == protoType.getId());
        this.d = d2;
        this.protoType = protoType;
        this.portInsts = new PortInst[protoType.getNumPorts()];
        for (int i2 = 0; i2 < this.portInsts.length; ++i2) {
            PortProto pp = protoType.getPort(i2);
            this.portInsts[i2] = PortInst.newInst(pp, this);
        }
    }

    protected Object writeReplace() {
        return new NodeInstKey(this);
    }

    @Deprecated
    public static NodeInst makeInstance(NodeProto protoType, Point2D center, double width, double height, Cell parent) {
        return NodeInst.makeInstance(protoType, EditingPreferences.getInstance(), center, width, height, parent, Orientation.IDENT, null);
    }

    @Deprecated
    public static NodeInst makeInstance(NodeProto protoType, Point2D center, double width, double height, Cell parent, Orientation orient, String name) {
        return NodeInst.makeInstance(protoType, EditingPreferences.getInstance(), center, width, height, parent, orient, name, 0);
    }

    public static NodeInst makeInstance(NodeProto protoType, EditingPreferences ep, Point2D center, double width, double height, Cell parent) {
        return NodeInst.makeInstance(protoType, ep, center, width, height, parent, Orientation.IDENT, null);
    }

    public static NodeInst makeInstance(NodeProto protoType, EditingPreferences ep, Point2D center, double width, double height, Cell parent, Orientation orient, String name) {
        return NodeInst.makeInstance(protoType, ep, center, width, height, parent, orient, name, 0);
    }

    public static NodeInst makeInstance(NodeProto protoType, EditingPreferences ep, Point2D center, double width, double height, Cell parent, Orientation orient, String name, PrimitiveNode.Function function) {
        NodeInst ni = NodeInst.makeInstance(protoType, ep, center, width, height, parent, orient, name);
        if (ni != null && !ni.isCellInstance()) {
            ni.setPrimitiveFunction(function);
        }
        return ni;
    }

    public static NodeInst makeInstance(NodeProto protoType, EditingPreferences ep, Point2D center, double width, double height, Cell parent, Orientation orient, String name, int techBits) {
        NodeInst ni = NodeInst.newInst(protoType, ep, center, width, height, parent, orient, name, techBits);
        if (ni != null) {
            if (protoType instanceof Cell) {
                if (((Cell)protoType).isWantExpanded()) {
                    ni.setExpanded(true);
                }
            } else {
                protoType.getTechnology().setDefaultOutline(ni);
            }
            CircuitChangeJobs.inheritAttributes(ni, ep);
        }
        return ni;
    }

    public static NodeInst makeInstanceFromPoly(PrimitiveNode np, PolyBase poly, EditingPreferences ep, Cell parent) {
        PolyBase.Point[] pts = poly.getPoints();
        double lX = pts[0].getX();
        double hX = pts[0].getX();
        double lY = pts[0].getY();
        double hY = pts[0].getY();
        for (int i2 = 1; i2 < pts.length; ++i2) {
            if (pts[i2].getX() < lX) {
                lX = pts[i2].getX();
            }
            if (pts[i2].getX() > hX) {
                hX = pts[i2].getX();
            }
            if (pts[i2].getY() < lY) {
                lY = pts[i2].getY();
            }
            if (!(pts[i2].getY() > hY)) continue;
            hY = pts[i2].getY();
        }
        EPoint center = EPoint.fromLambda((lX + hX) / 2.0, (lY + hY) / 2.0);
        NodeInst ni = NodeInst.makeInstance(np, ep, center, hX - lX, hY - lY, parent);
        EPoint[] points = new EPoint[pts.length];
        for (int i3 = 0; i3 < pts.length; ++i3) {
            points[i3] = EPoint.fromLambda(pts[i3].getX(), pts[i3].getY());
        }
        ni.setTrace(points);
        return ni;
    }

    public static NodeInst makeDummyInstance(NodeProto np, EditingPreferences ep) {
        return NodeInst.makeDummyInstance(np, ep, EPoint.ORIGIN, np.getDefWidth(ep), np.getDefHeight(ep), Orientation.IDENT);
    }

    public static NodeInst makeDummyInstance(NodeProto np, EditingPreferences ep, EPoint center, double width, double height, Orientation orient) {
        return NodeInst.makeDummyInstance(np, ep, 0, center, width, height, orient);
    }

    public static NodeInst makeDummyInstance(NodeProto np, EditingPreferences ep, int techBits, EPoint center, double width, double height, Orientation orient) {
        EPoint size = EPoint.ORIGIN;
        if (np instanceof PrimitiveNode) {
            ERectangle full = ((PrimitiveNode)np).getFullRectangle();
            long gridWidth = DBMath.lambdaToSizeGrid(width - full.getLambdaWidth());
            long gridHeight = DBMath.lambdaToSizeGrid(height - full.getLambdaHeight());
            size = EPoint.fromGrid(gridWidth, gridHeight);
        }
        ImmutableNodeInst d2 = ImmutableNodeInst.newInst(0, np.getId(), Name.findName("node@0"), ep.getNodeTextDescriptor(), orient, center, size, 0, techBits, ep.getInstanceTextDescriptor());
        return NodeInst.makeDummyInstance(np, d2);
    }

    public static NodeInst makeDummyInstance(NodeProto np, ImmutableNodeInst d2) {
        if (np.getId() != d2.protoId) {
            throw new IllegalArgumentException();
        }
        return new NodeInst(np, d2);
    }

    public static NodeInst newInst(NodeProto protoType, EditingPreferences ep, Point2D center, double width, double height, Cell parent) {
        return NodeInst.newInst(protoType, ep, center, width, height, parent, Orientation.IDENT, null);
    }

    public static NodeInst newInst(NodeProto protoType, EditingPreferences ep, Point2D center, double width, double height, Cell parent, Orientation orient, String name) {
        return NodeInst.newInst(protoType, ep, center, width, height, parent, orient, name, 0);
    }

    public static NodeInst newInst(NodeProto protoType, EditingPreferences ep, Point2D center, double width, double height, Cell parent, Orientation orient, String name, int techBits) {
        if (name != null && parent.findNode(name) != null) {
            System.out.println(String.valueOf(parent) + " already has NodeInst with name \"" + name + "\"");
            return null;
        }
        EPoint size = EPoint.ORIGIN;
        if (protoType instanceof PrimitiveNode) {
            ERectangle full = ((PrimitiveNode)protoType).getFullRectangle();
            long gridWidth = DBMath.lambdaToSizeGrid(width - full.getLambdaWidth());
            long gridHeight = DBMath.lambdaToSizeGrid(height - full.getLambdaHeight());
            size = EPoint.fromGrid(gridWidth, gridHeight);
        }
        TextDescriptor nameDescriptor = ep.getNodeTextDescriptor();
        TextDescriptor protoDescriptor = ep.getInstanceTextDescriptor();
        return NodeInst.newInst(parent, protoType, name, nameDescriptor, center, size, orient, 0, techBits, protoDescriptor, null);
    }

    public static NodeInst newInst(Cell parent, NodeProto protoType, String name, TextDescriptor nameDescriptor, Point2D center, EPoint size, Orientation orient, int flags, int techBits, TextDescriptor protoDescriptor, ErrorLogger errorLogger) {
        int nodeId;
        if (protoType == null) {
            return null;
        }
        if (parent == null) {
            return null;
        }
        assert (parent.isLinked());
        if (protoType instanceof Cell) assert (((Cell)protoType).isLinked());
        Topology topology = parent.getTopology();
        EPoint anchor = EPoint.snap(center);
        Name nameKey = null;
        String msg = null;
        if (name != null) {
            nameKey = Name.findName(name);
            if (NodeInst.checkNameKey(nameKey, parent) || nameKey.isBus() && (!(protoType instanceof Cell) || !((Cell)protoType).isIcon())) {
                nameKey = null;
            } else if (parent.findNode(name) != null) {
                if (!nameKey.isTempname()) {
                    msg = String.valueOf(parent) + " already has NodeInst with name \"" + name + "\"";
                }
                nameKey = null;
            }
        }
        if (nameKey == null) {
            Name baseName;
            if (protoType instanceof Cell) {
                baseName = ((Cell)protoType).getBasename();
            } else {
                PrimitiveNode np = (PrimitiveNode)protoType;
                baseName = np.getPrimitiveFunction(techBits).getBasename();
            }
            nameKey = topology.getNodeAutoname(baseName);
            if (msg != null) {
                msg = msg + ", renamed to \"" + String.valueOf(nameKey) + "\"";
                System.out.println(msg);
            }
        }
        CellId parentId = parent.getId();
        if (nameDescriptor == null) {
            throw new NullPointerException();
        }
        if (protoDescriptor == null) {
            throw new NullPointerException();
        }
        while (parent.getNodeById(nodeId = parentId.newNodeId()) != null) {
        }
        ImmutableNodeInst d2 = ImmutableNodeInst.newInst(nodeId, protoType.getId(), nameKey, nameDescriptor, orient, anchor, size, flags, techBits, protoDescriptor);
        NodeInst ni = parent.addNode(d2);
        if (ni != null && msg != null && errorLogger != null) {
            errorLogger.logError(msg, ni, parent, null, 1);
        }
        return ni;
    }

    public static NodeInst lowLevelNewInstance(Topology topology, ImmutableNodeInst d2) {
        if (d2.protoId instanceof CellId && ((CellId)d2.protoId).isIcon()) {
            return new IconNodeInst(d2, topology);
        }
        return new NodeInst(d2, topology);
    }

    public void kill() {
        if (!this.isLinked()) {
            System.out.println("NodeInst already killed");
            return;
        }
        this.topology.cell.killNodes(Collections.singleton(this));
    }

    public void move(double dX, double dY) {
        this.modifyInstance(dX, dY, 0.0, 0.0, Orientation.IDENT);
    }

    public void resize(double dXSize, double dYSize) {
        this.modifyInstance(0.0, 0.0, dXSize, dYSize, Orientation.IDENT);
    }

    public void rotate(Orientation dOrient) {
        EPoint[] trace = this.getTrace();
        if (trace != null) {
            assert (this.getOrient() == Orientation.IDENT);
            this.setTraceRelative(trace, this.getAnchorCenter(), dOrient);
        } else {
            this.modifyInstance(0.0, 0.0, 0.0, 0.0, dOrient);
        }
    }

    public void modifyInstance(double dX, double dY, double dXSize, double dYSize, Orientation dOrient) {
        ImmutableNodeInst oldD;
        if (ImmutableNodeInst.isCellCenter(this.protoType.getId())) {
            this.topology.cell.adjustReferencePoint(dX, dY);
            return;
        }
        ImmutableNodeInst d2 = oldD = this.getD();
        if (dX != 0.0 || dY != 0.0) {
            d2 = d2.withAnchor(EPoint.fromLambda(d2.anchor.getX() + dX, d2.anchor.getY() + dY));
        }
        if (this.protoType instanceof PrimitiveNode) {
            double lambdaX = d2.size.getLambdaX() + dXSize;
            double lambdaY = d2.size.getLambdaY() + dYSize;
            d2 = d2.withSize(EPoint.fromLambda(lambdaX, lambdaY));
        }
        d2 = d2.withOrient(dOrient.concatenate(d2.orient));
        this.lowLevelModify(d2);
        if (this.topology != null) {
            Constraints.getCurrent().modifyNodeInst(this, oldD);
        }
    }

    public static void modifyInstances(NodeInst[] nis, double[] dXs, double[] dYs, double[] dXSizes, double[] dYSizes) {
        double dY;
        double dX;
        NodeInst ni;
        int i2;
        for (i2 = 0; i2 < nis.length; ++i2) {
            double dYSize;
            ni = nis[i2];
            if (ni == null) continue;
            dX = dXs != null ? dXs[i2] : 0.0;
            dY = dYs != null ? dYs[i2] : 0.0;
            double dXSize = dXSizes != null ? dXSizes[i2] : 0.0;
            double d2 = dYSize = dYSizes != null ? dYSizes[i2] : 0.0;
            if (Generic.isCellCenter(ni)) continue;
            ni.modifyInstance(dX, dY, dXSize, dYSize, Orientation.IDENT);
        }
        for (i2 = 0; i2 < nis.length; ++i2) {
            ni = nis[i2];
            if (ni == null || !Generic.isCellCenter(ni)) continue;
            dX = dXs != null ? dXs[i2] : 0.0;
            dY = dYs != null ? dYs[i2] : 0.0;
            ni.topology.cell.adjustReferencePoint(dX, dY);
        }
    }

    public NodeInst replace(NodeProto np, EditingPreferences ep, boolean ignorePortNames, boolean allowMissingPorts, boolean preserveParameters) {
        BatchChanges.NodeReplacement replacement = new BatchChanges.NodeReplacement(this, np, PrimitiveNode.Function.UNKNOWN, null);
        if (this.checkReplacement(replacement, ep, ignorePortNames, allowMissingPorts)) {
            return this.doReplace(replacement, ep, allowMissingPorts, preserveParameters);
        }
        return null;
    }

    public boolean checkReplacement(BatchChanges.NodeReplacement replacement, EditingPreferences ep, boolean ignorePortNames, boolean allowMissingPorts) {
        ArrayList<ChangeError> replacementErrors = new ArrayList<ChangeError>();
        this.checkReplacementErrors(replacement, ep, ignorePortNames, allowMissingPorts, replacementErrors);
        if (replacementErrors.size() == 0) {
            return true;
        }
        for (ChangeError ce : replacementErrors) {
            ce.printError();
        }
        return false;
    }

    public NodeInst replaceFullExplain(NodeProto np, EditingPreferences ep, boolean ignorePortNames, boolean allowMissingPorts, boolean preserveParameters, List<ChangeError> problems) {
        BatchChanges.NodeReplacement replacement = new BatchChanges.NodeReplacement(this, np, PrimitiveNode.Function.UNKNOWN, null);
        this.checkReplacementErrors(replacement, ep, ignorePortNames, allowMissingPorts, problems);
        if (problems.size() == 0) {
            return this.doReplace(replacement, ep, allowMissingPorts, preserveParameters);
        }
        return null;
    }

    public void checkReplacementErrors(BatchChanges.NodeReplacement replacement, EditingPreferences ep, boolean ignorePortNames, boolean allowMissingPorts, List<ChangeError> replacementErrors) {
        PortInst opi;
        int index;
        EDatabase database = this.getDatabase();
        NodeProto np = replacement.newProtoId.inDatabase(database);
        if (np instanceof Cell && Cell.isInstantiationRecursive((Cell)np, this.topology.cell)) {
            replacementErrors.add(new ChangeError(1, null, null, null));
            return;
        }
        NodeInst newNi = NodeInst.makeDummyInstance(np, replacement.newImmutableInst(this.getDatabase().backup(), ep));
        assert (newNi != null);
        PortAssociation[] oldAssoc = this.portAssociate(this, newNi, ignorePortNames);
        assert (oldAssoc.length == this.getNumPortInsts());
        for (int portIndex = 0; portIndex < oldAssoc.length; ++portIndex) {
            assert (oldAssoc[portIndex].portInst == this.getPortInst(portIndex));
        }
        Iterator<Object> it = this.getConnections();
        while (it.hasNext()) {
            Connection con = it.next();
            for (index = 0; index < oldAssoc.length && oldAssoc[index].portInst != con.getPortInst(); ++index) {
            }
            if (index >= oldAssoc.length || oldAssoc[index].assn == null) {
                if (allowMissingPorts) continue;
                replacementErrors.add(new ChangeError(2, con.getArc(), con.getPortInst(), null));
                continue;
            }
            opi = oldAssoc[index].assn;
            ArcInst ai = con.getArc();
            if (opi.getPortProto().connectsTo(ai.getProto()) || allowMissingPorts) continue;
            replacementErrors.add(new ChangeError(3, con.getArc(), con.getPortInst(), opi.getPortProto()));
        }
        if (replacementErrors.size() > 0) {
            return;
        }
        it = this.getExports();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            for (index = 0; index < oldAssoc.length && oldAssoc[index].portInst != pp.getOriginalPort(); ++index) {
            }
            if (index >= oldAssoc.length || oldAssoc[index].assn == null) {
                replacementErrors.add(new ChangeError(4, null, null, pp));
                continue;
            }
            opi = oldAssoc[index].assn;
            Connection conErr = pp.doesntConnectCon(opi.getPortProto().getBasePort());
            if (conErr == null) continue;
            replacementErrors.add(new ChangeError(5, conErr.getArc(), null, opi.getPortProto()));
        }
        if (replacementErrors.size() == 0) {
            for (int portIndex = 0; portIndex < oldAssoc.length; ++portIndex) {
                replacement.setAssoc(oldAssoc[portIndex].portInst, oldAssoc[portIndex].assn);
            }
        }
    }

    public NodeInst doReplace(BatchChanges.NodeReplacement replacement, EditingPreferences ep, boolean allowMissingPorts, boolean preserveParameters) {
        EDatabase database = this.topology.cell.getDatabase();
        assert (replacement.getOldNi(database) == this);
        ImmutableNodeInst newD = replacement.newImmutableInst(database.backup(), ep);
        HashSet<ArcInst> arcList = new HashSet<ArcInst>();
        Iterator<Connection> it = this.getConnections();
        while (it.hasNext()) {
            arcList.add(it.next().getArc());
        }
        HashMap<Export, PortInst> exportList = new HashMap<Export, PortInst>();
        Iterator<Export> it2 = this.getExports();
        while (it2.hasNext()) {
            Iterator e2 = it2.next();
            exportList.put((Export)((Object)e2), ((Export)((Object)e2)).getOriginalPort());
        }
        for (Iterator e2 : exportList.keySet()) {
            NodeInst dummyNi = NodeInst.newInst(Generic.tech().universalPinNode, ep, EPoint.ORIGIN, 0.0, 0.0, this.topology.cell);
            boolean ok = ((Export)((Object)e2)).move(dummyNi.getOnlyPortInst());
            assert (!ok);
        }
        assert (!this.hasExports());
        this.kill();
        NodeInst newNi = this.topology.cell.addNode(newD);
        assert (newNi.d == newD && newNi.protoType.getId() == replacement.newProtoId && !newNi.validVisBounds);
        for (ArcInst ai : arcList) {
            ArcInst newAi;
            NodeInst adjustThisNode;
            int ang;
            int ii;
            PortInst[] newPortInst = new PortInst[2];
            EPoint[] newPoint = new EPoint[2];
            int otherEnd = 0;
            for (int e3 = 0; e3 < 2; ++e3) {
                EPoint newLoc;
                PortProto newPort;
                PortInst pi = ai.getPortInst(e3);
                if (pi.getNodeInst() != this) {
                    newPortInst[e3] = pi;
                    newPoint[e3] = ai.getLocation(e3);
                    otherEnd = e3;
                    continue;
                }
                PortProtoId newPortId = replacement.assoc[pi.getPortIndex()];
                PortProto portProto = newPort = newPortId != null ? newPortId.inDatabase(database) : null;
                if (newPort == null) {
                    assert (allowMissingPorts);
                    continue;
                }
                PortInst opi = newNi.findPortInstFromProto(newPort);
                assert (opi != null);
                newPortInst[e3] = opi;
                Poly poly = opi.getPoly();
                newPoint[e3] = poly.isInside(newLoc = ai.getLocation(e3)) ? newLoc : EPoint.fromLambda(poly.getCenterX(), poly.getCenterY());
            }
            if (newPortInst[0] == null || newPortInst[1] == null) continue;
            boolean zigzag = false;
            if (ai.isFixedAngle() && (newPoint[0].getX() != newPoint[1].getX() || newPoint[0].getY() != newPoint[1].getY()) && (ii = DBMath.figureAngle(newPoint[0], newPoint[1])) % 1800 != (ang = ai.getDefinedAngle()) % 1800) {
                zigzag = true;
            }
            if (zigzag && !ai.isRigid() && ai.getDefinedAngle() % 900 == 0 && !(adjustThisNode = ai.getPortInst(otherEnd).getNodeInst()).hasExports()) {
                boolean adjustable = true;
                Iterator<Connection> oIt = adjustThisNode.getConnections();
                while (oIt.hasNext()) {
                    Connection otherCon = oIt.next();
                    ArcInst otherArc = otherCon.getArc();
                    if (otherArc == ai) continue;
                    if (otherArc.isRigid()) {
                        adjustable = false;
                        break;
                    }
                    if (otherArc.getDefinedAngle() % 900 != 0) {
                        adjustable = false;
                        break;
                    }
                    if ((ai.getDefinedAngle() / 900 & 1) != (otherArc.getDefinedAngle() / 900 & 1)) continue;
                    adjustable = false;
                    break;
                }
                if (adjustable) {
                    double dX = 0.0;
                    double dY = 0.0;
                    if (ai.getDefinedAngle() % 1800 == 0) {
                        dY = newPoint[1 - otherEnd].getY() - newPoint[otherEnd].getY();
                        newPoint[otherEnd] = EPoint.fromLambda(newPoint[otherEnd].getX(), newPoint[1 - otherEnd].getY());
                    } else {
                        dX = newPoint[1 - otherEnd].getX() - newPoint[otherEnd].getX();
                        newPoint[otherEnd] = EPoint.fromLambda(newPoint[1 - otherEnd].getX(), newPoint[otherEnd].getY());
                    }
                    adjustThisNode.move(dX, dY);
                    ArcInst newAi2 = ArcInst.newInstanceBase(ai.getProto(), ep, ai.getLambdaBaseWidth(), newPortInst[1], newPortInst[0], newPoint[1], newPoint[0], ai.getName(), -1);
                    if (newAi2 == null) {
                        throw new IllegalArgumentException();
                    }
                    newAi2.copyPropertiesFrom(ai);
                    continue;
                }
            }
            if (zigzag) {
                double cX = newPoint[0].getX();
                double cY = newPoint[1].getY();
                PrimitiveNode pinNp = ai.getProto().findOverridablePinProto(ep);
                double psx = pinNp.getDefWidth(ep);
                double psy = pinNp.getDefHeight(ep);
                NodeInst pinNi = NodeInst.newInst(pinNp, ep, new Point2D.Double(cX, cY), psx, psy, this.topology.cell);
                PortInst pinPi = pinNi.getOnlyPortInst();
                newAi = ArcInst.newInstanceBase(ai.getProto(), ep, ai.getLambdaBaseWidth(), newPortInst[1], pinPi, newPoint[1], new Point2D.Double(cX, cY), null, -1);
                if (newAi == null) {
                    throw new IllegalArgumentException();
                }
                newAi.copyPropertiesFrom(ai);
                ArcInst newAi2 = ArcInst.newInstanceBase(ai.getProto(), ep, ai.getLambdaBaseWidth(), pinPi, newPortInst[0], new Point2D.Double(cX, cY), newPoint[0], null, -1);
                if (newAi2 == null) {
                    throw new IllegalArgumentException();
                }
                newAi2.copyConstraintsFrom(ai);
                if (newPortInst[0].getNodeInst() == this) {
                    ArcInst aiSwap = newAi;
                    newAi = newAi2;
                    newAi2 = aiSwap;
                }
            } else {
                newAi = ArcInst.newInstanceBase(ai.getProto(), ep, ai.getLambdaBaseWidth(), newPortInst[1], newPortInst[0], newPoint[1], newPoint[0], null, -1);
                if (newAi == null) {
                    throw new IllegalArgumentException();
                }
                newAi.copyPropertiesFrom(ai);
            }
            newAi.setName(ai.getName(), ep);
        }
        for (Map.Entry e4 : exportList.entrySet()) {
            PortProto newPortProto;
            Export pp = (Export)e4.getKey();
            NodeInst dummyNi = pp.getOriginalPort().getNodeInst();
            assert (dummyNi.getProto() == Generic.tech().universalPinNode);
            assert (!dummyNi.hasConnections());
            PortInst originalPort = (PortInst)e4.getValue();
            assert (originalPort.getNodeInst() == this);
            PortProtoId newProtoId = replacement.assoc[originalPort.getPortIndex()];
            PortProto portProto = newPortProto = newProtoId != null ? newProtoId.inDatabase(database) : null;
            if (newPortProto == null) {
                assert (allowMissingPorts);
                pp.kill();
                continue;
            }
            PortInst newPi = newNi.findPortInstFromProto(newPortProto);
            assert (newPi != null);
            if (pp.move(newPi)) {
                pp.kill();
            }
            assert (!dummyNi.hasExports());
            dummyNi.kill();
        }
        Name basename = this.getBasename();
        if (newD.name.isTempname() && newD.name.getBasename() != basename) {
            newNi.setName(this.topology.getNodeAutoname(basename).toString());
        }
        return newNi;
    }

    @Override
    public ImmutableNodeInst getD() {
        return this.d;
    }

    public boolean setD(ImmutableNodeInst newD, boolean notify) {
        this.checkChanging();
        ImmutableNodeInst oldD = this.d;
        if (newD == oldD) {
            return false;
        }
        if (this.topology != null) {
            this.topology.cell.setTopologyModified();
            this.d = newD;
            assert (this.protoType == this.d.protoId.inDatabase(this.getDatabase()));
            if (notify) {
                Constraints.getCurrent().modifyNodeInst(this, oldD);
            }
        } else {
            this.d = newD;
            assert (this.protoType.getId() == this.d.protoId);
        }
        return true;
    }

    public void setDInUndo(ImmutableNodeInst newD) {
        this.checkUndoing();
        assert (this.d.protoId.isIcon() == newD.protoId.isIcon());
        this.d = newD;
        this.protoType = this.d.protoId.inDatabase(this.getDatabase());
        this.validVisBounds = false;
    }

    @Override
    public void addVar(Variable var) {
        if (this.setD(this.d.withVariable(var), true)) {
            this.checkPossibleVariableEffects(var.getKey());
        }
    }

    void addVar(PortProtoId portProtoId, Variable var) {
        this.setD(this.d.withPortInst(portProtoId, this.d.getPortInst(portProtoId).withVariable(var)), true);
    }

    @Override
    public void delVar(Variable.Key key) {
        if (this.setD(this.d.withoutVariable(key), true)) {
            this.checkPossibleVariableEffects(key);
        }
    }

    void delVar(PortProtoId portProtoId, Variable.Key key) {
        this.setD(this.d.withPortInst(portProtoId, this.d.getPortInst(portProtoId).withoutVariable(key)), true);
    }

    void delVars(PortProtoId portProtoId) {
        this.setD(this.d.withPortInst(portProtoId, ImmutablePortInst.EMPTY), true);
    }

    public void copyVarsFrom(NodeInst other) {
        this.checkChanging();
        Iterator<Variable> it = other.getVariables();
        while (it.hasNext()) {
            Variable var = it.next();
            if (var.getKey() == TRACE) {
                assert (other.getOrient() == Orientation.IDENT);
                this.setTraceRelative((EPoint[])var.getObject(), other.getAnchorCenter(), Orientation.IDENT);
                continue;
            }
            this.addVar(var);
        }
    }

    public void lowLevelModify(ImmutableNodeInst d2) {
        if (this.topology != null) {
            boolean renamed;
            this.checkChanging();
            boolean bl = renamed = this.d.name != d2.name;
            if (renamed) {
                this.topology.removeNodeName(this);
            }
            this.setD(d2, false);
            if (renamed) {
                this.topology.addNodeName(this);
            }
            this.redoGeometric();
        } else {
            this.d = d2;
            this.redoGeometric();
        }
    }

    public boolean isIconOfParent() {
        return this.protoType instanceof Cell && ((Cell)this.protoType).isIconOf(this.topology.cell);
    }

    @Deprecated
    public final int getNodeIndex() {
        return this.topology != null ? this.topology.cell.backup().cellRevision.getNodeIndexByNodeId(this.getNodeId()) : -1;
    }

    public final int getNodeId() {
        return this.getD().nodeId;
    }

    @Override
    public boolean isLinked() {
        try {
            if (this.topology == null) {
                return false;
            }
            Cell parent = this.topology.cell;
            return parent.isLinked() && parent.getNodeById(this.getNodeId()) == this;
        }
        catch (IndexOutOfBoundsException e2) {
            return false;
        }
    }

    @Override
    public Topology getTopology() {
        return this.topology;
    }

    @Override
    public void checkChanging() {
        if (this.topology != null) {
            this.topology.cell.checkChanging();
        }
    }

    @Override
    public Cell whichCell() {
        return this.topology.cell;
    }

    @Override
    public EDatabase getDatabase() {
        return this.topology != null ? this.topology.cell.getDatabase() : null;
    }

    public CellTree getCellTree() {
        if (this.topology != null) {
            return this.topology.cell.tree();
        }
        CellId clipCellId = Clipboard.getClipCellId();
        ImmutableCell cell = ImmutableCell.newInst(clipCellId, 0L);
        cell = cell.withTechId(this.getProto().getTechnology().getId());
        TechPool techPool = TechPool.getThreadTechPool();
        CellBackup cellBackup = CellBackup.newInst(cell, techPool);
        cellBackup = cellBackup.with(cell, new ImmutableNodeInst[]{this.getD()}, null, null, techPool);
        CellTree[] subTrees = CellTree.NULL_ARRAY;
        if (this.isCellInstance()) {
            Cell subCell = (Cell)this.protoType;
            CellUsage cu = clipCellId.getUsageIn(subCell.getId());
            subTrees = new CellTree[cu.indexInParent + 1];
            subTrees[cu.indexInParent] = subCell.tree();
        }
        CellTree cellTree = CellTree.newInst(cell, techPool).with(cellBackup, subTrees, techPool);
        return cellTree;
    }

    public CellBackup getCellBackup() {
        if (this.topology != null) {
            return this.topology.cell.backup();
        }
        CellId clipCellId = Clipboard.getClipCellId();
        ImmutableCell cell = ImmutableCell.newInst(clipCellId, 0L);
        cell = cell.withTechId(this.getProto().getTechnology().getId());
        TechPool techPool = TechPool.getThreadTechPool();
        CellBackup cellBackup = CellBackup.newInst(cell, techPool);
        cellBackup = cellBackup.with(cell, new ImmutableNodeInst[]{this.getD()}, null, null, techPool);
        return cellBackup;
    }

    public Orientation getOrient() {
        return this.d.orient;
    }

    public int getAngle() {
        return this.d.orient.getAngle();
    }

    public EPoint getAnchorCenter() {
        return this.d.anchor;
    }

    public double getAnchorCenterX() {
        return this.d.anchor.getX();
    }

    public double getAnchorCenterY() {
        return this.d.anchor.getY();
    }

    public double getXSize() {
        if (this.protoType instanceof Cell) {
            return ((Cell)this.protoType).getDefWidth();
        }
        long fullWidth = ((PrimitiveNode)this.protoType).getFullRectangle().getGridWidth();
        return DBMath.gridToLambda(this.d.size.getGridX() + fullWidth);
    }

    public double getLambdaBaseXSize() {
        if (this.protoType instanceof Cell) {
            return ((Cell)this.protoType).getDefWidth();
        }
        return DBMath.gridToLambda(this.d.size.getGridX() + this.getBaseRectangle().getGridWidth());
    }

    public double getXSizeWithoutOffset() {
        return GenMath.isNinetyDegreeRotation(this.getAngle()) ? this.getLambdaBaseYSize() : this.getLambdaBaseXSize();
    }

    public double getYSize() {
        if (this.protoType instanceof Cell) {
            return ((Cell)this.protoType).getDefHeight();
        }
        long fullHeight = ((PrimitiveNode)this.protoType).getFullRectangle().getGridHeight();
        return DBMath.gridToLambda(this.d.size.getGridY() + fullHeight);
    }

    public double getLambdaBaseYSize() {
        if (this.protoType instanceof Cell) {
            return ((Cell)this.protoType).getDefHeight();
        }
        return DBMath.gridToLambda(this.d.size.getGridY() + this.getBaseRectangle().getGridHeight());
    }

    public double getYSizeWithoutOffset() {
        return GenMath.isNinetyDegreeRotation(this.getAngle()) ? this.getLambdaBaseXSize() : this.getLambdaBaseYSize();
    }

    public boolean isMirroredAboutXAxis() {
        return this.isYMirrored();
    }

    public boolean isMirroredAboutYAxis() {
        return this.isXMirrored();
    }

    public boolean isXMirrored() {
        return this.d.orient.isXMirrored();
    }

    public boolean isYMirrored() {
        return this.d.orient.isYMirrored();
    }

    @Override
    public Iterator<Poly> getShape(Poly.Builder polyBuilder) {
        return polyBuilder.getShape(this);
    }

    public Poly getBaseShape() {
        return this.getBaseShape(this.d.anchor, this.d.size);
    }

    public Poly getBaseShape(EPoint anchor, double baseWidth, double baseHeight) {
        EPoint newSize = EPoint.ORIGIN;
        if (this.protoType instanceof PrimitiveNode) {
            ERectangle base = this.getBaseRectangle();
            newSize = EPoint.fromLambda(baseWidth - base.getWidth(), baseHeight - base.getHeight());
        }
        return this.getBaseShape(anchor, newSize);
    }

    private Poly getBaseShape(EPoint anchor, EPoint size) {
        double nodeHighY;
        double nodeLowY;
        double nodeHighX;
        double nodeLowX;
        if (this.protoType instanceof Cell) {
            ERectangle r = ((Cell)this.protoType).getBounds();
            nodeLowX = r.getLambdaMinX();
            nodeHighX = r.getLambdaMaxX();
            nodeLowY = r.getLambdaMinY();
            nodeHighY = r.getLambdaMaxY();
        } else {
            ERectangle baseRect = this.getBaseRectangle();
            long halfW = size.getGridX() >> 1;
            long halfH = size.getGridY() >> 1;
            nodeLowX = DBMath.gridToLambda(-halfW + baseRect.getGridMinX());
            nodeHighX = DBMath.gridToLambda(halfW + baseRect.getGridMaxX());
            nodeLowY = DBMath.gridToLambda(-halfH + baseRect.getGridMinY());
            nodeHighY = DBMath.gridToLambda(halfH + baseRect.getGridMaxY());
        }
        PolyBase.Point[] points = nodeLowX != nodeHighX || nodeLowY != nodeHighY ? Poly.makePoints(nodeLowX, nodeHighX, nodeLowY, nodeHighY) : new PolyBase.Point[]{Poly.fromLambda(nodeLowX, nodeLowY)};
        Poly poly = new Poly(points);
        FixpTransform trans = new FixpTransform(anchor, this.getOrient());
        poly.transform(trans);
        return poly;
    }

    @Override
    public ERectangle getBounds() {
        if (!this.validVisBounds) {
            this.computeBounds();
        }
        return this.visBounds;
    }

    private void computeBounds() {
        long[] gridBounds = new long[4];
        if (this.d.protoId instanceof CellId) {
            Cell subCell = (Cell)this.getProto();
            ERectangle subBounds = subCell.getBounds();
            gridBounds[0] = subBounds.getGridMinX();
            gridBounds[1] = subBounds.getGridMinY();
            gridBounds[2] = subBounds.getGridMaxX();
            gridBounds[3] = subBounds.getGridMaxY();
            this.d.orient.rectangleBounds(gridBounds);
            long anchorX = this.d.anchor.getGridX();
            long anchorY = this.d.anchor.getGridY();
            gridBounds[0] = gridBounds[0] + anchorX;
            gridBounds[1] = gridBounds[1] + anchorY;
            gridBounds[2] = gridBounds[2] + anchorX;
            gridBounds[3] = gridBounds[3] + anchorY;
        } else {
            PrimitiveNode pn = (PrimitiveNode)this.getProto();
            pn.genBounds(this.d, gridBounds);
        }
        long gridMinX = gridBounds[0];
        long gridMinY = gridBounds[1];
        long gridMaxX = gridBounds[2];
        long gridMaxY = gridBounds[3];
        if (this.visBounds == null || gridMinX != this.visBounds.getGridMinX() || gridMinY != this.visBounds.getGridMinY() || gridMaxX != this.visBounds.getGridMaxX() || gridMaxY != this.visBounds.getGridMaxY()) {
            this.visBounds = ERectangle.fromGrid(gridMinX, gridMinY, gridMaxX - gridMinX, gridMaxY - gridMinY);
        }
        this.validVisBounds = true;
    }

    public void redoGeometric() {
        if (this.topology != null) {
            this.topology.cell.unfreshRTree();
        }
        this.validVisBounds = false;
    }

    public double[] getArcDegrees() {
        PrimitiveNode pnp;
        double[] returnValues = new double[2];
        if (this.protoType instanceof PrimitiveNode && (pnp = (PrimitiveNode)this.protoType).isPartialCircle()) {
            return this.getD().getArcDegrees();
        }
        return returnValues;
    }

    public void setArcDegrees(double start, double curvature, EditingPreferences ep) {
        if (!(this.protoType instanceof PrimitiveNode)) {
            return;
        }
        PrimitiveNode pnp = (PrimitiveNode)this.protoType;
        if (!pnp.isPartialCircle()) {
            return;
        }
        if (start == 0.0 && curvature == 0.0) {
            if (this.getVar(Artwork.ART_DEGREES) == null) {
                return;
            }
            this.delVar(Artwork.ART_DEGREES);
        } else {
            Float[] fAddr = new Float[]{Float.valueOf((float)start), Float.valueOf((float)curvature)};
            this.newVar(Artwork.ART_DEGREES, (Object)fAddr, ep);
        }
    }

    private ERectangle getBaseRectangle() {
        return ((PrimitiveNode)this.protoType).getBaseRectangle();
    }

    public Rectangle2D getUntransformedBounds() {
        long hy;
        long ly;
        long hx;
        long lx;
        if (this.protoType instanceof PrimitiveNode) {
            ERectangle baseRect = this.getBaseRectangle();
            long halfW = this.d.size.getGridX() >> 1;
            long halfH = this.d.size.getGridY() >> 1;
            lx = -halfW + baseRect.getGridMinX();
            hx = halfW + baseRect.getGridMaxX();
            ly = -halfH + baseRect.getGridMinY();
            hy = halfH + baseRect.getGridMaxY();
        } else {
            ERectangle bounds = ((Cell)this.protoType).getBounds();
            lx = bounds.getGridMinX();
            hx = bounds.getGridMaxX();
            ly = bounds.getGridMinY();
            hy = bounds.getGridMaxY();
        }
        EPoint anchor = this.getAnchorCenter();
        return ERectangle.fromGrid(lx + anchor.getGridX(), ly + anchor.getGridY(), hx - lx, hy - ly);
    }

    @Override
    public Variable getParameter(Variable.Key key) {
        return null;
    }

    @Override
    public boolean isDefinedParameter(Variable.Key key) {
        return false;
    }

    @Override
    public Iterator<Variable> getParameters() {
        return ArrayIterator.emptyIterator();
    }

    @Override
    public Iterator<Variable> getDefinedParameters() {
        return ArrayIterator.emptyIterator();
    }

    public void addParameter(Variable param) {
    }

    public void delParameter(Variable.Key key) {
    }

    public Variable updateParam(Variable.Key key, Object value, EditingPreferences ep) {
        return null;
    }

    @Override
    public void addDisplayableVariables(Rectangle2D rect, List<Poly> polys, EditWindow0 wnd, boolean multipleStrings, boolean showTempNames) {
        PrimitiveNode.Function fun = this.getFunction();
        if (fun == PrimitiveNode.Function.PIN || fun == PrimitiveNode.Function.ART) {
            showTempNames = false;
        }
        if ((this.isUsernamed() || showTempNames && this.isLinked()) && this.d.nameDescriptor.isDisplay()) {
            double cX = rect.getCenterX();
            double cY = rect.getCenterY();
            TextDescriptor td = this.d.nameDescriptor;
            double offX = td.getXOff();
            double offY = td.getYOff();
            AbstractTextDescriptor.Position pos = td.getPos();
            Poly.Type style = pos.getPolyType();
            if (offX != 0.0 || offY != 0.0) {
                td = td.withOff(0.0, 0.0);
                style = Poly.rotateType(style, this);
            }
            PolyBase.Point[] pointList = style == Poly.Type.TEXTBOX ? Poly.makePoints(rect) : new PolyBase.Point[]{Poly.fromLambda(cX + offX, cY + offY)};
            Poly poly = new Poly(pointList);
            poly.setStyle(style);
            poly.setString(this.getNameKey().toString());
            poly.setTextDescriptor(td);
            poly.setLayer(null);
            poly.setDisplayedText(new DisplayedText(this, NODE_NAME));
            polys.add(poly);
        }
        super.addDisplayableVariables(rect, polys, wnd, multipleStrings, showTempNames);
        Iterator<PortInst> it = this.getPortInsts();
        while (it.hasNext()) {
            PortInst pi = it.next();
            pi.addDisplayableVariables(rect, polys, wnd, multipleStrings, showTempNames);
        }
    }

    public Poly[] getDisplayableVariables(EditWindow0 wnd, boolean showTempNames) {
        PrimitiveNode.Function fun = this.getFunction();
        if (fun == PrimitiveNode.Function.PIN || fun == PrimitiveNode.Function.ART) {
            showTempNames = false;
        }
        return this.getDisplayableVariables(this.getUntransformedBounds(), wnd, true, showTempNames);
    }

    public FixpTransform transformOut() {
        return new FixpTransform(this.d.anchor, this.d.orient);
    }

    public FixpTransform transformOut(FixpTransform prevTransform) {
        FixpTransform transform = this.transformOut();
        transform.preConcatenate(prevTransform);
        return transform;
    }

    public FixpTransform transformIn() {
        return this.d.orient.inverse().rotateAbout(0.0, 0.0, -this.getAnchorCenterX(), -this.getAnchorCenterY());
    }

    public FixpTransform transformIn(FixpTransform prevTransform) {
        FixpTransform transform = this.transformIn();
        transform.concatenate(prevTransform);
        return transform;
    }

    public FixpTransform translateIn() {
        double dx = this.getAnchorCenterX();
        double dy = this.getAnchorCenterY();
        FixpTransform transform = new FixpTransform();
        transform.translate(-dx, -dy);
        return transform;
    }

    public FixpTransform translateIn(FixpTransform prevTransform) {
        FixpTransform transform = this.translateIn();
        FixpTransform returnTransform = new FixpTransform(prevTransform);
        returnTransform.concatenate(transform);
        return returnTransform;
    }

    public FixpTransform translateOut() {
        double dx = this.getAnchorCenterX();
        double dy = this.getAnchorCenterY();
        FixpTransform transform = new FixpTransform();
        transform.translate(dx, dy);
        return transform;
    }

    public FixpTransform translateOut(FixpTransform prevTransform) {
        FixpTransform transform = this.translateOut();
        FixpTransform returnTransform = new FixpTransform(prevTransform);
        returnTransform.concatenate(transform);
        return returnTransform;
    }

    public FixpTransform pureRotateOut() {
        return this.d.orient.pureRotate();
    }

    public FixpTransform pureRotateIn() {
        return this.d.orient.inverse().pureRotate();
    }

    public FixpTransform rotateIn() {
        return this.d.orient.inverse().rotateAbout(this.d.anchor);
    }

    public FixpTransform rotateIn(FixpTransform prevTransform) {
        if (this.d.orient == Orientation.IDENT) {
            return prevTransform;
        }
        FixpTransform transform = this.rotateIn();
        FixpTransform returnTransform = new FixpTransform(prevTransform);
        returnTransform.concatenate(transform);
        return returnTransform;
    }

    public FixpTransform rotateOut() {
        return this.d.orient.rotateAbout(this.d.anchor);
    }

    public FixpTransform rotateOutAboutTrueCenter() {
        return this.d.orient.rotateAbout(this.getTrueCenterX(), this.getTrueCenterY());
    }

    public FixpTransform rotateOut(FixpTransform prevTransform) {
        if (this.d.orient == Orientation.IDENT) {
            return prevTransform;
        }
        FixpTransform transform = this.rotateOut();
        FixpTransform returnTransform = new FixpTransform(prevTransform);
        returnTransform.concatenate(transform);
        return returnTransform;
    }

    public FixpTransform rotateOutAboutTrueCenter(FixpTransform prevTransform) {
        if (this.d.orient == Orientation.IDENT) {
            return prevTransform;
        }
        FixpTransform transform = this.rotateOutAboutTrueCenter();
        FixpTransform returnTransform = new FixpTransform(prevTransform);
        returnTransform.concatenate(transform);
        return returnTransform;
    }

    public Poly getShapeOfPort(PortProto thePort) {
        if (this.isCellInstance()) {
            Cell subCell = (Cell)this.getProto();
            Export export = (Export)thePort;
            if (export.getParent() != subCell) {
                throw new IllegalArgumentException();
            }
            Poly poly = export.getPoly();
            poly.transform(this.transformOut());
            return poly;
        }
        Poly.Builder polyBuilder = Poly.newLambdaBuilder();
        return polyBuilder.getShape(this.getD(), (PrimitivePort)thePort);
    }

    public Poly getShapeOfPortForWiringTool(PortProto thePort, Point2D selectPt, EditingPreferences ep, double arcWidth) {
        PortOriginal fp = new PortOriginal(this, thePort);
        FixpTransform trans = fp.getTransformToTop();
        ImmutableNodeInst n2 = fp.getBottomImmutableNodeInst();
        PrimitivePort pp = fp.getBottomPortProto();
        PrimitiveNode np = pp.getParent();
        Poly.Builder polyBuilder = Poly.threadLocalLambdaBuilder();
        Poly poly = polyBuilder.getShape(this.getCellTree(), n2, pp, selectPt);
        Rectangle2D box = poly.getBox();
        if (box != null) {
            if (arcWidth != -1.0 && np.getFunction().isContact()) {
                ERectangle baseRectangle = np.getBaseRectangle();
                double width = DBMath.gridToLambda(n2.size.getGridX() + baseRectangle.getGridWidth());
                double height = DBMath.gridToLambda(n2.size.getGridY() + baseRectangle.getGridHeight());
                double newportwidth = width - arcWidth;
                double newportheight = height - arcWidth;
                if (newportwidth < 0.0) {
                    newportwidth = 0.0;
                }
                if (newportheight < 0.0) {
                    newportheight = 0.0;
                }
                double offsetX = 0.0;
                double offsetY = 0.0;
                if (newportwidth < box.getWidth()) {
                    offsetX = 0.5 * (newportwidth - box.getWidth());
                    box = new Rectangle2D.Double(box.getX() - offsetX, box.getY(), box.getWidth() + 2.0 * offsetX, box.getHeight());
                }
                if (newportheight < box.getHeight()) {
                    offsetY = 0.5 * (newportheight - box.getHeight());
                    box = new Rectangle2D.Double(box.getX(), box.getY() - offsetY, box.getWidth(), box.getHeight() + 2.0 * offsetY);
                }
            }
            if (n2.size.getGridX() == np.getDefSize(ep).getGridX()) {
                double x = poly.getCenterX();
                box = new Rectangle2D.Double(x, box.getMinY(), 0.0, box.getHeight());
            }
            if (n2.size.getGridY() == np.getDefSize(ep).getGridY()) {
                double y = poly.getCenterY();
                box = new Rectangle2D.Double(box.getMinX(), y, box.getWidth(), 0.0);
            }
            poly = new Poly(box);
        }
        poly.transform(trans);
        return poly;
    }

    public EPoint[] getTrace() {
        return this.getD().getTrace();
    }

    public void setTrace(Point2D[] points) {
        EPoint[] epoints;
        if (this.isCellInstance() || ImmutableNodeInst.isCellCenter(this.getProto().getId())) {
            throw new IllegalArgumentException();
        }
        if (points instanceof EPoint[]) {
            epoints = (EPoint[])points;
        } else {
            epoints = new EPoint[points.length];
            for (int i2 = 0; i2 < points.length; ++i2) {
                Point2D p = points[i2];
                if (p instanceof EPoint) {
                    epoints[i2] = (EPoint)p;
                    continue;
                }
                if (p == null) continue;
                epoints[i2] = EPoint.snap(p);
            }
        }
        this.setTrace(epoints);
    }

    public void setTrace(EPoint[] points) {
        this.setTraceRelative(points, null, null);
    }

    public void setTraceRelative(EPoint[] points, EPoint anchor, Orientation orient) {
        if (orient != null && !orient.isIdent()) {
            AbstractFixpPoint[] newPoints = new EPoint[points.length];
            for (int i2 = 0; i2 < points.length; ++i2) {
                if (points[i2] == null) continue;
                orient.transform(0L, 0L, points, i2, newPoints, i2, 1);
            }
            points = newPoints;
        }
        ImmutableNodeInst oldD = this.getD();
        this.lowLevelModify(oldD.withTrace(points, anchor));
        if (this.topology != null) {
            Constraints.getCurrent().modifyNodeInst(this, oldD);
        }
    }

    public boolean traceWraps() {
        if (this.protoType == Artwork.tech().splineNode || this.protoType == Artwork.tech().openedPolygonNode || this.protoType == Artwork.tech().openedDottedPolygonNode || this.protoType == Artwork.tech().openedDashedPolygonNode || this.protoType == Artwork.tech().openedThickerPolygonNode) {
            return false;
        }
        return !this.getFunction().isFET();
    }

    public Iterator<PortInst> getPortInsts() {
        return ArrayIterator.iterator(this.portInsts);
    }

    public int getNumPortInsts() {
        return this.portInsts.length;
    }

    public PortInst getPortInst(int portIndex) {
        return this.portInsts[portIndex];
    }

    public PortInst getOnlyPortInst() {
        int sz = this.portInsts.length;
        if (sz != 1) {
            System.out.println("NodeInst.getOnlyPortInst: " + String.valueOf(this.topology.cell) + ", " + String.valueOf(this) + " doesn't have just one port, it has " + sz);
            return null;
        }
        return this.portInsts[0];
    }

    public PortInst findPortInst(String name) {
        PortProto pp = this.protoType.findPortProto(name);
        if (pp == null) {
            return null;
        }
        return this.portInsts[pp.getPortIndex()];
    }

    public PortInst findClosestPortInst(Point2D w) {
        double bestDist = Double.MAX_VALUE;
        PortInst bestPi = null;
        for (int i2 = 0; i2 < this.portInsts.length; ++i2) {
            PortInst pi = this.portInsts[i2];
            Poly piPoly = pi.getPoly();
            Point2D.Double piPt = new Point2D.Double(piPoly.getCenterX(), piPoly.getCenterY());
            double thisDist = piPt.distance(w);
            if (!(thisDist < bestDist)) continue;
            bestDist = thisDist;
            bestPi = pi;
        }
        return bestPi;
    }

    public PortInst findPortInstFromProto(PortProto pp) {
        if (pp instanceof Export && !((Export)pp).isLinked() || pp.getParent() != this.getProto()) {
            throw new IllegalArgumentException();
        }
        return this.portInsts[pp.getPortIndex()];
    }

    public PortInst findPortInstFromEquivalentProto(PortProto pp) {
        if (pp instanceof Export && ((Export)pp).isLinked() && pp.getParent() != this.getProto()) {
            pp = ((Export)pp).findEquivalent((Cell)this.getProto());
        }
        return this.findPortInstFromProto(pp);
    }

    public void updatePortInsts(int[] pattern) {
        assert (pattern.length == this.protoType.getNumPorts());
        if (pattern.length == 0) {
            this.portInsts = NULL_PORT_INST_ARRAY;
            return;
        }
        PortInst[] newPortInsts = new PortInst[pattern.length];
        for (int i2 = 0; i2 < newPortInsts.length; ++i2) {
            int p = pattern[i2];
            newPortInsts[i2] = p >= 0 ? this.portInsts[p] : PortInst.newInst(this.protoType.getPort(i2), this);
        }
        this.portInsts = newPortInsts;
    }

    public void updatePortInsts(boolean full) {
        int i2;
        PortInst[] newPortInsts = new PortInst[this.protoType.getNumPorts()];
        for (i2 = 0; i2 < this.portInsts.length; ++i2) {
            int portIndex;
            PortProto pp;
            PortInst pi = this.portInsts[i2];
            if (full && (pi.getNodeInst() != this || (pp = pi.getPortProto()).getParent() != this.getProto() || pp instanceof Export && !((Export)pp).isLinked()) || (portIndex = pi.getPortIndex()) < 0) continue;
            newPortInsts[portIndex] = pi;
        }
        for (i2 = 0; i2 < newPortInsts.length; ++i2) {
            if (newPortInsts[i2] != null) continue;
            newPortInsts[i2] = PortInst.newInst(this.protoType.getPort(i2), this);
        }
        this.portInsts = newPortInsts;
    }

    public Cell getProtoEquivalent() {
        if (!(this.protoType instanceof Cell)) {
            return null;
        }
        return ((Cell)this.protoType).getEquivalent();
    }

    public boolean hasExports() {
        return this.isLinked() && this.topology.cell.backup().cellRevision.hasExportsOnNode(this.getD());
    }

    public Iterator<Export> getExports() {
        Iterator<ImmutableExport> it;
        ExportIterator eit = ArrayIterator.emptyIterator();
        if (this.isLinked() && (it = this.topology.cell.backup().cellRevision.getExportsOnNode(this.getD())).hasNext()) {
            eit = new ExportIterator(it);
        }
        return eit;
    }

    Iterator<Export> getExports(PortProtoId portId) {
        Iterator<ImmutableExport> it;
        ExportIterator eit = ArrayIterator.emptyIterator();
        if (this.isLinked() && (it = this.topology.cell.backup().cellRevision.getExportsOnPort(this.getD(), portId)).hasNext()) {
            eit = new ExportIterator(it);
        }
        return eit;
    }

    public int getNumExports() {
        return this.isLinked() ? this.topology.cell.backup().cellRevision.getNumExportsOnNode(this.getD()) : 0;
    }

    private PortAssociation[] portAssociate(NodeInst ni1, NodeInst ni2, boolean ignorePortNames) {
        int total1 = ni1.getProto().getNumPorts();
        PortAssociation[] portInfo1 = new PortAssociation[total1];
        int k2 = 0;
        Iterator<PortInst> it1 = ni1.getPortInsts();
        while (it1.hasNext()) {
            PortInst pi1 = it1.next();
            portInfo1[k2] = new PortAssociation();
            portInfo1[k2].portInst = pi1;
            portInfo1[k2].poly = pi1.getPoly();
            portInfo1[k2].pos = new Point2D.Double(portInfo1[k2].poly.getCenterX(), portInfo1[k2].poly.getCenterY());
            portInfo1[k2].assn = null;
            ++k2;
        }
        int total2 = ni2.getProto().getNumPorts();
        PortAssociation[] portInfo2 = new PortAssociation[total2];
        k2 = 0;
        Iterator<PortInst> it2 = ni2.getPortInsts();
        while (it2.hasNext()) {
            PortInst pi2 = it2.next();
            portInfo2[k2] = new PortAssociation();
            portInfo2[k2].portInst = pi2;
            portInfo2[k2].poly = pi2.getPoly();
            portInfo2[k2].pos = new Point2D.Double(portInfo2[k2].poly.getCenterX(), portInfo2[k2].poly.getCenterY());
            portInfo2[k2].assn = null;
            ++k2;
        }
        if (!ignorePortNames) {
            for (int i1 = 0; i1 < total1; ++i1) {
                PortInst pi1 = portInfo1[i1].portInst;
                for (int i2 = 0; i2 < total2; ++i2) {
                    PortInst pi2 = portInfo2[i2].portInst;
                    if (portInfo2[i2].assn != null || !pi2.getPortProto().getName().equals(pi1.getPortProto().getName())) continue;
                    portInfo1[i1].assn = pi2;
                    portInfo2[i2].assn = pi1;
                }
            }
        }
        for (int pass = 0; pass < 2; ++pass) {
            for (int i1 = 0; i1 < total1; ++i1) {
                PortInst pi1 = portInfo1[i1].portInst;
                if (portInfo1[i1].assn != null) continue;
                for (int i2 = 0; i2 < total2; ++i2) {
                    PortInst pi2 = portInfo2[i2].portInst;
                    if (portInfo2[i2].assn != null || portInfo2[i2].pos.getX() != portInfo1[i1].pos.getX() || portInfo2[i2].pos.getY() != portInfo1[i1].pos.getY() || pass == 0 && (!portInfo1[i1].poly.polySame(portInfo2[i2].poly) || !this.connectivityMatches(pi1.getPortProto(), pi2.getPortProto()))) continue;
                    if (portInfo1[i1].assn != null) {
                        PortProto mpt = portInfo1[i1].assn.getPortProto();
                        if (ignorePortNames && (pi1.getPortProto().getName().equals(mpt.getName()) || !pi1.getPortProto().getName().equals(pi2.getPortProto().getName()))) continue;
                        boolean matchNew = this.connectivityMatches(pi1.getPortProto(), pi2.getPortProto());
                        boolean matchOld = this.connectivityMatches(pi1.getPortProto(), mpt);
                        if (!matchNew || matchOld) continue;
                    }
                    portInfo1[i1].assn = pi2;
                    portInfo2[i2].assn = pi1;
                }
            }
        }
        for (int i1 = 0; i1 < total1; ++i1) {
            if (portInfo1[i1].assn != null) continue;
            for (int i2 = 0; i2 < total2; ++i2) {
                if (portInfo2[i2].assn != null || portInfo2[i2].pos.getX() != portInfo1[i1].pos.getX() || portInfo2[i2].pos.getY() != portInfo1[i1].pos.getY() || !this.connectivityMatches(portInfo1[i1].portInst.getPortProto(), portInfo2[i2].portInst.getPortProto())) continue;
                portInfo1[i1].assn = portInfo2[i2].portInst;
            }
        }
        return portInfo1;
    }

    private boolean connectivityMatches(PortProto pp1, PortProto pp2) {
        ArcProto[] i2Conn2;
        ArcProto[] i1Conn1 = pp1.getBasePort().getConnections();
        if (i1Conn1.length != (i2Conn2 = pp2.getBasePort().getConnections()).length) {
            return false;
        }
        for (int j2 = 0; j2 < i1Conn1.length; ++j2) {
            if (j2 >= i2Conn2.length) {
                return false;
            }
            if (i1Conn1[j2] == i2Conn2[j2]) continue;
            return false;
        }
        return true;
    }

    public boolean pinUseCount() {
        return this.topology != null && this.topology.cell.backup().cellRevision.pinUseCount(this.getD());
    }

    public boolean isInlinePin() {
        if (!this.protoType.getFunction().isPin()) {
            return false;
        }
        int j2 = 0;
        ArcInst[] reconAr = new ArcInst[2];
        Point2D.Double[] delta = new Point2D.Double[2];
        Iterator<Connection> it = this.getConnections();
        while (it.hasNext()) {
            ArcInst ai;
            Connection con = it.next();
            if (j2 >= 2) {
                j2 = 0;
                break;
            }
            reconAr[j2] = ai = con.getArc();
            EPoint thisLocation = con.getLocation();
            EPoint thatLocation = ai.getLocation(1 - con.getEndIndex());
            delta[j2] = new Point2D.Double(thatLocation.getX() - thisLocation.getX(), thatLocation.getY() - thisLocation.getY());
            ++j2;
        }
        if (j2 != 2) {
            return false;
        }
        if (reconAr[0].getProto() != reconAr[1].getProto()) {
            return false;
        }
        if (reconAr[0].getLambdaBaseWidth() != reconAr[1].getLambdaBaseWidth()) {
            return false;
        }
        if (((Point2D)delta[0]).getX() != 0.0 || ((Point2D)delta[0]).getY() != 0.0 || ((Point2D)delta[1]).getX() != 0.0 || ((Point2D)delta[1]).getY() != 0.0) {
            Point2D.Double zero = new Point2D.Double(0.0, 0.0);
            if (!(((Point2D)delta[0]).getX() == 0.0 && ((Point2D)delta[0]).getY() == 0.0 || ((Point2D)delta[1]).getX() == 0.0 && ((Point2D)delta[1]).getY() == 0.0 || DBMath.figureAngle(zero, delta[0]) == DBMath.figureAngle(delta[1], zero))) {
                return false;
            }
        }
        if (reconAr[0].getVar(ImmutableArcInst.ARC_RADIUS) != null) {
            return false;
        }
        if (reconAr[1].getVar(ImmutableArcInst.ARC_RADIUS) != null) {
            return false;
        }
        Name name0 = reconAr[0].getNameKey();
        Name name1 = reconAr[1].getNameKey();
        return name0 == null || name1 == null || name0.isTempname() || name1.isTempname();
    }

    public PortProto connectsTo(ArcProto arc) {
        int numPorts = this.protoType.getNumPorts();
        for (int i2 = 0; i2 < numPorts; ++i2) {
            PortProto pp = this.protoType.getPort(i2);
            if (!pp.connectsTo(arc)) continue;
            return pp;
        }
        return null;
    }

    public Iterator<Connection> getConnections() {
        if (this.topology == null) {
            Iterator<Connection> cit = ArrayIterator.emptyIterator();
            return cit;
        }
        return new ConnectionIterator(this.topology.cell.backup(), this.getD());
    }

    Iterator<Connection> getConnections(PortProtoId portId) {
        if (this.topology == null) {
            Iterator<Connection> cit = ArrayIterator.emptyIterator();
            return cit;
        }
        return new ConnectionIterator(this.topology.cell.backup(), this.getD(), portId);
    }

    public boolean hasConnections() {
        return this.topology != null && this.topology.cell.backup().cellRevision.hasConnectionsOnNode(this.getD());
    }

    boolean hasConnections(PortProtoId portId) {
        return this.topology != null && this.topology.cell.backup().cellRevision.hasConnectionsOnPort(this.getD(), portId);
    }

    public int getNumConnections() {
        return this.topology != null ? this.topology.cell.backup().cellRevision.getNumConnectionsOnNode(this.getD()) : 0;
    }

    @Override
    public boolean isConnected(Geometric geom) {
        return geom instanceof ArcInst && ((ArcInst)geom).isConnected(this);
    }

    @Override
    public String getName() {
        return this.d.name.toString();
    }

    public boolean isUsernamed() {
        return this.d.isUsernamed();
    }

    @Override
    public Name getNameKey() {
        return this.d.name;
    }

    public boolean setName(String name) {
        assert (this.isLinked());
        Name key = null;
        Cell parent = this.topology.cell;
        if (name != null && name.length() > 0) {
            if (name.equals(this.getName())) {
                return false;
            }
            if (parent.findNode(name) != null) {
                System.out.println(String.valueOf(parent) + " already has NodeInst with name \"" + name + "\"");
                return true;
            }
            key = Name.findName(name);
        } else {
            if (!this.isUsernamed()) {
                return false;
            }
            key = this.topology.getNodeAutoname(this.getBasename());
        }
        if (NodeInst.checkNameKey(key, parent) || key.isBus() && (!(this.protoType instanceof Cell) || !((Cell)this.protoType).isIcon())) {
            return true;
        }
        ImmutableNodeInst oldD = this.d;
        this.lowLevelModify(this.d.withName(key));
        Constraints.getCurrent().modifyNodeInst(this, oldD);
        return false;
    }

    public static boolean checkNameKey(Name name, Cell parent) {
        String extrMsg;
        String string = extrMsg = parent != null ? parent.toString() : "";
        if (!name.isValid()) {
            System.out.println(extrMsg + ": Invalid name \"" + String.valueOf(name) + "\" wasn't assigned to node :" + Name.checkName(name.toString()));
            return true;
        }
        if (name.isBus()) {
            if (name.isTempname()) {
                System.out.println(extrMsg + ": Temporary name \"" + String.valueOf(name) + "\" can't be bus");
                return true;
            }
            if (!parent.busNamesAllowed()) {
                System.out.println(extrMsg + ": Bus name \"" + String.valueOf(name) + "\" can be in icons and schematics only");
                return true;
            }
        }
        if (name.hasEmptySubnames()) {
            if (name.isBus()) {
                System.out.println(extrMsg + ": Name \"" + String.valueOf(name) + "\" with empty subnames wasn't assigned to node");
            } else {
                System.out.println(extrMsg + ": Cannot assign empty name \"" + String.valueOf(name) + "\" to node");
            }
            return true;
        }
        return false;
    }

    @Override
    public TextDescriptor getTextDescriptor(Variable.Key varKey) {
        if (varKey == NODE_NAME) {
            return this.d.nameDescriptor;
        }
        if (varKey == NODE_PROTO) {
            return this.d.protoDescriptor;
        }
        return super.getTextDescriptor(varKey);
    }

    @Override
    public void setTextDescriptor(Variable.Key varKey, TextDescriptor td) {
        if (varKey == NODE_NAME) {
            this.setD(this.d.withNameDescriptor(td), true);
            return;
        }
        if (varKey == NODE_PROTO) {
            this.setD(this.d.withProtoDescriptor(td), true);
            return;
        }
        super.setTextDescriptor(varKey, td);
    }

    @Override
    public boolean isDeprecatedVariable(Variable.Key key) {
        if (key == NODE_NAME || key == NODE_PROTO) {
            return true;
        }
        return super.isDeprecatedVariable(key);
    }

    public void checkPossibleVariableEffects(Variable.Key key) {
        if (key == TRACE && this.protoType instanceof PrimitiveNode || key == Artwork.ART_DEGREES) {
            this.lowLevelModify(this.d);
        }
    }

    public boolean isInvisiblePinWithText() {
        if (this.getProto() != Generic.tech().invisiblePinNode) {
            return false;
        }
        if (this.hasExports()) {
            return true;
        }
        return this.getDisplayableVariables(null, false).length != 0;
    }

    public Point2D invisiblePinWithOffsetText(boolean repair) {
        Poly.Type style;
        Technology tech;
        Poly[] polyList;
        if (!this.protoType.getFunction().isPin()) {
            return null;
        }
        if (this.hasConnections()) {
            return null;
        }
        if (this.protoType != Generic.tech().invisiblePinNode && (polyList = (tech = this.protoType.getTechnology()).getShapeOfNode(this)).length > 0 && !(style = polyList[0].getStyle()).isText()) {
            return null;
        }
        Iterator<Serializable> it = this.getExports();
        while (it.hasNext()) {
            Export pp = it.next();
            TextDescriptor td = pp.getTextDescriptor(Export.EXPORT_NAME);
            if (td.getXOff() == 0.0 && td.getYOff() == 0.0) continue;
            Point2D.Double retVal = new Point2D.Double(this.getAnchorCenterX() + td.getXOff(), this.getAnchorCenterY() + td.getYOff());
            if (repair) {
                pp.setOff(Export.EXPORT_NAME, 0.0, 0.0);
            }
            return retVal;
        }
        it = this.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            if (!var.isDisplay() || var.getXOff() == 0.0 && var.getYOff() == 0.0) continue;
            Point2D.Double retVal = new Point2D.Double(this.getAnchorCenterX() + var.getXOff(), this.getAnchorCenterY() + var.getYOff());
            if (repair) {
                this.setOff(var.getKey(), 0.0, 0.0);
            }
            return retVal;
        }
        return null;
    }

    public String getTechSpecificAddition() {
        PrimitiveNode pNp;
        if (this.protoType instanceof PrimitiveNode && (pNp = (PrimitiveNode)this.protoType).isTechSpecific()) {
            String description = this.protoType.describe(false);
            PrimitiveNode.Function fun = this.getFunction();
            String funName = fun.getName();
            String funNameLC = funName.toLowerCase();
            String descLC = description.toLowerCase();
            if (!descLC.equals(funNameLC)) {
                if (funNameLC.startsWith(descLC) && (funName = funName.substring(description.length())).startsWith("-")) {
                    funName = funName.substring(1);
                }
                if (funNameLC.endsWith(descLC) && (funName = funName.substring(0, funName.length() - description.length())).endsWith("-")) {
                    funName = funName.substring(0, funName.length() - 1);
                }
                return funName;
            }
        }
        return "";
    }

    @Override
    public String describe(boolean withQuotes) {
        Object name;
        Object description = this.protoType.describe(false);
        String extra = this.getTechSpecificAddition();
        if (extra.length() > 0) {
            description = (String)description + "(" + extra + ")";
        }
        Object object = name = withQuotes ? "'" + this.getName() + "'" : this.getName();
        if (name != null) {
            description = (String)description + "[" + (String)name + "]";
        }
        return description;
    }

    public String libDescribe() {
        String name;
        Object description = this.protoType.libDescribe();
        String extra = this.getTechSpecificAddition();
        if (extra.length() > 0) {
            description = (String)description + "(" + extra + ")";
        }
        if ((name = this.getName()) != null) {
            description = (String)description + "[" + name + "]";
        }
        return description;
    }

    public String noLibDescribe() {
        String name;
        Object description = this.protoType.noLibDescribe();
        String extra = this.getTechSpecificAddition();
        if (extra.length() > 0) {
            description = (String)description + "(" + extra + ")";
        }
        if ((name = this.getName()) != null) {
            description = (String)description + "[" + name + "]";
        }
        return description;
    }

    @Override
    public int compareTo(NodeInst that) {
        int cmp;
        if (this.topology != that.topology && (cmp = this.topology.cell.compareTo(that.topology.cell)) != 0) {
            return cmp;
        }
        cmp = TextUtils.STRING_NUMBER_ORDER.compare(this.getName(), that.getName());
        if (cmp != 0) {
            return cmp;
        }
        return this.getNodeId() - that.getNodeId();
    }

    @Override
    public String toString() {
        if (this.protoType == null) {
            return "NodeInst no protoType";
        }
        return "node " + this.describe(true);
    }

    @Override
    public NodeProto getProto() {
        return this.protoType;
    }

    @Override
    public boolean isCellInstance() {
        return this.protoType instanceof Cell;
    }

    public Nodable[] getNodables() {
        return new Nodable[]{this};
    }

    public int getNumNodables() {
        return 1;
    }

    public Nodable getNodable(int arrayIndex) {
        if (arrayIndex != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public boolean contains(NodeInst ni, int arrayIndex) {
        return ni == this && arrayIndex == 0;
    }

    @Override
    public NodeInst getNodeInst() {
        return this;
    }

    @Override
    public int getNodableArrayIndex() {
        return 0;
    }

    public PrimitiveNode.Function getFunction() {
        if (this.protoType instanceof Cell) {
            return PrimitiveNode.Function.UNKNOWN;
        }
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getPrimitiveFunction(this.getTechSpecific());
    }

    public boolean isPrimitiveTransistor() {
        PrimitiveNode.Function func = this.protoType.getFunction();
        return func.isTransistor();
    }

    public boolean isPrimtiveSubstrateNode() {
        if (this.getFunction() != PrimitiveNode.Function.NODE) {
            return false;
        }
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        if (np.getNodeLayers().length != 1) {
            return false;
        }
        return np.getNodeLayers()[0].getLayer().getFunction().isSubstrate();
    }

    public boolean isSerpentineTransistor() {
        if (!this.isPrimitiveTransistor()) {
            return false;
        }
        PrimitiveNode pn = (PrimitiveNode)this.getProto();
        return pn.isHoldsOutline() && this.getTrace() != null;
    }

    public PrimitiveNodeSize getNodeInstSize(VarContext context) {
        PrimitiveNodeSize size = this.getPrimitiveDependentNodeSize(context);
        if (size == null) {
            double x = this.getLambdaBaseXSize();
            double y = this.getLambdaBaseYSize();
            size = new PrimitiveNodeSize(x, y, true);
        }
        return size;
    }

    public PrimitiveNodeSize getPrimitiveDependentNodeSize(VarContext context) {
        PrimitiveNodeSize size = this.getTransistorSize(context);
        if (size == null) {
            size = this.getResistorSize(context);
        }
        return size;
    }

    private PrimitiveNodeSize getResistorSize(VarContext context) {
        if (!this.getFunction().isResistor()) {
            return null;
        }
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getResistorSize(this, context);
    }

    public TransistorSize getTransistorSize(VarContext context) {
        if (!this.isPrimitiveTransistor()) {
            return null;
        }
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorSize(this, context);
    }

    public void setPrimitiveNodeSize(double width, double length, EditingPreferences ep) {
        if (!(this.isPrimitiveTransistor() || this.getFunction().isFET() || this.getFunction().isResistor())) {
            return;
        }
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        this.checkChanging();
        np.getTechnology().setPrimitiveNodeSize(this, width, length, ep);
    }

    public void setPrimitiveNodeSize(Object width, Object length, EditingPreferences ep) {
        Technology tech = this.protoType.getTechnology();
        if (tech != Schematics.tech()) {
            return;
        }
        this.checkChanging();
        Schematics.tech().setPrimitiveNodeSize(this, width, length, ep);
    }

    public double getSerpentineTransistorLength() {
        return this.getD().getSerpentineTransistorLength();
    }

    public void setSerpentineTransistorLength(double length, EditingPreferences ep) {
        this.updateVar(TRANSISTOR_LENGTH_KEY, length, ep);
    }

    public PortInst getTransistorGatePort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorGatePort(this);
    }

    public PortInst getTransistorAltGatePort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorAltGatePort(this);
    }

    public PortInst getTransistorSourcePort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorSourcePort(this);
    }

    public PortInst getTransistorEmitterPort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorEmitterPort(this);
    }

    public PortInst getTransistorBasePort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorBasePort(this);
    }

    public PortInst getTransistorCollectorPort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorCollectorPort(this);
    }

    public PortInst getTransistorBiasPort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorBiasPort(this);
    }

    public PortInst getTransistorDrainPort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorDrainPort(this);
    }

    public int checkAndRepair(boolean repair, List<Geometric> list, ErrorLogger errorLogger) {
        String msg;
        Cell parent;
        Cell cell = parent = this.topology != null ? this.topology.cell : null;
        if (this.protoType instanceof Cell) {
            Variable var = this.getVar(NccCellAnnotations.NCC_ANNOTATION_KEY);
            if (var != null) {
                String nccMsg = "Removed extraneous NCC annotations from cell instance " + this.describe(false) + " in " + String.valueOf(this.topology.cell);
                if (repair) {
                    this.delVar(var.getKey());
                    nccMsg = nccMsg + " (REPAIRED)";
                }
                System.out.println(nccMsg);
                if (errorLogger != null) {
                    errorLogger.logWarning(nccMsg, this, parent, null, 1);
                }
            }
            return 0;
        }
        PrimitiveNode pn = (PrimitiveNode)this.protoType;
        if (pn.getTechnology().cleanUnusedNodesInLibrary(this, list)) {
            if (errorLogger != null) {
                msg = "Prototype of node " + this.getName() + " is unused";
                if (repair) {
                    Poly poly = new Poly(this.getBounds());
                    errorLogger.logError(msg, poly, parent, 1);
                } else {
                    errorLogger.logError(msg, this, parent, null, 1);
                }
            }
            if (list != null) {
                if (repair) {
                    list.add(this);
                }
                return 1;
            }
        }
        if (this.getTrace() != null && !pn.isHoldsOutline()) {
            msg = String.valueOf(parent) + ", " + String.valueOf(this) + " has unexpected outline";
            System.out.println(msg);
            if (errorLogger != null) {
                errorLogger.logError(msg, this, parent, null, 1);
            }
            if (repair) {
                this.delVar(TRACE);
            }
        }
        return 0;
    }

    @Override
    public void check() {
        assert (this.isLinked());
        super.check();
        assert (this.getClass() == (this.isCellInstance() && ((Cell)this.getProto()).isIcon() ? IconNodeInst.class : NodeInst.class));
        assert (this.portInsts.length == this.protoType.getNumPorts());
        for (int i2 = 0; i2 < this.portInsts.length; ++i2) {
            PortInst pi = this.portInsts[i2];
            assert (pi.getNodeInst() == this);
            PortProto pp = pi.getPortProto();
            assert (pp == this.protoType.getPort(i2));
        }
        if (this.validVisBounds) {
            ERectangle chkBounds;
            if (this.d.protoId instanceof CellId) {
                Cell subCell = (Cell)this.getProto();
                ERectangle subBounds = subCell.getBounds();
                long[] gridBounds = new long[]{subBounds.getGridMinX(), subBounds.getGridMinY(), subBounds.getGridMaxX(), subBounds.getGridMaxY()};
                this.d.orient.rectangleBounds(gridBounds);
                chkBounds = ERectangle.fromGrid(this.d.anchor.getGridX() + gridBounds[0], this.d.anchor.getGridY() + gridBounds[1], gridBounds[2] - gridBounds[0], gridBounds[3] - gridBounds[1]);
            } else {
                PrimitiveNode pn = (PrimitiveNode)this.getProto();
                long[] gridBounds = new long[4];
                pn.genBounds(this.d, gridBounds);
                chkBounds = ERectangle.fromGrid(gridBounds[0], gridBounds[1], gridBounds[2] - gridBounds[0], gridBounds[3] - gridBounds[1]);
            }
            assert (chkBounds.equals(this.visBounds));
        }
    }

    public Name getBasename() {
        return this.protoType instanceof Cell ? ((Cell)this.protoType).getBasename() : this.getFunction().getBasename();
    }

    public void copyStateBits(NodeInst ni) {
        this.setD(this.d.withStateBits(ni.d), true);
    }

    private void setFlag(ImmutableNodeInst.Flag flag, boolean value) {
        this.setD(this.d.withFlag(flag, value), true);
    }

    public void setExpanded(boolean value) {
        if (this.topology != null) {
            this.topology.cell.setExpanded(this.getNodeId(), value);
        }
    }

    public boolean isExpanded() {
        return this.topology != null && this.topology.cell.isExpanded(this.getNodeId());
    }

    public boolean isWiped() {
        if (this.topology == null || !(this.protoType instanceof PrimitiveNode) || !((PrimitiveNode)this.protoType).isArcsWipe()) {
            return false;
        }
        return this.topology.cell.backup().isWiped(this.getD());
    }

    public void setHardSelect() {
        this.setFlag(ImmutableNodeInst.HARD_SELECT, true);
    }

    public void clearHardSelect() {
        this.setFlag(ImmutableNodeInst.HARD_SELECT, false);
    }

    public boolean isHardSelect() {
        return this.d.is(ImmutableNodeInst.HARD_SELECT);
    }

    public void setVisInside() {
        this.setFlag(ImmutableNodeInst.VIS_INSIDE, true);
    }

    public void clearVisInside() {
        this.setFlag(ImmutableNodeInst.VIS_INSIDE, false);
    }

    public boolean isVisInside() {
        return this.d.is(ImmutableNodeInst.VIS_INSIDE);
    }

    public void setLocked() {
        this.setFlag(ImmutableNodeInst.LOCKED, true);
    }

    public void clearLocked() {
        this.setFlag(ImmutableNodeInst.LOCKED, false);
    }

    public boolean isLocked() {
        return this.d.is(ImmutableNodeInst.LOCKED);
    }

    public void setTechSpecific(int value) {
        this.setD(this.d.withTechSpecific(value), true);
    }

    public void setPrimitiveFunction(PrimitiveNode.Function function) {
        if (this.isCellInstance()) {
            return;
        }
        PrimitiveNode pn = (PrimitiveNode)this.getProto();
        if (pn.isTechSpecific()) {
            this.setTechSpecific(pn.getPrimitiveFunctionBits(function));
        }
    }

    public int getTechSpecific() {
        return this.d.techBits;
    }

    public Rectangle2D findEssentialBounds() {
        NodeProto np = this.getProto();
        if (!(np instanceof Cell)) {
            return null;
        }
        Rectangle2D eb = ((Cell)np).findEssentialBounds();
        if (eb == null) {
            return null;
        }
        FixpTransform xForm = this.transformOut();
        Point2D ll = new Point2D.Double(eb.getMinX(), eb.getMinY());
        ll = xForm.transform(ll, null);
        Point2D ur = new Point2D.Double(eb.getMaxX(), eb.getMaxY());
        ur = xForm.transform(ur, null);
        double minX = Math.min(ll.getX(), ur.getX());
        double minY = Math.min(ll.getY(), ur.getY());
        double maxX = Math.max(ll.getX(), ur.getX());
        double maxY = Math.max(ll.getY(), ur.getY());
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        Serializable p;
        Iterator<Serializable> i2;
        boolean found;
        Poly[] noPolyList;
        PrimitiveNode.Function noFunc;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NodeInst no = (NodeInst)obj;
        if (this.getFunction() != no.getFunction()) {
            if (buffer != null) {
                buffer.append("Functions are not the same for '" + this.getName() + "' and '" + no.getName() + "'\n");
            }
            return false;
        }
        NodeProto noProtoType = no.getProto();
        NodeProto protoType = this.getProto();
        if (protoType.getClass() != noProtoType.getClass()) {
            if (buffer != null) {
                buffer.append("Not the same node prototypes for '" + this.getName() + "' and '" + no.getName() + "'\n");
            }
            return false;
        }
        if (!this.rotateOut().equals(no.rotateOut())) {
            if (buffer != null) {
                buffer.append("Not the same rotation for '" + this.getName() + "' and '" + no.getName() + "'\n");
            }
            return false;
        }
        if (protoType instanceof Cell) {
            return noProtoType instanceof Cell;
        }
        PrimitiveNode np = (PrimitiveNode)protoType;
        PrimitiveNode noNp = (PrimitiveNode)noProtoType;
        PrimitiveNode.Function function = this.getFunction();
        if (function != (noFunc = no.getFunction())) {
            if (buffer != null) {
                buffer.append("Not the same node prototypes for '" + this.getName() + "' and '" + no.getName() + "':" + function.getName() + " v/s " + noFunc.getName() + "\n");
            }
            return false;
        }
        Poly[] polyList = np.getTechnology().getShapeOfNode(this);
        if (polyList.length != (noPolyList = noNp.getTechnology().getShapeOfNode(no)).length) {
            if (buffer != null) {
                buffer.append("Not same number of geometries in '" + this.getName() + "' and '" + no.getName() + "'\n");
            }
            return false;
        }
        ArrayList<Object> noCheckAgain = new ArrayList<Object>();
        for (int i3 = 0; i3 < polyList.length; ++i3) {
            found = false;
            for (int j2 = 0; j2 < noPolyList.length; ++j2) {
                if (noCheckAgain.contains(noPolyList[j2]) || !polyList[i3].compare(noPolyList[j2], buffer)) continue;
                found = true;
                noCheckAgain.add(noPolyList[j2]);
                break;
            }
            if (found) continue;
            if (buffer != null) {
                buffer.append("No corresponding geometry in '" + this.getName() + "' found in '" + no.getName() + "'\n");
            }
            return false;
        }
        noCheckAgain.clear();
        Iterator<Serializable> it = this.getPortInsts();
        while (it.hasNext()) {
            found = false;
            PortInst port = it.next();
            i2 = no.getPortInsts();
            while (i2.hasNext()) {
                p = i2.next();
                if (noCheckAgain.contains(p) || !port.compare(p, buffer)) continue;
                found = true;
                noCheckAgain.add(p);
                break;
            }
            if (found) continue;
            return false;
        }
        noCheckAgain.clear();
        it = this.getExports();
        while (it.hasNext()) {
            Export export = (Export)it.next();
            boolean found2 = false;
            i2 = no.getExports();
            while (i2.hasNext()) {
                p = (Export)i2.next();
                if (noCheckAgain.contains(p) || !export.compare(p, buffer)) continue;
                found2 = true;
                noCheckAgain.add(p);
                break;
            }
            if (found2) continue;
            if (buffer != null) {
                buffer.append("No corresponding export '" + export.getName() + "' found in '" + no.getName() + "'\n");
            }
            return false;
        }
        Iterator<Variable> it1 = this.getVariables();
        Iterator<Variable> it2 = no.getVariables();
        while (it1.hasNext() || it2.hasNext()) {
            Variable param2;
            if (!it1.hasNext() || !it2.hasNext()) {
                if (buffer != null) {
                    buffer.append("Different number of variables found in '" + no.getName() + "'\n");
                }
                return false;
            }
            Variable param1 = it1.next();
            if (param1.compare(param2 = it2.next(), buffer)) continue;
            if (buffer != null) {
                buffer.append("No corresponding parameter '" + String.valueOf(param1) + "' found in '" + no.getName() + "'\n");
            }
            return false;
        }
        noCheckAgain.clear();
        it = this.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            boolean found3 = false;
            i2 = no.getVariables();
            while (i2.hasNext()) {
                p = (Variable)i2.next();
                if (noCheckAgain.contains(p) || !var.compare(p, buffer)) continue;
                found3 = true;
                noCheckAgain.add(p);
                break;
            }
            if (found3) continue;
            if (buffer != null) {
                buffer.append("No corresponding variable '" + String.valueOf(var) + "' found in '" + no.getName() + "'\n");
            }
            return false;
        }
        return true;
    }

    private static class NodeInstKey
    extends EObjectInputStream.Key<NodeInst> {
        public NodeInstKey() {
        }

        private NodeInstKey(NodeInst ni) {
            super(ni);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, NodeInst ni) throws IOException {
            if (ni.getDatabase() != out.getDatabase() || !ni.isLinked()) {
                throw new NotSerializableException(String.valueOf(ni) + " not linked");
            }
            out.writeObject(ni.topology.cell);
            out.writeInt(ni.getNodeId());
        }

        @Override
        public NodeInst readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            int nodeId;
            Cell cell = (Cell)in.readObject();
            NodeInst ni = cell.getNodeById(nodeId = in.readInt());
            if (ni == null) {
                throw new InvalidObjectException("NodeInst from " + String.valueOf(cell));
            }
            return ni;
        }
    }

    public static class ChangeError
    implements Serializable {
        public static final int CE_RECURSIVE = 1;
        public static final int CE_MISSINGPORT = 2;
        public static final int CE_UNCONNECTABLEPORT = 3;
        public static final int CE_MISSINGEXPORT = 4;
        public static final int CE_MISSINGHIER = 5;
        private int errorType;
        private ArcInst conAI;
        private PortInst conPI;
        private PortProto ppBad;

        public ChangeError(int et, ArcInst ai, PortInst pi, PortProto pp) {
            this.errorType = et;
            this.conAI = ai;
            this.conPI = pi;
            this.ppBad = pp;
        }

        public ArcInst getConAI() {
            return this.conAI;
        }

        public void printError() {
            switch (this.errorType) {
                case 1: {
                    System.out.println("Cannot replace because it would be recursive");
                    break;
                }
                case 2: {
                    System.out.println("Arc " + this.conAI.describe(false) + " on old port " + this.conPI.getPortProto().getName() + " cannot find new port");
                    break;
                }
                case 3: {
                    System.out.println("Arc " + this.conAI.describe(false) + " on old port " + this.conPI.getPortProto().getName() + " cannot connect to new port " + this.ppBad.getName());
                    break;
                }
                case 4: {
                    System.out.println("No port on new node can replace old node export: " + this.ppBad.getName());
                    break;
                }
                case 5: {
                    System.out.println("Arc " + this.conAI.describe(false) + " in higher-level cell " + this.conAI.getParent().describe(false) + " cannot connect to port " + this.ppBad.getName());
                }
            }
        }
    }

    private static class PortAssociation {
        PortInst portInst;
        Poly poly;
        Point2D pos;
        PortInst assn;

        private PortAssociation() {
        }
    }

    private class ExportIterator
    implements Iterator<Export> {
        private final Iterator<ImmutableExport> it;

        ExportIterator(Iterator<ImmutableExport> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Export next() {
            return NodeInst.this.topology.cell.getExportChron(this.it.next().exportId.chronIndex);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ConnectionIterator
    implements Iterator<Connection> {
        private final List<ImmutableArcInst> arcs;
        private final BitSet headEnds = new BitSet();
        int i;
        Connection nextConn;

        ConnectionIterator(CellBackup cellBackup, ImmutableNodeInst d2) {
            this.arcs = cellBackup.cellRevision.getConnectionsOnNode(this.headEnds, d2);
            this.findNext();
        }

        ConnectionIterator(CellBackup cellBackup, ImmutableNodeInst d2, PortProtoId portId) {
            this.arcs = cellBackup.cellRevision.getConnectionsOnPort(this.headEnds, d2, portId);
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.nextConn != null;
        }

        @Override
        public Connection next() {
            if (this.nextConn == null) {
                throw new NoSuchElementException();
            }
            Connection con = this.nextConn;
            this.findNext();
            return con;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void findNext() {
            while (this.i < this.arcs.size()) {
                ArcInst ai = NodeInst.this.topology.cell.getArcById(this.arcs.get((int)this.i).arcId);
                if (ai != null) {
                    this.nextConn = this.headEnds.get(this.i) ? ai.getHead() : ai.getTail();
                    ++this.i;
                    return;
                }
                ++this.i;
            }
            this.nextConn = null;
        }
    }

    public static class ExpansionState
    implements Serializable {
        public static final int JUSTTHISCELL = 1;
        public static final int JUSTTHISHIERARCHY = 2;
        public static final int CELLSWITHINSTANCES = 3;
        public static final int ALLCELLS = 4;
        private Map<Cell, BitSet> expansion = new HashMap<Cell, BitSet>();

        public ExpansionState(Cell cell, int complexity) {
            if (complexity == 4) {
                for (Library lib : Library.getVisibleLibraries()) {
                    Iterator<Cell> it = lib.getCells();
                    while (it.hasNext()) {
                        Cell c2 = it.next();
                        this.expansion.put(c2, c2.lowLevelExpandedNodes());
                    }
                }
            } else if (cell != null) {
                switch (complexity) {
                    case 2: {
                        this.recurseExpansionCache(cell);
                        break;
                    }
                    case 3: {
                        Iterator<NodeInst> it = cell.getInstancesOf();
                        while (it.hasNext()) {
                            NodeInst ni = it.next();
                            Cell par = ni.getParent();
                            if (this.expansion.get(par) != null) continue;
                            this.expansion.put(par, par.lowLevelExpandedNodes());
                        }
                        break;
                    }
                    case 1: {
                        this.expansion.put(cell, cell.lowLevelExpandedNodes());
                    }
                }
            }
        }

        private void recurseExpansionCache(Cell cell) {
            if (this.expansion.get(cell) != null) {
                return;
            }
            this.expansion.put(cell, cell.lowLevelExpandedNodes());
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (ni.isIconOfParent() || !ni.isCellInstance()) continue;
                this.recurseExpansionCache((Cell)ni.getProto());
            }
        }

        public boolean isExpanded(NodeInst ni) {
            Cell cell = ni.getParent();
            BitSet expandedNodes = this.expansion.get(cell);
            if (expandedNodes == null) {
                return false;
            }
            return expandedNodes.get(ni.getNodeId());
        }
    }
}

