/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import com.sun.electric.database.text.Name;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.GenMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class NameImpl
extends Name {
    private static final boolean USE_STRING_NUMBER_ORDER = false;
    private final String ns;
    private NameImpl[] subnames;
    private final NameImpl basename;
    private final int numSuffix;
    private int flags;
    private static volatile NameImpl[] allNames = new NameImpl[1];
    private static int allNamesCount = 0;

    public final String toString() {
        return this.ns;
    }

    @Override
    public int compareTo(Name name) {
        return this.ns.compareTo(((NameImpl)name).ns);
    }

    @Override
    public final boolean isValid() {
        return (this.flags & 1) == 0;
    }

    @Override
    public final boolean isTempname() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public boolean hasDuplicates() {
        return (this.flags & 0x20) != 0;
    }

    @Override
    public boolean hasEmptySubnames() {
        return (this.flags & 0x40) != 0;
    }

    @Override
    public boolean isList() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean isBus() {
        return this.subnames != null;
    }

    @Override
    public NameImpl subname(int i2) {
        if (this.subnames == null) {
            if (i2 != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }
        return this.subnames[i2];
    }

    @Override
    public int busWidth() {
        return this.subnames == null ? 1 : this.subnames.length;
    }

    @Override
    public NameImpl getBasename() {
        return this.basename;
    }

    @Override
    public int getNumSuffix() {
        return this.numSuffix;
    }

    @Override
    public NameImpl findSuffixed(int i2) {
        if (i2 < 0 || this.basename == null) {
            return null;
        }
        String basenameString = this.basename.ns.substring(0, this.basename.ns.length() - 1);
        return NameImpl.newTrimmedName(basenameString + i2, true);
    }

    static NameImpl newTrimmedName(String ns, boolean clone) {
        return NameImpl.findTrimmedName(ns, true, clone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NameImpl findTrimmedName(String ns, boolean create, boolean clone) {
        NameImpl n2;
        NameImpl[] hash = allNames;
        int i2 = ns.hashCode() & Integer.MAX_VALUE;
        i2 %= hash.length;
        int j2 = 1;
        while (hash[i2] != null) {
            n2 = hash[i2];
            if (n2.ns.equals(ns)) {
                return n2;
            }
            if ((i2 += j2) >= hash.length) {
                i2 -= hash.length;
            }
            j2 += 2;
        }
        Class<NameImpl> clazz = NameImpl.class;
        synchronized (NameImpl.class) {
            if (hash == allNames && allNames[i2] == null) {
                if (!create) {
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    return null;
                }
                if (allNamesCount * 2 <= hash.length - 3) {
                    if (clone) {
                        ns = new String(ns);
                        clone = false;
                    }
                    n2 = new NameImpl(ns);
                    if (hash != allNames || hash[i2] != null) {
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        return NameImpl.newTrimmedName(ns, false);
                    }
                    hash[i2] = n2;
                    ++allNamesCount;
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    return n2;
                }
                NameImpl.rehash();
            }
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return NameImpl.findTrimmedName(ns, create, clone);
        }
    }

    private static void rehash() {
        NameImpl[] oldHash = allNames;
        int newSize = oldHash.length * 2 + 3;
        if (newSize < 0) {
            throw new IndexOutOfBoundsException();
        }
        NameImpl[] newHash = new NameImpl[GenMath.primeSince(newSize)];
        for (NameImpl n2 : oldHash) {
            if (n2 == null) continue;
            int i2 = n2.ns.hashCode() & Integer.MAX_VALUE;
            i2 %= newHash.length;
            int j2 = 1;
            while (newHash[i2] != null) {
                if ((i2 += j2) >= newHash.length) {
                    i2 -= newHash.length;
                }
                j2 += 2;
            }
            newHash[i2] = n2;
        }
        allNames = newHash;
    }

    private NameImpl(String s) {
        this.ns = s;
        int suffix = -1;
        NameImpl base = null;
        try {
            this.flags = NameImpl.checkNameThrow(this.ns);
        }
        catch (NumberFormatException e2) {
            this.flags = 1;
        }
        if ((this.flags & 1) == 0 && (this.flags & 0x10) != 0) {
            int l2;
            for (l2 = this.ns.length(); l2 > 0 && TextUtils.isDigit(this.ns.charAt(l2 - 1)); --l2) {
            }
            if (l2 == this.ns.length() - 1 && this.ns.charAt(this.ns.length() - 1) == '0') {
                base = this;
                suffix = 0;
            } else {
                base = NameImpl.newTrimmedName(this.ns.substring(0, l2) + "0", false);
                suffix = Integer.parseInt(this.ns.substring(l2));
            }
        }
        this.numSuffix = suffix;
        this.basename = base;
        if (this.flags == 1) {
            return;
        }
        if ((this.flags & 4) == 0) {
            return;
        }
        if (this.isList()) {
            this.makeListSubNames();
            return;
        }
        int split = this.ns.indexOf(91);
        if (split == 0) {
            split = this.ns.lastIndexOf(91);
        }
        if (split == 0) {
            this.makeBracketSubNames();
        } else {
            this.makeSplitSubNames(split);
        }
    }

    private void makeListSubNames() {
        ArrayList<NameImpl> subs = new ArrayList<NameImpl>();
        int beg = 0;
        while (beg <= this.ns.length()) {
            int end;
            for (end = beg; end < this.ns.length() && this.ns.charAt(end) != ','; ++end) {
                if (this.ns.charAt(end) != '[') continue;
                while (this.ns.charAt(end) != ']') {
                    ++end;
                }
            }
            NameImpl nm = NameImpl.newTrimmedName(this.ns.substring(beg, end), true);
            for (int j2 = 0; j2 < nm.busWidth(); ++j2) {
                subs.add(nm.subname(j2));
            }
            beg = end + 1;
        }
        this.setSubnames(subs);
    }

    private void makeBracketSubNames() {
        ArrayList<NameImpl> subs = new ArrayList<NameImpl>();
        int beg = 1;
        while (beg < this.ns.length()) {
            int colon;
            int end = this.ns.indexOf(44, beg);
            if (end < 0) {
                end = this.ns.length() - 1;
            }
            if ((colon = this.ns.indexOf(58, beg)) < 0 || colon >= end) {
                NameImpl nm = NameImpl.newTrimmedName("[" + this.ns.substring(beg, end) + "]", false);
                subs.add(nm);
            } else {
                int ind2;
                int ind1 = Integer.parseInt(this.ns.substring(beg, colon));
                if (ind1 < (ind2 = Integer.parseInt(this.ns.substring(colon + 1, end)))) {
                    for (i = ind1; i <= ind2; ++i) {
                        subs.add(NameImpl.newTrimmedName("[" + i + "]", false));
                    }
                } else {
                    for (i = ind1; i >= ind2; --i) {
                        subs.add(NameImpl.newTrimmedName("[" + i + "]", false));
                    }
                }
            }
            beg = end + 1;
        }
        this.setSubnames(subs);
    }

    private void setSubnames(List<NameImpl> subs) {
        this.subnames = new NameImpl[subs.size()];
        subs.toArray(this.subnames);
        Object[] sorted = new NameImpl[subs.size()];
        subs.toArray(sorted);
        Arrays.sort(sorted);
        for (int i2 = 1; i2 < sorted.length; ++i2) {
            if (!sorted[i2].equals(sorted[i2 - 1])) continue;
            this.flags |= 0x20;
            break;
        }
    }

    private void makeSplitSubNames(int split) {
        if (split < 0 || split >= this.ns.length()) {
            System.out.println("HEY! string is '" + this.ns + "' but want index " + split);
            return;
        }
        NameImpl baseName = NameImpl.newTrimmedName(this.ns.substring(0, split), true);
        NameImpl indexList = NameImpl.newTrimmedName(this.ns.substring(split), true);
        this.subnames = new NameImpl[baseName.busWidth() * indexList.busWidth()];
        for (int i2 = 0; i2 < baseName.busWidth(); ++i2) {
            String bs = baseName.subname(i2).toString();
            for (int j2 = 0; j2 < indexList.busWidth(); ++j2) {
                String is = indexList.subname(j2).toString();
                this.subnames[i2 * indexList.busWidth() + j2] = NameImpl.newTrimmedName(bs + is, false);
            }
        }
        if (baseName.hasDuplicates() || indexList.hasDuplicates()) {
            this.flags |= 0x20;
        }
    }
}

