/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import com.sun.electric.database.text.NameImpl;
import com.sun.electric.util.TextUtils;
import java.util.Comparator;

public abstract class Name
implements Comparable<Name> {
    private static volatile Name[] allNames = new Name[1];
    private static int allNamesCount = 0;
    public static final Comparator<Name> STRING_NUMBER_ORDER = new Comparator<Name>(){

        @Override
        public int compare(Name o1, Name o2) {
            return TextUtils.STRING_NUMBER_ORDER.compare(o1.toString(), o2.toString());
        }
    };
    protected static final int ERROR = 1;
    protected static final int LIST = 2;
    protected static final int BUS = 4;
    protected static final int SIMPLE = 8;
    protected static final int TEMP = 16;
    protected static final int DUPLICATES = 32;
    protected static final int HAS_EMPTIES = 64;

    public static Name findName(String ns) {
        String ts;
        if (ns == null) {
            return null;
        }
        return NameImpl.newTrimmedName(ts, (ts = Name.trim(ns)) == ns);
    }

    public static String checkName(String ns) {
        try {
            int flags = Name.checkNameThrow(ns);
            if ((flags & 0x40) != 0) {
                return "has empty subnames";
            }
            return null;
        }
        catch (NumberFormatException e2) {
            return e2.getMessage();
        }
    }

    public static void printStatistics() {
        int validNames = 0;
        int userNames = 0;
        int busCount = 0;
        int busWidth = 0;
        long length = 0L;
        for (Name n2 : allNames) {
            if (n2 == null) continue;
            length += (long)n2.toString().length();
            if (n2.isValid()) {
                ++validNames;
            }
            if (!n2.isTempname()) {
                ++userNames;
            }
            if (!n2.isBus()) continue;
            ++busCount;
            busWidth += n2.busWidth();
        }
        System.out.println(allNamesCount + " Names " + length + " chars. " + validNames + " valid " + userNames + " usernames " + busCount + " buses with " + busWidth + " elements.");
    }

    @Override
    public abstract int compareTo(Name var1);

    public abstract boolean isValid();

    public abstract boolean isTempname();

    public abstract boolean hasDuplicates();

    public abstract boolean hasEmptySubnames();

    public abstract boolean isList();

    public abstract boolean isBus();

    public abstract Name subname(int var1);

    public abstract int busWidth();

    public abstract Name getBasename();

    public abstract int getNumSuffix();

    public abstract Name findSuffixed(int var1);

    private static String trim(String ns) {
        if (ns == null) {
            return null;
        }
        int len = ns.length();
        int newLen = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            if (ns.charAt(i2) <= ' ') continue;
            ++newLen;
        }
        if (newLen == len) {
            return ns;
        }
        StringBuffer buf = new StringBuffer(newLen);
        for (int i3 = 0; i3 < len; ++i3) {
            if (ns.charAt(i3) <= ' ') continue;
            buf.append(ns.charAt(i3));
        }
        return buf.toString();
    }

    protected static int checkNameThrow(String ns) throws NumberFormatException {
        int flags = 8;
        int bracket = -1;
        boolean wasBrackets = false;
        int colon = -1;
        if (ns.length() == 0 || ns.charAt(ns.length() - 1) == ',') {
            flags |= 0x40;
        }
        for (int i2 = 0; i2 < ns.length(); ++i2) {
            int j2;
            char c2 = ns.charAt(i2);
            if (bracket < 0) {
                colon = -1;
                if (c2 == ']') {
                    throw new NumberFormatException("unmatched ']' in name");
                }
                if (c2 == ':') {
                    throw new NumberFormatException("':' out of brackets");
                }
                if (c2 == '[') {
                    bracket = i2;
                    flags &= 0xFFFFFFF7;
                    if (i2 == 0 || ns.charAt(i2 - 1) == ',') {
                        flags |= 0x40;
                    }
                    wasBrackets = true;
                } else if (c2 == ',') {
                    flags |= 6;
                    flags &= 0xFFFFFFF7;
                    if (i2 == 0 || ns.charAt(i2 - 1) == ',') {
                        flags |= 0x40;
                    }
                    wasBrackets = false;
                } else if (wasBrackets) {
                    throw new NumberFormatException("Wrong character after brackets");
                }
                if (c2 != '@') continue;
                for (j2 = i2 + 1; j2 < ns.length(); ++j2) {
                    char cj = ns.charAt(j2);
                    if (cj >= '0' && cj <= '9') continue;
                    throw new NumberFormatException("Wrong number suffix in temporary name");
                }
                if (i2 == ns.length() - 1 || ns.charAt(i2 + 1) == '0' && i2 != ns.length() - 2) {
                    throw new NumberFormatException("Wrong temporary name");
                }
                if ((flags & 8) == 0) {
                    throw new NumberFormatException("list of temporary names");
                }
                Integer.parseInt(ns.substring(i2 + 1));
                assert (flags == 8);
                return 24;
            }
            if (c2 == '[') {
                throw new NumberFormatException("nested bracket '[' in name");
            }
            if (c2 == ':') {
                if (colon >= 0) {
                    throw new NumberFormatException("too many ':' inside brackets");
                }
                if (i2 == bracket + 1) {
                    throw new NumberFormatException("has missing start of index range");
                }
                if (ns.charAt(bracket + 1) == '-') {
                    throw new NumberFormatException("has negative start of index range");
                }
                for (j2 = bracket + 1; j2 < i2; ++j2) {
                    if (TextUtils.isDigit(ns.charAt(j2))) continue;
                    throw new NumberFormatException("has nonnumeric start of index range");
                }
                colon = i2;
                flags |= 4;
            }
            if (colon >= 0 && (c2 == ']' || c2 == ',')) {
                if (i2 == colon + 1) {
                    throw new NumberFormatException("has missing end of index range");
                }
                if (ns.charAt(colon + 1) == '-') {
                    throw new NumberFormatException("has negative end of index range");
                }
                for (j2 = colon + 1; j2 < i2; ++j2) {
                    if (TextUtils.isDigit(ns.charAt(j2))) continue;
                    throw new NumberFormatException("has nonnumeric end of index range");
                }
                if (Integer.parseInt(ns.substring(bracket + 1, colon)) == Integer.parseInt(ns.substring(colon + 1, i2))) {
                    throw new NumberFormatException("has equal start and end indices");
                }
                colon = -1;
            }
            if (c2 == ']') {
                if (i2 == bracket + 1) {
                    flags |= 0x40;
                }
                bracket = -1;
            }
            if (c2 == ',') {
                if (i2 == bracket + 1) {
                    flags += 64;
                }
                bracket = i2;
                flags |= 4;
            }
            if (c2 != '@') continue;
            throw new NumberFormatException("'@' in brackets");
        }
        if (bracket != -1) {
            throw new NumberFormatException("Unclosed bracket");
        }
        return flags;
    }
}

