/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.CellTree;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.NetCell;
import com.sun.electric.database.network.NetSchem;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.IconNodeInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ActivityLogger;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class Netlist {
    final NetCell netCell;
    final ShortResistors shortResistors;
    WeakReference<Snapshot> expectedSnapshot;
    WeakReference<CellTree> expectedCellTree;
    final int[] netMap;
    final int[] nm_net;
    private Network[] networks;
    int numExternalEntries;
    int numExternalNets;

    Netlist(NetCell netCell, ShortResistors shortResistors, int numExternals, int[] map) {
        int i2;
        this.netCell = netCell;
        this.shortResistors = shortResistors;
        this.netMap = map;
        this.nm_net = new int[this.netMap.length];
        Netlist.closureMap(this.netMap);
        int k2 = 0;
        for (i2 = 0; i2 < this.netMap.length; ++i2) {
            if (this.netMap[i2] != i2) continue;
            ++k2;
        }
        this.networks = new Network[k2];
        this.numExternalEntries = numExternals;
        k2 = 0;
        for (i2 = 0; i2 < this.netMap.length; ++i2) {
            if (this.netMap[i2] == i2) {
                this.nm_net[i2] = k2++;
                if (i2 >= numExternals) continue;
                ++this.numExternalNets;
                continue;
            }
            this.nm_net[i2] = this.nm_net[this.netMap[i2]];
        }
    }

    static int[] initMap(int size) {
        int[] map = new int[size];
        for (int i2 = 0; i2 < map.length; ++i2) {
            map[i2] = i2;
        }
        return map;
    }

    static void connectMap(int[] map, int a1, int a2) {
        int k2;
        int m1 = a1;
        while (map[m1] != m1) {
            m1 = map[m1];
        }
        int m2 = a2;
        while (map[m2] != m2) {
            m2 = map[m2];
        }
        int m3 = m1 < m2 ? m1 : m2;
        while (true) {
            k2 = map[a1];
            map[a1] = m3;
            if (a1 == k2) break;
            a1 = k2;
        }
        while (true) {
            k2 = map[a2];
            map[a2] = m3;
            if (a2 == k2) break;
            a2 = k2;
        }
    }

    static void closureMap(int[] map) {
        for (int i2 = 0; i2 < map.length; ++i2) {
            map[i2] = map[map[i2]];
        }
    }

    public Cell getCell() {
        return this.netCell.cell;
    }

    abstract Iterator<String> getNames(int var1);

    abstract Iterator<String> getExportedNames(int var1);

    abstract String getName(int var1);

    abstract boolean hasName(int var1, String var2);

    abstract void fillNames(int var1, Collection<String> var2, Collection<String> var3);

    boolean isExported(int netIndex) {
        return netIndex < this.numExternalNets;
    }

    abstract boolean isUsernamed(int var1);

    int getNetIndexByMap(int mapOffset) {
        return this.nm_net[mapOffset];
    }

    abstract int getEquivPortIndexByNetIndex(int var1);

    private final void checkForModification() {
        if (this.expectedCellTree != null ? this.netCell.cell.tree() != this.expectedCellTree.get() && this.netCell.obsolete(this) : this.netCell.database.backup() != this.expectedSnapshot.get() && this.netCell.obsolete(this)) {
            throw new ConcurrentModificationException();
        }
        this.netCell.database.checkExamine();
    }

    public static Nodable getNodableFor(NodeInst ni, int arrayIndex) {
        if (ni instanceof IconNodeInst) {
            if (ni.isIconOfParent() || arrayIndex < 0 || arrayIndex >= ni.getNameKey().busWidth()) {
                return null;
            }
            return ((IconNodeInst)ni).getNodable(arrayIndex);
        }
        return ni;
    }

    public Iterator<Nodable> getNodables() {
        this.checkForModification();
        return this.netCell.getNodables();
    }

    public Netlist getNetlist(Nodable no) {
        if (!no.isCellInstance()) {
            return null;
        }
        return ((Cell)no.getProto()).getNetlist(this.shortResistors);
    }

    public Global.Set getGlobals() {
        this.checkForModification();
        return this.netCell.getGlobals();
    }

    public int getNumDrawns() {
        return this.netCell.numDrawns;
    }

    public int getNumConnectedDrawns() {
        return this.netCell.numConnectedDrawns;
    }

    public int getNumNetworks() {
        this.checkForModification();
        return this.networks.length;
    }

    public int getNumExternalNetworks() {
        this.checkForModification();
        return this.numExternalNets;
    }

    public Network getNetwork(int netIndex) {
        this.checkForModification();
        return this.getNetworkRaw(netIndex);
    }

    private Network getNetworkRaw(int netIndex) {
        if (netIndex < 0) {
            return null;
        }
        Network network = this.networks[netIndex];
        if (network != null) {
            return network;
        }
        network = new Network(this, netIndex);
        if (this.networks[netIndex] != null) {
            return this.networks[netIndex];
        }
        this.networks[netIndex] = network;
        return network;
    }

    public Iterator<Network> getNetworks() {
        this.checkForModification();
        for (int netIndex = 0; netIndex < this.networks.length; ++netIndex) {
            if (this.networks[netIndex] != null) continue;
            this.getNetworkRaw(netIndex);
        }
        return Arrays.asList(this.networks).iterator();
    }

    int getNetIndex(Global global) {
        this.checkForModification();
        int netMapIndex = this.netCell.getNetMapOffset(global);
        if (netMapIndex < 0) {
            return -1;
        }
        return this.nm_net[netMapIndex];
    }

    int getNetIndex(Nodable no, Global global) {
        this.checkForModification();
        int netMapIndex = this.netCell.getNetMapOffset(no, global);
        if (netMapIndex < 0) {
            return -1;
        }
        return this.nm_net[netMapIndex];
    }

    int getNetIndex(Nodable no, Network subNetwork) {
        this.checkForModification();
        Netlist subNetlist = subNetwork.getNetlist();
        assert (subNetlist.shortResistors == this.shortResistors);
        if (no.getParent() == this.netCell.cell && subNetlist.getCell() == no.getProto() && subNetwork.isExported()) {
            int equivPortIndex = subNetlist.getEquivPortIndexByNetIndex(subNetwork.getNetIndex());
            assert (equivPortIndex >= 0 && equivPortIndex < subNetlist.netCell.equivPortsN.length);
            int netMapIndex = this.netCell.getNetMapOffset(no, equivPortIndex);
            if (netMapIndex >= 0) {
                return this.nm_net[netMapIndex];
            }
        }
        return -1;
    }

    int getNetIndex(Nodable no, PortProto portProto, int busIndex) {
        this.checkForModification();
        if (no.getParent() != this.netCell.cell) {
            return -1;
        }
        if (portProto.getParent() != no.getProto()) {
            System.out.println("Netlist.getNetwork: invalid argument portProto '" + portProto.getName() + "' in Nodable '" + no.getName() + "'");
            return -1;
        }
        if (busIndex < 0 || busIndex >= this.netCell.getBusWidth(no, portProto)) {
            return -1;
        }
        int netMapIndex = this.netCell.getNetMapOffset(no, portProto, busIndex);
        if (netMapIndex < 0) {
            return -1;
        }
        return this.nm_net[netMapIndex];
    }

    int getNetIndex(Nodable no, Name portName) {
        this.checkForModification();
        if (no.getParent() != this.netCell.cell) {
            return -1;
        }
        if (portName.isBus()) {
            throw new IllegalArgumentException("Scalar export name expected");
        }
        int netMapIndex = this.netCell.getNetMapOffset(no, portName);
        if (netMapIndex < 0) {
            return -1;
        }
        return this.nm_net[netMapIndex];
    }

    int getNetIndex(Export export, int busIndex) {
        Name exportName;
        int netIndex;
        this.checkForModification();
        if (export.getParent() != this.netCell.cell) {
            return -1;
        }
        if (busIndex < 0 || busIndex >= export.getNameKey().busWidth()) {
            System.out.println("Nodable.getNetwork: invalid arguments busIndex=" + busIndex + " export=" + String.valueOf(export));
            return -1;
        }
        int netMapIndex = this.netCell.getNetMapOffset(export, busIndex);
        int n2 = netIndex = netMapIndex >= 0 ? this.nm_net[netMapIndex] : -1;
        if (Job.getDebug() && netIndex != this.getNetIndex(exportName = export.getNameKey().subname(busIndex))) {
            String msg = "Export Name network mismatch in Cell " + this.netCell.cell.libDescribe() + ": getNetIndex(" + String.valueOf(export) + "," + busIndex + ")=" + netIndex + " getNetIndex(" + String.valueOf(exportName) + ")=" + this.getNetIndex(exportName);
            System.out.println(msg);
            ActivityLogger.logException((Throwable)((Object)new AssertionError((Object)msg)));
        }
        return netIndex;
    }

    int getNetIndex(Name exportName) {
        this.checkForModification();
        if (exportName.isBus()) {
            throw new IllegalArgumentException("Scalar export name expected");
        }
        int netMapIndex = this.netCell.getNetMapOffset(exportName);
        if (netMapIndex < 0) {
            return -1;
        }
        return this.nm_net[netMapIndex];
    }

    int getNetIndex(ArcInst ai, int busIndex) {
        this.checkForModification();
        if (ai.getParent() != this.netCell.cell) {
            return -1;
        }
        int netMapIndex = this.netCell.getNetMapOffset(ai, busIndex);
        if (netMapIndex < 0) {
            return -1;
        }
        return this.nm_net[netMapIndex];
    }

    public Network getNetwork(Global global) {
        return this.getNetworkRaw(this.getNetIndex(global));
    }

    public Network getNetwork(Nodable no, Global global) {
        return this.getNetworkRaw(this.getNetIndex(no, global));
    }

    public Network getNetwork(Nodable no, Network subNetwork) {
        return this.getNetworkRaw(this.getNetIndex(no, subNetwork));
    }

    public Network getNetwork(Nodable no, PortProto portProto, int busIndex) {
        if (no == null || portProto == null) {
            return null;
        }
        if (no instanceof NodeInst && !((NodeInst)no).isLinked()) {
            return null;
        }
        if (portProto instanceof Export && !((Export)portProto).isLinked()) {
            return null;
        }
        return this.getNetworkRaw(this.getNetIndex(no, portProto, busIndex));
    }

    public Network getNetwork(Nodable no, Name portName) {
        if (no == null || portName == null) {
            return null;
        }
        if (no instanceof NodeInst && !((NodeInst)no).isLinked()) {
            return null;
        }
        return this.getNetworkRaw(this.getNetIndex(no, portName));
    }

    public boolean portsConnected(Nodable no, PortProto port1, PortProto port2) {
        if (no == null || port1 == null || port2 == null) {
            return false;
        }
        if (no instanceof NodeInst && !((NodeInst)no).isLinked()) {
            return false;
        }
        if (port1 instanceof Export && !((Export)port1).isLinked()) {
            return false;
        }
        if (port2 instanceof Export && !((Export)port2).isLinked()) {
            return false;
        }
        if (no instanceof IconNodeInst) {
            int portWidth = port1.getNameKey().busWidth();
            if (port2.getNameKey().busWidth() != portWidth) {
                return false;
            }
            for (int arrayIndex = 0; arrayIndex < no.getNameKey().busWidth(); ++arrayIndex) {
                Nodable subNo = ((IconNodeInst)no).getNodable(arrayIndex);
                for (int i2 = 0; i2 < portWidth; ++i2) {
                    Name port1name = port1.getNameKey();
                    if (port1name.isBus()) {
                        port1name = port1name.findSuffixed(i2);
                    } else assert (i2 == 0);
                    Name port2name = port2.getNameKey();
                    if (port2name.isBus()) {
                        port2name = port2name.findSuffixed(i2);
                    } else assert (i2 == 0);
                    if (this.getNetIndex(subNo, port1name) == this.getNetIndex(subNo, port2name)) continue;
                    return false;
                }
            }
        } else {
            int busWidth = this.netCell.getBusWidth(no, port1);
            if (this.netCell.getBusWidth(no, port2) != busWidth) {
                return false;
            }
            for (int i3 = 0; i3 < busWidth; ++i3) {
                if (this.getNetIndex(no, port1, i3) == this.getNetIndex(no, port2, i3)) continue;
                return false;
            }
        }
        return true;
    }

    public Network getNetwork(PortInst pi) {
        if (!pi.isLinked()) {
            return null;
        }
        PortProto portProto = pi.getPortProto();
        if (portProto.getNameKey().isBus()) {
            NodeInst ni = pi.getNodeInst();
            System.out.println("Internal error: getNetwork(PortInst) called for bus port on " + ni.describe(false) + " in cell " + ni.getParent().describe(false));
            return null;
        }
        NodeInst ni = pi.getNodeInst();
        if (ni instanceof IconNodeInst) {
            if (ni.isIconOfParent()) {
                return null;
            }
            return this.getNetwork(pi.getNodeInst().getNodable(0), portProto.getNameKey().subname(0));
        }
        return this.getNetwork(pi.getNodeInst().getNodable(0), portProto, 0);
    }

    public Map<Network, PortInst[]> getPortInstsByNetwork() {
        if (this.netCell instanceof NetSchem) {
            throw new IllegalArgumentException();
        }
        Cell cell = this.netCell.cell;
        int[] networkCounts = new int[this.getNumNetworks()];
        Iterator<NodeInst> nit = cell.getNodes();
        while (nit.hasNext()) {
            NodeInst ni = nit.next();
            Iterator<PortInst> pit = ni.getPortInsts();
            while (pit.hasNext()) {
                PortInst pi = pit.next();
                Network net = this.getNetwork(pi);
                if (net == null) continue;
                int n2 = net.getNetIndex();
                networkCounts[n2] = networkCounts[n2] + 1;
            }
        }
        LinkedHashMap<Network, PortInst[]> map = new LinkedHashMap<Network, PortInst[]>();
        PortInst[][] portInsts = new PortInst[this.getNumNetworks()][];
        for (int netIndex = 0; netIndex < this.getNumNetworks(); ++netIndex) {
            portInsts[netIndex] = new PortInst[networkCounts[netIndex]];
            map.put(this.getNetwork(netIndex), portInsts[netIndex]);
        }
        Arrays.fill(networkCounts, 0);
        Iterator<NodeInst> nit2 = cell.getNodes();
        while (nit2.hasNext()) {
            NodeInst ni = nit2.next();
            Iterator<PortInst> pit = ni.getPortInsts();
            while (pit.hasNext()) {
                int netIndex;
                PortInst pi = pit.next();
                Network net = this.getNetwork(pi);
                if (net == null) continue;
                int n3 = netIndex = net.getNetIndex();
                int n4 = networkCounts[n3];
                networkCounts[n3] = n4 + 1;
                portInsts[netIndex][n4] = pi;
            }
        }
        return map;
    }

    public Map<Network, ArcInst[]> getArcInstsByNetwork() {
        if (this.netCell instanceof NetSchem) {
            throw new IllegalArgumentException();
        }
        Cell cell = this.netCell.cell;
        int[] networkCounts = new int[this.getNumNetworks()];
        Iterator<ArcInst> ait = cell.getArcs();
        while (ait.hasNext()) {
            ArcInst ai = ait.next();
            Network net = this.getNetwork(ai, 0);
            if (net == null) continue;
            int n2 = net.getNetIndex();
            networkCounts[n2] = networkCounts[n2] + 1;
        }
        LinkedHashMap<Network, ArcInst[]> map = new LinkedHashMap<Network, ArcInst[]>();
        ArcInst[][] arcInsts = new ArcInst[this.getNumNetworks()][];
        for (int netIndex = 0; netIndex < this.getNumNetworks(); ++netIndex) {
            int numArcs = networkCounts[netIndex];
            ArcInst[] arcs = numArcs > 0 ? new ArcInst[numArcs] : ArcInst.NULL_ARRAY;
            map.put(this.getNetwork(netIndex), arcs);
            arcInsts[netIndex] = arcs;
        }
        Arrays.fill(networkCounts, 0);
        Iterator<ArcInst> ait2 = cell.getArcs();
        while (ait2.hasNext()) {
            int netIndex;
            ArcInst ai = ait2.next();
            Network net = this.getNetwork(ai, 0);
            if (net == null) continue;
            int n3 = netIndex = net.getNetIndex();
            int n4 = networkCounts[n3];
            networkCounts[n3] = n4 + 1;
            arcInsts[netIndex][n4] = ai;
        }
        return map;
    }

    public Network getNetwork(Export export, int busIndex) {
        if (!export.isLinked()) {
            return null;
        }
        return this.getNetworkRaw(this.getNetIndex(export, busIndex));
    }

    public Network getNetwork(Name exportName) {
        return this.getNetworkRaw(this.getNetIndex(exportName));
    }

    public Network getNetwork(ArcInst ai, int busIndex) {
        if (!ai.isLinked()) {
            return null;
        }
        return this.getNetworkRaw(this.getNetIndex(ai, busIndex));
    }

    public boolean sameNetwork(ArcInst ai1, ArcInst ai2) {
        if (ai1 == null || ai2 == null) {
            return false;
        }
        if (!ai1.isLinked()) {
            return false;
        }
        if (!ai2.isLinked()) {
            return false;
        }
        this.checkForModification();
        int busWidth1 = this.netCell.getBusWidth(ai1);
        int busWidth2 = this.netCell.getBusWidth(ai2);
        if (busWidth1 != busWidth2) {
            return false;
        }
        for (int i2 = 0; i2 < busWidth1; ++i2) {
            if (this.getNetIndex(ai1, i2) == this.getNetIndex(ai2, i2)) continue;
            return false;
        }
        return true;
    }

    public boolean sameNetwork(Nodable no, PortProto pp, ArcInst ai) {
        if (no == null || pp == null || ai == null) {
            return false;
        }
        if (no instanceof NodeInst && !((NodeInst)no).isLinked()) {
            return false;
        }
        if (pp instanceof Export && !((Export)pp).isLinked()) {
            return false;
        }
        if (!ai.isLinked()) {
            return false;
        }
        this.checkForModification();
        if (no instanceof IconNodeInst) {
            int busWidth2;
            int portWidth;
            int arrayWidth = no.getNameKey().busWidth();
            if (arrayWidth * (portWidth = pp.getNameKey().busWidth()) != (busWidth2 = this.netCell.getBusWidth(ai))) {
                return false;
            }
            for (int i2 = 0; i2 < busWidth2; ++i2) {
                Nodable subNo = ((IconNodeInst)no).getNodable(i2 / portWidth);
                if (this.getNetIndex(subNo, pp, i2 % portWidth) == this.getNetIndex(ai, i2)) continue;
                return false;
            }
        } else {
            int busWidth2;
            int busWidth1 = this.netCell.getBusWidth(no, pp);
            if (busWidth1 != (busWidth2 = this.netCell.getBusWidth(ai))) {
                return false;
            }
            for (int i3 = 0; i3 < busWidth1; ++i3) {
                if (this.getNetIndex(no, pp, i3) == this.getNetIndex(ai, i3)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean sameNetwork(Nodable no1, PortProto pp1, Nodable no2, PortProto pp2) {
        int busWidth2;
        if (no1 == null || pp1 == null || no2 == null || pp2 == null) {
            return false;
        }
        if (no1 instanceof NodeInst && !((NodeInst)no1).isLinked()) {
            return false;
        }
        if (pp1 instanceof Export && !((Export)pp1).isLinked()) {
            return false;
        }
        if (no2 instanceof NodeInst && !((NodeInst)no2).isLinked()) {
            return false;
        }
        if (pp2 instanceof Export && !((Export)pp2).isLinked()) {
            return false;
        }
        int busWidth1 = this.netCell.getBusWidth(no1, pp1);
        if (busWidth1 != (busWidth2 = this.netCell.getBusWidth(no2, pp2))) {
            return false;
        }
        if (no1 instanceof IconNodeInst || no2 instanceof IconNodeInst) {
            Name portName1 = pp1.getNameKey();
            Name portName2 = pp2.getNameKey();
            int portWidth1 = portName1.busWidth();
            int portWidth2 = portName2.busWidth();
            for (int i2 = 0; i2 < busWidth1; ++i2) {
                int netIndex2;
                int netIndex1 = no1 instanceof IconNodeInst ? this.getNetIndex(((IconNodeInst)no1).getNodable(i2 / portWidth1), portName1.subname(i2 % portWidth1)) : this.getNetIndex(no1, pp1, i2);
                if (netIndex1 == (netIndex2 = no2 instanceof IconNodeInst ? this.getNetIndex(((IconNodeInst)no2).getNodable(i2 / portWidth2), portName2.subname(i2 % portWidth2)) : this.getNetIndex(no2, pp2, i2))) continue;
                return false;
            }
        } else {
            for (int i3 = 0; i3 < busWidth1; ++i3) {
                if (this.getNetIndex(no1, pp1, i3) == this.getNetIndex(no2, pp2, i3)) continue;
                return false;
            }
        }
        return true;
    }

    public String getNetworkName(ArcInst ai) {
        if (ai == null || !ai.isLinked()) {
            return null;
        }
        this.checkForModification();
        if (ai.getParent() != this.netCell.cell) {
            return null;
        }
        int busWidth = this.netCell.getBusWidth(ai);
        if (busWidth > 1) {
            return this.netCell.getBusName(ai).toString();
        }
        Network network = this.getNetwork(ai, 0);
        if (network == null) {
            return null;
        }
        return network.describe(false);
    }

    public Name getBusName(ArcInst ai) {
        if (ai == null || !ai.isLinked()) {
            return null;
        }
        this.checkForModification();
        if (ai.getParent() != this.netCell.cell) {
            return null;
        }
        int busWidth = this.netCell.getBusWidth(ai);
        if (busWidth <= 1) {
            return null;
        }
        return this.netCell.getBusName(ai);
    }

    public int getBusWidth(Export e2) {
        if (e2 == null || !e2.isLinked()) {
            return 0;
        }
        return e2.getNameKey().busWidth();
    }

    public int getBusWidth(ArcInst ai) {
        if (ai == null || !ai.isLinked()) {
            return 0;
        }
        this.checkForModification();
        if (ai.getParent() != this.netCell.cell) {
            return 0;
        }
        return this.netCell.getBusWidth(ai);
    }

    public ShortResistors getShortResistors() {
        return this.shortResistors;
    }

    public String toString() {
        return "Netlist of " + String.valueOf(this.netCell.cell);
    }

    public static enum ShortResistors {
        NO,
        PARASITIC,
        ALL;

    }
}

