/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.CellTree;
import com.sun.electric.database.EquivPorts;
import com.sun.electric.database.EquivalentSchematicExports;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.NetCell;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.NetlistImpl;
import com.sun.electric.database.network.NetlistShorted;
import com.sun.electric.database.network.NetworkManager;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.IconNodeInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.util.math.MutableInteger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class NetSchem
extends NetCell {
    NetSchem implementation;
    int[] drawnOffsets;
    IconInst[] iconInsts;
    IdentityHashMap<IconInst, Set<Global>> iconInstExcludeGlobals;
    Global.Set globals = Global.Set.empty;
    int[] portOffsets = new int[1];
    int netNamesOffset;
    Name[] drawnNames;
    int[] drawnWidths;
    private IdentityHashMap<Name, Integer> exportNameMapOffsets;
    private CellTree cellTree;
    private CellId mainSchemId;
    private IdentityHashMap<CellId, EquivalentSchematicExports> eqExports;

    NetSchem(Cell cell) {
        super(cell);
        Cell mainSchematics;
        this.setImplementation(this);
        if (cell.isIcon() && (mainSchematics = cell.getMainSchematicInGroup()) != null) {
            NetSchem mainSchem = new NetSchem(mainSchematics);
            this.setImplementation(mainSchem);
        }
    }

    private void setImplementation(NetSchem implementation) {
        if (this.implementation == implementation) {
            return;
        }
        this.implementation = implementation;
    }

    @Override
    NetSchem getSchem() {
        return this.implementation;
    }

    @Override
    Iterator<Nodable> getNodables() {
        NodeInst ni;
        ArrayList<Nodable> nodables = new ArrayList<Nodable>();
        Iterator<NodeInst> it = this.cell.getNodes();
        while (it.hasNext()) {
            ni = it.next();
            if (this.iconInsts[ni.getNodeId()] != null) continue;
            nodables.add(ni);
        }
        it = this.cell.getNodes();
        while (it.hasNext()) {
            ni = it.next();
            IconInst iconInst = this.iconInsts[ni.getNodeId()];
            if (iconInst == null || iconInst.iconOfParent) continue;
            for (int i2 = 0; i2 < iconInst.numNodables; ++i2) {
                Nodable proxy = iconInst.getNodable(i2);
                assert (proxy != null);
                nodables.add(proxy);
            }
        }
        return nodables.iterator();
    }

    @Override
    Global.Set getGlobals() {
        return this.globals;
    }

    @Override
    int getNetMapOffset(Global global) {
        return this.globals.indexOf(global);
    }

    @Override
    int getNetMapOffset(Nodable no, Global global) {
        if (no == null) {
            return -1;
        }
        int nodeId = no.getNodeInst().getNodeId();
        if (nodeId < 0 || nodeId >= this.iconInsts.length) {
            return -1;
        }
        IconInst iconInst = this.iconInsts[nodeId];
        if (iconInst == null || iconInst.iconOfParent) {
            return -1;
        }
        assert (!(no instanceof NodeInst) || no == iconInst.nodeInst && ((Cell)iconInst.nodeInst.getProto()).isSchematic());
        int indexOfGlobal = iconInst.eq.implementation.globals.indexOf(global);
        if (indexOfGlobal < 0) {
            return -1;
        }
        return iconInst.getNetMapOffset(no) + indexOfGlobal;
    }

    @Override
    int getNetMapOffset(Nodable no, int equivPortIndex) {
        int nodeId = no.getNodeInst().getNodeId();
        if (nodeId < 0 || nodeId >= this.iconInsts.length) {
            return -1;
        }
        IconInst iconInst = this.iconInsts[nodeId];
        if (iconInst == null || iconInst.iconOfParent) {
            return -1;
        }
        return iconInst.getNetMapOffset(no) + equivPortIndex;
    }

    @Override
    int getNetMapOffset(Nodable no, PortProto portProto, int busIndex) {
        if (no == null) {
            return -1;
        }
        int nodeId = no.getNodeInst().getNodeId();
        if (nodeId < 0 || nodeId >= this.iconInsts.length) {
            return -1;
        }
        IconInst iconInst = this.iconInsts[nodeId];
        if (iconInst == null) {
            int drawn = this.drawns[this.ni_pi[nodeId] + portProto.getPortIndex()];
            if (drawn < 0) {
                return -1;
            }
            if (busIndex < 0 || busIndex >= this.drawnWidths[drawn]) {
                return -1;
            }
            assert (portProto.getParent() == ((NodeInst)no).getProto());
            return this.drawnOffsets[drawn] + busIndex;
        }
        if (iconInst.iconOfParent) {
            return -1;
        }
        Cell subCell = (Cell)portProto.getParent();
        assert (no.getProto() == subCell);
        EquivalentSchematicExports eq = iconInst.eq;
        if (no instanceof IconNodeInst) {
            int portWidth = portProto.getNameKey().busWidth();
            Nodable no1 = ((IconNodeInst)no).getNodable(busIndex / portWidth);
            busIndex %= portWidth;
            if (Job.getDebug()) {
                System.out.println("IconNodeInst " + String.valueOf(no) + " is passed to getNodeIndex. Replaced by IconNodeable " + String.valueOf(no1));
            }
            assert (eq.cellId == subCell.getId());
            no = no1;
        } else assert (eq.implementation.cellId == subCell.getId());
        Name exportName = portProto.getNameKey().subname(busIndex);
        int portOffset = eq.implementation.getExportNameMapOffset(exportName);
        if (portOffset < 0) {
            return -1;
        }
        return iconInst.getNetMapOffset(no) + portOffset;
    }

    @Override
    int getNetMapOffset(Nodable no, Name portName) {
        if (no == null) {
            return -1;
        }
        int nodeId = no.getNodeInst().getNodeId();
        if (nodeId < 0 || nodeId >= this.iconInsts.length) {
            return -1;
        }
        IconInst iconInst = this.iconInsts[nodeId];
        if (iconInst == null) {
            if (this.cell.getNodeById(nodeId) != no) {
                throw new IllegalArgumentException();
            }
            PortProto portProto = no.getProto().findPortProto(portName);
            int drawn = this.drawns[this.ni_pi[nodeId] + portProto.getPortIndex()];
            if (drawn < 0) {
                return -1;
            }
            if (this.drawnWidths[drawn] != 1) {
                throw new IllegalArgumentException();
            }
            assert (portProto.getParent() == ((NodeInst)no).getProto());
            return this.drawnOffsets[drawn];
        }
        if (iconInst.iconOfParent) {
            throw new IllegalArgumentException();
        }
        if (this.cell.getNodeById(nodeId).getNodable(no.getNodableArrayIndex()) != no) {
            throw new IllegalArgumentException();
        }
        assert (!(no instanceof IconNodeInst));
        Cell subCell = (Cell)no.getProto();
        EquivalentSchematicExports eq = iconInst.eq;
        assert (eq.implementation.cellId == subCell.getId());
        int portOffset = eq.implementation.getExportNameMapOffset(portName);
        if (portOffset < 0) {
            return -1;
        }
        return iconInst.getNetMapOffset(no) + portOffset;
    }

    @Override
    int getBusWidth(Nodable no, PortProto portProto) {
        if (no instanceof NodeInst) {
            NodeInst ni = (NodeInst)no;
            int drawn = this.drawns[this.ni_pi[ni.getNodeId()] + portProto.getPortIndex()];
            if (drawn < 0) {
                return 0;
            }
            return this.drawnWidths[drawn];
        }
        return portProto.getNameKey().busWidth();
    }

    @Override
    int getNetMapOffset(Export export, int busIndex) {
        int drawn = this.drawns[export.getPortIndex()];
        if (drawn < 0) {
            return -1;
        }
        if (busIndex < 0 || busIndex >= this.drawnWidths[drawn]) {
            return -1;
        }
        return this.drawnOffsets[drawn] + busIndex;
    }

    @Override
    int getNetMapOffset(Name exportName) {
        Integer objResult;
        assert (!exportName.isBus());
        if (this.exportNameMapOffsets == null) {
            this.buildExportNameMapOffsets();
        }
        return (objResult = this.exportNameMapOffsets.get(exportName)) != null ? objResult : -1;
    }

    private void buildExportNameMapOffsets() {
        IdentityHashMap<Name, Integer> map = new IdentityHashMap<Name, Integer>();
        for (int exportIndex = 0; exportIndex < this.cell.getNumPorts(); ++exportIndex) {
            Export e2 = this.cell.getPort(exportIndex);
            for (int busIndex = 0; busIndex < e2.getNameKey().busWidth(); ++busIndex) {
                Name exportName = e2.getNameKey().subname(busIndex);
                if (map.containsKey(exportName)) continue;
                map.put(exportName, this.portOffsets[exportIndex] + busIndex);
            }
        }
        this.exportNameMapOffsets = map;
    }

    @Override
    int getNetMapOffset(ArcInst ai, int busIndex) {
        int drawn = this.getArcDrawn(ai);
        if (drawn < 0) {
            return -1;
        }
        if (busIndex < 0 || busIndex >= this.drawnWidths[drawn]) {
            return -1;
        }
        return this.drawnOffsets[drawn] + busIndex;
    }

    @Override
    Name getBusName(ArcInst ai) {
        int drawn = this.getArcDrawn(ai);
        return this.drawnNames[drawn];
    }

    @Override
    public int getBusWidth(ArcInst ai) {
        int drawn = this.getArcDrawn(ai);
        if (drawn < 0) {
            return 0;
        }
        return this.drawnWidths[drawn];
    }

    private boolean initNodables() {
        int i2;
        int numNodes = this.cell.getNumNodes();
        Global.Buf globalBuf = new Global.Buf();
        HashMap nodeInstExcludeGlobal = null;
        for (int i3 = 0; i3 < numNodes; ++i3) {
            PortCharacteristic characteristic;
            NodeInst ni = this.cell.getNode(i3);
            NodeProto np = ni.getProto();
            if (ni.isCellInstance()) {
                String errorMsg;
                String msg;
                Cell subCell = (Cell)np;
                if (!subCell.isIcon() && !subCell.isSchematic()) {
                    if (!ni.getNameKey().isBus()) continue;
                    msg = String.valueOf(this.cell) + ": Array name <" + String.valueOf(ni.getNameKey()) + "> can be assigned only to icon nodes";
                    System.out.println(msg);
                    this.networkManager.pushHighlight(ni);
                    this.networkManager.logError(msg, 1);
                    continue;
                }
                if (ni.getNameKey().hasDuplicates()) {
                    msg = String.valueOf(this.cell) + ": Node name <" + String.valueOf(ni.getNameKey()) + "> has duplicate subnames";
                    System.out.println(msg);
                    this.networkManager.pushHighlight(ni);
                    this.networkManager.logError(msg, 1);
                }
                if (ni.isIconOfParent()) continue;
                EquivalentSchematicExports eq = this.database.backup().getEquivExports(subCell.getId());
                Global.Set gs = eq.implementation.globals;
                if (eq.implementation.globalPartitions != null) {
                    int numPortInsts = np.getNumPorts();
                    HashSet<Global> gb = null;
                    for (int j2 = 0; j2 < numPortInsts; ++j2) {
                        PortInst pi = ni.getPortInst(j2);
                        int piOffset = this.getPortInstOffset(pi);
                        int drawn = this.drawns[piOffset];
                        if (drawn < 0 || drawn >= this.numConnectedDrawns) continue;
                        Export e2 = (Export)pi.getPortProto();
                        Name busName = e2.getNameKey();
                        for (int busIndex = 0; busIndex < busName.busWidth(); ++busIndex) {
                            Name exportName = busName.subname(busIndex);
                            Global.Set globalsOnElement = eq.implementation.globalPartitions.get(exportName);
                            if (globalsOnElement == null) continue;
                            if (gb == null) {
                                gb = new HashSet<Global>();
                            }
                            for (int l2 = 0; l2 < globalsOnElement.size(); ++l2) {
                                Global g2 = globalsOnElement.get(l2);
                                gb.add(g2);
                            }
                        }
                    }
                    if (gb != null) {
                        if (nodeInstExcludeGlobal == null) {
                            nodeInstExcludeGlobal = new HashMap();
                        }
                        nodeInstExcludeGlobal.put(ni, gb);
                        gs = gs.remove(gb.iterator());
                    }
                }
                if ((errorMsg = globalBuf.addToBuf(gs)) == null) continue;
                String msg2 = "Network: " + String.valueOf(this.cell) + " has globals with conflicting characteristic " + errorMsg;
                System.out.println(msg2);
                this.networkManager.logError(msg2, 0);
                continue;
            }
            Global g3 = NetSchem.globalInst(ni);
            if (g3 == null) continue;
            if (g3 == Global.ground) {
                characteristic = PortCharacteristic.GND;
            } else if (g3 == Global.power) {
                characteristic = PortCharacteristic.PWR;
            } else {
                characteristic = PortCharacteristic.findCharacteristic(ni.getTechSpecific());
                if (characteristic == null) {
                    String msg = "Network: " + String.valueOf(this.cell) + " has global " + g3.getName() + " with unknown characteristic bits";
                    System.out.println(msg);
                    this.networkManager.pushHighlight(ni);
                    this.networkManager.logError(msg, 0);
                    characteristic = PortCharacteristic.UNKNOWN;
                }
            }
            String errorMsg = globalBuf.addToBuf(g3, characteristic);
            if (errorMsg == null) continue;
            String msg = "Network: " + String.valueOf(this.cell) + " has global with conflicting characteristic " + errorMsg;
            System.out.println(msg);
            this.networkManager.logError(msg, 0);
        }
        Global.Set newGlobals = globalBuf.getBuf();
        boolean changed = false;
        if (this.globals != newGlobals) {
            changed = true;
            this.globals = newGlobals;
            if (NetworkTool.debug) {
                System.out.println(String.valueOf(this.cell) + " has " + String.valueOf(this.globals));
            }
        }
        int mapOffset = this.portOffsets[0] = this.globals.size();
        int numPorts = this.cell.getNumPorts();
        for (i2 = 1; i2 <= numPorts; ++i2) {
            Export export = this.cell.getPort(i2 - 1);
            if (NetworkTool.debug) {
                System.out.println(String.valueOf(export) + " " + this.portOffsets[i2 - 1]);
            }
            if (this.portOffsets[i2] == (mapOffset += export.getNameKey().busWidth())) continue;
            changed = true;
            this.portOffsets[i2] = mapOffset;
        }
        if (this.equivPortsN == null || this.equivPortsN.length != mapOffset) {
            this.equivPortsN = new int[mapOffset];
            this.equivPortsP = new int[mapOffset];
            this.equivPortsA = new int[mapOffset];
        }
        for (i2 = 0; i2 < this.numDrawns; ++i2) {
            this.drawnOffsets[i2] = mapOffset;
            mapOffset += this.drawnWidths[i2];
            if (!NetworkTool.debug) continue;
            System.out.println("Drawn " + i2 + " has offset " + this.drawnOffsets[i2]);
        }
        int maxNodeId = this.cell.backup().cellRevision.getMaxNodeId();
        this.iconInsts = new IconInst[maxNodeId + 1];
        this.iconInstExcludeGlobals = null;
        for (int n2 = 0; n2 < numNodes; ++n2) {
            Set gs;
            IconInst iconInst;
            Cell iconCell;
            NodeInst ni = this.cell.getNode(n2);
            if (!ni.isCellInstance() || !(iconCell = (Cell)ni.getProto()).isIcon() && !iconCell.isSchematic()) continue;
            this.iconInsts[ni.getNodeId()] = iconInst = new IconInst(ni, mapOffset);
            if (ni.isIconOfParent()) {
                assert (iconInst.iconOfParent && iconInst.numNodables == -1);
                continue;
            }
            Set set = gs = nodeInstExcludeGlobal != null ? (Set)nodeInstExcludeGlobal.get(ni) : null;
            if (gs != null) {
                if (this.iconInstExcludeGlobals == null) {
                    this.iconInstExcludeGlobals = new IdentityHashMap();
                }
                this.iconInstExcludeGlobals.put(iconInst, gs);
            }
            assert (iconInst.numNodables == ni.getNameKey().busWidth());
            for (int i4 = 0; i4 < ni.getNameKey().busWidth(); ++i4) {
                Nodable proxy;
                if (ni instanceof IconNodeInst) {
                    proxy = ((IconNodeInst)ni).getNodable(i4);
                } else {
                    assert (ni.getNameKey().busWidth() == 1);
                    proxy = ni;
                }
                assert (iconInst.getNetMapOffset(proxy) == mapOffset);
                mapOffset += iconInst.numExtendedExports;
            }
        }
        this.netNamesOffset = mapOffset;
        if (NetworkTool.debug) {
            System.out.println("netNamesOffset=" + this.netNamesOffset);
        }
        return changed;
    }

    private static Global globalInst(NodeInst ni) {
        String globalName;
        NodeProto np = ni.getProto();
        if (np == Schematics.tech().groundNode) {
            return Global.ground;
        }
        if (np == Schematics.tech().powerNode) {
            return Global.power;
        }
        if (np == Schematics.tech().globalNode && (globalName = ni.getVarValue(Schematics.SCHEM_GLOBAL_NAME, String.class)) != null) {
            return Global.newGlobal(globalName);
        }
        return null;
    }

    void calcDrawnWidths() {
        int i2;
        int oldWidth;
        int arcIndex;
        Arrays.fill(this.drawnNames, null);
        Arrays.fill(this.drawnWidths, -1);
        int numPorts = this.cell.getNumPorts();
        int numNodes = this.cell.getNumNodes();
        int numArcs = this.cell.getNumArcs();
        for (int i3 = 0; i3 < numPorts; ++i3) {
            int drawn = this.drawns[i3];
            Name name = this.cell.getPort(i3).getNameKey();
            int newWidth = name.busWidth();
            int oldWidth2 = this.drawnWidths[drawn];
            if (oldWidth2 < 0) {
                this.drawnNames[drawn] = name;
                this.drawnWidths[drawn] = newWidth;
                continue;
            }
            if (oldWidth2 == newWidth) continue;
            this.reportDrawnWidthError(this.cell.getPort(i3), null, this.drawnNames[drawn].toString(), name.toString());
            if (oldWidth2 >= newWidth) continue;
            this.drawnNames[drawn] = name;
            this.drawnWidths[drawn] = newWidth;
        }
        Iterator<ArcInst> it = this.cell.getArcs();
        for (arcIndex = 0; arcIndex < numArcs; ++arcIndex) {
            Name name;
            ArcInst ai = it.next();
            int drawn = this.drawns[this.arcsOffset + arcIndex];
            if (drawn < 0 || (name = ai.getNameKey()).isTempname()) continue;
            int newWidth = name.busWidth();
            oldWidth = this.drawnWidths[drawn];
            if (oldWidth < 0) {
                this.drawnNames[drawn] = name;
                this.drawnWidths[drawn] = newWidth;
                continue;
            }
            if (oldWidth == newWidth) continue;
            this.reportDrawnWidthError(null, ai, this.drawnNames[drawn].toString(), name.toString());
            if (oldWidth >= newWidth) continue;
            this.drawnNames[drawn] = name;
            this.drawnWidths[drawn] = newWidth;
        }
        ArcProto busArc = Schematics.tech().bus_arc;
        Iterator<ArcInst> it2 = this.cell.getArcs();
        for (arcIndex = 0; arcIndex < numArcs; ++arcIndex) {
            Name name;
            ArcInst ai = it2.next();
            int drawn = this.drawns[this.arcsOffset + arcIndex];
            if (drawn < 0 || !(name = ai.getNameKey()).isTempname() || (oldWidth = this.drawnWidths[drawn]) >= 0) continue;
            this.drawnNames[drawn] = name;
            if (ai.getProto() == busArc) continue;
            this.drawnWidths[drawn] = 1;
        }
        for (i2 = 0; i2 < numNodes; ++i2) {
            NodeInst ni = this.cell.getNode(i2);
            NodeProto np = ni.getProto();
            if (!ni.isCellInstance() && (np.getFunction().isPin() || np == Schematics.tech().offpageNode)) continue;
            int numPortInsts = np.getNumPorts();
            for (int j2 = 0; j2 < numPortInsts; ++j2) {
                Cell subCell;
                PortInst pi = ni.getPortInst(j2);
                int drawn = this.drawns[this.getPortInstOffset(pi)];
                if (drawn < 0) continue;
                int oldWidth3 = this.drawnWidths[drawn];
                int newWidth = 1;
                if (ni.isCellInstance() && ((subCell = (Cell)np).isIcon() || subCell.isSchematic())) {
                    int arraySize = subCell.isIcon() ? ni.getNameKey().busWidth() : 1;
                    int portWidth = pi.getPortProto().getNameKey().busWidth();
                    if (oldWidth3 == portWidth) continue;
                    newWidth = arraySize * portWidth;
                }
                if (oldWidth3 < 0) {
                    this.drawnWidths[drawn] = newWidth;
                    continue;
                }
                if (oldWidth3 == newWidth) continue;
                String msg = "Network: Schematic " + String.valueOf(this.cell) + " has net <" + String.valueOf(this.drawnNames[drawn]) + "> with width conflict in connection " + pi.describe(true);
                System.out.println(msg);
                this.networkManager.pushHighlight(pi);
                this.networkManager.logError(msg, 0);
            }
        }
        for (i2 = 0; i2 < this.drawnWidths.length; ++i2) {
            if (this.drawnWidths[i2] < 1) {
                this.drawnWidths[i2] = 1;
            }
            if (!NetworkTool.debug) continue;
            System.out.println("Drawn " + i2 + " " + (this.drawnNames[i2] != null ? this.drawnNames[i2].toString() : "") + " has width " + this.drawnWidths[i2]);
        }
    }

    void reportDrawnWidthError(Export pp, ArcInst ai, String firstname, String badname) {
        int numPorts = this.cell.getNumPorts();
        String msg = "Network: Schematic " + String.valueOf(this.cell) + " has net with conflict width of names <" + firstname + "> and <" + badname + ">";
        System.out.println(msg);
        boolean originalFound = false;
        for (int i2 = 0; i2 < numPorts; ++i2) {
            String name = this.cell.getPort(i2).getName();
            if (!name.equals(firstname)) continue;
            this.networkManager.pushHighlight(this.cell.getPort(i2));
            originalFound = true;
            break;
        }
        if (!originalFound) {
            Iterator<ArcInst> it = this.cell.getArcs();
            while (it.hasNext()) {
                ArcInst oai = it.next();
                String name = oai.getName();
                if (!name.equals(firstname)) continue;
                this.networkManager.pushHighlight(oai);
                break;
            }
        }
        if (ai != null) {
            this.networkManager.pushHighlight(ai);
        }
        if (pp != null) {
            this.networkManager.pushHighlight(pp);
        }
        this.networkManager.logError(msg, 0);
    }

    @Override
    void addNetNames(Name name, Export e2, ArcInst ai) {
        for (int i2 = 0; i2 < name.busWidth(); ++i2) {
            this.addNetName(name.subname(i2), e2, ai);
        }
    }

    private void localConnections(int[] netMap) {
        int numExports = this.cell.getNumPorts();
        for (int k2 = 0; k2 < numExports; ++k2) {
            Export e2 = this.cell.getPort(k2);
            int portOffset = this.portOffsets[k2];
            Name expNm = e2.getNameKey();
            int busWidth = expNm.busWidth();
            int drawn = this.drawns[k2];
            int drawnOffset = this.drawnOffsets[drawn];
            for (int i2 = 0; i2 < busWidth; ++i2) {
                Netlist.connectMap(netMap, portOffset + i2, drawnOffset + (busWidth == this.drawnWidths[drawn] ? i2 : i2 % this.drawnWidths[drawn]));
                MutableInteger nn = (MutableInteger)this.netNames.get(expNm.subname(i2));
                Netlist.connectMap(netMap, portOffset + i2, this.netNamesOffset + nn.intValue());
            }
        }
        int numNodes = this.cell.getNumNodes();
        for (int k3 = 0; k3 < numNodes; ++k3) {
            NodeInst ni = this.cell.getNode(k3);
            int nodeId = ni.getNodeId();
            NodeProto np = ni.getProto();
            if (!ni.isCellInstance()) {
                Global g2 = NetSchem.globalInst(ni);
                if (g2 != null) {
                    int drawn = this.drawns[this.ni_pi[nodeId]];
                    Netlist.connectMap(netMap, this.globals.indexOf(g2), this.drawnOffsets[drawn]);
                }
                if (np != Schematics.tech().wireConNode) continue;
                this.connectWireCon(netMap, ni);
                continue;
            }
            IconInst iconInst = this.iconInsts[nodeId];
            if (iconInst == null || iconInst.iconOfParent) continue;
            Cell subCell = (Cell)np;
            assert (subCell.isIcon() || subCell.isSchematic());
            EquivalentSchematicExports eq = iconInst.eq;
            Name nodeName = ni.getNameKey();
            int arraySize = nodeName.busWidth();
            int numPorts = np.getNumPorts();
            for (int m2 = 0; m2 < numPorts; ++m2) {
                int width;
                Export e3 = (Export)np.getPort(m2);
                Name busExportName = e3.getNameKey();
                int busWidth = busExportName.busWidth();
                int drawn = this.drawns[this.ni_pi[nodeId] + m2];
                if (drawn < 0 || (width = this.drawnWidths[drawn]) != busWidth && width != busWidth * arraySize) continue;
                assert (arraySize == iconInst.numNodables);
                for (int arrayIndex = 0; arrayIndex < arraySize; ++arrayIndex) {
                    int nodeOffset = iconInst.netMapOffset + arrayIndex * iconInst.numExtendedExports;
                    int busOffset = this.drawnOffsets[drawn];
                    if (width != busWidth) {
                        busOffset += busWidth * arrayIndex;
                    }
                    for (int j2 = 0; j2 < busWidth; ++j2) {
                        Name exportName = busExportName.subname(j2);
                        int portOffset = eq.implementation.getExportNameMapOffset(exportName);
                        if (portOffset < 0) continue;
                        Netlist.connectMap(netMap, busOffset + j2, nodeOffset + portOffset);
                    }
                }
            }
        }
        int numArcs = this.cell.getNumArcs();
        Iterator<Geometric> it = this.cell.getArcs();
        for (int arcIndex = 0; arcIndex < numArcs; ++arcIndex) {
            ArcInst ai = it.next();
            int drawn = this.drawns[this.arcsOffset + arcIndex];
            if (drawn < 0 || !ai.isUsernamed()) continue;
            int busWidth = this.drawnWidths[drawn];
            Name arcNm = ai.getNameKey();
            if (arcNm.busWidth() != busWidth) continue;
            int drawnOffset = this.drawnOffsets[drawn];
            for (int i3 = 0; i3 < busWidth; ++i3) {
                MutableInteger nn = (MutableInteger)this.netNames.get(arcNm.subname(i3));
                Netlist.connectMap(netMap, drawnOffset + i3, this.netNamesOffset + nn.intValue());
            }
        }
        it = this.cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            IconInst iconInst = this.iconInsts[ni.getNodeId()];
            if (iconInst == null || iconInst.iconOfParent) continue;
            Set<Global> excludeGlobals = null;
            if (this.iconInstExcludeGlobals != null) {
                excludeGlobals = this.iconInstExcludeGlobals.get(iconInst);
            }
            for (int k4 = 0; k4 < iconInst.numNodables; ++k4) {
                EquivalentSchematicExports eq = iconInst.eq.implementation;
                assert (eq.implementation == eq);
                int numGlobals = eq.portOffsets[0];
                if (numGlobals == 0) continue;
                int nodableOffset = iconInst.netMapOffset + k4 * iconInst.numExtendedExports;
                for (int i4 = 0; i4 < numGlobals; ++i4) {
                    Global g3 = eq.globals.get(i4);
                    if (excludeGlobals != null && excludeGlobals.contains(g3)) continue;
                    Netlist.connectMap(netMap, this.globals.indexOf(g3), nodableOffset + i4);
                }
            }
        }
        Netlist.closureMap(netMap);
    }

    private void connectWireCon(int[] netMap, NodeInst ni) {
        ArcInst ai1 = null;
        ArcInst ai2 = null;
        Iterator<Connection> it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = it.next();
            ArcInst ai = con.getArc();
            if (ai1 == null) {
                ai1 = ai;
                continue;
            }
            if (ai2 == null) {
                ai2 = ai;
                continue;
            }
            String msg = "Network: Schematic " + String.valueOf(this.cell) + " has connector " + String.valueOf(ni) + " which merges more than two arcs";
            System.out.println(msg);
            this.networkManager.pushHighlight(ni);
            this.networkManager.logError(msg, 0);
            return;
        }
        if (ai2 == null || ai1 == ai2) {
            return;
        }
        int large = this.getArcDrawn(ai1);
        int small = this.getArcDrawn(ai2);
        if (large < 0 || small < 0) {
            return;
        }
        if (this.drawnWidths[small] > this.drawnWidths[large]) {
            int temp = small;
            small = large;
            large = temp;
        }
        for (int i2 = 0; i2 < this.drawnWidths[large]; ++i2) {
            Netlist.connectMap(netMap, this.drawnOffsets[large] + i2, this.drawnOffsets[small] + i2 % this.drawnWidths[small]);
        }
    }

    private void internalConnections(int[] netMapF, int[] netMapP, int[] netMapA) {
        NodeInst ni;
        int numNodes = this.cell.getNumNodes();
        for (int k2 = 0; k2 < numNodes; ++k2) {
            ni = this.cell.getNode(k2);
            int nodeId = ni.getNodeId();
            int nodeOffset = this.ni_pi[nodeId];
            NodeProto np = ni.getProto();
            if (!ni.isCellInstance()) {
                PrimitiveNode.Function fun = ni.getFunction();
                if (fun == PrimitiveNode.Function.RESIST) {
                    assert (this.drawns.length > 1);
                    Netlist.connectMap(netMapP, this.drawnOffsets[this.drawns[nodeOffset]], this.drawnOffsets[this.drawns[nodeOffset + 1]]);
                    Netlist.connectMap(netMapA, this.drawnOffsets[this.drawns[nodeOffset]], this.drawnOffsets[this.drawns[nodeOffset + 1]]);
                    continue;
                }
                if (!fun.isComplexResistor()) continue;
                assert (this.drawns.length > 1);
                Netlist.connectMap(netMapA, this.drawnOffsets[this.drawns[nodeOffset]], this.drawnOffsets[this.drawns[nodeOffset + 1]]);
                continue;
            }
            IconInst iconInst = this.iconInsts[nodeId];
            if (iconInst != null) continue;
            Cell subCell = (Cell)np;
            assert (!subCell.isIcon() && !subCell.isSchematic());
            EquivPorts eq = this.cell.tree().getEquivPorts();
            int[] eqN = eq.getEquivPortsN();
            int[] eqP = eq.getEquivPortsP();
            int[] eqA = eq.getEquivPortsA();
            int numPorts = eq.getNumExports();
            assert (eqN.length == numPorts && eqP.length == numPorts && eqA.length == numPorts);
            for (int i2 = 0; i2 < numPorts; ++i2) {
                int dj;
                int jA;
                int dj2;
                int jP;
                int dj3;
                int di = this.drawns[nodeOffset + i2];
                if (di < 0) continue;
                int jN = eqN[i2];
                if (i2 != jN && (dj3 = this.drawns[nodeOffset + jN]) >= 0) {
                    Netlist.connectMap(netMapF, this.drawnOffsets[di], this.drawnOffsets[dj3]);
                }
                if (i2 != (jP = eqP[i2]) && (dj2 = this.drawns[nodeOffset + jP]) >= 0) {
                    Netlist.connectMap(netMapP, this.drawnOffsets[di], this.drawnOffsets[dj2]);
                }
                if (i2 == (jA = eqA[i2]) || (dj = this.drawns[nodeOffset + jA]) < 0) continue;
                Netlist.connectMap(netMapA, this.drawnOffsets[di], this.drawnOffsets[dj]);
            }
        }
        Iterator<NodeInst> it = this.cell.getNodes();
        while (it.hasNext()) {
            ni = it.next();
            IconInst iconInst = this.iconInsts[ni.getNodeId()];
            if (iconInst == null || iconInst.iconOfParent) continue;
            for (int k3 = 0; k3 < iconInst.numNodables; ++k3) {
                EquivalentSchematicExports eq = iconInst.eq.implementation;
                assert (eq.implementation == eq);
                int[] eqN = eq.getEquivPortsN();
                int[] eqP = eq.getEquivPortsP();
                int[] eqA = eq.getEquivPortsA();
                int nodableOffset = iconInst.netMapOffset + k3 * iconInst.numExtendedExports;
                for (int i3 = 0; i3 < eqN.length; ++i3) {
                    int jA;
                    int jP;
                    int io = nodableOffset + i3;
                    int jF = eqN[i3];
                    if (i3 != jF) {
                        Netlist.connectMap(netMapF, io, nodableOffset + jF);
                    }
                    if (i3 != (jP = eqP[i3])) {
                        Netlist.connectMap(netMapP, io, nodableOffset + jP);
                    }
                    if (i3 == (jA = eqA[i3])) continue;
                    Netlist.connectMap(netMapA, io, nodableOffset + jA);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void buildNetworkLists(int[] netMapF) {
        void var4_14;
        int index;
        this.netlistN = new NetlistImpl(this, this.equivPortsN.length, netMapF);
        int equivPortIndex = 0;
        for (int i2 = 0; i2 < this.globals.size(); ++i2) {
            Global global = this.globals.get(i2);
            int netIndex = this.netlistN.getNetIndex(global);
            this.netlistN.addUserName(netIndex, global.getNameKey(), true);
            this.netlistN.setEquivPortIndexByNetIndex(equivPortIndex++, netIndex);
        }
        Iterator<Object> it = this.cell.getExports();
        while (it.hasNext()) {
            Export export = it.next();
            for (int busIndex = 0; busIndex < export.getNameKey().busWidth(); ++busIndex) {
                this.netlistN.setEquivPortIndexByNetIndex(equivPortIndex++, this.netlistN.getNetIndex(export, busIndex));
            }
        }
        for (Map.Entry entry : this.netNames.entrySet()) {
            Name name = (Name)entry.getKey();
            index = ((MutableInteger)entry.getValue()).intValue();
            if (index < 0 || index >= this.exportedNetNameCount) continue;
            this.netlistN.addUserName(this.netlistN.getNetIndexByMap(this.netNamesOffset + index), name, true);
        }
        for (Map.Entry entry : this.netNames.entrySet()) {
            Name name = (Name)entry.getKey();
            index = ((MutableInteger)entry.getValue()).intValue();
            if (index < this.exportedNetNameCount) continue;
            this.netlistN.addUserName(this.netlistN.getNetIndexByMap(this.netNamesOffset + index), name, false);
        }
        int numArcs = this.cell.getNumArcs();
        boolean bl = false;
        Iterator<ArcInst> it2 = this.cell.getArcs();
        while (var4_14 < numArcs) {
            ArcInst ai = it2.next();
            int drawn = this.drawns[this.arcsOffset + var4_14];
            if (drawn >= 0) {
                for (int j2 = 0; j2 < this.drawnWidths[drawn]; ++j2) {
                    Object netName;
                    int netIndexN = this.netlistN.getNetIndex(ai, j2);
                    if (netIndexN >= 0 && this.netlistN.hasNames(netIndexN)) {
                        netIndexN = -1;
                    }
                    if (netIndexN < 0 || this.drawnNames[drawn] == null) continue;
                    if (this.drawnWidths[drawn] == 1) {
                        netName = this.drawnNames[drawn].toString();
                    } else if (this.drawnNames[drawn].isTempname()) {
                        int busIndex = NetworkTool.isBusAscendingInNetlistEngine() ? j2 : this.drawnWidths[drawn] - 1 - j2;
                        netName = this.drawnNames[drawn].toString() + "[" + busIndex + "]";
                    } else {
                        netName = this.drawnNames[drawn].subname(j2).toString();
                    }
                    if (netIndexN < 0) continue;
                    this.netlistN.addTempName(netIndexN, (String)netName);
                }
            }
            ++var4_14;
        }
        Iterator<Nodable> it3 = this.getNodables();
        while (it3.hasNext()) {
            Nodable no = it3.next();
            NodeProto np = no.getProto();
            int numPorts = np.getNumPorts();
            for (int i3 = 0; i3 < numPorts; ++i3) {
                PortProto pp = np.getPort(i3);
                int busWidth = pp.getNameKey().busWidth();
                for (int k2 = 0; k2 < busWidth; ++k2) {
                    int netIndexN = this.netlistN.getNetIndex(no, pp, k2);
                    if (netIndexN < 0 || this.netlistN.hasNames(netIndexN)) continue;
                    this.netlistN.addTempName(netIndexN, no.getName() + "." + String.valueOf(pp.getNameKey().subname(k2)));
                }
            }
        }
        int numNodes = this.cell.getNumNodes();
        for (int n2 = 0; n2 < numNodes; ++n2) {
            NodeInst ni = this.cell.getNode(n2);
            int nodeId = ni.getNodeId();
            NodeProto np = ni.getProto();
            int arraySize = ni.getNameKey().busWidth();
            int numPorts = np.getNumPorts();
            for (int i4 = 0; i4 < numPorts; ++i4) {
                PortProto pp = np.getPort(i4);
                int drawn = this.drawns[this.ni_pi[nodeId] + i4];
                if (drawn < 0) continue;
                int busWidth = pp.getNameKey().busWidth();
                int drawnWidth = this.drawnWidths[drawn];
                for (int l2 = 0; l2 < drawnWidth; ++l2) {
                    int netIndexN = this.netlistN.getNetIndexByMap(this.drawnOffsets[drawn] + l2);
                    if (netIndexN < 0 || this.netlistN.hasNames(netIndexN)) continue;
                    int arrayIndex = l2 / busWidth % arraySize;
                    int busIndex = l2 % busWidth;
                    this.netlistN.addTempName(netIndexN, String.valueOf(ni.getNameKey().subname(arrayIndex)) + "." + String.valueOf(pp.getNameKey().subname(busIndex)));
                }
            }
        }
        int numNetworks = this.netlistN.getNumNetworks();
        for (int i5 = 0; i5 < numNetworks; ++i5) {
            assert (this.netlistN.hasNames(i5));
            assert (this.netlistN.isExported(i5) == i5 < this.netlistN.getNumExternalNetworks());
            if (!this.netlistN.isExported(i5)) continue;
            int equivPortInd = this.netlistN.getEquivPortIndexByNetIndex(i5);
            assert (equivPortInd >= 0 && equivPortInd < equivPortIndex);
        }
    }

    private boolean updateInterface() {
        boolean changed = false;
        for (int i2 = 0; i2 < this.equivPortsN.length; ++i2) {
            if (this.equivPortsN[i2] != this.netlistN.netMap[i2]) {
                changed = true;
                this.equivPortsN[i2] = this.netlistN.netMap[i2];
            }
            if (this.equivPortsP[i2] != this.netlistP.netMap[i2]) {
                changed = true;
                this.equivPortsP[i2] = this.netlistP.netMap[i2];
            }
            if (this.equivPortsA[i2] == this.netlistA.netMap[i2]) continue;
            changed = true;
            this.equivPortsA[i2] = this.netlistA.netMap[i2];
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSchematic() {
        NetworkManager networkManager = this.networkManager;
        synchronized (networkManager) {
            Snapshot oldSnapshot = (Snapshot)this.expectedSnapshot.get();
            Snapshot newSnapshot = this.database.backup();
            if (oldSnapshot == newSnapshot) {
                return;
            }
            CellId cellId = this.cell.getId();
            assert (cellId.isIcon() || cellId.isSchematic());
            if (this.cellTree != newSnapshot.getCellTree(cellId) || this.mainSchemId != newSnapshot.getMainSchematics(cellId) || this.mainSchemId != cellId && this.mainSchemId != null && !this.eqExports.get(this.mainSchemId).equals(newSnapshot.getEquivExports(this.mainSchemId)) || !this.sameEqivPortsOfSubcells(newSnapshot, this.cell.getId())) {
                this.networkManager.startErrorLogging(this.cell);
                try {
                    this.exportNameMapOffsets = null;
                    this.makeDrawns();
                    this.initNetnames();
                    this.redoNetworks1();
                }
                finally {
                    this.networkManager.finishErrorLogging();
                }
                this.cellTree = newSnapshot.getCellTree(cellId);
                this.mainSchemId = newSnapshot.getMainSchematics(cellId);
                this.eqExports = new IdentityHashMap();
                if (this.mainSchemId != null) {
                    this.eqExports.put(this.mainSchemId, newSnapshot.getEquivExports(this.mainSchemId));
                }
                for (CellTree subTree : this.cellTree.getSubTrees()) {
                    CellId subCellId;
                    if (subTree == null || !(subCellId = subTree.top.cellRevision.d.cellId).isIcon() && !subCellId.isSchematic()) continue;
                    this.eqExports.put(subCellId, newSnapshot.getEquivExports(subCellId));
                }
            }
            this.expectedSnapshot = new WeakReference<Snapshot>(newSnapshot);
        }
    }

    private boolean sameEqivPortsOfSubcells(Snapshot newSnapshot, CellId cellId) {
        for (CellTree subTree : newSnapshot.getCellTree(cellId).getSubTrees()) {
            CellId subCellId;
            if (subTree == null || (!(subCellId = subTree.top.cellRevision.d.cellId).isIcon() ? !subCellId.isSchematic() : cellId.isSchematic() && newSnapshot.getCellGroupIndex(cellId) == newSnapshot.getCellGroupIndex(subCellId))) continue;
            if (newSnapshot.getEquivExports(subCellId).equals(this.eqExports.get(subCellId))) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean redoNetworks1() {
        int numPorts = this.cell.getNumPorts();
        if (this.portOffsets.length != numPorts + 1) {
            this.portOffsets = new int[numPorts + 1];
        }
        if (this.drawnNames == null || this.drawnNames.length != this.numDrawns) {
            this.drawnNames = new Name[this.numDrawns];
            this.drawnWidths = new int[this.numDrawns];
            this.drawnOffsets = new int[this.numDrawns];
        }
        this.calcDrawnWidths();
        boolean changed = this.initNodables();
        int mapSize = this.netNamesOffset + this.netNames.size();
        int[] netMapF = Netlist.initMap(mapSize);
        this.localConnections(netMapF);
        int[] netMapP = (int[])netMapF.clone();
        int[] netMapA = (int[])netMapF.clone();
        this.internalConnections(netMapF, netMapP, netMapA);
        this.buildNetworkLists(netMapF);
        assert (this.equivPortsP.length == this.equivPortsN.length);
        this.netlistP = new NetlistShorted(this.netlistN, Netlist.ShortResistors.PARASITIC, netMapP);
        assert (this.equivPortsA.length == this.equivPortsN.length);
        this.netlistA = new NetlistShorted(this.netlistN, Netlist.ShortResistors.ALL, netMapA);
        if (this.updateInterface()) {
            changed = true;
        }
        if (Job.getDebug()) {
            EquivalentSchematicExports eq = this.cell.getDatabase().backup().getEquivExports(this.cell.getId());
            assert (this.globals.equals(eq.getGlobals()));
            assert (Arrays.equals(this.equivPortsN, eq.getEquivPortsN()));
            assert (Arrays.equals(this.equivPortsP, eq.getEquivPortsP()));
            assert (Arrays.equals(this.equivPortsA, eq.getEquivPortsA()));
        }
        return changed;
    }

    @Override
    boolean obsolete(Netlist netlist) {
        Netlist newNetlist = this.getNetlist(netlist.shortResistors);
        this.netlistP.expectedSnapshot = this.netlistA.expectedSnapshot = this.expectedSnapshot;
        this.netlistN.expectedSnapshot = this.netlistA.expectedSnapshot;
        return newNetlist != netlist;
    }

    private class IconInst {
        final NodeInst nodeInst;
        final boolean iconOfParent;
        final int numNodables;
        final int netMapOffset;
        final int numExtendedExports;
        final EquivalentSchematicExports eq;

        private IconInst(NodeInst nodeInst, int nodeOffset) {
            Cell proto = (Cell)nodeInst.getProto();
            assert (proto.isIcon() || proto.isSchematic());
            this.nodeInst = nodeInst;
            this.iconOfParent = nodeInst.isIconOfParent();
            this.numNodables = this.iconOfParent ? -1 : nodeInst.getNameKey().busWidth();
            this.netMapOffset = nodeOffset;
            this.eq = this.iconOfParent ? null : nodeInst.getDatabase().backup().getEquivExports(proto.getId());
            this.numExtendedExports = this.iconOfParent ? -1000000 : this.eq.implementation.numExpandedExports;
        }

        private Nodable getNodable(int arrayIndex) {
            assert (this.numNodables == this.nodeInst.getNumNodables());
            return this.nodeInst.getNodable(arrayIndex);
        }

        private int getNetMapOffset(Nodable proxy) {
            int arrayIndex = proxy.getNodableArrayIndex();
            assert (this.getNodable(arrayIndex) == proxy);
            return this.netMapOffset + arrayIndex * this.numExtendedExports;
        }
    }
}

