/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.CellTree;
import com.sun.electric.database.EquivPorts;
import com.sun.electric.database.ImmutableNet;
import com.sun.electric.database.ImmutableNetLayout;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.NetSchem;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.NetlistImpl;
import com.sun.electric.database.network.NetlistShorted;
import com.sun.electric.database.network.NetworkManager;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.util.math.MutableInteger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NetCell {
    static final int VALID = 1;
    static final int LOCALVALID = 2;
    static final char PORT_SEPARATOR = '.';
    final NetworkManager networkManager;
    final EDatabase database;
    final boolean isSchem;
    final Cell cell;
    int flags;
    WeakReference<Snapshot> expectedSnapshot;
    WeakReference<CellTree> expectedCellTree;
    int[] equivPortsN;
    int[] equivPortsP;
    int[] equivPortsA;
    int[] ni_pi;
    int arcsOffset;
    private int[] headConn;
    private int[] tailConn;
    int[] drawns;
    int numDrawns;
    int numExportedDrawns;
    int numConnectedDrawns;
    HashMap<Name, MutableInteger> netNames = new HashMap();
    private int netNameCount;
    int exportedNetNameCount;
    NetlistImpl netlistN;
    NetlistShorted netlistP;
    NetlistShorted netlistA;
    private static PortProto busPinPort = Schematics.tech().busPinNode.getPort(0);
    private static ArcProto busArc = Schematics.tech().bus_arc;
    private ArrayList<PortInst> stack;

    NetCell(Cell cell) {
        this.database = cell.getDatabase();
        this.networkManager = this.database.getNetworkManager();
        this.isSchem = this instanceof NetSchem;
        if (this.isSchem) {
            this.expectedSnapshot = new WeakReference<Object>(null);
        } else {
            this.expectedCellTree = new WeakReference<Object>(null);
        }
        this.cell = cell;
    }

    public static NetCell newInst(Cell cell) {
        return cell.isIcon() || cell.isSchematic() ? new NetSchem(cell) : new NetCell(cell);
    }

    public Netlist getNetlist(Netlist.ShortResistors shortResistors) {
        if (this.isSchem) {
            if (this.database.backup() != this.expectedSnapshot.get()) {
                ((NetSchem)this).updateSchematic();
            }
        } else if (this.cell.tree() != this.expectedCellTree.get()) {
            this.updateLayout();
        }
        switch (shortResistors) {
            case NO: {
                return this.netlistN;
            }
            case PARASITIC: {
                return this.netlistP;
            }
            case ALL: {
                return this.netlistA;
            }
        }
        throw new AssertionError();
    }

    Iterator<Nodable> getNodables() {
        return this.cell.getNodables();
    }

    Global.Set getGlobals() {
        return Global.Set.empty;
    }

    int getNetMapOffset(Global global) {
        return -1;
    }

    int getNetMapOffset(Nodable no, Global global) {
        return -1;
    }

    int getNetMapOffset(Nodable no, int equivPortIndex) {
        NodeInst ni = (NodeInst)no;
        if (this.cell.getNodeById(ni.getNodeId()) != ni) {
            throw new IllegalArgumentException();
        }
        return this.drawns[this.ni_pi[ni.getNodeId()] + equivPortIndex];
    }

    int getNetMapOffset(Nodable no, PortProto portProto, int busIndex) {
        NodeInst ni = (NodeInst)no;
        if (this.cell.getNodeById(ni.getNodeId()) != ni) {
            throw new IllegalArgumentException();
        }
        return this.drawns[this.ni_pi[ni.getNodeId()] + portProto.getPortIndex()];
    }

    int getNetMapOffset(Nodable no, Name portName) {
        NodeInst ni = (NodeInst)no;
        if (this.cell.getNodeById(ni.getNodeId()) != ni) {
            throw new IllegalArgumentException();
        }
        PortProto portProto = ni.getProto().findPortProto(portName);
        if (portProto == null) {
            return -1;
        }
        return this.drawns[this.ni_pi[ni.getNodeId()] + portProto.getPortIndex()];
    }

    int getBusWidth(Nodable no, PortProto portProto) {
        return 1;
    }

    int getNetMapOffset(Export export, int busIndex) {
        return this.drawns[export.getPortIndex()];
    }

    int getNetMapOffset(Name exportName) {
        Export export = this.cell.findExport(exportName);
        return export != null ? this.drawns[export.getPortIndex()] : -1;
    }

    int getNetMapOffset(ArcInst ai, int busIndex) {
        return this.getArcDrawn(ai);
    }

    Name getBusName(ArcInst ai) {
        return null;
    }

    int getBusWidth(ArcInst ai) {
        int drawn = this.getArcDrawn(ai);
        if (drawn < 0) {
            return 0;
        }
        return 1;
    }

    int getArcDrawn(ArcInst ai) {
        assert (ai.getParent() == this.cell);
        int arcIndex = this.cell.backup().cellRevision.getArcIndexByArcId(ai.getArcId());
        return this.drawns[this.arcsOffset + arcIndex];
    }

    private void initConnections() {
        int i2;
        int numPorts = this.cell.getNumPorts();
        int maxNodeId = this.cell.backup().cellRevision.getMaxNodeId();
        int numArcs = this.cell.getNumArcs();
        if (this.ni_pi == null || this.ni_pi.length != maxNodeId + 1) {
            this.ni_pi = new int[maxNodeId + 1];
        }
        int offset = numPorts;
        for (int nodeId = 0; nodeId <= maxNodeId; ++nodeId) {
            this.ni_pi[nodeId] = offset;
            NodeInst ni = this.cell.getNodeById(nodeId);
            if (ni == null) continue;
            offset += ni.getProto().getNumPorts();
        }
        this.arcsOffset = offset;
        if (this.headConn == null || this.headConn.length != (offset += numArcs)) {
            this.headConn = new int[offset];
            this.tailConn = new int[offset];
            this.drawns = new int[offset];
        }
        for (i2 = numPorts; i2 < this.arcsOffset; ++i2) {
            this.headConn[i2] = i2;
            this.tailConn[i2] = i2;
        }
        for (i2 = 0; i2 < numPorts; ++i2) {
            int portOffset = i2;
            Export export = this.cell.getPort(i2);
            int orig = this.getPortInstOffset(export.getOriginalPort());
            this.headConn[portOffset] = this.headConn[orig];
            this.headConn[orig] = portOffset;
            this.tailConn[portOffset] = -1;
        }
        Iterator<ArcInst> it = this.cell.getArcs();
        for (int arcIndex = 0; arcIndex < numArcs; ++arcIndex) {
            ArcInst ai = it.next();
            int arcOffset = this.arcsOffset + arcIndex;
            int head = this.getPortInstOffset(ai.getHeadPortInst());
            this.headConn[arcOffset] = this.headConn[head];
            this.headConn[head] = arcOffset;
            int tail = this.getPortInstOffset(ai.getTailPortInst());
            this.tailConn[arcOffset] = this.tailConn[tail];
            this.tailConn[tail] = arcOffset;
        }
    }

    private void addToDrawn1(PortInst pi) {
        ArcProto ap;
        ArcInst ai;
        int piOffset = this.getPortInstOffset(pi);
        if (this.drawns[piOffset] >= 0) {
            return;
        }
        PortProto pp = pi.getPortProto();
        if (pp instanceof PrimitivePort && ((PrimitivePort)pp).isIsolated()) {
            return;
        }
        this.drawns[piOffset] = this.numDrawns;
        if (NetworkTool.debug) {
            System.out.println(this.numDrawns + ": " + String.valueOf(pi));
        }
        int k2 = piOffset;
        while (this.headConn[k2] != piOffset) {
            PortInst tpi;
            if (this.drawns[k2 = this.headConn[k2]] >= 0) continue;
            if (k2 < this.arcsOffset) {
                this.drawns[k2] = this.numDrawns;
                if (!NetworkTool.debug) continue;
                System.out.println(this.numDrawns + ": " + String.valueOf(this.cell.getPort(k2)));
                continue;
            }
            ai = this.cell.getArc(k2 - this.arcsOffset);
            ap = ai.getProto();
            if (ap.getFunction() == ArcProto.Function.NONELEC || pp == busPinPort && ap != busArc) continue;
            this.drawns[k2] = this.numDrawns;
            if (NetworkTool.debug) {
                System.out.println(this.numDrawns + ": " + String.valueOf(ai));
            }
            if ((tpi = ai.getTailPortInst()).getPortProto() == busPinPort && ap != busArc) continue;
            this.stack.add(tpi);
        }
        k2 = piOffset;
        while (this.tailConn[k2] != piOffset) {
            PortInst hpi;
            if (this.drawns[k2 = this.tailConn[k2]] >= 0 || (ap = (ai = this.cell.getArc(k2 - this.arcsOffset)).getProto()).getFunction() == ArcProto.Function.NONELEC || pp == busPinPort && ap != busArc) continue;
            this.drawns[k2] = this.numDrawns;
            if (NetworkTool.debug) {
                System.out.println(this.numDrawns + ": " + String.valueOf(ai));
            }
            if ((hpi = ai.getHeadPortInst()).getPortProto() == busPinPort && ap != busArc) continue;
            this.stack.add(hpi);
        }
    }

    private void addToDrawn(PortInst pi) {
        assert (this.stack.isEmpty());
        this.stack.add(pi);
        while (!this.stack.isEmpty()) {
            pi = this.stack.remove(this.stack.size() - 1);
            PortProto pp = pi.getPortProto();
            NodeProto np = pp.getParent();
            int numPorts = np.getNumPorts();
            if (numPorts == 1 || np instanceof Cell) {
                this.addToDrawn1(pi);
                continue;
            }
            NodeInst ni = pi.getNodeInst();
            int topology = ((PrimitivePort)pp).getTopology();
            for (int i2 = 0; i2 < numPorts; ++i2) {
                if (((PrimitivePort)np.getPort(i2)).getTopology() != topology) continue;
                this.addToDrawn1(ni.getPortInst(i2));
            }
        }
    }

    void makeDrawns() {
        int i2;
        this.initConnections();
        Arrays.fill(this.drawns, -1);
        this.stack = new ArrayList();
        this.numDrawns = 0;
        int numPorts = this.cell.getNumPorts();
        for (i2 = 0; i2 < numPorts; ++i2) {
            if (this.drawns[i2] >= 0) continue;
            this.drawns[i2] = this.numDrawns++;
            Export export = this.cell.getPort(i2);
            this.addToDrawn(export.getOriginalPort());
        }
        this.numExportedDrawns = this.numDrawns;
        int numArcs = this.cell.getNumArcs();
        for (i2 = 0; i2 < numArcs; ++i2) {
            PortInst tpi;
            PortInst hpi;
            ArcInst ai;
            ArcProto ap;
            if (this.drawns[this.arcsOffset + i2] >= 0 || (ap = (ai = this.cell.getArc(i2)).getProto()).getFunction() == ArcProto.Function.NONELEC) continue;
            this.drawns[this.arcsOffset + i2] = this.numDrawns;
            if (NetworkTool.debug) {
                System.out.println(this.numDrawns + ": " + String.valueOf(ai));
            }
            if ((hpi = ai.getHeadPortInst()).getPortProto() != busPinPort || ap == busArc) {
                this.addToDrawn(hpi);
            }
            if ((tpi = ai.getTailPortInst()).getPortProto() != busPinPort || ap == busArc) {
                this.addToDrawn(tpi);
            }
            ++this.numDrawns;
        }
        this.numConnectedDrawns = this.numDrawns;
        int numNodes = this.cell.getNumNodes();
        for (i2 = 0; i2 < numNodes; ++i2) {
            NodeInst ni = this.cell.getNode(i2);
            NodeProto np = ni.getProto();
            if (ni.isIconOfParent() || np.getFunction() == PrimitiveNode.Function.ART && np != Generic.tech().simProbeNode || np == Artwork.tech().pinNode || np == Generic.tech().invisiblePinNode) continue;
            int numPortInsts = np.getNumPorts();
            for (int j2 = 0; j2 < numPortInsts; ++j2) {
                PortInst pi = ni.getPortInst(j2);
                int piOffset = this.getPortInstOffset(pi);
                if (this.drawns[piOffset] >= 0 || pi.getPortProto() instanceof PrimitivePort && ((PrimitivePort)pi.getPortProto()).isIsolated()) continue;
                this.addToDrawn(pi);
                ++this.numDrawns;
            }
        }
        this.stack = null;
        this.tailConn = null;
        this.headConn = null;
        if (Job.getDebug()) {
            this.checkDrawns();
        }
    }

    private void checkDrawns() {
        ImmutableNet nets = new ImmutableNet(this.cell.tree());
        assert (this.numExportedDrawns == nets.numExportedDrawns);
        assert (this.numConnectedDrawns == nets.numConnectedDrawns);
        assert (this.numDrawns == nets.numDrawns);
        for (int exportIndex = 0; exportIndex < this.cell.getNumPorts(); ++exportIndex) {
            Export e2 = this.cell.getPort(exportIndex);
            assert (this.drawns[exportIndex] == nets.getDrawn(e2.getId()));
        }
        for (int nodeIndex = 0; nodeIndex < this.cell.getNumNodes(); ++nodeIndex) {
            NodeInst ni = this.cell.getNode(nodeIndex);
            int mapOffset = this.ni_pi[ni.getNodeId()];
            NodeProto np = ni.getProto();
            for (int portIndex = 0; portIndex < np.getNumPorts(); ++portIndex) {
                assert (this.drawns[mapOffset + portIndex] == nets.getDrawn(ni.getD(), np.getPort(portIndex).getId()));
            }
        }
        for (int arcIndex = 0; arcIndex < this.cell.getNumArcs(); ++arcIndex) {
            ArcInst ai = this.cell.getArc(arcIndex);
            assert (this.drawns[this.arcsOffset + arcIndex] == nets.getDrawn(ai.getD()));
        }
    }

    void showDrawns() {
        PrintWriter out;
        String filePath = "tttt";
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(filePath, true)));
        }
        catch (IOException e2) {
            System.out.println("Error opening " + filePath);
            return;
        }
        out.println("Drawns " + String.valueOf(this.cell));
        int numPorts = this.cell.getNumPorts();
        for (int drawn = 0; drawn < this.numDrawns; ++drawn) {
            for (int i2 = 0; i2 < this.drawns.length; ++i2) {
                int nodeId;
                if (this.drawns[i2] != drawn) continue;
                if (i2 < numPorts) {
                    out.println(drawn + ": " + String.valueOf(this.cell.getPort(i2)));
                    continue;
                }
                if (i2 >= this.arcsOffset) {
                    out.println(drawn + ": " + String.valueOf(this.cell.getArc(i2 - this.arcsOffset)));
                    continue;
                }
                for (nodeId = 1; nodeId < this.ni_pi.length && this.ni_pi[nodeId] <= i2; ++nodeId) {
                }
                NodeInst ni = this.cell.getNodeById(--nodeId);
                PortInst pi = ni.getPortInst(i2 - this.ni_pi[nodeId]);
                out.println(drawn + ": " + String.valueOf(pi));
            }
        }
        out.close();
    }

    void initNetnames() {
        Object e2;
        for (MutableInteger nn : this.netNames.values()) {
            nn.setValue(-1);
        }
        this.netNameCount = 0;
        Iterator<Object> it = this.cell.getExports();
        while (it.hasNext()) {
            e2 = it.next();
            this.addNetNames(((Export)e2).getNameKey(), (Export)e2, null);
        }
        this.exportedNetNameCount = this.netNameCount;
        it = this.cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            if (ai.getProto().getFunction() == ArcProto.Function.NONELEC) continue;
            if (ai.getNameKey().isBus() && ai.getProto() != busArc) {
                String msg = "Network: " + String.valueOf(this.cell) + " has bus name <" + String.valueOf(ai.getNameKey()) + "> on arc that is not a bus";
                System.out.println(msg);
                this.networkManager.pushHighlight(ai);
                this.networkManager.logError(msg, 0);
            }
            if (!ai.isUsernamed()) continue;
            this.addNetNames(ai.getNameKey(), null, ai);
        }
        it = this.netNames.entrySet().iterator();
        while (it.hasNext()) {
            e2 = (Map.Entry)it.next();
            Name name = (Name)e2.getKey();
            int index = ((MutableInteger)e2.getValue()).intValue();
            if (index < 0) {
                it.remove();
                continue;
            }
            if (!NetworkTool.debug) continue;
            System.out.println("NetName " + String.valueOf(name) + " " + index);
        }
        assert (this.netNameCount == this.netNames.size());
    }

    void addNetNames(Name name, Export e2, ArcInst ai) {
        if (name.isBus()) {
            System.out.println("Network: Layout " + String.valueOf(this.cell) + " has bus port/arc " + String.valueOf(name));
        }
        this.addNetName(name, e2, ai);
    }

    void addNetName(Name name, Export e2, ArcInst ai) {
        MutableInteger nn = this.netNames.get(name);
        if (nn == null) {
            nn = new MutableInteger(-1);
            this.netNames.put(name, nn);
        }
        if (nn.intValue() < 0) {
            nn.setValue(this.netNameCount++);
        }
    }

    private void internalConnections(int[] netMapN, int[] netMapP, int[] netMapA) {
        Iterator<NodeInst> it = this.cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            int nodeOffset = this.ni_pi[ni.getNodeId()];
            if (!ni.isCellInstance()) {
                PrimitiveNode.Function fun = ni.getFunction();
                if (fun == PrimitiveNode.Function.RESIST) {
                    assert (this.drawns.length > 1);
                    Netlist.connectMap(netMapP, this.drawns[nodeOffset], this.drawns[nodeOffset + 1]);
                    Netlist.connectMap(netMapA, this.drawns[nodeOffset], this.drawns[nodeOffset + 1]);
                    continue;
                }
                if (!fun.isComplexResistor()) continue;
                assert (this.drawns.length > 1);
                Netlist.connectMap(netMapA, this.drawns[nodeOffset], this.drawns[nodeOffset + 1]);
                continue;
            }
            Cell subCell = (Cell)ni.getProto();
            if (subCell.isIcon() || subCell.isSchematic()) continue;
            EquivPorts eq = subCell.tree().getEquivPorts();
            int[] eqN = eq.getEquivPortsN();
            int[] eqP = eq.getEquivPortsP();
            int[] eqA = eq.getEquivPortsA();
            for (int i2 = 0; i2 < eqN.length; ++i2) {
                if (eqN[i2] != i2) {
                    Netlist.connectMap(netMapN, this.drawns[nodeOffset + i2], this.drawns[nodeOffset + eqN[i2]]);
                }
                if (eqP[i2] != i2) {
                    Netlist.connectMap(netMapP, this.drawns[nodeOffset + i2], this.drawns[nodeOffset + eqP[i2]]);
                }
                if (eqA[i2] == i2) continue;
                Netlist.connectMap(netMapA, this.drawns[nodeOffset + i2], this.drawns[nodeOffset + eqA[i2]]);
            }
        }
        Netlist.closureMap(netMapN);
        Netlist.closureMap(netMapP);
        Netlist.closureMap(netMapA);
        if (Job.getDebug()) {
            ImmutableNetLayout immutableNetlist = new ImmutableNetLayout(this.cell.tree());
            assert (Arrays.equals(netMapN, immutableNetlist.getNetMap(Netlist.ShortResistors.NO)));
            assert (Arrays.equals(netMapP, immutableNetlist.getNetMap(Netlist.ShortResistors.PARASITIC)));
            assert (Arrays.equals(netMapA, immutableNetlist.getNetMap(Netlist.ShortResistors.ALL)));
        }
    }

    final int getPortInstOffset(PortInst pi) {
        return this.ni_pi[pi.getNodeInst().getNodeId()] + pi.getPortProto().getPortIndex();
    }

    NetSchem getSchem() {
        return null;
    }

    private void buildNetworkList(int[] netMapN) {
        int i2;
        int drawn;
        ArcInst ai;
        int arcIndex;
        this.netlistN = new NetlistImpl(this, this.numExportedDrawns, netMapN);
        int[] netNameToNetIndex = new int[this.netNames.size()];
        Arrays.fill(netNameToNetIndex, -1);
        int numPorts = this.cell.getNumPorts();
        for (int i3 = 0; i3 < numPorts; ++i3) {
            Export e2 = this.cell.getPort(i3);
            int drawn2 = this.drawns[i3];
            this.setNetName(netNameToNetIndex, drawn2, e2.getNameKey(), true);
            this.netlistN.setEquivPortIndexByNetIndex(i3, this.netlistN.getNetIndex(e2, 0));
        }
        int numArcs = this.cell.getNumArcs();
        Iterator<ArcInst> it = this.cell.getArcs();
        for (arcIndex = 0; arcIndex < numArcs; ++arcIndex) {
            ai = it.next();
            if (!ai.isUsernamed() || (drawn = this.drawns[this.arcsOffset + arcIndex]) < 0) continue;
            this.setNetName(netNameToNetIndex, drawn, ai.getNameKey(), false);
        }
        it = this.cell.getArcs();
        for (arcIndex = 0; arcIndex < numArcs; ++arcIndex) {
            int netIndexN;
            ai = it.next();
            drawn = this.drawns[this.arcsOffset + arcIndex];
            if (drawn < 0 || this.netlistN.hasNames(netIndexN = this.netlistN.getNetIndexByMap(drawn))) continue;
            this.netlistN.addTempName(netIndexN, ai.getName());
        }
        for (i2 = 0; i2 < this.cell.getNumNodes(); ++i2) {
            NodeInst ni = this.cell.getNode(i2);
            int nodeId = ni.getNodeId();
            for (int j2 = 0; j2 < ni.getProto().getNumPorts(); ++j2) {
                int netIndexN;
                int drawn3 = this.drawns[this.ni_pi[nodeId] + j2];
                if (drawn3 < 0 || this.netlistN.hasNames(netIndexN = this.netlistN.getNetIndexByMap(drawn3))) continue;
                this.netlistN.addTempName(netIndexN, ni.getName() + "." + ni.getProto().getPort(j2).getName());
            }
        }
        int numNetworks = this.netlistN.getNumNetworks();
        for (i2 = 0; i2 < numNetworks; ++i2) {
            assert (this.netlistN.hasNames(i2));
            assert (this.netlistN.isExported(i2) == i2 < this.netlistN.getNumExternalNetworks());
            if (!this.netlistN.isExported(i2)) continue;
            int equivPortIndex = this.netlistN.getEquivPortIndexByNetIndex(i2);
            assert (equivPortIndex >= 0 && equivPortIndex < numPorts);
        }
    }

    private void setNetName(int[] netNamesToNetIndex, int drawn, Name name, boolean exported) {
        int netIndexN = this.netlistN.getNetIndexByMap(drawn);
        assert (netIndexN >= 0);
        MutableInteger nn = this.netNames.get(name);
        if (netNamesToNetIndex[nn.intValue()] >= 0) {
            if (netNamesToNetIndex[nn.intValue()] == netIndexN) {
                return;
            }
            String msg = "Network: Layout " + String.valueOf(this.cell) + " has nets with same name " + String.valueOf(name);
            System.out.println(msg);
            int numPorts = this.cell.getNumPorts();
            for (int i2 = 0; i2 < numPorts; ++i2) {
                Export e2 = this.cell.getPort(i2);
                if (!e2.getName().equals(name.toString())) continue;
                this.networkManager.pushHighlight(this.cell.getPort(i2));
            }
            Iterator<ArcInst> it = this.cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                if (!ai.isUsernamed() || !ai.getName().equals(name.toString())) continue;
                this.networkManager.pushHighlight(ai);
            }
            this.networkManager.logError(msg, 0);
        } else {
            netNamesToNetIndex[nn.intValue()] = netIndexN;
        }
        this.netlistN.addUserName(netIndexN, name, exported);
    }

    private boolean updateInterface() {
        boolean changed = false;
        int numPorts = this.cell.getNumPorts();
        if (this.equivPortsN == null || this.equivPortsN.length != numPorts) {
            changed = true;
            this.equivPortsN = new int[numPorts];
            this.equivPortsP = new int[numPorts];
            this.equivPortsA = new int[numPorts];
        }
        int[] netToPortN = new int[numPorts];
        int[] netToPortP = new int[numPorts];
        int[] netToPortA = new int[numPorts];
        Arrays.fill(netToPortN, -1);
        Arrays.fill(netToPortP, -1);
        Arrays.fill(netToPortA, -1);
        for (int i2 = 0; i2 < numPorts; ++i2) {
            int netA;
            int netP;
            int netN = this.netlistN.netMap[this.drawns[i2]];
            if (netToPortN[netN] < 0) {
                netToPortN[netN] = i2;
            }
            if (this.equivPortsN[i2] != netToPortN[netN]) {
                changed = true;
                this.equivPortsN[i2] = netToPortN[netN];
            }
            if (netToPortP[netP = this.netlistP.netMap[this.drawns[i2]]] < 0) {
                netToPortP[netP] = i2;
            }
            if (this.equivPortsP[i2] != netToPortP[netP]) {
                changed = true;
                this.equivPortsP[i2] = netToPortP[netP];
            }
            if (netToPortA[netA = this.netlistA.netMap[this.drawns[i2]]] < 0) {
                netToPortA[netA] = i2;
            }
            if (this.equivPortsA[i2] == netToPortA[netA]) continue;
            changed = true;
            this.equivPortsA[i2] = netToPortA[netA];
        }
        if (Job.getDebug()) {
            EquivPorts equivPorts = this.cell.tree().getEquivPorts();
            assert (Arrays.equals(this.equivPortsN, equivPorts.getEquivPortsN()));
            assert (Arrays.equals(this.equivPortsP, equivPorts.getEquivPortsP()));
            assert (Arrays.equals(this.equivPortsA, equivPorts.getEquivPortsA()));
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLayout() {
        NetworkManager networkManager = this.networkManager;
        synchronized (networkManager) {
            CellTree oldCellTree = (CellTree)this.expectedCellTree.get();
            CellTree newCellTree = this.cell.tree();
            if (oldCellTree == newCellTree) {
                return;
            }
            if (oldCellTree == null || !newCellTree.sameNetlist(oldCellTree)) {
                this.networkManager.startErrorLogging(this.cell);
                try {
                    this.makeDrawns();
                    this.initNetnames();
                    this.redoNetworks1();
                }
                finally {
                    this.networkManager.finishErrorLogging();
                }
            }
            this.expectedCellTree = new WeakReference<CellTree>(newCellTree);
        }
    }

    boolean redoNetworks1() {
        int[] netMapN = Netlist.initMap(this.numDrawns);
        int[] netMapP = (int[])netMapN.clone();
        int[] netMapA = (int[])netMapN.clone();
        this.internalConnections(netMapN, netMapP, netMapA);
        this.buildNetworkList(netMapN);
        this.netlistP = new NetlistShorted(this.netlistN, Netlist.ShortResistors.PARASITIC, netMapP);
        this.netlistA = new NetlistShorted(this.netlistN, Netlist.ShortResistors.ALL, netMapA);
        return this.updateInterface();
    }

    boolean obsolete(Netlist netlist) {
        Netlist newNetlist = this.getNetlist(netlist.shortResistors);
        this.netlistP.expectedCellTree = this.netlistA.expectedCellTree = this.expectedCellTree;
        this.netlistN.expectedCellTree = this.netlistA.expectedCellTree;
        return newNetlist != netlist;
    }
}

