/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.id;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.prototype.PortProto;
import java.io.IOException;
import java.io.Serializable;

public abstract class PortProtoId
implements Serializable {
    public final NodeProtoId parentId;
    public final int chronIndex;
    public final String externalId;

    PortProtoId(NodeProtoId parentId, String externalId, int chronIndex) {
        assert (parentId != null);
        this.parentId = parentId;
        this.chronIndex = chronIndex;
        this.externalId = externalId;
    }

    Object writeReplace() {
        return new PortProtoIdKey(this);
    }

    public NodeProtoId getParentId() {
        return this.parentId;
    }

    public int getChronIndex() {
        return this.chronIndex;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public abstract String getName(Snapshot var1);

    public abstract PortProto inDatabase(EDatabase var1);

    public int hashCode() {
        return this.externalId.hashCode();
    }

    public String toString() {
        return String.valueOf(this.parentId) + ":" + this.externalId;
    }

    void check() {
        assert (this == this.parentId.getPortId(this.chronIndex));
        assert (this.externalId != null);
    }

    private static class PortProtoIdKey
    extends EObjectInputStream.Key<PortProtoId> {
        public PortProtoIdKey() {
        }

        private PortProtoIdKey(PortProtoId portProtoId) {
            super(portProtoId);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, PortProtoId portProtoId) throws IOException {
            out.writeObject(portProtoId.parentId);
            out.writeInt(portProtoId.chronIndex);
        }

        @Override
        public PortProtoId readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            NodeProtoId parentId = (NodeProtoId)in.readObject();
            int chronIndex = in.readInt();
            return parentId.getPortId(chronIndex);
        }
    }
}

