/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.id;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.text.CellName;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class LibId
implements Serializable {
    public static final LibId[] NULL_ARRAY = new LibId[0];
    public final IdManager idManager;
    public final String libName;
    public final int libIndex;
    private final HashMap<CellName, CellId> cellIdsByCellName = new HashMap();

    LibId(IdManager idManager, String libName, int libIndex) {
        if (libName == null) {
            throw new NullPointerException();
        }
        if (LibId.legalLibraryName(libName) != libName) {
            throw new IllegalArgumentException(libName);
        }
        this.idManager = idManager;
        this.libName = libName;
        this.libIndex = libIndex;
    }

    private Object writeReplace() {
        return new LibIdKey(this);
    }

    public CellId newCellId(CellName cellName) {
        return this.idManager.newCellId(this, cellName);
    }

    public Library inDatabase(EDatabase database) {
        return database.getLib(this);
    }

    public String toString() {
        return this.libName;
    }

    CellId getCellId(CellName cellName) {
        return this.cellIdsByCellName.get(cellName);
    }

    void putCellId(CellId cellId) {
        this.cellIdsByCellName.put(cellId.cellName, cellId);
    }

    void check() {
        assert (this == this.idManager.getLibId(this.libIndex));
        assert (this.libName != null && LibId.legalLibraryName(this.libName) == this.libName);
        for (Map.Entry<CellName, CellId> e2 : this.cellIdsByCellName.entrySet()) {
            CellId cellId = e2.getValue();
            assert (cellId.libId == this);
            assert (cellId.cellName == e2.getKey());
            assert (this.idManager.getCellId(cellId.cellIndex) == cellId);
        }
    }

    private static boolean isInvalidLibraryCharacter(char ch) {
        return Character.isWhitespace(ch) || ch == ':' || ch == '/';
    }

    public static String legalLibraryName(String libName) {
        int i2;
        if (libName == null || libName.length() == 0) {
            return null;
        }
        for (i2 = 0; i2 < libName.length() && !LibId.isInvalidLibraryCharacter(libName.charAt(i2)); ++i2) {
        }
        if (i2 == libName.length()) {
            return libName;
        }
        char[] chars = libName.toCharArray();
        while (i2 < libName.length()) {
            int ch = chars[i2];
            chars[i2] = LibId.isInvalidLibraryCharacter((char)ch) ? 45 : ch;
            ++i2;
        }
        return new String(chars);
    }

    private static class LibIdKey
    extends EObjectInputStream.Key<LibId> {
        public LibIdKey() {
        }

        private LibIdKey(LibId libId) {
            super(libId);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, LibId libId) throws IOException {
            if (libId.idManager != out.getIdManager()) {
                throw new NotSerializableException(String.valueOf(libId) + " from other IdManager");
            }
            out.writeInt(libId.libIndex);
        }

        @Override
        public LibId readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            int libIndex = in.readInt();
            return in.getIdManager().getLibId(libIndex);
        }
    }
}

