/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.btree;

import com.sun.electric.database.geometry.btree.BTree;
import com.sun.electric.database.geometry.btree.CachingPageStorage;
import com.sun.electric.database.geometry.btree.unboxed.UnboxedInt;
import java.io.Serializable;

abstract class NodeCursor<K extends Serializable & Comparable, V extends Serializable, S extends Serializable> {
    protected boolean dirty = false;
    protected CachingPageStorage ps;
    protected static final int SIZEOF_INT = 4;
    protected final BTree<K, V, S> bt;
    protected CachingPageStorage.CachedPage cp = null;

    protected NodeCursor(BTree<K, V, S> bt) {
        this.bt = bt;
        this.ps = bt.ps;
    }

    public abstract void initBuf(CachingPageStorage.CachedPage var1, int var2, boolean var3);

    protected abstract void setNumBuckets(int var1);

    public void setBuf(CachingPageStorage.CachedPage cp) {
        assert (!this.dirty);
        this.cp = cp;
    }

    public CachingPageStorage.CachedPage getCachedPage() {
        return this.cp;
    }

    public void forgetCachedPage() {
        this.cp = null;
    }

    public void writeBack() {
        this.dirty = false;
        this.cp.setDirty();
    }

    public int getParent() {
        return UnboxedInt.instance.deserializeInt(this.cp.getBuf(), 0);
    }

    public void setParent(int pageid) {
        this.bt.ui.serializeInt(pageid, this.getBuf(), 0);
    }

    public int split(byte[] key, int key_ofs, int splitPoint) {
        assert (this.isFull());
        int endOfBuf = this.endOfBuf();
        int ret = 0;
        for (int i2 = 0; i2 < splitPoint; ++i2) {
            ret += this.getNumValsBelowBucket(i2);
        }
        this.setNumBuckets(splitPoint);
        boolean wasRightMost = this.isRightMost();
        this.setRightMost(false);
        this.writeBack();
        if (key != null) {
            this.getKey(splitPoint, key, key_ofs);
        }
        byte[] oldbuf = this.cp.getBuf();
        this.initBuf(this.ps.getPage(this.ps.createPage(), false), this.getParent(), wasRightMost);
        this.setNumBuckets(this.getMaxBuckets() - splitPoint);
        this.scoot(oldbuf, endOfBuf, splitPoint);
        this.writeBack();
        return ret;
    }

    public boolean isFull() {
        return this.getNumBuckets() >= this.getMaxBuckets();
    }

    public int getPageId() {
        return this.cp.getPageId();
    }

    public byte[] getBuf() {
        return this.cp.getBuf();
    }

    public abstract int getNumBuckets();

    public abstract int getMaxBuckets();

    public abstract int compare(byte[] var1, int var2, int var3);

    public abstract boolean isLeafNode();

    public int search(byte[] key, int key_ofs) {
        int left = -1;
        int right = this.getNumBuckets();
        while (left + 1 < right) {
            assert (this.compare(key, key_ofs, left) >= 0);
            int i2 = (left + right) / 2;
            int comp = this.compare(key, key_ofs, i2);
            if (comp == 0) {
                return i2;
            }
            if (comp > 0) {
                left = i2;
                continue;
            }
            if (comp >= 0) continue;
            right = i2;
        }
        return left;
    }

    protected abstract int endOfBuf();

    public abstract void getKey(int var1, byte[] var2, int var3);

    protected abstract void scoot(byte[] var1, int var2, int var3);

    public abstract int getNumValsBelowBucket(int var1);

    public abstract void getSummary(int var1, byte[] var2, int var3);

    public abstract void getSummary(byte[] var1, int var2);

    public boolean isRightMost() {
        return this.bt.ui.deserializeInt(this.getBuf(), 4) != 0;
    }

    protected void setRightMost(boolean r) {
        this.bt.ui.serializeInt(r ? 1 : 0, this.getBuf(), 4);
    }
}

