/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.btree;

import com.sun.electric.database.geometry.btree.BTree;
import com.sun.electric.database.geometry.btree.CachingPageStorage;
import com.sun.electric.database.geometry.btree.NodeCursor;
import com.sun.electric.database.geometry.btree.unboxed.UnboxedInt;
import java.io.Serializable;

class LeafNodeCursor<K extends Serializable & Comparable, V extends Serializable, S extends Serializable>
extends NodeCursor<K, V, S> {
    private final int LEAF_HEADER_SIZE;
    private final int LEAF_ENTRY_SIZE;
    private final int LEAF_MAX_BUCKETS;
    private int numbuckets = 0;

    @Override
    public int getMaxBuckets() {
        return this.LEAF_MAX_BUCKETS;
    }

    public LeafNodeCursor(BTree<K, V, S> bt) {
        super(bt);
        this.LEAF_HEADER_SIZE = 24;
        this.LEAF_ENTRY_SIZE = bt.uk.getSize() + bt.uv.getSize();
        this.LEAF_MAX_BUCKETS = (this.ps.getPageSize() - this.LEAF_HEADER_SIZE) / this.LEAF_ENTRY_SIZE;
    }

    public static boolean isLeafNode(CachingPageStorage.CachedPage cp) {
        return UnboxedInt.instance.deserializeInt(cp.getBuf(), 8) == 0;
    }

    @Override
    public void setBuf(CachingPageStorage.CachedPage cp) {
        assert (LeafNodeCursor.isLeafNode(cp));
        super.setBuf(cp);
        this.numbuckets = this.bt.ui.deserializeInt(this.getBuf(), 20);
    }

    @Override
    public void initBuf(CachingPageStorage.CachedPage cp, int parent, boolean isRightMost) {
        super.setBuf(cp);
        this.bt.ui.serializeInt(0, this.getBuf(), 8);
        this.setRightMost(isRightMost);
        this.setNumBuckets(0);
        this.setParent(parent);
    }

    public int getLeftNeighborPageId() {
        return this.bt.ui.deserializeInt(this.getBuf(), 12);
    }

    public int getRightNeighborPageId() {
        return this.bt.ui.deserializeInt(this.getBuf(), 16);
    }

    @Override
    protected void setNumBuckets(int num) {
        this.numbuckets = num;
        this.bt.ui.serializeInt(this.numbuckets, this.getBuf(), 20);
    }

    @Override
    public int getNumBuckets() {
        return this.numbuckets;
    }

    @Override
    public int compare(byte[] key, int key_ofs, int keynum) {
        if (keynum < 0) {
            return 1;
        }
        if (keynum >= this.getNumBuckets()) {
            return -1;
        }
        return this.bt.uk.compare(key, key_ofs, this.getBuf(), this.LEAF_HEADER_SIZE + keynum * this.LEAF_ENTRY_SIZE);
    }

    public V getVal(int bucket) {
        return this.bt.uv.deserialize(this.getBuf(), this.LEAF_HEADER_SIZE + this.bt.uk.getSize() + this.LEAF_ENTRY_SIZE * bucket);
    }

    public V setVal(int bucket, V val) {
        assert (val != null);
        int pos = this.LEAF_HEADER_SIZE + this.bt.uk.getSize() + this.LEAF_ENTRY_SIZE * bucket;
        Object ret = this.bt.uv.deserialize(this.getBuf(), pos);
        this.bt.uv.serialize(val, this.getBuf(), pos);
        this.writeBack();
        return ret;
    }

    public void insertVal(int bucket, byte[] key, int key_ofs, V val) {
        assert (val != null);
        assert (this.getNumBuckets() < this.getMaxBuckets());
        if (bucket < this.getNumBuckets()) {
            System.arraycopy(this.getBuf(), this.LEAF_HEADER_SIZE + this.LEAF_ENTRY_SIZE * bucket, this.getBuf(), this.LEAF_HEADER_SIZE + this.LEAF_ENTRY_SIZE * (bucket + 1), (this.getNumBuckets() - bucket) * this.LEAF_ENTRY_SIZE);
        }
        this.setNumBuckets(this.getNumBuckets() + 1);
        System.arraycopy(key, key_ofs, this.getBuf(), this.LEAF_HEADER_SIZE + this.LEAF_ENTRY_SIZE * bucket, this.bt.uk.getSize());
        this.setVal(bucket, val);
        this.writeBack();
    }

    public void deleteVal(int bucket) {
        assert (bucket < this.getNumBuckets());
        System.arraycopy(this.getBuf(), this.LEAF_HEADER_SIZE + this.LEAF_ENTRY_SIZE * (bucket + 1), this.getBuf(), this.LEAF_HEADER_SIZE + this.LEAF_ENTRY_SIZE * bucket, (this.getNumBuckets() - bucket - 1) * this.LEAF_ENTRY_SIZE);
        this.setNumBuckets(this.getNumBuckets() - 1);
        this.writeBack();
    }

    @Override
    protected void scoot(byte[] oldBuf, int endOfBuf, int splitPoint) {
        int len = this.LEAF_HEADER_SIZE + this.LEAF_ENTRY_SIZE * splitPoint;
        System.arraycopy(oldBuf, len, this.getBuf(), this.LEAF_HEADER_SIZE, endOfBuf - len);
    }

    @Override
    public boolean isLeafNode() {
        return true;
    }

    @Override
    protected int endOfBuf() {
        return this.LEAF_HEADER_SIZE + this.LEAF_ENTRY_SIZE * this.getNumBuckets();
    }

    @Override
    public void getKey(int bucket, byte[] key, int key_ofs) {
        System.arraycopy(this.getBuf(), this.LEAF_HEADER_SIZE + this.LEAF_ENTRY_SIZE * bucket, key, key_ofs, this.bt.uk.getSize());
    }

    @Override
    public int getNumValsBelowBucket(int bucket) {
        return bucket < this.getNumBuckets() ? 1 : 0;
    }

    @Override
    public void getSummary(int bucket, byte[] buf, int ofs) {
        this.bt.summary.call(this.getBuf(), this.LEAF_HEADER_SIZE + this.LEAF_ENTRY_SIZE * bucket, buf, ofs);
    }

    public K getKey(int bucket) {
        return (K)this.bt.uk.deserialize(this.getBuf(), this.LEAF_HEADER_SIZE + this.LEAF_ENTRY_SIZE * bucket);
    }

    @Override
    public void getSummary(byte[] buf, int ofs) {
        byte[] buf2 = new byte[this.bt.summary.getSize()];
        this.getSummary(0, buf, ofs);
        for (int i2 = 1; i2 < this.getNumBuckets(); ++i2) {
            this.getSummary(i2, buf2, 0);
            this.bt.summary.multiply(buf, ofs, buf2, 0, buf, ofs);
        }
    }
}

