/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellRevision;
import com.sun.electric.database.CellUsageInfo;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.ImmutablePortInst;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.Variable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;

class UsageCollector {
    static final TreeMap<Variable.AttrKey, AbstractTextDescriptor.Unit> EMPTY_ATTRIBUTES = new TreeMap();
    private final ImmutableCell d;
    private final HashMap<CellId, CellUsageInfoBuilder> cellIndices = new HashMap(16, 0.5f);
    private final HashSet<TechId> techUsed = new HashSet(16, 0.5f);

    UsageCollector(ImmutableCell d2, ImmutableNodeInst.Iterable nodes, ImmutableArcInst.Iterable arcs, ImmutableExport.Iterable exports) {
        this.d = d2;
        for (ImmutableNodeInst n2 : nodes) {
            if (n2.protoId instanceof CellId) {
                CellUsageInfoBuilder cellCount = this.add((CellId)n2.protoId, true);
                if (cellCount.isIcon) {
                    for (Variable param : n2.getDefinedParams()) {
                        cellCount.addAttribute((Variable.AttrKey)param.getKey(), param.getUnit());
                    }
                    for (int varIndex = 0; varIndex < n2.getNumVariables(); ++varIndex) {
                        Variable.Key varKey = n2.getVar(varIndex).getKey();
                        if (!varKey.isAttribute()) continue;
                        cellCount.addAttribute((Variable.AttrKey)varKey, null);
                    }
                }
            } else {
                this.techUsed.add(((PrimitiveNodeId)n2.protoId).techId);
            }
            for (int chronIndex = 0; chronIndex < n2.ports.length; ++chronIndex) {
                ImmutablePortInst pi = n2.ports[chronIndex];
                if (pi == ImmutablePortInst.EMPTY) continue;
                PortProtoId pp = n2.protoId.getPortId(chronIndex);
                this.add(pp);
            }
        }
        for (ImmutableArcInst a2 : arcs) {
            this.techUsed.add(a2.protoId.techId);
            this.add(a2.tailPortId);
            this.add(a2.headPortId);
        }
        for (ImmutableExport e2 : exports) {
            this.add(e2.originalPortId);
        }
    }

    private void add(PortProtoId portId) {
        if (portId instanceof PrimitivePortId) {
            return;
        }
        ExportId eId = (ExportId)portId;
        this.add((CellId)eId.getParentId(), (boolean)false).usedExports.set(eId.chronIndex);
    }

    private CellUsageInfoBuilder add(CellId cellId, boolean isInstance) {
        CellUsageInfoBuilder cellCount = this.cellIndices.get(cellId);
        if (cellCount == null) {
            cellCount = new CellUsageInfoBuilder(this.d.cellId.getUsageIn(cellId));
            this.cellIndices.put(cellId, cellCount);
        }
        if (isInstance) {
            ++cellCount.instCount;
        }
        return cellCount;
    }

    BitSet getTechUsages(BitSet oldTechUsages) {
        BitSet techUsages = new BitSet();
        techUsages.set(this.d.techId.techIndex);
        for (TechId techId : this.techUsed) {
            techUsages.set(techId.techIndex);
        }
        return UsageCollector.bitSetWith(oldTechUsages, techUsages);
    }

    CellUsageInfo[] getCellUsages(CellUsageInfo[] oldCellUsages) {
        if (this.cellIndices.isEmpty()) {
            return CellRevision.NULL_CELL_USAGE_INFO_ARRAY;
        }
        CellId parentId = this.d.cellId;
        int length = 0;
        for (CellId cellId : this.cellIndices.keySet()) {
            length = Math.max(length, parentId.getUsageIn((CellId)cellId).indexInParent + 1);
        }
        Object[] newCellUsages = new CellUsageInfo[length];
        for (CellId cellId : this.cellIndices.keySet()) {
            CellUsage u = parentId.getUsageIn(cellId);
            int indexInParent = u.indexInParent;
            CellUsageInfoBuilder cellCount = this.cellIndices.get(cellId);
            if (cellCount == null) continue;
            CellUsageInfo oldC = indexInParent < oldCellUsages.length ? oldCellUsages[indexInParent] : null;
            newCellUsages[indexInParent] = cellCount.getCellUsageInfo(oldC);
        }
        return Arrays.equals(newCellUsages, oldCellUsages) ? oldCellUsages : newCellUsages;
    }

    static BitSet bitSetWith(BitSet oldBitSet, BitSet newBitSet) {
        if (newBitSet.isEmpty()) {
            return CellRevision.EMPTY_BITSET;
        }
        return newBitSet.equals(oldBitSet) ? oldBitSet : newBitSet;
    }

    static TreeMap<Variable.AttrKey, AbstractTextDescriptor.Unit> usedAttributesWith(TreeMap<Variable.AttrKey, AbstractTextDescriptor.Unit> oldAttributes, TreeMap<Variable.AttrKey, AbstractTextDescriptor.Unit> newAttributes) {
        if (newAttributes == null) {
            return null;
        }
        if (newAttributes.isEmpty()) {
            return EMPTY_ATTRIBUTES;
        }
        return newAttributes.equals(oldAttributes) ? oldAttributes : newAttributes;
    }

    private static class CellUsageInfoBuilder {
        private final boolean isIcon;
        private int instCount;
        private final BitSet usedExports = new BitSet();
        private final TreeMap<Variable.AttrKey, AbstractTextDescriptor.Unit> usedAttributes;

        private CellUsageInfoBuilder(CellUsage cellUsage) {
            this.isIcon = cellUsage.protoId.isIcon();
            this.usedAttributes = this.isIcon ? new TreeMap() : null;
        }

        private void addAttribute(Variable.AttrKey attrKey, AbstractTextDescriptor.Unit unit) {
            AbstractTextDescriptor.Unit oldUnit = this.usedAttributes.get(attrKey);
            if (oldUnit != null) {
                if (unit != oldUnit) {
                    throw new IllegalArgumentException(String.valueOf(attrKey) + " " + String.valueOf(unit));
                }
            } else {
                this.usedAttributes.put(attrKey, unit);
            }
        }

        private CellUsageInfo getCellUsageInfo(CellUsageInfo oldCellUsageInfo) {
            if (oldCellUsageInfo != null) {
                return oldCellUsageInfo.with(this.instCount, this.usedExports, this.usedAttributes);
            }
            return new CellUsageInfo(this.instCount, this.usedExports, this.usedAttributes);
        }
    }
}

