/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.EquivPorts;
import com.sun.electric.database.EquivalentSchematicExports;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNet;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.Name;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.util.math.MutableInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;

class ImmutableNetSchem
extends ImmutableNet {
    private static final boolean DEBUG = false;
    final Snapshot snapshot;
    private final int[] tailConn;
    private final int[] headConn;
    private final int[] drawns_;
    private final ArrayList<PortInst> stack = new ArrayList();
    private int numDrawns_;
    private int numExportedDrawns_;
    private int numConnectedDrawns_;
    private final HashMap<Name, MutableInteger> netNames = new HashMap();
    private int netNameCount;
    final int[] portOffsets;
    private final int[] drawnOffsets;
    IconInst[] iconInsts;
    private final Name[] drawnNames;
    private final int[] drawnWidths;
    Global.Set globals;
    int[] equivPortsN;
    int[] equivPortsP;
    int[] equivPortsA;
    IdentityHashMap<Name, Global.Set> globalPartitions;
    CellId implementationCellId;
    private IdentityHashMap<IconInst, Set<Global>> iconInstExcludeGlobals;
    int netNamesOffset;

    ImmutableNetSchem(Snapshot snapshot, CellId cellId) {
        super(snapshot.getCellTree(cellId));
        int i2;
        CellId mainSchemId;
        assert (cellId.isIcon() || cellId.isSchematic());
        this.snapshot = snapshot;
        CellId implementationCellId = cellId;
        if (cellId.isIcon() && (mainSchemId = snapshot.getMainSchematics(cellId)) != null) {
            this.getEquivExports(mainSchemId);
            implementationCellId = mainSchemId;
        }
        this.implementationCellId = implementationCellId;
        this.headConn = new int[this.arcsOffset + this.numArcs];
        this.tailConn = new int[this.arcsOffset + this.numArcs];
        this.drawns_ = new int[this.arcsOffset + this.numArcs];
        for (i2 = this.numExports; i2 < this.arcsOffset; ++i2) {
            this.headConn[i2] = i2;
            this.tailConn[i2] = i2;
        }
        for (i2 = 0; i2 < this.numExports; ++i2) {
            int portOffset = i2;
            ImmutableExport export = this.exports.get(i2);
            int orig = this.getPortInstOffset(export.originalNodeId, export.originalPortId);
            this.headConn[portOffset] = this.headConn[orig];
            this.headConn[orig] = portOffset;
            this.tailConn[portOffset] = -1;
        }
        for (int arcIndex = 0; arcIndex < this.numArcs; ++arcIndex) {
            ImmutableArcInst a2 = this.arcs.get(arcIndex);
            int arcOffset = this.arcsOffset + arcIndex;
            int head = this.getPortInstOffset(a2.headNodeId, a2.headPortId);
            this.headConn[arcOffset] = this.headConn[head];
            this.headConn[head] = arcOffset;
            int tail = this.getPortInstOffset(a2.tailNodeId, a2.tailPortId);
            this.tailConn[arcOffset] = this.tailConn[tail];
            this.tailConn[tail] = arcOffset;
        }
        this.makeDrawns();
        this.initNetnames();
        this.portOffsets = new int[this.numExports + 1];
        this.drawnNames = new Name[this.numDrawns_];
        this.drawnWidths = new int[this.numDrawns_];
        this.drawnOffsets = new int[this.numDrawns_];
        this.calcDrawnWidths();
        this.initNodables();
        int mapSize = this.netNamesOffset + this.netNames.size();
        int[] netMapN = ImmutableNetSchem.initMap(mapSize);
        this.localConnections(netMapN);
        int[] netMapP = (int[])netMapN.clone();
        int[] netMapA = (int[])netMapN.clone();
        this.internalConnections(netMapN, netMapP, netMapA);
        ImmutableNetSchem.closureMap(netMapN);
        ImmutableNetSchem.closureMap(netMapP);
        ImmutableNetSchem.closureMap(netMapA);
        this.updateInterface(netMapN, netMapP, netMapA);
    }

    private void addToDrawn1(PortInst pi) {
        ArcProto ap;
        ImmutableArcInst a2;
        int piOffset = pi.getPortInstOffset();
        if (this.drawns_[piOffset] >= 0) {
            return;
        }
        if (pi.portId instanceof PrimitivePortId && this.techPool.getPrimitivePort((PrimitivePortId)pi.portId).isIsolated()) {
            return;
        }
        this.drawns_[piOffset] = this.numDrawns_;
        int k2 = piOffset;
        while (this.headConn[k2] != piOffset) {
            if (this.drawns_[k2 = this.headConn[k2]] >= 0) continue;
            if (k2 < this.arcsOffset) {
                this.drawns_[k2] = this.numDrawns_;
                continue;
            }
            a2 = this.arcs.get(k2 - this.arcsOffset);
            ap = this.techPool.getArcProto(a2.protoId);
            if (ap.getFunction() == ArcProto.Function.NONELEC || pi.portId == this.busPinPortId && ap != this.busArc) continue;
            this.drawns_[k2] = this.numDrawns_;
            PortInst tpi = new PortInst(a2, 0);
            if (tpi.portId == this.busPinPortId && ap != this.busArc) continue;
            this.stack.add(tpi);
        }
        k2 = piOffset;
        while (this.tailConn[k2] != piOffset) {
            if (this.drawns_[k2 = this.tailConn[k2]] >= 0) continue;
            a2 = this.arcs.get(k2 - this.arcsOffset);
            ap = this.techPool.getArcProto(a2.protoId);
            if (ap.getFunction() == ArcProto.Function.NONELEC || pi.portId == this.busPinPortId && ap != this.busArc) continue;
            this.drawns_[k2] = this.numDrawns_;
            PortInst hpi = new PortInst(a2, 1);
            if (hpi.portId == this.busPinPortId && ap != this.busArc) continue;
            this.stack.add(hpi);
        }
    }

    private void addToDrawn(PortInst pi) {
        assert (this.stack.isEmpty());
        this.stack.add(pi);
        while (!this.stack.isEmpty()) {
            pi = this.stack.remove(this.stack.size() - 1);
            PortProtoId ppId = pi.portId;
            int numPorts = this.getNumPorts(ppId.getParentId());
            if (numPorts == 1 || ppId instanceof ExportId) {
                this.addToDrawn1(pi);
                continue;
            }
            PrimitivePort pp = this.techPool.getPrimitivePort((PrimitivePortId)ppId);
            PrimitiveNode pn = pp.getParent();
            int topology = pp.getTopology();
            for (int i2 = 0; i2 < numPorts; ++i2) {
                PrimitivePort pp2 = pn.getPort(i2);
                if (pp2.getTopology() != topology) continue;
                this.addToDrawn1(new PortInst(pi.n.nodeId, pp2.getId()));
            }
        }
    }

    void makeDrawns() {
        int i2;
        Arrays.fill(this.drawns_, -1);
        this.numDrawns_ = 0;
        for (i2 = 0; i2 < this.numExports; ++i2) {
            if (this.drawns_[i2] >= 0) continue;
            this.drawns_[i2] = this.numDrawns_++;
            ImmutableExport export = this.exports.get(i2);
            this.addToDrawn(new PortInst(export));
        }
        this.numExportedDrawns_ = this.numDrawns_;
        for (i2 = 0; i2 < this.numArcs; ++i2) {
            if (this.drawns_[this.arcsOffset + i2] >= 0) continue;
            ImmutableArcInst a2 = this.arcs.get(i2);
            ArcProto ap = this.techPool.getArcProto(a2.protoId);
            if (ap.getFunction() == ArcProto.Function.NONELEC) continue;
            this.drawns_[this.arcsOffset + i2] = this.numDrawns_;
            PortInst hpi = new PortInst(a2, 1);
            if (hpi.portId != this.busPinPortId || ap == this.busArc) {
                this.addToDrawn(hpi);
            }
            PortInst tpi = new PortInst(a2, 0);
            if (tpi.portId != this.busPinPortId || ap == this.busArc) {
                this.addToDrawn(tpi);
            }
            ++this.numDrawns_;
        }
        this.numConnectedDrawns_ = this.numDrawns_;
        for (i2 = 0; i2 < this.numNodes; ++i2) {
            PrimitiveNode pn;
            ImmutableNodeInst n2 = this.nodes.get(i2);
            if (n2.protoId instanceof CellId ? this.isIconOfParent(n2) : (pn = this.techPool.getPrimitiveNode((PrimitiveNodeId)n2.protoId)).getFunction() == PrimitiveNode.Function.ART && pn != Generic.tech().simProbeNode || pn == Artwork.tech().pinNode || pn == Generic.tech().invisiblePinNode) continue;
            int numPortInsts = this.getNumPorts(n2.protoId);
            for (int j2 = 0; j2 < numPortInsts; ++j2) {
                PortInst pi = new PortInst(n2.nodeId, this.getPortIdByIndex(n2.protoId, j2));
                int piOffset = pi.getPortInstOffset();
                if (this.drawns_[piOffset] >= 0 || n2.protoId instanceof PrimitiveNodeId && this.techPool.getPrimitivePort((PrimitivePortId)pi.portId).isIsolated()) continue;
                this.addToDrawn(pi);
                ++this.numDrawns_;
            }
        }
        assert (this.numExportedDrawns == this.numExportedDrawns_);
        assert (this.numConnectedDrawns == this.numConnectedDrawns_);
        assert (this.numDrawns == this.numDrawns_);
        assert (Arrays.equals(this.drawns, this.drawns_));
    }

    private void initNetnames() {
        this.netNameCount = 0;
        for (ImmutableExport e2 : this.exports) {
            this.addNetNames(e2.name);
        }
        for (ImmutableArcInst a2 : this.arcs) {
            ArcProto ap = this.techPool.getArcProto(a2.protoId);
            if (ap.getFunction() == ArcProto.Function.NONELEC) continue;
            assert (!a2.name.isBus() || ap == this.busArc);
            if (!a2.isUsernamed()) continue;
            this.addNetNames(a2.name);
        }
        assert (this.netNameCount == this.netNames.size());
    }

    private void addNetNames(Name name) {
        for (int i2 = 0; i2 < name.busWidth(); ++i2) {
            this.addNetName(name.subname(i2));
        }
    }

    private void addNetName(Name name) {
        MutableInteger nn = this.netNames.get(name);
        if (nn == null) {
            nn = new MutableInteger(-1);
            this.netNames.put(name, nn);
        }
        if (nn.intValue() < 0) {
            nn.setValue(this.netNameCount++);
        }
    }

    void calcDrawnWidths() {
        int arcIndex;
        int oldWidth;
        int i2;
        Arrays.fill(this.drawnNames, null);
        Arrays.fill(this.drawnWidths, -1);
        for (i2 = 0; i2 < this.numExports; ++i2) {
            int drawn = this.drawns_[i2];
            Name name = this.exports.get((int)i2).name;
            int newWidth = name.busWidth();
            oldWidth = this.drawnWidths[drawn];
            if (oldWidth < 0) {
                this.drawnNames[drawn] = name;
                this.drawnWidths[drawn] = newWidth;
                continue;
            }
            if (oldWidth == newWidth) continue;
            this.reportDrawnWidthError(this.drawnNames[drawn].toString(), name.toString());
            if (oldWidth >= newWidth) continue;
            this.drawnNames[drawn] = name;
            this.drawnWidths[drawn] = newWidth;
        }
        for (arcIndex = 0; arcIndex < this.numArcs; ++arcIndex) {
            Name name;
            ImmutableArcInst a2 = this.arcs.get(arcIndex);
            int drawn = this.drawns_[this.arcsOffset + arcIndex];
            if (drawn < 0 || (name = a2.name).isTempname()) continue;
            int newWidth = name.busWidth();
            int oldWidth2 = this.drawnWidths[drawn];
            if (oldWidth2 < 0) {
                this.drawnNames[drawn] = name;
                this.drawnWidths[drawn] = newWidth;
                continue;
            }
            if (oldWidth2 == newWidth) continue;
            this.reportDrawnWidthError(this.drawnNames[drawn].toString(), name.toString());
            if (oldWidth2 >= newWidth) continue;
            this.drawnNames[drawn] = name;
            this.drawnWidths[drawn] = newWidth;
        }
        for (arcIndex = 0; arcIndex < this.numArcs; ++arcIndex) {
            int drawn = this.drawns_[this.arcsOffset + arcIndex];
            if (drawn < 0) continue;
            ImmutableArcInst a3 = this.arcs.get(arcIndex);
            Name name = a3.name;
            if (!name.isTempname() || (oldWidth = this.drawnWidths[drawn]) >= 0) continue;
            this.drawnNames[drawn] = name;
            if (a3.protoId == this.busArc.getId()) continue;
            this.drawnWidths[drawn] = 1;
        }
        for (i2 = 0; i2 < this.numNodes; ++i2) {
            PrimitiveNode pn;
            ImmutableNodeInst n2 = this.nodes.get(i2);
            if (n2.protoId instanceof PrimitiveNodeId && ((pn = this.techPool.getPrimitiveNode((PrimitiveNodeId)n2.protoId)).getFunction().isPin() || pn.getTechnology() == this.schemTech && pn == this.schemTech.offpageNode)) continue;
            int numPortInsts = this.getNumPorts(n2.protoId);
            for (int j2 = 0; j2 < numPortInsts; ++j2) {
                PortInst pi = new PortInst(n2.nodeId, this.getPortIdByIndex(n2.protoId, j2));
                int drawn = this.drawns_[pi.getPortInstOffset()];
                if (drawn < 0) continue;
                int oldWidth3 = this.drawnWidths[drawn];
                int newWidth = 1;
                if (n2.protoId instanceof CellId) {
                    CellBackup subCell = this.snapshot.getCell((CellId)n2.protoId);
                    CellId subCellId = subCell.cellRevision.d.cellId;
                    if (subCellId.isIcon() || subCellId.isSchematic()) {
                        int arraySize = subCellId.isIcon() ? n2.name.busWidth() : 1;
                        int portWidth = subCell.cellRevision.exports.get((int)j2).name.busWidth();
                        if (oldWidth3 == portWidth) continue;
                        newWidth = arraySize * portWidth;
                    }
                }
                if (oldWidth3 < 0) {
                    this.drawnWidths[drawn] = newWidth;
                    continue;
                }
                if (oldWidth3 == newWidth) continue;
                String msg = "Network: Schematic " + String.valueOf(this.cellId) + " has net <" + String.valueOf(this.drawnNames[drawn]) + "> with width conflict in connection " + String.valueOf(pi.n.name) + " " + String.valueOf(pi.portId);
                System.out.println(msg);
            }
        }
        for (i2 = 0; i2 < this.drawnWidths.length; ++i2) {
            if (this.drawnWidths[i2] >= 1) continue;
            this.drawnWidths[i2] = 1;
        }
    }

    private void reportDrawnWidthError(String firstname, String badname) {
        String msg = "Network: Schematic " + String.valueOf(this.cellId) + " has net with conflict width of names <" + firstname + "> and <" + badname + ">";
        System.out.println(msg);
    }

    private void initNodables() {
        int i2;
        Global.Buf globalBuf = new Global.Buf();
        HashMap nodeInstExcludeGlobal = null;
        for (int i3 = 0; i3 < this.numNodes; ++i3) {
            PortCharacteristic characteristic;
            ImmutableNodeInst n2 = this.nodes.get(i3);
            if (n2.protoId instanceof CellId && (((CellId)n2.protoId).isIcon() || ((CellId)n2.protoId).isSchematic())) {
                if (n2.name.hasDuplicates()) {
                    msg = String.valueOf(this.cellId) + ": Node name <" + String.valueOf(n2.name) + "> has duplicate subnames";
                    System.out.println(msg);
                }
            } else if (n2.name.isBus()) {
                msg = String.valueOf(this.cellId) + ": Array name <" + String.valueOf(n2.name) + "> can be assigned only to icon nodes";
                System.out.println(msg);
            }
            if (n2.protoId instanceof CellId) {
                String errorMsg;
                CellId subCellId = (CellId)n2.protoId;
                if (!subCellId.isIcon() && !subCellId.isSchematic() || this.isIconOfParent(n2)) continue;
                EquivalentSchematicExports netEq = this.getEquivExports((CellId)n2.protoId);
                EquivalentSchematicExports schemEq = netEq.implementation;
                assert (schemEq != null && schemEq.getCellId() != this.cellId);
                Global.Set gs = schemEq.getGlobals();
                if (schemEq.implementation.globalPartitions != null) {
                    int numPortInsts = this.getNumPorts(n2.protoId);
                    HashSet<Global> gb = null;
                    for (int j2 = 0; j2 < numPortInsts; ++j2) {
                        PortInst pi = new PortInst(n2.nodeId, this.getPortIdByIndex(n2.protoId, j2));
                        int piOffset = pi.getPortInstOffset();
                        int drawn = this.drawns_[piOffset];
                        if (drawn < 0 || drawn >= this.numConnectedDrawns_) continue;
                        ImmutableExport e2 = netEq.exports.get(j2);
                        assert (e2.exportId == pi.portId);
                        Name busName = e2.name;
                        for (int busIndex = 0; busIndex < busName.busWidth(); ++busIndex) {
                            Name exportName = busName.subname(busIndex);
                            Global.Set globalsOnElement = schemEq.globalPartitions.get(exportName);
                            if (globalsOnElement == null) continue;
                            if (gb == null) {
                                gb = new HashSet<Global>();
                            }
                            for (int l2 = 0; l2 < globalsOnElement.size(); ++l2) {
                                Global g2 = globalsOnElement.get(l2);
                                gb.add(g2);
                            }
                        }
                    }
                    if (gb != null) {
                        if (nodeInstExcludeGlobal == null) {
                            nodeInstExcludeGlobal = new HashMap();
                        }
                        nodeInstExcludeGlobal.put(n2, gb);
                        gs = gs.remove(gb.iterator());
                    }
                }
                if ((errorMsg = globalBuf.addToBuf(gs)) == null) continue;
                String msg = "Network: " + String.valueOf(this.cellId) + " has globals with conflicting characteristic " + errorMsg;
                System.out.println(msg);
                continue;
            }
            Global g3 = this.globalInst(n2);
            if (g3 == null) continue;
            if (g3 == Global.ground) {
                characteristic = PortCharacteristic.GND;
            } else if (g3 == Global.power) {
                characteristic = PortCharacteristic.PWR;
            } else {
                characteristic = PortCharacteristic.findCharacteristic(n2.techBits);
                if (characteristic == null) {
                    String msg = "Network: " + String.valueOf(this.cellId) + " has global " + g3.getName() + " with unknown characteristic bits";
                    System.out.println(msg);
                    characteristic = PortCharacteristic.UNKNOWN;
                }
            }
            String errorMsg = globalBuf.addToBuf(g3, characteristic);
            if (errorMsg == null) continue;
            String msg = "Network: " + String.valueOf(this.cellId) + " has global with conflicting characteristic " + errorMsg;
            System.out.println(msg);
        }
        this.globals = globalBuf.getBuf();
        int mapOffset = this.portOffsets[0] = this.globals.size();
        for (i2 = 1; i2 <= this.numExports; ++i2) {
            ImmutableExport export = this.exports.get(i2 - 1);
            this.portOffsets[i2] = mapOffset += export.name.busWidth();
        }
        this.equivPortsN = new int[mapOffset];
        this.equivPortsP = new int[mapOffset];
        this.equivPortsA = new int[mapOffset];
        for (i2 = 0; i2 < this.numDrawns_; ++i2) {
            this.drawnOffsets[i2] = mapOffset;
            mapOffset += this.drawnWidths[i2];
        }
        this.iconInsts = new IconInst[this.numNodes];
        this.iconInstExcludeGlobals = null;
        for (int nodeIndex = 0; nodeIndex < this.numNodes; ++nodeIndex) {
            Set gs;
            IconInst iconInst;
            CellId subCellId;
            ImmutableNodeInst n3 = this.nodes.get(nodeIndex);
            if (!(n3.protoId instanceof CellId) || !(subCellId = (CellId)n3.protoId).isIcon() && !subCellId.isSchematic()) continue;
            this.iconInsts[nodeIndex] = iconInst = new IconInst(n3, mapOffset);
            if (this.isIconOfParent(n3)) continue;
            EquivalentSchematicExports netEq = iconInst.eq;
            EquivalentSchematicExports schemEq = netEq.implementation;
            assert (schemEq != null);
            Set set = gs = nodeInstExcludeGlobal != null ? (Set)nodeInstExcludeGlobal.get(n3) : null;
            if (gs != null) {
                if (this.iconInstExcludeGlobals == null) {
                    this.iconInstExcludeGlobals = new IdentityHashMap();
                }
                this.iconInstExcludeGlobals.put(iconInst, gs);
            }
            assert (iconInst.numExtendedExports == schemEq.equivPortsN.length);
            mapOffset += iconInst.numExtendedExports * n3.name.busWidth();
        }
        this.netNamesOffset = mapOffset;
    }

    private Global globalInst(ImmutableNodeInst n2) {
        String globalName;
        if (!(n2.protoId instanceof PrimitiveNodeId)) {
            return null;
        }
        PrimitiveNode pn = this.techPool.getPrimitiveNode((PrimitiveNodeId)n2.protoId);
        if (pn.getTechnology() != this.schemTech) {
            return null;
        }
        if (pn == this.schemTech.groundNode) {
            return Global.ground;
        }
        if (pn == this.schemTech.powerNode) {
            return Global.power;
        }
        if (pn == this.schemTech.globalNode && (globalName = (String)n2.getVarValue(Schematics.SCHEM_GLOBAL_NAME, String.class)) != null) {
            return Global.newGlobal(globalName);
        }
        return null;
    }

    private void localConnections(int[] netMap) {
        int k2;
        for (k2 = 0; k2 < this.numExports; ++k2) {
            ImmutableExport e2 = this.exports.get(k2);
            int portOffset = this.portOffsets[k2];
            Name expNm = e2.name;
            int busWidth = expNm.busWidth();
            int drawn = this.drawns_[k2];
            int drawnOffset = this.drawnOffsets[drawn];
            for (int i2 = 0; i2 < busWidth; ++i2) {
                ImmutableNetSchem.connectMap(netMap, portOffset + i2, drawnOffset + (busWidth == this.drawnWidths[drawn] ? i2 : i2 % this.drawnWidths[drawn]));
                MutableInteger nn = this.netNames.get(expNm.subname(i2));
                ImmutableNetSchem.connectMap(netMap, portOffset + i2, this.netNamesOffset + nn.intValue());
            }
        }
        for (k2 = 0; k2 < this.numNodes; ++k2) {
            ImmutableNodeInst n2 = this.nodes.get(k2);
            if (this.isIconOfParent(n2)) continue;
            if (n2.protoId instanceof PrimitiveNodeId) {
                Global g2 = this.globalInst(n2);
                if (g2 != null) {
                    int drawn = this.drawns_[this.ni_pi[this.nodeIndexByNodeId(n2.nodeId)]];
                    ImmutableNetSchem.connectMap(netMap, this.globals.indexOf(g2), this.drawnOffsets[drawn]);
                }
                if (this.schemTech == null || n2.protoId != this.schemTech.wireConNode.getId()) continue;
                this.connectWireCon(netMap, n2);
                continue;
            }
            IconInst iconInst = this.iconInsts[k2];
            if (iconInst == null || iconInst.iconOfParent) continue;
            assert (iconInst.nodeInst == n2);
            CellId subCellId = (CellId)n2.protoId;
            assert (subCellId.isIcon() || subCellId.isSchematic());
            EquivalentSchematicExports iconEq = iconInst.eq;
            EquivalentSchematicExports schemEq = iconEq.implementation;
            assert (schemEq != null);
            Name nodeName = n2.name;
            int arraySize = nodeName.busWidth();
            int numPorts = this.getNumPorts(n2.protoId);
            CellBackup subCell = this.snapshot.getCell(subCellId);
            for (int m2 = 0; m2 < numPorts; ++m2) {
                int width;
                ImmutableExport e3 = subCell.cellRevision.exports.get(m2);
                Name busExportName = e3.name;
                int busWidth = busExportName.busWidth();
                int drawn = this.drawns_[this.ni_pi[this.nodeIndexByNodeId(n2.nodeId)] + m2];
                if (drawn < 0 || (width = this.drawnWidths[drawn]) != busWidth && width != busWidth * arraySize) continue;
                for (int arrayIndex = 0; arrayIndex < arraySize; ++arrayIndex) {
                    int nodeOffset = iconInst.netMapOffset + arrayIndex * iconInst.numExtendedExports;
                    int busOffset = this.drawnOffsets[drawn];
                    if (width != busWidth) {
                        busOffset += busWidth * arrayIndex;
                    }
                    for (int j2 = 0; j2 < busWidth; ++j2) {
                        Name exportName = busExportName.subname(j2);
                        int portOffset = schemEq.getExportNameMapOffset(exportName);
                        if (portOffset < 0) continue;
                        ImmutableNetSchem.connectMap(netMap, busOffset + j2, nodeOffset + portOffset);
                    }
                }
            }
        }
        for (int arcIndex = 0; arcIndex < this.numArcs; ++arcIndex) {
            ImmutableArcInst a2 = this.arcs.get(arcIndex);
            int drawn = this.drawns_[this.arcsOffset + arcIndex];
            if (drawn < 0 || !a2.isUsernamed()) continue;
            int busWidth = this.drawnWidths[drawn];
            Name arcNm = a2.name;
            if (arcNm.busWidth() != busWidth) continue;
            int drawnOffset = this.drawnOffsets[drawn];
            for (int i3 = 0; i3 < busWidth; ++i3) {
                MutableInteger nn = this.netNames.get(arcNm.subname(i3));
                ImmutableNetSchem.connectMap(netMap, drawnOffset + i3, this.netNamesOffset + nn.intValue());
            }
        }
        for (IconInst iconInst : this.iconInsts) {
            if (iconInst == null || iconInst.iconOfParent) continue;
            Set<Global> excludeGlobals = null;
            if (this.iconInstExcludeGlobals != null) {
                excludeGlobals = this.iconInstExcludeGlobals.get(iconInst);
            }
            for (int k3 = 0; k3 < iconInst.nodeInst.name.busWidth(); ++k3) {
                EquivalentSchematicExports eq = iconInst.eq.implementation;
                assert (eq.implementation == eq);
                int numGlobals = eq.portOffsets[0];
                if (numGlobals == 0) continue;
                int nodableOffset = iconInst.netMapOffset + k3 * iconInst.numExtendedExports;
                for (int i4 = 0; i4 < numGlobals; ++i4) {
                    Global g3 = eq.globals.get(i4);
                    if (excludeGlobals != null && excludeGlobals.contains(g3)) continue;
                    ImmutableNetSchem.connectMap(netMap, this.globals.indexOf(g3), nodableOffset + i4);
                }
            }
        }
        ImmutableNetSchem.closureMap(netMap);
    }

    private void connectWireCon(int[] netMap, ImmutableNodeInst n2) {
        ImmutableArcInst a1 = null;
        ImmutableArcInst a2 = null;
        for (ImmutableArcInst a3 : this.cellBackup.cellRevision.getConnectionsOnNode(null, n2)) {
            if (a1 == null) {
                a1 = a3;
                continue;
            }
            if (a2 == null) {
                a2 = a3;
                continue;
            }
            String msg = "Network: Schematic " + String.valueOf(this.cellId) + " has connector " + String.valueOf(n2.name) + " which merges more than two arcs";
            System.out.println(msg);
            return;
        }
        if (a2 == null || a1 == a2) {
            return;
        }
        int large = this.getArcDrawn(a1);
        int small = this.getArcDrawn(a2);
        if (large < 0 || small < 0) {
            return;
        }
        if (this.drawnWidths[small] > this.drawnWidths[large]) {
            int temp = small;
            small = large;
            large = temp;
        }
        for (int i2 = 0; i2 < this.drawnWidths[large]; ++i2) {
            ImmutableNetSchem.connectMap(netMap, this.drawnOffsets[large] + i2, this.drawnOffsets[small] + i2 % this.drawnWidths[small]);
        }
    }

    private void internalConnections(int[] netMapF, int[] netMapP, int[] netMapA) {
        int jA;
        int jP;
        int i2;
        int[] eqA;
        int[] eqP;
        int[] eqN;
        Object eq;
        for (int k2 = 0; k2 < this.numNodes; ++k2) {
            ImmutableNodeInst n2 = this.nodes.get(k2);
            int nodeOffset = this.ni_pi[this.nodeIndexByNodeId(n2.nodeId)];
            if (n2.protoId instanceof PrimitiveNodeId) {
                PrimitiveNode.Function fun = this.getFunction(n2);
                if (fun == PrimitiveNode.Function.RESIST) {
                    ImmutableNetSchem.connectMap(netMapP, this.drawnOffsets[this.drawns_[nodeOffset]], this.drawnOffsets[this.drawns_[nodeOffset + 1]]);
                    ImmutableNetSchem.connectMap(netMapA, this.drawnOffsets[this.drawns_[nodeOffset]], this.drawnOffsets[this.drawns_[nodeOffset + 1]]);
                    continue;
                }
                if (!fun.isComplexResistor()) continue;
                ImmutableNetSchem.connectMap(netMapA, this.drawnOffsets[this.drawns_[nodeOffset]], this.drawnOffsets[this.drawns_[nodeOffset + 1]]);
                continue;
            }
            IconInst iconInst = this.iconInsts[k2];
            if (iconInst != null) continue;
            CellId subCellId = (CellId)n2.protoId;
            assert (!subCellId.isIcon() && !subCellId.isSchematic());
            eq = this.snapshot.getCellTree(subCellId).getEquivPorts();
            eqN = ((EquivPorts)eq).getEquivPortsN();
            eqP = ((EquivPorts)eq).getEquivPortsP();
            eqA = ((EquivPorts)eq).getEquivPortsA();
            int numPorts = ((EquivPorts)eq).getNumExports();
            assert (eqN.length == numPorts && eqP.length == numPorts && eqA.length == numPorts);
            for (i2 = 0; i2 < numPorts; ++i2) {
                int dj;
                int dj2;
                int dj3;
                int di = this.drawns_[nodeOffset + i2];
                if (di < 0) continue;
                int jN = eqN[i2];
                if (i2 != jN && (dj3 = this.drawns_[nodeOffset + jN]) >= 0) {
                    ImmutableNetSchem.connectMap(netMapF, this.drawnOffsets[di], this.drawnOffsets[dj3]);
                }
                if (i2 != (jP = eqP[i2]) && (dj2 = this.drawns_[nodeOffset + jP]) >= 0) {
                    ImmutableNetSchem.connectMap(netMapP, this.drawnOffsets[di], this.drawnOffsets[dj2]);
                }
                if (i2 == (jA = eqA[i2]) || (dj = this.drawns_[nodeOffset + jA]) < 0) continue;
                ImmutableNetSchem.connectMap(netMapA, this.drawnOffsets[di], this.drawnOffsets[dj]);
            }
        }
        for (IconInst iconInst : this.iconInsts) {
            if (iconInst == null || iconInst.iconOfParent) continue;
            for (int k3 = 0; k3 < iconInst.nodeInst.name.busWidth(); ++k3) {
                eq = iconInst.eq.implementation;
                assert (((EquivalentSchematicExports)eq).implementation == eq);
                eqN = ((EquivalentSchematicExports)eq).getEquivPortsN();
                eqP = ((EquivalentSchematicExports)eq).getEquivPortsP();
                eqA = ((EquivalentSchematicExports)eq).getEquivPortsA();
                int nodableOffset = iconInst.netMapOffset + k3 * iconInst.numExtendedExports;
                for (i2 = 0; i2 < eqN.length; ++i2) {
                    int io = nodableOffset + i2;
                    int jF = eqN[i2];
                    if (i2 != jF) {
                        ImmutableNetSchem.connectMap(netMapF, io, nodableOffset + jF);
                    }
                    if (i2 != (jP = eqP[i2])) {
                        ImmutableNetSchem.connectMap(netMapP, io, nodableOffset + jP);
                    }
                    if (i2 == (jA = eqA[i2])) continue;
                    ImmutableNetSchem.connectMap(netMapA, io, nodableOffset + jA);
                }
            }
        }
    }

    private void updateInterface(int[] netMapN, int[] netMapP, int[] netMapA) {
        for (int i2 = 0; i2 < this.equivPortsN.length; ++i2) {
            this.equivPortsN[i2] = netMapN[i2];
            this.equivPortsP[i2] = netMapP[i2];
            this.equivPortsA[i2] = netMapA[i2];
        }
        for (int exportIndex = 0; exportIndex < this.numExports; ++exportIndex) {
            ImmutableExport e2 = this.exports.get(exportIndex);
            if (!this.isGlobalPartition(e2)) continue;
            if (this.globalPartitions == null) {
                this.globalPartitions = new IdentityHashMap();
            }
            int busWidth = e2.name.busWidth();
            for (int k2 = 0; k2 < busWidth; ++k2) {
                Global.Buf globalBuf = null;
                int q = this.equivPortsN[this.portOffsets[exportIndex] + k2];
                for (int l2 = 0; l2 < this.globals.size(); ++l2) {
                    if (this.equivPortsN[l2] != q) continue;
                    Global g2 = this.globals.get(l2);
                    if (globalBuf == null) {
                        globalBuf = new Global.Buf();
                    }
                    globalBuf.addToBuf(g2, this.globals.getCharacteristic(g2));
                }
                if (globalBuf == null) continue;
                Name n2 = e2.name.subname(k2);
                Global.Set globs = this.globalPartitions.get(n2);
                if (globs != null) {
                    globalBuf.addToBuf(globs);
                }
                this.globalPartitions.put(n2, globalBuf.getBuf());
            }
        }
    }

    private boolean isGlobalPartition(ImmutableExport e2) {
        return this.schemTech != null && e2.originalPortId.parentId == this.schemTech.globalPartitionNode.getId();
    }

    public ImmutableExport findExport(CellRevision cell, Name name) {
        int portIndex = cell.exports.searchByName(name.toString());
        if (portIndex >= 0) {
            return cell.exports.get(portIndex);
        }
        return null;
    }

    public PrimitiveNode.Function getFunction(ImmutableNodeInst n2) {
        if (n2.protoId instanceof CellId) {
            return PrimitiveNode.Function.UNKNOWN;
        }
        PrimitiveNode np = this.techPool.getPrimitiveNode((PrimitiveNodeId)n2.protoId);
        return np.getPrimitiveFunction(n2.techBits);
    }

    private EquivalentSchematicExports getEquivExports(CellId cellId) {
        if (!cellId.isIcon() && !cellId.isSchematic()) {
            throw new IllegalArgumentException();
        }
        EquivalentSchematicExports eq = this.snapshot.equivSchemExports[cellId.cellIndex];
        if (eq == null) {
            ImmutableNetSchem netSchem = new ImmutableNetSchem(this.snapshot, cellId);
            this.snapshot.equivSchemExports[cellId.cellIndex] = eq = new EquivalentSchematicExports(netSchem);
        }
        return eq;
    }

    private int getArcDrawn(ImmutableArcInst a2) {
        int arcIndex = this.cellRevision.getArcIndexByArcId(a2.arcId);
        return this.drawns_[this.arcsOffset + arcIndex];
    }

    private int getPortInstOffset(int nodeId, PortProtoId portId) {
        return this.ni_pi[this.nodeIndexByNodeId(nodeId)] + this.getPortIndex(portId);
    }

    private PortProtoId getPortIdByIndex(NodeProtoId nodeProtoId, int portIndex) {
        if (nodeProtoId instanceof CellId) {
            return this.snapshot.getCell((CellId)((CellId)nodeProtoId)).cellRevision.exports.get((int)portIndex).exportId;
        }
        return this.techPool.getPrimitiveNode((PrimitiveNodeId)nodeProtoId).getPort(portIndex).getId();
    }

    private class PortInst {
        private final ImmutableNodeInst n;
        private final int nodeIndex;
        private final PortProtoId portId;
        private final int portIndex;

        private PortInst(int nodeId, PortProtoId portId) {
            this.nodeIndex = ImmutableNetSchem.this.nodeIndexByNodeId(nodeId);
            this.n = ImmutableNetSchem.this.nodes.get(this.nodeIndex);
            this.portId = portId;
            this.portIndex = ImmutableNetSchem.this.getPortIndex(portId);
        }

        private PortInst(ImmutableExport e2) {
            this(e2.originalNodeId, e2.originalPortId);
        }

        private PortInst(ImmutableArcInst a2, int end) {
            this(end != 0 ? a2.headNodeId : a2.tailNodeId, end != 0 ? a2.headPortId : a2.tailPortId);
        }

        private int getPortInstOffset() {
            return ImmutableNetSchem.this.ni_pi[this.nodeIndex] + this.portIndex;
        }
    }

    private class IconInst {
        final ImmutableNodeInst nodeInst;
        final boolean iconOfParent;
        final int netMapOffset;
        final int numExtendedExports;
        final EquivalentSchematicExports eq;

        private IconInst(ImmutableNodeInst n2, int nodeOffset) {
            assert (n2.protoId.isIcon() || n2.protoId.isSchematic());
            this.nodeInst = n2;
            this.iconOfParent = ImmutableNetSchem.this.isIconOfParent(n2);
            this.netMapOffset = nodeOffset;
            this.eq = this.iconOfParent ? null : ImmutableNetSchem.this.getEquivExports((CellId)n2.protoId);
            this.numExtendedExports = this.iconOfParent ? -1000000 : this.eq.implementation.numExpandedExports;
        }
    }
}

